/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.common.scheduler;

import ibase.bi.utility.BIException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScheduleParser {
    HashMap schDetailMap = null;

    static {
        try {
            CommonConstants.setBIHOME();
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
        }
    }

    public void processSchedule(String xmlString, String userName, String schedulerName, String event) throws Exception {
        try {
            BaseLogger.log("3", null, null, "\n\n Processing Scheduler " + schedulerName + "...");
            String userSchfileName = String.valueOf(CommonConstants.getBIHOME()) + File.separator + "resource" + File.separator + userName + File.separator + "Scheduler.xml";
            File userSchFileObj = new File(userSchfileName);
            if (event.equalsIgnoreCase("I")) {
                this.addScheduler(xmlString, userSchFileObj);
            } else if (event.equalsIgnoreCase("U_START") || event.equalsIgnoreCase("U_STOP") || event.equalsIgnoreCase("M")) {
                this.updateScheduler(xmlString, userSchFileObj, schedulerName);
            } else if (event.equalsIgnoreCase("D")) {
                this.removeScheduler(userSchFileObj, schedulerName);
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void addScheduler(String xmlString, File fileObj) throws Exception {
        Document strDoc = this.getDom(xmlString);
        this.setDetails(strDoc);
        Document doc = null;
        Element root = null;
        if (!fileObj.exists()) {
            fileObj.createNewFile();
            this.serializeDom(this.getDom("<ROOT/>"), fileObj);
            doc = this.getDom(fileObj);
        } else {
            doc = this.getDom(fileObj);
        }
        root = doc.getDocumentElement();
        Node newNode = doc.importNode(strDoc.getElementsByTagName("SCHEDULER").item(0), true);
        root.appendChild(newNode);
        this.serializeDom(doc, fileObj);
    }

    private void updateScheduler(String xmlString, File fileObj, String schedulerName) throws Exception {
        Document doc = this.getDom(fileObj);
        Element root = doc.getDocumentElement();
        Document strDoc = this.getDom(xmlString);
        Node schedulerInfo = this.getSchedulerNode(doc, schedulerName);
        NamedNodeMap attList = schedulerInfo.getAttributes();
        NodeList oldChildList = schedulerInfo.getChildNodes();
        NodeList newChildList = strDoc.getElementsByTagName("SCHEDULER").item(0).getChildNodes();
        String newChildName = null;
        String oldChildName = null;
        int i = 0;
        while (i < newChildList.getLength()) {
            if (newChildList.item(i).getNodeType() == 1) {
                newChildName = newChildList.item(i).getNodeName();
                int j = 0;
                while (j < oldChildList.getLength()) {
                    if (oldChildList.item(j).getNodeType() == 1 && newChildName.equals(oldChildName = oldChildList.item(j).getNodeName())) {
                        Node updatedNode = doc.importNode(newChildList.item(i), true);
                        schedulerInfo.replaceChild(updatedNode, oldChildList.item(j));
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.serializeDom(doc, fileObj);
    }

    private void removeScheduler(File fileObj, String schedulerName) throws Exception {
        Document doc = this.getDom(fileObj);
        Element root = doc.getDocumentElement();
        root.removeChild(this.getSchedulerNode(doc, schedulerName));
        this.serializeDom(doc, fileObj);
    }

    private Node getSchedulerNode(Document doc, String schedulerID) throws Exception {
        NodeList schedulerList = doc.getElementsByTagName("SCHEDULER");
        Node schNode = null;
        int l = 0;
        while (l < schedulerList.getLength()) {
            String schName;
            Node schedulerInfo = schedulerList.item(l);
            NamedNodeMap attList = schedulerInfo.getAttributes();
            boolean found = false;
            if (attList.getNamedItem("ID") != null) {
                schName = attList.getNamedItem("ID").getNodeValue();
                if (schName.equals(schedulerID)) {
                    found = true;
                }
            } else if (attList.getNamedItem("id") != null && (schName = attList.getNamedItem("id").getNodeValue()).equals(schedulerID)) {
                found = true;
            }
            if (found) {
                schNode = schedulerInfo;
            }
            ++l;
        }
        return schNode;
    }

    private Document getDom(String xmlString) throws Exception {
        Document strDom = null;
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
        strDom = docBuilder.parse(bais);
        return strDom;
    }

    private Document getDom(File xmlFileObj) throws Exception {
        Document doc = null;
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        doc = docBuilder.parse(xmlFileObj);
        return doc;
    }

    public String getSchedules(String userName, String filterString, String filterType) throws Exception {
        File userSchFileObj;
        block12: {
            String userSchfileName = String.valueOf(CommonConstants.getBIHOME()) + File.separator + "resource" + File.separator + userName + File.separator + "Scheduler.xml";
            userSchFileObj = new File(userSchfileName);
            ArrayList scheduleList = new ArrayList();
            if (userSchFileObj.exists()) break block12;
            return null;
        }
        try {
            Document doc = this.getDom(userSchFileObj);
            ByteArrayOutputStream baos = null;
            StringBuffer xmlStringBuf = new StringBuffer();
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            if (filterType == null) {
                baos = new ByteArrayOutputStream();
                serializer.transform(new DOMSource(doc), new StreamResult(baos));
                xmlStringBuf.append(baos.toString());
            } else if (filterType.equalsIgnoreCase("REPORTNAME")) {
                NodeList schedulerList = doc.getElementsByTagName("SCHEDULER");
                xmlStringBuf.append("<ROOT>");
                int l = 0;
                while (l < schedulerList.getLength()) {
                    baos = new ByteArrayOutputStream();
                    Node schedulerInfo = schedulerList.item(l);
                    NodeList childList = schedulerInfo.getChildNodes();
                    String savedReportName = null;
                    int i = 0;
                    while (i < childList.getLength()) {
                        if (childList.item(i).getNodeName().equals("REPORTNAME")) {
                            savedReportName = childList.item(i).getFirstChild().getNodeValue();
                            break;
                        }
                        ++i;
                    }
                    if (savedReportName != null && savedReportName.equals(filterString)) {
                        serializer.transform(new DOMSource(schedulerInfo), new StreamResult(baos));
                        xmlStringBuf.append(baos.toString());
                    }
                    ++l;
                }
                xmlStringBuf.append("</ROOT>");
            } else if (filterType.equalsIgnoreCase("SCHEDULERID")) {
                baos = new ByteArrayOutputStream();
                xmlStringBuf.append("<ROOT>");
                Node node = this.getSchedulerNode(doc, filterString);
                serializer.transform(new DOMSource(node), new StreamResult(baos));
                xmlStringBuf.append(baos.toString());
                xmlStringBuf.append("</ROOT>");
            }
            return xmlStringBuf.toString();
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void setDetails(Document doc) throws Exception {
        HashMap<String, String> hMap = null;
        BaseLogger.log("2", null, null, "\n\n\n setDetails");
        hMap = new HashMap<String, String>();
        NodeList ndList = doc.getElementsByTagName("SCHEDULER");
        Node schNode = ndList.item(0);
        NodeList childList = schNode.getChildNodes();
        String propName = null;
        String propValue = null;
        int c = 0;
        while (c < childList.getLength()) {
            propName = childList.item(c).getNodeName();
            propValue = childList.item(c).getFirstChild() != null ? childList.item(c).getFirstChild().getNodeValue() : "";
            hMap.put(propName, propValue);
            ++c;
        }
        this.schDetailMap = hMap;
    }

    public HashMap getDetails() throws Exception {
        try {
            return this.schDetailMap;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public HashMap getDetails(String userName, String schedulerName) throws Exception {
        File f;
        block6: {
            String fileName = "";
            fileName = userName.length() != 0 ? String.valueOf(CommonConstants.getBIHOME()) + File.separator + "resource" + File.separator + userName + File.separator + "Scheduler.xml" : String.valueOf(CommonConstants.getBIHOME()) + File.separator + "resource" + File.separator + "common" + File.separator + "xml" + File.separator + "Scheduler" + File.separator + "Scheduler.xml";
            f = new File(fileName);
            if (f.exists()) break block6;
            return null;
        }
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = db.parse(f);
            HashMap<String, String> hMap = new HashMap<String, String>();
            NodeList ndList = doc.getElementsByTagName("NAME");
            int i = 0;
            while (i < ndList.getLength()) {
                Node node = ndList.item(i);
                if (node.getFirstChild().getNodeValue().equals(schedulerName)) {
                    Node parentNode = node.getParentNode();
                    NodeList childList = parentNode.getChildNodes();
                    int c = 0;
                    while (c < childList.getLength()) {
                        hMap.put(childList.item(c).getNodeName(), childList.item(c).getFirstChild() != null ? childList.item(c).getFirstChild().getNodeValue() : "");
                        ++c;
                    }
                }
                ++i;
            }
            return hMap;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void serializeDom(Document source, File target) throws Exception {
        DOMSource domSource = new DOMSource(source);
        StreamResult streamResult = new StreamResult(new FileOutputStream(target));
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer tr = tfactory.newTransformer();
        tr.transform(domSource, streamResult);
    }
}

