/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.MasterBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.servlet.ITMAuthenticateServlet;
import ibase.webitm.utility.ITMException;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RSActions
extends ITMAuthenticateServlet {
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;
    HttpSession session = null;

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doPost(request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String responseStr = "";
        this.session = request.getSession();
        try {
            String objName = request.getParameter("OBJ_NAME");
            String objContext = request.getParameter("OBJ_CONTEXT");
            String editFlag = request.getParameter("EDIT_FLAG");
            String rightsChar = request.getParameter("RIGHTS_CHAR");
            responseStr = this.getActions(objName, objContext, editFlag, rightsChar);
            response.setBufferSize(1024);
            response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
            ServletOutputStream outStream = response.getOutputStream();
            outStream.write(responseStr.getBytes());
            outStream.flush();
            outStream.close();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException : doPost :getActions :==>");
            responseStr = itme.getMessage();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : doPost :getActions :==>");
            e.printStackTrace();
            responseStr = e.getMessage();
        }
    }

    public String getActions(String objName, String objContext, String editFlag) throws Exception, ITMException {
        String retVal = "";
        String titleStr = "";
        String serviceCodeStr = "";
        Object profileID = null;
        StringBuffer titlesBuffer = new StringBuffer();
        StringBuffer serviceCodeBuffer = new StringBuffer();
        try {
            MasterBean masterBean = (MasterBean)this.session.getAttribute(String.valueOf(objName) + "Bean");
            if (masterBean != null) {
                retVal = masterBean.masterRem.getFilteredActions(editFlag, objContext);
            } else {
                AppConnectParm appConnect = new AppConnectParm();
                InitialContext ctx = new InitialContext(appConnect.getProperty());
                BaseLogger.log("3", null, null, "Getting Action String from DBAccessEJB getActionsString()");
                DBAccessEJB ejbObj = new DBAccessEJB();
                UserInfoBean userInfoBean = (UserInfoBean)this.session.getAttribute("USER_INFO");
                if (userInfoBean != null) {
                    retVal = ejbObj.getActionsString(objName, editFlag, objContext, userInfoBean.getProfileId(), userInfoBean.getUserLevel(), userInfoBean.getTransDB());
                }
                ejbObj = null;
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :RSActions :getActions :==>");
            retVal = itme.getMessage();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :RSActions :getActions :==>");
            e.printStackTrace();
            retVal = e.getMessage();
        }
        BaseLogger.log("2", null, null, "RSActions returning Action String :[" + retVal + "]");
        return retVal;
    }

    public String getActions(String objName, String objContext, String editFlag, String rightsChar) throws Exception, ITMException {
        String actionStr = "";
        BaseLogger.log("2", null, null, "Getting Action String for : objName :[" + objName + "] objContext :[" + objContext + "] editFlag :[" + editFlag + "] rightsChar [" + rightsChar + "]");
        String retVal = "";
        String titleStr = "";
        String serviceCodeStr = "";
        Object profileID = null;
        StringBuffer titlesBuffer = new StringBuffer();
        StringBuffer serviceCodeBuffer = new StringBuffer();
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            String nodeStr;
            MasterBean masterBean = (MasterBean)this.session.getAttribute(String.valueOf(objName) + "Bean");
            BaseLogger.log("3", null, null, "RSActions masterBean :[" + masterBean + "]");
            if (masterBean != null) {
                retVal = masterBean.masterRem.getFilteredActions(editFlag, objContext);
            } else {
                AppConnectParm appConnect = new AppConnectParm();
                InitialContext ctx = new InitialContext(appConnect.getProperty());
                BaseLogger.log("3", null, null, "Getting Action String from DBAccessEJB getActionsString()");
                DBAccessEJB ejbObj = new DBAccessEJB();
                UserInfoBean userInfoBean = (UserInfoBean)this.session.getAttribute("USER_INFO");
                if (userInfoBean != null) {
                    retVal = ejbObj.getActionsString(objName, editFlag, objContext, userInfoBean.getProfileId(), userInfoBean.getUserLevel(), userInfoBean.getTransDB());
                }
                ejbObj = null;
            }
            if (rightsChar != null && rightsChar.length() > 0 && (nodeStr = RSActions.searchNode(genericUtility.parseString(retVal), rightsChar)) != null && nodeStr.length() > 0) {
                retVal = "<ACTIONS>" + nodeStr + "</ACTIONS>";
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :RSActions :getActions :==>");
            retVal = itme.getMessage();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :RSActions :getActions :==>");
            e.printStackTrace();
            retVal = e.getMessage();
        }
        BaseLogger.log("2", null, null, "RSActions returning Action String :[" + retVal + "]");
        return retVal;
    }

    private static String searchNode(Document dom, String rightsChar) throws ITMException {
        E12GenericUtility genericUtility = new E12GenericUtility();
        BaseLogger.log("2", null, null, "Searching node from dom :[" + dom + "] rightsChar :[" + rightsChar + "]");
        Node detailNode = null;
        try {
            NodeList detailList = dom.getElementsByTagName("action");
            int detListLength = detailList.getLength();
            int ctr = 0;
            while (ctr < detListLength) {
                Node curDetail = detailList.item(ctr);
                if (curDetail.getAttributes().getNamedItem("id").getNodeValue().equalsIgnoreCase(rightsChar)) {
                    detailNode = curDetail;
                    break;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :searchNode :==>" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        return genericUtility.serializeDom(detailNode);
    }
}

