/*
 * Decompiled with CFR 0.152.
 */
package ibase.system.config;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.File;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AppConnectParm
extends DefaultHandler {
    String moduleName = null;
    boolean readNow = true;
    StringBuffer sbf = new StringBuffer();
    Properties prop = new Properties();

    public AppConnectParm() {
    }

    public AppConnectParm(String moduleName) {
        this.moduleName = moduleName;
    }

    public Properties getProperty() throws Exception {
        String initialContextFactory = CommonConstants.INITIAL_CONTEXT_FACTORY;
        String providerURL = CommonConstants.PROVIDER_URL;
        String urlPKGPrefixes = CommonConstants.URL_PKG_PREFIXES;
        String providerURLDMS = CommonConstants.PROVIDER_URL_DMS;
        if ("DMS".equalsIgnoreCase(this.moduleName) && (providerURLDMS == null || providerURLDMS.trim().length() == 0)) {
            this.parse();
        } else if (initialContextFactory == null || initialContextFactory.trim().length() == 0 || providerURL == null || providerURL.trim().length() == 0 || urlPKGPrefixes == null || urlPKGPrefixes.trim().length() == 0) {
            this.parse();
        } else {
            this.setProperty();
        }
        return this.prop;
    }

    public void parse() throws Exception {
        try {
            String filePath = "";
            filePath = CommonConstants.APPLICATION_CONTEXT != null ? String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "appserver.xml" : String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + "setting" + File.separator + "appserver.xml";
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(filePath, (DefaultHandler)this);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: AppConnectParm: parse: ==>\n" + e);
            throw e;
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String tagName, Attributes atts) throws SAXException {
        try {
            if (tagName.equals("DEFAULT_CONFIG")) {
                this.readNow = true;
            } else if (this.moduleName != null) {
                if (this.moduleName.equalsIgnoreCase("bi") && tagName.equals("BI_CONFIG")) {
                    this.readNow = true;
                } else if (this.moduleName.equalsIgnoreCase("webitm") && tagName.equals("WEBITM_CONFIG")) {
                    this.readNow = true;
                } else if (this.moduleName.equalsIgnoreCase("edi") && tagName.equals("EDI_CONFIG")) {
                    this.readNow = true;
                } else if (this.moduleName.equalsIgnoreCase("etl") && tagName.equals("ETL_CONFIG")) {
                    this.readNow = true;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: AppConnectParm: startElement: ==>\n" + e);
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.readNow) {
            if (qName.equals("INITIAL_CONTEXT_FACTORY")) {
                this.prop.put("java.naming.factory.initial", this.sbf.toString());
                CommonConstants.INITIAL_CONTEXT_FACTORY = this.sbf.toString();
            } else if (qName.equals("PROVIDER_URL")) {
                if (!"DMS".equalsIgnoreCase(this.moduleName) || this.prop.get("java.naming.provider.url") == null) {
                    this.prop.put("java.naming.provider.url", this.sbf.toString());
                    CommonConstants.PROVIDER_URL = this.sbf.toString();
                }
            } else if (qName.equals("URL_PKG_PREFIXES")) {
                this.prop.put("java.naming.factory.url.pkgs", this.sbf.toString());
                CommonConstants.URL_PKG_PREFIXES = this.sbf.toString();
            } else if (qName.equals("PROVIDER_URL_DMS") && "DMS".equalsIgnoreCase(this.moduleName)) {
                this.prop.put("java.naming.provider.url", this.sbf.toString());
                CommonConstants.PROVIDER_URL_DMS = this.sbf.toString();
            }
        }
        if (qName.equals("DEFAULT_CONFIG") || qName.equals("BI_CONFIG") || qName.equals("WEBITM_CONFIG") || qName.equals("EDI_CONFIG") || qName.equals("ETL_CONFIG")) {
            this.readNow = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length1) throws SAXException {
        this.sbf = new StringBuffer().append(ch, start, length1);
    }

    @Override
    public void endDocument() throws SAXException {
    }

    private void setProperty() {
        this.prop.put("java.naming.factory.initial", CommonConstants.INITIAL_CONTEXT_FACTORY);
        if ("DMS".equalsIgnoreCase(this.moduleName)) {
            this.prop.put("java.naming.provider.url", CommonConstants.PROVIDER_URL_DMS);
        } else {
            this.prop.put("java.naming.provider.url", CommonConstants.PROVIDER_URL);
        }
        this.prop.put("java.naming.factory.url.pkgs", CommonConstants.URL_PKG_PREFIXES);
    }
}

