/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectArrayMessage;

public class UserActivityLogger {
    private static Logger logger = null;
    private static URI uri = null;
    private static List<String> fieldNameList = null;

    private static void setURI() {
        try {
            String propFileDir = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "configuration" + File.separator + "UserActivityLogger" + ".properties";
            File propFile = new File(propFileDir);
            if (propFile.exists()) {
                uri = propFile.toURI();
                Properties properties = new Properties();
                properties.load(new FileInputStream(propFile));
                String header = properties.getProperty("appender.csvFile.layout.header");
                fieldNameList = Arrays.asList(header.split(","));
            }
            Object var1_3 = null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void log(HashMap<Integer, ArrayList<String>> completeData, String userId) {
        try {
            if (completeData != null) {
                String userActivityFile = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "log" + File.separator + "UserActivity" + File.separator + UserActivityLogger.getFileName(userId) + ".log";
                UserActivityLogger.configureLogger(userActivityFile);
                for (Map.Entry<Integer, ArrayList<String>> entry : completeData.entrySet()) {
                    ArrayList<String> rowData = entry.getValue();
                    if (rowData == null) continue;
                    Object[] message = rowData.toArray();
                    logger.info((Message)new ObjectArrayMessage(message));
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in userActivitylog :[" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    public static void log(String userId, HashMap<String, HashMap<String, String>> activityActionEventsDetails) {
        try {
            if (activityActionEventsDetails != null) {
                String userActivityFile = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "log" + File.separator + "UserActivity" + File.separator + UserActivityLogger.getFileName(userId) + ".log";
                UserActivityLogger.configureLogger(userActivityFile);
                for (Map.Entry<String, HashMap<String, String>> entry : activityActionEventsDetails.entrySet()) {
                    HashMap<String, String> activityEventMap = entry.getValue();
                    ArrayList<String> logDataList = new ArrayList<String>();
                    for (String fieldName : fieldNameList) {
                        logDataList.add(UserActivityLogger.checkNull(activityEventMap.get(fieldName)));
                    }
                    if (logDataList == null) continue;
                    Object[] message = logDataList.toArray();
                    logger.info((Message)new ObjectArrayMessage(message));
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in userActivitylog :[" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    private static String getFileName(String userId) {
        return String.valueOf(userId) + "_" + new SimpleDateFormat("yyyyMMdd").format(new Date());
    }

    private static void configureLogger(String logFileName) {
        System.setProperty("logFilename", logFileName);
        logger = LogManager.getLogger((String)UserActivityLogger.class.getName());
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        if (uri == null) {
            UserActivityLogger.setURI();
        }
        if (uri != null) {
            context.setConfigLocation(uri);
        }
    }

    private static String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }
}

