/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ArgumentEJB;
import ibase.webitm.ejb.ArgumentRemote;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.PopUpEJB;
import ibase.webitm.utility.ITMException;
import java.util.ArrayList;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ArgumentBean {
    protected InitialContext ctx = null;
    ArgumentEJB argument = null;
    public String objName;
    public String objContext;
    public String pContext;
    public ArrayList argFieldNameList = null;
    public ArrayList argDisplayNameList = new ArrayList();
    public ArrayList argTypeList = new ArrayList();
    public ArrayList physicalNameList = new ArrayList();
    public ArrayList displayNameList = new ArrayList();
    public ArrayList defaultValueList = null;
    private ArrayList userFilterTypeList = null;
    public String periodCode = "";
    public String dispDateFormat = "";
    public String userInfo;

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    public String getUserInfo(String userInfo) {
        return this.userInfo;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public String getObjName() {
        return this.objName;
    }

    public void setObjContext(String objContext) {
        this.objContext = objContext;
    }

    public String getObjContext() {
        return this.objContext;
    }

    public void setPContext(String pContext) {
        this.pContext = pContext;
    }

    public String getPContext() {
        return this.pContext;
    }

    public ArrayList getArgFieldNameList() {
        return this.argFieldNameList;
    }

    public ArrayList getArgDisplayNameList() {
        return this.argDisplayNameList;
    }

    public ArrayList getArgTypeList() {
        return this.argTypeList;
    }

    public ArrayList getPhysicalNameList() {
        return this.physicalNameList;
    }

    public ArrayList getValueList() {
        return this.defaultValueList;
    }

    public ArrayList getDisplayNameList() {
        return this.displayNameList;
    }

    public String getDispDateFormat() {
        return this.dispDateFormat;
    }

    public ArrayList getUserFilterTypeList() {
        return this.userFilterTypeList;
    }

    private InitialContext getInitialContext() throws ITMException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :ArgumentBean :getInitialContext :");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ArgumentBean :getInitialContext :");
            throw new ITMException(e);
        }
        return ctx;
    }

    private ArgumentRemote getArgument() throws ITMException {
        try {
            if (this.argument == null) {
                if (this.ctx == null) {
                    this.ctx = this.getInitialContext();
                }
                this.argument = new ArgumentEJB();
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :ArgumentBean :getArgument :==>\n" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ArgumentBean :getArgument :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return this.argument;
    }

    public String getArguments() throws ITMException {
        String argXMLStr = "";
        try {
            argXMLStr = this.getArgument().getArguments(this.objName);
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :ArgumentBean :getArguments :==>In getting argument XML String\n" + itme);
            argXMLStr = null;
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ArgumentBean :getArguments :==>In getting argument XML String\n" + e);
            argXMLStr = null;
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "[ArgumentBean]argXMLStr :\n" + argXMLStr);
        return argXMLStr;
    }

    public ArrayList getPerioInfoList() throws ITMException {
        ArrayList periodInfoList = null;
        try {
            periodInfoList = new ArrayList();
            UserInfoBean userInfo = new UserInfoBean(this.userInfo);
            String transDB = userInfo.getTransDB();
            String periodInfoXML = this.getArgument().getPeriodInfo(userInfo);
            ArrayList<String> periodCodeList = new ArrayList<String>();
            ArrayList<String> fromDateList = new ArrayList<String>();
            ArrayList<String> toDateList = new ArrayList<String>();
            E12GenericUtility genericUtility = new E12GenericUtility();
            Document doc = genericUtility.parseString(periodInfoXML);
            this.periodCode = doc.getElementsByTagName("DEFAULT_CODE").item(0).getFirstChild().getNodeValue();
            NodeList periodNodeList = doc.getElementsByTagName("PERIOD");
            int periodNodeListLength = periodNodeList.getLength();
            int ctr = 0;
            while (ctr < periodNodeListLength) {
                Node periodNode = periodNodeList.item(ctr);
                NodeList periodList = periodNode.getChildNodes();
                int dCtr = 0;
                while (dCtr < periodList.getLength()) {
                    Node currChild = periodList.item(dCtr);
                    if (currChild.getNodeName().equalsIgnoreCase("CODE")) {
                        periodCodeList.add(currChild.getFirstChild().getNodeValue());
                    } else if (currChild.getNodeName().equalsIgnoreCase("FR_DATE")) {
                        String currFromDateString = genericUtility.getValidDateString(currChild.getFirstChild().getNodeValue(), genericUtility.getApplDateFormat(), genericUtility.getDispDateFormat());
                        fromDateList.add(currFromDateString);
                    } else if (currChild.getNodeName().equalsIgnoreCase("TO_DATE")) {
                        String currToDateString = genericUtility.getValidDateString(currChild.getFirstChild().getNodeValue(), genericUtility.getApplDateFormat(), genericUtility.getDispDateFormat());
                        toDateList.add(currToDateString);
                    }
                    ++dCtr;
                }
                ++ctr;
            }
            periodInfoList.add(periodCodeList);
            periodInfoList.add(fromDateList);
            periodInfoList.add(toDateList);
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :ArgumentBean :getPerioInfoMap :==>\n" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ArgumentBean :getPerioInfoMap :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return periodInfoList;
    }

    public String getPrdCode() throws ITMException {
        String prdCode = "";
        String name = "";
        String type = "";
        try {
            String argXMLStr = this.getArgument().getArguments(this.objName);
            E12GenericUtility genericUtility = new E12GenericUtility();
            Document doc = genericUtility.parseString(argXMLStr);
            NodeList nlFormAlarg = doc.getElementsByTagName("FORMALARG");
            int iTot = 0;
            while (iTot < nlFormAlarg.getLength()) {
                Node ndFormAlarg = nlFormAlarg.item(iTot);
                name = ndFormAlarg.getAttributes().getNamedItem("name").getNodeValue();
                type = ndFormAlarg.getAttributes().getNamedItem("javatype").getNodeValue();
                prdCode = type.equalsIgnoreCase("datetime") || type.equalsIgnoreCase("date") ? this.periodCode : "";
                ++iTot;
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :ArgumentBean :getPrdCode :==>\n" + itme);
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ArgumentBean :getPrdCode :==>\n" + e);
            throw new ITMException(e);
        }
        return prdCode;
    }

    public void createXmlVals(String xmlStr) throws ITMException {
        String fieldName = null;
        String name = null;
        String type = null;
        ArrayList<String> lFieldNameList = new ArrayList<String>();
        ArrayList<String> lNameList = new ArrayList<String>();
        ArrayList<String> lTypeList = new ArrayList<String>();
        ArrayList<String> lValueList = new ArrayList<String>();
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            Document doc = genericUtility.parseString(xmlStr);
            NodeList nlFormAlarg = doc.getElementsByTagName("FORMALARG");
            int size = nlFormAlarg.getLength();
            int iTot = 0;
            while (iTot < size) {
                Node ndFormAlarg = nlFormAlarg.item(iTot);
                fieldName = ndFormAlarg.getAttributes().getNamedItem("field_name").getNodeValue();
                name = ndFormAlarg.getAttributes().getNamedItem("name").getNodeValue();
                type = ndFormAlarg.getAttributes().getNamedItem("javatype").getNodeValue();
                if (type.equalsIgnoreCase("datetime") || type.equalsIgnoreCase("date")) {
                    this.dispDateFormat = genericUtility.getDispDateFormat();
                }
                lFieldNameList.add(fieldName);
                lNameList.add(name);
                lTypeList.add(type);
                Node valueNode = ndFormAlarg.getFirstChild();
                if (valueNode != null && valueNode.getFirstChild() != null) {
                    lValueList.add(valueNode.getFirstChild().getNodeValue());
                } else {
                    lValueList.add("");
                }
                ++iTot;
            }
            this.argFieldNameList = lFieldNameList;
            this.argDisplayNameList = lNameList;
            this.argTypeList = lTypeList;
            this.defaultValueList = lValueList;
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :ArgumentBean :getXmlVals :==>\n" + itme);
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ArgumentBean :getXmlVals :==>\n" + e);
            throw new ITMException(e);
        }
    }

    public void setColumnsInfo() throws ITMException {
        String sPhyName = null;
        String sDispName = null;
        String allNamesStr = null;
        ArrayList<String> lPhyNameList = new ArrayList<String>();
        ArrayList<String> lDispNameList = new ArrayList<String>();
        String type = null;
        ArrayList<String> colNameTypeList = new ArrayList<String>();
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            allNamesStr = this.getArgument().getColumnsInfo(this.objName);
            Document doc = genericUtility.parseString("<Root>" + allNamesStr + "</Root>");
            NodeList nlColInfo = doc.getElementsByTagName("COLINFO");
            int size = nlColInfo.getLength();
            int i = 0;
            while (i < size) {
                Node ndColInfo = nlColInfo.item(i);
                sPhyName = ndColInfo.getAttributes().getNamedItem("physicalName").getNodeValue();
                sDispName = ndColInfo.getAttributes().getNamedItem("displayName").getNodeValue();
                type = ndColInfo.getAttributes().getNamedItem("type").getNodeValue();
                lPhyNameList.add(sPhyName);
                lDispNameList.add(sDispName);
                colNameTypeList.add(type);
                ++i;
            }
            this.physicalNameList = lPhyNameList;
            this.displayNameList = lDispNameList;
            this.userFilterTypeList = colNameTypeList;
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :ArgumentBean :setColumnsInfo :==>\n" + itme.toString());
            throw itme;
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "Exception :ArgumentBean :setColumnsInfo :==>\n" + ex.toString());
            throw new ITMException(ex);
        }
    }

    public String getAccFilt(String objName, String profileID, UserInfoBean userInfo) throws ITMException {
        String accFilt = null;
        try {
            DBAccessEJB dbAccess = new DBAccessEJB();
            accFilt = dbAccess.getAccFilt(objName, profileID, userInfo);
            dbAccess = null;
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException :ArgumentBean :getAccFilt :==>\n" + itme.toString());
            throw itme;
        }
        catch (Exception ex) {
            BaseLogger.log("0", userInfo, null, "Exception :ArgumentBean :getAccFilt :==>\n" + ex.toString());
            throw new ITMException(ex);
        }
        return accFilt;
    }

    public String getFieldPopUpXML(String fieldName, String modName, String pageContext, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("2", null, null, "[ArgumentBean]Getting PopUp XML string for pageContext :" + pageContext + ": fieldName :" + fieldName + ": modName :" + modName + ":");
        String popUpInfoString = "";
        try {
            if (this.ctx == null) {
                this.ctx = this.getInitialContext();
            }
            BaseLogger.log("3", null, null, "[ArgumentBean]Looking Up for PopUp EJB ......");
            PopUpEJB popUp = new PopUpEJB();
            int pgContext = Integer.parseInt(pageContext);
            BaseLogger.log("3", null, null, "[ArgumentBean]Calling PopupEJB's createPopUpList() method--->");
            popUp.createPopUpList(userInfo);
            BaseLogger.log("3", null, null, "[ArgumentBean]Calling PopupEJB's getFieldPopUpString() method--->");
            popUpInfoString = popUp.getFieldPopUpString(fieldName, modName, pgContext);
            popUp = null;
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :ArgumentBean :getFieldPopUpXML :==>\n" + itme.getMessage());
            popUpInfoString = null;
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ArgumentBean :getFieldPopUpXML :==>\n" + e.getMessage());
            popUpInfoString = null;
            throw new ITMException(e);
        }
        return popUpInfoString;
    }

    public String getWinName(UserInfoBean userInfo) throws ITMException {
        String windowName = "";
        try {
            windowName = this.getArgument().getWinName(this.objName, userInfo);
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException :ArgumentBean :getWinName :==>In getting getWinName XML String\n" + itme);
            windowName = null;
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :ArgumentBean :getWinName :==>In getting getWinName XML String\n" + e);
            windowName = null;
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "[ArgumentBean]argXMLStr :\n" + windowName);
        return windowName;
    }

    public String getArguments(UserInfoBean userInfo) throws ITMException {
        String transDB = userInfo.getTransDB();
        String argXMLStr = "";
        BaseLogger.log("2", userInfo, null, "transDB in getArguments(UserInfoBean userInfo) " + transDB);
        try {
            argXMLStr = transDB != null && transDB.trim().length() > 0 ? this.getArgument().getArguments(this.objName, userInfo) : this.getArgument().getArguments(this.objName);
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException :ArgumentBean :getArguments :==>In getting argument XML String\n" + itme);
            argXMLStr = null;
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :ArgumentBean :getArguments :==>In getting argument XML String\n" + e);
            argXMLStr = null;
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "[ArgumentBean]argXMLStr :\n" + argXMLStr);
        return argXMLStr;
    }
}

