/*
 * Decompiled with CFR 0.152.
 */
package ibase.communication.telegram;

import org.json.JSONArray;
import org.json.JSONObject;

public class TelegramUpdateParser {
    public static FileInfo parseUpdate(String jsonString) {
        JSONObject jsonObject = new JSONObject(jsonString);
        JSONObject message = jsonObject.getJSONObject("message");
        String fileName = "";
        String fileId = "";
        String fileMimeType = "";
        if (message.has("audio")) {
            JSONObject audio = message.getJSONObject("audio");
            fileName = audio.optString("file_name", "");
            fileId = audio.getString("file_id");
            fileMimeType = audio.getString("mime_type");
        } else if (message.has("voice")) {
            JSONObject voice = message.getJSONObject("voice");
            fileId = voice.getString("file_id");
            fileMimeType = voice.getString("mime_type");
            fileName = "voice.ogg";
        } else if (message.has("video")) {
            JSONObject video = message.getJSONObject("video");
            fileName = video.optString("file_name", "");
            fileId = video.getString("file_id");
            fileMimeType = video.getString("mime_type");
        } else if (message.has("photo")) {
            JSONArray photoArray = message.getJSONArray("photo");
            JSONObject photo = photoArray.getJSONObject(photoArray.length() - 1);
            fileId = photo.getString("file_id");
            fileMimeType = "image/jpeg";
            fileName = "photo.jpg";
        }
        if (fileName.isEmpty()) {
            long chatId = message.getJSONObject("chat").getLong("id");
            fileName = String.valueOf(chatId) + "_file";
        }
        return new FileInfo(fileName, fileId, fileMimeType);
    }

    public static class FileInfo {
        private String fileName;
        private String fileId;
        private String fileMimeType;

        public FileInfo(String fileName, String fileId, String fileMimeType) {
            this.fileName = fileName;
            this.fileId = fileId;
            this.fileMimeType = fileMimeType;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFileId() {
            return this.fileId;
        }

        public String getFileMimeType() {
            return this.fileMimeType;
        }
    }
}

