package ibase.webService.createDataModel;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetSiteDetails extends ValidatorEJB {
	
	public String getSiteDetails(String inputData,String xtraParams) {
		try {
			
			BaseLogger.log("3", null,  null, " Inside getSiteDetails()==> Method::");			

			BaseLogger.log("3", null,  null, "GetSiteDetails.getSiteDetails() xtraParam:::" + xtraParams );			
			UserInfoBean userInfo = super.getUserInfo();
			
    		DBAccessEJB dbAccess = new DBAccessEJB();
    		String loginCode = userInfo.getLoginCode().trim();
    		String applName="";
    		String profileId = userInfo.getProfileId().trim();
    		String userLevel = userInfo.getUserLevel().trim();
    		String finEntity= userInfo.getFin_entity().trim();
    		String TransDB =userInfo.getTransDB().trim();
    		boolean isMobile = false;
    		
    		String signFavData = dbAccess.getSiteCodeDetails(loginCode, profileId, userLevel, finEntity,TransDB);
    		BaseLogger.log("3", null,  null, "WorkflowDataModelComp.getFavoriteMenu() signFavData= "+signFavData);
    		// call method
    	   String signFavDataJson=	getSiteCodeDetailsJson(loginCode,profileId,userLevel,finEntity,TransDB);
   		   BaseLogger.log("3", null,  null, "WorkflowDataModelComp.getFavoriteMenu() signFavData= "+signFavDataJson);

    		return "";
		} 
		catch (Exception e) 
		{
			BaseLogger.log("0", null,  null, "GetSiteDetails.getFavoriteMenu() Exception:::" + e.getMessage() );
			return "Error:"+e.getMessage();
		}		
	} 
	
	public String getSiteCodeDetailsJson(String loginUserId, String userLevel, String profileId, String transDB, String fin_entity) throws ITMException, JSONException
	{
		BaseLogger.log("3", null,  null, " Inside getSiteCodeDetailsJson() Method::");			

		
	    BaseLogger.log("2", null, null, "get SiteCode Details loginUserId[" + loginUserId + "]");
	    BaseLogger.log("2", null, null, "get SiteCode Details userLevel[" + userLevel + "]");
	    BaseLogger.log("2", null, null, "get SiteCode Details profileId[" + profileId + "]");
	    BaseLogger.log("2", null, null, "get SiteCode Details transDB[" + transDB + "]");
	    BaseLogger.log("2", null, null, "get SiteCode Details fin_entity[" + fin_entity + "]");

	    DBAccessEJB dbAccessEJB = new DBAccessEJB();

	    JSONObject jsonObject = new JSONObject();
	    JSONArray userSiteArray = new JSONArray();

	    String siteCode = "";
	    String city = "";
	    String siteDescription = "";
	    String finEntity = "";
	    String facilityCode = "";
	    String profileIdValue = "";

	    ConnDriver connDriver = new ConnDriver();
	    Connection conn = null;
	    PreparedStatement pStmt = null;
	    ResultSet rs = null;

	    try {
	        conn = connDriver.getConnectDB(transDB);
	        String sql = null;

	        String enterprise = dbAccessEJB.getDBColumnValue("USERS", "ENTERPRISE", "CODE = '" + loginUserId + "'");
	        BaseLogger.log("3", null, null, "get SiteCode Details enterprise[" + enterprise + "]");

	        if ("2".equalsIgnoreCase(userLevel)) {
	            sql = "SELECT * FROM USER_SITE WHERE USER_ID = ?";
	            pStmt = conn.prepareStatement(sql);
	            pStmt.setString(1, loginUserId);
	        } else if (("0".equalsIgnoreCase(userLevel) || "1".equalsIgnoreCase(userLevel)) && (E12GenericUtility.checkNull(enterprise).length() > 0)) {
	            sql = "SELECT SITE.SITE_CODE,SITE.CITY,SITE.DESCR,SITE.FIN_ENTITY,FACILITY_CODE," +
	                    "(CASE WHEN SITE.FIN_ENTITY='" + fin_entity + "'" + "THEN 1 ELSE 2 END) AS SRNO " +
	                    "FROM SITE WHERE SITE.ENTERPRISE = ?" + " ORDER BY SRNO,CITY,FIN_ENTITY";
	            pStmt = conn.prepareStatement(sql);
	            pStmt.setString(1, enterprise);
	        } else {
	            sql = "SELECT SITE.SITE_CODE,SITE.CITY,SITE.DESCR,SITE.FIN_ENTITY,FACILITY_CODE," +
	                    "(CASE WHEN SITE.FIN_ENTITY='" + fin_entity + "'" + "THEN 1 ELSE 2 END) AS SRNO " +
	                    "FROM SITE" + " ORDER BY SRNO,CITY,FIN_ENTITY";
	            pStmt = conn.prepareStatement(sql);
	        }

	        BaseLogger.log("3", null, null, "Sql getSiteCodeDetails[" + sql + "]");
	        rs = pStmt.executeQuery();
	        ResultSetMetaData rsmd = rs.getMetaData();
	        int colCount = rsmd.getColumnCount();
	        BaseLogger.log("3", null, null, "no of column : " + colCount);

	        if (rs.next()) {
	            do {
	                JSONObject userSiteObject = new JSONObject();
	                for (int colNo = 1; colNo <= colCount; colNo++) {
	                    String colName = E12GenericUtility.checkNull(rsmd.getColumnName(colNo)).toUpperCase();
	                    String colValue = E12GenericUtility.checkNull(rs.getString(colNo));

	                    if ("SITE_CODE".equalsIgnoreCase(colName)) {
	                        siteCode = colValue;
	                    } else if ("CITY".equalsIgnoreCase(colName)) {
	                        city = colValue;
	                    } else if ("DESCR".equalsIgnoreCase(colName)) {
	                        siteDescription = colValue;
	                    } else if ("FIN_ENTITY".equalsIgnoreCase(colName)) {
	                        finEntity = colValue;
	                    } else if ("FACILITY_CODE".equalsIgnoreCase(colName)) {
	                        facilityCode = colValue;
	                    } else if ("PROFILE_ID".equalsIgnoreCase(colName)) {
	                        profileIdValue = colValue;
	                    }

	                    userSiteObject.put(colName, colValue);
	                }

	                userSiteObject.put("CITY", city);
	                userSiteObject.put("SITE_DESCR", siteDescription);
	                userSiteObject.put("FIN_ENTITY", finEntity);
	                userSiteObject.put("FACILITY_CODE", facilityCode);
	                userSiteObject.put("PROFILE_ID", profileIdValue);

	                userSiteArray.put(buildOptionArrayForSiteCodeJSON(
	                        E12GenericUtility.checkNull(siteCode),
	                        E12GenericUtility.checkNull(city),
	                        E12GenericUtility.checkNull(siteDescription),
	                        E12GenericUtility.checkNull(finEntity),
	                        E12GenericUtility.checkNull(facilityCode),
	                        E12GenericUtility.checkNull(profileIdValue)
	                ));
	            } while (rs.next());
	        }

	    } catch (Exception e) {
	        BaseLogger.log("0", null, null, "Exception in getSiteCodeDetails [" + e.getMessage() + "]");
	        e.printStackTrace();
	    } finally {
	        try {
	            // Close resources: rs, pStmt, conn
	            if (rs != null) {
	                rs.close();
	            }
	            if (pStmt != null) {
	                pStmt.close();
	            }
	            if (conn != null && !conn.isClosed()) {
	                conn.close();
	            }
	        } catch (Exception e) {
	            BaseLogger.log("0", null, null, "Exception : DBAccessEJB : getSiteCodeDetails()" + e.getMessage());
	            throw new ITMException(e);
	        }
	    }

	    jsonObject.put("user_sites", userSiteArray);

	    BaseLogger.log("2", null, null, "Returning Site Code Details [" + jsonObject.toString() + "]");
	    return jsonObject.toString();
	}
	private static JSONObject buildOptionArrayForSiteCodeJSON(String siteCode, String city, String siteDescription, 
	        String finEntity, String facilityCode, String profileIdValue) throws JSONException {

	    JSONObject siteCodeObject = new JSONObject();

	    siteCodeObject.put("site_code", siteCode);
	    siteCodeObject.put("city", city);
	    siteCodeObject.put("site_description", siteDescription);
	    siteCodeObject.put("fin_entity", finEntity);
	    siteCodeObject.put("facility_code", facilityCode);
	    siteCodeObject.put("profile_id", profileIdValue);

	    return siteCodeObject;
	}

	


}
