/*
c    Window Name : W_file_to_batch_load
 */
package ibase.webitm.ejb; 
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
// added for ejb3
import org.xml.sax.InputSource;

import ibase.sessionnotification.ClientWebsocketNotification;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.system.config.nosql.NoSQLConnDriver;
import ibase.system.config.resource.NoSQLConnection;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.CommonConstants.WebSocketMessageType;
import ibase.utility.E12GenericUtility;
import ibase.utility.MongoDBHandler;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.ITMTransactionEditorBean;
import ibase.webitm.utility.Column;
//import ibase.webitm.bean.TemplateDetails;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.MetaDataObject;
import ibase.webitm.utility.UploadThread;

@Stateless // added for ejb3

//Changed By Mahesh Patidar on 03-SEP-13 [to resolved issue after pass connection in processRequest() in MasterStateFulEJB]
//public class MasterApplyEJB  implements  MasterApplyEJBLocal , MasterApplyEJBRemote // SessionBean
//Changed by Prasad on 02/11/16 [to resove issue of dbId and data mismatch]
//public class MasterApplyEJB extends MasterStatefulEJB implements  MasterApplyEJBLocal , MasterApplyEJBRemote
public class MasterApplyEJB implements MasterApplyEJBLocal, MasterApplyEJBRemote 
{
	//SHAMIM not required	Connection conn = null;
	//boolean isError = false;
	//	String errMsg= "";
	//SessionContext cSessionContext;
	
	// Added by Gagan B. [START]
	private String runMode = ""; 

	public String getRunMode() {
		return runMode;
	}

	public void setRunMode(String runMode) {
		this.runMode = runMode;
	}
	// Added by Gagan B. [END]

	private E12GenericUtility genericUtility = new E12GenericUtility();
	private String userId = "";
	private String logInSite = "";
	private int tran_sl = 0;
	private String win_name= "";
	private String batch_id = "";
	//Added by Prasad on 02/11/16
	private String objName = "";
	//Added by Prasad on 28/12/16 [changes for update detail only which contains in excel file] START
	private ArrayList objFormsDetailList = null;
	private String COLUMN_SEPARATOR = ":";
	private HashMap<String, String> formWisePkFldNameMap = null;
	private HashMap<String, String> formNameMap = null;
	//Added by Prasad on 28/12/16 [changes for update detail only which contains in excel file] END
	//Added by Prasad on 11/04/17 [changes related to adding new detail records while updating header] START
	private MasterDataStatefulEJB masterDataStateful = null;
	private DBAccessLocal dbAccess = null;
	private UserInfoBean userInfoBean = null;
	private String xtraParam = "";
	private HashMap<String, Integer> maxDomIdMap = null;
	private HashMap<String, ArrayList<String>> itemChangeListMap = new HashMap<String, ArrayList<String>>();
	private HashMap<String, String> blankDomStrMap = new HashMap<String, String>();
	//Added by Prasad on 11/04/17 [changes related to adding new detail records while updating header] END
	
	//Added By Ravindra C on 03-01-18 for Store the Error file into Database And write Error File - Start
	private HashMap<Integer,ArrayList<String>> respRowErrorMap = new HashMap<Integer, ArrayList<String>>();
	
	//Added by Prasad on 16/06/17 [to set pkValue as provided in excel file]
	private boolean isRetainPkValue = false;
	
	//Added By Ravindra C on 12-09-2020 for Stop upload Thread
    public static HashSet<String> cancelledUploadThreads = new HashSet<String>();
    
    //Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload] Start
  	private boolean isDataUploadAutoConfirm = false;
  	public void setDataUploadAutoConfirm( boolean isDataUploadAutoConfirm )
  	{
  		this.isDataUploadAutoConfirm = isDataUploadAutoConfirm;
  	}
  	//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload] End

	//CREATING XMLSTRING BY TAKING DATA AND FIELD NAME FROM BATCHLOADET AND INSERTING IN TO CHARGEBACK
	//changed by gayatri on 22-10-2011 [to add one more argument isSaveData][FI1BSUN001]start
	//public String  applyMasterTable( String batchid, String xtraParam, ibase.utility.UserInfoBean userInfo,
	public String  applyMasterTable( String batchId, String xtraParam, ibase.utility.UserInfoBean userInfo) throws ITMException
	{
		//Added By Ravindra C on 10-08-19 for Remote upload server related option
		//String retStatus = applyMasterTable( batchId, xtraParam, userInfo, true, null, null );
		String retStatus = applyMasterTable( batchId, xtraParam, userInfo, true, null, null,null );
		BaseLogger.log("2", userInfo, null,"<!@#> applyMasterTable returnig string from  retStatus:"+retStatus+":");
		return retStatus;
	}
	public String  applyMasterTable( String batchId,  boolean isSaveData) throws ITMException
	{
		String xtraParam = "";
		ibase.utility.UserInfoBean userInfo = null;
		// Changes BY Arvind on 7/JUN/14 As per Danish Sir START
		//Added By Ravindra C on 10-08-19 for Remote upload server related option
		//String retStatus = applyMasterTable( batchId, xtraParam, userInfo, isSaveData, null, null);
		String retStatus = applyMasterTable( batchId, xtraParam, userInfo, isSaveData, null, null, null );
		// Changes BY Arvind on 7/JUN/14 As per Danish Sir END
		return retStatus;
	}
	
	public String applyMasterTable( String batchId, String xtraParam, ibase.utility.UserInfoBean userInfo, boolean isSaveData, String remoteData) throws ITMException
	//changed by gayatri on 22-10-2011 [to add one more argument isSaveData][FI1BSUN001]end
	{
		//Added By Ravindra C on 10-08-19 for Remote upload server related option
		//String retStatus = applyMasterTable(  batchId,  xtraParam,  userInfo, true, null, null );
		String retStatus = applyMasterTable(  batchId,  xtraParam,  userInfo, true, null, null, remoteData );
		BaseLogger.log("2", userInfo, null,"<!@#> applyMasterTable returnig string from  retStatus:"+retStatus+":");
		return retStatus;
	}//end of dom creation
	//changed by gayatri on 29-07-2011

	//Added by Anjali R. on 02/11/17 [Added argument as excelfilepath] Start
	public String  applyMasterTable( String batchId, String xtraParam, ibase.utility.UserInfoBean userInfo,String excelFilePath,String templateKey, String remoteData) throws ITMException
	{
		String retStatus = applyMasterTable(  batchId,  xtraParam,  userInfo, true, excelFilePath, templateKey, remoteData );
		BaseLogger.log("2", userInfo, null,"<!@#> applyMasterTable returnig string from  retStatus:"+retStatus+":");
		return retStatus;
	}
	
	//Added By Ravindra C on 10-08-19 for Remote upload server related option
	//public String applyMasterTable( String batchId, String xtraParam, ibase.utility.UserInfoBean userInfo, boolean isSaveData, String excelFilePath, String templateKey ) throws ITMException
	public String applyMasterTable( String batchId, String xtraParam, ibase.utility.UserInfoBean userInfo, boolean isSaveData, String excelFilePath, String templateKey, String remoteData ) throws ITMException
	{
		String retStatus = "";
		String winName = "";
		String dataInput = "";
		StringBuffer logBuff = new StringBuffer();
		BaseLogger.log("2", userInfo, null,"Enter In to Dom Creation and master apply in  Corresponding Master...."); 
		BaseLogger.log("2", userInfo, null,"Transation for Batch id::::::"+batchId); 
		ResultSet rs = null;

		PreparedStatement pstmt = null;
		StringBuffer xmlBuff = null;
		String sql = "";
		String fldData = "";
		String fldName = "";
		String xmlStrPass = "";
		int objSsl = 0;
		int objSl = 0;
		int totObjSl = 0;
		Connection conect = null;
		int maxTranSl =0;
		String tableName = "";
		String tableNameDet1 = " ";
		String tableNameDet2 = " ";
		String tableNameDet3 = " ";
		String tranIdCol = "";
		boolean isBatchIdColExist = false;
		ArrayList<String> pointerList  = new ArrayList<String>();
		HashMap<Integer,String> objFormsWiseUpdateTable = new HashMap<Integer, String>();
		HashMap<String,ArrayList<String>> tableWiseDateColumnListMap = new HashMap<String,ArrayList<String>>();

		setXtraParam( xtraParam );
		if ( maxDomIdMap != null )
		{
			maxDomIdMap.clear();
		}
		if ( itemChangeListMap != null )
		{
			itemChangeListMap.clear();
		}
		if ( blankDomStrMap != null )
		{
			blankDomStrMap.clear();
		}

		String objName ="";
		ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
		try
		{
			ConnDriver conndriver = new ConnDriver();

			String transDB = "";
			batchId = ( batchId == null ) ? "" : batchId.trim();

			if(userInfo != null)
			{
				transDB = userInfo.getTransDB();
				userId = userInfo.getLoginCode();
			}

			//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				conect = conndriver.getConnectDB(transDB);
			}
			
			int minTranSl = getMinTranSL( batchId, conect );
			BaseLogger.log("3", userInfo, null, "minTranSl[" + minTranSl + "]" );
			if ( minTranSl == -1 )
			{
				if( conect != null )
				{
					conect.close();
					conect = null;
				}
				retStatus = "Success";
				BaseLogger.log("3", userInfo, null,"retString[" + retStatus + "]");
				return retStatus;
			}
			String collectWin = "SELECT WIN_NAME, DATA_INPUT FROM BATCHLOAD WHERE BATCH_ID=? AND TRAN_SL = ? FOR UPDATE NOWAIT";
			/*BaseLogger.log("3", userInfo, null,"collectWin ["+collectWin+"]");*/
			pstmt = conect.prepareStatement(collectWin);
			pstmt.setString( 1, batchId );
			pstmt.setInt( 2, minTranSl );
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				winName = rs.getString(1);
				dataInput = rs.getString(2);
				BaseLogger.log("3", userInfo, null, "win_name["+ win_name +"], type["+ dataInput +"]" );
			}
			rs.close();
			rs = null;
		}
		catch(SQLException sqlex) 
		{
			BaseLogger.log("0", userInfo, null,"SQLException :[MasterApplyEJB(1)][Excuting Query Failed1]" +sqlex.getMessage());
			sqlex.printStackTrace();
			String errorMessage = sqlex.getMessage();
			try 
			{
				if(errorMessage != null && errorMessage.startsWith("ORA-") )
				{
					retStatus = itmDBAccess.getErrorString("","VTEDILOCKD","", userInfo);
				}
				else
				{
					retStatus = itmDBAccess.getErrorString("","VTEDIFAIL","", userInfo);
				}
			}
			catch (RemoteException e)
			{
				BaseLogger.log("0", userInfo, null,"Exception while getting return String .......... ["+e.getMessage()+"]");
				e.printStackTrace();
			}
			if (retStatus.indexOf("<trace>") != -1)
			{
				retStatus = retStatus.replace(retStatus.substring(retStatus.indexOf("<trace>"), retStatus.indexOf("</trace>")), 
						"<trace><![CDATA["+ errorMessage +"]]>");
			}
			return retStatus; 
		}
		catch(Exception ex)
		{
			BaseLogger.log("0", userInfo, null,"Exception1(MasterApplyEJB(1)) ::"+ex.getMessage());
			ex.printStackTrace();
			try 
			{
				if( conect != null )
				{
					conect.close();
					conect = null;
					BaseLogger.log("0", userInfo, null,"<!@#>closing connection done");
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
			throw new ITMException(ex);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(SQLException sqlex)
			{
				sqlex.printStackTrace();
				throw new ITMException(sqlex);
			}
		}

		BaseLogger.log("3", userInfo, null, "win_name::::::::::: ["+ winName +"]" );
		if( winName != null && winName.indexOf("w") == 0 && winName.indexOf("_") == 1 )
		{
			objName = winName.substring("w_".length(), winName.length());
			BaseLogger.log("3", userInfo, null,"objName = ["+objName+"]");
		}

		ArrayList<String> transInfoList = getTransInfo( winName, conect );
		if ( transInfoList != null && transInfoList.size() > 0 )
		{
			tranIdCol = transInfoList.get( 0 );
			tableName = transInfoList.get( 1 );
			tableNameDet1 = transInfoList.get( 2 );
			tableNameDet2 = transInfoList.get( 3 );
			tableNameDet3 = transInfoList.get( 4 );
		}
		BaseLogger.log("3", userInfo, null,"Header TableName :: ["+ tableName +"], tranIdCol :: ["+ tranIdCol +"]" );
		BaseLogger.log("3", userInfo, null,"Detail Table1:1 :: ["+ tableNameDet1 +"], Table1:2 :: ["+ tableNameDet2 +"], Table1:3 :: ["+ tableNameDet3 +"]" );
		
		objFormsWiseUpdateTable = this.getObjFormsWiseUpdateTable( conect, winName );
		int totalForms = objFormsWiseUpdateTable.size();
		String tableToUpdate= "";
		BaseLogger.log("3", userInfo, null,"totalForms --"+totalForms+" and objFormsWiseUpdateTable ["+objFormsWiseUpdateTable+"]");
		for( Integer formNo : objFormsWiseUpdateTable.keySet() )
		{
			tableToUpdate = objFormsWiseUpdateTable.get(formNo);
			tableWiseDateColumnListMap.put( tableToUpdate, this.getDateColumnsofTable( conect, tableToUpdate ) );
		}
		BaseLogger.log("3", userInfo, null,"tableWiseDateColumnListMap --"+tableWiseDateColumnListMap);

		try 
		{
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext initialContext = new InitialContext(appConnect.getProperty());
			//DBAccessLocal dbAccess = (DBAccessLocal) initialContext.lookup("ibase/DBAccessEJB/local");
			DBAccessEJB dbAccess = new DBAccessEJB();
			//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
			objFormsDetailList = dbAccess.getObjFormsDetailList(objName, userInfo);
			//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] START
			formWisePkFldNameMap = new HashMap<String, String>();
			formNameMap = new HashMap<String, String>();
			int noOfForms = objFormsDetailList.size();
			for(int i = 0; i < noOfForms; i++)
			{
				ArrayList currFormDetailList = (ArrayList)objFormsDetailList.get(i);
				String objContext = (String) currFormDetailList.get(14);
				if ( currFormDetailList.size() > 27 )
				{
					formWisePkFldNameMap.put( objContext, ""+currFormDetailList.get(27) );
				}
				String formName = (String) ( ( currFormDetailList.get(32) == null ) ? "" : currFormDetailList.get(32) );
				BaseLogger.log("3", userInfo, null, "objContext : ["+ objContext +"], formName : ["+ formName +"]" );
				formNameMap.put( objName + "::" + objContext, formName );
			}
			BaseLogger.log("3", userInfo, null, "formWisePkFldNameMap - ["+ formWisePkFldNameMap +"]" );
			BaseLogger.log("3", userInfo, null, "formNameMap - ["+ formNameMap +"]" );
			//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] END
			dbAccess = null;
		}
		catch (RemoteException e1) 
		{
			e1.printStackTrace();
		}
		catch (NamingException e1) 
		{
			e1.printStackTrace();
		}
		catch (Exception e1) 
		{
			e1.printStackTrace();
		}

		ArrayList<Integer> batchLoadDet = getBatchLoadDet( batchId, conect );
		int minObjssl = 0;
		if ( batchLoadDet != null && batchLoadDet.size() > 0 )
		{
			minObjssl = batchLoadDet.get( 0 );
			totObjSl = batchLoadDet.get( 1 );
		}
		BaseLogger.log("3", userInfo, null, "minObjssl : ["+ minObjssl +"], totObjSl : ["+ totObjSl +"]" );
		//sql = "";
		
		int incrementBy = (minObjssl == 0) ? totObjSl + 1 : totObjSl;

		maxTranSl = getMaxTranSL( winName, batchId, conect );
		BaseLogger.log("3", userInfo, null, "MAX OF HEADER (maxTranSl): ["+ maxTranSl +"]" );
		tran_sl = maxTranSl;
		logBuff.append(	"<?xml version='1.0' encoding='"+CommonConstants.ENCODING+"'?>\n").append("<Root>\n");
		logBuff.append("<Header>");
		logBuff.append("<win_name>").append(winName).append("</win_name>");
		logBuff.append("<batch_id>").append(batchId).append("</batch_id>");

		for( int transl = 1; transl <= maxTranSl; transl++ )//maxTranSl
		{
			BaseLogger.log("3", userInfo, null,"maxTranSl " +maxTranSl + "TranSl" +transl);
			String TranID = "";
			int totalDetRec = 0;
			String errMsg= "";
			String loadStatus = "";
			String tranTag = "<TranSl domID=\""+transl+"\" >"; 
			logBuff.append(tranTag);
			xmlBuff =new StringBuffer();
			BaseLogger.log("3", userInfo, null,"total no of objsl= "+incrementBy);
			xmlBuff.append(	"<?xml version='1.0' encoding='"+CommonConstants.ENCODING+"'?>\n").append("<Root>\n");
			xmlBuff.append("<DocumentRoot>");
			xmlBuff.append("<description>").append("Datawindow Root").append("</description>");
			xmlBuff.append("<group0>");
			xmlBuff.append("<description>").append("Group0 description").append("</description>");
			xmlBuff.append("<Header0>");
			xmlBuff.append("<objName><![CDATA[").append(objName).append("]]></objName>");
			xmlBuff.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
			xmlBuff.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
			xmlBuff.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
			xmlBuff.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
			xmlBuff.append("<action><![CDATA[").append("SAVE").append("]]></action>");
			xmlBuff.append("<elementName><![CDATA[").append("").append("]]></elementName>");
			xmlBuff.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
			xmlBuff.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
			xmlBuff.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
			xmlBuff.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
			xmlBuff.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
			xmlBuff.append("<description>").append("Header0 members").append("</description>");
			xmlBuff.append("<pkValues><![CDATA[").append("").append("]]></pkValues>"); // Added by Amit D 
			objSsl = 0;
			sql = "SELECT MAX(BATCHLOADDET.OBJ_SSL), MAX(BATCHLOADDET.OBJ_SL) FROM BATCHLOADDET,BATCHLOAD WHERE BATCHLOAD.BATCH_ID=BATCHLOADDET.BATCH_ID AND BATCHLOAD.TRAN_SL=BATCHLOADDET.TRAN_SL AND BATCHLOAD.WIN_NAME=? "
					+ " AND BATCHLOAD.TRAN_SL=?   AND BATCHLOAD.BATCH_ID= ?";

			BaseLogger.log("3", userInfo, null,"sql 111= [ "+sql+"]");
			try
			{
				pstmt = conect.prepareStatement(sql);
				pstmt.setString(1,winName.trim()); 
				pstmt.setInt(2,transl); 
				pstmt.setString(3,batchId.trim()); 
				rs = pstmt.executeQuery(); 
				if(rs.next())
				{
					objSsl = rs.getInt(1);
					//shamim
					objSl = rs.getInt(2);
				}
				BaseLogger.log("3", userInfo, null,"TOTAL DETAIL OF HEADER =("+transl+")IS("+objSsl+")");
				BaseLogger.log("3", userInfo, null,"<!@#>objSl>TOTAL DETAIL OF HEADER =("+transl+")IS("+objSl+")");
				rs.close();
				pstmt.close();
			}
			catch(SQLException se11)
			{
				try{conect.rollback();}catch(Exception see){
					throw new ITMException(see);
				}
				BaseLogger.log("0", userInfo, null,"SQLException :[MasterApplyEJB(9)][Excuting Query Failed1]" + sql + se11.getMessage());
				se11.printStackTrace();
				throw new ITMException(se11);
			}
			catch(Exception ex11)
			{
				try{conect.rollback();}catch(Exception exe){throw new ITMException(exe);}
				BaseLogger.log("0", userInfo, null,"Exception1 (MasterApplyEJB(9))::"+sql +ex11.getMessage());
				ex11.printStackTrace();
				throw new ITMException(ex11);
			}
			/* Added by Amit D on 13 Jun 2013 to Close Statement and Result Set Start*/
			finally
			{
				try
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				catch(SQLException sqlex)
				{
					sqlex.printStackTrace();
					throw new ITMException(sqlex);
				}
			}
			for(int ctr = 0 ; ctr<incrementBy;ctr++) //incrementBy IS objSl
			{
				int temp = ctr+1; 
				pointerList = tableWiseDateColumnListMap.get(objFormsWiseUpdateTable.get(temp));
				int dateColListSize = 0;
				if(pointerList != null)
				{
					dateColListSize = pointerList.size();
				}
				DWFactory dws = null;
				try
				{
					dws = new DWFactory(userInfo);
				} 
				catch (Exception e) 
				{
					e.printStackTrace();
				}
				//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] START
				String formName = getFormName( ""+ temp );
				if ( formName == null || formName.trim().length() == 0 )
				{
					formName = ""+ temp;
				}
				String metaDataFileName = objName + "2" + formName; //$NON-NLS-1$
				//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] END
				DWObject dwObj = (DWObject)dws.getDataWindow(metaDataFileName);
				ArrayList primaryKeyLogNameList = dwObj.getPrimaryKeyLogNameList();
				ArrayList primaryKeyDataTypeList = dwObj.getPrimaryKeyDataTypeList();
				HashMap colLogNameTypeMap = dwObj.getColLogNameTypeMap();
				HashMap colLogNameSizeMap = dwObj.getColLogNameSizeMap();
				if(temp == 1)
				{
					BaseLogger.log("3", userInfo, null,"HEADER OF TRANSL :"+transl);

					try 
					{		
						sql = "SELECT BATCHLOADDET.FLD_DATA,BATCHLOADDET.COL_NAME  FROM BATCHLOAD ,BATCHLOADDET "
								+" WHERE BATCHLOAD.BATCH_ID = BATCHLOADDET.BATCH_ID  AND BATCHLOAD.TRAN_SL=BATCHLOADDET.TRAN_SL AND BATCHLOAD.WIN_NAME = ? "
								+ "AND BATCHLOAD.TRAN_SL=? AND BATCHLOAD.BATCH_ID= ? AND BATCHLOADDET.OBJ_SL= ? ";
						BaseLogger.log("3", userInfo, null,"SQL ["+sql+"]");
						BaseLogger.log("3", userInfo, null,"transl ["+transl+"]");
						pstmt = conect.prepareStatement(sql);
						pstmt.setString(1,winName);
						pstmt.setInt(2,transl); 
						pstmt.setString(3,batchId.trim()); 	
						pstmt.setInt(4,ctr);
						rs = pstmt.executeQuery();
						HashMap<String, String> fldValueMap = new HashMap<String, String>();
						StringBuffer dataBuff = new StringBuffer();
						while(rs.next())
						{
							fldData = rs.getString(1);
							fldName = rs.getString(2);	
							BaseLogger.log("3", userInfo, null, "fldName ["+ fldName +"], fldData ["+ fldData +"]" );

							fldData =  ("<NULL>").equals(fldData)  ? "" : fldData ;
							if( fldData != null && fldData.length() > 0 && (!fldData.equals("<NULL>")))
							{
								for(int dateFldCount = 0;dateFldCount<dateColListSize;dateFldCount++)
								{
									String  dateFld = pointerList.get(dateFldCount);
									if(fldName.trim().equalsIgnoreCase(dateFld.trim()))  
									{
										try
										{
											Object date = null;
											SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
											date = sdf.parse(fldData);
											SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getApplDateFormat());
											fldData=sdf1.format(date).toString();
										}
										catch(Exception ex)
										{
											ex.printStackTrace();
										}
									}
								}
								if ( "line_no".equalsIgnoreCase( fldName ) )
								{
									if( ( (String)colLogNameTypeMap.get( fldName ) ).equalsIgnoreCase("char") )
									{
										int size = ((Integer)colLogNameSizeMap.get( fldName )).intValue();
										while( fldData.length() != size )
										{
											fldData = " " + fldData; 
										}
									}
								}
							}
							if( fldName != null && fldName.length() > 0 )
							{
								fldName = fldName.toLowerCase();
								if(fldData != null && fldData.length()!=0 && ("<NULL>").equals(fldData))
								{
									BaseLogger.log("3", userInfo, null,"feild data null ");
									fldData = "";
								}
								//changes done by cpandey on 12/12/12  //previous  fldData == null?"":fldData.trim()
								//Changed by Prasad on 28/12/16 [to set pkvalue and pkname in excel dom]
								//xmlBuff.append("<").append(fldName).append("><![CDATA[").append( fldData ).append("]]></" ).append( fldName ).append(">");
								//Changed by Prasad on 27/07/17 [set isDataUpload flag true]
								//dataBuff.append("<").append(fldName).append("><![CDATA[").append( fldData ).append("]]></" ).append( fldName ).append(">");
								dataBuff.append("<").append(fldName).append(" isDataUpload=\"true\"").append("><![CDATA[").append( fldData ).append("]]></" ).append( fldName ).append(">");
								//end of changes 
							}
							fldValueMap.put( fldName, fldData );
						}
						StringBuffer pkFieldNameBuff = new StringBuffer();
						StringBuffer pkValueBuff = new StringBuffer();
						StringBuffer pkFieldDataTypesBuff = new StringBuffer();
						String pkFldNames = "";
						if ( formWisePkFldNameMap != null && formWisePkFldNameMap.containsKey( "1" ) )
						{
							pkFldNames = genericUtility.checkNull( formWisePkFldNameMap.get( "1" ) );
						}
						if ( pkFldNames.length() > 0 )
						{
							String[] pkFldNamesArr = pkFldNames.split( COLUMN_SEPARATOR );
							for ( int i = 0; i < pkFldNamesArr.length; i++ )
							{
								String pkFldName = pkFldNamesArr[i];
								pkFieldNameBuff.append( pkFldName ).append( COLUMN_SEPARATOR );

								String headerPKFieldDataType = ""+ primaryKeyDataTypeList.get( getIndex( primaryKeyLogNameList, pkFldName ) );
								pkFieldDataTypesBuff.append( headerPKFieldDataType ).append( COLUMN_SEPARATOR );

								String pkFldVal = fldValueMap.get( pkFldName );
								pkValueBuff.append( pkFldVal ).append( COLUMN_SEPARATOR );
							}
						}
						else
						{
							for(int i = 0; i < primaryKeyLogNameList.size(); i++)
							{
								String pkFieldName = (String) primaryKeyLogNameList.get(i);
								pkFieldNameBuff.append( pkFieldName ).append( COLUMN_SEPARATOR );

								pkFieldDataTypesBuff.append( (String)primaryKeyDataTypeList.get(i) ).append( COLUMN_SEPARATOR );

								pkValueBuff.append( fldValueMap.get( pkFieldName ) ).append( COLUMN_SEPARATOR );
							}
						}
						if ( pkValueBuff.toString().endsWith( COLUMN_SEPARATOR ) )
						{
							pkValueBuff = pkValueBuff.deleteCharAt( pkValueBuff.length() - COLUMN_SEPARATOR.length() );
						}
						BaseLogger.log("3", userInfo, null, "pkValueBuff - ["+ pkValueBuff +"], pkFieldNameBuff - ["+ pkFieldNameBuff +"]" );
						String tag = "<Detail1 dbID=\""+ pkValueBuff +"\" domID=\"1\" objName=\""+objName+"\" objContext=\"1\" >";
						xmlBuff.append(tag);
						String tag1 = "<attribute pkNames=\""+ pkFieldNameBuff +"\" status=\"N\" updateFlag=\"A\" selected=\"N\" />";
						xmlBuff.append(tag1);
						xmlBuff.append( dataBuff );
						String end = "</Detail1>";
						xmlBuff.append(end); 
						rs.close();
						pstmt.close();
					}    
					catch(SQLException se1) 
					{
						BaseLogger.log("0", userInfo, null,"SQLException :[MasterApplyEJB(11)][Excuting Query Failed3]" + sql + se1.getMessage());
						se1.printStackTrace();
						try 
						{
							if( conect != null )
							{
								conect.close();
								conect = null;
								BaseLogger.log("3", userInfo, null,"<!@#>closing connection done");
							}
						}
						catch (SQLException e) 
						{
							e.printStackTrace();
							throw new ITMException(e);
						}
						throw new ITMException(se1);
					}
					catch(Exception ex1)
					{
						BaseLogger.log("0", userInfo, null,"Exception3 (MasterApplyEJB(11))::"+sql +ex1.getMessage());
						ex1.printStackTrace();
						try 
						{
							if( conect != null )
							{
								conect.close();
								conect = null;
								BaseLogger.log("0", userInfo, null,"<!@#>closing connection done");
							}
						}
						catch (SQLException e) 
						{
							e.printStackTrace();
							throw new ITMException(e);
						}
						throw new ITMException(ex1);
					}
					finally
					{
						try
						{
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
						catch(SQLException sqlex)
						{
							sqlex.printStackTrace();
							throw new ITMException(sqlex);
						}
					}
				}
				else
				{
					BaseLogger.log("3", userInfo, null,"<!@#> in else FOR DETAIL LOOP FOR NO OF RECORD IN DETAIL");
					for(int j = 1;  j <= objSsl; j++ ) //objSsl
					{
						BaseLogger.log("3", userInfo, null,"<!@#> objSsl ["+ objSsl +"]:  j :["+ j +"]" );

						boolean isDetailRecordExist = false; 
						StringBuffer detailBuffer = new StringBuffer();

						StringBuffer dataBuffer = new StringBuffer();

						BaseLogger.log("3", userInfo, null,"detail(" +j+")of" +"HEADER :"+transl);

						try
						{
							sql = "SELECT BATCHLOADDET.FLD_DATA, BATCHLOADDET.COL_NAME FROM BATCHLOAD,BATCHLOADDET"
									+" WHERE BATCHLOAD.BATCH_ID = BATCHLOADDET.BATCH_ID  AND BATCHLOAD.TRAN_SL = BATCHLOADDET.TRAN_SL AND BATCHLOAD.WIN_NAME = ? "
									+ "AND BATCHLOADDET.OBJ_SL= ? AND BATCHLOAD.TRAN_SL=? and BATCHLOADDET.OBJ_SSL=? AND BATCHLOAD.BATCH_ID= ?  ";
							BaseLogger.log("3", userInfo, null,"sql at 676 [ "+sql+"]");
							pstmt = conect.prepareStatement(sql);
							pstmt.setString(1,winName);
							pstmt.setInt(2,ctr);
							pstmt.setInt(3,transl); 
							pstmt.setInt(4,j);
							pstmt.setString(5,batchId.trim());

							rs = pstmt.executeQuery();
							HashMap<String, String> fldValueMap = new HashMap<String, String>();
							while(rs.next())
							{
								isDetailRecordExist = true;
								fldData = rs.getString(1);
								fldName = rs.getString(2);	
								BaseLogger.log("3", userInfo, null,"fldName ["+fldName+"]");
								BaseLogger.log("3", userInfo, null,"fldData ["+fldData+"]");
								if(fldName!=null && fldName.length()>0)
								{
									fldName = fldName.toLowerCase();
								}
								BaseLogger.log("3", userInfo, null,"<!@#> converting dates for details :");

								if( fldData != null && fldData.length() > 0 && (!fldData.equals("<NULL>")))
								{
									BaseLogger.log("3", userInfo, null,"<!@#> converting dates for details :in if " +pointerList.size());
									for(int dateFldCount = 0;dateFldCount<dateColListSize;dateFldCount++)
									{	
										String dateFld = (String)pointerList.get(dateFldCount);
										if(fldName.trim().equalsIgnoreCase(dateFld.trim()))  	
										{
											try
											{
												Object date = null;
												SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
												date = sdf.parse(fldData);
												SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getApplDateFormat());
												fldData=sdf1.format(date).toString();
											}
											catch(Exception ex)
											{
												ex.printStackTrace();
											}
										}
									}
									if ( "line_no".equalsIgnoreCase( fldName ) )
									{
										if( ( (String)colLogNameTypeMap.get( fldName ) ).equalsIgnoreCase("char") )
										{
											int size = ((Integer)colLogNameSizeMap.get( fldName )).intValue();
											while( fldData.length() != size )
											{
												fldData = " " + fldData; 
											}
										}
									}
								}	//shamim ends
								if( fldName != null && fldName.length() > 0 )
								{
									if(fldData != null && fldData.length()!=0 && ("<NULL>").equalsIgnoreCase(fldData))
									{
										fldData = "";
									}
									//changes done by cpandey on 12/Dec/12
									// Changes By Arvind on 23-JAN-2014 : As per Danish detailBuffer will be write if dataBuffer has some value START
									//Changed by Prasad on 10/03/17 [remove trim condtion for fieldData]
									//dataBuffer.append("<").append(fldName).append("><![CDATA[").append(fldData == null?"":fldData.trim()).append("]]></").append(fldName).append(">");
									//Changed by Prasad on 27/07/17 [set isDataUpload flag true]
									//dataBuffer.append("<").append( fldName ).append("><![CDATA[").append( fldData ).append("]]></").append( fldName ).append(">");
									dataBuffer.append("<").append( fldName ).append(" isDataUpload=\"true\"").append("><![CDATA[").append( fldData ).append("]]></").append( fldName ).append(">");
									// Changes By Arvind on 23-JAN-2014 : As per Danish detailBuffer will be write if dataBuffer has some value END
									//end of changes 
								}
								fldValueMap.put( fldName, fldData );
							}
							if ( dataBuffer.length() > 0 )
							{
								StringBuffer pkFieldNameBuff = new StringBuffer();
								StringBuffer pkValueBuff = new StringBuffer();
								StringBuffer pkFieldDataTypesBuff = new StringBuffer();
								String pkFldNames = "";
								if ( formWisePkFldNameMap != null && formWisePkFldNameMap.containsKey( ""+ temp ) )
								{
									pkFldNames = genericUtility.checkNull( formWisePkFldNameMap.get( ""+ temp ) );
								}
								if ( pkFldNames.length() > 0 )
								{
									String[] pkFldNamesArr = pkFldNames.split( COLUMN_SEPARATOR );
									for ( int i = 0; i < pkFldNamesArr.length; i++ )
									{
										String pkFldName = pkFldNamesArr[i];
										pkFieldNameBuff.append( pkFldName ).append( COLUMN_SEPARATOR );

										String headerPKFieldDataType = ""+ primaryKeyDataTypeList.get( getIndex( primaryKeyLogNameList, pkFldName ) );
										pkFieldDataTypesBuff.append( headerPKFieldDataType ).append( COLUMN_SEPARATOR );

										String pkFldVal = fldValueMap.get( pkFldName );
										pkValueBuff.append( pkFldVal ).append( COLUMN_SEPARATOR );
									}
								}
								else
								{
									for(int i = 0; i < primaryKeyLogNameList.size(); i++)
									{
										String pkFieldName = (String) primaryKeyLogNameList.get(i);
										pkFieldNameBuff.append( pkFieldName ).append( COLUMN_SEPARATOR );

										pkFieldDataTypesBuff.append( (String)primaryKeyDataTypeList.get(i) ).append( COLUMN_SEPARATOR );

										pkValueBuff.append( fldValueMap.get( pkFieldName ) ).append( COLUMN_SEPARATOR );
									}
								}
								if ( pkValueBuff.toString().endsWith( COLUMN_SEPARATOR ) )
								{
									pkValueBuff = pkValueBuff.deleteCharAt( pkValueBuff.length() - COLUMN_SEPARATOR.length() );
								}
								BaseLogger.log("3", userInfo, null, "temp - ["+ temp +"], pkValueBuff - ["+ pkValueBuff +"], pkFieldNameBuff - ["+ pkFieldNameBuff +"]" );
								String tag = "<Detail"+temp;
								tag = tag +" dbID=\""+ pkValueBuff +"\" domID=\""+j+"\" objName=\""+objName+"\"  objContext=\""+temp+ "\""+">";
								detailBuffer.append(tag);
								detailBuffer.append("<attribute  pkNames=\""+ pkFieldNameBuff +"\" status=\"N\" updateFlag=\"A\" selected=\"N\"/>");

								detailBuffer.append(dataBuffer.toString());

								String end = "</Detail"+temp+">";
								detailBuffer.append(end);
							}
							dataBuffer = null;

							if(isDetailRecordExist)
							{
								xmlBuff.append(detailBuffer.toString());
							}
							else
							{
								BaseLogger.log("3", userInfo, null,"No Detail Record Exist so Ignored.......");
							}

							rs.close();
							pstmt.close();
						}    
						catch(SQLException se1)
						{
							BaseLogger.log("0", userInfo, null,"SQLException :[MasterApplyEJB(13)][Excuting Query Failed3]" + sql + se1.getMessage());
							try 
							{
								if( conect != null )
								{
									conect.close();
									conect = null;
									BaseLogger.log("0", userInfo, null,"<!@#>closing connection done");
								}
							}
							catch (SQLException e) 
							{
								e.printStackTrace();
								throw new ITMException(e);
							}
							se1.printStackTrace();
							throw new ITMException(se1);
						}
						catch(Exception ex1)
						{
							BaseLogger.log("0", userInfo, null,"Exception3 (MasterApplyEJB(13))::"+sql +ex1.getMessage());
							ex1.printStackTrace();
							try 
							{
								if( conect != null )
								{
									conect.close();
									conect = null;
									BaseLogger.log("0", userInfo, null,"<!@#>closing connection done");
								}
							}
							catch (SQLException e) 
							{
								e.printStackTrace();
								throw new ITMException(e);
							}
							throw new ITMException(ex1);
						}
						finally
						{
							try
							{
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
							}
							catch(SQLException sqlex)
							{
								sqlex.printStackTrace();
								throw new ITMException(sqlex);
							}
						}
					}
				}		
			}//end of for
			xmlBuff.append("</Header0>"); // Commented by Amit D on 24 Dec 13 //Gulzar 16/06/14 : UN-Commented as it is giving error while edit the batch load data.
			xmlBuff.append("</group0>");
			xmlBuff.append("</DocumentRoot>");
			xmlBuff.append("</Root>\r\n");
			try 
			{
				xmlStrPass = xmlBuff.toString();
				BaseLogger.log("3", userInfo, null, "xmlStr:::::::::::::::::: ["+ xmlStrPass +"]" );
				FileOutputStream fos1 = null;
				File dir = new File (CommonConstants.JBOSSHOME + File.separator +"XMLCB"+File.separator+transl+"_"+batchId);
				if(!dir.exists())
				{
					dir.mkdirs();
				}
				File file = new File( dir ,batchId+".xml");
				if(!file.exists())
				{
					file.createNewFile();
					fos1 = new FileOutputStream(file);
				}
				else
				{
					fos1 = new FileOutputStream(file);
				}
				byte convertStringToByte1[] = xmlStrPass.getBytes();
				fos1.write(convertStringToByte1);
				fos1.close();
			} 
			catch(Exception e) 
			{ 
				BaseLogger.log("0", userInfo, null,"Exception : [MasterApplyEJB(14)][getErrorString] \n:==>"+e.getMessage());
				e.printStackTrace();
				try 
				{
					if( conect != null )
					{
						conect.close();
						conect = null;
						BaseLogger.log("0", userInfo, null,"<!@#>closing connection done");
					}
				}
				catch (SQLException ex) 
				{
					ex.printStackTrace();
					throw new ITMException(ex);
				}
				throw new ITMException(e);
			}
			finally
			{
				try 
				{
					if( rs != null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
				}
				catch (SQLException e) 
				{
					e.printStackTrace();
					throw new ITMException(e);
				}
			}
			String errStr ="";
			if(!isSaveData)
			{
				retStatus = xmlBuff.toString();
			}
			else 
			{
				try
				{
					String excelData = "";
					if( "X".equalsIgnoreCase( dataInput ) )
					{
						excelData = readInputFile( batchId );
						errStr = saveData( excelData, userInfo, conect );
					}
					else
					{
						excelData = xmlStrPass;
						BaseLogger.log("3", userInfo, null, "<!@#> going in save data for this maxTranSl ["+ maxTranSl +"], TranSl ["+ transl +"]" );
						//BaseLogger.log("3", userInfo, null, "<!@#> before save data xmlStrPass ["+ xmlStrPass +"]" );
						errStr = saveData( excelData, userInfo, conect );	
					}
					BaseLogger.log("3", userInfo, null, "<!@#> after save data for this maxTranSl ["+ maxTranSl +"], TranSl ["+ transl +"]" );
					BaseLogger.log("3", userInfo, null, "<!@#> after save data  errStr ["+ errStr +"]" );

					String excelDataDBId = getExcelDataDBId( excelData );
					//Added By Ravindra C on 10-08-19 for Remote upload server related option.
					//retStatus = generateUploadResponse( batchId, transl, errStr, excelDataDBId, excelFilePath, templateKey, conect, userInfo,  null  );
					retStatus = generateUploadResponse( batchId, transl, errStr, excelDataDBId, excelFilePath, templateKey, conect, userInfo,  null, remoteData  );
					if( ! "Rollback".equalsIgnoreCase( retStatus ) && ! "Error".equalsIgnoreCase( retStatus ) )
					{
						isBatchIdColExist = isBatchIdColExist( tableName, conect );
						if( isBatchIdColExist && tableName != null && tranIdCol != null && tranIdCol.trim().length() > 0 )
						{
							//In success case : retStatus - is tranId
							updateBatchIdInTransTable( tableName, tranIdCol, batchId, retStatus, conect );
						}
						retStatus = "Success";
					}
				}
				catch(Exception g)
				{
					BaseLogger.log("0", userInfo, null,g.getMessage());
					try 
					{
						if( conect != null )
						{
							conect.close();
							conect = null;
							BaseLogger.log("0", userInfo, null,"<!@#>closing connection done");
						}
					}
					catch (SQLException e) 
					{
						e.printStackTrace();
						throw new ITMException(e);
					}
					throw new ITMException(g);	
				}
				finally
				{
					try 
					{
						if( rs != null )
						{
							rs.close();
							rs = null;
						}
						if( pstmt != null )
						{
							pstmt.close();
							pstmt = null;
						}
					}
					catch (SQLException e) 
					{
						e.printStackTrace();
						throw new ITMException(e);
					}
				}
			}
			logBuff.append("<tran_id>").append(TranID).append("</tran_id>");
			logBuff.append("<total_det>").append(totalDetRec).append("</total_det>");
			logBuff.append("<load_status>").append(loadStatus).append("</load_status>");
			logBuff.append("<err_msg>").append(errMsg).append("</err_msg>");
			logBuff.append("</TranSl>");
		}//end of transl
		logBuff.append("</Header>"); 
		logBuff.append("</Root>"); 
		try 
		{ 
			if( conect != null )
			{
				conect.commit();	
			}
			//WRITING IN THE XMLSTRING(LOG) IN A FILE
			//		FileOutputStream	fos11 = new FileOutputStream(CommonConstants.JBOSSHOME + File.separator +"LOG"+File.separator+ "LOG"+batchId+".xml");
			//CHANGED BY SHAMIM ON 09-08-12 AS PER DISCUSSION WITH MANOHARAN Sir
			FileOutputStream fos11=null;
			File dir= new File (CommonConstants.JBOSSHOME + File.separator +"LOG");
			if(!dir.exists())
			{
				dir.mkdir();
			}
			File file = new File(dir,batchId+".xml");
			if(!file.exists())
			{
				file.createNewFile();
				fos11= new FileOutputStream(file);
			}else
			{
				fos11= new FileOutputStream(file);

			}
			//changes end by shamim
			byte convertStringToByte11[] = logBuff.toString().getBytes();
			fos11.write(convertStringToByte11);
			fos11.close();

			//Added by Prasad on 07/03/18 [to delete file after successful upload] START
			File excelFile = new File( excelFilePath );
			BaseLogger.log("3", userInfo, null,"file #@#@#::[" + excelFile + "]");
			if ( excelFile.exists() )
			{
				excelFile.delete();
				BaseLogger.log("3", userInfo, null,"file deleted");
			}
			//Added by Prasad on 07/03/18 [to delete file after successful upload] END
		} 
		catch(Exception e)
		{ 
			BaseLogger.log("0", userInfo, null,"Exception : [CreateEJB][getErrorString] \n:==>"+e.getMessage());
			e.printStackTrace();
			try 
			{
				if( conect != null )
				{
					conect.close();
					conect = null;
					BaseLogger.log("0", userInfo, null,"<!@#>closing connection done");
				}
			}
			catch (SQLException ex) 
			{
				ex.printStackTrace();
				throw new ITMException(ex);
			}
			throw new ITMException(e);
		}
		//adding finally by shamim to close open connection
		finally
		{
			if( conect != null )
			{
				try 
				{
					conect.close();
					conect = null;
					BaseLogger.log("0", userInfo, null,"<!@#>closing connection done");
				}
				catch (SQLException e) 
				{
					e.printStackTrace();
					throw new ITMException(e);
				}
			}
		}

		BaseLogger.log("3", userInfo, null,"END OF MASTER APPLY......");
		BaseLogger.log("3", userInfo, null,"<!@#>END OF MASTER APPLY......retStatus "+retStatus);
		//ADDED BY SHAMIM
		if( isSaveData )
		{
			if( retStatus.indexOf("Success") > -1 )
			{
				try 
				{
					retStatus = itmDBAccess.getErrorString( "", "VTEDISU", "", userInfo );
				} 
				catch (RemoteException e) 
				{
					e.printStackTrace();
				} 
				catch (ITMException e) 
				{
					e.printStackTrace();
				}
			}
			else
			{
				try 
				{
					retStatus = itmDBAccess.getErrorString( "", "VTEDIFA", "", userInfo );
				} 
				catch (RemoteException e) 
				{
					e.printStackTrace();
					throw new ITMException(e);
				} 
				catch (ITMException e) 
				{
					e.printStackTrace();
					throw new ITMException(e);
				}
			}
		}
		return retStatus;
	}
	//Added by Anjali R. on 02/11/17 [Added argument as excelfilepath] End
	
	//Added by Prasad on 29/10/18 [creating a overloaded method for processing data from scheduler and manually] START
	private String saveData( String xmlString, ibase.utility.UserInfoBean userInfo, Connection conn )throws ITMException
	{
		//Changed By Ravindra C on 22-01-2021 [for auto confirm transaction from upload]
		return saveData(xmlString, userInfo, isRetainPkValue, isDataUploadAutoConfirm, conn);
	}
	//Added by Prasad on 29/10/18 [creating a overloaded method for processing data from scheduler and manually] END
	
	//Added by Pankaj P on 25/05/2021 [set batchid details to masterStateful related changes] START
	public String saveData( String xmlString, ibase.utility.UserInfoBean userInfo, boolean isRetainPkValue, boolean isDataUploadAutoConfirm, Connection conn )throws ITMException
	{
		return saveData(xmlString, userInfo, isRetainPkValue, isDataUploadAutoConfirm, "", conn);
	}
	//Added by Pankaj P on 25/05/2021 [set batchid details to masterStateful related changes] END

	//private String saveData(String xmlString)throws ITMException
	//Changed By Mahesh Patidar on 18/JUL/13[to pass connection for process request]
	//private String saveData(String xmlString,ibase.utility.UserInfoBean userInfo)throws ITMException
	//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload]
	//public String saveData( String xmlString, ibase.utility.UserInfoBean userInfo, boolean isRetainPkValue, Connection conn )throws ITMException
	public String saveData( String xmlString, ibase.utility.UserInfoBean userInfo, boolean isRetainPkValue, boolean isDataUploadAutoConfirm, String batchId, Connection conn )throws ITMException
	{
		//changed By Ravindra C on 06-09-18 for prevent SYSOUT.  -Start 
		BaseLogger.log("9", userInfo, null, "saving data...........\nxmlString - ["+ xmlString +"]" );
		//changed By Ravindra C on 06-09-18 for prevent SYSOUT.  -Start
		InitialContext ctx = null;
		String retString = null;
		//Changed by Prasad on 02/11/16 [creating new instance of masterstateful as reomved extended MasterStatefulEJB] START
		//Changed By Mahesh Patidar on 03-SEP-13[call process request directly from extended MasterStatefulEJB]
		MasterStatefulLocal masterStateful = null;
		try
		{
//			String [] authencate = new String[2];
//			authencate[0] = userId;
//			authencate[1] = userId;
			//changed by gayatri on 29-07-2011 [to set userInfo]
			String userInfoString = userInfo.toString();
			//Added by Prasad on 30/03/17 [to set userinfo]
			setUserInfoBean(userInfo);
			
			HashMap<String, String> transactionDetailMap = getTransactionDetailForEdit( conn, xmlString, userInfoString );//Added by AMit D  For Testing
			
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");
			
			masterStateful.setUserInfo( userInfoString, xmlString );
			//setUserInfo(userInfoString, xmlString);
//			retString = masterStateful.processRequest(authencate, logInSite, true, xmlString);
			
			//Commented and Changes made by Gulzar on 23/08/13 to pass 'true' in case of external transaction  
			//retString = masterStateful.processRequest(userInfo, xmlString, false, conn);
//			retString = masterStateful.processRequest(userInfo, xmlString, true, conn);
			//BaseLogger.log("3", userInfo, null,"creating MasterStatefulEJB components.........");
			//ejbCreate();
			//BaseLogger.log("3", userInfo, null,"created MasterStatefulEJB components.........");
			//Added by Prasad on 16/06/17 [set editor id for transaction]
			int randInt = new Random().nextInt();
			masterStateful.setEditorId(""+randInt);
			//Added by Prasad on 28/12/16 [to set flag from file upload]
			masterStateful.setFileUpload( true );
			//Added by Prasad on 28/12/16 [to set flag data upload, for add and edit]
			masterStateful.setDataUpload( true );
			//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload]
			masterStateful.setDataUploadAutoConfirm( isDataUploadAutoConfirm );
			//Added by Pankaj P on 25/05/2021 [set batchid details to masterStateful related changes]
			masterStateful.setUploadBatchId( batchId );
			BaseLogger.log("3", userInfo, null, "isDataUploadAutoConfirm - ["+ isDataUploadAutoConfirm +"]" );
			
			if( "Y".equalsIgnoreCase( transactionDetailMap.get( "IS_RECORD_EXIST" ) ) )
			{
				// Changes by Gagan B. on 20-JUL-23 to handle case of edit in case transaction saving API.
				BaseLogger.log("3", userInfo, null, "inside IS_RECORD_EXIST transactionDetailMap - ["+ transactionDetailMap +"]" );
				String pkValues = transactionDetailMap.get("PK_VALUES");
				if (pkValues.endsWith(":")) {
					pkValues =  pkValues.substring(0, pkValues.length() - 1);
		        }
				BaseLogger.log("3", userInfo, null, "inside IS_RECORD_EXIST pkValues - ["+ pkValues +"]" );
				xmlString = E12GenericUtility.updateDbIDAttribute(xmlString, pkValues);
				BaseLogger.log("3", userInfo, null, "inside IS_RECORD_EXIST xmlString - ["+ xmlString +"]" );
				xmlString = updateXml( transactionDetailMap, xmlString );
			}
			else
			{
				xmlString = removeLineNoData( xmlString );
				BaseLogger.log("3", null, null, "After removeLineNoData : ["+ xmlString +"]" );
				//Added by Prasad on 16/06/17 [to set pkValue as provided in excel file] START
				BaseLogger.log("3", userInfo, null, "this.isRetainPkValue - ["+ isRetainPkValue +"]" );
				if ( isRetainPkValue )
				{
					masterStateful.setRetainPkValue( isRetainPkValue );
				}
				//Added by Prasad on 16/06/17 [to set pkValue as provided in excel file] END
				// Added By Arvind on 10-JUL-14 : To generate new primary key for new transaction START
				//masterStateful.setDataUpload(true);
				// Added By Arvind on 10-JUL-14 : To generate new primary key for new transaction END
				BaseLogger.log("3", userInfo, null,"No record Exist to New Record going to insert");
			}
			// Added by Gagan B. on 22-FEB-23 to set runMode value as "B" when transaction is saved via API. [START]
			getRunMode();
			BaseLogger.log( "3", userInfo, null, "runMode from processRequest MasterApplyEJB ["+ runMode +"]" );
			if(runMode.equals("B")) {
				masterStateful.setRunMode("B");
			}
			// Added by Gagan B. on 22-FEB-23 to set runMode value as "B" when transaction is saved via API. [END]
			
			retString = masterStateful.processRequest( userInfo, xmlString, true, conn );
			BaseLogger.log( "3", userInfo, null, "returnString from processRequest ["+ retString +"]" );
			masterStateful.setFileUpload( false );
			//Added by Prasad on 28/12/16 [to set flag data upload, for add and edit]
			masterStateful.setDataUpload( false );
			masterStateful.setRetainPkValue( false );
			//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload]
			masterStateful.setDataUploadAutoConfirm( false );
			//Added by Pankaj P on 25/05/2021 [set batchid details to masterStateful related changes]
			masterStateful.setUploadBatchId( null );
			
			//comment By Nilesh Start: 12-05-2017
			//masterStateful.remove();
			//comment By Nilesh End: 12-05-2017
			//BaseLogger.log("3", userInfo, null,"After removed masterStateful Components[" + retString + "]");
			//Changes by Gulzar on 23/08/13 : END
			//Ended By Mahesh Patidar
			//Changed by Prasad on 02/11/16 [creating new instance of masterstateful as reomved extended MasterStatefulEJB] END
		}
		//Ended By Mahesh Patidar on 03-SEP-13
		catch(ITMException itme)
		{
			BaseLogger.log("0", userInfo, null,"ITMException :FeedBackServlet :saveData :==>");
			throw itme;
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo, null,"Exception :FeedBackServlet :saveData :==>");
			throw new ITMException(e);
		}
		//Added By Nilesh Start ::12-05-2017
		finally
		{
			if(masterStateful!=null)
			{
				masterStateful.remove();
				masterStateful=null;
			}
		}
		//Added By Nilesh End ::12-05-2017
		return retString;
	}
	
	//added by shamim
	private  String readInputFile(String batchid) throws ITMException
	{
		//String batchid="batch_id";
		String readStr=null;
		StringBuilder strbuld = new StringBuilder();
		String retStr ="";
		//added by gayatri on 24-07-2012 [to create edi_input folder]start
		//File file = new File(CommonConstants.JBOSSHOME + File.separator +File.separator+ "edi_input",batchid +".xml");
		File dir = new File( CommonConstants.JBOSSHOME + File.separator + "edi_input" );
		if(!dir.exists())
		{
			dir.mkdirs();
		}
		File file = new File( dir, batchid +".xml" );
		//added by gayatri on 24-07-2012 [to create edi_input folder]end
		try
		{
			FileReader fileReader = new FileReader(file); 
			BufferedReader br = new BufferedReader(fileReader);

			while((readStr = br.readLine())!=null)
			{
				strbuld.append(readStr);
			}
			//BaseLogger.log("3", userInfo, null,"br.readLine" +strbuld.toString());
			br.close();
			retStr=strbuld.toString();
			BaseLogger.log("3", null, null,"Reading xml<!@#>" +retStr);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retStr;
	}
	
	/**
	 * @return the objName
	 */
	public String getObjName() 
	{
		return objName;
	}
	/**
	 * @param objName the objName to set
	 */
	public void setObjName(String objName) 
	{
		this.objName = objName;
	}
	
	//Added by Prasad on 28/12/16 [to get index value from arraylist] START
	private int getIndex( ArrayList list, String matchValue )
	{
		int index = 0;
		if ( list != null && list.size() > 0 )
		{
			for ( int i = 0; i < list.size(); i++ )
			{
				if ( ( list.get( i ) ).equals( matchValue ) )
				{
					return i;
				}
			}
		}
		return index;
	}
	//Added by Prasad on 28/12/16 [to get index value from arraylist] END
	
	public HashMap<String, String> getTransactionDetailForEdit( Connection conn, String xmlString, String userInfoStr )
	{
		String recordExist = "N";
		Document dom 	= null;
		Node headerNode = null;
		HashMap<String ,String> transactionDetailMap = null; 
		try
		{
			String pageContext = "2";
			int numberOfForms = 0;
			String pkValues = "";
			String refSer = "" ;
			//AppConnectParm appConnect = new AppConnectParm();
			//InitialContext initialContext = new InitialContext(appConnect.getProperty());
			
			//Changed by Prasad on 28/12/16 [to get objforms wise pkfield values]
			//DBAccessLocal dbAccess = (DBAccessLocal) initialContext.lookup("ibase/DBAccessEJB/local"); //$NON-NLS-1$
			
			transactionDetailMap = new HashMap<String, String>();
			dom = genericUtility.parseString(xmlString);
			headerNode = dom.getElementsByTagName("Detail1").item(0);
		
			this.objName = dom.getElementsByTagName("objName").item(0).getFirstChild().getNodeValue();
			String objContext = dom.getElementsByTagName("objContext").item(0).getFirstChild().getNodeValue();
		
			//Changed by Prasad on 28/12/16 [to get objforms wise pkfield values]
			//ArrayList objFormsDetailList = dbAccess.getObjFormsDetailList(objName);
			if ( objFormsDetailList != null )
			{
				numberOfForms = objFormsDetailList.size();
			}
			
			headerNode = dom.getElementsByTagName("Detail1").item(0);
			//Changes By Ajinkya Gopalkar on 4-Apr-17
//			DWFactory dws = DWFactory.getDWFactory();
			DWFactory dws = new DWFactory(userInfoBean);
			//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] START
			String formName = getFormName( "1" );
			if ( formName == null || formName.trim().length() == 0 )
			{
				formName = "1";
			}
			String metaDataFileName = objName + "2" + formName; //$NON-NLS-1$
			//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] END
			DWObject dwObj = (DWObject)dws.getDataWindow(metaDataFileName);
			ArrayList primaryKeyLogNameList = dwObj.getPrimaryKeyLogNameList();
			ArrayList primaryKeyDataTypeList = dwObj.getPrimaryKeyDataTypeList();
			StringBuffer headerPKFieldNamesBuff = new StringBuffer();
			StringBuffer pkValueBuff = new StringBuffer();
			StringBuffer headerPKFieldDataTypesBuff = new StringBuffer();
			
			//Changed by Prasad on 28/12/16 [to set values form objform wise] START
			String pkFldNames = checkNull( getPkNames( headerNode ) );
			BaseLogger.log( "3", null, null, "pkFldNames : ["+ pkFldNames +"]" );
			if ( pkFldNames.length() == 0 && formWisePkFldNameMap != null && formWisePkFldNameMap.containsKey( "1" ) )
			{
				pkFldNames = genericUtility.checkNull( formWisePkFldNameMap.get( "1" ) );
				BaseLogger.log("3", null, null,"pkFldNames from formWisePkFldNameMap :["+ pkFldNames +"]");
			}
			if ( pkFldNames.length() > 0 )
			{
				String[] pkFldNamesArr = pkFldNames.split( COLUMN_SEPARATOR );
				for ( int i = 0; i < pkFldNamesArr.length; i++ )
				{
					String pkFldName = pkFldNamesArr[i];
					headerPKFieldNamesBuff.append( pkFldName ).append( COLUMN_SEPARATOR );
					
					String headerPKFieldDataType = "";
					try 
					{
						headerPKFieldDataType = ""+ primaryKeyDataTypeList.get( getIndex( primaryKeyLogNameList, pkFldName ) );
						headerPKFieldDataTypesBuff.append( headerPKFieldDataType ).append( COLUMN_SEPARATOR );
					}
					catch (Exception e) 
					{
						BaseLogger.log("2", null, null,"Exception in getTransactionDetailForEdit of MasterApplyEJB:["+e.getMessage()+"]");
						e.printStackTrace();
					}
					
					String pkFldVal = genericUtility.getColumnValueFromNode( pkFldName, headerNode );
					pkValueBuff.append( pkFldVal ).append( COLUMN_SEPARATOR );
				}
			}
			else
			{
				for(int i = 0; i < primaryKeyLogNameList.size(); i++)
				{
					String pkFieldName = (String) primaryKeyLogNameList.get(i);
					headerPKFieldNamesBuff.append( pkFieldName ).append( COLUMN_SEPARATOR );
					
					headerPKFieldDataTypesBuff.append( (String)primaryKeyDataTypeList.get(i) ).append( COLUMN_SEPARATOR );
					
					String pkFldVal = genericUtility.getColumnValueFromNode( pkFieldName, headerNode );
					pkValueBuff.append( pkFldVal ).append( COLUMN_SEPARATOR );
				}
			}
			
			/*if (headerPKFieldNamesBuff.length() > 0)
			{
				headerPKFieldNamesBuff.deleteCharAt((headerPKFieldNamesBuff.length() - 1));
			}
			String headerPKFieldNames = headerPKFieldNamesBuff.toString();*/
			//Changed by Prasad on 28/12/16 [to set values form objform wise] END
			String headerPKFieldDataTypes = headerPKFieldDataTypesBuff.toString();
			pkValues = pkValueBuff.toString();
			
			//MasterDataStatefulLocal masterDataStateful = (MasterDataStatefulLocal)initialContext.lookup("ibase/MasterDataStatefulEJB/local"); //$NON-NLS-1$
			//Added by Prasad on 28/12/16 [to set formwise pkfld values]
			getMasterDataStatefulLocal().setFormWisePkFldNameMap( formWisePkFldNameMap );
			//Changed by Prasad on 17/03/18 [formName implementation in transaction editor]
			String transactionEditXML  	= getMasterDataStatefulLocal().getTransactionXMLForEdit(objName, pageContext, numberOfForms, pkValues, headerPKFieldDataTypes, null, null, refSer, userInfoStr, objFormsDetailList );
			
			transactionEditXML  		= transactionEditXML.replace("</Header0>", "");
			transactionEditXML			= transactionEditXML.replace("<Header0>", "<Header0></Header0>");
			transactionEditXML  		= transactionEditXML.replace("</group0>", "");
			transactionEditXML			= transactionEditXML.replace("<group0>", "<group0></group0>");
			
			dom = genericUtility.parseString(transactionEditXML);
			//BaseLogger.log("3", userInfo, null,"transactionEditXML -- "+transactionEditXML);
			if (dom.getElementsByTagName("Detail1").getLength() == 1 )
			{
				recordExist = "Y";
			}
			transactionDetailMap.put("IS_RECORD_EXIST", recordExist);
			transactionDetailMap.put("TRANSACTION_EDIT_XML", transactionEditXML);
			transactionDetailMap.put("PK_VALUES", pkValues);
		}
		catch(Throwable ex)
		{
			ex.printStackTrace();
		}
		return transactionDetailMap;
	}
	
	public String updateXml( HashMap<String, String> transactionDetailMap , String xmlStringAdd )
	{
		String updatedXML 		= "";
		String xmlStringEdit 	= "";
		Document newDomAdd = null;
		Document newDomEdit = null;
		Node detailNode = null;
		String nodeName = "" ;
		try
		{
			//Changes made by Gulzar on 26/06/14 to solve the below issue : START
			//If transaction data Detail1, Detail2 etc is included in the '<Header0></Header0>' then in that case 
			//getElementsByTagName("group0").item(0) will return '<Header0>' node instead of "Detail" .
			//So changed data is not get merged and thus not updated in DB. 
			xmlStringAdd	= xmlStringAdd.replace("</Header0>", "");
			xmlStringAdd	= xmlStringAdd.replace("<Header0>", "<Header0></Header0>");
			
			//Changes made by Gulzar on 26/06/14 to solve the below issue : END
			xmlStringEdit = transactionDetailMap.get("TRANSACTION_EDIT_XML");
			
			newDomAdd = genericUtility.parseString(xmlStringAdd);
			newDomEdit = genericUtility.parseString(xmlStringEdit);
			
			Node rootNode = newDomAdd.getElementsByTagName("group0").item(0);
			//Added by Prasad on 29/10/18 [condition for checking data from scheduler and manually] START
			if ( rootNode == null )
			{
				rootNode = newDomAdd.getElementsByTagName("Root").item(0);
			}
			//Added by Prasad on 29/10/18 [condition for checking data from scheduler and manually] END
			NodeList detailNodeList = rootNode.getChildNodes();
			int detailNodeListLen = detailNodeList.getLength();
			for(int i=0 ; i < detailNodeListLen ; i++)
			{
				detailNode = detailNodeList.item(i);
				nodeName = detailNode.getNodeName();
				if(nodeName.startsWith("Detail"))
				{
					newDomEdit = mergeNode(detailNode, newDomEdit);
				}
			}
			rootNode = newDomEdit.getElementsByTagName("Header0").item(0);
			
			StringBuffer xmlBuff = new StringBuffer();
			xmlBuff.append("<Header0>");
			xmlBuff.append("<objName><![CDATA[").append(objName).append("]]></objName>");
			xmlBuff.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
			xmlBuff.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
			xmlBuff.append("<editFlag><![CDATA[").append("E").append("]]></editFlag>");
			xmlBuff.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
			xmlBuff.append("<action><![CDATA[").append("EDIT").append("]]></action>");
			xmlBuff.append("<elementName><![CDATA[").append("").append("]]></elementName>");
			xmlBuff.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
			xmlBuff.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
			xmlBuff.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
			xmlBuff.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
			xmlBuff.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
			xmlBuff.append("<pkValues><![CDATA[").append(transactionDetailMap.get("PK_VALUES")).append("]]></pkValues>");
			xmlBuff.append("</Header0>");
			Document tempDom = genericUtility.parseString(xmlBuff.toString());
			NodeList tempNodeList =   tempDom.getElementsByTagName("Header0").item(0).getChildNodes();
			for (int i = 0; i < tempNodeList.getLength(); i++) 
			{
				Node tempNode = tempNodeList.item(i);
				rootNode.appendChild( rootNode.getOwnerDocument().importNode( tempNode, true ) );
			}
			updatedXML = genericUtility.serializeDom(newDomEdit);
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		BaseLogger.log("3", null, null,"updatedXML ------"+updatedXML);
		return updatedXML;
	}
	
	private Document mergeNode(Node nodeToBeMerged, Document dom)
	{
		try
		{
			String nodeName 		= nodeToBeMerged.getNodeName();
			String domId   			= nodeToBeMerged.getAttributes().getNamedItem( "domID" ).getNodeValue();
			String dbId   			= nodeToBeMerged.getAttributes().getNamedItem( "dbID" ).getNodeValue();
			String updateFlag = ""; //Added by Mahesh Saggam on 22-May-2020 [Changes for delete detail record]
			NodeList subChildList 	= nodeToBeMerged.getChildNodes();
			int subChildListLen 	= subChildList.getLength();
			Node childNode = null;
			HashMap<String, String> nodeValueMap = new HashMap<String, String>();
			for(int i =0 ; i < subChildListLen ; i++)
			{
				childNode = subChildList.item(i);
				String childNodeName = childNode.getNodeName();
				//Added by Mahesh Saggam on 22-May-2020 [Changes for delete detail record] Start
				if("attribute".equalsIgnoreCase(childNodeName))
				{
					updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
				}
				//Added by Mahesh Saggam on 22-May-2020 [Changes for delete detail record] End
				if(! ("#text".equals(childNodeName) || "attribute".equalsIgnoreCase(childNodeName)))
				{
					String nodeValue = childNode.getFirstChild() == null ? "" : childNode.getFirstChild().getNodeValue();
					/*if(nodeValue != null && nodeValue.trim().length() > 0)
					{
						nodeValueMap.put(childNodeName, nodeValue);
					}*/
					nodeValueMap.put(childNodeName, nodeValue);
				}
			}
			//Added by Prasad on 08/11/16 [resolving issue of adding new detail for updation]
			boolean isRecordExist = false;
			NodeList parentNodeList = dom.getElementsByTagName(nodeName);
			int parentNodeListLen = parentNodeList.getLength();
			Node parentNode = null;
			for(int i =0 ; i < parentNodeListLen ; i++)
			{
				parentNode = parentNodeList.item(i);
				//Added by Prasad on 28/12/16 [to check record exist using dbId] START
				String parentNodeDbId = parentNode.getAttributes().getNamedItem("dbID").getNodeValue();
				parentNodeDbId = parentNodeDbId.replaceAll( "\\s", "" );
				dbId = dbId.replaceAll( "\\s", "" );
				BaseLogger.log("3", null, null, "dbId - ["+ dbId +"], parentNodeDbId - ["+ parentNodeDbId +"]" );
				//Added by Prasad on 21/08/2021 [to resolve date format in primary key related point]
				//if ( dbId != null && parentNodeDbId != null && dbId.length() > 0 && dbId.equals( parentNodeDbId ) )
				if ( dbId != null && parentNodeDbId != null && dbId.length() > 0 && dbId.equalsIgnoreCase( parentNodeDbId ) )
				{
					isRecordExist = true;
					break;
				}
				//Added by Prasad on 28/12/16 [to check record exist using dbId] END
			}
			BaseLogger.log("3", null, null, "parentNode - ["+ parentNode +"], isRecordExist - ["+ isRecordExist +"]" );
			if( parentNode != null && isRecordExist )
			{
				subChildList = parentNode.getChildNodes();
				subChildListLen = subChildList.getLength();
				//Changed by Prasad on 28/12/16 [to set edit flag E only if record changes in excel] START
				boolean isChgExist = false;
				for( int i = 0; i < subChildListLen; i++ )
				{
					childNode = subChildList.item(i);
					if ( childNode != null )
					{
						/*if( "attribute".equalsIgnoreCase( childNode.getNodeName() ) )
						{
							childNode.getAttributes().getNamedItem("updateFlag").setNodeValue("E");
						}*/
						if( nodeValueMap.containsKey( childNode.getNodeName() ) )
						{
							String nodeValue = nodeValueMap.get( childNode.getNodeName() );
							if ( childNode.getFirstChild() != null ) 
							{
								if ( ! nodeValue.equals( childNode.getFirstChild().getNodeValue() ) )
								{
									isChgExist = true;
								}
								childNode.getFirstChild().setNodeValue( nodeValue );
								((Element)childNode).setAttribute("isDataUpload", "true");
							} 
							else 
							{
								isChgExist = true;
								childNode.appendChild( dom.createCDATASection( nodeValue ) );
							}
							((Element)childNode).setAttribute("isDataUpload", "true");
						}
					}
				}
				if ( nodeName.equalsIgnoreCase( "Detail1" ) )
				{
					isChgExist = true;
				}
				if ( isChgExist )
				{
					for( int i = 0; i < subChildListLen; i++ )
					{
						childNode = subChildList.item(i);
						//Added by Mahesh Saggam on 22-May-2020 [Changes for delete detail record] Start
						if(childNode != null && "attribute".equalsIgnoreCase( childNode.getNodeName() ) && "D".equals(updateFlag))
						{
							childNode.getAttributes().getNamedItem("updateFlag").setNodeValue("D");
							break;
						}
						//Added by Mahesh Saggam on 22-May-2020 [Changes for delete detail record] End
						else if( childNode != null && "attribute".equalsIgnoreCase( childNode.getNodeName() ) )
						{
							childNode.getAttributes().getNamedItem("updateFlag").setNodeValue("E");
							break;
						}
					}
				}
				//Changed by Prasad on 28/12/16 [to set edit flag E only if record changes in excel] END
			}
			//Added by Prasad on 08/11/16 [resolving issue of adding new detail for updation] START
			else if ( ! isRecordExist )
			{
				//Changed by Prasad on 30/03/17 [to get blank dom and update excel data] START
				String objCtx = nodeName.substring( 6 );
				BaseLogger.log("3", null, null, "objCtx - ["+ objCtx +"]" );
				String userInfoStr = "";
				if ( getUserInfoBean() != null )
				{
					userInfoStr = getUserInfoBean().toString();
				}
				String tempDetailXMLStr = "";
				String blankDomStrMapKey = this.objName + "~" + objCtx;
				if ( blankDomStrMap != null && blankDomStrMap.containsKey( blankDomStrMapKey ) )
				{
					tempDetailXMLStr = blankDomStrMap.get( blankDomStrMapKey );
				}
				else
				{
					//Changed by Prasad on 17/03/18 [formName implementation in transaction editor]
					tempDetailXMLStr = getMasterDataStatefulLocal().getBlankDomForAdd( this.objName, objCtx, "1", null, userInfoStr, "WebEditor", getFormName( objCtx ) );
					blankDomStrMap.put( blankDomStrMapKey, tempDetailXMLStr );
				}
				BaseLogger.log("3", null, null, "tempDetailXMLStr - ["+ tempDetailXMLStr +"]" );
				Document tempChildDom = genericUtility.parseString( tempDetailXMLStr );
				appendToDom( dom, tempChildDom, nodeToBeMerged, objCtx );
				/*Node rootNode = dom.getElementsByTagName( "DocumentRoot" ).item(0);
				if ( rootNode != null )
				{
					Node mergeNode = applyDataXML( tempDetailXMLStr, objCtx, nodeToBeMerged );
					if ( mergeNode != null )
					{
						rootNode.appendChild( rootNode.getOwnerDocument().importNode( mergeNode, true ) );
					}
					else
					{
						rootNode.appendChild( rootNode.getOwnerDocument().importNode( nodeToBeMerged, true ) );
					}
				}*/
				//Changed by Prasad on 30/03/17 [to get blank dom and update excel data] END
			}
			//Added by Prasad on 08/11/16 [resolving issue of adding new detail for updation] END
			nodeValueMap.clear();
			nodeValueMap = null;
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
		return dom;
	}
	
	private HashMap<Integer,String> getObjFormsWiseUpdateTable( Connection conn, String asWinname ) throws ITMException
	{
		int formNo = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String metadataFilePath = "";
		HashMap<Integer,String> objFormsWiseUpdateTable = null;
		DWObject dw  = null;
		String updatableTable = "";
		try 
		{
			String objName = asWinname.substring((asWinname.indexOf("w_") +2),asWinname.length());
			// Commented and Added by Pankaj R on 24-Nov-20 as suggested by Danish sir
			// metadataFilePath = CommonConstants.JBOSSHOME+ File.separator + "bin" + File.separator + "metadata"+ File.separator ;
			metadataFilePath = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator ;
			
			objFormsWiseUpdateTable = new HashMap<Integer, String>();
			
			String sqlStr = "SELECT FORM_NO FROM OBJ_FORMS WHERE WIN_NAME = ? ";
			pstmt = conn.prepareStatement( sqlStr );
			pstmt.setString(1, asWinname);
			rs = pstmt.executeQuery();
			if (rs.next()) 
			{
				formNo = rs.getInt("FORM_NO");
				//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] START
				String formName = getFormName( ""+ formNo );
				if ( formName == null || formName.trim().length() == 0 )
				{
					formName = ""+ formNo;
				}
				dw = new DWObject(metadataFilePath + objName.trim() + "2" + formName + ".xml", userInfoBean);
				//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] END
				updatableTable = dw.getTableToBeUpdated();
				objFormsWiseUpdateTable.put(formNo, updatableTable);
			}
			
		} catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException( e );
		}
		finally
		{
			try {
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			} catch (Exception e) {
				throw new ITMException( e );
			}
		}
		return objFormsWiseUpdateTable;
	}
	private ArrayList<String> getDateColumnsofTable(Connection conn , String tableName) throws ITMException
	{
		ArrayList<String> dateColumnList = new ArrayList<String>();
		PreparedStatement datepstmt = null;
		ResultSet dateRs = null;
		String dateStr = "";
		if(tableName != null)
			{
				try
				{
					dateStr = "SELECT * FROM "+tableName.trim() +" WHERE ROWNUM <1";
					datepstmt = conn.prepareStatement(dateStr);

					dateRs = datepstmt.executeQuery();
					ResultSetMetaData rsmd = dateRs.getMetaData();
					int numberOfColumns = rsmd.getColumnCount();
					for(int colCount =1;colCount<=numberOfColumns;colCount++)
					{

						if((rsmd.getColumnType(colCount) == java.sql.Types.DATE )|| (rsmd.getColumnType(colCount)==java.sql.Types.TIMESTAMP))//HARD CODE FOR DATE 91
						{
							BaseLogger.log("3", null, null,"Date field collect...");
							String dateFlds = rsmd.getColumnName(colCount);
							dateColumnList.add( dateFlds );
						}
					}
					datepstmt.close();
					datepstmt = null;
					dateRs.close();
					dateRs = null;
					BaseLogger.log("3", null, null,"total date fld in ="+dateColumnList);
				}
				catch(SQLException extc1)
				{
					BaseLogger.log("0", null, null,"SQLException :[MasterApplyEJB(3)][Excuting Query Failed1]" +dateStr+extc1.getMessage());
					extc1.printStackTrace();
					throw new ITMException(extc1);
				}
				catch(Exception extc1)
				{
					BaseLogger.log("0", null, null,"Exception1(MasterApplyEJB(3)) ::"+dateStr+extc1.getMessage());
					extc1.printStackTrace();
				}
				finally
				{
					try
					{
						if(dateRs != null)
						{
							dateRs.close();
							dateRs = null;
							
						}
						if(datepstmt != null)
						{
							datepstmt.close();
							datepstmt = null;
						}
					}
					catch(SQLException sqlex)
					{
						sqlex.printStackTrace();
						throw new ITMException(sqlex);
					}
				}
			}
		return dateColumnList;
	}
	/**
	 * @return the objFormsDetailList
	 */
	public ArrayList getObjFormsDetailList() 
	{
		return objFormsDetailList;
	}
	/**
	 * @param objFormsDetailList the objFormsDetailList to set
	 */
	public void setObjFormsDetailList(ArrayList objFormsDetailList) 
	{
		this.objFormsDetailList = objFormsDetailList;
	}
	
	//Added by Prasad on 30/03/17 [to get blank dom and update excel data] START
	/**
	 * @return the userInfoBean
	 */
	public UserInfoBean getUserInfoBean() 
	{
		return userInfoBean;
	}
	/**
	 * @param userInfoBean the userInfoBean to set
	 */
	public void setUserInfoBean(UserInfoBean userInfoBean) 
	{
		this.userInfoBean = userInfoBean;
	}
	
	/**
	 * @return the xtraParam
	 */
	public String getXtraParam() 
	{
		return xtraParam;
	}
	
	/**
	 * @param xtraParam the xtraParam to set
	 */
	public void setXtraParam(String xtraParam) 
	{
		this.xtraParam = xtraParam;
	}
	
	private MasterDataStatefulEJB getMasterDataStatefulLocal()
	{
		try 
		{
			if ( masterDataStateful == null )
			{
				/*AppConnectParm appConnect = new AppConnectParm();
				InitialContext initialContext = new InitialContext( appConnect.getProperty() );

				masterDataStateful = (MasterDataStatefulLocal)initialContext.lookup("ibase/MasterDataStatefulEJB/local");*/
				masterDataStateful = new MasterDataStatefulEJB();
			}
		}
		/*catch (NamingException e) 
		{
			e.printStackTrace();
		}*/
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		return masterDataStateful;
	}
	
	private DBAccessLocal getDBAccessLocal()
	{
		try 
		{
			/*if ( dbAccess == null )
			{
				AppConnectParm appConnect = new AppConnectParm();
				InitialContext initialContext = new InitialContext(appConnect.getProperty());
				
				dbAccess = (DBAccessLocal) initialContext.lookup("ibase/DBAccessEJB/local");
			}*/
			dbAccess = new DBAccessEJB();
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		
		return dbAccess;
	}
	
	/**
	 * 
	 * @param tempParentDom
	 * @param blankChildDom
	 * @param nodeToBeMerged
	 * @param objCtx
	 * @throws ITMException
	 */
	private void appendToDom( Document tempParentDom, Document blankChildDom, Node nodeToBeMerged, String objCtx ) throws ITMException
    {
		try
		{
			String detailNodeName = "Detail"+ objCtx;
			NodeList detailList = tempParentDom.getElementsByTagName( detailNodeName );
			Node detailNode = blankChildDom.getElementsByTagName( detailNodeName ).item(0);

			assignPKFieldValues( detailNode, nodeToBeMerged, objCtx );
			assignNewDomID( detailList, detailNode, objCtx );
			
			String transDB = "";
			if ( getUserInfoBean() != null )
			{
				transDB = getUserInfoBean().getTransDB();
			}
			ArrayList itemChangeList = null;
			String itemChangeListMapKey = this.objName + "~" + objCtx;
			if ( itemChangeListMap != null && itemChangeListMap.containsKey( itemChangeListMapKey ) )
			{
				itemChangeList = itemChangeListMap.get( itemChangeListMapKey );
			}
			else
			{
				//if( transDB != null && transDB.trim().length() > 0 && !"null".equalsIgnoreCase(transDB.trim()))
				{
					itemChangeList = getDBAccessLocal().getItemChangeElementList( this.objName, objCtx, getUserInfoBean() );
				}
				/*else
				{
					itemChangeList = getDBAccessLocal().getItemChangeElementList( this.objName, objCtx );
				}*/
				itemChangeListMap.put( itemChangeListMapKey, itemChangeList );
			}
			if ( itemChangeList != null )
			{
				assignITMDefaultValues( tempParentDom, detailNode, objCtx, itemChangeList );
			}
			applyDataXML( nodeToBeMerged, blankChildDom, detailNode, objCtx );
			
			NodeList oriHeaderList = tempParentDom.getElementsByTagName( "DocumentRoot" );
			if ( detailNode != null )
			{
				Node importedNode = tempParentDom.importNode( detailNode, true );
				oriHeaderList.item(0).appendChild( importedNode );
			}
			else
			{
				Node importedNode = tempParentDom.importNode( nodeToBeMerged, true );
				oriHeaderList.item(0).appendChild( importedNode );
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null, "Exception : MasterApplyEJB : appendToDom :"+e.getMessage() );
		} 
	}
	
	/**
	 * 
	 * @param detailNode
	 * @param nodeToBeMerged
	 * @param objCtx
	 */
	private void assignPKFieldValues( Node detailNode, Node nodeToBeMerged, String objCtx )
	{
		try 
		{
			if( nodeToBeMerged != null )
			{
				String dbID = "";
				if ( nodeToBeMerged.getAttributes().getNamedItem( "dbID" ) != null )
				{
					dbID = nodeToBeMerged.getAttributes().getNamedItem( "dbID" ).getNodeValue();
				}

				String pkNames = "";
				NodeList subChildList = nodeToBeMerged.getChildNodes();
				int subChildListLen = subChildList.getLength();
				Node childNode = null;
				for( int i = 0; i < subChildListLen; i++ )
				{
					childNode = subChildList.item(i);
					String childNodeName = childNode.getNodeName();
					if( ! ("#text".equals(childNodeName) ))
					{
						if ( "attribute".equalsIgnoreCase(childNodeName) )
						{
							if ( childNode.getAttributes().getNamedItem( "pkNames" ) != null )
							{
								pkNames = childNode.getAttributes().getNamedItem( "pkNames" ).getNodeValue();
							}
							break;
						}
					}
				}

				if ( detailNode != null )
				{
					if ( detailNode.getAttributes().getNamedItem( "dbID" ) != null )
					{
						detailNode.getAttributes().getNamedItem( "dbID" ).setNodeValue( dbID );
					}

					subChildList = detailNode.getChildNodes();
					subChildListLen = subChildList.getLength();
					for( int i = 0; i < subChildListLen; i++ )
					{
						childNode = subChildList.item(i);
						if ( childNode != null )
						{
							String childNodeName = childNode.getNodeName();
							if( "attribute".equalsIgnoreCase( childNodeName ) )
							{
								if ( childNode.getAttributes().getNamedItem( "pkNames" ) != null )
								{
									childNode.getAttributes().getNamedItem("pkNames").setNodeValue( pkNames );
								}
								break;
							}
						}
					}
				}
			}
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", null, null, "Exception in applyDataXML - ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
	}
	
	private String getPkNames( Node detailNode )
	{
		String pkNames = "";
		try 
		{
			if ( detailNode != null )
			{
				NodeList subChildList = detailNode.getChildNodes();
				int subChildListLen = subChildList.getLength();
				Node childNode = null;
				for( int i = 0; i < subChildListLen; i++ )
				{
					childNode = subChildList.item(i);
					if ( childNode != null )
					{
						String childNodeName = childNode.getNodeName();
						if( "attribute".equalsIgnoreCase( childNodeName ) )
						{
							if ( childNode.getAttributes().getNamedItem( "pkNames" ) != null )
							{
								pkNames = childNode.getAttributes().getNamedItem( "pkNames" ).getNodeValue();
							}
							break;
						}
					}
				}
			}
		}
		catch (DOMException e) 
		{
			BaseLogger.log( "0", null, null, "Exception in getPkNames : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		return pkNames;
	}
	
	/**
	 * 
	 * @param nodeToBeMerged
	 * @param childDom
	 * @param detailNode
	 * @param objCtx
	 */
	private void applyDataXML( Node nodeToBeMerged, Document childDom, Node detailNode, String objCtx )
	{
		try 
		{
			if( nodeToBeMerged != null )
			{
				HashMap<String, String> nodeValueMap = new HashMap<String, String>();
				String dbID = "";
				if ( nodeToBeMerged.getAttributes().getNamedItem( "dbID" ) != null )
				{
					dbID = nodeToBeMerged.getAttributes().getNamedItem( "dbID" ).getNodeValue();
				}
				nodeValueMap.put( "dbID", dbID );

				NodeList subChildList = nodeToBeMerged.getChildNodes();
				int subChildListLen = subChildList.getLength();
				Node childNode = null;
				for( int i = 0; i < subChildListLen; i++ )
				{
					childNode = subChildList.item(i);
					String childNodeName = childNode.getNodeName();
					if( ! ("#text".equals(childNodeName) ))
					{
						if ( "attribute".equalsIgnoreCase(childNodeName) )
						{
							String pkNames = "";
							if ( childNode.getAttributes().getNamedItem( "pkNames" ) != null )
							{
								pkNames = childNode.getAttributes().getNamedItem( "pkNames" ).getNodeValue();
							}
							nodeValueMap.put( "pkNames", pkNames );
						}
						else
						{
							String nodeValue = childNode.getFirstChild() == null ? "" : childNode.getFirstChild().getNodeValue();
							nodeValueMap.put( childNodeName, nodeValue );
						}
					}
				}
				BaseLogger.log("3",null, null, "nodeValueMap - ["+ nodeValueMap +"]" );

				if ( detailNode != null )
				{
					subChildList = detailNode.getChildNodes();
					subChildListLen = subChildList.getLength();
					for( int i = 0; i < subChildListLen; i++ )
					{
						childNode = subChildList.item(i);
						if ( childNode != null )
						{
							String childNodeName = childNode.getNodeName();
							if( "attribute".equalsIgnoreCase( childNodeName ) )
							{
								/*if ( childNode.getAttributes().getNamedItem( "pkNames" ) != null && nodeValueMap.containsKey( "pkNames" ) )
								{
									String pkNames = nodeValueMap.get( "pkNames" );
									childNode.getAttributes().getNamedItem("pkNames").setNodeValue( pkNames );
								}*/
							}
							else if( nodeValueMap.containsKey( childNodeName ) )
							{
								String nodeValue = nodeValueMap.get( childNodeName );
								if ( childNode.getFirstChild() != null ) 
								{
									childNode.getFirstChild().setNodeValue( nodeValue );
								}
								else 
								{
									childNode.appendChild( childDom.createCDATASection( nodeValue ) );
								}
								((Element)childNode).setAttribute("isDataUpload", "true");
							}
						}
					}
				}
			}
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", null, null, "Exception in applyDataXML - ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
	}

	/**
	 * 
	 * @param detailList
	 * @param detailNode
	 * @param objContext
	 * @throws Exception
	 */
	private void assignNewDomID( NodeList detailList, Node detailNode, String objContext ) throws Exception
	{
		try 
		{
			int maxDomID = 0;
			int currDomID = -1;
			Node currDetailNode = null;
			if( maxDomIdMap == null )
			{
				maxDomIdMap = new HashMap<String, Integer>();
			}
			String maxDomIdMapKey = this.objName+"_"+objContext;
			if ( maxDomIdMap.get( maxDomIdMapKey ) == null )
			{
				int detailListLength = detailList.getLength();
				for(int detailCtr = 0; detailCtr < detailListLength; detailCtr++)
				{
					currDetailNode = detailList.item(detailCtr);
					String currDomIDStr = currDetailNode.getAttributes().getNamedItem("domID").getNodeValue();
					if(currDomIDStr != null && !currDomIDStr.equals(""))
					{
						currDomID = Integer.parseInt(currDomIDStr.trim());
					}
					if(currDomID > maxDomID)
					{
						maxDomID = currDomID;
					}
				}
				maxDomID = maxDomID + 1;
				maxDomIdMap.put( maxDomIdMapKey, new Integer( maxDomID ) );
				BaseLogger.log("3", null, null, "Setting Value if not found for ["+ maxDomIdMapKey +"] to ["+ ( maxDomID ) +"]" );
			}
			else
			{
				maxDomID = ( ( Integer ) maxDomIdMap.get( maxDomIdMapKey ) ).intValue();
				maxDomID = maxDomID + 1;
				maxDomIdMap.put( maxDomIdMapKey, new Integer ( maxDomID )   );
				BaseLogger.log("3", null, null, "Setting Value if found for ["+ maxDomIdMapKey +"] to ["+ ( maxDomID ) +"]" );
			}
			detailNode.getAttributes().getNamedItem( "domID" ).setNodeValue( String.valueOf(maxDomID) );
			BaseLogger.log("3", null, null,"Assigned new Dom id :[" + maxDomID +"]");
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", null, null, "Exception : MasterApplyEJB : assignNewDomID :"+e.getMessage() );
			e.printStackTrace();
		}
	}
	
	/**
	 * 
	 * @param parentDom
	 * @param detailNode
	 * @param objContext
	 * @param itemChangeList
	 */
	private void assignITMDefaultValues( Document parentDom, Node detailNode, String objContext, ArrayList<String> itemChangeList )
	{
		try 
		{
			if ( detailNode != null )
			{
				String domID = "";
				if ( detailNode.getAttributes() != null && detailNode.getAttributes().getNamedItem("domID") != null )
				{
					domID = detailNode.getAttributes().getNamedItem("domID").getNodeValue();
				}
				String dbID = "";
				if ( detailNode.getAttributes() != null && detailNode.getAttributes().getNamedItem("dbID") != null )
				{
					dbID = detailNode.getAttributes().getNamedItem("dbID").getNodeValue();
				}
				String editFlag = "";
				NodeList subChildList = detailNode.getChildNodes();
				int subChildListLen = subChildList.getLength();
				for( int i = 0; i < subChildListLen; i++ )
				{
					Node childNode = subChildList.item(i);
					if ( childNode != null )
					{
						String childNodeName = childNode.getNodeName();
						if( "attribute".equalsIgnoreCase( childNodeName ) )
						{
							if ( childNode.getAttributes() != null && childNode.getAttributes().getNamedItem( "updateFlag" ) != null )
							{
								editFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
							break;
						}
					}
				}
				BaseLogger.log("3",null, null, "editFlag - ["+ editFlag +"]" );
				String fieldName = "";
				if (editFlag.equalsIgnoreCase("A"))
				{
					fieldName = "itm_default";
				}
				else if (editFlag.equalsIgnoreCase("E"))
				{
					fieldName = "itm_defaultedit";
				}
				BaseLogger.log("3", null, null, "fieldName - ["+ fieldName +"]" );
				
				if ( itemChangeList != null && itemChangeList.contains( fieldName ) )
				{
					StringBuffer selectedDataBuff = new StringBuffer("<Header0>");
					selectedDataBuff.append("<objName><![CDATA[").append(this.objName).append("]]></objName>");
					selectedDataBuff.append("<pageContext><![CDATA[").append(domID).append("]]></pageContext>");
					selectedDataBuff.append("<objContext><![CDATA[").append( objContext ).append("]]></objContext>");
					selectedDataBuff.append("<editFlag><![CDATA["+editFlag+"]]></editFlag>");
					selectedDataBuff.append("<focusedColumn><![CDATA[").append(fieldName).append("]]></focusedColumn>");
					selectedDataBuff.append("<action><![CDATA[]]></action>");
					selectedDataBuff.append("<elementName><![CDATA[").append("1").append("]]></elementName>");
					selectedDataBuff.append("<forcedSave><![CDATA[").append("false").append("]]></forcedSave>");
					selectedDataBuff.append("<taxInFocus><![CDATA[").append("false").append("]]></taxInFocus>");
					selectedDataBuff.append("<pkValues><![CDATA[").append(dbID).append("]]></pkValues>");
					selectedDataBuff.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
					selectedDataBuff.append("<taxKeyValue><![CDATA[").append("1").append("]]></taxKeyValue>");
					selectedDataBuff.append("<saveLevel><![CDATA[").append("0").append("]]></saveLevel>");
					selectedDataBuff.append("<description>").append("Header0 members").append("</description>");
					String tranDomStr = selectedDataBuff.toString();
					
					String domStr = genericUtility.serializeDom( detailNode );
					String parentDomStr = genericUtility.serializeDom( parentDom );
					
					tranDomStr = "<?xml version='1.0' encoding='UTF-8'?><DocumentRoot>"
							+ "<description>Datawindow Root</description><group0><description>Group0 description</description>"
							+ tranDomStr
							+ domStr
							+ "</Header0></group0></DocumentRoot>";
					
					String detailDomStr = "<?xml version='1.0' encoding='UTF-8'?><DocumentRoot>"
							+ "<description>Datawindow Root</description><group0><description>Group0 description</description>"
							+ tranDomStr
							+ parentDomStr
							+ "</group0></DocumentRoot>";
					
					String returnStr = executeSystemEvent( this.objName, "post_item_change", tranDomStr, detailDomStr, domID, "", getUserInfoBean() );
					
					if ( returnStr != null && returnStr.trim().length() > 0 )
					{
						String itemChngXml = returnStr.replaceFirst("<Detail>", "<Detail"+objContext+">");
						itemChngXml = itemChngXml.replace("</Detail>", "</Detail"+objContext+">");
						
						detailNode = applyToDom( detailNode, itemChngXml );
					}
				}
			}
		}
		catch ( Exception e ) 
		{
			BaseLogger.log("0", null, null, "Exception : MasterApplyEJB : assignITMDefaultValues :"+e.getMessage() );
			e.printStackTrace();
		}
	}
	
	/**
	 * 
	 * @param detailNode
	 * @param retString
	 * @return
	 * @throws ITMException
	 */
	private Node applyToDom( Node detailNode, String retString ) throws ITMException 
	{
		Document dom1 = null;
		Node parentNode = null;
		NodeList parentNodeList = null;
		Node childNode = null;
		NodeList childNodeList = null;

		Node domNode = null;
		NodeList detailNodeList = null;
		
		try 
		{
			dom1 = new E12GenericUtility().parseString(retString);
			parentNodeList = dom1.getElementsByTagName("Root").item(0).getChildNodes();
			
			for ( int cnt = 0; cnt < parentNodeList.getLength(); cnt++ ) 
			{
				parentNode = parentNodeList.item(cnt);
				childNodeList = parentNode.getChildNodes();

				for ( int cnt1 = 0; cnt1 < childNodeList.getLength(); cnt1++ ) 
				{
					childNode = childNodeList.item(cnt1);
					String childNodeName = childNode.getNodeName();
					childNodeName = childNodeName != null ? childNodeName.trim() : "";
					detailNodeList = detailNode.getChildNodes();
					
					for ( int cnt2 = 0; cnt2 < detailNodeList.getLength(); cnt2++ ) 
					{
						domNode = detailNodeList.item(cnt2);
						String domNodeName = domNode.getNodeName();
						domNodeName = domNodeName != null ? domNodeName.trim() : "";
						if ( domNodeName.equalsIgnoreCase( childNodeName ) ) 
						{
							domNode.setTextContent(childNode.getTextContent());
						}
					}
				}
			}
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", null, null, "Exception :MasterApplyEJB :applyToDom :==>"+e.getMessage() );
			throw new ITMException(e);
		}
		return detailNode;
	}
	
	/**
	 * 
	 * @param objName
	 * @param eventCode
	 * @param transDomString
	 * @param detailDomString
	 * @param domId
	 * @param xtraParams
	 * @param userInfo
	 * @return
	 * @throws ITMException
	 */
	private String executeSystemEvent( String objName, String eventCode, String transDomString, String detailDomString, String domId, String xtraParams, UserInfoBean userInfo ) throws ITMException 
	{
		String retStr = "";
		try 
		{
			//AppConnectParm appConnect = new AppConnectParm();
			//InitialContext ctx = new InitialContext(appConnect.getProperty());
			//EventManagerRemote eventManager = (EventManagerRemote) ctx.lookup("ibase/EventManagerEJB/remote");
			EventManagerEJB eventManager = new EventManagerEJB();
			String transDB = "";
			if(userInfo != null)
			{
				transDB = userInfo.getTransDB();
			}
			if( transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0 )
			{
				retStr = eventManager.executeSystemEvent(objName, eventCode, null, transDomString, detailDomString, xtraParams, domId, userInfo);
			}
			else
			{
				retStr = eventManager.executeSystemEvent(objName, eventCode, null, transDomString, detailDomString, xtraParams, domId);
			}
			retStr = eventManager.executeSystemEvent(objName, eventCode, null, transDomString, detailDomString, xtraParams, domId);
			eventManager.remove();
			eventManager = null;
		}
		catch (ITMException itme) 
		{
			BaseLogger.log("0", userInfo, null,"ITMException :MasterApplyEJB :executeSystemEvent :==>"+itme);
			throw itme;
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", userInfo, null,"Exception :MasterApplyEJB :executeSystemEvent :==>"+e);
			throw new ITMException(e);
		}
		return retStr;
	}
	//Added by Prasad on 30/03/17 [to get blank dom and update excel data] END
	
	//Added by Prasad on 16/06/17 [to set pkValue as provided in excel file] START
	public void setRetainPkValue(boolean isRetainPkValue) 
	{
		this.isRetainPkValue = isRetainPkValue;
	}
	//Added by Prasad on 16/06/17 [to set pkValue as provided in excel file] END
	
	//Added By Ravindra C on 26-06-18 to check file type(xml / Excel)  - Start
	
	//Added By Ravindra C on 10-08-19 for Remote upload server related option
	//private String generateUploadResponse( String batchId, int tranSl, String errorStr, String excelDataDBId, String excelFilePath, String templateKey, Connection conn, UserInfoBean userInfo, String uploadFilePath ) throws ITMException
	private String generateUploadResponse( String batchId, int tranSl, String errorStr, String excelDataDBId, String excelFilePath, String templateKey, Connection conn, UserInfoBean userInfo, String uploadFilePath, String remoteData ) throws ITMException
	{
		//Added By Ravindra C on 10-08-19 for Remote upload server related option
		//return generateUploadResponse( batchId, tranSl, errorStr, excelDataDBId, excelFilePath, templateKey, conn, userInfo, null, null, uploadFilePath );
		return generateUploadResponse( batchId, tranSl, errorStr, excelDataDBId, excelFilePath, templateKey, conn, userInfo, null, null, uploadFilePath, remoteData );
	}
	//Added By Ravindra C on 26-06-18 to check file type(xml / Excel)  - End
	
	//changed by ravindra c on 2-02-19 for matrix errror file write 
	//private String generateUploadResponse( String batchId, int tranSl, String errorStr, String excelDataDBId, String excelFilePath, String templateKey, Connection conn, UserInfoBean userInfo, UploadFileLocal uploadFile, String fileType ) throws ITMException
	
	//Added By Ravindra C on 10-08-19 for Remote upload server related option
	//private String generateUploadResponse( String batchId, int tranSl, String errorStr, String excelDataDBId, String excelFilePath, String templateKey, Connection conn, UserInfoBean userInfo, UploadFileLocal uploadFile, String fileType, String uploadFilePath ) throws ITMException
	private String generateUploadResponse( String batchId, int tranSl, String errorStr, String excelDataDBId, String excelFilePath, String templateKey, Connection conn, UserInfoBean userInfo, UploadFileLocal uploadFile, String fileType, String uploadFilePath, String remoteData ) throws ITMException
	{
		String retStatus = "";
		try 
		{
			//Added By Ravindra C on 11-07-18 for  Uploading data while inserting into batchload 
			userId = userInfo.getLoginCode();
			//commented By Ravindra C on 06-09-18 for prevent SYSOUT.
			//BaseLogger.log("3", userInfo, null, "In buildUploadResponse :: Template key :: [" + templateKey + "]" );
			//E12GenericUtility genericUtility = new E12GenericUtility();
			
			Document responseDom = null;
			String errorMsg = "";
			errorStr = E12GenericUtility.checkNull( errorStr );
			if ( errorStr.length() > 0 )
			{
				responseDom = genericUtility.parseString( errorStr );
				errorMsg = getErrorMessage( responseDom );
			}
			if( errorMsg != null && errorMsg.length() > 0 )			
			{
				conn.rollback();
				BaseLogger.log("3", userInfo, null, "Connection Rollback...... excelDataDBId : ["+ excelDataDBId +"]" );

				updateBatchLoad( batchId, tranSl, errorMsg, "E", excelDataDBId, conn, userInfo );
				BaseLogger.log("3", userInfo, null, "excelFilePath :: ["+ excelFilePath +"], Template key:: [" + templateKey + "]" );
				//Added By Ravindra C on 26-06-18 to check file type(xml / Excel) if Xml No error to Show  - Start
				
				//Added By Ravindra C on 03-01-18 for Store the Error file into Database And write Error File - Start
				if( ! "xml".equalsIgnoreCase( fileType ) )
				{
					//Added By Ravindra C on 10-08-19 for Enable Remote upload server related option.  - Start
					JSONObject remoteDataJson =  new JSONObject(remoteData);
					//int dataStartsFrom = TemplateDetails.get(templateKey).getDataStartsFrom(1);;
					int dataStartsFrom = (int)remoteDataJson.get("DATA_START_FORM"); 
					BaseLogger.log("3", userInfo, null,"dataStartsFrom : ["+ dataStartsFrom +"]");
					//Added By Ravindra C on 10-08-19 for Enable Remote upload server related option.  - Start
					
					dataStartsFrom = (dataStartsFrom + tranSl) - 1;
					BaseLogger.log("3", userInfo, null,"Data Starts :: [" + dataStartsFrom + "]");
					if ( errorMsg != null )
					{
						errorMsg = errorMsg.replaceAll( "</br>", "\n" );
					}
					ArrayList<String> errorList = new ArrayList<String>();
					errorList.add( excelDataDBId );
					errorList.add( errorMsg );
					//added by Ravindra c on 01-02-19 to write error file. - Strat  
					errorList.add( uploadFilePath );
					errorList.add( errorStr );
					//added by Ravindra c on 01-02-19 to write error file. - end
					respRowErrorMap.put( dataStartsFrom, errorList );
					//BaseLogger.log("3", userInfo, null,"=== respRowErrorMap ===>> :: ["+ respRowErrorMap +"]");
				}
				//Added By Ravindra C on 03-01-18 for Store the Error file into Database And write Error File - End
				
				retStatus = "Error";
			}
			else
			{
				String tranIdRef = getExistingTranId( batchId, tranSl, conn );
				if( tranIdRef != null )
				{
					conn.rollback();
					retStatus = "Rollback";
					BaseLogger.log("3", userInfo, null,"Connection Rollback......");
				}
				String tranId = getUploadedTranId( responseDom );
				updateBatchLoad( batchId, tranSl, "Uploaded successfully", "Y", tranId, conn, userInfo );
				retStatus = tranId;
			}

			sendWebSocketNotification( batchId, conn, userInfo );
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", userInfo, null,"Exception in buildUploadResponse : " + e.getMessage());
			e.printStackTrace();
			throw new ITMException( e );
		}
		BaseLogger.log("2", userInfo, null, "In generateUploadResponse : retStatus : ["+ retStatus +"]" );
		return retStatus;
	}
	
	private String getErrorMessage( Document responseDom ) throws ITMException
	{
		String errMessage = "";
		try 
		{
			if ( responseDom == null )
			{
				return "";
			}
			NodeList parentNodeList = responseDom.getElementsByTagName("Errors");
			BaseLogger.log("3", null, null,"parentNodeList.getlength = " + parentNodeList.getLength());
			parentNodeList = responseDom.getElementsByTagName("error");
			BaseLogger.log("3", null, null,"parentNodeList.getlength = " + parentNodeList.getLength());
			int cnt = parentNodeList.getLength();
			if ( cnt == 0 )
			{
				parentNodeList = responseDom.getElementsByTagName("Error");
				BaseLogger.log("3", null, null,"Error ---- parentNodeList.getlength = " + parentNodeList.getLength());
				cnt = parentNodeList.getLength();
			}
			//String temp = "";
			String errCode = "";
			String errorColumnName = "";
			String errType = "";
			String errorDescr = "";
			String errorTrace = "";
			String errMsg = "";
			String messageType = "";
			for ( int errorCnt = 0; errorCnt < cnt; errorCnt++ )
			{
				Node parentNode = parentNodeList.item( errorCnt );
				if( parentNode != null )
				{
					NodeList childNodeList = parentNode.getChildNodes();
					int	childNodeListLength = childNodeList.getLength();
					errCode = parentNode.getAttributes().getNamedItem("id") == null ? "" : parentNode.getAttributes().getNamedItem("id").getNodeValue();
					BaseLogger.log("3", null, null, "errCode : ["+ errCode +"]" );
					errType = parentNode.getAttributes().getNamedItem("type") == null ? "" : parentNode.getAttributes().getNamedItem("type").getNodeValue();
					BaseLogger.log("3", null, null, "errType : ["+ errType +"]" );
					errorColumnName = parentNode.getAttributes().getNamedItem("column_name") == null ? "" : parentNode.getAttributes().getNamedItem("column_name").getNodeValue();
					if ( errorColumnName != null && errorColumnName.length() > 0 )
					{
						errCode = ( errorColumnName + " : " + errCode );							
					}
					for (int childRow = 0; childRow < childNodeListLength; childRow++)
					{
						Node childNode = childNodeList.item(childRow);
						String childNodeName = childNode.getNodeName();
						BaseLogger.log("3", null, null, "childNodeName ["+ childNodeName +"]" );	
						int sequence = errorCnt;
						if ( childNodeName.equals("message") )
						{
							if( childNode != null && childNode.getFirstChild() != null )
							{
								//temp = (++sequence) + ". " + errCode + " : " + (childNode.getFirstChild().getNodeValue()).trim();
								if ( childNode.getFirstChild().getNodeValue() != null && childNode.getFirstChild().getNodeValue().trim().length() > 0 )
								{
									errMsg = (++sequence) + ". " + errCode + " : " + (childNode.getFirstChild().getNodeValue()).trim();
								}
							}
						}
						else if ( childNodeName.equals("description") )
						{
							if( childNode != null && childNode.getFirstChild() != null )
							{
								//temp = (++sequence) + ". " + errCode + " : " + (childNode.getFirstChild().getNodeValue()).trim();
								if ( childNode.getFirstChild().getNodeValue() != null && childNode.getFirstChild().getNodeValue().trim().length() > 0 )
								{
									errorDescr = ( childNode.getFirstChild().getNodeValue() ).trim();
								}
							}
						}
						else if ( childNodeName.equals("trace") )
						{
							if( childNode != null && childNode.getFirstChild() != null )
							{
								//temp = " [ " + (childNode.getFirstChild().getNodeValue()).trim() + " ] ";
								if ( childNode.getFirstChild().getNodeValue() != null && childNode.getFirstChild().getNodeValue().trim().length() > 0 )
								{
									errorTrace = " [ " + (childNode.getFirstChild().getNodeValue()).trim() + " ] ";
								}
							}
						}
						else if ( childNodeName.equalsIgnoreCase("type") )
						{
							//temp = "[ " + messageType + " ] " + temp;
							messageType = childNode.getFirstChild().getNodeValue();
						}
					}
					//Added by Prasad on 31/05/18 [to display trace in error message] START
					//errMessage = errMessage + temp;
					if( errMessage != null && errMessage.trim().length() > 0 )
					{
						errMessage += "</br>";
					}
					if ( ( messageType == null || messageType.trim().length() == 0 ) && errType != null && errType.length() > 0 )
					{
						messageType = errType;
					}
					if ("W".equalsIgnoreCase(messageType))
					{
						messageType = "WARNING";										
					}
					else if ("E".equalsIgnoreCase(messageType))
					{
						messageType = "ERROR";
					}
					else if ("P".equalsIgnoreCase(messageType))
					{
						messageType = "PROMPT";
					}
					else if ("X".equalsIgnoreCase(messageType))
					{
						messageType = "EXCEPTION";
					}
					if ( messageType != null && messageType.trim().length() > 0 )
					{
						errMessage += "[ " + messageType + " ] ";
					}
					if ( errMsg.length() > 0 )
					{
						errMessage += errMsg;
					}
					if ( errorDescr.length() > 0 )
					{
						errMessage += "</br>" + errorDescr;
					}
					if ( errorTrace.length() > 0 && ! "EXCEPTION".equals( messageType ) )
					{
						errMessage += "</br>" + errorTrace;
					}
					//Added by Prasad on 31/05/18 [to display trace in error message] END
				}
			}
		}
		catch (DOMException e) 
		{
			e.printStackTrace();
			throw new ITMException( e );
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException( e );
		}
		BaseLogger.log("3", null, null, "message :: ["+ errMessage +"]" );
		return errMessage;
	}
	
	private String getUploadedTranId( Document responseDom ) throws ITMException
	{
		String tranId = "";
		try 
		{
			if ( responseDom == null )
			{
				return "";
			}
			//String xmlStr="<Root><Detail>Success</Detail><TranID>0000001405</TranID></Root>";
			NodeList parentNodeList = responseDom.getElementsByTagName("Root");
			Node parentNode = parentNodeList.item(0);
			NodeList childNodeList = parentNode.getChildNodes();
			int childNodeListLength = childNodeList.getLength();
			for (int childRow = 0; childRow < childNodeListLength; childRow++)
			{
				Node childNode = childNodeList.item(childRow);
				String childNodeName = childNode.getNodeName();
				if (childNodeName.equals("TranID"))
				{
					tranId = (childNode.getFirstChild().getNodeValue()).trim();
				}
			}
			BaseLogger.log("3", null, null,"tran_id="+tranId);
		}
		catch (DOMException e) 
		{
			e.printStackTrace();
			throw new ITMException( e );
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException( e );
		}
		return tranId;
	}
	
	public void updateBatchLoad( String batchId, int tranSl, String errorMsg, String loadStatus, String tranId, Connection conn, UserInfoBean userInfo ) throws ITMException
	{
		PreparedStatement psUpdateBl = null;
		ResultSet rs = null;
		try
		{
			String update = "UPDATE BATCHLOAD SET ERROR_MSG = ?, LOAD_STAT = ?, LOAD_DATE = ?, TRAN_ID__REF = ? WHERE BATCH_ID = ? AND TRAN_SL = ?";		
			psUpdateBl = conn.prepareStatement( update );

			//Added by Prasad on 30/05/18 [check error message length] START
			if ( errorMsg != null && errorMsg.length() > 2000 )
			{
				errorMsg = errorMsg.substring( 0, 1999 );
			}
			//Added by Prasad on 30/05/18 [check error message length] END
			psUpdateBl.setString( 1, errorMsg );
			psUpdateBl.setString( 2, loadStatus );
			psUpdateBl.setTimestamp( 3, new java.sql.Timestamp( System.currentTimeMillis() ) );
			psUpdateBl.setString( 4, tranId );
			psUpdateBl.setString( 5, batchId );					
			psUpdateBl.setInt( 6, tranSl );
			int updateCnt = psUpdateBl.executeUpdate();
			psUpdateBl.close();
			psUpdateBl = null;
			BaseLogger.log("3", null, null, "BATCHLOAD : updateCnt :: ["+ updateCnt +"]" );
			
			/*if ( "E".equalsIgnoreCase( loadStatus ) )
			{
				updateThreadKeyBatchLoad( batchId, tranSl, conn );
			}*/
			if ( CommonConstants.API_FILE_DESTINATION != null && CommonConstants.API_FILE_DESTINATION.length() > 0 )
			{
				String sql = "SELECT EDI_ADDR, SUBJECT FROM BATCHLOAD WHERE BATCH_ID = ? AND TRAN_SL = ?";
				psUpdateBl = conn.prepareStatement(sql);
				psUpdateBl.setString( 1,batchId );
				psUpdateBl.setInt( 2, tranSl );
				rs = psUpdateBl.executeQuery();
				
				String ediAddr = "";
				String subject = "";
				if( rs.next() )
				{
					ediAddr = rs.getString( "EDI_ADDR" );
					subject = rs.getString( "SUBJECT" );
				}
				BaseLogger.log("3", null, null, "ediAddr : ["+ ediAddr +"], subject : ["+ subject +"]" );
				
				rs.close();
				rs = null;
				psUpdateBl.close();
				psUpdateBl = null;
				
				if ( ediAddr.equalsIgnoreCase( CommonConstants.API_FILE_DESTINATION ) && subject.length() > 0 )
				{
					updateStatusInNoSQLDB( "EDI_DATA", subject, loadStatus, userInfo );
				}
			}
			//conn.commit(); Ravi
		}
		catch( SQLException ex )
		{
			BaseLogger.log("0", null, null, "SQLException : updateBatchLoad :: ["+ ex.getMessage() +"]" );
			ex.printStackTrace();
			throw new ITMException( ex );
		}
		catch( Exception ex )
		{
			BaseLogger.log("0", null, null, "Exception : updateBatchLoad :: ["+ ex.getMessage() +"]" );
			ex.printStackTrace();
			throw new ITMException( ex );
		}
		finally
		{
			try
			{
				if( psUpdateBl != null )
				{
					psUpdateBl.close();
					psUpdateBl = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( conn != null )
				{
					conn.commit(); //Ravi
					conn = null;
				}
			}
			catch(SQLException sqlex)
			{
				sqlex.printStackTrace();
			}
		}
	}
	
	public void updateThreadKeyBatchLoad( String batchId, int transl, Connection conn ) throws ITMException
	{
		PreparedStatement psUpdateBl = null;
		try
		{
			DBAccessEJB dbAccess = new DBAccessEJB();
			String threadKey = dbAccess.getDBColumnValue( "BATCHLOAD", "BATCH_ID", (" BATCH_ID = '"+ batchId +"' AND TRAN_SL = '"+ transl +"' "), conn );
			dbAccess = null;
			threadKey = checkNull( threadKey );
			
			if ( threadKey.length() > 0 )
			{
				String update = "UPDATE BATCHLOAD SET LOAD_STAT = ?, CHG_DATE = ? WHERE THREAD_KEY = ? AND LOAD_STAT = 'N'";		
				psUpdateBl = conn.prepareStatement( update );
				psUpdateBl.setString( 1, "H" );
				psUpdateBl.setTimestamp( 2, new java.sql.Timestamp( System.currentTimeMillis() ) );
				psUpdateBl.setString( 3, threadKey );
				
				int updateCnt = psUpdateBl.executeUpdate();
				
				psUpdateBl.close();
				psUpdateBl = null;
				BaseLogger.log("3", null, null, "BATCHLOAD : updateCnt :: ["+ updateCnt +"]" );
			}
		}
		catch( SQLException ex )
		{
			BaseLogger.log("0", null, null, "SQLException : updateBatchLoad :: ["+ ex.getMessage() +"]" );
			ex.printStackTrace();
			throw new ITMException( ex );
		}
		catch( Exception ex )
		{
			BaseLogger.log("0", null, null, "Exception : updateBatchLoad :: ["+ ex.getMessage() +"]" );
			ex.printStackTrace();
			throw new ITMException( ex );
		}
		finally
		{
			try
			{
				if( psUpdateBl != null )
				{
					psUpdateBl.close();
					psUpdateBl = null;
				}
				if( conn != null )
				{
					conn.commit();
					conn = null;
				}
			}
			catch(SQLException sqlex)
			{
				sqlex.printStackTrace();
				//throw new ITMException(sqlex);
			}
		}
	}
	
	private void updateStatusInNoSQLDB( String collection, String refId, String loadStatus, UserInfoBean userInfo )
	{
		NoSQLConnection connection = null;
		try 
		{
			if ( CommonConstants.API_FILE_DESTINATION != null && CommonConstants.API_FILE_DESTINATION.length() > 0 )
			{
				NoSQLConnDriver connDriver = new NoSQLConnDriver();
				connection = connDriver.getConnectNoSQLDB( (userInfo.getEnterprise() + "_NOSQL"), CommonConstants.API_FILE_DESTINATION );
				connDriver = null;
				
				MongoDBHandler dbHandler = new MongoDBHandler( connection, collection );
				dbHandler.update( "_id", refId, "LOAD_STATUS", loadStatus );
			}
		}
		catch (SQLException e) 
		{
			BaseLogger.log( "0", userInfo, null, "SQLException :: updateStatusInNoSQLDB : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		catch (JSONException e) 
		{
			BaseLogger.log( "0", userInfo, null, "JSONException :: updateStatusInNoSQLDB : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		catch (Exception e) 
		{
			BaseLogger.log( "0", userInfo, null, "Exception :: updateStatusInNoSQLDB : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		finally
		{
			try 
			{
				if( connection != null )
				{
					connection.close();
					connection = null;
				}
			}
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
	}
	
	private String getExistingTranId( String batchId, int tranSl, Connection conn ) throws ITMException
	{
		PreparedStatement psUpdateBl = null;
		ResultSet rs = null;
		String tranIdRef = null;
		try 
		{
			String sql = "SELECT TRAN_ID__REF FROM BATCHLOAD WHERE BATCH_ID = ? AND TRAN_SL= ?";
			psUpdateBl = conn.prepareStatement(sql);
			psUpdateBl.setString( 1,batchId );
			psUpdateBl.setInt( 2, tranSl );
			rs = psUpdateBl.executeQuery();
			while(rs.next())
			{
				tranIdRef = rs.getString( "TRAN_ID__REF" );
			}
			BaseLogger.log("3", null, null, "tranIdRef [" + tranIdRef + "] for batchId[" + batchId + "] and tranSl[" + tranSl + "]" );

			rs.close();
			rs = null;
			psUpdateBl.close();
			psUpdateBl = null;
		}
		catch( SQLException ex )
		{
			BaseLogger.log("0", null, null, "SQLException : getExistingTranId :: ["+ ex.getMessage() +"]" );
			ex.printStackTrace();
			throw new ITMException( ex );
		}
		catch( Exception ex )
		{
			BaseLogger.log("0", null, null, "Exception : getExistingTranId :: ["+ ex.getMessage() +"]" );
			ex.printStackTrace();
			throw new ITMException( ex );
		}
		finally 
		{
			try 
			{
				if ( psUpdateBl != null )
				{
					psUpdateBl.close();
					psUpdateBl = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return tranIdRef;
	}
	
	public void sendWebSocketNotification( String batchId, Connection conn, UserInfoBean userInfo )
	{
		try 
		{
			//Changed by Prasad on 11/09/19 [to get upload data] START
			/*if ( uploadFile == null )
			{
				//AppConnectParm appConnect = new AppConnectParm();
				//InitialContext ctx = new InitialContext(appConnect.getProperty());
				//uploadFile = (UploadFileLocal) ctx.lookup( "ibase/UploadFileEJB/local" );
				uploadFile = new UploadFileEJB();
			}
			String retResult = uploadFile.getUploadStatusData( batchId, userInfo, conn );*/
			BckgrndProcessEJB bckgrndProcessEJB = new BckgrndProcessEJB();
			String retResult = bckgrndProcessEJB.getAllBckgrndJobStatus( userInfo, null, batchId, conn );
			bckgrndProcessEJB = null;
			//Changed by Prasad on 11/09/19 [to get upload data] END

			ArrayList<String> currentUserList = new ArrayList<String>();
			currentUserList.add(userId);

			JSONObject wsMessage = new JSONObject();
			JSONArray userIds = new JSONArray(currentUserList);
			//added by Ravindra C on 11-09-19 for upload utility progress display(refresh) - Start
			JSONObject webSocketMsgWithType = new JSONObject();

			wsMessage.put("user_ids", userIds);
			wsMessage.put("message", retResult);

			//added by Ravindra C on 11-09-19 for upload utility progress display(refresh) - Start
			webSocketMsgWithType.put( "type", String.valueOf( WebSocketMessageType.UPLOAD_UTILITY_STATUS ) );
			webSocketMsgWithType.put( "data", retResult );
			wsMessage.put("message", webSocketMsgWithType);
			//added by Ravindra C on 11-09-19 for upload utility progress display(refresh) - End

			ClientWebsocketNotification clientWebsocketNotification = new ClientWebsocketNotification();
			clientWebsocketNotification.sendMessage(wsMessage);
		}
		catch (JSONException e) 
		{
			BaseLogger.log( "0", userInfo, null, "JSONException in sendWebSocketNotification : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		catch (RemoteException e) 
		{
			BaseLogger.log( "0", userInfo, null, "RemoteException in sendWebSocketNotification : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		catch (ITMException e) 
		{
			BaseLogger.log( "0", userInfo, null, "ITMException in sendWebSocketNotification : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
	}
	
	//Added By Ravindra C on 03-01-18 for Store the Error file into Database And write Error File
	//private void moveErrorFile( String excelFilePath ) throws IOException
	private void moveErrorFile( String excelFilePath, String userId ) throws IOException
	{
		try 
		{
			BaseLogger.log("3", null, null, "excelFilePath - [" + excelFilePath + "]" );
			File file = new File( excelFilePath );
			String fileName = file.getName();
			if ( file.exists() )
			{
				String errorFilePath = CommonConstants.TEMP_FOLDER + File.separator + "Failed" + File.separator + userId ;
				File errorFile = new File( errorFilePath );
				BaseLogger.log("3", null, null, "errorFile - [" + errorFile + "]" );
				if ( ! errorFile.exists() )
				{
					errorFile.mkdirs();
				}
				BaseLogger.log("3", null, null, "errorFilePath New- [" + errorFilePath + "]" );
				file.renameTo( new File( errorFile, fileName ) );
				BaseLogger.log("3", null, null, "fileName - [" + fileName + "]" );
			}
		} 
		catch (Exception e) 
		{
			BaseLogger.log("0", null, null,"Exception----on move error file---["+e.getMessage()+"]");
		}
	}
	
	//Commented by Ravindrar C on 03-01-18 for Store the Error file into Database And write Error File- Start
	/*private void writeErrorInFile( String excelFilePath, String templateKey, int tranSl, String errorMsg, String excelDataDBId )
	{
		try 
		{
			File file = new File( excelFilePath );
			String filename = file.getName();

			String errorFilePath = CommonConstants.TEMP_FOLDER + File.separator + "Failed" + File.separator + userId + File.separator + filename;
			File errorfile = new File( errorFilePath );
			if( ! errorfile.exists() && file.exists() )
			{
				moveErrorFile( excelFilePath );
				errorfile = new File( errorFilePath );
			}
			int matrixRowNo = TemplateDetails.get(templateKey).getMatrixRowNo( 1 );
			BaseLogger.log("3", userInfo, null, "matrixRowNo::[" + matrixRowNo + "]" );

			String sheetName = TemplateDetails.get(templateKey).getSheetName( 1 );
			BaseLogger.log("3", userInfo, null, "sheetName::[" + sheetName + "]" );

			int headingRowNo = TemplateDetails.get(templateKey).getHeadingRowNo(1);
			BaseLogger.log("3", userInfo, null, "Heading row number::[" + headingRowNo + "]" );

			int dataStartsFrom = TemplateDetails.get(templateKey).getDataStartsFrom(1);
			BaseLogger.log("3", userInfo, null, "Data Starts from number:: [" + dataStartsFrom + "]" );
			dataStartsFrom = (dataStartsFrom + tranSl) - 1;
			BaseLogger.log("3", userInfo, null,"Data Starts :: [" + dataStartsFrom + "]");

			if( errorfile.exists() )
			{
				//Added by Prasad on 31/05/18 [to display proper error message in excel file] START
				if ( errorMsg != null )
				{
					errorMsg = errorMsg.replaceAll( "</br>", "\n" );
				}
				//Added by Prasad on 31/05/18 [to display proper error message in excel file] END
				String errorfilename = errorfile.getName();
				BaseLogger.log("3", userInfo, null,"errorfile FILE NAME ::[" + errorfilename + "]");
				String downloadedPath = errorfile.getAbsolutePath();
				BaseLogger.log("3", userInfo, null,"errorfile PATH::[" + downloadedPath + "]");

				FileInputStream fsIP = new FileInputStream(new File(downloadedPath));
				BaseLogger.log("3", userInfo, null,"errorfile fsIP::[" + fsIP + "]");

				HSSFWorkbook wb = new HSSFWorkbook(fsIP);
				//Added by Prasad on 07/05/18 [to adding new Errors sheet and setting style to error row] START
				HSSFCellStyle borderStyle = wb.createCellStyle();

				borderStyle.setBorderLeft( HSSFCellStyle.BORDER_THIN );             
				borderStyle.setBorderRight( HSSFCellStyle.BORDER_THIN );            
				borderStyle.setBorderTop( HSSFCellStyle.BORDER_THIN );              
				borderStyle.setBorderBottom( HSSFCellStyle.BORDER_THIN );

				borderStyle.setBottomBorderColor( IndexedColors.RED.getIndex() );
				borderStyle.setTopBorderColor( IndexedColors.RED.getIndex() );
				borderStyle.setLeftBorderColor( IndexedColors.RED.getIndex() );
				borderStyle.setRightBorderColor( IndexedColors.RED.getIndex() );

				Font font = wb.createFont();
				font.setColor( IndexedColors.RED.getIndex() );
				borderStyle.setFont( font );

				if ( matrixRowNo == -1 )
				{
					HSSFSheet dataSheet = wb.getSheet( sheetName );
					HSSFRow dataRow = dataSheet.getRow( dataStartsFrom );
					try 
					{
						for ( int col = 0; col < dataRow.getLastCellNum(); col++ )
						{
							HSSFCell cell = dataRow.getCell( col );
							if ( cell != null )
							{
								cell.setCellStyle( borderStyle );
							}
						}
					}
					catch (Exception e) 
					{
						BaseLogger.log("3", userInfo, null, "Exception while highlighting row in excel file ["+ e.getMessage() +"]" );
						e.printStackTrace();
					}
					int rowNum = dataRow.getLastCellNum();
					dataSheet.getRow( headingRowNo ).createCell( rowNum );
					dataSheet.getRow( headingRowNo ).getCell( rowNum ).setCellValue( "ERROR MSG" );

					dataRow.createCell( rowNum );
					dataRow.getCell( rowNum ).setCellValue( errorMsg );
				}
				else
				{
					BaseLogger.log("3", userInfo, null, "Matrix file" );
				}

				HSSFSheet worksheet = wb.getSheet( "ERRORS" );
				if ( worksheet == null )
				{
					worksheet = wb.createSheet( "ERRORS" );
				}
				HSSFRow row = worksheet.getRow( 0 );
				if ( row == null )
				{
					row = worksheet.createRow( 0 );

					HSSFCell cell = row.createCell( 0 );
					cell.setCellValue( "PRIMARY_KEY" );

					cell = row.createCell( 1 );
					cell.setCellValue( "ERROR_MSG" );
				}

				int rowNum = worksheet.getLastRowNum();
				if ( rowNum == 0 )
				{
					rowNum = 1;
				}
				else
				{
					rowNum += 1;
				}
				BaseLogger.log("3", userInfo, null, "rowNum - ["+ rowNum +"]" );
				row = worksheet.getRow( rowNum );
				if ( row == null )
				{
					row = worksheet.createRow( rowNum );

					HSSFCell cell = row.createCell( 0 );
					cell.setCellValue( excelDataDBId );

					cell = row.createCell( 1 );
					cell.setCellValue( errorMsg );
				}
				//Added by Prasad on 07/05/18 [to adding new Errors sheet and setting style to error row] END
				fsIP.close();
				FileOutputStream output_file = new FileOutputStream(new File(downloadedPath));
				BaseLogger.log("3", userInfo, null,"Inside errorfile output_file::[" + output_file + "]");
				wb.write(output_file);
				output_file.flush();
				output_file.close();
			}
			else
			{
				BaseLogger.log("3", userInfo, null, "Error file not exist" );
			}
		}
		catch (FileNotFoundException e) 
		{
			e.printStackTrace();
		}
		catch (IOException e) 
		{
			e.printStackTrace();
		}
	}*/
	//Commented by Ravindrar C on 03-01-18 for Store the Error file into Database And write Error File- End
	
	private void updateBatchIdInTransTable( String tableName, String tranIdCol, String batchId, String tranId, Connection conn ) throws ITMException
	{
		PreparedStatement psUpdateBl = null;
		try
		{
			if( tableName != null && tranIdCol != null && tranIdCol.trim().length() > 0 )
			{
				String query = "UPDATE " + tableName.trim() + " SET BATCH_ID = ? WHERE " + tranIdCol.trim() + " = ? ";
				psUpdateBl = conn.prepareStatement(query);
				psUpdateBl.clearParameters();
				psUpdateBl.setString( 1, batchId );		
				psUpdateBl.setString( 2, tranId );				
				int cnt = psUpdateBl.executeUpdate();
				BaseLogger.log("3", null, null, "batchId updated successfully in [" + cnt + "] records" );
				psUpdateBl.close();
				psUpdateBl = null;
			}
		}
		catch( SQLException ex )
		{
			BaseLogger.log("0", null, null, "SQLException : updateBatchIdInTransTable :: ["+ ex.getMessage() +"]" );
			ex.printStackTrace();
			throw new ITMException( ex );
		}
		catch( Exception ex )
		{
			BaseLogger.log("0", null, null, "Exception : updateBatchIdInTransTable :: ["+ ex.getMessage() +"]" );
			ex.printStackTrace();
			throw new ITMException( ex );
		}
		finally
		{
			try
			{
				if( psUpdateBl != null )
				{
					psUpdateBl.close();
					psUpdateBl = null;
				}
				if( conn != null )
				{
					conn.commit();
				}
			}
			catch(SQLException sqlex)
			{
				sqlex.printStackTrace();
				throw new ITMException(sqlex);
			}
		}
	}
	
	private ArrayList<String> getTransInfo( String winName, Connection conn ) throws ITMException
	{
		ArrayList<String> transInfoList = new ArrayList<String>();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String sqlStr = "SELECT TRAN_ID_COL, TABLE_NAME, TABLE_NAME_DET1, TABLE_NAME_DET2, TABLE_NAME_DET3 FROM TRANSETUP WHERE UPPER(TRAN_WINDOW) = UPPER( ? )";
			pstmt = conn.prepareStatement( sqlStr );
			pstmt.setString( 1, winName );
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				transInfoList.add(rs.getString( "TRAN_ID_COL" ));
				transInfoList.add(rs.getString( "TABLE_NAME" ));
				transInfoList.add(rs.getString( "TABLE_NAME_DET1" ));
				transInfoList.add(rs.getString( "TABLE_NAME_DET2" ));
				transInfoList.add(rs.getString( "TABLE_NAME_DET3" ));
			}
		}
		catch( SQLException ex )
		{
			BaseLogger.log("0", null, null, "SQLException : getTransInfo :: ["+ ex.getMessage() +"]" );
			ex.printStackTrace();
			throw new ITMException( ex );
		}
		catch( Exception ex )
		{
			BaseLogger.log("0", null, null, "Exception : getTransInfo :: ["+ ex.getMessage() +"]" );
			ex.printStackTrace();
			throw new ITMException( ex );
		}
		finally
		{
			try 
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		BaseLogger.log("2", null, null, "transInfoList : ["+ transInfoList +"]" );
		return transInfoList;
	}
	
	private boolean isBatchIdColExist( String tableName, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean isBatchIdColExist = false;
		if( tableName != null )
		{
			try
			{
				String batchIdColSql = "SELECT BATCH_ID FROM "+ tableName.trim() +" WHERE ROWNUM <1 ";
				pstmt = conn.prepareStatement(batchIdColSql);
				rs = pstmt.executeQuery();
				isBatchIdColExist = true;
				pstmt.close();
				pstmt = null;
			}
			catch( SQLException extc1 )
			{
				//extc1.printStackTrace();
				//throw new ITMException(extc1);
			}
			catch( Exception extc1 )
			{
				extc1.printStackTrace();
			}
			finally
			{
				try
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
				}
				catch( SQLException sqlex )
				{
					sqlex.printStackTrace();
					throw new ITMException(sqlex);
				}
			}
		}
		BaseLogger.log("2", null, null, "isBatchIdColExist : ["+ isBatchIdColExist +"]" );
		return isBatchIdColExist;
	}
	
	private ArrayList<Integer> getBatchLoadDet( String batchId, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ArrayList<Integer> batchLoadDet = new ArrayList<Integer>();
		try
		{
			String sql = "SELECT MIN(BATCHLOADDET.OBJ_SL), MAX( BATCHLOADDET.OBJ_SL ) FROM BATCHLOADDET WHERE BATCHLOADDET.BATCH_ID = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,batchId.trim()); 
			rs = pstmt.executeQuery(); 
			if(rs.next())
			{
				batchLoadDet.add( rs.getInt(1) );
				batchLoadDet.add( rs.getInt(2) );
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(SQLException se)
		{
			BaseLogger.log("0", null, null, "SQLException : getBatchLoadDet :: ["+ se.getMessage() +"]" );
			se.printStackTrace();
			throw new ITMException(se);
		}
		catch(Exception ex)
		{
			BaseLogger.log("0", null, null, "Exception : getBatchLoadDet :: ["+ ex.getMessage() +"]" );
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(SQLException sqlex)
			{
				sqlex.printStackTrace();
				throw new ITMException(sqlex);
			}
		}
		BaseLogger.log("2", null, null, "batchLoadDet : ["+ batchLoadDet +"]" );
		return batchLoadDet;
	}
	
	private int getMinTranSL( String batchId, Connection conect ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int minTranSl = -1;
		try 
		{
			String sql = "SELECT MIN(TRAN_SL) AS TRAN_SL FROM BATCHLOAD WHERE BATCH_ID = ? HAVING MIN(TRAN_SL) IS NOT NULL";
			pstmt = conect.prepareStatement(sql);
			pstmt.setString( 1, batchId );
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				minTranSl = rs.getInt("TRAN_SL");
			}
		}
		catch( SQLException ex )
		{
			BaseLogger.log("0", null, null, "SQLException : getMinTranSL :: ["+ ex.getMessage() +"]" );
			ex.printStackTrace();
			throw new ITMException( ex );
		}
		catch( Exception ex )
		{
			BaseLogger.log("0", null, null, "Exception : getMinTranSL :: ["+ ex.getMessage() +"]" );
			ex.printStackTrace();
			throw new ITMException( ex );
		}
		finally 
		{
			try 
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null, "minTranSl : ["+ minTranSl +"]" );
		return minTranSl;
	}
	
	private int getMaxTranSL( String winName, String batchId, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int maxTranSl = 0;
		try
		{
			String sqlmax = "SELECT MAX(TRAN_SL) FROM BATCHLOAD WHERE WIN_NAME= ? AND BATCH_ID= ?";
			pstmt = conn.prepareStatement(sqlmax);
			pstmt.setString( 1, winName ); 
			pstmt.setString( 2, batchId );
			rs = pstmt.executeQuery(); 
			if(rs.next())
			{
				maxTranSl = rs.getInt(1);
			}
			rs.close();
			rs =null;
			pstmt.close();
			pstmt = null;
		}
		catch( SQLException se33 )
		{
			BaseLogger.log("0", null, null, "SQLException : getMaxTranSL : ["+ se33.getMessage() +"]" );
			se33.printStackTrace();
			throw new ITMException(se33);
		}
		catch(Exception ex33)
		{
			BaseLogger.log("0", null, null, "Exception : getMaxTranSL : ["+ ex33.getMessage() +"]" );
			ex33.printStackTrace();
			throw new ITMException(ex33);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch( SQLException sqlex )
			{
				sqlex.printStackTrace();
				throw new ITMException(sqlex);
			}
		}
		BaseLogger.log("2", null, null, "maxTranSl : ["+ maxTranSl +"]" );
		return maxTranSl;
	}
	
	private String getExcelDataDBId( String uploadData )
	{
		String dbId = "";
		try 
		{
			//E12GenericUtility genericUtility = new E12GenericUtility();
			Document uploadDataDom = genericUtility.parseString( uploadData );
			Node parentNode = uploadDataDom.getElementsByTagName( "Detail1" ).item( 0 );
			dbId = parentNode.getAttributes().getNamedItem( "dbID" ).getNodeValue();
		}
		catch (ITMException e) 
		{
			e.printStackTrace();
		}
		catch (DOMException e) 
		{
			e.printStackTrace();
		}
		BaseLogger.log("2", null, null, "dbId : ["+ dbId +"]" );
		return dbId;
	}
	
	//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] START
	private String getFormName( String formNo )
	{
		String formName = "";
		if ( formNameMap != null && formNameMap.get( formNo ) != null )
		{
			formName = formNameMap.get( objName + "::" + formNo );
		}
		return formName;
	}
	//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] END
	
	//Added By Ravindra C on 10-08-19 for Remote upload server related option
	//public String uploadBatchData( String objName, String tableName, String tranIdCol, String filePath, String fileType, String templateKey, String batchId, boolean isBatchIdColExist, String xtraParams, UserInfoBean userInfo, String tempName, String sessionId, String loadMode ) throws ITMException
	public String uploadBatchData( String objName, String tableName, String tranIdCol, String filePath, String fileType, String templateKey, String batchId, boolean isBatchIdColExist, String xtraParams, UserInfoBean userInfo, String tempName, String sessionId, String loadMode, String remoteData ) throws ITMException
	{
		ResultSet rs = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		String retStatus = "";
		String xmlFilePath = "";
		try 
		{
			ConnDriver conndriver = new ConnDriver();
			String transDB = "";
			batchId = ( batchId == null ) ? "" : batchId.trim();

			if( userInfo != null )
			{
				transDB = userInfo.getTransDB();
				userId = userInfo.getLoginCode();
			}
			conn = conndriver.getConnectDB(transDB);
			conn.setAutoCommit( false );
			conndriver = null;
			
			BaseLogger.log("3",userInfo,null,  "tableName : ["+ tableName +"], tranIdCol : ["+ tranIdCol +"]" );
			
			xmlFilePath = CommonConstants.JBOSSHOME + File.separator + "XLS_UPLOAD" + File.separator + userId + File.separator + batchId;
			BaseLogger.log("3",userInfo,null, "xmlFilePath : ["+ xmlFilePath +"]" );
			
			setObjFormDetail(objName, userInfo);
			
			//AppConnectParm appConnect = new AppConnectParm();
			//InitialContext ctx = new InitialContext(appConnect.getProperty());
			//UploadFileLocal uploadFile = (UploadFileLocal) ctx.lookup( "ibase/UploadFileEJB/local" );
			UploadFileEJB uploadFile = new UploadFileEJB();
			
			ExecutorService executor = Executors.newFixedThreadPool( 50 );
			
			String uploadFileName = "";
			String sql = "SELECT BATCH_ID, TRAN_SL FROM BATCHLOAD WHERE BATCH_ID = ?";
			pstmt = conn.prepareStatement( sql );
			pstmt.setString( 1, batchId );
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				int tranSl = rs.getInt( 2 );
				BaseLogger.log("3",userInfo, null, "batchId : ["+ batchId +"], transl : [" + tranSl + "]" );

				//Added By Ravindra C on 12-09-2020 for Stop upload Thread.
				if ( cancelledUploadThreads == null || ! cancelledUploadThreads.contains( batchId ) )
				{
					uploadFileName = batchId + "_" + tranSl + ".xml";
					String uploadFilePath = xmlFilePath + File.separator + uploadFileName;

					File tempXMLFile = new File( uploadFilePath );
					if ( tempXMLFile.exists() )
					{
						String uploadData = readInputTempXMLFile( batchId, uploadFilePath );
						if ( uploadData != null && uploadData.length() > 0 )
						{
							//tempXMLFile.delete();
							String excelDataDBId = getExcelDataDBId( uploadData );
							BaseLogger.log("3",userInfo,null, "excelDataDBId : ["+ excelDataDBId +"]" );
							if ( "P".equalsIgnoreCase( loadMode ) )
							{
								Runnable uploadThread = new UploadThread( tableName, tranIdCol, excelDataDBId, uploadData, fileType, filePath, uploadFilePath, batchId, tranSl, templateKey, isBatchIdColExist, userInfo, tempName, sessionId, respRowErrorMap, remoteData, isDataUploadAutoConfirm );
								executor.execute( uploadThread );
							}
							else
							{
								String errStr = saveData( uploadData, userInfo, conn );
								//Added By Ravindra C on 26-06-18 to check file type(xml / Excel)
								//Added By Ravindra C on 10-08-19 for Remote upload server related option.
								//retStatus = generateUploadResponse( batchId, tranSl, errStr, excelDataDBId, filePath, templateKey, conn, userInfo, uploadFile, fileType, uploadFilePath );
								retStatus = generateUploadResponse( batchId, tranSl, errStr, excelDataDBId, filePath, templateKey, conn, userInfo, uploadFile, fileType, uploadFilePath, remoteData );
								if( ! "Rollback".equalsIgnoreCase( retStatus ) && ! "Error".equalsIgnoreCase( retStatus ) )
								{
									//boolean isBatchIdColExist = isBatchIdColExist( tableName, conn );
									BaseLogger.log( "3", userInfo, null, "isBatchIdColExist : ["+ isBatchIdColExist +"]" );
									if( isBatchIdColExist && tableName != null && tranIdCol != null && tranIdCol.trim().length() > 0 )
									{
										tranIdCol = tranIdCol.toLowerCase();
										//In success case : retStatus - is tranId
										updateBatchIdInTransTable( tableName, tranIdCol, batchId, retStatus, conn );
									}
									retStatus = "Success";
								}
							}
						}
					}
				}
				//Added By Ravindra C on 12-09-2020 for Stop upload Thread - Start
				else
				{
					updateBatchLoad( batchId, tranSl, "Cancelled by user", "C", "", conn, userInfo );
				}
				//Added By Ravindra C on 12-09-2020 for Stop upload Thread - End
			}
			executor.shutdown();
			while ( ! executor.isTerminated() ) {}
			BaseLogger.log("3",userInfo,null, "Finished all uploads..");
			
			//Added By Ravindra C on 12-09-2020 for Stop upload Thread - Start
			if ( cancelledUploadThreads != null && cancelledUploadThreads.contains( batchId ) )
			{
				cancelledUploadThreads.remove( batchId );
			}
			//Added By Ravindra C on 12-09-2020 for Stop upload Thread - End
			
			//Added By Ravindra C on 10-08-18 for Store the Error file into Database - Start
			if ( ! "xml".equalsIgnoreCase( fileType ) && respRowErrorMap != null && respRowErrorMap.size() > 0 )
			{
				//Added By Ravindra C on 10-08-19 for Remote upload server related option.
				//String errorFileResp = writeErrorExcelFile(respRowErrorMap, filePath, templateKey, userId, objName )
				String errorFileResp = writeErrorExcelFile( respRowErrorMap, filePath, templateKey, userId, objName, remoteData );
				BaseLogger.log("3",userInfo,null, "errorFileResp : ["+ errorFileResp +"]");
				//Added By Ravindra C on 10-08-18 for Store the Error file into Database - Start
				uploadDocument( filePath, batchId, tempName, sessionId, userInfo );
				//Added By Ravindra C on 10-08-18 for Store the Error file into Database - End
			}
			//Commented by Ravindrar C on 03-01-18 for Store the Error file into Database And write Error File- End
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( conn != null )
			{
				conn.close();
				conn = null;
			}
			uploadFile = null;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",userInfo,null, "Exception : [CreateEJB][getErrorString] \n:==>"+e.getMessage());
			e.printStackTrace();
			try 
			{
				if( conn != null )
				{
					conn.rollback();
					
					conn.close();
					conn = null;
					BaseLogger.log("3",userInfo,null, "<!@#>closing connection done");
				}
			}
			catch (SQLException ex) 
			{
				ex.printStackTrace();
				throw new ITMException(ex);
			}

			File excelFile = new File( filePath );
			BaseLogger.log("3",userInfo,null,  "excelFile : ["+ excelFile +"]" );
			if ( excelFile.exists() )
			{
				excelFile.delete();
				BaseLogger.log("3",userInfo,null, "excelFile file deleted");
			}
			
			File xmlFolderDir = new File( xmlFilePath );
			if ( xmlFolderDir.exists() )
			{
				xmlFolderDir.delete();
				BaseLogger.log("3",userInfo,null, "xmlFolderDir deleted");
			}

			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			} 
			catch (SQLException e) 
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
			
			File excelFile = new File( filePath );
			//BaseLogger.log("3",userInfo,null,  "excelFile : ["+ excelFile +"]" );
			if ( excelFile.exists() )
			{
				excelFile.delete();
				BaseLogger.log("3",userInfo,null, "excelFile file deleted");
			}
			
			File xmlFolderDir = new File( xmlFilePath );
			if ( xmlFolderDir.exists() )
			{
				xmlFolderDir.delete();
				BaseLogger.log("3",userInfo,null, "xmlFolderDir deleted");
			}
		}
		BaseLogger.log("2",userInfo,null, "<!@#>END OF MASTER APPLY......retStatus ==> ["+ retStatus +"]");

		return "success";
	}
	
	private void uploadDocument( String filePath, String batchId, String tempName, String sessionId, UserInfoBean userInfo )
	{
		try 
		{
			File file = new File( filePath );
			BaseLogger.log("3",userInfo,null, "filePath : ["+ filePath +"]");

			String fileName = file.getName();
			BaseLogger.log("3",userInfo,null, "fileName : [" + fileName + "]");

			String errorFilePath = CommonConstants.TEMP_FOLDER + File.separator + "Failed" + File.separator + userId + File.separator + fileName;
			BaseLogger.log("3",userInfo,null, "errorFilePath : ["+ errorFilePath +"]");

			File errorfile = new File( errorFilePath );
			if( errorfile != null && errorfile.exists() )
			{
				String docTypeAttach = "error";
				String batchObjName = "I-BL";
				String uploadResp = callDocumentHandlerServlet( batchObjName, batchId, tempName, fileName, sessionId, errorFilePath, docTypeAttach, userInfo );
				BaseLogger.log("3",userInfo,null, "uploadResp ::::: ["+ uploadResp +"]");
			}
		} 
		catch ( Exception e ) 
		{
			BaseLogger.log("0",userInfo,null,  "callDocumentHandlerServlet IOException ::: ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
	}
	
	//Added By Ravindra C on 05-06-2018 for upload Batch Data - [Start]
	/**
	 * @throws ITMException 
	 * 
	 */
	//changed By Ravindra c on 08-09-18 to Store Download Excel error file.
	//public String uploadBatchData( String objName, String tableName, String tranIdCol, String filePath, String fileType, String templateKey, String batchId, boolean isBatchIdColExist, String xtraParams, UserInfoBean userInfo ) throws ITMException
	//Added By Ravindra C on 10-08-19 for Remote upload server related option.
	//public String uploadBatchData( String objName, String tableName, String tranIdCol, String filePath, String fileType, String templateKey, String batchId, boolean isBatchIdColExist, String xtraParams, UserInfoBean userInfo, String tempName, String sessionId ) throws ITMException
	public String uploadBatchData( String objName, String tableName, String tranIdCol, String filePath, String fileType, String templateKey, String batchId, boolean isBatchIdColExist, String xtraParams, UserInfoBean userInfo, String tempName, String sessionId, String remoteData ) throws ITMException
	{ 
		this.objName = objName;
		ResultSet rs = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		String retStatus = "";
		String xmlFilePath = "";
		try 
		{
			ConnDriver conndriver = new ConnDriver();
			String transDB = "";
			batchId = ( batchId == null ) ? "" : batchId.trim();

			if( userInfo != null )
			{
				transDB = userInfo.getTransDB();
				userId = userInfo.getLoginCode();
			}
			conn = conndriver.getConnectDB(transDB);
			conn.setAutoCommit( false );
			conndriver = null;
			
			BaseLogger.log("3", userInfo, null, "tableName : ["+ tableName +"], tranIdCol : ["+ tranIdCol +"]" );
			
			xmlFilePath = CommonConstants.JBOSSHOME + File.separator + "XLS_UPLOAD" + File.separator + userId + File.separator + batchId;
			BaseLogger.log("3", userInfo, null, "xmlFilePath : ["+ xmlFilePath +"]" );
			
			//AppConnectParm appConnect = new AppConnectParm();
			//InitialContext ctx = new InitialContext(appConnect.getProperty());
			//UploadFileLocal uploadFile = (UploadFileLocal) ctx.lookup( "ibase/UploadFileEJB/local" );
			UploadFileEJB uploadFile = new UploadFileEJB();
			
			String uploadFileName = "";
			String sql = "SELECT BATCH_ID, TRAN_SL FROM BATCHLOAD WHERE BATCH_ID = ?";
			pstmt = conn.prepareStatement( sql );
			pstmt.setString( 1, batchId );
			rs = pstmt.executeQuery();

			while( rs.next() )
			{
				int tranSl = rs.getInt( 2 );
				BaseLogger.log("3", userInfo, null, "batchId : ["+ batchId +"] transl : [" + tranSl + "]" );

				uploadFileName = batchId + "_" + tranSl + ".xml";
				String uploadFilePath = xmlFilePath + File.separator + uploadFileName;
				
				File tempXMLFile = new File( uploadFilePath );
				if ( tempXMLFile.exists() )
				{
					String excelData = readInputTempXMLFile( batchId, uploadFilePath );
					String errStr = saveData( excelData, userInfo, conn );
					String excelDataDBId = getExcelDataDBId( excelData );
					BaseLogger.log("3", userInfo, null, "excelDataDBId : ["+ excelDataDBId +"]" );
					//Added By Ravindra C on 26-06-18 to check file type(xml / Excel)
					//retStatus = generateUploadResponse( batchId, tranSl, errStr, excelDataDBId, excelFilePath, templateKey, conn, userInfo, uploadFile );
					//Added By Ravindra C on 10-08-19 for Remote upload server related option.
					//retStatus = generateUploadResponse( batchId, tranSl, errStr, excelDataDBId, filePath, templateKey, conn, userInfo, uploadFile, fileType, uploadFilePath );
					retStatus = generateUploadResponse( batchId, tranSl, errStr, excelDataDBId, filePath, templateKey, conn, userInfo, uploadFile, fileType, uploadFilePath, remoteData );
					tempXMLFile.delete(); // Temporary commented By Ravindra C.
				}

				if( ! "Rollback".equalsIgnoreCase( retStatus ) && ! "Error".equalsIgnoreCase( retStatus ) )
				{
					//boolean isBatchIdColExist = isBatchIdColExist( tableName, conn );
					BaseLogger.log("3", userInfo, null, "isBatchIdColExist : ["+ isBatchIdColExist +"]" );
					if( isBatchIdColExist && tableName != null && tranIdCol != null && tranIdCol.trim().length() > 0 )
					{
						tranIdCol = tranIdCol.toLowerCase();
						//In success case : retStatus - is tranId
						updateBatchIdInTransTable( tableName, tranIdCol, batchId, retStatus, conn );
					}
					retStatus = "Success";
				}
			}
			//Commented by Ravindrar C on 03-01-18 for Store the Error file into Database And write Error File- Start
			if(!".xml".equalsIgnoreCase(fileType) && respRowErrorMap.size() > 0 )
			{
				//Added By Ravindra C on 10-08-19 for Remote upload server related option.
				//String errorFileResp = writeErrorExcelFile(respRowErrorMap, filePath, templateKey, userId, objName );
				String errorFileResp = writeErrorExcelFile(respRowErrorMap, filePath, templateKey, userId, objName, remoteData );
				BaseLogger.log("3", userInfo, null,"errorFileResp ==> ["+ errorFileResp +"]");
			}
			//Commented by Ravindrar C on 03-01-18 for Store the Error file into Database And write Error File- End
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( conn != null )
			{
				conn.close();
				conn = null;
			}
			uploadFile = null;
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo, null,"Exception : [CreateEJB][getErrorString] \n:==>"+e.getMessage());
			e.printStackTrace();
			try 
			{
				if( conn != null )
				{
					conn.rollback();
					
					conn.close();
					conn = null;
					BaseLogger.log("0", userInfo, null,"<!@#>closing connection done");
				}
			}
			catch (SQLException ex) 
			{
				ex.printStackTrace();
				throw new ITMException(ex);
			}

			File excelFile = new File( filePath );
			BaseLogger.log("3", userInfo, null, "excelFile : ["+ excelFile +"]" );
			if ( excelFile.exists() )
			{
				excelFile.delete();
				BaseLogger.log("3", userInfo, null,"excelFile file deleted");
			}
			
			File xmlFolderDir = new File( xmlFilePath );
			if ( xmlFolderDir.exists() )
			{
				xmlFolderDir.delete();
				BaseLogger.log("3", userInfo, null,"xmlFolderDir deleted");
			}

			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			} 
			catch (SQLException e) 
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
			
			File excelFile = new File( filePath );
			//BaseLogger.log("3", userInfo, null, "excelFile : ["+ excelFile +"]" );
			if ( excelFile.exists() )
			{
				excelFile.delete();
				BaseLogger.log("3", userInfo, null,"excelFile file deleted");
			}
			
			File xmlFolderDir = new File( xmlFilePath );
			if ( xmlFolderDir.exists() )
			{
				xmlFolderDir.delete();
				BaseLogger.log("3", userInfo, null,"xmlFolderDir deleted");
			}
		}
		BaseLogger.log("3", userInfo, null,"<!@#>END OF MASTER APPLY......retStatus ==> ["+ retStatus +"]");
		//Added By Ravindra C on 10-08-18 for Store the Error file into Database - Start
		try 
		{
			File file = new File( filePath );
			BaseLogger.log("3", userInfo, null,"filePath : ["+ filePath +"]");

			String fileName = file.getName();
			BaseLogger.log("3", userInfo, null,"fileName : [" + fileName + "]");

			String errorFilePath = CommonConstants.TEMP_FOLDER + File.separator + "Failed" + File.separator + userId + File.separator + fileName;
			BaseLogger.log("3", userInfo, null,"errorFilePath : ["+ errorFilePath +"]");

			File errorfile = new File( errorFilePath );
			if( errorfile != null && errorfile.exists() )
			{
				String docTypeAttach = "error";
				String batchObjName = "I-BL";
				String uploadResp = callDocumentHandlerServlet( batchObjName, batchId, tempName, fileName, sessionId, errorFilePath, docTypeAttach, userInfo );
				BaseLogger.log("3", userInfo, null,"uploadResp ::::: ["+ uploadResp +"]");
			}
		} 
		catch ( Exception e ) 
		{
			BaseLogger.log("3", userInfo, null, "callDocumentHandlerServlet IOException ::: ["+ e.getMessage() +"]" );
			e.printStackTrace();
		} 
		//Added By Ravindra C on 10-08-18 for Store the Error file into Database - End

		return "success";
	}
	
	//Added By Ravindra C on 10-08-19 for Remote upload server related option.
	//public HashMap<Integer, ArrayList<String>> uploadData(String uploadData, String tableName, String tranIdCol, String pkValue, String filePath, String fileType, String uploadFilePath, String batchId, int tranSl, String templateKey, boolean isBatchIdColExist, UserInfoBean userInfo, String tempName, String sessionId) throws ITMException
	public HashMap<Integer, ArrayList<String>> uploadData(String uploadData, String tableName, String tranIdCol, String pkValue, String filePath, String fileType, String uploadFilePath, String batchId, int tranSl, String templateKey, boolean isBatchIdColExist, UserInfoBean userInfo, String tempName, String sessionId, String remoteData) throws ITMException
	{
		String returnStr = "";
		Connection conn = null;
		try 
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( userInfo.getTransDB() );
			connDriver = null;
			conn.setAutoCommit( false );
			
			//Added by Prasad on 10/08/18 [to resolve formName wise implementation related issue] START
			/*DBAccessEJB dbAccess = new DBAccessEJB();
			objFormsDetailList = dbAccess.getObjFormsDetailList(objName, userInfo);
			formWisePkFldNameMap = new HashMap<String, String>();
			formNameMap = new HashMap<String, String>();
			int noOfForms = objFormsDetailList.size();
			for(int i = 0; i < noOfForms; i++)
			{
				ArrayList currFormDetailList = (ArrayList)objFormsDetailList.get(i);
				String objContext = (String) currFormDetailList.get(14);
				if ( currFormDetailList.size() > 27 )
				{
					formWisePkFldNameMap.put( objContext, ""+currFormDetailList.get(27) );
				}
				String formName = (String) ( ( currFormDetailList.get(32) == null ) ? "" : currFormDetailList.get(32) );
				BaseLogger.log("3", userInfo, null, "objContext : ["+ objContext +"], formName : ["+ formName +"]" );
				formNameMap.put( objName + "::" + objContext, formName );
			}
			BaseLogger.log("3", userInfo, null, "formWisePkFldNameMap - ["+ formWisePkFldNameMap +"]" );
			BaseLogger.log("3", userInfo, null, "formNameMap - ["+ formNameMap +"]" );
			dbAccess = null;*/
			setObjFormDetail( objName, userInfo );
			//Added by Prasad on 10/08/18 [to resolve formName wise implementation related issue] END

			returnStr = saveData( uploadData, userInfo, conn );
			//Added By Ravindra C on 10-08-19 for Remote upload server related option.
			//String uploadResponse = generateUploadResponse( batchId, tranSl, returnStr, pkValue, filePath, templateKey, conn, userInfo, null, fileType, uploadFilePath );
			String uploadResponse = generateUploadResponse( batchId, tranSl, returnStr, pkValue, filePath, templateKey, conn, userInfo, null, fileType, uploadFilePath, remoteData );
			BaseLogger.log("3", userInfo, null, "uploadResponse : ["+ uploadResponse +"]" );

			if( ! "Rollback".equalsIgnoreCase( uploadResponse ) && ! "Error".equalsIgnoreCase( uploadResponse ) )
			{
				String xmlFileName = batchId + "_" + tranSl + ".xml";
				File tempXMLFile = new File( uploadFilePath + File.separator + xmlFileName );
				if ( tempXMLFile.exists() )
				{
					tempXMLFile.delete();
				}
				BaseLogger.log("3", userInfo, null, "tableName : ["+ tableName +"], tranIdCol : ["+ tranIdCol +"], isBatchIdColExist : ["+ isBatchIdColExist +"]" );
				if( isBatchIdColExist && tableName != null && tableName.length() > 0 && tranIdCol != null && tranIdCol.trim().length() > 0 )
				{
					tranIdCol = tranIdCol.toLowerCase();
					updateBatchIdInTransTable( tableName, tranIdCol, batchId, uploadResponse, conn );
				}
				uploadResponse = "Success";
			}

			if ( conn != null ) 
			{
				conn.commit();
			}
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", userInfo, null,"SaveData Exception : [" + e.getMessage() +"]");
			e.printStackTrace();
			try 
			{
				if ( conn != null )
				{
					conn.rollback();
					conn.close();
					conn = null;
				}
				throw new ITMException( e );
			}
			catch (SQLException ex) 
			{
				ex.printStackTrace();
			}
		}
		finally 
		{
			try 
			{
				if( conn != null )
				{
					conn.close();
					conn = null;
				} 
			} 
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
		return respRowErrorMap;
	}
	//Changed by Ravindra C on 11-07-18 for Uploading data while inserting into batchload - End

	private String readInputTempXMLFile( String batchId, String filePath ) throws ITMException
	{
		String retStr = "";
		BaseLogger.log("3", null, null, "readInputTempXMLFile => batchId : ["+ batchId +"]" );
		try
		{
			FileReader fileReader = new FileReader( filePath ); 
			String readStr = null;
			StringBuilder strbuld = new StringBuilder();
			BufferedReader br = new BufferedReader(fileReader);
			while( (readStr = br.readLine() ) != null )
			{
				strbuld.append( readStr );
			}
			br.close();
			retStr = strbuld.toString();
		}
		catch( IOException e )
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch( Exception e )
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retStr;
	}
	//Added By Ravindra C on 08-09-2018 for upload Batch Data - [End]

	//Added By Ravindra C on 10-08-18 for Store the Error file into Database - Start
	public String callDocumentHandlerServlet(String objName, String batchId, String tempName, String fileName, String sessionId, String uploadedFilePath, String docTypeAttach, UserInfoBean userInfo ) throws ITMException, IOException, NamingException 
	{
		//Added by Prasad on 18/01/19 [call documenthandlerEJB instead of documentHandlerServlet] START
		String retString = "";
		String refSer = "";
		if( checkNull( objName ).length() > 0 )
		{
			String transDB = "";
			if( userInfo != null )
			{
				transDB = userInfo.getTransDB();
			}
			DBAccessEJB dbAccess = new DBAccessEJB();
			refSer = dbAccess.getDBColumnValue( " TRANSETUP ", " REF_SER ", (" TRAN_WINDOW = '"+ objName +"'"), transDB );
			BaseLogger.log("3", userInfo, null, "refSer ["+ refSer +"]");
		}
		String fileType = fileName.substring( fileName.lastIndexOf(".") + 1 );
		String userId = userInfo.getLoginCode();
		
		//public String addDocument( String objName, String refId, String refSer, String refCol, String strGrabFrame, String documentType, String attachFileType, String filePath, String docLinkOptn, String refDescr, int noOfPages, String extractedData, String module, UserInfoBean userInfo,String fileMetadata ) throws ITMException;
		
		StringBuffer retXMLStringBuff = new StringBuffer();

		retXMLStringBuff.append("<?xml version=\"1.0\" encoding=\""+CommonConstants.ENCODING+"\"?>");
		retXMLStringBuff.append("<DocumentRoot>");
		retXMLStringBuff.append("<description>Datawindow Root</description>");
		retXMLStringBuff.append("<group0>");
		retXMLStringBuff.append("<description>Group0 description</description>");
		retXMLStringBuff.append("<Header0>");
		retXMLStringBuff.append("<description>Header0 members</description>");
		retXMLStringBuff.append("<header>");
		retXMLStringBuff.append("<ref_id><![CDATA[").append(batchId).append("]]></ref_id>");
		retXMLStringBuff.append("<ref_col><![CDATA[").append("").append("]]></ref_col>");
		retXMLStringBuff.append("<obj_name><![CDATA[").append(objName).append("]]></obj_name>");
		retXMLStringBuff.append("<ref_ser><![CDATA[").append(refSer).append("]]></ref_ser>");
		retXMLStringBuff.append("<doc_name><![CDATA[").append(fileName).append("]]></doc_name>");
		retXMLStringBuff.append("<doc_type><![CDATA[").append(fileType).append("]]></doc_type>");
		retXMLStringBuff.append("<document_type><![CDATA[").append(docTypeAttach).append("]]></document_type>");
		retXMLStringBuff.append("<file_type><![CDATA[").append(fileType).append("]]></file_type>");
		retXMLStringBuff.append("<created_by><![CDATA[").append(userId).append("]]></created_by>");
		//retXMLStringBuff.append("<doc_link_optn><![CDATA[" + docLinkOptn + "]]></doc_link_optn>");
		//retXMLStringBuff.append("<ref_descr><![CDATA[" + refDescr + "]]></ref_descr>");
		//retXMLStringBuff.append("<doc_pages><![CDATA[" + noOfPages + "]]></doc_pages>");
		//retXMLStringBuff.append("<extracted_data><![CDATA[" + extractedData + "]]></extracted_data>");
		// Changed by Pravin K on 25-JAN-19 [ Added fileMetadata To store last modify date]
		//retXMLStringBuff.append("<file_metadata><![CDATA[" + fileMetadata + "]]></file_metadata>");// pa // 25-JAN
		//retXMLStringBuff.append("<module><![CDATA[" + module + "]]></module>");
		retXMLStringBuff.append("</header>");
		retXMLStringBuff.append("</Header0>");
		retXMLStringBuff.append("</group0>");
		retXMLStringBuff.append("</DocumentRoot>");
		
		byte[] byteArray = getFileInBytes( uploadedFilePath, userInfo );
		
		DocumentHandlerEJB docHandler = new DocumentHandlerEJB();
		retString = docHandler.addDocument( retXMLStringBuff.toString(), byteArray, null, userInfo );
		
		//DocumentHandlerWrapperRemote docHandler = (DocumentHandlerWrapperRemote) getInitialContext().lookup("ibase/DocumentHandlerWrapperEJB/remote");
		// Changed by Pravin K on 29-JAN-19 [ For fileMetadata]
		//retString = docHandler.addDocument( objName, batchId, refSer, null, null, docTypeAttach, fileType, uploadedFilePath, null, null, 0, null, null, userInfo,"");
		BaseLogger.log("3", userInfo, null, "In addDocument :: retString : ["+ retString +"]" );
		
		return retString;
		/*
		//String path = CommonConstants.TOMCAT_HOME;
		//added by Ravindra C on 23-10-18 for removing space between name -Start
		String userInformation = URLEncoder.encode( userInfo.toString(), CommonConstants.ENCODING);
		tempName = URLEncoder.encode( tempName, CommonConstants.ENCODING);
		fileName = URLEncoder.encode( fileName, CommonConstants.ENCODING);
		uploadedFilePath = URLEncoder.encode( uploadedFilePath, CommonConstants.ENCODING);
		//added by Ravindra C on 23-10-18 for removing space between name -End

		String fileType = fileName.substring( fileName.lastIndexOf(".") + 1 );
		String urlStr = path+"/ibase/WebITMDocumentHandlerServlet?ACTION=UPLOAD_D0CMENT"
				+ "&CAPTURE_IMAGE=false"
				+ "&IMG_EXIST=true"
				+ "&REF_ID="+ batchId +""
				+ "&OBJ_NAME="+ objName +""   
				+ "&TEMP_NAME="+ tempName +""
				+ "&FILE_NAME="+ fileName +""
				+ "&FILE_TYPE="+ fileType +""
				+ "&REF_SER="+ refSer +""
				+ "&UPLOADED_FILE_PATH="+ uploadedFilePath +""
				+ "&USER_INFO="+ userInformation +""
				+ "&DOCUMENT_TYPE="+ docTypeAttach;

		BaseLogger.log("3", null, null,"urlStr :: ["+ urlStr +"]");
		String xmlString = "";
		String output = "";
		try 
		{
			URL url = new URL( urlStr );
			HttpURLConnection conn = (HttpURLConnection) url.openConnection();
			conn.setDoOutput(true);
			conn.setRequestMethod("POST");
			conn.setRequestProperty("Cookie", "JSESSIONID=" + URLEncoder.encode(sessionId, "UTF-8"));
			try 
			{
				DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
				wr.writeBytes( xmlString );
				wr.flush();
			}
			catch (Exception e) 
			{
				BaseLogger.log("0", null, null,"callDocumentHandlerServlet Exception - ["+ e.getMessage()+"]" );
			}
			BaseLogger.log("3", null, null, "URL: ["+ url +"]" );
			BaseLogger.log("3", null, null, "ResponseCode: ["+ conn.getResponseCode()+"]" );

			StringBuffer responseBuff = new StringBuffer();
			BufferedReader br = new BufferedReader( new InputStreamReader( ( conn.getInputStream() ) ) );
			while ( ( output = br.readLine() ) != null ) 
			{
				responseBuff.append( output );
			}
			conn.disconnect();
			output = responseBuff.toString();
			BaseLogger.log("3", null, null,"Output: ["+ output +"]");
		}
		catch (MalformedURLException e) 
		{
			e.printStackTrace();
			BaseLogger.log("0", null, null, "callDocumentHandlerServlet MalformedURLException ["+ e.getMessage() +"]" );
			throw new ITMException(e);
		}
		catch (IOException e) 
		{
			e.printStackTrace();
			BaseLogger.log("0", null, null, "callDocumentHandlerServlet IOException ["+ e.getMessage() +"]" );
		}
		return output;*/
		//Added by Prasad on 18/01/19 [call documenthandlerEJB instead of documentHandlerServlet] END
	}
	//Added By Ravindra C on 10-08-18 for Store the Error file into Database - End
	
	private InitialContext getInitialContext()
	{
		InitialContext ctx = null;
		try 
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch (NamingException e) 
		{
			e.printStackTrace();
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		return ctx;
	}
	
	//Added By Ravindra C on 10-08-18 for Store the Error file into Database - Start
	public static String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	//Added By Ravindra C on 10-08-18 for Store the Error file into Database - End
	
	//Added by Ravindra C on 03-01-18 for Store the Error file into Database And write Error File -Start
	//Added By Ravindra C on 10-08-19 for Remote upload server related option.
	//public String writeErrorExcelFile( HashMap<Integer,ArrayList<String>> respRowErrorMap, String excelFilePath, String templateKey, String userId, String objName ) throws ITMException
	public String writeErrorExcelFile( HashMap<Integer,ArrayList<String>> respRowErrorMap, String excelFilePath, String templateKey, String userId, String objName, String remoteData ) throws ITMException
	{
		BaseLogger.log("2", null, null,"respRowErrorMap : ["+ respRowErrorMap +"]");
		try 
		{
			File file = new File( excelFilePath );
			String filename = file.getName();

			String errorFilePath = CommonConstants.TEMP_FOLDER + File.separator + "Failed" + File.separator + userId + File.separator + filename;
			BaseLogger.log("3", null, null,"errorFilePath --> :["+ errorFilePath +"]");

			File errorfile = new File( errorFilePath );
			if( file.exists() )
			{
				moveErrorFile( excelFilePath, userId );
				errorfile = new File( errorFilePath );
			}
			String errorfilename = errorfile.getName();
			BaseLogger.log("3", null, null,"errorfile FILE NAME ::[" + errorfilename + "]");
			String downloadedPath = errorfile.getAbsolutePath();
			BaseLogger.log("3", null, null,"errorfile PATH::[" + downloadedPath + "]");

			FileInputStream fsIP = new FileInputStream(new File(downloadedPath));
			BaseLogger.log("3", null, null,"errorfile fsIP::[" + fsIP + "]");

			HSSFWorkbook wb = new HSSFWorkbook(fsIP);
			HSSFCellStyle borderStyle = wb.createCellStyle();
			//Modified by Jatin M [To update depcrecated methods which were removed in latest version of Apache POI/any supporting jar related to Apache POI] - START
			/*borderStyle.setBorderLeft( HSSFCellStyle.BORDER_THIN );             
			borderStyle.setBorderRight( HSSFCellStyle.BORDER_THIN );            
			borderStyle.setBorderTop( HSSFCellStyle.BORDER_THIN );              
			borderStyle.setBorderBottom( HSSFCellStyle.BORDER_THIN );*/
			borderStyle.setBorderLeft( BorderStyle.THIN );             
			borderStyle.setBorderRight( BorderStyle.THIN );            
			borderStyle.setBorderTop( BorderStyle.THIN );              
			borderStyle.setBorderBottom( BorderStyle.THIN );
			//Modified by Jatin M [To update depcrecated methods which were removed in latest version of Apache POI/any supporting jar related to Apache POI] - END
			borderStyle.setBottomBorderColor( IndexedColors.RED.getIndex() );
			borderStyle.setTopBorderColor( IndexedColors.RED.getIndex() );
			borderStyle.setLeftBorderColor( IndexedColors.RED.getIndex() );
			borderStyle.setRightBorderColor( IndexedColors.RED.getIndex() );
			
			Font font = wb.createFont();
			font.setColor( IndexedColors.RED.getIndex() );
			borderStyle.setFont( font );

			BaseLogger.log("3", null, null,"objName ["+ objName +"] templateKey ::["+ templateKey +"] wb : ["+ wb +"] borderStyle : ["+ borderStyle +"]");
			//Added By Ravindra C on 10-08-19 for Remote upload server related option.
			JSONObject remoteDataJson =  new JSONObject(remoteData);
			
			BaseLogger.log("3", null, null,"remoteDataJson : ["+ remoteDataJson +"]");			
			//int noOfForms = TemplateDetails.get( objName ).getFormCount();
			int noOfForms = (int)remoteDataJson.get("NO_OF_FORMS");
			//Added By Ravindra C on 10-08-19 for Remote upload server related option.
			BaseLogger.log("3", null, null,"noOfForms :["+ noOfForms +"]");
			boolean isMatrixSheet = false;
			
			for ( int formCtr = 1; formCtr <= noOfForms; formCtr++ )
			{
				//JSONArray tempDataArray = remoteDataJson.getJSONArray(""+formCtr);
				//System.out.println("tempDataArray ::: ---> : ["+ tempDataArray +"]");
				
				JSONObject tempDataJsonObj= remoteDataJson.getJSONObject(""+formCtr);
				BaseLogger.log("3", null, null,"tempDataJsonObj ["+ tempDataJsonObj +"]");
				int matrixRowNo = (int)tempDataJsonObj.get("MATRIX_ROW_NO"); 
				//int matrixRowNo = TemplateDetails.get(templateKey).getMatrixRowNo(formCtr);
				BaseLogger.log("3", null, null, "matrixRowNo:[" + matrixRowNo + "]" );
				
				if( matrixRowNo != -1)
				{
					isMatrixSheet = true;
					break;
				}
			}
			highLightColumn( objName, templateKey, wb, borderStyle, isMatrixSheet, noOfForms, remoteDataJson );
			
			BaseLogger.log("3", null, null,"Below The HighLight(); ");
			fsIP.close();
			FileOutputStream outputFile = new FileOutputStream(new File(downloadedPath));
			BaseLogger.log("3", null, null,"Inside errorfile output_file::[" + outputFile + "]");
			wb.write(outputFile);
			outputFile.flush();
			outputFile.close();
			respRowErrorMap.clear();
		}
		catch (FileNotFoundException e) 
		{
			BaseLogger.log("0", null, null,"writeErrorInFile FileNotFoundException :["+e.getMessage()+"]");
			e.printStackTrace();
		}
		catch (IOException e) 
		{
			BaseLogger.log("0", null, null,"writeErrorInFile IOException :["+e.getMessage()+"]");
			e.printStackTrace();
		} 
		catch (JSONException e) 
		{
			BaseLogger.log("0", null, null,"writeErrorInFile JSONException :["+e.getMessage()+"]");
			e.printStackTrace();
		}
		return "Success";
	}
	//Added by Ravindra C on 03-01-18 for Store the Error file into Database And write Error File - End
	
	//Added by Prasad on 29/10/18 [create method to set objForm details] START
	public void setObjFormDetail( String objName, UserInfoBean userInfo )
	{
		try 
		{
			DBAccessEJB dbAccess = new DBAccessEJB();
			boolean isFound = false;
			if ( formNameMap != null && formNameMap.size() > 0 )
			{
				for ( Map.Entry<String, String> entry : formNameMap.entrySet() )
				{
					if ( entry.getKey().startsWith( objName + "::" ) )
					{
						isFound = true;
					}
				}
			}
			if ( isFound )
			{
				return;
			}
			objFormsDetailList = dbAccess.getObjFormsDetailList(objName, userInfo);
			formWisePkFldNameMap = new HashMap<String, String>();
			formNameMap = new HashMap<String, String>();
			int noOfForms = objFormsDetailList.size();
			for(int i = 0; i < noOfForms; i++)
			{
				ArrayList currFormDetailList = (ArrayList)objFormsDetailList.get(i);
				String objContext = (String) currFormDetailList.get(14);
				if ( currFormDetailList.size() > 27 )
				{
					formWisePkFldNameMap.put( objContext, ""+currFormDetailList.get(27) );
				}
				String formName = (String) ( ( currFormDetailList.get(32) == null ) ? "" : currFormDetailList.get(32) );
				BaseLogger.log("3",userInfo,null,  "objContext : ["+ objContext +"], formName : ["+ formName +"]" );
				formNameMap.put( objName + "::" + objContext, formName );
			}
			BaseLogger.log( "3", userInfo, null, "formWisePkFldNameMap - ["+ formWisePkFldNameMap +"]" );
			BaseLogger.log( "3", userInfo, null, "formNameMap - ["+ formNameMap +"]" );
			dbAccess = null;
		}
		catch (RemoteException e) 
		{
			e.printStackTrace();
		}
		catch (ITMException e) 
		{
			e.printStackTrace();
		}
	}
	//Added by Prasad on 29/10/18 [create method to set objForm details] END

	//Added By Ravindra C On 21-12-18 for delete line_no value when record Add Mode- Start
	private String removeLineNoData( String xmlString ) throws ITMException 
	{
		BaseLogger.log("2", null, null, "In removeLineNoData xmlString : ["+ xmlString +"]");
		String xmlStr ="";
		Document doc = null;
		Node detailNode = null;
		String nodeName ="";
		doc = genericUtility.parseString(xmlString);
		Node rootNode = doc.getElementsByTagName("Header0").item(0);
		//Changed By Pankaj T. on 24-07-19 if Header0 tag not present then used Root tag for getting root node - start
		if( rootNode == null )
		{
			BaseLogger.log("2", null, null, "In removeLineNoData if Header0 not present");
			rootNode = doc.getElementsByTagName("Root").item(0);
		}
		//Changed By Pankaj T. on 24-07-19 if Header0 tag not present then used Root tag for getting root node - end
		if( rootNode != null )
		{
			NodeList detailNodeList = rootNode.getChildNodes();
			int detailNodeListLen = detailNodeList.getLength();
			for(int i =0 ; i < detailNodeListLen ; i++)
			{
				detailNode = detailNodeList.item(i);
				nodeName = detailNode.getNodeName();
				if(nodeName.startsWith("Detail"))
				{
					NodeList subChildList = detailNode.getChildNodes();
					int subChildListLen = subChildList.getLength();
					for( int j = 0 ; j < subChildListLen ; j++)
					{
						Node childNode = subChildList.item(j);
						String childNodeName = childNode.getNodeName();
						if( "line_no".equalsIgnoreCase(childNodeName) )
						{
							//Added By Ravindra C on 1-08-19 to remove line_no if line no value is null - Start
							if(childNode.getFirstChild() == null)
							{
								childNode.setNodeValue("");
								childNode.getAttributes().removeNamedItem("isDataUpload");
							}
							//Added By Ravindra C on 1-08-19 to remove line_no if line no value is null - End
							else
							{
								if(childNode.getFirstChild().getNodeValue() !=null && childNode.getAttributes().getNamedItem("isDataUpload") != null )
								{
									childNode.getFirstChild().setNodeValue("");
									childNode.getAttributes().removeNamedItem("isDataUpload");
								}
							}
						}
					}
				}
			}
		}
		xmlStr = genericUtility.serializeDom(doc);
		return xmlStr;
	}
	//Added By Ravindra C On 21-12-18 for delete line_no value when record Add Mode- End

	//Added By ravindra c 
	
	//Added by Ravindra C on 08-02-19 to write Matrix And Normal Excel Errpor Information - Start
	private void highLightColumn( String objName, String templateKey, HSSFWorkbook wb, HSSFCellStyle borderStyle, boolean isMatrixSheet, int noOfForms, JSONObject remoteDataJson ) throws ITMException, JSONException
	{
		String pkFieldName = (String)remoteDataJson.get("PK_FIELD_NAME");
		//String pkFieldName = TemplateDetails.get( objName ).getPKFieldNameList( ""+1 ).get( 0 );
		BaseLogger.log("3", null, null, "noOfForms : ["+ noOfForms +"], pkFieldName :==>: ["+ pkFieldName +"]");
		String headerPkFieldValue = "";
		HashMap<String, Integer> colSpanMap = new HashMap<String, Integer>();

		for( Entry<Integer, ArrayList<String>> entry : respRowErrorMap.entrySet() )
		{
			int rowNo = entry.getKey();
			ArrayList<String> errorList = entry.getValue();
			String errorMsg = "";
			String uploadFilePath = "";
			String xmlData ="";
			String respErrorStr = "";
			
			String detailDomId = "";
			int errorDomId = 0;
			String errorColumnName ="";
			String respErrorObjContext ="";
			int formNum = 0;
			int colSpan = 0;
			if ( errorList != null )
			{
				if( errorList.get(0).trim().length() > 0 )
				{
					headerPkFieldValue = errorList.get(0);
				}
				errorMsg = errorList.get(1);
				uploadFilePath = errorList.get(2);
				respErrorStr = errorList.get(3);
			}
			File errorXmlFile = new File( uploadFilePath );
			if( errorXmlFile.exists() )
			{
				xmlData = readInputTempXMLFile( null, uploadFilePath );
				BaseLogger.log("3", null, null, "errorData :: ["+ xmlData +"]");
				BaseLogger.log("3", null, null, "errorMsg :: ["+ errorMsg +"]  headerPkFieldValue :: ["+ headerPkFieldValue +"]");
			}
			Document errorStrDom = genericUtility.parseString( respErrorStr );
			Node errorStrNode = errorStrDom.getElementsByTagName("Errors").item(0);
			
			if( isMatrixSheet )
			{
				NodeList errorStrNodeList = errorStrNode.getChildNodes();
				BaseLogger.log("3", null, null, "childListLength :: ["+ errorStrNodeList.getLength() +"]");
				if ( errorStrNodeList != null ) 
				{
					for ( int errorStrItr = 0; errorStrItr < errorStrNodeList.getLength(); errorStrItr++ ) 
					{
						Node errorStrChildNode = errorStrNodeList.item( errorStrItr );
						if ( errorStrChildNode != null ) 
						{
							String errorStrChildNodeName = errorStrChildNode.getNodeName();

							if( errorStrChildNodeName.startsWith("error") )
							{
								NodeList errorStrSubChildList = errorStrChildNode.getChildNodes();
								errorColumnName = errorStrChildNode.getAttributes().getNamedItem( "column_name" ).getNodeValue();

								for( int errorStrSubChildListItr = 0 ; errorStrSubChildListItr < errorStrSubChildList.getLength(); errorStrSubChildListItr++)
								{
									Node subChildNode  = errorStrSubChildList.item(errorStrSubChildListItr);
									String subChildNodeName = subChildNode.getNodeName();
									
									if( "detailDomId".equalsIgnoreCase( subChildNodeName ) )
									{
										detailDomId = subChildNode.getFirstChild().getNodeValue();
									}
									if("objContext".equalsIgnoreCase( subChildNodeName) )
									{
										respErrorObjContext = subChildNode.getFirstChild().getNodeValue();
										break;
									}
								}
								BaseLogger.log("3", null, null, "detailDomId : ["+ detailDomId +"] columnName :: ["+ errorColumnName +"] respErrorObjContext :["+ respErrorObjContext +"]");
								break;
							}
						}
					}
					if ( detailDomId != null && detailDomId.length() > 0 )
					{
						errorDomId = Integer.parseInt( detailDomId.trim() );				
					}
					if(respErrorObjContext.length() > 0)
					{
						formNum = Integer.parseInt( respErrorObjContext.trim() );
					}
				}
			}
			for ( int formCtr = 1; formCtr <= noOfForms; formCtr++ )
			{
				JSONObject tempDataJsonObj= remoteDataJson.getJSONObject(""+formCtr);
				
				//int matrixRowNo = TemplateDetails.get(templateKey).getMatrixRowNo(formCtr);
				int matrixRowNo =(int)tempDataJsonObj.get("MATRIX_ROW_NO");
				BaseLogger.log("3", null, null, "matrixRowNo:[" + matrixRowNo + "]" );

				//String sheetName = TemplateDetails.get(templateKey).getSheetName(formCtr);
				
				String sheetName =(String)tempDataJsonObj.get("SHEET_NAME");
				BaseLogger.log("3", null, null, "sheetName::[" + sheetName + "]" );
				
				if( isMatrixSheet )
				{
					//colSpan = TemplateDetails.get( templateKey ).getMatrixColSpan( sheetName );
					colSpan = (int)tempDataJsonObj.getInt("COLSPAN");
					BaseLogger.log("3", null, null, "colSpan : ["+ colSpan +"]");
					colSpanMap.put( sheetName, colSpan );
					if( sheetName.length() == 0 )
					{
						continue;
					}
				}
				
				//int startMatrixColNum = TemplateDetails.get(templateKey).getStartMatrixColNo(formCtr);
				int startMatrixColNum = (int)tempDataJsonObj.get("START_MATRIX_No");
				BaseLogger.log("3", null, null, "startMatrixColNum :: ["+ startMatrixColNum +"]");

				int endMatrixColNum = (int)tempDataJsonObj.get("END_MATRIX_NO");
				//int endMatrixColNum = TemplateDetails.get(templateKey).getEndMatrixColNo(formCtr);
				BaseLogger.log("3", null, null, "endMatrixColNum :: ["+ endMatrixColNum +"]");

				int headingRowNo = (int)tempDataJsonObj.get("HEADING_ROW_NO");
				//int headingRowNo = TemplateDetails.get(templateKey).getHeadingRowNo(formCtr);
				BaseLogger.log("3", null, null, "Heading row number :: ["+ headingRowNo + "]" );

				if ( !isMatrixSheet && formCtr == 1  )
				{
					addStyleToHeader( sheetName,  rowNo,  wb,  borderStyle,  headingRowNo,  errorMsg );
					HSSFSheet worksheet = wb.getSheet( "ERRORS" );
					if ( worksheet == null )
					{
						worksheet = wb.createSheet( "ERRORS" );
					}
					HSSFRow row = worksheet.getRow( 0 );
					if ( row == null )
					{
						row = worksheet.createRow( 0 );
						HSSFCell cell = row.createCell( 0 );
						cell.setCellValue( "PRIMARY_KEY" );
						cell = row.createCell( 1 );
						cell.setCellValue( "ERROR_MSG" );
					}
					int rowNum = worksheet.getLastRowNum();
					if ( rowNum == 0 )
					{
						rowNum = 1;
					}
					else
					{
						rowNum += 1;
					}
					row = worksheet.getRow( rowNum );
					if ( row == null )
					{
						row = worksheet.createRow( rowNum );
						HSSFCell cell = row.createCell( 0 );
						cell.setCellValue( headerPkFieldValue );
						cell = row.createCell( 1 );
						cell.setCellValue( errorMsg );
					}
				}
				else if( isMatrixSheet )
				{
					if(  matrixRowNo == -1)
					{
						addStyleToHeader( sheetName,  rowNo,  wb,  borderStyle,  headingRowNo,  errorMsg );
					}
					if( matrixRowNo != -1 )
					{
						writeNewErrorSheetForMatrix( noOfForms, xmlData, formNum, errorMsg, detailDomId, wb);
						int errorMatrixStartColNo = startMatrixColNum;
						if( sheetName.length() > 0 )
						{
							HSSFSheet dataSheet = wb.getSheet( sheetName );
							int noOfRows = dataSheet.getPhysicalNumberOfRows();
							HSSFRow headingRow = dataSheet.getRow( headingRowNo );
							int noOfColumns = headingRow.getPhysicalNumberOfCells();
							if ( matrixRowNo != -1 && formCtr == formNum )
							{
								if(colSpanMap !=null && colSpanMap.containsKey(sheetName))
								{
									colSpan = colSpanMap.get( sheetName );
								}
								if ( errorDomId > 1 )
								{
									while( errorDomId != 1 )
									{
										errorMatrixStartColNo = errorMatrixStartColNo + colSpan;
										errorDomId--;
									}
									errorMatrixStartColNo = errorMatrixStartColNo--;
								}
								ArrayList<Integer> matrixColList = getMatrixColList(noOfColumns, startMatrixColNum, endMatrixColNum, errorMatrixStartColNo, colSpan);
								BaseLogger.log("3", null, null, "matrixColList :: ["+ matrixColList + "]" );

								int pkColumnCellNo = getPkColumnCellNo( noOfColumns, headingRow, pkFieldName);
								BaseLogger.log("3", null, null, "pkColumnCellNo :: ["+ pkColumnCellNo +"]");

								int errorColumnCellNo = getErrorColumnCellNo( noOfColumns, headingRow, matrixColList, errorColumnName );
								BaseLogger.log("3", null, null, "errorColumnCellNo :: ["+ errorColumnCellNo +"] headingRowNo :["+ headingRowNo +"]");

								int  errorRowNo = getErrorRowNumber( headingRowNo, dataSheet, noOfRows, pkColumnCellNo, headerPkFieldValue );
								BaseLogger.log("3", null, null, "errorRowNo :: ["+ errorRowNo +"]");

								if( errorRowNo != 0 )
								{
									HSSFRow errorDataRow = dataSheet.getRow( errorRowNo ); 
									HSSFCell errorDataCell = errorDataRow.getCell( errorColumnCellNo );
									errorDataCell.setCellStyle(borderStyle);
								}
							}
						}
					}
				}
				else
				{
					BaseLogger.log("3", null, null, " NOT matrix Sheet ::: NOT Header Sheet :::: ");
				}
			}
		}
	}
	//Added by Ravindra C on 08-02-19 to write Matrix And Normal Excel Errpor Information - End
	
	//Added by Ravindra C on 08-02-19 to write Matrix And Normal Excel Errpor Information - Start
	private void writeNewErrorSheetForMatrix( int noOfForms, String xmlData, int sheetNum, String errorMsg, String detailDomId, HSSFWorkbook wb ) throws ITMException
	{
		LinkedHashMap<Integer, HashMap<String, String>> errorData = new LinkedHashMap<Integer, HashMap<String, String>>();
		ArrayList<String> headerColumn = new ArrayList<String>();
		HashMap< String, String > errorDataValMap = new HashMap<String, String >();
		String errorDataDomId ="";
		headerColumn.add( "ERROR MSG" );
		errorDataValMap.put( "ERROR MSG", errorMsg );

		for( int detailNumber = 1; detailNumber <= noOfForms; detailNumber++ )
		{
			Document errorDataDom = genericUtility.parseString( xmlData );
			NodeList errorDataNodeList = errorDataDom.getElementsByTagName("Detail"+detailNumber);
			int deatilNodeLength = errorDataNodeList.getLength();
			
			for( int detailItr = 0 ; detailItr < deatilNodeLength ; detailItr++ )
			{
				Node errorDataNode = errorDataNodeList.item( detailItr );
				NodeList errorDataChildList = errorDataNode.getChildNodes();
				
				if ( errorDataChildList != null ) 
				{
					for ( int errorDataCunt = 0; errorDataCunt < errorDataChildList.getLength(); errorDataCunt++ ) 
					{
						Node errorDataChildNode = errorDataChildList.item( errorDataCunt );
						if ( errorDataChildNode != null ) 
						{
							String errorDataChildHeaderColName = errorDataChildNode.getNodeName();
							if(!"attribute".equalsIgnoreCase( errorDataChildHeaderColName ) && detailNumber == 1 )
							{
								headerColumn.add( errorDataChildHeaderColName );
								String errorDataHeaderVal = errorDataChildNode.getFirstChild().getNodeValue(); 
								errorDataValMap.put( errorDataChildHeaderColName, errorDataHeaderVal );
							}
							errorDataDomId  =  errorDataNode.getAttributes().getNamedItem( "domID" ).getNodeValue();
							if( !"attribute".equalsIgnoreCase( errorDataChildHeaderColName ) && ( detailNumber == 2 || detailNumber > 2 ) && errorDataDomId.trim().equalsIgnoreCase( detailDomId.trim()) )
							{
								String errorDataChildDetailName = errorDataChildNode.getNodeName();
								headerColumn.add( errorDataChildDetailName );
								String errorDataDetailVal = errorDataChildNode.getFirstChild().getNodeValue(); // NULL POINTER EXCEPTION >
								errorDataValMap.put( errorDataChildDetailName, errorDataDetailVal );
							}
						}
					}
				}
			}
			errorData.put( detailNumber, errorDataValMap );
			if( detailNumber == sheetNum )
			{
				break;
			}
		}
		HSSFSheet worksheet = wb.getSheet( "ERRORS" );
		if ( worksheet == null )
		{
			worksheet = wb.createSheet( "ERRORS" );
		}
		HSSFRow row = worksheet.getRow( 0 );
		if ( row == null )
		{
			row = worksheet.createRow( 0 );
			for( int headeColVal = 0 ; headeColVal < headerColumn.size(); headeColVal++ )
			{
				HSSFCell cell = row.createCell( headeColVal );
				String cellVal = headerColumn.get( headeColVal );
				cell.setCellValue( cellVal );
			}
		}
		if(row != null)
		{
			row = worksheet.getRow( 0 );
			int headerColNum = row.getLastCellNum();
			if( headerColumn.size() > headerColNum )
			{
				for( int headeColVal = 0 ; headeColVal < headerColumn.size(); headeColVal++ )
				{
					HSSFCell cell = row.createCell( headeColVal );
					String cellVal = headerColumn.get( headeColVal );
					cell.setCellValue( cellVal );
				}
			}
		}
		int rowNum = worksheet.getLastRowNum();
		if ( rowNum == 0 )
		{
			rowNum = 1;
		}
		else
		{
			rowNum += 1;
		}
		row = worksheet.getRow( rowNum );
		if ( row == null )
		{
			row = worksheet.createRow( rowNum );
			for( int errorRowData = 0 ; errorRowData < headerColumn.size(); errorRowData++ )
			{
				HSSFCell cell = row.createCell( errorRowData );
				String cellVal = headerColumn.get( errorRowData );
				String cellData = errorDataValMap.get(cellVal); 
				cell.setCellValue(cellData);
			}
		}
	}
	//Added by Ravindra C on 08-02-19 to write Matrix And Normal Excel Errpor Information - end
	
	//Added by Ravindra C on 08-02-19 to write Matrix And Normal Excel Errpor Information - Start
	private void addStyleToHeader(String sheetName, int rowNo, HSSFWorkbook wb, HSSFCellStyle borderStyle, int headingRowNo, String errorMsg )
	{
		HSSFSheet dataSheet = wb.getSheet( sheetName );
		HSSFRow dataRow = dataSheet.getRow( rowNo );
		try 
		{
			for ( int col = 0; col < dataRow.getLastCellNum(); col++ )
			{
				HSSFCell cell = dataRow.getCell( col );
				if ( cell != null )
				{
					cell.setCellStyle( borderStyle );
				}
			}
			int rowNum = dataRow.getLastCellNum();
			dataSheet.getRow( headingRowNo ).createCell( rowNum );
			dataSheet.getRow( headingRowNo ).getCell( rowNum ).setCellValue( "ERROR MSG" );
			dataRow.createCell( rowNum );
			dataRow.getCell( rowNum ).setCellValue( errorMsg );
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", null, null, "Exception while addStyleToHeader : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
	}
	//Added by Ravindra C on 08-02-19 to write Matrix And Normal Excel Errpor Information - End
	
	//Added by Ravindra C on 08-02-19 to write Matrix And Normal Excel Errpor Information - Start
	private ArrayList<Integer> getMatrixColList( int noOfColumns, int startMatrixColNo, int endMatrixColNo, int matrixStartFrom, int colSpan )
	{
		ArrayList<Integer> matrixColList = new ArrayList<Integer>();
		for (int colNo = 0; colNo < noOfColumns; colNo++)
		{
			if ( colNo < startMatrixColNo || colNo > endMatrixColNo )
			{
				matrixColList.add(colNo);
			}
			else if ( colNo >= matrixStartFrom && colNo < (matrixStartFrom + colSpan) )
			{
				matrixColList.add(colNo);
			}
		}
		return matrixColList;
	}
	//Added by Ravindra C on 08-02-19 to write Matrix And Normal Excel Errpor Information - End
	
	//Added by Ravindra C on 08-02-19 to write Matrix And Normal Excel Errpor Information - Start
	private int getPkColumnCellNo( int noOfColumns, HSSFRow headingRow, String pkFieldName )
	{
		int pkColumnCellNo = 0;
		for ( int hdrColumnCtr = 0; hdrColumnCtr < noOfColumns; hdrColumnCtr++ )
		{
			HSSFCell dataCell = headingRow.getCell( hdrColumnCtr );
			String cellData = "";
			//Modified by Jatin M [To update depcrecated methods which were removed in latest version of Apache POI/any supporting jar related to Apache POI] - START
			//if (dataCell.getCellType() == XSSFCell.CELL_TYPE_STRING)
			if (dataCell.getCellType() == CellType.STRING )
			{
				if( dataCell.getStringCellValue() != null && dataCell.getStringCellValue() !="" )
				{
					cellData = dataCell.getStringCellValue();
					if ( cellData.toLowerCase().equals( pkFieldName.toLowerCase() ) )
					{
						pkColumnCellNo = hdrColumnCtr;
						break;
					}
				}
			}
		}
		return pkColumnCellNo;
	}
	//Added by Ravindra C on 08-02-19 to write Matrix And Normal Excel Errpor Information - End
	
	//Added by Ravindra C on 08-02-19 to write Matrix And Normal Excel Errpor Information - Start
	private int getErrorColumnCellNo( int noOfColumns, HSSFRow headingRow, ArrayList<Integer> matrixColList, String errorColumnName )
	{
		int errorColumnCellNo = 0;
		for ( int matrixColumnCtr = 0; matrixColumnCtr < noOfColumns; matrixColumnCtr++ )
		{
			if ( matrixColList != null && matrixColList.contains( matrixColumnCtr ) )
			{
				HSSFCell dataCell = headingRow.getCell( matrixColumnCtr );
				String cellData = "";
				//Modified by Jatin M [To update depcrecated methods which were removed in latest version of Apache POI/any supporting jar related to Apache POI] - START
				//if (dataCell.getCellType() == XSSFCell.CELL_TYPE_STRING)
				if (dataCell.getCellType() == CellType.STRING)
				{
					cellData = dataCell.getStringCellValue();
				}
				//else if (dataCell.getCellType() == XSSFCell.CELL_TYPE_NUMERIC)
				else if (dataCell.getCellType() == CellType.NUMERIC)
				{
					cellData = ""+ dataCell.getNumericCellValue();
				}
				if ( cellData.toLowerCase().equals( errorColumnName.toLowerCase() ) )
				{
					errorColumnCellNo = matrixColumnCtr;
					break;
				}
				//Modified by Jatin M [To update depcrecated methods which were removed in latest version of Apache POI/any supporting jar related to Apache POI] - END
			}
		}
		return errorColumnCellNo;
	}
	//Added by Ravindra C on 08-02-19 to write Matrix And Normal Excel Errpor Information - End
	
	//Added by Ravindra C on 08-02-19 to write Matrix And Normal Excel Errpor Information - Start
	private int getErrorRowNumber( int headingRowNo, HSSFSheet dataSheet, int noOfRows, int pkColumnCellNo , String headerPkFieldValue  )
	{
		int errorRowNo = 0;
		for ( int rowCtr = ( headingRowNo + 1); rowCtr < noOfRows; rowCtr++ )
		{
			HSSFRow dataRow = dataSheet.getRow( rowCtr );
			HSSFCell dataCell = dataRow.getCell( pkColumnCellNo );
			String cellData = "";
			//Modified by Jatin M [To update depcrecated methods which were removed in latest version of Apache POI/any supporting jar related to Apache POI] - START
			//if (dataCell.getCellType() == XSSFCell.CELL_TYPE_STRING)
			if (dataCell.getCellType() == CellType.STRING)
			{
				if( dataCell.getStringCellValue() != null && dataCell.getStringCellValue() !="" )
				{
					cellData = dataCell.getStringCellValue();
				}
			}
			//else if (dataCell.getCellType() == XSSFCell.CELL_TYPE_NUMERIC)
			else if (dataCell.getCellType() == CellType.NUMERIC)
			{
				if( String.valueOf((int)dataCell.getNumericCellValue()) != null && String.valueOf((int ) dataCell.getNumericCellValue() ) != "" )
				{
					cellData = String.valueOf( ( int ) dataCell.getNumericCellValue() );
				}
			}
			if ( cellData.trim().toLowerCase().equals( headerPkFieldValue.trim().toLowerCase() ) )
			{
				errorRowNo = rowCtr;
				break;
			}
			//Modified by Jatin M [To update depcrecated methods which were removed in latest version of Apache POI/any supporting jar related to Apache POI] - END
		}
		return errorRowNo;
	}
	//Added by Ravindra C on 08-02-19 to write Matrix And Normal Excel Errpor Information - End
	
	private byte[] getFileInBytes( String filePath, UserInfoBean userInfo ) throws ITMException
	{
		byte[] byteArray = null;
		BufferedInputStream bfr = null;
		ByteArrayOutputStream bout = null;
		try
		{
			File file = new File( filePath );
			FileInputStream input = new FileInputStream( file );
			bfr = new BufferedInputStream( input );
			bout = new ByteArrayOutputStream();
			int i=-1;
			while((i=bfr.read()) != -1)
			{
				bout.write(i);
			}
			byteArray = bout.toByteArray();
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( bfr != null )
				{
					bfr.close();
					bfr = null;
				}
				if( bout != null )
				{
					bout.close();
					bout = null;
				}
			}
			catch ( Exception e )
			{
				BaseLogger.log("0",userInfo,null,"Exception in releasing file resource :" );
				e.printStackTrace();
			}
		}
		return byteArray;
	}
	
	//Added By Ravindra C on 10-08-19 for Remote upload server related option. - Start
	@Override
	public String applyMasterTable(String batchid, String xtraParams, UserInfoBean userInfo, String excelFile,
			String tempName) throws RemoteException, ITMException {
		// TODO Auto-generated method stub
		return null;
	}
	@Override
	public String uploadBatchData(String objName, String tableName, String tranIdCol, String filePath, String fileType,
			String templateKey, String batchId, boolean isBatchIdColExist, String xtraParams, UserInfoBean userInfo,
			String tempName, String sessionId) throws ITMException {
		// TODO Auto-generated method stub
		return null;
	}
	//Added By Ravindra C on 10-08-19 for Remote upload server related option. - End
	@Override
	public HashMap<Integer, ArrayList<String>> uploadData(String uploadData, String tableName, String tranIdCol,
			String pkValue, String filePath, String fileType, String uploadFilePath, String batchId, int tranSl,
			String templateKey, boolean isBatchIdColExist, UserInfoBean userInfo, String tempName, String sessionId)
			throws ITMException {
		// TODO Auto-generated method stub
		return null;
	}
	
	public void updateBatchLoad( HashMap<Integer, HashMap<String, String>> dataMap, String status, Connection conn, UserInfoBean userInfo ) throws ITMException
	{
		PreparedStatement psUpdateBl = null;
		boolean isLocalConn = false;
		try
		{
			if ( dataMap != null && dataMap.size() > 0 )
			{
				if ( conn == null )
				{
					ConnDriver connDriver = new ConnDriver();
					conn = connDriver.getConnectDB( userInfo.getTransDB() );
					connDriver = null;
					isLocalConn = true;
				}
				
				String update = "UPDATE BATCHLOAD SET LOAD_STAT = ?, CHG_DATE = ? WHERE BATCH_ID = ? AND TRAN_SL = ?";
				psUpdateBl = conn.prepareStatement( update );
				
				String batchId = "";
				String tranSl = "";
				for( Map.Entry<Integer, HashMap<String, String>> dataEntry : dataMap.entrySet() )
				{
					HashMap<String, String> tempDataMap = dataEntry.getValue();
					batchId = checkNull( tempDataMap.get( "BATCH_ID" ) );
					tranSl = checkNull( tempDataMap.get( "TRAN_SL" ) );

					psUpdateBl.setString( 1, status );
					psUpdateBl.setTimestamp( 2, new java.sql.Timestamp( System.currentTimeMillis() ) );
					psUpdateBl.setString( 3, batchId );
					psUpdateBl.setString( 4, tranSl );
					
					psUpdateBl.addBatch();
				}
				int[] updateRecCnt = psUpdateBl.executeBatch();
				BaseLogger.log("3", null, null, "BATCHLOAD : updateRecCnt :: ["+ updateRecCnt +"]" );
				
				psUpdateBl.close();
				psUpdateBl = null;
				
				conn.commit();
			}
		}
		catch( SQLException ex )
		{
			BaseLogger.log("0", null, null, "SQLException : updateBatchLoad :: ["+ ex.getMessage() +"]" );
			ex.printStackTrace();
			throw new ITMException( ex );
		}
		catch( Exception ex )
		{
			BaseLogger.log("0", null, null, "Exception : updateBatchLoad :: ["+ ex.getMessage() +"]" );
			ex.printStackTrace();
			throw new ITMException( ex );
		}
		finally
		{
			try
			{
				if( psUpdateBl != null )
				{
					psUpdateBl.close();
					psUpdateBl = null;
				}
				if( conn != null && isLocalConn )
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException sqlex)
			{
				sqlex.printStackTrace();
			}
		}
	}
	
	
	/*  Changed By Amol S on 3-jan-24[F LOAD_STAT is 'E"get the RETRY_CTR and increase it by 1,
	    if not found then it should be 1.and update the same in the BATCHLOAD table's RETRY_CTR]   ---Start
    */
	public void updateBatchLoad(String batchId, int tranSl, Connection conn, UserInfoBean userInfo) throws ITMException {
	    PreparedStatement psUpdateBl = null;
	    PreparedStatement psSelectLoadStatus = null;
	    boolean isLocalConn = false;

	    try {
	        // If connection is not provided, create a local connection
	        if (conn == null) {
	            ConnDriver connDriver = new ConnDriver();
	            conn = connDriver.getConnectDB(userInfo.getTransDB());
	            connDriver = null;
	            isLocalConn = true;
	        }

	        // Fetch the current LOAD_STAT from the database
	        String selectLoadStatus = "SELECT LOAD_STAT FROM BATCHLOAD WHERE BATCH_ID = ? AND TRAN_SL = ?";
	        psSelectLoadStatus = conn.prepareStatement(selectLoadStatus);
	        psSelectLoadStatus.setString(1, batchId);
	        psSelectLoadStatus.setInt(2, tranSl);

	        ResultSet resultSet = psSelectLoadStatus.executeQuery();

	        String loadStatus = null;
	        if (resultSet.next()) {
	            loadStatus = resultSet.getString("LOAD_STAT");
	        }

	        // Continue with the existing update logic
	        String update = "UPDATE BATCHLOAD SET LOAD_STAT = ?, CHG_DATE = ? WHERE BATCH_ID = ? AND TRAN_SL = ?";
	        psUpdateBl = conn.prepareStatement(update);

	        // Use the retrieved LOAD_STAT or provide a default value if not found
	        psUpdateBl.setString(1, (loadStatus != null) ? loadStatus : "DEFAULT_LOAD_STAT");
	        psUpdateBl.setTimestamp(2, new java.sql.Timestamp(System.currentTimeMillis()));
	        psUpdateBl.setString(3, batchId);
	        psUpdateBl.setInt(4, tranSl);

	        // Execute the update query
	        int updateCnt = psUpdateBl.executeUpdate();

	        psUpdateBl.close();
	        psUpdateBl = null;
	        BaseLogger.log("3", null, null, "BATCHLOAD : updateCnt :: [" + updateCnt + "]");

	        // Commit the changes to the database
	        conn.commit();

	        // Check if loadStatus is 'E'
	        if ("E".equals(loadStatus)) {
	            // If 'E', update RETRY_CTR
	            updateRetryCounter(conn, batchId, tranSl);
	        }
	    } catch (SQLException ex) {
	        // Handle SQL exception
	        BaseLogger.log("0", null, null, "SQLException : updateBatchLoad :: [" + ex.getMessage() + "]");
	        ex.printStackTrace();
	        throw new ITMException(ex);
	    } catch (Exception ex) {
	        // Handle general exception
	        BaseLogger.log("0", null, null, "Exception : updateBatchLoad :: [" + ex.getMessage() + "]");
	        ex.printStackTrace();
	        throw new ITMException(ex);
	    } finally {
	        // Close resources in the finally block
	        try {
	            if (psSelectLoadStatus != null) {
	                psSelectLoadStatus.close();
	            }
	            if (psUpdateBl != null) {
	                psUpdateBl.close();
	            }
	            if (conn != null && isLocalConn) {
	                conn.close();
	            }
	        } catch (SQLException sqlex) {
	            // Handle SQL exception during resource closing
	            sqlex.printStackTrace();
	        }
	    }
	}

	// method to update RETRY_CTR
	private void updateRetryCounter(Connection conn, String batchId, int tranSl) throws SQLException {
	    String selectRetryCounter = "SELECT RETRY_CTR FROM BATCHLOAD WHERE BATCH_ID = ? AND TRAN_SL = ?";
	    String updateRetryCounter = "UPDATE BATCHLOAD SET RETRY_CTR = 1 WHERE BATCH_ID = ? AND TRAN_SL = ?";
	    String insertRetryCounter = "INSERT INTO BATCHLOAD (BATCH_ID, TRAN_SL, RETRY_CTR) VALUES (?, ?, 1)";

	    try (PreparedStatement psSelectRetryCounter = conn.prepareStatement(selectRetryCounter)) {
	        psSelectRetryCounter.setString(1, batchId);
	        psSelectRetryCounter.setInt(2, tranSl);

	        try (ResultSet resultSet = psSelectRetryCounter.executeQuery()) {
	            if (resultSet.next()) {
	                // Get the current retry counter
	                int currentRetryCounter = resultSet.getInt("RETRY_CTR");

	                // Update the retry counter
	                try (PreparedStatement psUpdateRetryCounter = conn.prepareStatement(updateRetryCounter)) {
	                    psUpdateRetryCounter.setString(1, batchId);
	                    psUpdateRetryCounter.setInt(2, tranSl);
	                    psUpdateRetryCounter.executeUpdate();
	                    BaseLogger.log("3", null, null, "RETRY_CTR updated successfully: 1");
	                }
	            } else {
	                // If the record does not exist, insert a new record with a retry counter of 1
	                try (PreparedStatement psInsertRetryCounter = conn.prepareStatement(insertRetryCounter)) {
	                    psInsertRetryCounter.setString(1, batchId);
	                    psInsertRetryCounter.setInt(2, tranSl);
	                    psInsertRetryCounter.executeUpdate();
	                    BaseLogger.log("3", null, null, "New record inserted with retry counter set to 1");
	                }
	            }
	        }
	    }
	}
	
	/*  Changed By Amol S on 3-jan-24[F LOAD_STAT is 'E"get the RETRY_CTR and increase it by 1,
    if not found then it should be 1.and update the same in the BATCHLOAD table's RETRY_CTR]   --- End
*/

	
}