/*
 * Decompiled with CFR 0.152.
 */
package ibase.hibernate.dao;

import ibase.hibernate.bean.RefSer;
import ibase.hibernate.bean.Task;
import ibase.hibernate.utility.HibernateUtil;
import ibase.utility.BaseLogger;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskDAO {
    private String siteTranDB = "DEFAULT";

    public List<Task> fetchTasksList(String USER_ID) {
        List<Task> taskList = new ArrayList<Task>();
        try {
            Session session = HibernateUtil.getSessionFactory(this.siteTranDB).openSession();
            Query query = session.createQuery("FROM Task WHERE userIdAsg = '" + USER_ID + "' OR userIdOwn = '" + USER_ID + "'");
            taskList = query.getResultList();
            BaseLogger.log("3", null, null, "Task list: [" + taskList + "]");
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return taskList;
    }

    public List<Task> fetchTasksList(String REF_ID, String REF_SER, String USER_ID) {
        List<Task> taskList = new ArrayList<Task>();
        try {
            Session session = HibernateUtil.getSessionFactory(this.siteTranDB).openSession();
            Query query = session.createQuery("FROM Task WHERE (userIdAsg = '" + USER_ID + "' OR userIdOwn = '" + USER_ID + "') AND REF_ID = '" + REF_ID + "' AND REF_SER = '" + REF_SER + "'");
            taskList = query.getResultList();
            BaseLogger.log("3", null, null, "Task list based on refId: [" + taskList + "]");
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return taskList;
    }

    public Task fetchTask(String taskId) {
        Task task = null;
        try {
            Session session = HibernateUtil.getSessionFactory(this.siteTranDB).openSession();
            Query query = session.createQuery("FROM Task WHERE taskId = '" + taskId + "'");
            if (query.getResultList().size() > 0) {
                List tasks = query.getResultList();
                task = (Task)tasks.get(0);
            }
            BaseLogger.log("3", null, null, "Task data: [" + task + "]");
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return task;
    }

    public void removeTask(String taskId) {
        Task task = this.fetchTask(taskId);
        try {
            Session session = HibernateUtil.getSessionFactory(this.siteTranDB).openSession();
            session.beginTransaction();
            session.delete((Object)task);
            session.getTransaction().commit();
            session.close();
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
    }

    public Task addTask(String loginCode, JSONObject taskData) throws JSONException {
        Task task = new Task();
        try {
            task.setTaskId(this.getNextSequence("tasks_seq"));
            if (taskData.getString("refSer").equals("TASK")) {
                task.setRefId(this.getNextSequence("tasks_ref_seq"));
            } else {
                task.setRefId(taskData.getString("refId"));
            }
            task.setRefSer(taskData.getString("refSer"));
            task.setUserIdOwn(loginCode);
            task.setAddDate(new Date());
            task.setAddTerm("base");
            task.setAddUser(loginCode);
            task.setChgTerm("base");
            task.toTask(taskData, loginCode);
            Session session = HibernateUtil.getSessionFactory(this.siteTranDB).openSession();
            session.beginTransaction();
            session.save((Object)task);
            session.getTransaction().commit();
            session.close();
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return task;
    }

    public void updateTask(String taskId, String loginCode, JSONObject taskData) {
        try {
            Task task = this.fetchTask(taskId);
            task.toTask(taskData, loginCode);
            Session session = HibernateUtil.getSessionFactory(this.siteTranDB).openSession();
            session.beginTransaction();
            session.update((Object)task);
            session.getTransaction().commit();
            session.close();
        }
        catch (JSONException e) {
            BaseLogger.log("0", null, null, "JSONException :");
            e.printStackTrace();
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
    }

    private String getNextSequence(String seqName) {
        String sequence = "";
        try {
            Session session = HibernateUtil.getSessionFactory(this.siteTranDB).openSession();
            NativeQuery query = session.createSQLQuery("SELECT " + seqName + ".nextVal FROM DUAL");
            List seqList = query.getResultList();
            if (seqList != null && seqList.size() > 0) {
                int seq = ((BigDecimal)seqList.get(0)).intValue();
                BaseLogger.log("3", null, null, "squence: [" + seq + "]");
                sequence = String.format(String.format("%%0%dd", 10), seq);
            }
            BaseLogger.log("3", null, null, "squence: [" + sequence + "]");
            session.close();
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return sequence;
    }

    public Map<String, RefSer> getRefSerMap(List<String> refSers) {
        HashMap<String, RefSer> refSerMap = new HashMap<String, RefSer>();
        try {
            Session session = HibernateUtil.getSessionFactory(this.siteTranDB).openSession();
            BaseLogger.log("3", null, null, "Inside getRefSerList refSers: [" + refSers + "]");
            String refSersStr = this.getEnclosedString(refSers);
            Query query = session.createQuery("from RefSer where refSer in (" + refSersStr + ") order by refSer ");
            List refSerList = query.getResultList();
            if (refSerList != null) {
                for (RefSer refSer : refSerList) {
                    refSerMap.put(refSer.getRefSer().trim(), refSer);
                }
            }
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return refSerMap;
    }

    private String getEnclosedString(List<String> docIdList) {
        StringBuffer buffer = new StringBuffer();
        int len = 0;
        for (String docId : docIdList) {
            buffer.append("'").append(docId.trim()).append("'");
            if (++len >= docIdList.size()) continue;
            buffer.append(",");
        }
        if (buffer.length() == 0) {
            buffer.append("''");
        }
        BaseLogger.log("2", null, null, "Inside getEnclosedString buffer: [" + buffer + "]");
        return buffer.toString();
    }
}

