/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility.training;

import com.aspose.words.Document;
import com.lowagie.text.pdf.PdfReader;
import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.DocumentHandlerEJB;
import ibase.webitm.ejb.DocumentHandlerWrapperEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.utility.ViewReport;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.StringJoiner;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.jcodec.api.FrameGrab;
import org.jcodec.api.JCodecException;
import org.jcodec.common.FileChannelWrapper;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.containers.mp4.demuxer.AbstractMP4DemuxerTrack;
import org.jcodec.containers.mp4.demuxer.MP4Demuxer;
import org.jcodec.scale.ColorUtil;
import org.jcodec.scale.Transform;

public class CreateReportAndAttach
extends ActionHandlerEJB {
    E12GenericUtility genericUtility = new E12GenericUtility();

    public String createReportAndAttach(String tranID, String xtraParam, String forcedFlag) throws ITMException, IOException {
        ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
        DBAccessEJB dbAccess = new DBAccessEJB();
        String reportObjName = "iti_for_joining_letter";
        String filePath = null;
        ViewReport viewReport = new ViewReport();
        String docType = "pdf";
        String backgrndProcess = "false";
        String deviceType = "";
        String fromSqlTimeOut = "";
        String fromBackgrounServer = "false";
        String browserType = null;
        String notifyBy = null;
        String remoteAddress = "";
        String isExplore = "";
        boolean isConfirmReprint = false;
        Connection conn = null;
        String result = "";
        String userCode = "";
        try {
            userCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParam, "loginCode");
            UserInfoBean userInfo = commonDBAccessEJB.createUserInfo(userCode);
            BaseLogger.log((String)"3", null, null, (Object)("Inside createReportAndAttach gsb tranID [" + tranID + "]"));
            BaseLogger.log((String)"3", null, null, (Object)("Inside createReportAndAttach xtraParam [" + xtraParam + "]"));
            String workSite = dbAccess.getDBColumnValue("EMPLOYEE", "WORK_SITE", "EMP_CODE = '" + tranID + "'", userInfo.getTransDB());
            BaseLogger.log((String)"3", null, null, (Object)("Inside createReportAndAttach workSite [" + workSite + "]"));
            String finEntity = dbAccess.getDBColumnValue("SITE", "FIN_ENTITY", "SITE_CODE = '" + workSite + "'", userInfo.getTransDB());
            BaseLogger.log((String)"3", null, null, (Object)("Inside createReportAndAttach finEntity [" + finEntity + "]"));
            if (finEntity.equalsIgnoreCase("ASBL")) {
                BaseLogger.log((String)"3", null, null, (Object)"Inside createReportAndAttach finEntity is ASBL");
                reportObjName = "iti_for_joining_letter_asbl";
            }
            conn = this.getConnection();
            String reportArgument = "<ACTUALPARAMETERS><ACTUALPARAMETER><Root><ObjName><![CDATA[" + reportObjName + "]]></ObjName><Arguments><Argument id=\"emp_cd_fr\" name = \"emp_cd_fr\"><argType><![CDATA[java.lang.String]]></argType><value><![CDATA[" + tranID + "]]></value></Argument><Argument id=\"emp_cd_to\" name = \"emp_cd_to\"><argType><![CDATA[java.lang.String]]></argType><value><![CDATA[" + tranID + " ]]></value></Argument><Argument id=\"as_date\" name = \"as_date\"><argType><![CDATA[java.util.Date]]></argType><value><![CDATA[06/10/23]]></value></Argument><Argument id=\"x_path\" name = \"x_path\"><argType><![CDATA[java.lang.String]]></argType><value><![CDATA[/DocumentRoot/iti_for_joining_letter]]></value></Argument><Argument id=\"design_source\" name = \"design_source\"><argType><![CDATA[java.lang.String]]></argType><value><![CDATA[iti_for_joining_letter.jrxml]]></value></Argument><Argument id=\"data_source\" name = \"data_source\"><argType><![CDATA[java.lang.String]]></argType><value><![CDATA[SQL]]></value></Argument><Argument id=\"bind_type\" name = \"bind_type\"><argType><![CDATA[java.lang.Integer]]></argType><value><![CDATA[]]></value></Argument><Argument id=\"report_type\" name = \"report_type\"><argType><![CDATA[java.lang.String]]></argType><value><![CDATA[JASPER]]></value></Argument><Argument id=\"report_save_type\" name = \"report_save_type\"><argType><![CDATA[java.lang.String]]></argType><value><![CDATA[HTML]]></value></Argument><Argument id=\"as_cloud_print\" name = \"as_cloud_print\"><argType><![CDATA[java.lang.StringArray]]></argType><value><![CDATA[]]></value></Argument></Arguments></Root></ACTUALPARAMETER></ACTUALPARAMETERS>";
            ArrayList<String> documentWordsToMatch = new ArrayList<String>(Arrays.asList(reportObjName, tranID));
            String docIDs = this.getDocIDs(userInfo, documentWordsToMatch);
            BaseLogger.log((String)"3", null, null, (Object)("Inside createReportAndAttach docID [" + docIDs + "]"));
            String tncCodes = this.getTNCCodesFromDOCID(userInfo, docIDs);
            BaseLogger.log((String)"3", null, null, (Object)("Inside createReportAndAttach tncCodes [" + tncCodes + "]"));
            if (this.isReportgenerated(reportObjName, tranID, userInfo, docIDs, userCode) && this.isTNCAgreed(tncCodes, tranID, userInfo.getTransDB())) {
                BaseLogger.log((String)"3", null, null, (Object)"Report already generated and accepted...");
                result = itmDBAccessEJB.getErrorString("", "REPGENACC", userCode, "", conn);
            } else {
                BaseLogger.log((String)"3", null, null, (Object)"Inside createReportAndAttach generating new report...");
                if (E12GenericUtility.checkNull((String)docIDs).equalsIgnoreCase("")) {
                    BaseLogger.log((String)"3", null, null, (Object)("No existing documents in DOC_CONTENTS with Document name like: " + documentWordsToMatch));
                } else {
                    DocumentHandlerWrapperEJB docHandler = new DocumentHandlerWrapperEJB();
                    docIDs = String.valueOf(docIDs) + "   ";
                    String deleteBulkAttachmentsResult = docHandler.deleteBulkAttachments(docIDs, userCode, userInfo);
                    BaseLogger.log((String)"3", null, null, (Object)("deleteBulkAttachmentsResult: " + deleteBulkAttachmentsResult));
                }
                viewReport.getReport(docType, reportObjName, backgrndProcess, deviceType, reportArgument, fromSqlTimeOut, fromBackgrounServer, userCode, isExplore, isConfirmReprint, browserType, notifyBy, remoteAddress);
                filePath = viewReport.getFilePath();
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("filePath:::[" + viewReport.getFilePath() + "]"));
                String customText = String.valueOf(tranID) + "_" + reportObjName;
                File file = CreateReportAndAttach.renameFileWithDate(filePath, customText);
                if (filePath != "" && filePath != null) {
                    result = itmDBAccessEJB.getErrorString("", "REPGENSUC", userCode, "", conn);
                    DocumentHandlerEJB documentHandlerEJB = new DocumentHandlerEJB();
                    String uploadAttachmentresult = this.uploadAttachments("empl_complete", "EMP", tranID, userInfo.getLoginCode(), userInfo.getSiteCode(), file, conn, documentHandlerEJB, "/wildfly/attachment/loaded", "", "", true, userInfo, workSite, finEntity);
                    System.out.println("uploadAttachmentresult:::[" + uploadAttachmentresult + "]");
                } else {
                    result = itmDBAccessEJB.getErrorString("", "REPGENF", userCode, "", conn);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static File renameFileWithDate(String filePath, String customText) {
        File file = new File(filePath);
        File newFile = null;
        if (file.exists()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yy");
            String currentDate = dateFormat.format(new java.util.Date());
            String parentDirectory = file.getParent();
            String fileName = file.getName();
            String fileExtension = "";
            int lastDotIndex = fileName.lastIndexOf(".");
            if (lastDotIndex >= 0) {
                fileExtension = fileName.substring(lastDotIndex);
                fileName = fileName.substring(0, lastDotIndex);
            }
            String newFileName = String.valueOf(customText) + "_" + currentDate + fileExtension;
            String newFilePath = String.valueOf(parentDirectory) + File.separator + newFileName;
            newFile = new File(newFilePath);
            if (file.renameTo(newFile)) {
                System.out.println("File renamed successfully.");
            } else {
                System.out.println("File renaming failed.");
            }
        } else {
            System.out.println("File does not exist.");
        }
        return newFile;
    }

    /*
     * Exception decompiling
     */
    private String uploadAttachments(String objName, String refSer, String tranID, String loginCode, String loginSite, File fileTobeAttached, Connection conn, DocumentHandlerEJB docHandler, String loadedDirPath, String unAllocatedDirPath, String toBeLoadedSubDirPath, boolean isFileToBeAttach, UserInfoBean userInfo, String workSite, String finEntity) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private String generateTranId(String winName, String xsiteCode, String userID, Connection conn) throws Exception {
        Statement lstmt = null;
        ResultSet lrs = null;
        String tranId = null;
        try {
            try {
                String keyStringQuery = null;
                String tranDate = null;
                String tranSer = "";
                String keyString = "";
                String keyCol = "";
                keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE UPPER(TRAN_WINDOW) = ?";
                System.out.println("keyStringQuery  :: " + keyStringQuery);
                lstmt = conn.prepareStatement(keyStringQuery);
                lstmt.setString(1, winName);
                lrs = lstmt.executeQuery();
                if (lrs.next()) {
                    keyString = lrs.getString("KEY_STRING");
                    keyCol = lrs.getString("TRAN_ID_COL");
                    tranSer = lrs.getString("REF_SER");
                } else {
                    if (lrs != null) {
                        lrs.close();
                    }
                    lrs = null;
                    if (lstmt != null) {
                        lstmt.close();
                    }
                    String sqlStr = "SELECT  KEY_STRING, TRAN_ID_COL, REF_SER  FROM  TRANSETUP WHERE  TRAN_WINDOW = 'GENERAL' ";
                    System.out.println(" sqlStr : SELECT  KEY_STRING, TRAN_ID_COL, REF_SER  FROM  TRANSETUP WHERE  TRAN_WINDOW = 'GENERAL' ");
                    lstmt = conn.prepareStatement("SELECT  KEY_STRING, TRAN_ID_COL, REF_SER  FROM  TRANSETUP WHERE  TRAN_WINDOW = 'GENERAL' ");
                    lrs = lstmt.executeQuery();
                    if (lrs.next()) {
                        keyString = lrs.getString("KEY_STRING");
                        keyCol = lrs.getString("TRAN_ID_COL");
                        tranSer = lrs.getString("REF_SER");
                    }
                }
                lrs.close();
                lrs = null;
                lstmt.close();
                lstmt = null;
                tranDate = this.getCurrdateAppFormat();
                StringBuffer xmlValues = new StringBuffer("<?xml version=\"1.0\" encoding=\"").append(CommonConstants.ENCODING).append("\"?><Root>");
                xmlValues.append("<Header></Header><Detail1><site_code>").append(xsiteCode).append("</site_code>");
                xmlValues.append("<tran_date>").append(tranDate).append("</tran_date></Detail1></Root>");
                TransIDGenerator tg = new TransIDGenerator(xmlValues.toString(), userID, CommonConstants.DB_NAME);
                tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
            }
            catch (SQLException se) {
                se.printStackTrace();
                throw new ITMException((Exception)se);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ITMException(ex);
            }
        }
        finally {
            if (lstmt != null) {
                lstmt.close();
                lstmt = null;
            }
        }
        return tranId;
    }

    private int deleteUnallocRec(String tranId, Connection conn, String loginCode) {
        int deleteCnt;
        block21: {
            PreparedStatement pstmt = null;
            Connection mConnection = conn;
            boolean isLocalConnection = false;
            deleteCnt = 0;
            try {
                try {
                    if (mConnection == null) {
                        UserInfoBean userInfoBean = this.createUserInfo(loginCode);
                        ConnDriver mConnDriver = new ConnDriver();
                        conn = mConnDriver.getConnectDB(userInfoBean.getTransDB());
                        mConnDriver = null;
                        isLocalConnection = true;
                    }
                    String sql = "DELETE FROM UNALLOCATED_ATTACH WHERE TRAN_ID = ?";
                    pstmt = mConnection.prepareStatement("DELETE FROM UNALLOCATED_ATTACH WHERE TRAN_ID = ?");
                    pstmt.setString(1, tranId);
                    deleteCnt = pstmt.executeUpdate();
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (isLocalConnection && mConnection != null) {
                            mConnection.close();
                            mConnection = null;
                        }
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                    try {
                        if (isLocalConnection && mConnection != null) {
                            mConnection.close();
                            mConnection = null;
                        }
                        break block21;
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (isLocalConnection && mConnection != null) {
                        mConnection.close();
                        mConnection = null;
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (isLocalConnection && mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
            try {
                if (isLocalConnection && mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
        }
        System.out.println("deleteCnt : [" + deleteCnt + "]");
        return deleteCnt;
    }

    private boolean isFileUploaded(String docId, String refSer, String objName, Connection conn, String loginCode) {
        boolean isFileUploaded;
        block23: {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            Connection mConnection = conn;
            boolean isLocalConnection = false;
            isFileUploaded = false;
            try {
                try {
                    int resultCnt = 0;
                    if (mConnection == null) {
                        UserInfoBean userInfoBean = this.createUserInfo(loginCode);
                        ConnDriver mConnDriver = new ConnDriver();
                        conn = mConnDriver.getConnectDB(userInfoBean.getTransDB());
                        mConnDriver = null;
                        isLocalConnection = true;
                    }
                    String sql = "SELECT COUNT(*) FROM UNALLOCATED_ATTACH WHERE DOC_ID = ? AND REF_SER = ? AND OBJ_NAME = ?";
                    pstmt = mConnection.prepareStatement("SELECT COUNT(*) FROM UNALLOCATED_ATTACH WHERE DOC_ID = ? AND REF_SER = ? AND OBJ_NAME = ?");
                    pstmt.setString(1, docId);
                    pstmt.setString(2, refSer);
                    pstmt.setString(3, objName);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        resultCnt = rs.getInt(1);
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    System.out.println("resultCnt - [" + resultCnt + "]");
                    if (resultCnt > 0) {
                        isFileUploaded = true;
                    }
                }
                catch (Exception e) {
                    isFileUploaded = false;
                    e.printStackTrace();
                    try {
                        if (isLocalConnection && mConnection != null) {
                            mConnection.close();
                            mConnection = null;
                        }
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                    try {
                        if (isLocalConnection && mConnection != null) {
                            mConnection.close();
                            mConnection = null;
                        }
                        break block23;
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (isLocalConnection && mConnection != null) {
                        mConnection.close();
                        mConnection = null;
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (isLocalConnection && mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
            try {
                if (isLocalConnection && mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
        }
        System.out.println("isFileUploaded : [" + isFileUploaded + "]");
        return isFileUploaded;
    }

    private void createUploadFileLog(String log, String fileName) {
        try {
            String logDir = String.valueOf(String.valueOf(CommonConstants.JBOSSHOME)) + File.separator + "log" + File.separator + "attachments" + File.separator + fileName;
            File outFile = new File(String.valueOf(String.valueOf(CommonConstants.JBOSSHOME)) + File.separator + "log" + File.separator + "attachments");
            if (!outFile.exists()) {
                outFile.mkdir();
            }
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(logDir, true)));
            out.println(log);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getCurrdateAppFormat() {
        String currAppdate = "";
        try {
            Timestamp currDate = new Timestamp(System.currentTimeMillis());
            SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getDBDateFormat());
            java.util.Date date = sdf.parse(currDate.toString());
            currDate = Timestamp.valueOf(String.valueOf(String.valueOf(sdf.format((Object)date).toString())) + " 00:00:00.0");
            currAppdate = new SimpleDateFormat(this.genericUtility.getApplDateFormat()).format(currDate).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return currAppdate;
    }

    public UserInfoBean createUserInfo(String userId) throws BaseException, Exception {
        UserInfoBean userInfoBean = new UserInfoBean();
        ConnDriver connDriver = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                userInfoBean.setLoginCode(userId);
                connDriver = new ConnDriver();
                connection = connDriver.getConnectDB("Driver");
                statement = connection.createStatement();
                String sql = "select EMP_CODE,ENTITY_CODE,PROFILE_ID,USER_TYPE,CHG_TERM,USER_THEME,USER_COUNTRY,USER_LANG,TRANS_DB,SITE_CODE__DEF from users where code='" + userId + "'";
                resultSet = statement.executeQuery(sql);
                if (resultSet.next()) {
                    userInfoBean.setEmpCode(E12GenericUtility.checkNull((String)resultSet.getString("EMP_CODE")));
                    userInfoBean.setEntityCode(E12GenericUtility.checkNull((String)resultSet.getString("ENTITY_CODE")));
                    userInfoBean.setProfileId(E12GenericUtility.checkNull((String)resultSet.getString("PROFILE_ID")));
                    userInfoBean.setUserType(E12GenericUtility.checkNull((String)resultSet.getString("USER_TYPE")));
                    userInfoBean.setRemoteHost(E12GenericUtility.checkNull((String)resultSet.getString("CHG_TERM")));
                    userInfoBean.setUserTheme(E12GenericUtility.checkNull((String)resultSet.getString("USER_THEME")));
                    userInfoBean.setUserCountry(E12GenericUtility.checkNull((String)resultSet.getString("USER_COUNTRY")));
                    userInfoBean.setUserLanguage(E12GenericUtility.checkNull((String)resultSet.getString("USER_LANG")));
                    userInfoBean.setTransDB(E12GenericUtility.checkNull((String)resultSet.getString("TRANS_DB")));
                    userInfoBean.setSiteCode(E12GenericUtility.checkNull((String)resultSet.getString("SITE_CODE__DEF")));
                    System.out.println("CommonDBAccessEjb createUserInfo()::::::" + userInfoBean.toString());
                }
            }
            catch (Exception e) {
                System.out.println("Exception in CommonDBAccessEJB createUserInfo()........." + e);
                UserInfoBean userInfoBean2 = userInfoBean;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                return userInfoBean2;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (connection != null) {
            connection.close();
        }
        return userInfoBean;
    }

    public int getPageCount(File fileTobeAttached) {
        String filePath = fileTobeAttached.toString();
        String fileName = fileTobeAttached.getName();
        String fileType = fileName.substring(fileName.indexOf(".") + 1);
        int pageCount = 0;
        try {
            if ("pdf".equalsIgnoreCase(fileType)) {
                PdfReader reader = new PdfReader(filePath);
                pageCount = reader.getNumberOfPages();
            } else if ("doc".equalsIgnoreCase(fileType)) {
                try {
                    POIFSFileSystem fis = new POIFSFileSystem((InputStream)new FileInputStream(fileTobeAttached));
                    HWPFDocument wdDoc = new HWPFDocument(fis);
                    pageCount = wdDoc.getSummaryInformation().getPageCount();
                    wdDoc.close();
                }
                catch (Exception e) {
                    System.out.println("In getPageCount Exception [" + e.getMessage() + "]");
                    e.printStackTrace();
                }
            } else if ("docx".equalsIgnoreCase(fileType)) {
                byte[] inputBytePDF = null;
                try {
                    FileInputStream fin = new FileInputStream(fileTobeAttached);
                    inputBytePDF = new byte[(int)fileTobeAttached.length()];
                    fin.read(inputBytePDF);
                    fin.close();
                    ByteArrayInputStream docxInputStream = new ByteArrayInputStream(inputBytePDF);
                    Document wordDoc = new Document((InputStream)docxInputStream);
                    pageCount = wordDoc.getPageCount();
                }
                catch (Exception e2) {
                    System.out.println("In docx type Exception [" + e2.getMessage() + "]");
                    e2.printStackTrace();
                }
            }
        }
        catch (IOException e3) {
            System.out.println("In doc type Exception [" + e3.getMessage() + "]");
            e3.printStackTrace();
        }
        return pageCount;
    }

    private byte[] getPdfPreviewImage(String filepath) {
        byte[] bytes = new byte[1];
        File file = new File(filepath);
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (PDDocument document = PDDocument.load((File)file);){
                PDFRenderer pdfRenderer = new PDFRenderer(document);
                BufferedImage bufferedImage = pdfRenderer.renderImageWithDPI(0, 50.0f, ImageType.RGB);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
                bytes = outputStream.toByteArray();
                document.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            BaseLogger.log((String)"0", null, (String)"DocumentHandlerWrapperEJB", (Object)("IOException while trying to create pdf document - " + ex));
            return bytes;
        }
        catch (Exception ex) {
            BaseLogger.log((String)"0", null, (String)"DocumentHandlerWrapperEJB", (Object)("Other exception while trying to create pdf document - " + ex));
            return bytes;
        }
        return bytes;
    }

    private byte[] getTextToImage(String filepath) {
        byte[] bytes = new byte[1];
        File file = new File(filepath);
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            bytes = this.convert(sb.toString(), String.valueOf(filepath) + "_img");
            br.close();
        }
        catch (IOException ex) {
            BaseLogger.log((String)"0", null, (String)"DocumentHandlerWrapperEJB", (Object)("IOException while trying to create txt document - " + ex));
            return bytes;
        }
        catch (Exception ex) {
            BaseLogger.log((String)"0", null, (String)"DocumentHandlerWrapperEJB", (Object)("Other exception while trying to create txt document - " + ex));
            return bytes;
        }
        return bytes;
    }

    private byte[] convert(String text, String img_name) {
        String[] text_array = text.split("[\n]");
        BufferedImage img = new BufferedImage(1, 1, 2);
        Graphics2D g2d = img.createGraphics();
        Font font = new Font("Consolas", 1, 12);
        g2d.setFont(font);
        FontMetrics fm = g2d.getFontMetrics();
        int width = fm.stringWidth(CreateReportAndAttach.getLongestLine(text_array));
        int lines = CreateReportAndAttach.getLineCount(text);
        int height = fm.getHeight() * (lines + 4);
        g2d.dispose();
        img = new BufferedImage(width, height, 2);
        g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setFont(font);
        fm = g2d.getFontMetrics();
        g2d.setColor(Color.BLACK);
        int i = 1;
        while (i <= lines) {
            g2d.drawString(text_array[i - 1], 0, fm.getAscent() * i);
            ++i;
        }
        g2d.dispose();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", outputStream);
            BaseLogger.log((String)"0", null, null, (Object)("Print inside convert outputStream::::::: " + outputStream));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return outputStream.toByteArray();
    }

    private static String getLongestLine(String[] arr) {
        String max = arr[0];
        int i = 1;
        while (i < arr.length) {
            if (max.length() < arr[i].length()) {
                max = arr[i];
            }
            ++i;
        }
        return max;
    }

    public static int getLineCount(String text) {
        return text.split("[\n]").length;
    }

    private byte[] getVideoPreviewImage(String strGrabFrame, String filePath, UserInfoBean userInfo) {
        byte[] videoFrameByteArray;
        block11: {
            videoFrameByteArray = new byte[1];
            try {
                boolean grabFrame = new Boolean(strGrabFrame);
                if (!grabFrame) break block11;
                File videoFile = new File(filePath);
                if (videoFile.exists()) {
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("@@@@@ DocumentHandlerServlet :: addDocument() : Video file found at [" + videoFile.toString() + "]"));
                    try {
                        int totalFrames = 0;
                        int frameNumber = 10;
                        try {
                            FileChannelWrapper ch = NIOUtils.readableFileChannel((File)videoFile);
                            MP4Demuxer demuxer = new MP4Demuxer((SeekableByteChannel)ch);
                            AbstractMP4DemuxerTrack video_track = demuxer.getVideoTrack();
                            totalFrames = video_track.getMeta().getTotalFrames();
                            frameNumber = totalFrames * 10 / 100;
                        }
                        catch (Exception e) {
                            BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)("Exception in DocumentHandlerServlet :: getVideoPreviewImage() : " + e));
                        }
                        Picture picFrame = FrameGrab.getNativeFrame((File)videoFile, (int)frameNumber);
                        int height = picFrame.getHeight();
                        int width = picFrame.getWidth();
                        ColorSpace picColorSpace = picFrame.getColor();
                        if (picColorSpace != ColorSpace.RGB) {
                            Transform transform = ColorUtil.getTransform((ColorSpace)picFrame.getColor(), (ColorSpace)ColorSpace.RGB);
                            Picture newPic = Picture.create((int)width, (int)height, (ColorSpace)ColorSpace.RGB);
                            transform.transform(picFrame, newPic);
                            picFrame = newPic;
                        }
                        BufferedImage bufferedImage = new BufferedImage(width, height, 5);
                        byte[] bufferedImageData = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                        int[] picData = picFrame.getPlaneData(0);
                        int i = 0;
                        int len = bufferedImageData.length;
                        while (i < len) {
                            bufferedImageData[i] = (byte)picData[i];
                            ++i;
                        }
                        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)bufferedImage, "png", arrayOutputStream);
                        videoFrameByteArray = arrayOutputStream.toByteArray();
                    }
                    catch (IOException ex) {
                        BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)("Exception in DocumentHandlerServlet :: addDocument() : " + ex));
                    }
                    catch (JCodecException ex) {
                        BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)("Exception in DocumentHandlerServlet :: addDocument() : " + (Object)((Object)ex)));
                    }
                    catch (Exception ex) {
                        BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)("Exception in DocumentHandlerServlet :: addDocument() : " + ex));
                    }
                    break block11;
                }
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("@@@@@ DocumentHandlerServlet :: addDocument() : Video file NOT found at [" + videoFile.toString() + "]"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return videoFrameByteArray;
    }

    public boolean isReportgenerated(String reportName, String refID, UserInfoBean userInfo, String docIDs, String userCode) {
        File[] files;
        BaseLogger.log((String)"3", null, null, (Object)("@@@@@ CreateReportAndAttach :: isReportgenerated() reportName : [" + reportName + "]"));
        BaseLogger.log((String)"3", null, null, (Object)("@@@@@ CreateReportAndAttach :: isReportgenerated() refID : [" + refID + "]"));
        boolean result = false;
        String reportFilePath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "webitm" + File.separator + "reports" + File.separator + "finalreport" + File.separator + userInfo.getLoginCode();
        BaseLogger.log((String)"3", null, null, (Object)("@@@@@ CreateReportAndAttach :: isReportgenerated() reportFilePath : [" + reportFilePath + "]"));
        ArrayList<String> wordsToMatch = new ArrayList<String>(Arrays.asList(reportName, refID));
        BaseLogger.log((String)"3", null, null, (Object)("@@@@@ CreateReportAndAttach :: isReportgenerated() wordsToMatch : [" + wordsToMatch + "]"));
        File directory = new File(reportFilePath);
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && CreateReportAndAttach.containsAllWordsInFileName(file, wordsToMatch)) {
                    result = true;
                    DocumentHandlerWrapperEJB docHandler = new DocumentHandlerWrapperEJB();
                    try {
                        docHandler.deleteBulkAttachments(docIDs, userCode, userInfo);
                    }
                    catch (ITMException | RemoteException e) {
                        e.printStackTrace();
                    }
                    BaseLogger.log((String)"3", null, null, (Object)("@@@@@ CreateReportAndAttach :: isReportgenerated() result : [" + result + "]"));
                }
                ++n2;
            }
        }
        return result;
    }

    public boolean isTNCAgreed(String tncCode, String userCode, String transDB) throws SQLException {
        boolean result = false;
        BaseLogger.log((String)"3", null, null, (Object)"Inside isTNCAgreed ...");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(transDB);
                String isTNCAgreedSQL = "SELECT * FROM TNC_ACCEPT WHERE TNC_CODE = ? AND USER_CODE = ?";
                PreparedStatement isTNCAgreedPS = connection.prepareStatement(isTNCAgreedSQL);
                isTNCAgreedPS.setString(1, tncCode);
                isTNCAgreedPS.setString(2, userCode);
                ResultSet isTNCAgreedRS = isTNCAgreedPS.executeQuery();
                if (isTNCAgreedRS.next()) {
                    BaseLogger.log((String)"3", null, null, (Object)"Inside isTNCAgreed result is true...");
                    result = true;
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return result;
    }

    public static boolean containsAllWordsInFileName(File file, List<String> wordsToMatch) {
        String fileName = file.getName();
        for (String word : wordsToMatch) {
            if (fileName.contains(word)) continue;
            return false;
        }
        return true;
    }

    private String getTNCCodesFromDOCID(UserInfoBean userInfo, String docIds) throws SQLException {
        StringJoiner tncCodeJoiner;
        String tncCodes;
        block19: {
            String[] ids;
            BaseLogger.log((String)"3", null, null, (Object)"Inside getTNCCodesFromDOCID ...");
            tncCodes = "";
            StringJoiner idsJoiner = new StringJoiner("','", "('", "')");
            tncCodeJoiner = new StringJoiner(":");
            String[] stringArray = ids = docIds.split(":");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                idsJoiner.add(id);
                ++n2;
            }
            Connection connection = null;
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    ConnDriver connDriver = new ConnDriver();
                    connection = connDriver.getConnectDB(userInfo.getTransDB());
                    String getDocIDsSQL = "SELECT TNC_CODE FROM TNC_DOC_MST WHERE TNC_DOC_NAME IN" + idsJoiner.toString();
                    pstmt = connection.prepareStatement(getDocIDsSQL);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String tncCode = rs.getString("TNC_CODE");
                        System.out.println("tncCode gsb " + tncCode);
                        tncCodeJoiner.add(tncCode);
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                    if (connection != null) {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (connection != null) {
                            connection.close();
                            connection = null;
                        }
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                throw throwable;
            }
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        BaseLogger.log((String)"3", null, null, (Object)("tncCodes gsb" + tncCodes));
        tncCodes = tncCodeJoiner.toString();
        return tncCodes;
    }

    private String getDocIDs(UserInfoBean userInfo, List<String> documentWordsToMatch) throws SQLException {
        StringJoiner idsJoiner;
        String docIDs;
        block19: {
            BaseLogger.log((String)"3", null, null, (Object)"Inside getDocIDs ...");
            docIDs = "";
            idsJoiner = new StringJoiner(":");
            Connection connection = null;
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    ConnDriver connDriver = new ConnDriver();
                    connection = connDriver.getConnectDB(userInfo.getTransDB());
                    StringJoiner conditionJoiner = new StringJoiner(" AND ");
                    for (String word : documentWordsToMatch) {
                        conditionJoiner.add("DOC_NAME LIKE '%" + word + "%'");
                    }
                    String getDocIDsSQL = "SELECT DOC_ID FROM DOC_CONTENTS WHERE " + conditionJoiner.toString();
                    pstmt = connection.prepareStatement(getDocIDsSQL);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String docID = rs.getString("DOC_ID");
                        idsJoiner.add(docID);
                        System.out.println("docID gsb " + docID);
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                    if (connection != null) {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (connection != null) {
                            connection.close();
                            connection = null;
                        }
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                throw throwable;
            }
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        docIDs = idsJoiner.toString();
        System.out.println("docIDs gsb " + docIDs);
        return docIDs;
    }

    private void createTNCDoc(UserInfoBean userInfo, String docID, String docVer, String entityCode, String siteCode, String finEntity) throws SQLException {
        BaseLogger.log((String)"3", null, null, (Object)"Inside createTNCDoc ...");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
                String tncCode = commonDBAccessEJB.generateSeq("TNC_DOC_MST_SEQ", 10, userInfo.getTransDB());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new java.util.Date());
                calendar.add(1, 10);
                Date toDate = new Date(calendar.getTime().getTime());
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String selectTncDocMst = "SELECT * FROM TNC_DOC_MST WHERE ENTITY_CODE__APPL = 'E' AND ENTITY_CODE = ?";
                PreparedStatement selectTncDocMstPS = connection.prepareStatement(selectTncDocMst);
                selectTncDocMstPS.setString(1, entityCode);
                ResultSet selectTncDocMstRS = selectTncDocMstPS.executeQuery();
                if (selectTncDocMstRS.next()) {
                    BaseLogger.log((String)"3", null, null, (Object)"updating tnc_doc_mst");
                    tncCode = selectTncDocMstRS.getString("TNC_CODE");
                    docVer = CreateReportAndAttach.incrementVersion(docVer);
                    this.updateTNCDoc(userInfo, docID, docVer, tncCode);
                } else {
                    BaseLogger.log((String)"3", null, null, (Object)"INSERTING  tnc_doc_mst");
                    String insertTncDocMst = "INSERT INTO TNC_DOC_MST (TNC_CODE,DATE_FROM,DATE_TO,SITE_CODE__APPL,TNC_DOC_NAME,TNC_DOC_TYPE,CHG_DATE,CHG_USER,CHG_TERM,DOC_VER,TNC_TYPE,ENTITY_CODE__APPL,TNC_DESCR,FIN_ENTITY,IS_INTIMATED,TNC_DOC_DESCR,ALLOW_IGNORE,ENTITY_CODE) VALUES \n(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    pstmt = connection.prepareStatement(insertTncDocMst);
                    pstmt.setString(1, tncCode);
                    pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                    pstmt.setDate(3, toDate);
                    pstmt.setString(4, siteCode);
                    pstmt.setString(5, docID);
                    pstmt.setString(6, "pdf");
                    pstmt.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(8, userInfo.getLoginCode());
                    pstmt.setString(9, userInfo.getTermId());
                    pstmt.setString(10, docVer);
                    pstmt.setString(11, "COC");
                    pstmt.setString(12, "E");
                    pstmt.setString(13, null);
                    pstmt.setString(14, finEntity);
                    pstmt.setString(15, "N");
                    pstmt.setString(16, null);
                    pstmt.setString(17, "0");
                    pstmt.setString(18, entityCode);
                    int insCnt = pstmt.executeUpdate();
                    if (insCnt > 0) {
                        connection.commit();
                    }
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
    }

    private void updateTNCDoc(UserInfoBean userInfo, String docID, String docVer, String tncCode) throws SQLException {
        BaseLogger.log((String)"3", null, null, (Object)"Inside updateTNCDoc ...");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String getDocIDsSQL = "UPDATE TNC_DOC_MST SET TNC_DOC_NAME = ? , DOC_VER = ? WHERE TNC_CODE = ?";
                pstmt = connection.prepareStatement(getDocIDsSQL);
                pstmt.setString(1, docID);
                pstmt.setString(2, docVer);
                pstmt.setString(3, tncCode);
                int updateCnt = pstmt.executeUpdate();
                if (updateCnt > 0) {
                    connection.commit();
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
    }

    public static void findAndDeleteFile(String directoryPath, String fileNameToDelete) {
        System.out.println("Inside findAndDeleteFile...");
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            System.out.println("Directory does not exist: " + directoryPath);
            return;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    CreateReportAndAttach.findAndDeleteFile(file.getAbsolutePath(), fileNameToDelete);
                } else if (file.isFile() && file.getName().equals(fileNameToDelete)) {
                    if (file.delete()) {
                        System.out.println("Deleted file: " + file.getAbsolutePath());
                    } else {
                        System.err.println("Failed to delete file: " + file.getAbsolutePath());
                    }
                }
                ++n2;
            }
        }
    }

    public static String incrementVersion(String version) {
        String[] parts = version.split("\\.");
        if (parts.length == 2) {
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            return String.valueOf(++major) + "." + minor;
        }
        return version;
    }
}

