/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.MailInfo;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ITMMailInfo
extends MailInfo {
    String formatCode = "";
    String emailType = "";
    String entityCode = "";
    String entityType = "";
    String objName = "";
    String refID = "";
    String refSer = "";
    String lineNo = "";
    String xslFileName = "";
    String transInfo = "";
    String domString = "";
    String xmlDataFilePath;
    String toAddr = "";
    String ccAddr = "";
    String bccAddr = "";
    String subject = "";
    String message = "";
    String attachType = "";
    String processInstanceId = "";
    String linkAddr = "";
    String messageType = null;
    private String transactionXML = "";
    HashMap<String, String> inlineImages = null;
    String mailFrom = "";

    @Override
    public String getMailFrom() {
        return this.mailFrom;
    }

    @Override
    public void setMailFrom(String mailFrom) {
        this.mailFrom = mailFrom;
    }

    public void setFormatCode(String formatCode) throws ITMException {
        this.formatCode = formatCode;
    }

    public String getFormatCode() {
        return this.formatCode;
    }

    @Override
    public void setEmailType(String emailType) {
        this.emailType = emailType;
    }

    @Override
    public String getEmailType() {
        return this.emailType;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    @Override
    public String getObjName() {
        return this.objName;
    }

    public void setRefID(String refID) {
        this.refID = refID;
    }

    public String setRefID() {
        return this.refID;
    }

    public void setRefSer(String refSer) {
        this.refSer = refSer;
    }

    @Override
    public String getRefSer() {
        return this.refSer;
    }

    public void setLineNo(String lineNo) {
        this.lineNo = lineNo;
    }

    @Override
    public String getLineNo() {
        return this.lineNo;
    }

    public void setXslFileName(String xslFileName) {
        this.xslFileName = xslFileName;
    }

    @Override
    public String getXslFileName() {
        return this.xslFileName;
    }

    @Override
    public void setToAddr(String toAddr) {
        this.toAddr = toAddr;
    }

    @Override
    public String getToAddr() {
        return this.toAddr;
    }

    @Override
    public void setCcAddr(String ccAddr) {
        this.ccAddr = ccAddr;
    }

    @Override
    public String getCcAddr() {
        return this.ccAddr;
    }

    @Override
    public void setBccAddr(String bccAddr) {
        this.bccAddr = bccAddr;
    }

    @Override
    public String getBccAddr() {
        return this.bccAddr;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getLinkAddr() {
        return this.linkAddr;
    }

    public void setLinkAddr(String linkAddr) {
        this.linkAddr = linkAddr;
    }

    public void setAttachType(String attachType) {
        this.attachType = attachType;
    }

    public String getAttachType() {
        return this.attachType;
    }

    public void setAttachContent(String transInfo) throws ITMException {
        this.transInfo = transInfo;
    }

    public String getAttachContent() {
        return this.transInfo;
    }

    public void setDomString(String domString) throws ITMException {
        this.domString = domString;
    }

    public String getDomString() throws ITMException {
        return this.domString;
    }

    @Override
    public void setXmlDataFilePath(String xmlDataFilePath) {
        this.xmlDataFilePath = xmlDataFilePath;
    }

    @Override
    public String getXmlDataFilePath() {
        return this.xmlDataFilePath;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getMessageType() {
        return this.messageType;
    }

    @Override
    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    @Override
    public HashMap<String, String> getInlineImages() {
        return this.inlineImages;
    }

    @Override
    public void setInlineImages(HashMap<String, String> inlineImages) {
        this.inlineImages = inlineImages;
    }

    @Override
    public void setMailProp(String mailXMLStr) throws ITMException {
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            mailXMLStr = genericUtility.setXmlDec(mailXMLStr);
            BaseLogger.log("3", null, null, "mailXMLStr @@@ \n" + mailXMLStr);
            Document mailInfoDom = this.parseString(mailXMLStr);
            this.objName = this.getValueOfField(mailInfoDom, "OBJ_NAME");
            this.refID = this.getValueOfField(mailInfoDom, "REF_ID");
            this.refSer = this.getValueOfField(mailInfoDom, "REF_SER");
            this.lineNo = this.getValueOfField(mailInfoDom, "LINE_NO");
            this.xslFileName = this.getValueOfField(mailInfoDom, "XSL_FILE_NAME");
            this.emailType = this.getValueOfField(mailInfoDom, "EMAIL_TYPE");
            this.domString = this.getValueOfField(mailInfoDom, "XML_DATA");
            this.formatCode = this.getValueOfField(mailInfoDom, "FORMAT_CODE");
            this.xmlDataFilePath = this.getValueOfField(mailInfoDom, "XML_DATA_FILE_PATH");
            this.toAddr = this.getValueOfField(mailInfoDom, "TO_ADD");
            this.ccAddr = this.getValueOfField(mailInfoDom, "CC_ADD");
            this.bccAddr = this.getValueOfField(mailInfoDom, "BCC_ADD");
            this.entityCode = this.getValueOfField(mailInfoDom, "ENTITY_CODE");
            this.entityType = this.getValueOfField(mailInfoDom, "ENTITY_TYPE");
            this.message = this.getValueOfField(mailInfoDom, "BODY_TEXT");
            this.subject = this.getValueOfField(mailInfoDom, "SUBJECT");
            this.linkAddr = this.getValueOfField(mailInfoDom, "LINK_ADDR");
            this.processInstanceId = this.getValueOfField(mailInfoDom, "PRC_ID");
            this.mailFrom = this.getValueOfField(mailInfoDom, "MAIL_FROM");
            this.messageType = this.getValueOfField(mailInfoDom, "MESSAGE_TYPE");
            if (mailInfoDom.getElementsByTagName("INLINE_IMAGES") != null && mailInfoDom.getElementsByTagName("INLINE_IMAGES").item(0) != null && mailInfoDom.getElementsByTagName("INLINE_IMAGES").item(0).getFirstChild() != null) {
                NodeList imageNodeList = mailInfoDom.getElementsByTagName("INLINE_IMAGES").item(0).getChildNodes();
                this.inlineImages = new HashMap();
                int i = 0;
                while (i <= imageNodeList.getLength()) {
                    Node imageNode = imageNodeList.item(i);
                    BaseLogger.log("9", null, null, "imageNode:" + imageNode);
                    if (imageNode != null && imageNode.getFirstChild() != null) {
                        this.inlineImages.put(imageNode.getNodeName(), imageNode.getFirstChild().getNodeValue());
                    }
                    ++i;
                }
                BaseLogger.log("3", null, null, "this.inlineImages:" + this.inlineImages.toString());
            }
            this.setMailDetails();
            if ("".equals(E12GenericUtility.checkNull(this.toAddr))) {
                BaseLogger.log("3", null, null, "In ITMMailInfo setMailProp 1 TO_ADD is null");
                throw new ITMException("CUSTOM_MESSAGE:In Mail sending TO_ADD is null", new Exception());
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ITMMailInfo :setMailProp 1:==>\n" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private void setMailDetails() throws ITMException {
        ArrayList mailDetailList = null;
        boolean emailFlag = false;
        String argType = "";
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            DBAccessEJB dbAccess = new DBAccessEJB();
            if (this.formatCode != null && this.formatCode.length() > 0) {
                mailDetailList = dbAccess.getMailDetailList(this.formatCode);
            }
            BaseLogger.log("3", null, null, "[ITMMailInfo] mail detail found for format code :" + this.formatCode + ":");
            BaseLogger.log("3", null, null, "[ITMMailInfo] mailDetailList  :" + mailDetailList + ":");
            if (mailDetailList != null && mailDetailList.size() > 0) {
                String endIndex;
                String startIndex;
                String currToken;
                int i;
                ArrayList tokens;
                String to = "";
                String cc = "";
                String bcc = "";
                if ((String)mailDetailList.get(0) != null) {
                    to = (String)mailDetailList.get(0);
                }
                if ((String)mailDetailList.get(1) != null) {
                    cc = (String)mailDetailList.get(1);
                }
                if ((String)mailDetailList.get(2) != null) {
                    bcc = (String)mailDetailList.get(2);
                }
                if (cc == null) {
                    cc = "";
                }
                if (bcc == null) {
                    bcc = "";
                }
                String emailId = "";
                if (to.length() > 0) {
                    StringBuffer toAddrBuff = new StringBuffer();
                    tokens = genericUtility.getTokenList(to, ",");
                    BaseLogger.log("3", null, null, "tokens " + tokens);
                    i = 0;
                    while (i < tokens.size()) {
                        currToken = (String)tokens.get(i);
                        if (currToken.indexOf("{") != -1) {
                            BaseLogger.log("3", null, null, "To with '{' :[" + currToken + "]");
                            startIndex = "";
                            endIndex = "";
                            if (currToken.charAt(1) == '(') {
                                startIndex = "(";
                                endIndex = ")";
                            } else if (currToken.charAt(1) == '[') {
                                startIndex = "[";
                                endIndex = "]";
                            }
                            argType = currToken.substring(currToken.indexOf(startIndex) + 1, currToken.indexOf(endIndex));
                            this.entityType = argType.length() == 1 ? argType : argType.substring(0, 1);
                            BaseLogger.log("3", null, null, "argType :::: [" + argType + "] ");
                            if (argType != null && argType.trim().length() > 0) {
                                emailId = this.getEmailAddr(argType, currToken.substring(currToken.indexOf(endIndex) + 1, currToken.length() - 1));
                                if ((emailId = E12GenericUtility.checkNull(emailId)).length() > 0) {
                                    toAddrBuff.append(emailId).append(",");
                                }
                            }
                        } else if (currToken.indexOf("<") != -1) {
                            BaseLogger.log("3", null, null, "To with '<' :[" + currToken + "]");
                            emailId = this.customizeDataStr(currToken, this.domString);
                            emailId = E12GenericUtility.checkNull(emailId);
                            if (emailId.length() > 0) {
                                toAddrBuff.append(emailId).append(",");
                            }
                        } else if (currToken.indexOf("[") != -1) {
                            BaseLogger.log("3", null, null, "To with '[' :[" + currToken + "]");
                            if (currToken.charAt(1) == '(') {
                                this.entityType = currToken.substring(2, 3);
                                currToken = currToken.substring(4, currToken.length() - 1);
                            } else {
                                currToken = currToken.substring(1, currToken.length() - 1);
                            }
                            if (currToken.equals("ROLE_CODE")) {
                                emailId = this.getRoleCodeEmailAddr(this.entityType);
                                if ((emailId = E12GenericUtility.checkNull(emailId)).length() > 0) {
                                    toAddrBuff.append(emailId).append(",");
                                }
                            }
                        } else {
                            emailId = E12GenericUtility.checkNull(currToken);
                            if (emailId.length() > 0) {
                                toAddrBuff.append(emailId).append(",");
                            }
                        }
                        ++i;
                    }
                    this.toAddr = this.toAddr != null && !this.toAddr.equalsIgnoreCase("null") && this.toAddr.trim().length() > 0 ? String.valueOf(this.toAddr) + "," + toAddrBuff.toString() : toAddrBuff.toString();
                    BaseLogger.log("3", null, null, "this.toAddr " + this.toAddr.toString());
                    if (this.toAddr.endsWith(",")) {
                        this.toAddr = this.toAddr.substring(0, this.toAddr.length() - 1);
                    }
                }
                if (cc.length() > 0) {
                    StringBuffer ccAddrBuff = new StringBuffer();
                    tokens = genericUtility.getTokenList(cc, ",");
                    BaseLogger.log("3", null, null, "tokens " + tokens);
                    i = 0;
                    while (i < tokens.size()) {
                        currToken = (String)tokens.get(i);
                        if (currToken.indexOf("{") != -1) {
                            BaseLogger.log("3", null, null, "CC with '{' :[" + currToken + "]");
                            startIndex = "";
                            endIndex = "";
                            if (currToken.charAt(1) == '(') {
                                startIndex = "(";
                                endIndex = ")";
                            } else if (currToken.charAt(1) == '[') {
                                startIndex = "[";
                                endIndex = "]";
                            }
                            argType = currToken.substring(currToken.indexOf(startIndex) + 1, currToken.indexOf(endIndex));
                            BaseLogger.log("3", null, null, "argType :::: [" + argType + "] ");
                            this.entityType = argType.length() == 1 ? argType : argType.substring(0, 1);
                            if (argType != null && argType.trim().length() > 0) {
                                emailId = this.getEmailAddr(argType, currToken.substring(currToken.indexOf(endIndex) + 1, currToken.length() - 1));
                                if ((emailId = E12GenericUtility.checkNull(emailId)).length() > 0) {
                                    ccAddrBuff.append(emailId).append(",");
                                }
                            }
                        } else if (currToken.indexOf("<") != -1) {
                            BaseLogger.log("3", null, null, "To with '<' :[" + currToken + "]");
                            emailId = this.customizeDataStr(currToken, this.domString);
                            emailId = E12GenericUtility.checkNull(emailId);
                            if (emailId.length() > 0) {
                                ccAddrBuff.append(emailId).append(",");
                            }
                        } else if (currToken.indexOf("[") != -1) {
                            BaseLogger.log("3", null, null, "To with '[' :[" + currToken + "]");
                            if (currToken.charAt(1) == '(') {
                                this.entityType = currToken.substring(2, 3);
                                currToken = currToken.substring(4, currToken.length() - 1);
                            } else {
                                currToken = currToken.substring(1, currToken.length() - 1);
                            }
                            if (currToken.equals("ROLE_CODE")) {
                                emailId = this.getRoleCodeEmailAddr(this.entityType);
                                if ((emailId = E12GenericUtility.checkNull(emailId)).length() > 0) {
                                    ccAddrBuff.append(emailId).append(",");
                                }
                            }
                        } else {
                            emailId = E12GenericUtility.checkNull(currToken);
                            if (emailId.length() > 0) {
                                ccAddrBuff.append(emailId).append(",");
                            }
                        }
                        this.ccAddr = this.ccAddr != null && this.ccAddr.equalsIgnoreCase("null") && this.ccAddr.trim().length() > 0 ? String.valueOf(this.ccAddr) + "," + ccAddrBuff.toString() : ccAddrBuff.toString();
                        BaseLogger.log("3", null, null, "this.ccAddr" + this.ccAddr);
                        if (this.ccAddr.endsWith(",")) {
                            this.ccAddr = this.ccAddr.substring(0, this.ccAddr.length() - 1);
                        }
                        ++i;
                    }
                    BaseLogger.log("3", null, null, "ccAddrBuff " + ccAddrBuff.toString());
                    this.ccAddr = ccAddrBuff.toString();
                    if (this.ccAddr.endsWith(",")) {
                        this.ccAddr = this.ccAddr.substring(0, this.ccAddr.length() - 1);
                    }
                }
                if (bcc.length() > 0) {
                    StringBuffer bccAddrBuff = new StringBuffer();
                    tokens = genericUtility.getTokenList(bcc, ",");
                    BaseLogger.log("3", null, null, "tokens " + tokens);
                    i = 0;
                    while (i < tokens.size()) {
                        currToken = (String)tokens.get(i);
                        if (currToken.indexOf("{") != -1) {
                            BaseLogger.log("3", null, null, "BCC with '{' :[" + currToken + "]");
                            startIndex = "";
                            endIndex = "";
                            if (currToken.charAt(1) == '(') {
                                startIndex = "(";
                                endIndex = ")";
                            } else if (currToken.charAt(1) == '[') {
                                startIndex = "[";
                                endIndex = "]";
                            }
                            argType = currToken.substring(currToken.indexOf(startIndex) + 1, currToken.indexOf(endIndex));
                            BaseLogger.log("3", null, null, "argType :::: [" + argType + "] ");
                            this.entityType = argType.length() == 1 ? argType : argType.substring(0, 1);
                            if (argType != null && argType.trim().length() > 0) {
                                emailId = this.getEmailAddr(argType, currToken.substring(currToken.indexOf(endIndex) + 1, currToken.length() - 1));
                                if ((emailId = E12GenericUtility.checkNull(emailId)).length() > 0) {
                                    bccAddrBuff.append(emailId).append(",");
                                }
                            }
                        } else if (currToken.indexOf("<") != -1) {
                            BaseLogger.log("3", null, null, "To with '<' :[" + currToken + "]");
                            emailId = this.customizeDataStr(currToken, this.domString);
                            emailId = E12GenericUtility.checkNull(emailId);
                            if (emailId.length() > 0) {
                                bccAddrBuff.append(emailId).append(",");
                            }
                        } else if (currToken.indexOf("[") != -1) {
                            BaseLogger.log("3", null, null, "To with '[' :[" + currToken + "]");
                            if (currToken.charAt(1) == '(') {
                                this.entityType = currToken.substring(2, 3);
                                currToken = currToken.substring(4, currToken.length() - 1);
                            } else {
                                currToken = currToken.substring(1, currToken.length() - 1);
                            }
                            if (currToken.equals("ROLE_CODE")) {
                                emailId = this.getRoleCodeEmailAddr(this.entityType);
                                if ((emailId = E12GenericUtility.checkNull(emailId)).length() > 0) {
                                    bccAddrBuff.append(emailId).append(",");
                                }
                            }
                        } else {
                            emailId = E12GenericUtility.checkNull(currToken);
                            if (emailId.length() > 0) {
                                bccAddrBuff.append(emailId).append(",");
                            }
                        }
                        ++i;
                    }
                    BaseLogger.log("3", null, null, "bccAddrBuff" + this.bccAddr);
                    this.bccAddr = this.bccAddr != null && this.bccAddr.equalsIgnoreCase("null") && this.bccAddr.trim().length() > 0 ? String.valueOf(this.bccAddr) + "," + bccAddrBuff.toString() : bccAddrBuff.toString();
                    if (this.bccAddr.endsWith(",")) {
                        this.bccAddr = this.bccAddr.substring(0, this.bccAddr.length() - 1);
                    }
                }
                if ((String)mailDetailList.get(3) != null && (this.subject == null || this.subject != null && "null".equalsIgnoreCase(this.subject))) {
                    this.subject = (String)mailDetailList.get(3);
                    if (this.subject.indexOf("<") != -1) {
                        this.subject = this.customizeDataStr(this.subject, this.domString);
                    }
                }
                if ((String)mailDetailList.get(4) != null && (this.message == null || this.message != null && "null".equalsIgnoreCase(this.message))) {
                    this.message = (String)mailDetailList.get(4);
                    if (this.message.indexOf("<") != -1) {
                        this.message = this.customizeDataStr(this.message, this.domString);
                    }
                }
                if ((String)mailDetailList.get(5) != null) {
                    this.attachType = (String)mailDetailList.get(5);
                }
            }
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ITMMailInfo :email :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private String getEmailAddr(String argType, String argName) throws ITMException {
        BaseLogger.log("2", null, null, "[ITMMailInfo] argType 2 [" + argType + "], argName [" + argName + "]");
        String retEmailAddr = "";
        try {
            String masterTable = null;
            String whereFieldName = null;
            String selFieldName = null;
            String responsibleFor = "";
            String entityType = "";
            String whereCondition = "";
            if (argType != null && argType.trim().length() > 0) {
                entityType = argType.substring(0, 1);
            }
            if (argType != null && argType.trim().length() > 1) {
                responsibleFor = argType.substring(1, 2);
            }
            if (entityType.equalsIgnoreCase("C")) {
                masterTable = "CUSTOMER";
                argName = argName == null || "".equals(argName) ? "CUST_CODE" : argName;
                whereFieldName = "CUST_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (entityType.equalsIgnoreCase("S")) {
                masterTable = "SUPPLIER";
                argName = argName == null || "".equals(argName) ? "SUPP_CODE" : argName;
                whereFieldName = "SUPP_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (entityType.equalsIgnoreCase("E")) {
                masterTable = "EMPLOYEE";
                argName = argName == null || "".equals(argName) ? "EMP_CODE" : argName;
                whereFieldName = "EMP_CODE";
                selFieldName = "EMAIL_ID_OFF";
            } else if (entityType.equalsIgnoreCase("P")) {
                masterTable = "SALES_PERS";
                argName = argName == null || "".equals(argName) ? "SALES_PERS" : argName;
                whereFieldName = "SALES_PERS";
                selFieldName = "EMAIL_ADDR";
            } else if (entityType.equalsIgnoreCase("G")) {
                masterTable = "STRG_CUSTOMER";
                argName = argName == null || "".equals(argName) ? "SC_CODE" : argName;
                whereFieldName = "SC_CODE";
                selFieldName = "EMAIL_ADDR";
            }
            Document dom = this.parseString(this.domString);
            String whereFieldValue = this.getValueOfField(dom, argName.toLowerCase());
            if (whereFieldValue == null || whereFieldValue != null && whereFieldValue.trim().length() == 0) {
                BaseLogger.log("3", null, null, "Setting entityCode as value ...");
                whereFieldValue = this.entityCode;
            }
            DBAccessEJB dbAccess = new DBAccessEJB();
            BaseLogger.log("3", null, null, "inside ITMMailinfo whereFieldValue==" + whereFieldValue + "==this.entityCode==" + this.entityCode);
            retEmailAddr = responsibleFor != null && responsibleFor.trim().length() > 0 ? dbAccess.getEntityEmailAddr(entityType, whereFieldValue, responsibleFor) : dbAccess.getEmailAddr(selFieldName, masterTable, whereFieldName, whereFieldValue);
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ITMMailInfo :getEmailAddr :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return retEmailAddr;
    }

    private String getRoleCodeEmailAddr(String argType) throws ITMException {
        BaseLogger.log("2", null, null, "[ITMMailInfo] argType getRoleCodeEmailAddr 1 [" + argType + "]");
        String retEmailAddr = "";
        try {
            String masterTable = null;
            String whereFieldName = null;
            String selFieldName = null;
            if (argType.equalsIgnoreCase("C")) {
                masterTable = "CUSTOMER";
                whereFieldName = "CUST_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (argType.equalsIgnoreCase("S")) {
                masterTable = "SUPPLIER";
                whereFieldName = "SUPP_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (argType.equalsIgnoreCase("E")) {
                masterTable = "EMPLOYEE";
                whereFieldName = "EMP_CODE";
                selFieldName = "EMAIL_ID_OFF";
            } else if (argType.equalsIgnoreCase("P")) {
                masterTable = "SALES_PERS";
                whereFieldName = "SALES_PERS";
                selFieldName = "EMAIL_ADDR";
            } else if (argType.equalsIgnoreCase("G")) {
                masterTable = "STRG_CUSTOMER";
                whereFieldName = "SC_CODE";
                selFieldName = "EMAIL_ADDR";
            }
            DBAccessEJB dbAccess = new DBAccessEJB();
            retEmailAddr = dbAccess.getEmailAddr(selFieldName, masterTable, whereFieldName, this.entityCode);
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ITMMailInfo :getEmailAddr :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return retEmailAddr;
    }

    private Document parseString(String xmlString) throws ITMException {
        Document dom = null;
        try {
            if (xmlString != null && xmlString.length() > 0) {
                E12GenericUtility genericUtility = new E12GenericUtility();
                xmlString = genericUtility.setXmlDec(xmlString);
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, CommonConstants.ENCODING);
            ByteArrayInputStream baos = new ByteArrayInputStream(xmlString.getBytes());
            dom = db.parse(baos);
        }
        catch (Exception e) {
            dom = null;
            BaseLogger.log("0", null, null, "Exception :ITMMailInfo :parseString :==>\n" + e);
            throw new ITMException(e);
        }
        return dom;
    }

    private String getValueOfField(Document dom, String fieldName) throws ITMException {
        BaseLogger.log("2", null, null, "Getting value of [" + fieldName + "]");
        String fieldValue = null;
        try {
            Node currField = dom.getElementsByTagName(fieldName).item(0);
            if (currField != null) {
                BaseLogger.log("3", null, null, "[" + fieldName + "] found ");
                if (currField.getFirstChild() != null) {
                    fieldValue = currField.getFirstChild().getNodeType() == 1 ? new E12GenericUtility().serializeDom(currField, true) : currField.getFirstChild().getNodeValue();
                }
            } else {
                BaseLogger.log("3", null, null, "Node [" + fieldName + "] not found ");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ITMMailInfo :getValueOfField() :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return fieldValue;
    }

    private String getValueOfFieldFromStr(String domStr, String fieldName) throws ITMException {
        String fieldValue = "";
        try {
            if (domStr.indexOf(fieldName) != -1) {
                String startTag = "<" + fieldName + ">";
                String endTag = "</" + fieldName + ">";
                fieldValue = domStr.substring(domStr.indexOf(startTag) + startTag.length(), domStr.indexOf(endTag));
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ITMMailInfo :getValueOfField() :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return fieldValue.trim();
    }

    public File createLink() throws ITMException {
        BaseLogger.log("2", null, null, "Creating File Obj Link ..");
        BaseLogger.log("2", null, null, "Application id form ibase[sunny]::::[" + CommonConstants.appStore_id + " ]");
        File linkFileObj = new File(".." + File.separator + "xmldatafiles" + File.separator + "link" + Math.random() + ".html");
        String link = null;
        try {
            if (this.linkAddr != null && this.linkAddr.length() > 0) {
                if (this.linkAddr.indexOf("<") != -1) {
                    this.linkAddr = this.customizeDataStr(this.linkAddr, this.domString);
                }
                link = String.valueOf(CommonConstants.TOMCAT_HOME) + "/ibase/" + "webitm" + "/jsp/" + this.linkAddr.trim();
            } else {
                link = String.valueOf(CommonConstants.TOMCAT_HOME) + "/ibase/" + "webitm" + "/jsp/" + "signature.jsp?OBJ_NAME=" + this.objName + "&REF_SER=" + this.refSer + "&REF_ID=" + URLEncoder.encode(this.refID, CommonConstants.ENCODING).replaceAll("\\+", "%20") + "&LINE_NO=" + this.lineNo + "&XSL_FILE_NAME=" + this.xslFileName + "&APPNAME=" + CommonConstants.app_name + "&APPSTORE_ID=" + CommonConstants.appStore_id;
                BaseLogger.log("3", null, null, "Updated link [" + link + "]");
            }
            FileWriter fw = new FileWriter(linkFileObj);
            fw.write("<HTML>");
            fw.write("<HEAD>");
            fw.write("</HEAD>");
            fw.write("<BODY>");
            fw.write("<a href=" + link + "><strong style=\"background-color: deepskyblue; border: none; color: white; padding: 3px 20px; text-align: center; text-decoration: none; display: inline-block; font-size: 18px; cursor: pointer;\"> View in Application ></strong></a><br>");
            fw.write("</BODY>");
            fw.write("</HTML>");
            fw.flush();
            fw.close();
            BaseLogger.log("3", null, null, "Link to be Mailed Created... :" + link);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ITMMailInfo :createLink :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return linkFileObj;
    }

    @Override
    public File getLinkFileObj(String message) throws ITMException {
        BaseLogger.log("2", null, null, "Creating File Obj Link ..");
        BaseLogger.log("2", null, null, "Application id form ibase[sunny]::::[" + CommonConstants.appStore_id + " ]");
        File linkFileObj = new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "xmldatafiles" + File.separator + "link" + Math.random() + ".html");
        String link = null;
        try {
            if (this.linkAddr != null && this.linkAddr.length() > 0) {
                if (this.linkAddr.indexOf("<") != -1) {
                    this.linkAddr = this.customizeDataStr(this.linkAddr, this.domString);
                }
                link = String.valueOf(CommonConstants.TOMCAT_HOME) + "/ibase/" + "webitm" + "/jsp/" + this.encodeQueryParams(this.linkAddr.trim());
            } else {
                link = String.valueOf(CommonConstants.TOMCAT_HOME) + "/ibase/" + "webitm" + "/jsp/" + "signature.jsp?OBJ_NAME=" + this.objName + "&REF_SER=" + this.refSer + "&REF_ID=" + URLEncoder.encode(this.refID, CommonConstants.ENCODING).replaceAll("\\+", "%20") + "&LINE_NO=" + this.lineNo + "&XSL_FILE_NAME=" + this.xslFileName + "&APPNAME=" + CommonConstants.app_name + "&APPSTORE_ID=" + CommonConstants.appStore_id;
            }
            FileWriter fw = new FileWriter(linkFileObj);
            fw.write("<HTML>");
            fw.write("<HEAD>");
            fw.write("</HEAD>");
            fw.write("<BODY>");
            fw.write("<div>" + message + "</div><br>");
            fw.write("<a href=" + link + "><strong style=\"background-color: deepskyblue; border: none; color: white; padding: 3px 20px; text-align: center; text-decoration: none; display: inline-block; font-size: 18px; cursor: pointer;\"> View in Application ></strong></a><br>");
            fw.write("</BODY>");
            fw.write("</HTML>");
            fw.flush();
            fw.close();
            BaseLogger.log("3", null, null, "Link to be Mailed Created... :" + link);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ITMMailInfo :createLink :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "linkFileObj [" + linkFileObj + "]");
        return linkFileObj;
    }

    private String customizeDataStr(String msgStr, String domString) throws Exception {
        String fieldValue = "";
        String replacedFieldValue = "";
        String currMsgstr = "";
        StringBuffer msgBuff = new StringBuffer();
        try {
            if (msgStr.indexOf("<") != -1) {
                StringTokenizer msgToken = new StringTokenizer(msgStr, ">");
                while (msgToken.hasMoreTokens()) {
                    currMsgstr = msgToken.nextToken();
                    if (currMsgstr.indexOf("<") == -1) continue;
                    int startBracket = currMsgstr.indexOf("<");
                    msgBuff.append(currMsgstr.substring(0, startBracket));
                    fieldValue = currMsgstr.substring(startBracket + 1, currMsgstr.length());
                    BaseLogger.log("3", null, null, "fieldValue[" + fieldValue + "]");
                    replacedFieldValue = !fieldValue.contains(".") ? "<" + fieldValue + ">" : this.getValueOfFieldFromDom(domString, fieldValue);
                    BaseLogger.log("3", null, null, "replacedFieldValue:::[" + replacedFieldValue + "]");
                    msgBuff.append(replacedFieldValue);
                }
                if (!msgStr.endsWith(">")) {
                    String tempStr = msgStr.substring(msgStr.lastIndexOf(">") + 1, msgStr.length());
                    msgBuff.append(tempStr);
                }
            } else {
                msgBuff.append(msgStr);
            }
            BaseLogger.log("3", null, null, " msg buff [" + msgBuff.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msgBuff.toString();
    }

    private String getValueOfFieldFromDom(String domStr, String fieldRequired) throws Exception {
        Object parentNode = null;
        Document dom = null;
        String childNodeName = null;
        Object childNodeName1 = null;
        String fieldValue = null;
        String fromNode = null;
        ArrayList taskList = new ArrayList();
        dom = this.parseString(domStr);
        if (fieldRequired.indexOf(".") != -1) {
            fromNode = fieldRequired.substring(0, fieldRequired.indexOf("."));
            fieldRequired = fieldRequired.substring(fieldRequired.indexOf(".") + 1, fieldRequired.length());
        } else {
            fromNode = fromNode == null ? "Detail1" : fromNode;
        }
        NodeList detailList = dom.getElementsByTagName(fromNode);
        int detListLength = detailList.getLength();
        int ctr = 0;
        while (ctr < detListLength) {
            Node currDetailNode = detailList.item(ctr);
            NodeList childList = currDetailNode.getChildNodes();
            int childCtr = childList.getLength();
            int chCnt = 0;
            while (chCnt < childCtr) {
                Node childNode = childList.item(chCnt);
                childNodeName = childNode.getNodeName();
                if (childNodeName.equalsIgnoreCase(fieldRequired) && childNode.getFirstChild() != null) {
                    fieldValue = childNode.getFirstChild().getNodeValue().trim();
                    BaseLogger.log("3", null, null, "fieldRequired [" + fieldRequired + "] fieldValue  [" + fieldValue + "]");
                }
                ++chCnt;
            }
            ++ctr;
        }
        if ("REMARKS".equalsIgnoreCase(fieldRequired)) {
            E12GenericUtility genericUtility = new E12GenericUtility();
            NodeList nList = dom.getElementsByTagName("WRKFLW_REMARKS");
            int nListLen = nList.getLength();
            int i = 0;
            while (i < nListLen) {
                Node currDetailNode = detailList.item(i);
                genericUtility.removeWhitespaceInner(currDetailNode, null);
                NodeList childList = currDetailNode.getChildNodes();
                int childListLen = childList.getLength();
                int j = 0;
                while (j < childListLen) {
                    Node childNode = childList.item(j);
                    childNodeName = childNode.getNodeName();
                    if (childNodeName.equalsIgnoreCase(fieldRequired) && childNode.getFirstChild() != null) {
                        fieldValue = childNode.getFirstChild().getNodeValue().trim();
                        BaseLogger.log("3", null, null, "fieldRequired [" + fieldRequired + "] fieldValue  [" + fieldValue + "]");
                    }
                    ++j;
                }
                ++i;
            }
        }
        fieldValue = fieldValue == null ? "" : fieldValue;
        return fieldValue;
    }

    public String encodeQueryParams(String url) throws ITMException {
        String linkAddr = "";
        try {
            String[] urlParts = url.split("\\?");
            linkAddr = String.valueOf(urlParts[0]) + "?";
            if (urlParts.length > 1) {
                String query = urlParts[1];
                int cnt = 0;
                String[] stringArray = query.split("&");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String param = stringArray[n2];
                    ++cnt;
                    String[] pair = param.split("=");
                    String key = pair[0];
                    String value = "";
                    if (pair.length > 1) {
                        value = URLEncoder.encode(pair[1], CommonConstants.ENCODING).replaceAll("\\+", "%20");
                    }
                    linkAddr = cnt == 1 ? String.valueOf(linkAddr) + key + "=" + value : String.valueOf(linkAddr) + "&" + key + "=" + value;
                    BaseLogger.log("3", null, null, "linkAddr ::" + linkAddr);
                    ++n2;
                }
            }
            return linkAddr;
        }
        catch (Exception ex) {
            throw new ITMException(ex);
        }
    }

    @Override
    public void setMailProp(String mailXMLStr, UserInfoBean userInfo) throws ITMException {
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            mailXMLStr = genericUtility.setXmlDec(mailXMLStr);
            BaseLogger.log("3", userInfo, null, "mailXMLStr @@@ \n" + mailXMLStr);
            Document mailInfoDom = this.parseString(mailXMLStr);
            this.objName = this.getValueOfField(mailInfoDom, "OBJ_NAME");
            this.refID = this.getValueOfField(mailInfoDom, "REF_ID");
            this.refSer = this.getValueOfField(mailInfoDom, "REF_SER");
            this.lineNo = this.getValueOfField(mailInfoDom, "LINE_NO");
            this.xslFileName = this.getValueOfField(mailInfoDom, "XSL_FILE_NAME");
            this.emailType = this.getValueOfField(mailInfoDom, "EMAIL_TYPE");
            this.domString = this.getValueOfField(mailInfoDom, "XML_DATA");
            this.formatCode = this.getValueOfField(mailInfoDom, "FORMAT_CODE");
            this.xmlDataFilePath = this.getValueOfField(mailInfoDom, "XML_DATA_FILE_PATH");
            this.toAddr = this.getValueOfField(mailInfoDom, "TO_ADD");
            this.ccAddr = this.getValueOfField(mailInfoDom, "CC_ADD");
            this.bccAddr = this.getValueOfField(mailInfoDom, "BCC_ADD");
            this.entityCode = this.getValueOfField(mailInfoDom, "ENTITY_CODE");
            this.entityType = this.getValueOfField(mailInfoDom, "ENTITY_TYPE");
            this.message = this.getValueOfField(mailInfoDom, "BODY_TEXT");
            this.subject = this.getValueOfField(mailInfoDom, "SUBJECT");
            this.linkAddr = this.getValueOfField(mailInfoDom, "LINK_ADDR");
            this.processInstanceId = this.getValueOfField(mailInfoDom, "PRC_ID");
            this.mailFrom = this.getValueOfField(mailInfoDom, "MAIL_FROM");
            this.messageType = this.getValueOfField(mailInfoDom, "MESSAGE_TYPE");
            this.transactionXML = this.getValueOfField(mailInfoDom, "TRANSACTION_XML");
            if (mailInfoDom.getElementsByTagName("INLINE_IMAGES") != null && mailInfoDom.getElementsByTagName("INLINE_IMAGES").item(0) != null && mailInfoDom.getElementsByTagName("INLINE_IMAGES").item(0).getFirstChild() != null) {
                NodeList imageNodeList = mailInfoDom.getElementsByTagName("INLINE_IMAGES").item(0).getChildNodes();
                this.inlineImages = new HashMap();
                int i = 0;
                while (i <= imageNodeList.getLength()) {
                    Node imageNode = imageNodeList.item(i);
                    BaseLogger.log("9", userInfo, null, "imageNode:" + imageNode);
                    if (imageNode != null && imageNode.getFirstChild() != null) {
                        this.inlineImages.put(imageNode.getNodeName(), imageNode.getFirstChild().getNodeValue());
                    }
                    ++i;
                }
                BaseLogger.log("3", userInfo, null, "this.inlineImages:" + this.inlineImages.toString());
            }
            this.setMailDetails(userInfo);
            if ("".equals(E12GenericUtility.checkNull(this.toAddr))) {
                BaseLogger.log("3", null, null, "In ITMMailInfo setMailProp 2 TO_ADD is null");
                throw new ITMException("CUSTOM_MESSAGE:In Mail sending TO_ADD is null", new Exception());
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :ITMMailInfo :setMailProp 2:==>\n" + e.getMessage());
            throw new ITMException(e);
        }
    }

    @Override
    public void setMailProp(String mailXMLStr, Connection connection) throws ITMException {
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            mailXMLStr = genericUtility.setXmlDec(mailXMLStr);
            BaseLogger.log("3", null, null, "mailXMLStr @@@ Connection \n" + mailXMLStr);
            Document mailInfoDom = this.parseString(mailXMLStr);
            this.objName = this.getValueOfField(mailInfoDom, "OBJ_NAME");
            this.refID = this.getValueOfField(mailInfoDom, "REF_ID");
            this.refSer = this.getValueOfField(mailInfoDom, "REF_SER");
            this.lineNo = this.getValueOfField(mailInfoDom, "LINE_NO");
            this.xslFileName = this.getValueOfField(mailInfoDom, "XSL_FILE_NAME");
            this.emailType = this.getValueOfField(mailInfoDom, "EMAIL_TYPE");
            this.domString = this.getValueOfField(mailInfoDom, "XML_DATA");
            this.formatCode = this.getValueOfField(mailInfoDom, "FORMAT_CODE");
            this.xmlDataFilePath = this.getValueOfField(mailInfoDom, "XML_DATA_FILE_PATH");
            this.toAddr = this.getValueOfField(mailInfoDom, "TO_ADD");
            this.ccAddr = this.getValueOfField(mailInfoDom, "CC_ADD");
            this.bccAddr = this.getValueOfField(mailInfoDom, "BCC_ADD");
            this.entityCode = E12GenericUtility.checkNull(this.getValueOfField(mailInfoDom, "ENTITY_CODE"));
            this.entityType = this.getValueOfField(mailInfoDom, "ENTITY_TYPE");
            this.message = this.getValueOfField(mailInfoDom, "BODY_TEXT");
            this.subject = this.getValueOfField(mailInfoDom, "SUBJECT");
            this.linkAddr = this.getValueOfField(mailInfoDom, "LINK_ADDR");
            this.processInstanceId = this.getValueOfField(mailInfoDom, "PRC_ID");
            this.mailFrom = this.getValueOfField(mailInfoDom, "MAIL_FROM");
            this.messageType = this.getValueOfField(mailInfoDom, "MESSAGE_TYPE");
            if (mailInfoDom.getElementsByTagName("INLINE_IMAGES") != null && mailInfoDom.getElementsByTagName("INLINE_IMAGES").item(0) != null && mailInfoDom.getElementsByTagName("INLINE_IMAGES").item(0).getFirstChild() != null) {
                NodeList imageNodeList = mailInfoDom.getElementsByTagName("INLINE_IMAGES").item(0).getChildNodes();
                this.inlineImages = new HashMap();
                int i = 0;
                while (i <= imageNodeList.getLength()) {
                    Node imageNode = imageNodeList.item(i);
                    BaseLogger.log("9", null, null, "imageNode:" + imageNode);
                    if (imageNode != null && imageNode.getFirstChild() != null) {
                        this.inlineImages.put(imageNode.getNodeName(), imageNode.getFirstChild().getNodeValue());
                    }
                    ++i;
                }
                BaseLogger.log("3", null, null, "this.inlineImages:" + this.inlineImages.toString());
            }
            this.setMailDetails(connection);
            if ("".equals(E12GenericUtility.checkNull(this.toAddr))) {
                BaseLogger.log("3", null, null, "In ITMMailInfo setMailProp 3 TO_ADD is null");
                throw new ITMException("CUSTOM_MESSAGE:In Mail sending TO_ADD is null", new Exception());
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ITMMailInfo :setMailProp 3:==>\n" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private void setMailDetails(UserInfoBean userInfo) throws ITMException {
        ArrayList mailDetailList = null;
        boolean emailFlag = false;
        String argType = "";
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            DBAccessEJB dbAccess = new DBAccessEJB();
            if (this.formatCode != null && this.formatCode.length() > 0) {
                mailDetailList = dbAccess.getMailDetailList(this.formatCode, userInfo);
            }
            BaseLogger.log("3", userInfo, null, "[ITMMailInfo] mail detail found for format code :" + this.formatCode + ":");
            BaseLogger.log("3", userInfo, null, "[ITMMailInfo] mailDetailList  :" + mailDetailList + ":");
            String emailId = "";
            if (mailDetailList != null && mailDetailList.size() > 0) {
                String endIndex;
                String startIndex;
                String currToken;
                int i;
                ArrayList tokens;
                String to = "";
                String cc = "";
                String bcc = "";
                if ((String)mailDetailList.get(0) != null) {
                    to = (String)mailDetailList.get(0);
                }
                if ((String)mailDetailList.get(1) != null) {
                    cc = (String)mailDetailList.get(1);
                }
                if ((String)mailDetailList.get(2) != null) {
                    bcc = (String)mailDetailList.get(2);
                }
                if (cc == null) {
                    cc = "";
                }
                if (bcc == null) {
                    bcc = "";
                }
                if (to.length() > 0) {
                    StringBuffer toAddrBuff = new StringBuffer();
                    tokens = genericUtility.getTokenList(to, ",");
                    BaseLogger.log("3", userInfo, null, "tokens " + tokens);
                    i = 0;
                    while (i < tokens.size()) {
                        currToken = (String)tokens.get(i);
                        if (currToken.indexOf("{") != -1) {
                            BaseLogger.log("3", userInfo, null, "To with '{' :[" + currToken + "]");
                            startIndex = "";
                            endIndex = "";
                            if (currToken.charAt(1) == '(') {
                                startIndex = "(";
                                endIndex = ")";
                            } else if (currToken.charAt(1) == '[') {
                                startIndex = "[";
                                endIndex = "]";
                            }
                            argType = currToken.substring(currToken.indexOf(startIndex) + 1, currToken.indexOf(endIndex));
                            this.entityType = argType.length() == 1 ? argType : argType.substring(0, 1);
                            BaseLogger.log("3", userInfo, null, "argType :::: [" + argType + "] ");
                            if (argType != null && argType.trim().length() > 0) {
                                emailId = this.getEmailAddr(argType, currToken.substring(currToken.indexOf(endIndex) + 1, currToken.length() - 1), userInfo);
                                if ((emailId = E12GenericUtility.checkNull(emailId)).length() > 0) {
                                    toAddrBuff.append(emailId).append(",");
                                }
                            }
                        } else if (currToken.indexOf("<") != -1) {
                            BaseLogger.log("3", userInfo, null, "To with '<' :[" + currToken + "]");
                            emailId = this.customizeDataStr(currToken, this.domString);
                            emailId = E12GenericUtility.checkNull(emailId);
                            if (emailId.length() > 0) {
                                toAddrBuff.append(emailId).append(",");
                            }
                        } else if (currToken.indexOf("[") != -1) {
                            BaseLogger.log("3", userInfo, null, "To with '[' :[" + currToken + "]");
                            if (currToken.charAt(1) == '(') {
                                this.entityType = currToken.substring(2, 3);
                                currToken = currToken.substring(4, currToken.length() - 1);
                            } else {
                                currToken = currToken.substring(1, currToken.length() - 1);
                            }
                            if (currToken.equals("ROLE_CODE")) {
                                emailId = this.getRoleCodeEmailAddr(this.entityType, userInfo);
                                if ((emailId = E12GenericUtility.checkNull(emailId)).length() > 0) {
                                    toAddrBuff.append(emailId).append(",");
                                }
                            }
                        } else {
                            emailId = E12GenericUtility.checkNull(currToken);
                            if (emailId.length() > 0) {
                                if (!emailId.contains("@")) {
                                    emailId = E12GenericUtility.checkNull(this.getWFRoleEmailId(emailId, userInfo));
                                }
                                toAddrBuff.append(emailId).append(",");
                            }
                        }
                        ++i;
                    }
                    this.toAddr = this.toAddr != null && !this.toAddr.equalsIgnoreCase("null") && this.toAddr.trim().length() > 0 ? String.valueOf(this.toAddr) + "," + toAddrBuff.toString() : toAddrBuff.toString();
                    BaseLogger.log("3", userInfo, null, "this.toAddr " + this.toAddr.toString());
                    if (this.toAddr.endsWith(",")) {
                        this.toAddr = this.toAddr.substring(0, this.toAddr.length() - 1);
                    }
                }
                if (cc.length() > 0) {
                    StringBuffer ccAddrBuff = new StringBuffer();
                    tokens = genericUtility.getTokenList(cc, ",");
                    BaseLogger.log("3", userInfo, null, "tokens " + tokens);
                    i = 0;
                    while (i < tokens.size()) {
                        currToken = (String)tokens.get(i);
                        if (currToken.indexOf("{") != -1) {
                            BaseLogger.log("3", userInfo, null, "CC with '{' :[" + currToken + "]");
                            startIndex = "";
                            endIndex = "";
                            if (currToken.charAt(1) == '(') {
                                startIndex = "(";
                                endIndex = ")";
                            } else if (currToken.charAt(1) == '[') {
                                startIndex = "[";
                                endIndex = "]";
                            }
                            argType = currToken.substring(currToken.indexOf(startIndex) + 1, currToken.indexOf(endIndex));
                            BaseLogger.log("3", userInfo, null, "argType :::: [" + argType + "] ");
                            this.entityType = argType.length() == 1 ? argType : argType.substring(0, 1);
                            if (argType != null && argType.trim().length() > 0) {
                                emailId = this.getEmailAddr(argType, currToken.substring(currToken.indexOf(endIndex) + 1, currToken.length() - 1), userInfo);
                                if ((emailId = E12GenericUtility.checkNull(emailId)).length() > 0) {
                                    ccAddrBuff.append(emailId).append(",");
                                }
                            }
                        } else if (currToken.indexOf("<") != -1) {
                            BaseLogger.log("3", userInfo, null, "To with '<' :[" + currToken + "]");
                            emailId = this.customizeDataStr(currToken, this.domString);
                            emailId = E12GenericUtility.checkNull(emailId);
                            if (emailId.length() > 0) {
                                ccAddrBuff.append(emailId).append(",");
                            }
                        } else if (currToken.indexOf("[") != -1) {
                            BaseLogger.log("3", userInfo, null, "To with '[' :[" + currToken + "]");
                            if (currToken.charAt(1) == '(') {
                                this.entityType = currToken.substring(2, 3);
                                currToken = currToken.substring(4, currToken.length() - 1);
                            } else {
                                currToken = currToken.substring(1, currToken.length() - 1);
                            }
                            if (currToken.equals("ROLE_CODE")) {
                                emailId = this.getRoleCodeEmailAddr(this.entityType, userInfo);
                                if ((emailId = E12GenericUtility.checkNull(emailId)).length() > 0) {
                                    ccAddrBuff.append(emailId).append(",");
                                }
                            }
                        } else {
                            emailId = E12GenericUtility.checkNull(currToken);
                            if (emailId.length() > 0) {
                                if (!emailId.contains("@")) {
                                    emailId = E12GenericUtility.checkNull(this.getWFRoleEmailId(emailId, userInfo));
                                }
                                ccAddrBuff.append(emailId).append(",");
                            }
                        }
                        this.ccAddr = this.ccAddr != null && this.ccAddr.equalsIgnoreCase("null") && this.ccAddr.trim().length() > 0 ? String.valueOf(this.ccAddr) + "," + ccAddrBuff.toString() : ccAddrBuff.toString();
                        BaseLogger.log("3", userInfo, null, "this.ccAddr" + this.ccAddr);
                        if (this.ccAddr.endsWith(",")) {
                            this.ccAddr = this.ccAddr.substring(0, this.ccAddr.length() - 1);
                        }
                        ++i;
                    }
                    BaseLogger.log("3", userInfo, null, "ccAddrBuff " + ccAddrBuff.toString());
                    this.ccAddr = ccAddrBuff.toString();
                    if (this.ccAddr.endsWith(",")) {
                        this.ccAddr = this.ccAddr.substring(0, this.ccAddr.length() - 1);
                    }
                }
                if (bcc.length() > 0) {
                    StringBuffer bccAddrBuff = new StringBuffer();
                    tokens = genericUtility.getTokenList(bcc, ",");
                    BaseLogger.log("3", userInfo, null, "tokens " + tokens);
                    i = 0;
                    while (i < tokens.size()) {
                        currToken = (String)tokens.get(i);
                        if (currToken.indexOf("{") != -1) {
                            BaseLogger.log("3", userInfo, null, "BCC with '{' :[" + currToken + "]");
                            startIndex = "";
                            endIndex = "";
                            if (currToken.charAt(1) == '(') {
                                startIndex = "(";
                                endIndex = ")";
                            } else if (currToken.charAt(1) == '[') {
                                startIndex = "[";
                                endIndex = "]";
                            }
                            argType = currToken.substring(currToken.indexOf(startIndex) + 1, currToken.indexOf(endIndex));
                            BaseLogger.log("3", userInfo, null, "argType :::: [" + argType + "] ");
                            this.entityType = argType.length() == 1 ? argType : argType.substring(0, 1);
                            if (argType != null && argType.trim().length() > 0) {
                                emailId = this.getEmailAddr(argType, currToken.substring(currToken.indexOf(endIndex) + 1, currToken.length() - 1), userInfo);
                                if ((emailId = E12GenericUtility.checkNull(emailId)).length() > 0) {
                                    bccAddrBuff.append(emailId).append(",");
                                }
                            }
                        } else if (currToken.indexOf("<") != -1) {
                            BaseLogger.log("3", userInfo, null, "To with '<' :[" + currToken + "]");
                            emailId = this.customizeDataStr(currToken, this.domString);
                            emailId = E12GenericUtility.checkNull(emailId);
                            if (emailId.length() > 0) {
                                bccAddrBuff.append(emailId).append(",");
                            }
                        } else if (currToken.indexOf("[") != -1) {
                            BaseLogger.log("3", userInfo, null, "To with '[' :[" + currToken + "]");
                            if (currToken.charAt(1) == '(') {
                                this.entityType = currToken.substring(2, 3);
                                currToken = currToken.substring(4, currToken.length() - 1);
                            } else {
                                currToken = currToken.substring(1, currToken.length() - 1);
                            }
                            if (currToken.equals("ROLE_CODE")) {
                                emailId = this.getRoleCodeEmailAddr(this.entityType, userInfo);
                                if ((emailId = E12GenericUtility.checkNull(emailId)).length() > 0) {
                                    bccAddrBuff.append(emailId).append(",");
                                }
                            }
                        } else {
                            emailId = E12GenericUtility.checkNull(currToken);
                            if (emailId.length() > 0) {
                                if (!emailId.contains("@")) {
                                    emailId = E12GenericUtility.checkNull(this.getWFRoleEmailId(emailId, userInfo));
                                }
                                bccAddrBuff.append(emailId).append(",");
                            }
                        }
                        ++i;
                    }
                    BaseLogger.log("3", userInfo, null, "bccAddrBuff" + this.bccAddr);
                    this.bccAddr = this.bccAddr != null && this.bccAddr.equalsIgnoreCase("null") && this.bccAddr.trim().length() > 0 ? String.valueOf(this.bccAddr) + "," + bccAddrBuff.toString() : bccAddrBuff.toString();
                    if (this.bccAddr.endsWith(",")) {
                        this.bccAddr = this.bccAddr.substring(0, this.bccAddr.length() - 1);
                    }
                }
                if ((String)mailDetailList.get(3) != null && (this.subject == null || this.subject != null && "null".equalsIgnoreCase(this.subject))) {
                    this.subject = (String)mailDetailList.get(3);
                    if (this.subject.indexOf("<") != -1) {
                        this.subject = this.customizeDataStr(this.subject, this.domString);
                    }
                }
                if ((String)mailDetailList.get(4) != null && (this.message == null || this.message != null && "null".equalsIgnoreCase(this.message))) {
                    this.message = (String)mailDetailList.get(4);
                    if (this.message.indexOf("<") != -1) {
                        this.message = this.customizeDataStr(this.message, this.domString);
                    }
                }
                if ((String)mailDetailList.get(5) != null) {
                    this.attachType = (String)mailDetailList.get(5);
                }
            }
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :ITMMailInfo :email :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private String getEmailAddr(String argType, String argName, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("2", userInfo, null, "[ITMMailInfo]argType 3 [" + argType + "], argName [" + argName + "]");
        String retEmailAddr = "";
        try {
            String masterTable = null;
            String whereFieldName = null;
            String selFieldName = null;
            String responsibleFor = "";
            String entityType = "";
            String whereCondition = "";
            if (argType != null && argType.trim().length() > 0) {
                entityType = argType.substring(0, 1);
            }
            if (argType != null && argType.trim().length() > 1) {
                responsibleFor = argType.substring(1, 2);
            }
            if (entityType.equalsIgnoreCase("C")) {
                masterTable = "CUSTOMER";
                argName = argName == null || "".equals(argName) ? "CUST_CODE" : argName;
                whereFieldName = "CUST_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (entityType.equalsIgnoreCase("S")) {
                masterTable = "SUPPLIER";
                argName = argName == null || "".equals(argName) ? "SUPP_CODE" : argName;
                whereFieldName = "SUPP_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (entityType.equalsIgnoreCase("E")) {
                masterTable = "EMPLOYEE";
                argName = argName == null || "".equals(argName) ? "EMP_CODE" : argName;
                whereFieldName = "EMP_CODE";
                selFieldName = "EMAIL_ID_OFF";
            } else if (entityType.equalsIgnoreCase("P")) {
                masterTable = "SALES_PERS";
                argName = argName == null || "".equals(argName) ? "SALES_PERS" : argName;
                whereFieldName = "SALES_PERS";
                selFieldName = "EMAIL_ADDR";
            } else if (entityType.equalsIgnoreCase("G")) {
                masterTable = "STRG_CUSTOMER";
                argName = argName == null || "".equals(argName) ? "SC_CODE" : argName;
                whereFieldName = "SC_CODE";
                selFieldName = "EMAIL_ADDR";
            }
            Document dom = this.parseString(this.domString);
            String whereFieldValue = this.getValueOfField(dom, argName.toLowerCase());
            if (whereFieldValue == null || whereFieldValue != null && whereFieldValue.trim().length() == 0) {
                BaseLogger.log("3", userInfo, null, "Setting entityCode as value ...");
                whereFieldValue = this.entityCode;
            }
            DBAccessEJB dbAccess = new DBAccessEJB();
            BaseLogger.log("3", userInfo, null, "inside ITMMailinfo whereFieldValue==" + whereFieldValue + "==this.entityCode==" + this.entityCode);
            retEmailAddr = responsibleFor != null && responsibleFor.trim().length() > 0 ? dbAccess.getEntityEmailAddr(entityType, whereFieldValue, responsibleFor) : dbAccess.getEmailAddr(selFieldName, masterTable, whereFieldName, whereFieldValue, userInfo);
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :ITMMailInfo :getEmailAddr :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return retEmailAddr;
    }

    private String getRoleCodeEmailAddr(String argType, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("2", userInfo, null, "[ITMMailInfo] argType getRoleCodeEmailAddr 2 [" + argType + "]");
        String retEmailAddr = "";
        try {
            String masterTable = null;
            String whereFieldName = null;
            String selFieldName = null;
            if (argType.equalsIgnoreCase("C")) {
                masterTable = "CUSTOMER";
                whereFieldName = "CUST_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (argType.equalsIgnoreCase("S")) {
                masterTable = "SUPPLIER";
                whereFieldName = "SUPP_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (argType.equalsIgnoreCase("E")) {
                masterTable = "EMPLOYEE";
                whereFieldName = "EMP_CODE";
                selFieldName = "EMAIL_ID_OFF";
            } else if (argType.equalsIgnoreCase("P")) {
                masterTable = "SALES_PERS";
                whereFieldName = "SALES_PERS";
                selFieldName = "EMAIL_ADDR";
            }
            DBAccessEJB dbAccess = new DBAccessEJB();
            retEmailAddr = dbAccess.getEmailAddr(selFieldName, masterTable, whereFieldName, this.entityCode, userInfo);
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :ITMMailInfo :getEmailAddr :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return retEmailAddr;
    }

    private void setMailDetails(Connection connection) throws ITMException {
        ArrayList mailDetailList = null;
        boolean emailFlag = false;
        String argType = "";
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            DBAccessEJB dbAccess = new DBAccessEJB();
            if (this.formatCode != null && this.formatCode.length() > 0) {
                mailDetailList = dbAccess.getMailDetailList(this.formatCode, connection);
            }
            BaseLogger.log("3", null, null, "[ITMMailInfo] mail detail found for format code :" + this.formatCode + ":");
            BaseLogger.log("3", null, null, "[ITMMailInfo] mailDetailList  :" + mailDetailList + ":");
            if (mailDetailList != null && mailDetailList.size() > 0) {
                String endIndex;
                String startIndex;
                String currToken;
                int i;
                ArrayList tokens;
                String to = "";
                String cc = "";
                String bcc = "";
                if ((String)mailDetailList.get(0) != null) {
                    to = (String)mailDetailList.get(0);
                }
                if ((String)mailDetailList.get(1) != null) {
                    cc = (String)mailDetailList.get(1);
                }
                if ((String)mailDetailList.get(2) != null) {
                    bcc = (String)mailDetailList.get(2);
                }
                if (cc == null) {
                    cc = "";
                }
                if (bcc == null) {
                    bcc = "";
                }
                if (to.length() > 0) {
                    StringBuffer toAddrBuff = new StringBuffer();
                    tokens = genericUtility.getTokenList(to, ",");
                    BaseLogger.log("3", null, null, "tokens " + tokens);
                    i = 0;
                    while (i < tokens.size()) {
                        currToken = (String)tokens.get(i);
                        if (currToken.indexOf("{") != -1) {
                            BaseLogger.log("3", null, null, "To with '{' :[" + currToken + "]");
                            startIndex = "";
                            endIndex = "";
                            if (currToken.charAt(1) == '(') {
                                startIndex = "(";
                                endIndex = ")";
                            } else if (currToken.charAt(1) == '[') {
                                startIndex = "[";
                                endIndex = "]";
                            }
                            argType = currToken.substring(currToken.indexOf(startIndex) + 1, currToken.indexOf(endIndex));
                            this.entityType = argType.length() == 1 ? argType : argType.substring(0, 1);
                            BaseLogger.log("3", null, null, "argType :::: [" + argType + "] ");
                            if (argType != null && argType.trim().length() > 0) {
                                toAddrBuff.append(this.getEmailAddr(argType, currToken.substring(currToken.indexOf(endIndex) + 1, currToken.length() - 1), connection)).append(",");
                            }
                        } else if (currToken.indexOf("<") != -1) {
                            BaseLogger.log("3", null, null, "To with '<' :[" + currToken + "]");
                            toAddrBuff.append(this.customizeDataStr(currToken, this.domString)).append(",");
                        } else if (currToken.indexOf("[") != -1) {
                            BaseLogger.log("3", null, null, "To with '[' :[" + currToken + "]");
                            if (currToken.charAt(1) == '(') {
                                this.entityType = currToken.substring(2, 3);
                                currToken = currToken.substring(4, currToken.length() - 1);
                            } else {
                                currToken = currToken.substring(1, currToken.length() - 1);
                            }
                            if (currToken.equals("ROLE_CODE")) {
                                toAddrBuff.append(this.getRoleCodeEmailAddr(this.entityType, connection)).append(",");
                            }
                        } else {
                            toAddrBuff.append(currToken).append(",");
                        }
                        ++i;
                    }
                    this.toAddr = this.toAddr != null && !this.toAddr.equalsIgnoreCase("null") && this.toAddr.trim().length() > 0 ? String.valueOf(this.toAddr) + "," + toAddrBuff.toString() : toAddrBuff.toString();
                    BaseLogger.log("3", null, null, "this.toAddr " + this.toAddr.toString());
                    if (this.toAddr.endsWith(",")) {
                        this.toAddr = this.toAddr.substring(0, this.toAddr.length() - 1);
                    }
                }
                if (cc.length() > 0) {
                    StringBuffer ccAddrBuff = new StringBuffer();
                    tokens = genericUtility.getTokenList(cc, ",");
                    BaseLogger.log("3", null, null, "tokens " + tokens);
                    i = 0;
                    while (i < tokens.size()) {
                        currToken = (String)tokens.get(i);
                        if (currToken.indexOf("{") != -1) {
                            BaseLogger.log("3", null, null, "CC with '{' :[" + currToken + "]");
                            startIndex = "";
                            endIndex = "";
                            if (currToken.charAt(1) == '(') {
                                startIndex = "(";
                                endIndex = ")";
                            } else if (currToken.charAt(1) == '[') {
                                startIndex = "[";
                                endIndex = "]";
                            }
                            argType = currToken.substring(currToken.indexOf(startIndex) + 1, currToken.indexOf(endIndex));
                            BaseLogger.log("3", null, null, "argType :::: [" + argType + "] ");
                            this.entityType = argType.length() == 1 ? argType : argType.substring(0, 1);
                            if (argType != null && argType.trim().length() > 0) {
                                ccAddrBuff.append(this.getEmailAddr(argType, currToken.substring(currToken.indexOf(endIndex) + 1, currToken.length() - 1), connection)).append(",");
                            }
                        } else if (currToken.indexOf("<") != -1) {
                            BaseLogger.log("3", null, null, "To with '<' :[" + currToken + "]");
                            ccAddrBuff.append(this.customizeDataStr(currToken, this.domString)).append(",");
                        } else if (currToken.indexOf("[") != -1) {
                            BaseLogger.log("3", null, null, "To with '[' :[" + currToken + "]");
                            if (currToken.charAt(1) == '(') {
                                this.entityType = currToken.substring(2, 3);
                                currToken = currToken.substring(4, currToken.length() - 1);
                            } else {
                                currToken = currToken.substring(1, currToken.length() - 1);
                            }
                            if (currToken.equals("ROLE_CODE")) {
                                ccAddrBuff.append(this.getRoleCodeEmailAddr(this.entityType, connection)).append(",");
                            }
                        } else {
                            ccAddrBuff.append(currToken).append(",");
                        }
                        this.ccAddr = this.ccAddr != null && this.ccAddr.equalsIgnoreCase("null") && this.ccAddr.trim().length() > 0 ? String.valueOf(this.ccAddr) + "," + ccAddrBuff.toString() : ccAddrBuff.toString();
                        BaseLogger.log("3", null, null, "this.ccAddr" + this.ccAddr);
                        if (this.ccAddr.endsWith(",")) {
                            this.ccAddr = this.ccAddr.substring(0, this.ccAddr.length() - 1);
                        }
                        ++i;
                    }
                    BaseLogger.log("3", null, null, "ccAddrBuff " + ccAddrBuff.toString());
                    this.ccAddr = ccAddrBuff.toString();
                    if (this.ccAddr.endsWith(",")) {
                        this.ccAddr = this.ccAddr.substring(0, this.ccAddr.length() - 1);
                    }
                }
                if (bcc.length() > 0) {
                    StringBuffer bccAddrBuff = new StringBuffer();
                    tokens = genericUtility.getTokenList(bcc, ",");
                    BaseLogger.log("3", null, null, "tokens " + tokens);
                    i = 0;
                    while (i < tokens.size()) {
                        currToken = (String)tokens.get(i);
                        if (currToken.indexOf("{") != -1) {
                            BaseLogger.log("3", null, null, "BCC with '{' :[" + currToken + "]");
                            startIndex = "";
                            endIndex = "";
                            if (currToken.charAt(1) == '(') {
                                startIndex = "(";
                                endIndex = ")";
                            } else if (currToken.charAt(1) == '[') {
                                startIndex = "[";
                                endIndex = "]";
                            }
                            argType = currToken.substring(currToken.indexOf(startIndex) + 1, currToken.indexOf(endIndex));
                            BaseLogger.log("3", null, null, "argType :::: [" + argType + "] ");
                            this.entityType = argType.length() == 1 ? argType : argType.substring(0, 1);
                            if (argType != null && argType.trim().length() > 0) {
                                bccAddrBuff.append(this.getEmailAddr(argType, currToken.substring(currToken.indexOf(endIndex) + 1, currToken.length() - 1), connection)).append(",");
                            }
                        } else if (currToken.indexOf("<") != -1) {
                            BaseLogger.log("3", null, null, "To with '<' :[" + currToken + "]");
                            bccAddrBuff.append(this.customizeDataStr(currToken, this.domString)).append(",");
                        } else if (currToken.indexOf("[") != -1) {
                            BaseLogger.log("3", null, null, "To with '[' :[" + currToken + "]");
                            if (currToken.charAt(1) == '(') {
                                this.entityType = currToken.substring(2, 3);
                                currToken = currToken.substring(4, currToken.length() - 1);
                            } else {
                                currToken = currToken.substring(1, currToken.length() - 1);
                            }
                            if (currToken.equals("ROLE_CODE")) {
                                bccAddrBuff.append(this.getRoleCodeEmailAddr(this.entityType, connection)).append(",");
                            }
                        } else {
                            bccAddrBuff.append(currToken).append(",");
                        }
                        ++i;
                    }
                    BaseLogger.log("3", null, null, "bccAddrBuff" + this.bccAddr);
                    this.bccAddr = this.bccAddr != null && this.bccAddr.equalsIgnoreCase("null") && this.bccAddr.trim().length() > 0 ? String.valueOf(this.bccAddr) + "," + bccAddrBuff.toString() : bccAddrBuff.toString();
                    if (this.bccAddr.endsWith(",")) {
                        this.bccAddr = this.bccAddr.substring(0, this.bccAddr.length() - 1);
                    }
                }
                if ((String)mailDetailList.get(3) != null && (this.subject == null || this.subject != null && "null".equalsIgnoreCase(this.subject))) {
                    this.subject = (String)mailDetailList.get(3);
                    if (this.subject.indexOf("<") != -1) {
                        this.subject = this.customizeDataStr(this.subject, this.domString);
                    }
                }
                if ((String)mailDetailList.get(4) != null && (this.message == null || this.message != null && "null".equalsIgnoreCase(this.message))) {
                    this.message = (String)mailDetailList.get(4);
                    if (this.message.indexOf("<") != -1) {
                        this.message = this.customizeDataStr(this.message, this.domString);
                    }
                }
                if ((String)mailDetailList.get(5) != null) {
                    this.attachType = (String)mailDetailList.get(5);
                }
            }
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ITMMailInfo :email :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private String getEmailAddr(String argType, String argName, Connection connection) throws ITMException {
        BaseLogger.log("2", null, null, "[ITMMailInfo] argType 4 [" + argType + "], argName [" + argName + "]");
        String retEmailAddr = "";
        try {
            String masterTable = null;
            String whereFieldName = null;
            String selFieldName = null;
            String responsibleFor = "";
            String entityType = "";
            String whereCondition = "";
            if (argType != null && argType.trim().length() > 0) {
                entityType = argType.substring(0, 1);
            }
            if (argType != null && argType.trim().length() > 1) {
                responsibleFor = argType.substring(1, 2);
            }
            if (entityType.equalsIgnoreCase("C")) {
                masterTable = "CUSTOMER";
                argName = argName == null || "".equals(argName) ? "CUST_CODE" : argName;
                whereFieldName = "CUST_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (entityType.equalsIgnoreCase("S")) {
                masterTable = "SUPPLIER";
                argName = argName == null || "".equals(argName) ? "SUPP_CODE" : argName;
                whereFieldName = "SUPP_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (entityType.equalsIgnoreCase("E")) {
                masterTable = "EMPLOYEE";
                argName = argName == null || "".equals(argName) ? "EMP_CODE" : argName;
                whereFieldName = "EMP_CODE";
                selFieldName = "EMAIL_ID_OFF";
            } else if (entityType.equalsIgnoreCase("P")) {
                masterTable = "SALES_PERS";
                argName = argName == null || "".equals(argName) ? "SALES_PERS" : argName;
                whereFieldName = "SALES_PERS";
                selFieldName = "EMAIL_ADDR";
            } else if (entityType.equalsIgnoreCase("G")) {
                masterTable = "STRG_CUSTOMER";
                argName = argName == null || "".equals(argName) ? "SC_CODE" : argName;
                whereFieldName = "SC_CODE";
                selFieldName = "EMAIL_ADDR";
            }
            Document dom = this.parseString(this.domString);
            String whereFieldValue = this.getValueOfField(dom, argName.toLowerCase());
            if (whereFieldValue == null || whereFieldValue != null && whereFieldValue.trim().length() == 0) {
                BaseLogger.log("3", null, null, "Setting entityCode as value ...");
                whereFieldValue = this.entityCode;
            }
            DBAccessEJB dbAccess = new DBAccessEJB();
            BaseLogger.log("3", null, null, "inside ITMMailinfo whereFieldValue==" + whereFieldValue + "==this.entityCode==" + this.entityCode);
            retEmailAddr = responsibleFor != null && responsibleFor.trim().length() > 0 ? dbAccess.getEntityEmailAddr(entityType, whereFieldValue, responsibleFor) : dbAccess.getEmailAddr(selFieldName, masterTable, whereFieldName, whereFieldValue, connection);
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ITMMailInfo :getEmailAddr :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return retEmailAddr;
    }

    private String getRoleCodeEmailAddr(String argType, Connection connection) throws ITMException {
        return this.getRoleCodeEmailAddr(argType, this.entityCode, connection);
    }

    private String getRoleCodeEmailAddr(String argType, String entityCode, Connection connection) throws ITMException {
        BaseLogger.log("2", null, null, "[ITMMailInfo] argType getRoleCodeEmailAddr 3 [" + argType + "]");
        String retEmailAddr = "";
        try {
            String masterTable = null;
            String whereFieldName = null;
            String selFieldName = null;
            if (argType.equalsIgnoreCase("C")) {
                masterTable = "CUSTOMER";
                whereFieldName = "CUST_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (argType.equalsIgnoreCase("S")) {
                masterTable = "SUPPLIER";
                whereFieldName = "SUPP_CODE";
                selFieldName = "EMAIL_ADDR";
            } else if (argType.equalsIgnoreCase("E")) {
                masterTable = "EMPLOYEE";
                whereFieldName = "EMP_CODE";
                selFieldName = "EMAIL_ID_OFF";
            } else if (argType.equalsIgnoreCase("P")) {
                masterTable = "SALES_PERS";
                whereFieldName = "SALES_PERS";
                selFieldName = "EMAIL_ADDR";
            } else if (this.entityType.equalsIgnoreCase("G")) {
                masterTable = "STRG_CUSTOMER";
                whereFieldName = "SC_CODE";
                selFieldName = "EMAIL_ADDR";
            }
            DBAccessEJB dbAccess = new DBAccessEJB();
            if (entityCode != null) {
                String[] entityCodes = entityCode.split(",");
                if (entityCodes.length > 1) {
                    int i = 0;
                    while (i < entityCodes.length) {
                        String arrEntityCode = entityCodes[i];
                        String emailAddress = dbAccess.getEmailAddr(selFieldName, masterTable, whereFieldName, arrEntityCode, connection);
                        retEmailAddr = String.valueOf(retEmailAddr) + emailAddress + (i == entityCodes.length - 1 ? "" : ",");
                        ++i;
                    }
                } else {
                    retEmailAddr = dbAccess.getEmailAddr(selFieldName, masterTable, whereFieldName, entityCode, connection);
                }
            }
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ITMMailInfo :getEmailAddr :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return retEmailAddr;
    }

    public String getEntityCode() {
        return this.entityCode;
    }

    private String getWFRoleEmailId(String roleCode, UserInfoBean userInfo) {
        String emailId = "";
        Document transactionDom = null;
        Connection conn = null;
        try {
            try {
                if (roleCode.length() > 0) {
                    String roleSqlInput;
                    String entityCode = "";
                    ConnDriver connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(userInfo.getTransDB());
                    connDriver = null;
                    if (E12GenericUtility.checkNull(this.transactionXML).length() > 0) {
                        transactionDom = this.parseString(this.transactionXML);
                    }
                    DBAccessEJB dbAccess = new DBAccessEJB();
                    ArrayList roleInfoList = dbAccess.getRoleInfoList(conn, roleCode);
                    BaseLogger.log("3", userInfo, null, "roleInfoList : [" + roleInfoList + "]");
                    StringBuffer roleExprBuff = new StringBuffer();
                    StringBuffer roleExprTypeBuff = new StringBuffer();
                    if (roleInfoList.size() >= 4 && (roleSqlInput = E12GenericUtility.checkNull((String)roleInfoList.get(4))).length() > 0) {
                        String[] roleExprArr = roleSqlInput.split(",");
                        BaseLogger.log("2", userInfo, null, "roleExprArr : [" + Arrays.asList(roleExprArr) + "]");
                        int roleExpor = 0;
                        while (roleExpor < roleExprArr.length) {
                            String roleExprStr = roleExprArr[roleExpor];
                            String roleExpr = roleExprStr.substring(0, roleExprStr.lastIndexOf(":") + 1);
                            roleExprBuff.append(roleExpr);
                            String roleExprType = roleExprStr.substring(roleExprStr.lastIndexOf(":") + 1);
                            roleExprTypeBuff.append(roleExprType).append(":");
                            ++roleExpor;
                        }
                        BaseLogger.log("3", userInfo, null, "roleExprBuff : [" + roleExprBuff + "], roleExprTypeBuff : [" + roleExprTypeBuff + "]");
                    }
                    entityCode = dbAccess.getRoleEntityCode(roleExprBuff.toString(), roleExprTypeBuff.toString(), roleInfoList, transactionDom, userInfo);
                    dbAccess = null;
                    BaseLogger.log("3", userInfo, null, "entityCode : [" + entityCode + "]");
                    if (E12GenericUtility.checkNull(entityCode).length() > 0) {
                        emailId = this.getRoleCodeEmailAddr((String)roleInfoList.get(1), entityCode, conn);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return emailId;
    }
}

