/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility.wiz;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wiz.Column;
import ibase.webitm.utility.wiz.Form;
import ibase.webitm.utility.wiz.ITMRule;
import ibase.webitm.utility.wiz.ITMValidatorComponent;
import ibase.webitm.utility.wiz.Messages;
import ibase.webitm.utility.wiz.TransactionCoreModel;
import ibase.webitm.utility.wiz.TransactionHeaderModel;
import ibase.webitm.utility.wiz.TransactionKey;
import ibase.webitm.utility.wiz.TransactionSaxTransformer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransactionCoreModelImplSax
extends TransactionCoreModel
implements Serializable {
    TransactionHeaderModel transHdrModel = null;
    TransactionKey transKeyObj = null;
    HashMap allTaxFieldEditMap = null;

    public TransactionCoreModelImplSax() throws ITMException {
        try {
            BaseLogger.log("1", null, null, "TransactionCoreModelImplSax constructed");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionCoreModelImplSax :constructor :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public void loadHeaderMetaData(String transName, String transXmlStr) throws ITMException {
        try {
            this.createHeaderModel(transName, transXmlStr, null);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionCoreModelImplSax :loadHeaderMetaData :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    @Override
    public void loadMetaData(String transName, String transXmlStr, String objType) throws ITMException {
        try {
            HashMap formColMap = this.createFormObjColMap(transName, transXmlStr);
            if (formColMap != null) {
                for (Form frmObj : formColMap.keySet()) {
                    HashMap colNameObjMap = (HashMap)formColMap.get(frmObj);
                    this.createMetaDataForForm(frmObj.getTransName(), frmObj.getFormNo(), colNameObjMap, objType);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionCoreModelImplSax :loadMetaData :==>" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    @Override
    public String loadXMLData(String xmlDataFileName) throws ITMException {
        String msgStr = null;
        try {
            File dataFile = new File(xmlDataFileName);
            if (dataFile.exists() && dataFile.isFile()) {
                BaseLogger.log("0", null, null, "Data File Exists...");
                long fileSizeLimit = 316500L;
                msgStr = this.createDataUsingDomParsing(dataFile);
            } else {
                msgStr = Messages.getString("TransactionCoreModelImplSax_noDataFound");
            }
        }
        catch (IndexOutOfBoundsException idxEx) {
            BaseLogger.log("0", null, null, "IndexOutOfBoundsException : TransactionCoreModelImplSax :loadXMLData :==>" + idxEx.getMessage());
            throw new IndexOutOfBoundsException("Number of Columns in Brow and Detail screen mismatched!!!");
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Exception :TransactionCoreModelImplSax :loadXMLData :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return msgStr;
    }

    public String loadXMLData(String mode, String xmlData) throws ITMException {
        String msgStr = null;
        try {
            BaseLogger.log("0", null, null, "Data File Exists...");
            long fileSizeLimit = 316500L;
            msgStr = this.createDataUsingDomParsing(xmlData);
        }
        catch (IndexOutOfBoundsException idxEx) {
            BaseLogger.log("0", null, null, "IndexOutOfBoundsException : TransactionCoreModelImplSax :loadXMLData :==>" + idxEx.getMessage());
            throw new IndexOutOfBoundsException("Number of Columns in Brow and Detail screen mismatched!!!");
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Exception :TransactionCoreModelImplSax :loadXMLData :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return msgStr;
    }

    public String refreshXMLData(String fileName) throws ITMException {
        String msgStr = null;
        try {
            File dataFile = new File(fileName);
            if (dataFile.exists() && dataFile.isFile()) {
                msgStr = this.createDataUsingDomParsing(dataFile);
                dataFile.delete();
            } else {
                msgStr = Messages.getString("TransactionCoreModelImplSax_noDataFound");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Exception :TransactionCoreModelImplSax :refreshXMLData :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return msgStr;
    }

    private void createHeaderModel(String transName, String transXmlStr, HashMap colNameObjMap) throws ITMException {
        try {
            String metadataString = null;
            if (transName.equalsIgnoreCase("Taxtran")) {
                metadataString = this.getMetadataString(transName, "", "");
            } else {
                this.transHdrModel = new TransactionHeaderModel();
                this.transKeyObj = new TransactionKey();
                metadataString = this.getMetadataString(transName, "1", "1");
            }
            Document metaDom = this.parseString(metadataString);
            this.setGridLine(metaDom);
            NodeList columnsNodeList = metaDom.getElementsByTagName("table_column");
            int i = 0;
            while (i < columnsNodeList.getLength()) {
                NodeList columnNodeList = columnsNodeList.item(i).getChildNodes();
                Column colObj = new Column();
                colObj.setColID(i + 1);
                int j = 1;
                while (j < columnNodeList.getLength()) {
                    String tagName = null;
                    String tagValue = null;
                    Node colNode = columnNodeList.item(j);
                    tagName = colNode.getNodeName();
                    if (tagName != null) {
                        tagValue = colNode.getFirstChild().getNodeValue().trim();
                    }
                    if (tagName.equals("key")) {
                        colObj.setKey(tagValue.equals("yes"));
                    } else if (tagName.equals("type")) {
                        colObj.setColType(tagValue);
                    } else if (tagName.equals("dbname")) {
                        colObj.setPhysicalName(tagValue);
                    } else if (tagName.equals("values")) {
                        NodeList itemNodeList = colNode.getChildNodes();
                        HashMap<String, String> valuesMap = null;
                        int itemCtr = 0;
                        while (itemCtr < itemNodeList.getLength()) {
                            Node itemNode = itemNodeList.item(itemCtr);
                            if (itemNode.getNodeType() == 1) {
                                if (valuesMap == null) {
                                    valuesMap = new HashMap<String, String>();
                                }
                                String displayStr = itemNode.getAttributes().getNamedItem("display").getNodeValue();
                                String dataStr = itemNode.getAttributes().getNamedItem("data").getNodeValue();
                                valuesMap.put(displayStr, dataStr);
                            }
                            ++itemCtr;
                        }
                        if (valuesMap != null) {
                            colObj.setCompType('C');
                            colObj.setValuesMap(valuesMap);
                        }
                    } else if (tagName.equals("name")) {
                        Node colOtherInfoNode;
                        tagValue = tagValue.trim();
                        colObj.setLogicalName(tagValue);
                        colObj.setBrowName(tagValue);
                        colObj.setType("Column");
                        Node colOtherTextInfo = this.getColOtherTextInfo(metaDom, tagValue.trim());
                        if (colOtherTextInfo != null) {
                            NodeList textNodeInfo = colOtherTextInfo.getChildNodes();
                            int m = 1;
                            while (m < textNodeInfo.getLength()) {
                                Node colNode2 = textNodeInfo.item(m);
                                if (colNode2.getNodeName().equalsIgnoreCase("text") && colNode2.getFirstChild() != null) {
                                    colObj.setBrowName(colNode2.getFirstChild().getNodeValue());
                                }
                                m += 2;
                            }
                        }
                        if ((colOtherInfoNode = this.getColOtherInfo(metaDom, tagValue.trim())) != null) {
                            NodeList otherNodeinfo = colOtherInfoNode.getChildNodes();
                            int x = -1;
                            int y = -1;
                            int cCol = 1;
                            while (cCol < otherNodeinfo.getLength()) {
                                Node colNode2 = otherNodeinfo.item(cCol);
                                if (colNode2.getNodeName().equals("x") && colNode2.getFirstChild() != null) {
                                    x = Integer.parseInt(colNode2.getFirstChild().getNodeValue());
                                    colObj.setBrowPos(x);
                                } else if (colNode2.getNodeName().equals("width") && colNode2.getFirstChild() != null) {
                                    colObj.setWidth(Integer.parseInt(colNode2.getFirstChild().getNodeValue()));
                                } else if (colNode2.getNodeName().equals("alignment") && colNode2.getFirstChild() != null) {
                                    colObj.setAlignment(Integer.parseInt(colNode2.getFirstChild().getNodeValue()));
                                } else if (colNode2.getNodeName().equals("tabsequence") && colNode2.getFirstChild() != null) {
                                    colObj.setTabSequence(Integer.parseInt(colNode2.getFirstChild().getNodeValue()));
                                    if (colObj.getTabSequence() == 32766) {
                                        colObj.setProtectedType(1);
                                    } else {
                                        colObj.setProtectedType(0);
                                    }
                                } else if (colNode2.getNodeName().equals("protect") && colNode2.getFirstChild() != null) {
                                    String protectStr = colNode2.getAttributes().getNamedItem("expression").getNodeValue().trim();
                                    try {
                                        colObj.setProtectedType(Integer.parseInt(protectStr));
                                    }
                                    catch (NumberFormatException numEx) {
                                        colObj.setProtectedType(CommonConstants.DEF_PROTECT);
                                    }
                                }
                                cCol += 2;
                            }
                        }
                    }
                    j += 2;
                }
                if (colObj.getSQLPos() == -1) {
                    colObj.setSQLPos(i);
                }
                if (transName.equalsIgnoreCase("Taxtran")) {
                    Column otherColPropObj;
                    if (colNameObjMap != null && (otherColPropObj = (Column)colNameObjMap.get(colObj.getLogicalName())) != null) {
                        colObj.setPopUpExists(otherColPropObj.getPopUpExists());
                        colObj.setPopUpParam(otherColPropObj.getPopUpParam());
                        colObj.setPopUpSource(otherColPropObj.getPopUpSource());
                        colObj.setPopUpObjName(otherColPropObj.getPopUpObjName());
                        colObj.setPopUpColNames(otherColPropObj.getPopUpColNames());
                        colObj.setFilterString(otherColPropObj.getFilterString());
                        colObj.setSrvCallOnChange(otherColPropObj.getSrvCallOnChange());
                        colObj.setMultiOptionPopUp(otherColPropObj.getMultiOptionPopUp());
                        colObj.setHelpOption(otherColPropObj.getHelpOption());
                    }
                    this.addColumn(CommonConstants.TAX_FORM_NO, colObj.getLogicalName(), colObj);
                } else {
                    this.transHdrModel.addColumn(colObj.getLogicalName(), colObj);
                    if (colObj.isKey()) {
                        this.transKeyObj.setValue(colObj.getLogicalName(), null);
                        this.transKeyObj.setSqlPos(colObj.getLogicalName(), colObj.getSQLPos());
                        this.transKeyObj.addPKCol(colObj);
                    }
                }
                ++i;
            }
            if (!transName.equalsIgnoreCase("Taxtran")) {
                this.setBrowPos();
            }
            if (transXmlStr != null) {
                metaDom = this.parseString(transXmlStr);
                NodeList transNodeList = metaDom.getElementsByTagName("Transaction");
                int transCtr = 0;
                while (transCtr < transNodeList.getLength()) {
                    String transId = transNodeList.item(transCtr).getAttributes().getNamedItem("id").getNodeValue();
                    if (transId.equals(transName)) {
                        NodeList formNodeList = transNodeList.item(transCtr).getChildNodes();
                        int frmCtr = 0;
                        while (frmCtr < formNodeList.getLength()) {
                            Node formNode = formNodeList.item(frmCtr);
                            if (formNode.getNodeName().equalsIgnoreCase("TRANSETUP")) {
                                NodeList formPropNodeList = formNode.getChildNodes();
                                int propCtr = 0;
                                while (propCtr < formPropNodeList.getLength()) {
                                    Node propNode = formPropNodeList.item(propCtr);
                                    if ((!propNode.getNodeName().equalsIgnoreCase("TAX_FORMS") || propNode.getFirstChild() == null || propNode.getFirstChild().getNodeValue() == null || propNode.getFirstChild().getNodeValue().equals("null")) && propNode.getFirstChild() != null && this.transHdrModel != null) {
                                        this.transHdrModel.setObjDetailMapValue(propNode.getNodeName(), propNode.getFirstChild().getNodeValue());
                                    }
                                    ++propCtr;
                                }
                            }
                            ++frmCtr;
                        }
                    }
                    ++transCtr;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionCoreModelImplSax :createHeaderModel :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private void createMetaDataForForm(String transName, String formNo, HashMap colNameObjMap, String objType) throws ITMException {
        BaseLogger.log("2", null, null, " createMetaDataForForm called    [ " + objType + " ]");
        try {
            HashMap<String, String> resCtxMap = new HashMap<String, String>();
            TransactionSaxTransformer tranSaxObj = new TransactionSaxTransformer(this);
            resCtxMap.put("TRANS_NAME", transName);
            resCtxMap.put("FORM_NO", formNo);
            if (objType != null && objType.equalsIgnoreCase("P")) {
                resCtxMap.put("PAGE_CTX", "1");
            }
            if (objType.equalsIgnoreCase("P")) {
                String metadataFileName = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator + transName + resCtxMap.get("PAGE_CTX") + formNo + ".xml";
                File metadataFile = new File(metadataFileName);
                if (metadataFile.exists() && metadataFile.isFile()) {
                    long time = System.currentTimeMillis();
                    tranSaxObj.setFormNo(formNo);
                    tranSaxObj.setColNameObjMap(colNameObjMap);
                    ArrayList<String> toReadObjList = new ArrayList<String>();
                    toReadObjList.add("table_column");
                    toReadObjList.add("GroupBox");
                    toReadObjList.add("ColumnObject");
                    toReadObjList.add("TextObject");
                    toReadObjList.add("BrowInfo");
                    tranSaxObj.setToReadObjList(toReadObjList);
                    tranSaxObj.parse(metadataFile);
                    this.identifyGroups(formNo);
                }
            } else {
                int pageContext = 2;
                while (pageContext >= 1) {
                    String metadataFileName = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator + transName + pageContext + formNo + ".xml";
                    File metadataFile = new File(metadataFileName);
                    if (metadataFile.exists() && metadataFile.isFile()) {
                        ArrayList<String> toReadObjList;
                        long time;
                        if (pageContext == 2) {
                            time = System.currentTimeMillis();
                            tranSaxObj.setFormNo(formNo);
                            tranSaxObj.setColNameObjMap(colNameObjMap);
                            toReadObjList = new ArrayList<String>();
                            toReadObjList.add("table_column");
                            toReadObjList.add("GroupBox");
                            toReadObjList.add("ColumnObject");
                            toReadObjList.add("TextObject");
                            tranSaxObj.setToReadObjList(toReadObjList);
                            tranSaxObj.parse(metadataFile);
                            this.identifyGroups(formNo);
                        } else if (pageContext == 1) {
                            time = System.currentTimeMillis();
                            tranSaxObj.setFormNo(formNo);
                            tranSaxObj.setColNameObjMap(null);
                            toReadObjList = new ArrayList();
                            toReadObjList.add("BrowInfo");
                            tranSaxObj.setToReadObjList(toReadObjList);
                            tranSaxObj.parse(metadataFile);
                        }
                    } else {
                        BaseLogger.log("3", null, null, "TransactionCoreModelImplSax :createMetaDataForForm :File Not Found>" + metadataFileName);
                    }
                    --pageContext;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionCoreModelImplSax :createMetaDataForForm :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private HashMap createFormObjColMap(String transName, String transXmlStr) throws ITMException {
        HashMap<Form, HashMap<String, Column>> formColMap = null;
        ArrayList<String> taxFormList = new ArrayList<String>();
        try {
            DocumentBuilder docBuildFacObj = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document formDom = docBuildFacObj.parse(new ByteArrayInputStream(transXmlStr.getBytes(CommonConstants.ENCODING)));
            NodeList transNodeList = formDom.getElementsByTagName("Transaction");
            int transCtr = 0;
            while (transCtr < transNodeList.getLength()) {
                String transId = transNodeList.item(transCtr).getAttributes().getNamedItem("id").getNodeValue();
                if (transId.equals(transName)) {
                    NodeList formNodeList = transNodeList.item(transCtr).getChildNodes();
                    int frmCtr = 0;
                    while (frmCtr < formNodeList.getLength()) {
                        String formId;
                        Node formNode = formNodeList.item(frmCtr);
                        if (formNode.getNodeName().equalsIgnoreCase("TRANSETUP")) {
                            NodeList formPropNodeList = formNode.getChildNodes();
                            int propCtr = 0;
                            while (propCtr < formPropNodeList.getLength()) {
                                Node propNode = formPropNodeList.item(propCtr);
                                if (propNode.getNodeName().equalsIgnoreCase("TAX_FORMS") && propNode.getFirstChild() != null && propNode.getFirstChild().getNodeValue() != null && !propNode.getFirstChild().getNodeValue().equals("null")) {
                                    if (propNode.getFirstChild().getNodeValue().indexOf(",") == -1) {
                                        taxFormList.add(propNode.getFirstChild().getNodeValue());
                                    } else {
                                        StringTokenizer strToken = new StringTokenizer(propNode.getFirstChild().getNodeValue(), ",");
                                        while (strToken.hasMoreElements()) {
                                            taxFormList.add(strToken.nextToken());
                                        }
                                    }
                                    Form frmObj = new Form();
                                    frmObj.setTransName("Taxtran");
                                    frmObj.setFormNo(CommonConstants.TAX_FORM_NO);
                                    if (formColMap == null) {
                                        formColMap = new HashMap();
                                    }
                                    if (this.addNewForm(CommonConstants.TAX_FORM_NO, frmObj)) {
                                        formColMap.put(frmObj, null);
                                    }
                                } else if (propNode.getFirstChild() != null) {
                                    this.setObjDetailMapValue(propNode.getNodeName(), propNode.getFirstChild().getNodeValue());
                                }
                                ++propCtr;
                            }
                        } else if (formNode.getNodeName().equalsIgnoreCase("Form") && (formId = formNode.getAttributes().getNamedItem("no").getNodeValue()) != null) {
                            Form frmObj = new Form();
                            HashMap<String, Column> colNameObjMap = null;
                            frmObj.setTransName(transId);
                            frmObj.setFormNo(formId);
                            if (taxFormList.contains(formId)) {
                                frmObj.setTaxApplicable(true);
                            }
                            NodeList formPropNodeList = formNode.getChildNodes();
                            int propCtr = 0;
                            while (propCtr < formPropNodeList.getLength()) {
                                Node propNode = formPropNodeList.item(propCtr);
                                if (propNode.getNodeName().equalsIgnoreCase("Title") && propNode.getFirstChild() != null) {
                                    frmObj.setTitle(propNode.getFirstChild().getNodeValue());
                                } else if (propNode.getNodeName().equalsIgnoreCase("CrossUpdateExpr") && propNode.getFirstChild() != null) {
                                    frmObj.setCrossUpdateExpr(propNode.getFirstChild().getNodeValue());
                                } else if (propNode.getNodeName().equalsIgnoreCase("ExprFldInfo") && propNode.getFirstChild() != null) {
                                    frmObj.setExprFldInfo(propNode.getFirstChild().getNodeValue());
                                } else if (propNode.getNodeName().equalsIgnoreCase("TargetFldInfo") && propNode.getFirstChild() != null) {
                                    frmObj.setTargetFldInfo(propNode.getFirstChild().getNodeValue());
                                } else if (propNode.getNodeName().equalsIgnoreCase("ExprComment") && propNode.getFirstChild() != null) {
                                    frmObj.setExprComment(propNode.getFirstChild().getNodeValue());
                                } else if (propNode.getNodeName().equalsIgnoreCase("ScanFlag") && propNode.getFirstChild() != null) {
                                    frmObj.setScanFlag(propNode.getFirstChild().getNodeValue());
                                } else if (propNode.getNodeName().equalsIgnoreCase("ScanMetadata") && propNode.getFirstChild() != null) {
                                    frmObj.setScanMetadata(propNode.getFirstChild().getNodeValue());
                                } else if (propNode.getNodeName().equalsIgnoreCase("AutoAcceptScan") && propNode.getFirstChild() != null) {
                                    frmObj.setAutoAcceptScan(propNode.getFirstChild().getNodeValue());
                                } else if (propNode.getNodeName().equalsIgnoreCase("PropertyInfo") && propNode.getFirstChild() != null) {
                                    frmObj.setPropertyInfo(propNode.getFirstChild().getNodeValue());
                                } else if (propNode.getNodeName().equalsIgnoreCase("ExtCom") && propNode.getFirstChild() != null) {
                                    frmObj.setExtCom(propNode.getFirstChild().getNodeValue());
                                } else if (propNode.getNodeName().equalsIgnoreCase("ExtMetadata") && propNode.getFirstChild() != null) {
                                    frmObj.setExtMetadata(propNode.getFirstChild().getNodeValue());
                                } else if (propNode.getNodeName().equalsIgnoreCase("ExtSetup") && propNode.getFirstChild() != null) {
                                    frmObj.setExtSetUp(propNode.getFirstChild().getNodeValue());
                                } else if (propNode.getNodeName().equalsIgnoreCase("ScanDelimiter") && propNode.getFirstChild() != null) {
                                    frmObj.setScanDelimiter(propNode.getFirstChild().getNodeValue());
                                } else if (propNode.getNodeName().equalsIgnoreCase("AutoAcceptWeighdata") && propNode.getFirstChild() != null) {
                                    frmObj.setAutoAcceptWeighdata(propNode.getFirstChild().getNodeValue());
                                } else if (propNode.getNodeName().equalsIgnoreCase("Column")) {
                                    String colName = propNode.getAttributes().getNamedItem("id").getNodeValue();
                                    if (colName.equalsIgnoreCase("itm_default")) {
                                        frmObj.setITMDefault(true);
                                    } else if (colName.equalsIgnoreCase("itm_defaultedit")) {
                                        frmObj.setITMDefaultEdit(true);
                                    } else {
                                        boolean popUpExists;
                                        Column colObj = new Column();
                                        colObj.setLogicalName(colName.trim());
                                        if (propNode.getAttributes().getNamedItem("popUpExists") != null && (popUpExists = Boolean.valueOf(propNode.getAttributes().getNamedItem("popUpExists").getNodeValue()).booleanValue())) {
                                            String param;
                                            int multiOptPopUp = 0;
                                            if (propNode.getAttributes().getNamedItem("multiOptPopUp") != null) {
                                                multiOptPopUp = Integer.parseInt(propNode.getAttributes().getNamedItem("multiOptPopUp").getNodeValue());
                                                colObj.setMultiOptionPopUp(multiOptPopUp);
                                            }
                                            if (propNode.getAttributes().getNamedItem("helpOption") != null) {
                                                String helpOption = propNode.getAttributes().getNamedItem("helpOption").getNodeValue();
                                                colObj.setHelpOption(Integer.parseInt(helpOption));
                                            }
                                            colObj.setPopUpExists(popUpExists);
                                            colObj.setMultiOptionPopUp(multiOptPopUp);
                                            String popUpSource = null;
                                            if (propNode.getAttributes().getNamedItem("popUpSource") != null) {
                                                popUpSource = propNode.getAttributes().getNamedItem("popUpSource").getNodeValue();
                                                colObj.setPopUpSource("null".equalsIgnoreCase(popUpSource) ? null : popUpSource);
                                            }
                                            if ("M".equalsIgnoreCase(popUpSource)) {
                                                if (propNode.getAttributes().getNamedItem("popUpObjName") != null) {
                                                    String popUpObjName = propNode.getAttributes().getNamedItem("popUpObjName").getNodeValue();
                                                    colObj.setPopUpObjName("null".equalsIgnoreCase(popUpObjName) ? null : popUpObjName);
                                                }
                                                NodeList popUpParamList = propNode.getChildNodes();
                                                int cnt = 0;
                                                while (cnt < popUpParamList.getLength()) {
                                                    Node paramNode = popUpParamList.item(cnt);
                                                    if ("POPHELP_COLS".equalsIgnoreCase(paramNode.getNodeName())) {
                                                        colObj.setPopUpColNames("null".equalsIgnoreCase(paramNode.getFirstChild().getNodeValue()) ? null : paramNode.getFirstChild().getNodeValue());
                                                    } else if ("FILTER_STRING".equalsIgnoreCase(paramNode.getNodeName())) {
                                                        colObj.setFilterString("null".equalsIgnoreCase(paramNode.getFirstChild().getNodeValue()) ? null : paramNode.getFirstChild().getNodeValue());
                                                    }
                                                    ++cnt;
                                                }
                                            }
                                            colObj.setPopUpParam((param = propNode.getAttributes().getNamedItem("popUpParam").getNodeValue()).equalsIgnoreCase("null") ? null : param);
                                        }
                                        if (propNode.getAttributes().getNamedItem("srvCallOnChange") != null) {
                                            boolean srvCallOnChange = new Boolean(propNode.getAttributes().getNamedItem("srvCallOnChange").getNodeValue());
                                            colObj.setSrvCallOnChange(srvCallOnChange);
                                        }
                                        if (colNameObjMap == null) {
                                            colNameObjMap = new HashMap<String, Column>();
                                        }
                                        colNameObjMap.put(colName, colObj);
                                        Node valInfoNode = null;
                                        if (propNode.hasChildNodes()) {
                                            NodeList propChildNodes = propNode.getChildNodes();
                                            int i = 0;
                                            while (i < propChildNodes.getLength()) {
                                                Node childNode = propChildNodes.item(i);
                                                if (childNode.getNodeName().equalsIgnoreCase("ValInfo")) {
                                                    valInfoNode = childNode;
                                                }
                                                ++i;
                                            }
                                        }
                                        if (valInfoNode != null) {
                                            ITMRule itmRuleObj = new ITMRule();
                                            if (valInfoNode.getAttributes().getNamedItem("BlankOpt") != null) {
                                                String blankOpt = valInfoNode.getAttributes().getNamedItem("BlankOpt").getNodeValue();
                                                itmRuleObj.setBlankOpt(blankOpt.equalsIgnoreCase("null") ? null : blankOpt);
                                            }
                                            if (valInfoNode.getAttributes().getNamedItem("ValType") != null) {
                                                String valType = valInfoNode.getAttributes().getNamedItem("ValType").getNodeValue();
                                                itmRuleObj.setValType(valType.equalsIgnoreCase("null") ? null : valType);
                                            }
                                            if (valInfoNode.getAttributes().getNamedItem("ValidateFromObjName") != null) {
                                                String ValidateFromObjName = valInfoNode.getAttributes().getNamedItem("ValidateFromObjName").getNodeValue();
                                                itmRuleObj.setValidateFromObjName(ValidateFromObjName.equalsIgnoreCase("null") ? null : ValidateFromObjName);
                                            }
                                            if (valInfoNode.getAttributes().getNamedItem("ErrorCode") != null) {
                                                String errorCode = valInfoNode.getAttributes().getNamedItem("ErrorCode").getNodeValue();
                                                itmRuleObj.setErrorCode(errorCode.equalsIgnoreCase("null") ? null : errorCode.trim());
                                            }
                                            if (valInfoNode.hasChildNodes()) {
                                                Node msgNode = null;
                                                NodeList valInfoChildNodes = valInfoNode.getChildNodes();
                                                int i = 0;
                                                while (i < valInfoChildNodes.getLength()) {
                                                    Node childNode = valInfoChildNodes.item(i);
                                                    if (childNode.getNodeName().equalsIgnoreCase("Message")) {
                                                        msgNode = childNode;
                                                    }
                                                    ++i;
                                                }
                                                if (msgNode != null && msgNode.getFirstChild() != null) {
                                                    String msgStr = msgNode.getFirstChild().getNodeValue();
                                                    itmRuleObj.setMessage(msgStr.equalsIgnoreCase("null") ? null : msgStr);
                                                }
                                            }
                                            itmRuleObj.setFieldName(colName.trim());
                                            itmRuleObj.setObjName(transName);
                                            ITMValidatorComponent.getInstance().addValidationRules(formId, colName, itmRuleObj);
                                        }
                                    }
                                }
                                ++propCtr;
                            }
                            if (formColMap == null) {
                                formColMap = new HashMap<Form, HashMap<String, Column>>();
                            }
                            if (this.addNewForm(formId, frmObj)) {
                                formColMap.put(frmObj, colNameObjMap);
                            }
                        }
                        ++frmCtr;
                    }
                }
                ++transCtr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionCoreModelImplSax :createFormsListFromXML :==>" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return formColMap;
    }

    private Node getColOtherTextInfo(Document dom, String nameSearch) throws ITMException {
        Node returnNode;
        block6: {
            returnNode = null;
            try {
                NodeList colDetailList = dom.getElementsByTagName("TextObject");
                int colDetailListLen = colDetailList.getLength();
                int i = 0;
                while (i < colDetailListLen) {
                    Node colNodeTextObject = colDetailList.item(i);
                    NodeList colNodeList = colNodeTextObject.getChildNodes();
                    int colNodeListLength = colNodeList.getLength();
                    int j = 1;
                    while (j < colNodeListLength) {
                        String tagName = null;
                        String tagValue = null;
                        Node colNode = colNodeList.item(j);
                        tagName = colNode.getNodeName().trim();
                        if (colNode.getFirstChild() != null && colNode.getFirstChild().getNodeValue() != null) {
                            tagValue = colNode.getFirstChild().getNodeValue().trim();
                        }
                        if (tagName.equals("name") && (tagValue = tagValue.trim()).equalsIgnoreCase(String.valueOf(nameSearch) + "_t")) {
                            returnNode = colDetailList.item(i);
                            break block6;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :TransactionCoreModelImplSax :getColOtherTextInfo :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return returnNode;
    }

    private Node getColOtherInfo(Document dom, String nameSearch) throws ITMException {
        Node returnNode;
        block6: {
            returnNode = null;
            try {
                NodeList colDetailList = dom.getElementsByTagName("ColumnObject");
                int colDetailListLength = colDetailList.getLength();
                int i = 0;
                while (i < colDetailListLength) {
                    Node colNodeColumnObject = colDetailList.item(i);
                    NodeList colNodeList = colNodeColumnObject.getChildNodes();
                    int colNodeListLength = colNodeList.getLength();
                    int j = 1;
                    while (j < colNodeListLength) {
                        String tagName = null;
                        String tagValue = null;
                        Node colNode = colNodeList.item(j);
                        tagName = colNode.getNodeName().trim();
                        if (colNode.getFirstChild() != null && colNode.getFirstChild().getNodeValue() != null) {
                            tagValue = colNode.getFirstChild().getNodeValue().trim();
                        }
                        if (tagName.equals("name") && (tagValue = tagValue.trim()).equals(nameSearch)) {
                            returnNode = colDetailList.item(i);
                            break block6;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :TransactionCoreModelImplSax :getColOtherInfo :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return returnNode;
    }

    private String createDataUsingDomParsing(File dataFile) throws ITMException {
        String msgStr = null;
        try {
            DocumentBuilder docBuildFacObj = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document dataDom = docBuildFacObj.parse(dataFile);
            String formNo2 = null;
            Node headNode = dataDom.getElementsByTagName("Header0").item(0);
            if (headNode != null) {
                NodeList detailNodeList = headNode.getChildNodes();
                HashMap<String, ArrayList> formNoRowCountMap = new HashMap<String, ArrayList>();
                int noOFDetails = detailNodeList.getLength();
                int detailCtr = 0;
                while (detailCtr < noOFDetails) {
                    String tagName = detailNodeList.item(detailCtr).getNodeName();
                    if (tagName.startsWith("Detail")) {
                        formNo2 = tagName.substring(tagName.indexOf("l") + 1);
                        String domIdStr = detailNodeList.item(detailCtr).getAttributes().getNamedItem("domID").getNodeValue();
                        ArrayList domIdList = null;
                        if (!formNoRowCountMap.containsKey(formNo2)) {
                            domIdList = new ArrayList();
                            domIdList.add(new Integer(domIdStr));
                            formNoRowCountMap.put(formNo2, domIdList);
                        } else {
                            domIdList = (ArrayList)formNoRowCountMap.get(formNo2);
                            domIdList.add(new Integer(domIdStr));
                            formNoRowCountMap.put(formNo2, domIdList);
                        }
                    }
                    ++detailCtr;
                }
                for (String formNo2 : formNoRowCountMap.keySet()) {
                    this.setDefaultRowToDataForm(formNo2, (ArrayList)formNoRowCountMap.get(formNo2));
                }
                int detailCtr2 = 0;
                while (detailCtr2 < detailNodeList.getLength()) {
                    Node detailNode = detailNodeList.item(detailCtr2);
                    String tagName = detailNode.getNodeName();
                    if (tagName.startsWith("Detail")) {
                        formNo2 = tagName.substring(tagName.indexOf("l") + 1);
                        String domIdStr = detailNode.getAttributes().getNamedItem("domID").getNodeValue();
                        int domId = Integer.parseInt(domIdStr);
                        HashMap<String, String> fieldValueMap = new HashMap<String, String>();
                        NodeList colNodeList = detailNode.getChildNodes();
                        String status = null;
                        String updateFlag = null;
                        ArrayList allTaxDataList = null;
                        int colCtr = 0;
                        while (colCtr < colNodeList.getLength()) {
                            Node colNode = colNodeList.item(colCtr);
                            String colName = colNode.getNodeName().trim();
                            if (!colName.equalsIgnoreCase("attribute") && colNode.getNodeType() == 1) {
                                if (colName.equalsIgnoreCase("Taxes")) {
                                    allTaxDataList = this.loadTaxData(colNode);
                                } else {
                                    String colValue = null;
                                    Column colObj = this.getColumn(formNo2, colName);
                                    if (colNode.getFirstChild() != null && colObj != null) {
                                        colValue = colNode.getFirstChild().getNodeValue();
                                        colObj.setIsChanged(true);
                                    }
                                    fieldValueMap.put(colName, colValue);
                                    if (colNode.getAttributes().getNamedItem("protect") != null && colObj != null) {
                                        String protectStr = colNode.getAttributes().getNamedItem("protect").getNodeValue().trim();
                                        colObj.setProtectedType(Integer.parseInt(protectStr));
                                    }
                                }
                            } else if (colName.equalsIgnoreCase("attribute")) {
                                status = colNode.getAttributes().getNamedItem("status").getNodeValue();
                                updateFlag = colNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
                            }
                            ++colCtr;
                        }
                        this.setRow(formNo2, domId, status.charAt(0), updateFlag.charAt(0), fieldValueMap);
                        if (allTaxDataList != null) {
                            this.insertTaxDetail(formNo2, domId, allTaxDataList);
                        }
                    }
                    ++detailCtr2;
                }
            } else {
                Node msgNode = dataDom.getElementsByTagName("Message").item(0);
                msgStr = msgNode != null && msgNode.getFirstChild() != null ? msgNode.getFirstChild().getNodeValue() : msgStr;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Exception :TransactionCoreModelImplSax :createDataUsingDomParsing :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return msgStr;
    }

    private String createDataUsingDomParsing(String xmlData) throws ITMException {
        String msgStr = null;
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            Document dataDom = genericUtility.parseString(xmlData);
            String formNo2 = null;
            Node headNode = dataDom.getElementsByTagName("Header0").item(0);
            if (headNode != null) {
                NodeList detailNodeList = headNode.getChildNodes();
                HashMap<String, ArrayList> formNoRowCountMap = new HashMap<String, ArrayList>();
                int noOFDetails = detailNodeList.getLength();
                int detailCtr = 0;
                while (detailCtr < noOFDetails) {
                    String tagName = detailNodeList.item(detailCtr).getNodeName();
                    if (tagName.startsWith("Detail")) {
                        formNo2 = tagName.substring(tagName.indexOf("l") + 1);
                        String domIdStr = detailNodeList.item(detailCtr).getAttributes().getNamedItem("domID").getNodeValue();
                        ArrayList domIdList = null;
                        if (!formNoRowCountMap.containsKey(formNo2)) {
                            domIdList = new ArrayList();
                            domIdList.add(new Integer(domIdStr));
                            formNoRowCountMap.put(formNo2, domIdList);
                        } else {
                            domIdList = (ArrayList)formNoRowCountMap.get(formNo2);
                            domIdList.add(new Integer(domIdStr));
                            formNoRowCountMap.put(formNo2, domIdList);
                        }
                    }
                    ++detailCtr;
                }
                for (String formNo2 : formNoRowCountMap.keySet()) {
                    this.setDefaultRowToDataForm(formNo2, (ArrayList)formNoRowCountMap.get(formNo2));
                }
                int detailCtr2 = 0;
                while (detailCtr2 < detailNodeList.getLength()) {
                    Node detailNode = detailNodeList.item(detailCtr2);
                    String tagName = detailNode.getNodeName();
                    if (tagName.startsWith("Detail")) {
                        formNo2 = tagName.substring(tagName.indexOf("l") + 1);
                        String domIdStr = detailNode.getAttributes().getNamedItem("domID").getNodeValue();
                        int domId = Integer.parseInt(domIdStr);
                        HashMap<String, String> fieldValueMap = new HashMap<String, String>();
                        NodeList colNodeList = detailNode.getChildNodes();
                        String status = null;
                        String updateFlag = null;
                        ArrayList allTaxDataList = null;
                        int colCtr = 0;
                        while (colCtr < colNodeList.getLength()) {
                            Node colNode = colNodeList.item(colCtr);
                            String colName = colNode.getNodeName().trim();
                            if (!colName.equalsIgnoreCase("attribute") && colNode.getNodeType() == 1) {
                                if (colName.equalsIgnoreCase("Taxes")) {
                                    allTaxDataList = this.loadTaxData(colNode);
                                } else {
                                    String colValue = null;
                                    Column colObj = this.getColumn(formNo2, colName);
                                    if (colNode.getFirstChild() != null && colObj != null) {
                                        colValue = colNode.getFirstChild().getNodeValue();
                                        colObj.setIsChanged(true);
                                    }
                                    fieldValueMap.put(colName, colValue);
                                    if (colNode.getAttributes().getNamedItem("protect") != null && colObj != null) {
                                        String protectStr = colNode.getAttributes().getNamedItem("protect").getNodeValue().trim();
                                        colObj.setProtectedType(Integer.parseInt(protectStr));
                                    }
                                }
                            } else if (colName.equalsIgnoreCase("attribute")) {
                                status = colNode.getAttributes().getNamedItem("status").getNodeValue();
                                updateFlag = colNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
                            }
                            ++colCtr;
                        }
                        this.setRow(formNo2, domId, status.charAt(0), updateFlag.charAt(0), fieldValueMap);
                        if (allTaxDataList != null) {
                            this.insertTaxDetail(formNo2, domId, allTaxDataList);
                        }
                    }
                    ++detailCtr2;
                }
            } else {
                Node msgNode = dataDom.getElementsByTagName("Message").item(0);
                msgStr = msgNode != null && msgNode.getFirstChild() != null ? msgNode.getFirstChild().getNodeValue() : msgStr;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Exception :TransactionCoreModelImplSax :createDataUsingDomParsing :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return msgStr;
    }

    public ArrayList loadTaxData(Node taxesNode) throws ITMException {
        ArrayList allTaxDataList = new ArrayList();
        try {
            int taxRowCtr = 0;
            this.allTaxFieldEditMap = new HashMap();
            NodeList taxNodeList = taxesNode.getChildNodes();
            int taxCtr = 0;
            while (taxCtr < taxNodeList.getLength()) {
                Node detailNode = taxNodeList.item(taxCtr);
                if (detailNode.getNodeName().startsWith("Tax")) {
                    String status = null;
                    String updateFlag = null;
                    int domId = -1;
                    ArrayList<String> editableTaxFieldList = new ArrayList<String>();
                    editableTaxFieldList.add("tax_perc");
                    if (detailNode.getAttributes().getNamedItem("domID") != null) {
                        String domIdStr = detailNode.getAttributes().getNamedItem("domID").getNodeValue();
                        domId = Integer.parseInt(domIdStr);
                    }
                    NodeList colNodeList = detailNode.getChildNodes();
                    ArrayList<Constable> taxDataList = new ArrayList<Constable>();
                    HashMap<String, String> taxColValueMap = new HashMap<String, String>();
                    int colCtr = 0;
                    while (colCtr < colNodeList.getLength()) {
                        Node colNode = colNodeList.item(colCtr);
                        if (colNode.getNodeName().equalsIgnoreCase("attribute")) {
                            status = colNode.getAttributes().getNamedItem("status").getNodeValue();
                            updateFlag = colNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
                        } else if (!colNode.getNodeName().equalsIgnoreCase("attribute") && colNode.getNodeType() == 1) {
                            Column colObj = this.getColumn(CommonConstants.TAX_FORM_NO, colNode.getNodeName().trim());
                            String colValue = null;
                            if (colNode.getFirstChild() != null && colObj != null) {
                                colValue = colNode.getFirstChild().getNodeValue();
                                colObj.setIsChanged(true);
                            }
                            taxColValueMap.put(colNode.getNodeName(), colValue);
                            if (colNode.getAttributes().getNamedItem("protect") != null && colObj != null) {
                                String protectStr = colNode.getAttributes().getNamedItem("protect").getNodeValue().trim();
                                colObj.setProtectedType(Integer.parseInt(protectStr));
                                if (colObj.getLogicalName().equalsIgnoreCase("tax_perc") && "1".equalsIgnoreCase(protectStr)) {
                                    editableTaxFieldList.clear();
                                }
                            }
                            if (colObj.getLogicalName().equalsIgnoreCase("cc_editopt") && "N".equalsIgnoreCase(colValue)) {
                                editableTaxFieldList.clear();
                            }
                        }
                        ++colCtr;
                    }
                    int size = this.getTransInfoSize();
                    int ctr = 0;
                    while (ctr < taxColValueMap.size() + size) {
                        taxDataList.add(null);
                        ++ctr;
                    }
                    taxDataList.set(0, new Integer(domId));
                    taxDataList.set(1, new Character(status.charAt(0)));
                    taxDataList.set(2, new Character(updateFlag.charAt(0)));
                    for (String colLogicalName : taxColValueMap.keySet()) {
                        Column colObj = this.getColumn(CommonConstants.TAX_FORM_NO, colLogicalName);
                        if (colObj == null || colObj.getSQLPos() == -1) continue;
                        taxDataList.set(colObj.getSQLPos() + size, (Constable)taxColValueMap.get(colLogicalName));
                    }
                    allTaxDataList.add(taxDataList);
                    this.allTaxFieldEditMap.put(String.valueOf(taxRowCtr++), editableTaxFieldList);
                }
                ++taxCtr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionCoreModelImplSax :loadTaxData :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return allTaxDataList;
    }

    public HashMap getAllTaxFieldEditMap() {
        return this.allTaxFieldEditMap;
    }

    private void setBrowPos() throws ITMException {
        try {
            ArrayList browColList = this.transHdrModel.getBrowColumnList(true);
            int i = 0;
            while (i < browColList.size()) {
                Column colObj = (Column)browColList.get(i);
                colObj.setBrowSequence(i);
                if (colObj.isKey()) {
                    this.transKeyObj.setBrowPos(colObj.getLogicalName(), i);
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionCoreModelImplSax :setBrowPos :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public TransactionHeaderModel getHeaderModel() throws ITMException {
        try {
            return this.transHdrModel;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionCoreModelImplSax :getHeaderModel :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public TransactionKey getTransKey() throws ITMException {
        try {
            return this.transKeyObj;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionCoreModelImplSax :getHeaderModel :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private String getMetadataString(String transName, String pageContext, String formNo) throws Exception {
        String metadataString = null;
        BaseLogger.log("2", null, null, "getMetadataString is called........");
        HashMap<String, String> resCtxMap = new HashMap<String, String>();
        resCtxMap.put("TRANS_NAME", transName);
        resCtxMap.put("FORM_NO", formNo);
        resCtxMap.put("PAGE_CTX", pageContext);
        String metadataFileName = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator + transName + pageContext + formNo + ".xml";
        metadataString = this.readFile(metadataFileName);
        return metadataString;
    }

    private Document parseString(String xmlString) throws ITMException {
        Document dom = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, CommonConstants.FILE_ENCODING);
            ByteArrayInputStream baos = new ByteArrayInputStream(xmlString.getBytes(CommonConstants.ENCODING));
            dom = db.parse(baos);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : TransactionCoreModelImplSax : parseString :" + e);
            throw new ITMException(e);
        }
        return dom;
    }

    private String readFile(String fileName) throws Exception {
        StringBuffer fileContent = new StringBuffer();
        FileInputStream fMainIn = new FileInputStream(fileName);
        BufferedReader bfr = new BufferedReader(new InputStreamReader((InputStream)fMainIn, CommonConstants.ENCODING));
        String outTempStr = null;
        while ((outTempStr = bfr.readLine()) != null) {
            fileContent.append(outTempStr);
        }
        return fileContent.toString();
    }

    public void parseTabSeparatedData(String outTempStr, String formNo) throws Exception {
        if (outTempStr != null) {
            HashMap colLogicalNameObjMap = this.getColLogicalNameMap(formNo);
            int domId = 0;
            int noOfRows = this.getNoOfRows(formNo);
            int i = 0;
            while (i < noOfRows) {
                this.deleteRow(formNo, 0);
                ++i;
            }
            if (outTempStr.length() > 0) {
                String[] lineArr = outTempStr.split("\\r\\n");
                if (lineArr.length <= 1) {
                    lineArr = outTempStr.split("\\n");
                }
                BaseLogger.log("0", null, null, "lineArr length:" + lineArr.length);
                int i2 = 0;
                while (i2 < lineArr.length) {
                    ArrayList<String> rowList = new ArrayList<String>();
                    String tokenString = lineArr[i2].substring(0, lineArr[i2].length());
                    String delimiter = "\t";
                    while (tokenString.indexOf(delimiter) != -1) {
                        int endIndex = tokenString.indexOf(delimiter);
                        rowList.add(tokenString.substring(0, endIndex));
                        tokenString = tokenString.substring(endIndex + 1, tokenString.length());
                    }
                    rowList.add(tokenString);
                    Iterator iter = colLogicalNameObjMap.keySet().iterator();
                    HashMap fieldNameValueMap = new HashMap();
                    while (iter.hasNext()) {
                        Column colObj;
                        String colLogicalName = (String)iter.next();
                        if (!colLogicalNameObjMap.get(colLogicalName).getClass().isInstance(new Column()) || (colObj = (Column)colLogicalNameObjMap.get(colLogicalName)).getSQLPos() == -1 || colObj.getSQLPos() >= rowList.size()) continue;
                        fieldNameValueMap.put(colLogicalName, rowList.get(colObj.getSQLPos()));
                    }
                    this.insertRow(formNo, ++domId, 'N', 'A', fieldNameValueMap);
                    ++i2;
                }
            }
        }
    }

    private void setGridLine(Document metaDom) throws Exception {
        NodeList gridList = metaDom.getElementsByTagName("grid.lines");
        if (gridList != null && gridList.item(0) != null) {
            this.setGridStructure(true);
        }
    }

    public void deleteAllRows(String formNo) throws Exception {
        int noOfRows = this.getNoOfRows(formNo);
        BaseLogger.log("3", null, null, " noOfRows for the form [" + formNo + "] is [" + noOfRows + "]");
        int i = 0;
        while (i < noOfRows) {
            this.deleteRow(formNo, 0);
            ++i;
        }
    }
}

