/* created by shraddha M
 * Brand prescription: adding prescription for doctor [09-jan-2021] W20ISUN022
 * */
 package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

public class SprsCampgnRxWizard extends ValidatorEJB implements SprsCampgnRxWizardLocal, SprsCampgnRxWizardRemote
{
	GenericUtility genericUtility = GenericUtility.getInstance();
	
	public String getDoctorDetail(Document dom, Document dom1, Document dom2, String campgnID, String xtraParams,String salesPers,String editFlag,String objContext,String formName,String brandCode,String brandItem,Connection conn) throws RemoteException,ITMException
	{
		String doctorsql="";
		int currentFormNo = 0;
		int lineNum=1;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String doctorName="";
		String localityDescr ="";
		String localityCode="";
		String speciality = "";
		String qualification="";
		String tranIdSql="",strgCodeSql="";
		String presctranId="", doctorTranId="";
		String selStrgCode="";
		String selBrandCode="";
		String strgCode="";
		String brandDescr="";
		String classCode="";
		String stateDesc="";
		String category="";
		String selDoctors ="";
		String doctranIdSql="";
		String rxCnt="";
		HashMap selStrgCodeMap = new HashMap();
		StringBuffer valueXmlString = new StringBuffer();
		StringBuffer custBuff = new StringBuffer();
		String customers="";
		boolean isLocalConn =false;
		try 
		{
			if(conn == null )
			{
				conn = getConnection();
				isLocalConn =true;
			}
			
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			int domID = 1;
            
            brandCode = checkNull(genericUtility.getColumnValue("brand_code",dom1));

            System.out.println("brandCode::::: rxw iz:["+brandCode+"]");
            
            DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Calendar calendar = Calendar.getInstance();
			String currentDate  = dtFormat.format(calendar.getTime());
			currentDate =  genericUtility.getValidDateString(currentDate,  genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
			System.out.println("currentDate => " + currentDate);
            /*tranIdSql="select max(tran_id) as tran_id from SPRS_CAMPGN where tran_date =(select max(SP.tran_date) from SPRS_CAMPGN SP, STRG_CAMPAIGN ST where SP.CAMPGN_ID = ST.CAMPGN_ID and SP.tran_date between ST.eff_from and ST.valid_upto and SP.sales_pers =? ) and sales_pers = ? AND TRAN_TYPE='P' ";
            
            pstmt =  conn.prepareStatement(tranIdSql);
			pstmt.setString(1, salesPers);
			pstmt.setString(2, salesPers);
			rs = pstmt.executeQuery();
			if (rs.next())                           
			{
				presctranId=checkNull(rs.getString("tran_id"));
				System.out.println("presctranId="+presctranId);
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}*/
			//Added by mrunalini SInkar for grace period chages
			int graceDays=0;

			String sql = "SELECT GRACE_DAYS FROM STRG_CAMPAIGN  WHERE CAMPGN_ID = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, campgnID);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				graceDays = rs.getInt("GRACE_DAYS");

			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
            
            tranIdSql="select max(SC.tran_id)  as tran_id from SPRS_CAMPGN SC,SPRS_CAMPGN_STRG SCMPS,STRG_CAMPAIGN SCM "
					+ " where SC.tran_date  between SCM.EFF_FROM and SCM.VALID_UPTO+? and  SC.tran_date = ? AND SC.CAMPGN_ID=SCM.CAMPGN_ID "
					+ "and SC.sales_pers = ? and SC.tran_type= ? and SC.campgn_id=? AND SC.tran_id=SCMPS.tran_id AND SCMPS.BRAND_CODE=?";  // adding campaignId 3032021 issue raised by qc then changes
			pstmt =  conn.prepareStatement(tranIdSql);
			pstmt.setInt(1, graceDays);
			pstmt.setDate(2,java.sql.Date.valueOf(currentDate));
			pstmt.setString(3, salesPers);
            pstmt.setString(4, "P");
            pstmt.setString(5,campgnID);       
            pstmt.setString(6,brandCode);       

			rs = pstmt.executeQuery();
			if (rs.next())                           
			{
				presctranId=checkNull(rs.getString("tran_id"));
				System.out.println("presctranId="+presctranId);

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
            
			 /*doctranIdSql="select max(SC.tran_id) as tran_id from SPRS_CAMPGN SC,SPRS_CAMPGN_STRG SCMPS where tran_date =(select max(SP.tran_date) from SPRS_CAMPGN SP, STRG_CAMPAIGN ST where SP.CAMPGN_ID = ST.CAMPGN_ID and SP.tran_date between ST.eff_from and ST.valid_upto and SP.sales_pers =? ) "
			 		+ "and sales_pers = ? AND TRAN_TYPE='D' AND SC.tran_id=SCMPS.tran_id AND SCMPS.BRAND_CODE=? ";
	            
	            pstmt =  conn.prepareStatement(doctranIdSql);
				pstmt.setString(1, salesPers);
				pstmt.setString(2, salesPers);
				rs = pstmt.executeQuery();
				if (rs.next())                           
				{
					doctorTranId=checkNull(rs.getString("tran_id"));
					System.out.println("doctorTranId="+doctorTranId);
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}*/
			doctranIdSql="select max(SC.tran_id)  as tran_id from SPRS_CAMPGN SC,SPRS_CAMPGN_STRG SCMPS,STRG_CAMPAIGN SCM "
					+ " where SC.tran_date  between SCM.EFF_FROM and SCM.VALID_UPTO+? AND SC.CAMPGN_ID=SCM.CAMPGN_ID "
					+ "and SC.sales_pers = ? and SC.tran_type= ? and SC.campgn_id=? AND SC.tran_id=SCMPS.tran_id AND SCMPS.BRAND_CODE=?";  // adding campaignId 3032021 issue raised by qc then changes
			pstmt =  conn.prepareStatement(doctranIdSql);
			
			pstmt.setInt(1, graceDays);
			pstmt.setString(2, salesPers);
            pstmt.setString(3, "D");
            pstmt.setString(4,campgnID);       
            pstmt.setString(5,brandCode);    
			rs = pstmt.executeQuery();
			if (rs.next())                           
			{
				doctorTranId=checkNull(rs.getString("tran_id"));
				System.out.println("doctorTranId="+doctorTranId);

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

			strgCodeSql="SELECT STRG_CODE, BRAND_CODE FROM SPRS_CAMPGN_STRG WHERE TRAN_ID =?  AND BRAND_CODE=?";
			pstmt =  conn.prepareStatement(strgCodeSql);
			pstmt.setString(1, presctranId);
            pstmt.setString(2,brandCode);       

			rs = pstmt.executeQuery();
			while(rs.next())
			{
				selStrgCode=checkNull(rs.getString("STRG_CODE"));
				selBrandCode=checkNull(rs.getString("BRAND_CODE"));
				selStrgCodeMap.put(selStrgCode, selBrandCode);
				
				if( custBuff.length() == 0)
				{
					custBuff.append("'").append( selStrgCode ).append("'");
				}
				else
				{
					custBuff.append(",'").append( selStrgCode ).append("'");
				}
				selDoctors=custBuff.toString();
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("selDoctors::"+selDoctors);
			if( customers == "" || customers == null)
			{
				customers = "'x'";
			}
			System.out.println("SQL First Query pk");
			/* commented by prachi
			doctorsql = " SELECT A.STRG_CODE AS STRG_CODE,A.SC_NAME AS SC_NAME,A.QUALIFICATION AS QUALIFICATION,A.Speciality  AS Speciality,A.LOCALITY As LOCALITY,A.DESCR AS DESCR,"   +
					    " A.CLASS_CODE AS CLASS_CODE,A.STATE AS STATE,A.RX_CNT AS RX_CNT FROM" +
					    " (SELECT STRG.STRG_CODE AS STRG_CODE,UPPER(SC.FIRST_NAME)||' ' ||UPPER(SC.MIDDLE_NAME)||' ' ||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY," +
					    " SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID,SR.DESCR,SC.CLASS_CODE,S.DESCR AS STATE, FN_GET_RX_COUNT_CAMPAIGNWISE(STRG.STRG_CODE,SP.CAMPGN_ID,SP.SALES_PERS,STRG.BRAND_CODE,'"+presctranId+"') AS RX_CNT,ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO" +
					    " FROM SPRS_CAMPGN_STRG STRG,SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE, LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE"+
					    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE =STRG.STRG_CODE AND L.LOCALITY_CODE = SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
					    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y' AND SP.TRAN_ID = ? AND SP.CAMPGN_ID = ? AND SP.TRAN_TYPE ='D' AND SP.SALES_PERS = ? AND STRG.STRG_CODE NOT IN("+customers+"))A WHERE A.ROWNO=1 " +
					    " UNION" +
					    " SELECT B.STRG_CODE AS STRG_CODE, B.SC_NAME AS SC_NAME,B.QUALIFICATION AS QUALIFICATION, B.SPECIALITY AS SPECIALITY,B.LOCALITY AS LOCALITY,B.DESCR AS DESCR,B.CLASS_CODE AS CLASS_CODE," +
					    " B.STATE AS STATE, B.RX_CNT AS RX_CNT FROM" +
					    " (SELECT DISTINCT(STRG.STRG_CODE), UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY,SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID," +
					    " SR.DESCR, SC.CLASS_CODE, S.DESCR  AS STATE,FN_GET_RX_COUNT_CAMPAIGNWISE(STRG.STRG_CODE,SP.CAMPGN_ID,SP.SALES_PERS,STRG.BRAND_CODE,'"+presctranId+"') AS RX_CNT,ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO FROM SPRS_CAMPGN_STRG STRG," +
					    " SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE,LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE" +
					    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE  =STRG.STRG_CODE AND L.LOCALITY_CODE =SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
					    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y' AND SP.TRAN_ID = ? AND SP.CAMPGN_ID = ? AND SP.TRAN_TYPE ='P' AND SP.SALES_PERS = ? AND STRG.STRG_CODE NOT IN("+customers+"))B  WHERE B.ROWNO=1 ORDER BY SC_NAME" ;
			*/
			doctorsql = " SELECT A.STRG_CODE AS STRG_CODE,A.SC_NAME AS SC_NAME,A.QUALIFICATION AS QUALIFICATION,A.Speciality  AS Speciality,A.CATEGORY AS CATEGORY,A.LOCALITY As LOCALITY,A.DESCR AS DESCR,"   +
				    " A.CLASS_CODE AS CLASS_CODE,A.STATE AS STATE,A.RX_CNT AS RX_CNT FROM" +
				    " (SELECT STRG.STRG_CODE AS STRG_CODE,UPPER(SC.FIRST_NAME)||' ' ||UPPER(SC.MIDDLE_NAME)||' ' ||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY,SS.CATEGORY AS CATEGORY," +
				    " SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID,SR.DESCR,SC.CLASS_CODE,S.DESCR AS STATE, FN_GET_RX_COUNT_CAMPAIGNWISE(STRG.STRG_CODE,SP.CAMPGN_ID,SP.SALES_PERS,STRG.BRAND_CODE,'"+presctranId+"') AS RX_CNT,ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO" +
				    " FROM SPRS_CAMPGN_STRG STRG,SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE, LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE"+
				    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE =STRG.STRG_CODE AND L.LOCALITY_CODE = SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
				    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y' AND SP.TRAN_ID = ? AND SP.CAMPGN_ID = ? AND SP.TRAN_TYPE ='D' AND SP.SALES_PERS = ? AND STRG.STRG_CODE NOT IN("+customers+"))A WHERE A.ROWNO=1 " +
				    " UNION" +
				    " SELECT B.STRG_CODE AS STRG_CODE, B.SC_NAME AS SC_NAME,B.QUALIFICATION AS QUALIFICATION, B.SPECIALITY AS SPECIALITY,B.CATEGORY AS CATEGORY,B.LOCALITY AS LOCALITY,B.DESCR AS DESCR,B.CLASS_CODE AS CLASS_CODE," +
				    " B.STATE AS STATE, B.RX_CNT AS RX_CNT FROM" +
				    " (SELECT DISTINCT(STRG.STRG_CODE), UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY,SS.CATEGORY AS CATEGORY,SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID," +
				    " SR.DESCR, SC.CLASS_CODE, S.DESCR  AS STATE,FN_GET_RX_COUNT_CAMPAIGNWISE(STRG.STRG_CODE,SP.CAMPGN_ID,SP.SALES_PERS,STRG.BRAND_CODE,'"+presctranId+"') AS RX_CNT,ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO FROM SPRS_CAMPGN_STRG STRG," +
				    " SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE,LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE" +
				    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE  =STRG.STRG_CODE AND L.LOCALITY_CODE =SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
				    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y' AND SP.TRAN_ID = ? AND SP.CAMPGN_ID = ? AND SP.TRAN_TYPE ='P' AND SP.SALES_PERS = ? AND STRG.STRG_CODE NOT IN("+customers+"))B  WHERE B.ROWNO=1 ORDER BY SC_NAME" ;
		

			pstmt =  conn.prepareStatement( doctorsql );
			pstmt.setString(1, doctorTranId);
			pstmt.setString(2, campgnID);
			pstmt.setString(3, salesPers);
			pstmt.setString(4, presctranId);
			pstmt.setString(5, campgnID);
			pstmt.setString(6, salesPers);
			rs = pstmt.executeQuery();
			
			
			while(rs.next())
			{
				strgCode = checkNull(rs.getString("STRG_CODE")) ;
				doctorName = checkNull(rs.getString("SC_NAME")) ;
				localityCode = checkNull(rs.getString("LOCALITY")) ;
				localityDescr = checkNull(rs.getString("DESCR")) ;
				speciality = checkNull(rs.getString("SPECIALITY")) ;
				qualification = checkNull(rs.getString("QUALIFICATION")) ;
				classCode = checkNull(rs.getString("CLASS_CODE")) ;
				stateDesc = checkNull(rs.getString("STATE")) ;
				rxCnt = checkNull(rs.getString("RX_CNT")) ;
				
				//ADDED BY PRACHI ON 8TH MARCH 22
				category =checkNull(rs.getString("CATEGORY")) ;
				
				if(selStrgCodeMap != null &&  selStrgCodeMap.containsKey(strgCode))
				{
					brandCode = (String)selStrgCodeMap.get(strgCode);
					brandDescr = getBrandDescr(brandCode);
					valueXmlString.append( "<Detail"+currentFormNo+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
					valueXmlString.append("<cust_name><![CDATA[").append(doctorName).append("]]></cust_name>\r\n");
					valueXmlString.append("<line_no><![CDATA[").append(lineNum).append("]]></line_no>\r\n");
					valueXmlString.append("<locality_code><![CDATA[").append(localityCode).append("]]></locality_code>\r\n");
					valueXmlString.append("<locality_descr><![CDATA[").append(localityDescr).append("]]></locality_descr>\r\n");
					valueXmlString.append("<speciality><![CDATA[").append(speciality).append("]]></speciality>\r\n");
					valueXmlString.append("<qualification><![CDATA[").append(qualification).append("]]></qualification>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append("").append("]]></tran_id>\r\n");
					valueXmlString.append( "<brand_code><![CDATA[").append(brandCode).append("]]></brand_code>\r\n");
					valueXmlString.append( "<description><![CDATA[").append(brandDescr).append("]]></description>\r\n");
					valueXmlString.append( "<class_code><![CDATA[").append(classCode).append("]]></class_code>\r\n");
					valueXmlString.append( "<state_descr><![CDATA[").append(stateDesc).append("]]></state_descr>\r\n");
					valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
					valueXmlString.append( "<item_form_no><![CDATA[").append(brandItem).append("]]></item_form_no>\r\n");
					valueXmlString.append( "<rx_cnt><![CDATA[").append(rxCnt).append("]]></rx_cnt>\r\n");
					valueXmlString.append( "<emp_code><![CDATA[").append(salesPers).append("]]></emp_code>\r\n");
					valueXmlString.append( "<campgn_id><![CDATA[").append(campgnID).append("]]></campgn_id>\r\n");
					valueXmlString.append( "<category><![CDATA[").append(category).append("]]></category>\r\n");
					valueXmlString.append("</Detail"+currentFormNo+">\r\n");
					domID++;
					lineNum++;
				}
				
			}
			
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			if( selDoctors == "" || selDoctors == null)
			{
				selDoctors = "'x'";
			}
			 System.out.println("brandDescr first form["+brandDescr+"]");
			 System.out.println("SQL First Query pk");
/*
			doctorsql = " SELECT A.STRG_CODE AS STRG_CODE,A.SC_NAME AS SC_NAME,A.QUALIFICATION AS QUALIFICATION,A.Speciality  AS Speciality,A.BRAND_CODE AS BRAND_CODE ,A.LOCALITY As LOCALITY,A.DESCR AS DESCR,"   +
				    " A.CLASS_CODE AS CLASS_CODE,A.STATE AS STATE,A.RX_CNT AS RX_CNT FROM" +
				    " (SELECT STRG.STRG_CODE AS STRG_CODE,UPPER(SC.FIRST_NAME)||' ' ||UPPER(SC.MIDDLE_NAME)||' ' ||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY,STRG.BRAND_CODE, " +
				    " SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID,SR.DESCR,SC.CLASS_CODE,S.DESCR AS STATE, FN_GET_RX_COUNT_CAMPAIGNWISE(STRG.STRG_CODE,SP.CAMPGN_ID,SP.SALES_PERS,STRG.BRAND_CODE,'"+presctranId+"' ) AS RX_CNT,ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO" +
				    " FROM SPRS_CAMPGN_STRG STRG,SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE, LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE"+
				    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE =STRG.STRG_CODE AND L.LOCALITY_CODE = SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
				    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y' AND SP.TRAN_ID = ? AND SP.CAMPGN_ID = ? AND SP.TRAN_TYPE ='D' AND SP.SALES_PERS = ? AND STRG.STRG_CODE NOT IN("+selDoctors+"))A WHERE A.ROWNO=1 " +
				    " UNION" +
				    " SELECT B.STRG_CODE AS STRG_CODE, B.SC_NAME AS SC_NAME,B.QUALIFICATION AS QUALIFICATION, B.SPECIALITY AS SPECIALITY,B.BRAND_CODE AS BRAND_CODE,B.LOCALITY AS LOCALITY,B.DESCR AS DESCR,B.CLASS_CODE AS CLASS_CODE," +
				    " B.STATE AS STATE, B.RX_CNT AS RX_CNT FROM" +
				    " (SELECT DISTINCT(STRG.STRG_CODE), UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY,STRG.BRAND_CODE,SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID," +
				    " SR.DESCR, SC.CLASS_CODE, S.DESCR  AS STATE,FN_GET_RX_COUNT_CAMPAIGNWISE(STRG.STRG_CODE,SP.CAMPGN_ID,SP.SALES_PERS,STRG.BRAND_CODE,'"+presctranId+"') AS RX_CNT,ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO FROM SPRS_CAMPGN_STRG STRG," +
				    " SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE,LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE" +
				    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE  =STRG.STRG_CODE AND L.LOCALITY_CODE =SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
				    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y' AND SP.TRAN_ID = ? AND SP.CAMPGN_ID = ? AND SP.TRAN_TYPE ='P' AND SP.SALES_PERS = ? AND STRG.STRG_CODE NOT IN("+selDoctors+"))B  WHERE B.ROWNO=1 ORDER BY SC_NAME" ;
	*/
			 doctorsql = " SELECT A.STRG_CODE AS STRG_CODE,A.SC_NAME AS SC_NAME,A.QUALIFICATION AS QUALIFICATION,A.Speciality  AS Speciality,A.CATEGORY AS CATEGORY,A.BRAND_CODE AS BRAND_CODE ,A.LOCALITY As LOCALITY,A.DESCR AS DESCR,"   +
					    " A.CLASS_CODE AS CLASS_CODE,A.STATE AS STATE,A.RX_CNT AS RX_CNT FROM" +
					    " (SELECT STRG.STRG_CODE AS STRG_CODE,UPPER(SC.FIRST_NAME)||' ' ||UPPER(SC.MIDDLE_NAME)||' ' ||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY,SS.CATEGORY AS CATEGORY,STRG.BRAND_CODE, " +
					    " SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID,SR.DESCR,SC.CLASS_CODE,S.DESCR AS STATE, FN_GET_RX_COUNT_CAMPAIGNWISE(STRG.STRG_CODE,SP.CAMPGN_ID,SP.SALES_PERS,STRG.BRAND_CODE,'"+presctranId+"' ) AS RX_CNT,ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO" +
					    " FROM SPRS_CAMPGN_STRG STRG,SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE, LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE"+
					    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE =STRG.STRG_CODE AND L.LOCALITY_CODE = SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
					    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y' AND SP.TRAN_ID = ? AND SP.CAMPGN_ID = ? AND SP.TRAN_TYPE ='D' AND SP.SALES_PERS = ? AND STRG.STRG_CODE NOT IN("+selDoctors+"))A WHERE A.ROWNO=1 " +
					    " UNION" +
					    " SELECT B.STRG_CODE AS STRG_CODE, B.SC_NAME AS SC_NAME,B.QUALIFICATION AS QUALIFICATION, B.SPECIALITY AS SPECIALITY,B.CATEGORY AS CATEGORY,B.BRAND_CODE AS BRAND_CODE,B.LOCALITY AS LOCALITY,B.DESCR AS DESCR,B.CLASS_CODE AS CLASS_CODE," +
					    " B.STATE AS STATE, B.RX_CNT AS RX_CNT FROM" +
					    " (SELECT DISTINCT(STRG.STRG_CODE), UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY,SS.CATEGORY AS CATEGORY,STRG.BRAND_CODE,SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID," +
					    " SR.DESCR, SC.CLASS_CODE, S.DESCR  AS STATE,FN_GET_RX_COUNT_CAMPAIGNWISE(STRG.STRG_CODE,SP.CAMPGN_ID,SP.SALES_PERS,STRG.BRAND_CODE,'"+presctranId+"') AS RX_CNT,ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO FROM SPRS_CAMPGN_STRG STRG," +
					    " SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE,LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE" +
					    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE  =STRG.STRG_CODE AND L.LOCALITY_CODE =SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
					    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y' AND SP.TRAN_ID = ? AND SP.CAMPGN_ID = ? AND SP.TRAN_TYPE ='P' AND SP.SALES_PERS = ? AND STRG.STRG_CODE NOT IN("+selDoctors+"))B  WHERE B.ROWNO=1 ORDER BY SC_NAME" ;
			
				
				pstmt =  conn.prepareStatement( doctorsql );
				pstmt.setString(1, doctorTranId);
				pstmt.setString(2, campgnID);
				pstmt.setString(3, salesPers);
				pstmt.setString(4, presctranId);
				pstmt.setString(5, campgnID);
				pstmt.setString(6, salesPers);
				rs = pstmt.executeQuery();
				
				while(rs.next())
				{
					strgCode = checkNull(rs.getString("STRG_CODE")) ;
					doctorName = checkNull(rs.getString("SC_NAME")) ;
					localityCode = checkNull(rs.getString("LOCALITY")) ;
					localityDescr = checkNull(rs.getString("DESCR")) ;
					speciality = checkNull(rs.getString("SPECIALITY")) ;
					qualification = checkNull(rs.getString("QUALIFICATION")) ;
					classCode = checkNull(rs.getString("CLASS_CODE")) ;
					stateDesc = checkNull(rs.getString("STATE")) ;
					rxCnt = checkNull(rs.getString("RX_CNT")) ;
					brandCode=checkNull(rs.getString("BRAND_CODE")) ;
					brandDescr = getBrandDescr(brandCode);
					category=checkNull(rs.getString("CATEGORY")) ;

					valueXmlString.append( "<Detail"+currentFormNo+" domID='"+domID+"' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
					valueXmlString.append("<cust_name><![CDATA[").append(doctorName).append("]]></cust_name>\r\n");
					valueXmlString.append("<line_no><![CDATA[").append(lineNum).append("]]></line_no>\r\n");
					valueXmlString.append("<locality_code><![CDATA[").append(localityCode).append("]]></locality_code>\r\n");
					valueXmlString.append("<locality_descr><![CDATA[").append(localityDescr).append("]]></locality_descr>\r\n");
					valueXmlString.append("<speciality><![CDATA[").append(speciality).append("]]></speciality>\r\n");
					valueXmlString.append("<qualification><![CDATA[").append(qualification).append("]]></qualification>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append("").append("]]></tran_id>\r\n");
					valueXmlString.append( "<brand_code><![CDATA[").append(brandCode).append("]]></brand_code>\r\n");
					valueXmlString.append( "<description><![CDATA[").append(brandDescr).append("]]></description>\r\n");
					valueXmlString.append( "<class_code><![CDATA[").append(classCode).append("]]></class_code>\r\n");
					valueXmlString.append( "<state_descr><![CDATA[").append(stateDesc).append("]]></state_descr>\r\n");
					valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
					valueXmlString.append( "<item_form_no><![CDATA[").append(brandItem).append("]]></item_form_no>\r\n");
					valueXmlString.append( "<rx_cnt><![CDATA[").append(rxCnt).append("]]></rx_cnt>\r\n");
					valueXmlString.append( "<emp_code><![CDATA[").append(salesPers).append("]]></emp_code>\r\n");
					valueXmlString.append( "<campgn_id><![CDATA[").append(campgnID).append("]]></campgn_id>\r\n");
					valueXmlString.append( "<category><![CDATA[").append(category).append("]]></category>\r\n");
					valueXmlString.append("</Detail"+currentFormNo+">\r\n");
					domID++;
					lineNum++;
				}
				
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch (Exception e)
		{
			throw new ITMException(e);	
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("doctorform resultString+::["+valueXmlString.toString()+"]");
		return valueXmlString.toString();
	}
	
	
	public String getcampgnItemDetails( Document dom, Document dom2 , String salePersCode, String wrkDate , String strgCode, String brandCode,String campgnID, String xtraParams,String formName, Connection connectionObject,String editScCode,String formNo, String itemSer ) throws ITMException
	{
		System.out.println("getcampgnItemDetails::[]"+salePersCode+", "+strgCode+"["+brandCode+"]");
		String itemsSql="";
		String selecteditemCode="";
		String selItemCode="";
		String selStrgCode="";
		String tranId="";
		String seltranId = "";
		String tranIdSql="";
		String selRx="";
		String sellineNo = "";
		String multibrandCodes="";
		int maxLineNo=0;
		int currentFormNo = 0;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		HashMap itemMap = new HashMap();
		HashMap qtyMap = new HashMap();
		HashMap tranIDMap = new HashMap();
		StringBuffer valueXmlString  = new StringBuffer();
		StringBuffer selectedXmlString  = new StringBuffer();
		StringBuffer unselectedString  = new StringBuffer();
		boolean isLocalConn =false;
		try 
		{
			if(connectionObject == null )
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			if( formNo != null && formNo.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( formNo );
			}
			
			int domID = 1;
			
			 	DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
				Calendar calendar = Calendar.getInstance();
				String currentDate  = dtFormat.format(calendar.getTime());
				currentDate =  genericUtility.getValidDateString(currentDate,  genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
				System.out.println("currentDate => " + currentDate);
			
				int graceDays=0;

				String sql = "SELECT GRACE_DAYS FROM STRG_CAMPAIGN  WHERE CAMPGN_ID = ? ";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1, campgnID);
				rs = pstmt.executeQuery();
				if ( rs.next() )
				{
					graceDays = rs.getInt("GRACE_DAYS");

				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
				tranIdSql="select max(SC.tran_id)  as tran_id from SPRS_CAMPGN SC,SPRS_CAMPGN_STRG SCMPS,STRG_CAMPAIGN SCM "
						+ " where SC.tran_date  between SCM.EFF_FROM and SCM.VALID_UPTO+? and  SC.tran_date = ? AND SC.CAMPGN_ID=SCM.CAMPGN_ID "
						+ "and SC.sales_pers = ? and SC.tran_type= ? and SC.campgn_id=? AND SC.tran_id=SCMPS.tran_id AND SCMPS.BRAND_CODE=?";
				
            	
				pstmt =  connectionObject.prepareStatement(tranIdSql);
				pstmt.setInt(1, graceDays);
				pstmt.setDate(2,java.sql.Date.valueOf(currentDate));
				pstmt.setString(3, salePersCode);
	            pstmt.setString(4, "P");
	            pstmt.setString(5,campgnID);       
	            pstmt.setString(6,brandCode);
	            
				rs = pstmt.executeQuery();
				if (rs.next())                           
				{
					tranId=checkNull(rs.getString("tran_id"));
					System.out.println("tranId::"+tranId);
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				selecteditemCode=" SELECT ITEM_CODE,STRG_CODE,OUTCOME_NUM,LINE_NO,TRAN_ID FROM SPRS_CAMPGN_ITEMS WHERE TRAN_ID = ?";
				pstmt =  connectionObject.prepareStatement(selecteditemCode);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					selStrgCode=checkNull(rs.getString("STRG_CODE"));
					selItemCode=checkNull(rs.getString("ITEM_CODE"));
					sellineNo=checkNull(rs.getString("LINE_NO"));
					selRx=checkNull(rs.getString("OUTCOME_NUM"));
					seltranId=checkNull(rs.getString("TRAN_ID"));
					itemMap.put( selItemCode+"~"+selStrgCode, sellineNo);
					qtyMap.put( selItemCode+"~"+selStrgCode, selRx);
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
              
				
				
				if(tranId != null)
				{
					if(tranId.length()>0)
					{
						String maxLineSql = "SELECT MAX(CASE WHEN LINE_NO IS NULL THEN 1 ELSE LINE_NO END) AS MAX_LINE_NO FROM SPRS_CAMPGN_ITEMS WHERE TRAN_ID = ? AND STRG_CODE= ? ";
						pstmt = connectionObject.prepareStatement(maxLineSql);
						pstmt.setString(1,tranId);
						pstmt.setString(2,strgCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							maxLineNo = rs.getInt("MAX_LINE_NO");
							
						}
						
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
					}
				}
				
				multibrandCodes=E12GenericUtility.getFormattedProfileId(brandCode);
				System.out.println("multibrandCodes::"+multibrandCodes);
				itemsSql ="SELECT ITEM.ITEM_CODE,ITEM.DESCR,ITEM.BRAND_CODE FROM ITEM,BRAND WHERE ITEM.BRAND_CODE=BRAND.BRAND_CODE AND ITEM.ITEM_SER=BRAND.ITEM_SER AND" +
						 " BRAND.ITEM_SER= ? AND ITEM.BRAND_CODE IN "+multibrandCodes+" ORDER BY DESCR ";
				
				pstmt =  connectionObject.prepareStatement( itemsSql );
				pstmt.setString(1, itemSer );
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					String itemCode = checkNull(rs.getString("ITEM_CODE"));
					String itemDescr = checkNull(rs.getString("DESCR"));
					if ( itemMap.get( itemCode+"~"+strgCode ) != null )
					{
						selRx = ( String ) qtyMap.get( itemCode+"~"+strgCode );
						String data = ( String ) itemMap.get( itemCode+"~"+strgCode );
						
						selectedXmlString.append( "<Detail"+currentFormNo+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'>\r\n" );
						selectedXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
						selectedXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
						selectedXmlString.append("<tran_id><![CDATA[").append("").append("]]></tran_id>\r\n");
						selectedXmlString.append("<line_no><![CDATA[").append(data).append("]]></line_no>\r\n");
						selectedXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
						selectedXmlString.append("<item_code visible='0'><![CDATA[").append(itemCode).append("]]></item_code>\r\n");
						selectedXmlString.append("<outcome_num><![CDATA[").append(selRx).append("]]></outcome_num>\r\n");
						selectedXmlString.append("<item_descr><![CDATA[").append(itemDescr).append("]]></item_descr>\r\n");
						selectedXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
						selectedXmlString.append( "</Detail"+currentFormNo+">\r\n" );
						domID++;
						
					}
					else
					{
						maxLineNo = maxLineNo +1;
						unselectedString.append( "<Detail"+currentFormNo+" domID='"+maxLineNo+"' selected = 'N' formName='"+formName+"'>\r\n" );
						unselectedString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
						unselectedString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
						unselectedString.append("<line_no><![CDATA[").append(maxLineNo).append("]]></line_no>\r\n");
						unselectedString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
						unselectedString.append("<item_code visible='0'><![CDATA[").append(itemCode).append("]]></item_code>\r\n");
						unselectedString.append("<outcome_num><![CDATA[").append("").append("]]></outcome_num>\r\n");
						unselectedString.append("<item_descr><![CDATA[").append(itemDescr).append("]]></item_descr>\r\n");
						unselectedString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
						unselectedString.append( "</Detail"+currentFormNo+">\r\n" );
						//domID++;
					}
				
				}
				
				valueXmlString.append(selectedXmlString);
				valueXmlString.append(unselectedString);
				System.out.println("selectedXmlString[["+selectedXmlString.toString());
				System.out.println("unselectedString[["+unselectedString.toString());
				if(rs != null)
				{
					rs.close(); rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close(); pstmt = null;
				}
				domID++;
		}
		catch(Exception e)
		{
			throw new ITMException(e);	
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :getcampgnItemDetails(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	
	public String getExistingItemDetail( String salePersCode, String eventDate , String custList ,String campgnID,String brandCode,String formNo,String formName,Connection connectionObject) throws ITMException 
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		StringBuffer valueXmlString = new StringBuffer();
		boolean isLocalConn =false;
		
		String tranIdSql="";
		String tranId="";
		String selecteditemCode="";
		String selStrgCode="",selItemCode="";
		String item ="";
		int selRx=0;
		int domID=1;
		try
		{
			if(connectionObject ==null )
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
//				tranIdSql="select max(tran_id) as tran_id from SPRS_CAMPGN where tran_date =(select max(SP.tran_date) from SPRS_CAMPGN SP, STRG_CAMPAIGN ST where SP.CAMPGN_ID = ST.CAMPGN_ID and SP.tran_date between ST.eff_from and ST.valid_upto and SP.sales_pers =? ) and sales_pers = ? AND TRAN_TYPE='P' ";
			  
			 
	            DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
				Calendar calendar = Calendar.getInstance();
				String currentDate  = dtFormat.format(calendar.getTime());
				currentDate =  genericUtility.getValidDateString(currentDate,  genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
				System.out.println("currentDate => " + currentDate);
			
            	
				
				int graceDays=0;

				String sql = "SELECT GRACE_DAYS FROM STRG_CAMPAIGN  WHERE CAMPGN_ID = ? ";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1, campgnID);
				rs = pstmt.executeQuery();
				if ( rs.next() )
				{
					graceDays = rs.getInt("GRACE_DAYS");

				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
				tranIdSql="select max(SC.tran_id)  as tran_id from SPRS_CAMPGN SC,SPRS_CAMPGN_STRG SCMPS,STRG_CAMPAIGN SCM "
						+ " where SC.tran_date  between SCM.EFF_FROM and SCM.VALID_UPTO+? and  SC.tran_date = ? AND SC.CAMPGN_ID=SCM.CAMPGN_ID "
						+ "and SC.sales_pers = ? and SC.tran_type= ? and SC.campgn_id=? AND SC.tran_id=SCMPS.tran_id AND SCMPS.BRAND_CODE=?";
				
				pstmt =  connectionObject.prepareStatement(tranIdSql);
				pstmt.setInt(1, graceDays);
				pstmt.setDate(2,java.sql.Date.valueOf(currentDate));
				pstmt.setString(3, salePersCode);
	            pstmt.setString(4, "P");
	            pstmt.setString(5,campgnID);       
	            pstmt.setString(6,brandCode);
				
				rs = pstmt.executeQuery();
				if (rs.next())                           
				{
					tranId=checkNull(rs.getString("tran_id"));
					System.out.println("tranId val::"+tranId);
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				selecteditemCode = "SELECT CITEM.ITEM_CODE,CITEM.STRG_CODE,CITEM.OUTCOME_NUM,CITEM.TRAN_ID,CITEM.LINE_NO,ITEM.DESCR FROM SPRS_CAMPGN_ITEMS CITEM,ITEM " +
								   "WHERE TRAN_ID = ? AND CITEM.ITEM_CODE=ITEM.ITEM_CODE ORDER BY ITEM.DESCR ";
				pstmt =  connectionObject.prepareStatement(selecteditemCode);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					selStrgCode=checkNull(rs.getString("STRG_CODE"));
					selItemCode=checkNull(rs.getString("ITEM_CODE"));
					item = checkNull(rs.getString("DESCR"));
					selRx=rs.getInt("OUTCOME_NUM");
					
					valueXmlString.append( "<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<item_descr><![CDATA[").append(item).append("]]></item_descr>\r\n");
					valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
					valueXmlString.append("<item_code><![CDATA[").append(selItemCode).append("]]></item_code>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append(selStrgCode).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[").append(checkNull(rs.getString("LINE_NO"))).append("]]></line_no>\r\n");
					valueXmlString.append( "<tran_id><![CDATA[" ).append(checkNull(rs.getString("TRAN_ID"))).append( "]]></tran_id>\r\n" );
					valueXmlString.append( "<outcome_num><![CDATA[" ).append(selRx).append( "]]></outcome_num>\r\n" );
					valueXmlString.append( "</Detail"+formNo+">\r\n" );
					domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		System.out.println("getSalesExistingItemDetail valueXmlString:::["+valueXmlString+"]");
		return valueXmlString.toString();
	
	}
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	
	public String getObjNameFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				if( currDetail.getAttributes().getNamedItem(attribute) != null )
				{
					objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
					break;
				}
			}
			if( (objName == null || objName.trim().length() == 0) && currFormNo != 1 )
			{
				detailList = dom.getElementsByTagName("Detail1");
				detailListLength = detailList.getLength();
				for (int ctr = 0;ctr < detailListLength;ctr++)
				{
					currDetail = detailList.item(ctr);
					if( currDetail.getAttributes().getNamedItem(attribute) != null )
					{
						objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
						break;
					}
				}
			}
			if(objName == null || objName.trim().length() == 0)
			{
				NodeList objNameList = dom.getElementsByTagName("objName");
				if(objNameList != null && objNameList.getLength() > 0)
				{
					Node objNameNode = objNameList.item(0);
					if(objNameNode != null && objNameNode.getFirstChild() != null)
					{
						objName = checkNull(objNameNode.getFirstChild().getNodeValue());
					}
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception Inside getObjNameFromDom ::["+e.getMessage()+"]");
			e.printStackTrace();
		}
		return objName;
	}
	public boolean preDomExists(Document dom, String currentFormNo) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node childNode = null;
		boolean selected = false;

		try
		{
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			if ( parentList.item(0) != null )
			{
				childList = parentList.item(0).getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						System.out.println("Column found!!!" + childNode.getNodeName());
						selected = true;
						break;
					}
				}
			}


		}
		catch ( Exception e )
		{
			System.out.println( "Exception :SprsCampgnRxWiz :preDomExists :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		//System.out.println("preDomExists =["+selected+"] and currentFormNo =["+currentFormNo+"]");

		return selected;
	}
	public String getBrandDescr(String brandCode) throws ITMException 
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql="";
		String brandDescr="";
		String brandDescription="";
		Connection connectionObject=null;
		boolean isLocalConn=false;
		try 
		{
			if(connectionObject ==  null )
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			
			if(brandCode !=null && brandCode.trim().length()>0)
			{
				sql = " SELECT DESCRIPTION FROM BRAND WHERE BRAND_CODE in "+ E12GenericUtility.getFormattedProfileId(brandCode)+"";
				pstmt = connectionObject.prepareStatement(sql);
				rs = pstmt.executeQuery();
				
				if ( brandCode.indexOf(",")  != -1)
				{
					while (rs.next())
					{
						brandDescr = brandDescr + checkNull(rs.getString("DESCRIPTION")) + ",";
						brandDescr=	brandDescr.concat(" ");
						brandDescription = brandDescr.substring(0, brandDescr.length()-2);
					}
					
				}
				else
				{
					if (rs.next())
					{
						brandDescription = checkNull(rs.getString("DESCRIPTION"));
					}
				}
				
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); 
		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return brandDescription;
	}
	
	public String getCustFromDom( Document dom, String currentForm, String salesPerson,String attrValue, Connection connectionObject ) throws ITMException
	{
		StringBuffer custBuff = new StringBuffer();
		boolean isLocalConn =false;
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		ArrayList temp = new ArrayList(100);
		String sqlTranId="";
		String prescriptnTranId="";
		String columnValue = "";
		String sql="";
		try
		{
			if(connectionObject == null )
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			
			int graceDays=0;


			
			sqlTranId="select max(tran_id) as tran_id from SPRS_CAMPGN where tran_date =(select max(a.tran_date) from SPRS_CAMPGN a, STRG_CAMPAIGN b where a.CAMPGN_ID = b.CAMPGN_ID " +
					  "and a.tran_date between b.eff_from and b.valid_upto+b.grace_days and a.sales_pers =? and a.tran_type='P' ) and sales_pers = ? and tran_type='P' ";
			pstmt =  connectionObject.prepareStatement(sqlTranId);
			pstmt.setString(1, salesPerson);
			pstmt.setString(2, salesPerson);
			rs = pstmt.executeQuery();
			if (rs.next())                           
			{
				prescriptnTranId=checkNull(rs.getString("tran_id"));
				
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			
			sql="SELECT STRG_CODE, BRAND_CODE FROM SPRS_CAMPGN_STRG WHERE TRAN_ID =?";
			pstmt =  connectionObject.prepareStatement(sql);
			
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("strg_code") )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
						System.out.println("columnValue["+columnValue+"]");
						if( parentNode.getAttributes().getNamedItem("selected").getNodeValue().equalsIgnoreCase(attrValue))
						{
							if( temp.contains(columnValue) )
							{

								continue;
							}
							pstmt.setString(1, prescriptnTranId);
							rs = pstmt.executeQuery();
							
							if( custBuff.length() == 0)
							{
								custBuff.append("'").append( columnValue ).append("'");
							}
							else
							{
								custBuff.append(",'").append( columnValue ).append("'");
							}
							
							temp.add( columnValue );
						}
					}
				}
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			temp.clear();
			//System.out.println("custBuff["+custBuff+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (isLocalConn &&  connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return custBuff.toString();
	}
	public String getSelectedYesRowValue(Document dom,String formNo, String colName, int rowNo) throws ITMException
	{
		NodeList detailList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		int	detailListLength = 0;
		int noOfChilds = 0;
		try
		{
			detailList = dom.getElementsByTagName("Detail"+formNo);
			detailListLength = detailList.getLength();
			if(detailListLength > 0)
			{
				parentNode = detailList.item(rowNo);
				elementAttr = (Element)parentNode;
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				if ( parentNode != null )
				{
					String selectedFlag = "";
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						childNodeName = childNode.getNodeName();

						if(childNode.getNodeName().equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("selected") != null)
							{

								selectedFlag = childNode.getAttributes().getNamedItem("selected").getNodeValue();
							}
						}
						else if(!childNode.getNodeName().equalsIgnoreCase("attribute") && childNode.getNodeName().equalsIgnoreCase("ORIG_ATTRIBUTE_NODE"))
						{
							String nodeValue = childNode.getFirstChild().getNodeValue();
							if(nodeValue.contains(" selected=\"Y\""))
							{
								selectedFlag="Y";
							}
						}
						if(childNodeName.equals(colName) && "Y".equalsIgnoreCase(selectedFlag))
						{
							if(childNode.getFirstChild()!=null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
								break;
							}
						}
					}
				}
			}

			if(columnValue == null)
				columnValue = "";

		}
		catch( Exception exp )
		{
			exp.printStackTrace();
			throw new ITMException(exp);
		}
		return columnValue;
	}
	public String getFormNo(String objName, String formName, Connection connectionObject) throws ITMException
	{
		Statement stmt = null;
		ResultSet rs = null;
		String formNo = "";
		try
		{
			String sql = "SELECT FORM_NO FROM OBJ_FORMS WHERE WIN_NAME = '"+"w_"+objName+"'AND FORM_NAME = '"+formName+"'";
			stmt = connectionObject.createStatement();
			rs = stmt.executeQuery(sql);
			if( rs.next() )
			{
				formNo = checkNull(rs.getString("FORM_NO"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( stmt !=null )
			{
				stmt.close();
				stmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); 
		}
		return formNo;
	}
	public String getParentformNo(String subFormNo, String objName, Connection conn) throws ITMException
	{
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		int subFormNum = 0;
		String formNumber = "";
		String formType = "";
		boolean isMainForm = false;
		try
		{
			String winName = "w_"+objName;
			if(conn == null)
			{
				conn = getConnection();
			}
			if( subFormNo != null && subFormNo.trim().length() > 0 )
			{
				subFormNum = Integer.parseInt( subFormNo );
			}
			String sql  = "SELECT FORM_NO,FORM_TYPE FROM OBJ_FORMS WHERE WIN_NAME = ? AND TO_NUMBER(FORM_NO) = ? ";
			pStmt = conn.prepareStatement(sql);

			for(int j = subFormNum; j>=1; j--)
			{
				pStmt.setString(1, winName);
				pStmt.setString(2, ""+j);

				rs = pStmt.executeQuery();
				if(rs.next())
				{
					formNumber = checkNull(rs.getString("FORM_NO"));
					formType = checkNull(rs.getString("FORM_TYPE"));
					if(formType.indexOf("MP")>=0)
					{
						isMainForm = true;
					}
				}
				pStmt.clearParameters();
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(isMainForm)
				{
					break;
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); 

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pStmt !=null )
				{
					pStmt.close();
					pStmt = null;
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return formNumber;
	}
	public String getSelectedRowValue(Document dom,String formNo, String colName, int rowNo) throws ITMException
	{
		NodeList detailList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		int	detailListLength = 0;
		int noOfChilds = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+formNo);
			detailListLength = detailList.getLength();
			parentNode = detailList.item(rowNo);
			elementAttr = (Element)parentNode;
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();

			if ( parentNode != null )
			{
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(colName) )
					{
						if(childNode.getFirstChild()!=null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
							break;
						}
					}
				}
			}
			if(columnValue == null)
				columnValue = "";

		}
		catch( Exception exp )
		{
			exp.printStackTrace();
		}
		return columnValue;
	}
	
	public String getPrevFormVal( Document dom, String currentFormNo, ArrayList temp, String colName ) throws ITMException
	{
		GenericUtility genericUtility = GenericUtility.getInstance();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		int domID=1;
		try
		{
			chgPreDom = genericUtility.parseString("<Root/>");
			System.out.println("currentFormNo ["+currentFormNo+"] \n dom["+genericUtility.serializeDom(dom)+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains(columnValue))
						{
							elementAttr = (Element)parentNode;

							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								elementAttr.setAttribute( "selected" , "Y" );
								domID++;
							}
							Node importedNode = chgPreDom.importNode( parentNode, true );
							chgPreDom.getDocumentElement().appendChild( importedNode );
							break;
						}

					}
				}

			}
			if(currentFormNo.equals("1"))
			{
				domID = 1;
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :getPrevFormValues :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;

	}
	
}