/********************************************************
	Title : SpgrpTarget
	Date  : 18/11/10
	Author: Dhiraj Chaudhari

********************************************************/

package ibase.webitm.ejb.wsfa.masters;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
//import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import org.w3c.dom.*;
import ibase.webitm.ejb.*;
import java.sql.Timestamp;

//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].

public class SpgrpTarget extends ValidatorEJB implements SpgrpTargetRemote,SpgrpTargetLocal
{
	java.sql.Date copyDate;

	public String wfValData()throws RemoteException, ITMException
	{
	return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();

		System.out.println("===>\n****xmlString****\n["+xmlString+"]\n****xmlString1****\n["+xmlString1+"]***xmlString2***\n["+xmlString2+"]");

		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			System.out.println("===>****,==== \n****dom****\n["+dom+"]\n****dom1****\n["+dom1+"]***dom2***\n["+dom2+"]");
			errString = wfValData( dom, dom1, dom2, objContext, editFlag, xtraParams );
			System.out.println("[SpgrpTarget][wfValData][ErrString:] " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: SpgrpTarget: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from SpgrpTarget wfValData");
		return errString;
	}

	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{

		int ctr = 0;
		int currentFormNo = 0;
		int childNodeListLength = 0;
		int cnt = 0;
		int val = 0;

		String loginSite = "";
		String userId = "";
		String childNodeName = "";
		String childNodeValue = "";
		String errString = "";
		String errCode = "";
		String sql = "";
		String itemSer = "";
		String stateCode = "";
		String salesProdGrp = "";
		String stanCode = "";
		String effDateStr = "";
		String valUptoDateStr = "" ;
		Connection conn = null;
		//Statement stmt = null;//Commented By Shahu Mali on 04-10-13
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Node parentNode = null;
		Node childNode = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		SimpleDateFormat sdfAppl = null ;

		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{
			sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverValidator" );
			connDriver = null;*/
			conn = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
			//stmt = conn.createStatement();////Commented By Shahu Mali on 04-10-13
			userId = getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNode.getFirstChild() != null)
					{
						childNodeValue = childNode.getFirstChild().getNodeValue();
					}
					System.out.println("****childNodeName["+childNodeName+"]nodeValue["+childNodeValue+"]****");
					if( "item_ser".equalsIgnoreCase( childNodeName ) )
					{
						if( childNode.getFirstChild() == null || childNodeValue == null || childNodeValue.trim().length() == 0)
						{
							errString =itmDBAccessEJB.getErrorString( "item_ser", "ITMSERNUL", userId );
							break ;
						}
						else
						{
							itemSer = childNodeValue;
							sql = "SELECT COUNT(*) FROM ITEMSER WHERE ITEM_SER = ?";
							pstmt= conn.prepareStatement(sql);
							pstmt.setString(1,itemSer);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
							   cnt = rs.getInt(1);
							}
							if (rs!=null)
							{
								rs.close();
								rs = null ;
							}
							if (pstmt!=null)
							{
								pstmt.close();
								pstmt = null ;
							}
							if(cnt == 0)
							{
								errCode = "INVITEMSER";
								errString = getErrorString("item_ser",errCode,userId);
								break;
							}
						}
					}
					else if( "state_code".equalsIgnoreCase( childNodeName ) )
					{
						if( childNode.getFirstChild() == null || childNodeValue == null || childNodeValue.trim().length() == 0)
						{
							errString =itmDBAccessEJB.getErrorString( "state_code", "STATENULL", userId );
							break ;
						}
						else
						{
							stateCode = childNodeValue;
							sql = "SELECT COUNT(*) FROM STATE WHERE STATE_CODE =?";
							pstmt= conn.prepareStatement(sql);
							pstmt.setString(1,stateCode) ;
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							if (rs!=null)
							{
								rs.close();
								rs = null ;
							}
							if (pstmt!=null)
							{
								pstmt.close();
								pstmt = null ;
							}
							if(cnt == 0)
							{
								errCode = "INVSTATCOD";
								errString = getErrorString("state_code",errCode,userId);
								break;
							}
						}
					}
					else if( "stan_code".equalsIgnoreCase( childNodeName ) )
					{
						if( childNode.getFirstChild() == null || childNodeValue == null || childNodeValue.trim().length() == 0)
						{
							errString =itmDBAccessEJB.getErrorString( "stan_code", "STANNULL", userId );
							break ;
						}
						else
						{
							stanCode = childNodeValue;
							sql = "SELECT COUNT(*) FROM STATION WHERE STAN_CODE =?";
							pstmt= conn.prepareStatement(sql);
							pstmt.setString(1,childNodeValue) ;
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							if (rs!=null)
							{
								rs.close();
								rs = null ;
							}
							if (pstmt!=null)
							{
								pstmt.close();
								pstmt = null ;
							}
							if(cnt == 0)
							{
								errCode = "INVSTANCOD";
								errString = getErrorString("stan_code",errCode,userId);
								break;
							}
						}
					}
					else if( "sales_prod_grp".equalsIgnoreCase( childNodeName ) )
					{
						if( childNode.getFirstChild() == null || childNodeValue == null || childNodeValue.trim().length() == 0)
						{
							errString =itmDBAccessEJB.getErrorString( "sales_prod_grp", "SALESPNUL", userId );
							break ;
						}
						else
						{   salesProdGrp = childNodeValue;
							sql = "SELECT COUNT(*) FROM SALES_PROD_GRP WHERE SALES_PROD_GRP =?";
							pstmt= conn.prepareStatement(sql);
							pstmt.setString(1,salesProdGrp) ;
							rs = pstmt.executeQuery();

							if(rs.next())
							{
							   cnt = rs.getInt(1);
							}
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							if (rs!=null)
							{
								rs.close();
								rs = null ;
							}
							if (pstmt!=null)
							{
								pstmt.close();
								pstmt = null ;
							}
							if(cnt == 0)
							{
								errCode = "INVSALESPG";
								errString = getErrorString("sales_prod_grp",errCode,userId);
								break;
							}
						}
					}
					else if( "eff_date".equalsIgnoreCase( childNodeName ) )
					{
						if( childNode.getFirstChild() == null || childNodeValue == null || childNodeValue.trim().length() == 0)
						{
							errString =itmDBAccessEJB.getErrorString( "eff_date", "EFFDATENU", userId );
							break ;
						}
						effDateStr = childNodeValue;
					}
					else if( "valid_upto".equalsIgnoreCase( childNodeName ) )
					{
						try
						{
							if( childNode.getFirstChild() == null || childNodeValue == null || childNodeValue.trim().length() == 0 )
							{
								errString =itmDBAccessEJB.getErrorString( "valid_upto", "VALIDUPNU", userId );
								break ;
							}
							else
							{
								java.util.Date validUptoDate = sdfAppl.parse(childNodeValue);
								java.util.Date effDate = sdfAppl.parse(effDateStr);
								if (effDate!=null && (!effDate.before(validUptoDate)))
								{
									errString =itmDBAccessEJB.getErrorString( "valid_upto", "VALIDUPBI", userId );
									break ;
								}
								valUptoDateStr = childNodeValue;
							}
						}
						catch (Exception ex)
						{
							ex.printStackTrace();
						}
					}
				}
				if (errString == null && errString.trim().length() == 0 && editFlag != null && editFlag.equalsIgnoreCase("A"))
				{
					sql = "SELECT COUNT(*) AS CNT FROM SPGRP_TARGET WHERE ITEM_SER = ? AND STATE_CODE = ? AND STAN_CODE  = ? AND SALES_PROD_GRP = ? AND EFF_DATE = ? AND VALID_UPTO = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,itemSer);
					pstmt.setString(2,stateCode);
					pstmt.setString(3,stanCode);
					pstmt.setString(4,salesProdGrp);
					System.out.println("In Add mode validation=====>\nitemSer["+itemSer+"]stateCode["+stateCode+"]stanCode["+stanCode+"]salesProdGrp["+salesProdGrp+"]effDateStr["+effDateStr+"]valUptoDateStr["+valUptoDateStr+"]");
					pstmt.setTimestamp(5,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(effDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
					pstmt.setTimestamp(6,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(valUptoDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
					rs = pstmt.executeQuery();
					cnt = rs.next() ? rs.getInt("CNT"): -1;
					if (rs!=null)
					{
						rs.close();
						rs = null ;
					}
					if (pstmt!=null)
					{
						pstmt.close();
						pstmt = null ;
					}
					if (cnt > 0)
					{
						errString =itmDBAccessEJB.getErrorString( "", "ENTRYEXIST", userId );
						break ;
					}
				}
				break;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception  : SpgrpTarget : wfValData :");
			e.printStackTrace();
			errString=e.getMessage();
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		finally
		{
			try
			{

				if (rs!=null)
				{
					rs.close();
					rs = null ;
				}
				if (pstmt!=null)
				{
					pstmt.close();
					pstmt = null ;
				}
				if (conn!= null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}
		}
		System.out.println("ErrString ::"+errString);
		return errString;
	}
	public String itemChanged()throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{
			dom = parseString(xmlString);
			System.out.println("xmlString" + xmlString);
			dom1 = parseString(xmlString1);
			if(xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [WsfaEffCovgEJB][itemChanged(String,String)] :==>\n"+e.getMessage());
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		int ctr=0 ;
		int k=0;
		int childNodeListLength=0;
		String columnValue = "";
		String childNodeName = "";
		String sql = "";
		String loginSite="";
		String query ="";
		StringBuffer valueXmlString = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn = null;
		//Statement stmt = null;//Commented By Shahu Mali on 04-10-13
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{
			/*ConnDriver conndriver = new ConnDriver();
			conn = conndriver.getConnectDB("DriverValidator");
			conndriver = null;*/
			conn = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			if(objContext != null && objContext.trim().length() > 0)
			k = Integer.parseInt(objContext);
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			switch(k)
			{
				case 1 :
				valueXmlString.append("<Detail1>");
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				childNodeListLength = childNodeList.getLength();
				for (ctr = 0 ; ctr < childNodeListLength  && !childNodeName.equals(currentColumn) ; ctr++ )
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(currentColumn) && childNode.getFirstChild() != null)
					{
						columnValue=childNode.getFirstChild().getNodeValue().trim();
					}

					if(currentColumn.trim().equalsIgnoreCase("item_ser"))
					{
						String itemSer = checkNull(genericUtility.getColumnValue("item_ser", dom));
						if(itemSer != null)
						{
							query =" SELECT DESCR FROM ITEMSER  WHERE ITEM_SER = ? " ;
							pstmt = conn.prepareStatement(query);
							pstmt.setString(1, itemSer);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								valueXmlString.append("<itemser_descr>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</itemser_descr>");
							}
							else
							{
								valueXmlString.append("<itemser_descr>").append("<![CDATA[]]>").append("</itemser_descr>");
							}
						}
					}
					else if (currentColumn.trim().equalsIgnoreCase("state_code"))
					{
						String stateCode = checkNull(genericUtility.getColumnValue("state_code", dom));
						if(stateCode != null)
						{
							query =" SELECT DESCR FROM STATE  WHERE STATE_CODE = ? " ;
							pstmt = conn.prepareStatement(query);
							pstmt.setString(1, stateCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								valueXmlString.append("<state_descr>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</state_descr>");
							}
							else
							{
								valueXmlString.append("<state_descr>").append("<![CDATA[]]>").append("</state_descr>");
							}
						}
					}
					else if (currentColumn.trim().equalsIgnoreCase("stan_code"))
					{
						String stanCode = checkNull(genericUtility.getColumnValue("stan_code", dom));
						if(stanCode != null)
						{
							//Commented and changes done by Gaurav Singh on 09-12-14
							//query =" SELECT DESCR FROM STATION  WHERE STAN_CODE = ? " ;
							query =" SELECT SN.DESCR,ST.ZONE FROM STATION SN, STATE ST WHERE SN.STATE_CODE = ST.STATE_CODE AND SN.STAN_CODE = ?";
							pstmt = conn.prepareStatement(query);
							pstmt.setString(1, stanCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								valueXmlString.append("<station_descr>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</station_descr>");
								valueXmlString.append("<state_zone>").append("<![CDATA[" + rs.getString("ZONE") + "]]>").append("</state_zone>");
							}
							else
							{
								valueXmlString.append("<station_descr>").append("<![CDATA[]]>").append("</station_descr>");
								valueXmlString.append("<state_zone>").append("<![CDATA[]]>").append("</state_zone>");
							}
						}
					}
					else if (currentColumn.trim().equalsIgnoreCase("sales_prod_grp"))
					{
						String salesProdGrp = checkNull(genericUtility.getColumnValue("sales_prod_grp", dom));
						if(salesProdGrp != null)
						{
							query =" SELECT DESCR FROM SALES_PROD_GRP  WHERE SALES_PROD_GRP = ? " ;
							pstmt = conn.prepareStatement(query);
							pstmt.setString(1, salesProdGrp);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								valueXmlString.append("<sales_prod_grp_descr>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</sales_prod_grp_descr>");
							}
							else
							{
								valueXmlString.append("<sales_prod_grp_descr>").append("<![CDATA[]]>").append("</sales_prod_grp_descr>");
							}
						}
					}
				}
				valueXmlString.append("</Detail1 >");
				System.out.println("itemchange string :::" +valueXmlString);
				break;
			}// switch end
			valueXmlString.append("</Root>");
		}// try end
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				conn.close();
				conn = null;
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}

		}
		System.out.println("valueXmlString:::::" + valueXmlString.toString());
		return valueXmlString.toString();
	}

	private String checkNull( String input )
	{
		if(input == null)
		{
		input = "";
		}
		return input;
	}

}
