/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.UserConstant;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UserConstants
implements Serializable {
    public String USER_ID;
    public String PRODUCT_ID;
    public String REGION_CODE;
    public String PI;
    String user;
    boolean userFileExists;
    ArrayList allUserConstantList;
    public ArrayList logicalNames = new ArrayList();
    public ArrayList displayNames = new ArrayList();
    public ArrayList values = new ArrayList();
    public ArrayList defaultValues = new ArrayList();
    public ArrayList dataTypes = new ArrayList();
    public HashMap dataTypeMappings = new HashMap();
    public HashMap valueMappings = new HashMap();

    public UserConstants() {
        this.allUserConstantList = new ArrayList();
    }

    public void parseUserConstantsXML(String user) {
        try {
            File fileToBeParsed;
            CommonConstants.setBIHOME();
            this.user = user;
            String userConstantsXML = String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + this.user + File.separator + "User_Constants.xml";
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = null;
            File f = new File(userConstantsXML);
            if (f.exists()) {
                fileToBeParsed = f;
                this.userFileExists = true;
            } else {
                fileToBeParsed = new File(String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + "common" + File.separator + "xml" + File.separator + "User_Constants.xml");
                this.userFileExists = false;
            }
            if (fileToBeParsed.exists()) {
                document = documentBuilder.parse(fileToBeParsed);
            }
            BaseLogger.log("3", null, null, "fileToBeParsed :" + fileToBeParsed);
            NodeList docNodeList = document.getElementsByTagName("USER_CONSTANT");
            this.allUserConstantList.clear();
            int i = 0;
            while (i < docNodeList.getLength()) {
                String constantValue = "";
                String constantName = "";
                String dataType = "";
                UserConstant userConstant = new UserConstant();
                if (docNodeList.item(i).getAttributes().getNamedItem("NAME") != null) {
                    constantName = docNodeList.item(i).getAttributes().getNamedItem("NAME").getNodeValue();
                    this.logicalNames.add(constantName);
                    userConstant.setLogicalName(constantName);
                }
                if (docNodeList.item(i).getAttributes().getNamedItem("DEFAULT") != null) {
                    this.defaultValues.add(docNodeList.item(i).getAttributes().getNamedItem("DEFAULT").getNodeValue());
                    userConstant.setDefaultValue(docNodeList.item(i).getAttributes().getNamedItem("DEFAULT").getNodeValue());
                }
                if (docNodeList.item(i).getAttributes().getNamedItem("JAVATYPE") != null) {
                    dataType = docNodeList.item(i).getAttributes().getNamedItem("JAVATYPE").getNodeValue();
                    this.dataTypes.add(docNodeList.item(i).getAttributes().getNamedItem("JAVATYPE").getNodeValue());
                    userConstant.setDataType(dataType);
                }
                if (docNodeList.item(i).getAttributes().getNamedItem("VALUE") != null) {
                    constantValue = docNodeList.item(i).getAttributes().getNamedItem("VALUE").getNodeValue();
                    this.values.add(constantValue);
                    userConstant.setCurrentValue(constantValue);
                }
                if (docNodeList.item(i).getAttributes().getNamedItem("TYPE") != null) {
                    constantValue = docNodeList.item(i).getAttributes().getNamedItem("TYPE").getNodeValue();
                    userConstant.setType(constantValue);
                }
                if (docNodeList.item(i).getAttributes().getNamedItem("EXPR") != null) {
                    constantValue = docNodeList.item(i).getAttributes().getNamedItem("EXPR").getNodeValue();
                    userConstant.setExpr(constantValue);
                }
                if (docNodeList.item(i).getAttributes().getNamedItem("EXPR_ARGS") != null) {
                    constantValue = docNodeList.item(i).getAttributes().getNamedItem("EXPR_ARGS").getNodeValue();
                    StringTokenizer stTokens = new StringTokenizer(constantValue, ",");
                    ArrayList<String> argList = new ArrayList<String>();
                    while (stTokens.hasMoreTokens()) {
                        argList.add(stTokens.nextToken().trim());
                    }
                    userConstant.setExprArgList(argList);
                }
                if (docNodeList.item(i).getFirstChild() != null) {
                    this.displayNames.add(docNodeList.item(i).getFirstChild().getNodeValue());
                    userConstant.setDisplayName(docNodeList.item(i).getFirstChild().getNodeValue());
                }
                this.dataTypeMappings.put(constantName, dataType);
                this.valueMappings.put(constantName, constantValue);
                if (constantName.equalsIgnoreCase("USER_ID")) {
                    this.USER_ID = constantValue;
                } else if (constantName.equalsIgnoreCase("REGION_CODE")) {
                    this.REGION_CODE = constantValue;
                } else if (constantName.equalsIgnoreCase("PI")) {
                    this.PI = constantValue;
                } else if (constantName.equalsIgnoreCase("PRODUCT_ID")) {
                    this.PRODUCT_ID = constantValue;
                }
                this.allUserConstantList.add(userConstant);
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :UserConstants :parseUserConstantsXML :==>\n");
            e.printStackTrace();
        }
    }

    public ArrayList getAllConstantsDetails() {
        this.logicalNames.clear();
        this.displayNames.clear();
        this.values.clear();
        this.dataTypes.clear();
        this.defaultValues.clear();
        this.dataTypeMappings.clear();
        this.parseUserConstantsXML(this.user);
        ArrayList<ArrayList> returnList = new ArrayList<ArrayList>();
        ArrayList<String> constantValues = new ArrayList<String>();
        int i = 0;
        while (i < this.allUserConstantList.size()) {
            String value = ((UserConstant)this.allUserConstantList.get(i)).getCurrentValue();
            constantValues.add(value);
            ++i;
        }
        returnList.add(this.logicalNames);
        returnList.add(this.displayNames);
        returnList.add(constantValues);
        returnList.add(this.defaultValues);
        returnList.add(this.dataTypes);
        BaseLogger.log("2", null, null, "The return list in all constant details is :\n" + returnList);
        return returnList;
    }

    public void updateConstants(String xmlString) {
        try {
            BaseLogger.log("3", null, null, "userFileExists :" + this.userFileExists);
            if (this.userFileExists) {
                if (xmlString.length() > 0) {
                    this.updateFile(xmlString);
                }
            } else {
                this.copyFile();
                if (xmlString.length() > 0) {
                    this.updateFile(xmlString);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void copyFile() {
        int read = -1;
        try {
            File userFile = new File(String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + this.user + File.separator + "User_Constants.xml");
            userFile.createNewFile();
            File commonFile = new File(String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + "common" + File.separator + "xml" + File.separator + "User_Constants.xml");
            FileWriter fw = new FileWriter(userFile);
            BufferedInputStream bufInputStream = new BufferedInputStream(new FileInputStream(commonFile));
            while ((read = bufInputStream.read()) != -1) {
                fw.write(read);
            }
            fw.flush();
            fw.close();
            BaseLogger.log("3", null, null, "File copied ");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception ==> createUserFile() :" + e);
        }
    }

    private void updateFile(String xmlString) {
        try {
            File ucFile = new File(String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + this.user + File.separator + "User_Constants.xml");
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(ucFile);
            Document strdom = documentBuilder.parse(new ByteArrayInputStream(xmlString.getBytes()));
            NodeList constantsNodeList = strdom.getElementsByTagName("USER_CONSTANT");
            NodeList docNodeList = document.getElementsByTagName("USER_CONSTANT");
            int i = 0;
            while (i < constantsNodeList.getLength()) {
                String constantName = constantsNodeList.item(i).getAttributes().getNamedItem("NAME") == null ? "" : constantsNodeList.item(i).getAttributes().getNamedItem("NAME").getNodeValue();
                String constantValue = constantsNodeList.item(i).getAttributes().getNamedItem("VALUE") == null ? "" : constantsNodeList.item(i).getAttributes().getNamedItem("VALUE").getNodeValue();
                String constantDType = constantsNodeList.item(i).getAttributes().getNamedItem("JAVATYPE") == null ? "" : constantsNodeList.item(i).getAttributes().getNamedItem("JAVATYPE").getNodeValue();
                String constantDefVal = constantsNodeList.item(i).getAttributes().getNamedItem("DEFAULT") == null ? "" : constantsNodeList.item(i).getAttributes().getNamedItem("DEFAULT").getNodeValue();
                String displayName = constantsNodeList.item(i).getFirstChild() == null ? "" : constantsNodeList.item(i).getFirstChild().getNodeValue();
                int j = 0;
                while (j < docNodeList.getLength()) {
                    Node node = docNodeList.item(j);
                    String name = node.getAttributes().getNamedItem("NAME").getNodeValue();
                    if (name.equals(constantName)) {
                        if (constantValue.length() > 0) {
                            node.getAttributes().getNamedItem("VALUE").setNodeValue(constantValue);
                        }
                        if (constantDType.length() > 0) {
                            node.getAttributes().getNamedItem("JAVATYPE").setNodeValue(constantDType);
                        }
                        if (constantDefVal.length() > 0) {
                            node.getAttributes().getNamedItem("DEFAULT").setNodeValue(constantDefVal);
                        }
                        if (displayName.length() > 0) {
                            node.getFirstChild().setNodeValue(displayName);
                            this.deleteJSTree();
                        }
                    }
                    ++j;
                }
                ++i;
            }
            DOMSource domSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(ucFile);
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer tr = tfactory.newTransformer();
            tr.transform(domSource, streamResult);
            BaseLogger.log("3", null, null, "File updated");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, e.getMessage());
            e.printStackTrace();
        }
    }

    public String getDataType(String lname) {
        int i = 0;
        while (i < this.allUserConstantList.size()) {
            if (((UserConstant)this.allUserConstantList.get(i)).getLogicalName().equalsIgnoreCase(lname)) {
                return ((UserConstant)this.allUserConstantList.get(i)).getDataType();
            }
            ++i;
        }
        return null;
    }

    public String getType(String lname) {
        int i = 0;
        while (i < this.allUserConstantList.size()) {
            if (((UserConstant)this.allUserConstantList.get(i)).getLogicalName().equalsIgnoreCase(lname)) {
                return ((UserConstant)this.allUserConstantList.get(i)).getType();
            }
            ++i;
        }
        return null;
    }

    public ArrayList getExprArgList(String lname) {
        int i = 0;
        while (i < this.allUserConstantList.size()) {
            if (((UserConstant)this.allUserConstantList.get(i)).getLogicalName().equalsIgnoreCase(lname)) {
                return ((UserConstant)this.allUserConstantList.get(i)).getExprArgList();
            }
            ++i;
        }
        return null;
    }

    public String getExpr(String lname) {
        int i = 0;
        while (i < this.allUserConstantList.size()) {
            if (((UserConstant)this.allUserConstantList.get(i)).getLogicalName().equalsIgnoreCase(lname)) {
                return ((UserConstant)this.allUserConstantList.get(i)).getExpr();
            }
            ++i;
        }
        return null;
    }

    public String getValue(String lname) {
        int i = 0;
        while (i < this.allUserConstantList.size()) {
            if (((UserConstant)this.allUserConstantList.get(i)).getLogicalName().equalsIgnoreCase(lname)) {
                return ((UserConstant)this.allUserConstantList.get(i)).getCurrentValue();
            }
            ++i;
        }
        return null;
    }

    public String getDefaultValue(String lname) {
        int i = 0;
        while (i < this.allUserConstantList.size()) {
            if (((UserConstant)this.allUserConstantList.get(i)).getLogicalName().equalsIgnoreCase(lname)) {
                return ((UserConstant)this.allUserConstantList.get(i)).getDefaultValue();
            }
            ++i;
        }
        return null;
    }

    public void addConstant(String xmlString) {
        try {
            if (this.userFileExists) {
                if (xmlString.length() > 0) {
                    this.appendFile(xmlString);
                }
            } else {
                this.copyFile();
                if (xmlString.length() > 0) {
                    this.appendFile(xmlString);
                }
            }
            this.deleteJSTree();
        }
        catch (IOException ie) {
            BaseLogger.log("0", null, null, "UserConstants: addConstant :");
            ie.printStackTrace();
        }
    }

    private void appendFile(String xmlString) throws IOException {
        try {
            File ucFile = new File(String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + this.user + File.separator + "User_Constants.xml");
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(ucFile);
            Element rootElement = document.getDocumentElement();
            Document strDom = documentBuilder.parse(new ByteArrayInputStream(xmlString.getBytes()));
            NodeList constantsNodeList = strDom.getElementsByTagName("USER_CONSTANT");
            NodeList docNodeList = document.getElementsByTagName("USER_CONSTANTS");
            int i = 0;
            while (i < constantsNodeList.getLength()) {
                Element ucElement = document.createElement("USER_CONSTANT");
                ucElement.setAttribute("DEFAULT", constantsNodeList.item(i).getAttributes().getNamedItem("DEFAULT").getNodeValue());
                ucElement.setAttribute("VALUE", constantsNodeList.item(i).getAttributes().getNamedItem("VALUE").getNodeValue());
                ucElement.setAttribute("JAVATYPE", constantsNodeList.item(i).getAttributes().getNamedItem("JAVATYPE").getNodeValue());
                ucElement.setAttribute("NAME", constantsNodeList.item(i).getAttributes().getNamedItem("NAME").getNodeValue().toUpperCase());
                String elementValue = constantsNodeList.item(i).getFirstChild().getNodeValue();
                ucElement.appendChild(document.createTextNode(elementValue));
                rootElement.appendChild(ucElement);
                ++i;
            }
            DOMSource domSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(ucFile);
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer tr = tfactory.newTransformer();
            tr.transform(domSource, streamResult);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "UserConstants:appendFile");
            e.printStackTrace();
        }
    }

    private void deleteJSTree() {
        try {
            String jsDirString = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "bi" + File.separator + "resource" + File.separator + this.user + File.separator + "js";
            File jsDir = new File(jsDirString);
            File[] jsFiles = jsDir.listFiles();
            int i = 0;
            while (i < jsFiles.length) {
                jsFiles[i].delete();
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : UserConstants : deleteJSTree()" + e);
            e.printStackTrace();
        }
    }

    public void deleteConstants(String xmlString) {
        try {
            if (!this.userFileExists) {
                this.copyFile();
            }
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document strDom = documentBuilder.parse(new ByteArrayInputStream(xmlString.getBytes()));
            NodeList strNodeList = strDom.getElementsByTagName("delete");
            File ucFile = new File(String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + this.user + File.separator + "User_Constants.xml");
            Document document = documentBuilder.parse(ucFile);
            NodeList docNodeList = document.getElementsByTagName("USER_CONSTANT");
            int i = 0;
            while (i < strNodeList.getLength()) {
                String constantName = strNodeList.item(i).getFirstChild().getNodeValue();
                int j = 0;
                while (j < docNodeList.getLength()) {
                    if (docNodeList.item(j).getAttributes().getNamedItem("NAME").getNodeValue().equalsIgnoreCase(constantName)) {
                        Node constantNode = docNodeList.item(j);
                        document.getElementsByTagName("USER_CONSTANTS").item(0).removeChild(constantNode);
                    }
                    ++j;
                }
                ++i;
            }
            DOMSource domSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(ucFile);
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer tr = tfactory.newTransformer();
            tr.transform(domSource, streamResult);
            this.deleteJSTree();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean isUserConstant(String lname) {
        boolean isExist = false;
        int i = 0;
        while (i < this.allUserConstantList.size()) {
            if (((UserConstant)this.allUserConstantList.get(i)).getLogicalName().equalsIgnoreCase(lname)) {
                isExist = true;
                break;
            }
            ++i;
        }
        return isExist;
    }
}

