/*
 * Decompiled with CFR 0.152.
 */
package ibase.hibernate.dao;

import ibase.hibernate.bean.UserTask;
import ibase.hibernate.utility.HibernateUtil;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.notification.ejb.PublishPushNotificationEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import org.json.JSONException;
import org.json.JSONObject;

public class UserTaskDao {
    private UserInfoBean userInfo = null;
    private HttpServletRequest request = null;

    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    public void saveOrUpdateUserTask(String userTaskDataJson) {
        BaseLogger.log("0", null, null, "in saveOrUpdateUserTask::" + userTaskDataJson);
        try {
            JSONObject userTaskData = new JSONObject();
            if (userTaskDataJson != null && userTaskDataJson.trim().length() > 0) {
                userTaskData = new JSONObject(userTaskDataJson);
                BaseLogger.log("0", null, null, "saveOrUpdateUserTask userTaskData :: " + userTaskData);
                String tranDB = this.userInfo.getTransDB();
                String loginCode = this.userInfo.getLoginCode();
                String tranId = this.getJSObjValue(userTaskData, "TRAN_ID");
                UserTask userTask = null;
                BaseLogger.log("0", null, null, "saveOrUpdateUserTask:: tranId:" + tranId);
                SimpleDateFormat sdfDBDateFormat = new SimpleDateFormat(new E12GenericUtility().getApplDateFormat());
                Date date = new Date();
                Date currDate = new Date();
                BaseLogger.log("0", null, null, "inside if UserTask is currDate==>" + currDate);
                InetAddress ownIP = InetAddress.getLocalHost();
                String chgTerm = ownIP.getHostAddress();
                if (tranId.length() > 0) {
                    userTask = this.getUserTask(tranId, tranDB);
                    BaseLogger.log("0", null, null, "inside update task userTask==>" + userTask);
                    userTask.setUserIdAssigned(this.getJSObjValue(userTaskData, "USER_ID__ASSIGNED"));
                    userTask.setTaskDescr(this.getJSObjValue(userTaskData, "TASK_DESCR"));
                    userTask.setCurrStatus(this.getJSObjValue(userTaskData, "CURR_STATUS"));
                    userTask.setStatusDate(currDate);
                    userTask.setChgDate(currDate);
                    userTask.setChgTerm(chgTerm);
                    userTask.setChgUser(loginCode);
                } else {
                    userTask = new UserTask();
                    String taskDomain = "SFA";
                    String expComplDateStr = this.getJSObjValue(userTaskData, "EXP_COMPL_DATE");
                    HashMap<String, String> typeCodeMap = this.getTaskDetails(taskDomain, tranDB);
                    String taskType = typeCodeMap.get("TASK_TYPE");
                    String taskCode = typeCodeMap.get("TASK_CODE");
                    String TranId = this.generateTranId(loginCode, tranDB);
                    userTask.setTranId(TranId);
                    userTask.setTranDate(currDate);
                    userTask.setUserId(loginCode);
                    userTask.setAddUser(loginCode);
                    userTask.setAddTerm(chgTerm);
                    userTask.setAddDate(currDate);
                    userTask.setTaskDescr(this.getJSObjValue(userTaskData, "TASK_DESCR"));
                    userTask.setTaskType(taskType);
                    userTask.setTaskDomain(taskDomain);
                    userTask.setTaskCode(taskCode);
                    userTask.setUserIdAssigned(this.getJSObjValue(userTaskData, "USER_ID__ASSIGNED"));
                    userTask.setCurrStatus(this.getJSObjValue(userTaskData, "CURR_STATUS"));
                    userTask.setStatusDate(currDate);
                    userTask.setComplRemarks("");
                    userTask.setRefSer(this.getJSObjValue(userTaskData, "REF_SER"));
                    userTask.setRefId(this.getJSObjValue(userTaskData, "REF_ID"));
                    userTask.setChgDate(currDate);
                    userTask.setChgTerm(chgTerm);
                    userTask.setChgUser(loginCode);
                    String userName = this.getUserName(userTask.getAddUser(), tranDB);
                    String assignedUserName = this.getUserName(userTask.getUserIdAssigned(), tranDB);
                    String notificationMsg = String.valueOf(assignedUserName) + " New task is assigned to you, by " + userName;
                    this.sendNotification(userTask.getUserIdAssigned(), notificationMsg, loginCode);
                    String response = this.sendEmail(userTask, tranDB, "USER_TASK_ASSIGN");
                    BaseLogger.log("0", null, null, " Task assigned sendEmail response:" + response);
                }
                BaseLogger.log("0", null, null, "inside saveOrUpdateUserTask if UserTask is userTask :" + userTask);
                Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
                Transaction tx = session.beginTransaction();
                session.saveOrUpdate((Object)userTask);
                session.flush();
                tx.commit();
                session.close();
            }
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException inside saveOrUpdateUserTask:");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception inside saveOrUpdateUserTask:");
            BaseLogger.log("0", null, null, e.getMessage());
        }
    }

    public void updateUserTaskStatus(String tranId, String status) {
        BaseLogger.log("0", null, null, "in updateUserTaskStatus::tranId[" + tranId + "],status[" + status + "]");
        try {
            if (tranId != null && tranId.trim().length() > 0) {
                String tranDB = this.userInfo.getTransDB();
                String loginCode = this.userInfo.getLoginCode();
                UserTask userTask = this.getUserTask(tranId, tranDB);
                BaseLogger.log("0", null, null, "inside if UserTask is userTask :" + userTask);
                if (userTask != null) {
                    SimpleDateFormat sdfDBDateFormat = new SimpleDateFormat(new E12GenericUtility().getApplDateFormat());
                    Date date = new Date();
                    Date currDate = new Date();
                    BaseLogger.log("0", null, null, "updateUserTaskStatus:: currDate :" + currDate);
                    InetAddress ownIP = InetAddress.getLocalHost();
                    String chgTerm = ownIP.getHostAddress();
                    userTask.setCurrStatus(status);
                    userTask.setStatusDate(currDate);
                    userTask.setChgDate(currDate);
                    userTask.setChgTerm(chgTerm);
                    userTask.setChgUser(loginCode);
                }
                BaseLogger.log("0", null, null, "after change userTask :" + userTask);
                Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
                Transaction tx = session.beginTransaction();
                session.update((Object)userTask);
                session.flush();
                tx.commit();
                session.close();
                String userName = this.getUserName(userTask.getAddUser(), tranDB);
                String assignedUserName = this.getUserName(userTask.getUserIdAssigned(), tranDB);
                String notificationMsg = String.valueOf(userName) + ", Task assigned to " + assignedUserName + " has been completed.";
                BaseLogger.log("0", null, null, "befor notification send userTask :" + userTask);
                this.sendNotification(userTask.getAddUser(), notificationMsg, loginCode);
                String response = this.sendEmail(userTask, tranDB, "USER_TASK_STATUS");
                BaseLogger.log("0", null, null, " sendEmail response:" + response);
            }
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException inside updateUserTaskStatus:");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception inside updateUserTaskStatus:");
            BaseLogger.log("0", null, null, e.getMessage());
        }
    }

    public Date getDateObj(String dateStr) throws ITMException {
        E12GenericUtility e12Utility = new E12GenericUtility();
        Date dateObj = e12Utility.getDateObject(dateStr);
        BaseLogger.log("2", null, null, "Date String :: [" + dateStr + " ] Date Object:" + dateObj);
        return dateObj;
    }

    private UserTask getUserTask(String tranId, String tranDB) {
        UserTask userTask = null;
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            Query query = session.createQuery("from UserTask where tranId='" + tranId + "'");
            List userTaskList = query.getResultList();
            System.out.println(" getUserTaskList : " + userTaskList);
            if (userTaskList.size() > 0) {
                userTask = (UserTask)userTaskList.get(0);
                BaseLogger.log("0", null, null, " getUserTask userTask : " + userTask);
            }
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException : getUserTask ");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return userTask;
    }

    private HashMap<String, String> getTaskDetails(String taskDomain, String tranDB) {
        HashMap<String, String> taskCodeArr = new HashMap<String, String>();
        Statement pstm = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            try {
                ConnDriver mConnDriver = new ConnDriver();
                conn = mConnDriver.getConnectDB(tranDB);
                String sql = "SELECT TASK_TYPE,TASK_CODE FROM TASK WHERE TASK_DOMAIN = ?";
                pstm = conn.prepareStatement(sql);
                pstm.setString(1, taskDomain);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    taskCodeArr.put("TASK_TYPE", this.checkNull(rs.getString("TASK_TYPE")));
                    taskCodeArr.put("TASK_CODE", this.checkNull(rs.getString("TASK_CODE")));
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstm != null) {
                    pstm.close();
                    pstm = null;
                }
            }
            catch (Exception e) {
                System.out.println("StrgMeetDCRWizConf.getTaskDetails()[ " + e.getMessage() + " ]");
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstm != null) {
                        pstm.close();
                        pstm = null;
                    }
                    if (conn != null) {
                        conn.commit();
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstm != null) {
                    pstm.close();
                    pstm = null;
                }
                if (conn != null) {
                    conn.commit();
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return taskCodeArr;
    }

    private String generateTranId(String userId, String tranDB) {
        String presentationID;
        block22: {
            presentationID = "";
            Statement pStmt = null;
            ResultSet rSet = null;
            String refSer = "";
            String tranIdCol = "";
            String keyString = "";
            Connection conn = null;
            try {
                try {
                    ConnDriver mConnDriver = new ConnDriver();
                    conn = mConnDriver.getConnectDB(tranDB);
                    if (conn != null) {
                        String transSql = "SELECT REF_SER,TRAN_ID_COL,KEY_STRING FROM TRANSETUP WHERE TRAN_WINDOW  = 'w_user_tasks'";
                        pStmt = conn.prepareStatement(transSql);
                        rSet = pStmt.executeQuery();
                        if (rSet.next()) {
                            refSer = rSet.getString("REF_SER") == null ? "" : rSet.getString("REF_SER").trim();
                            keyString = rSet.getString("KEY_STRING") == null ? "" : rSet.getString("KEY_STRING").trim();
                        }
                        BaseLogger.log("3", null, null, "refSer[" + refSer + "]tranIdCol[" + tranIdCol + "]keyString[" + keyString + "]");
                        TransIDGenerator tranIDGenerator = new TransIDGenerator("<Root></Root>", userId, CommonConstants.DB_NAME);
                        presentationID = tranIDGenerator.generateTranSeqID(refSer, tranIdCol, keyString, conn);
                    }
                }
                catch (Exception exp) {
                    BaseLogger.log("0", null, null, "Exception In generateTranId......");
                    exp.printStackTrace();
                    try {
                        if (rSet != null) {
                            rSet.close();
                            rSet.close();
                        }
                        if (pStmt != null) {
                            pStmt.close();
                            pStmt.close();
                        }
                        if (conn != null) {
                            conn.commit();
                            conn.close();
                            conn = null;
                        }
                        break block22;
                    }
                    catch (Exception expRsc) {
                        BaseLogger.log("0", null, null, "Exception In generateTranId...Finally...");
                        expRsc.printStackTrace();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rSet != null) {
                        rSet.close();
                        rSet.close();
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt.close();
                    }
                    if (conn != null) {
                        conn.commit();
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception expRsc) {
                    BaseLogger.log("0", null, null, "Exception In generateTranId...Finally...");
                    expRsc.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (rSet != null) {
                    rSet.close();
                    rSet.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt.close();
                }
                if (conn != null) {
                    conn.commit();
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception expRsc) {
                BaseLogger.log("0", null, null, "Exception In generateTranId...Finally...");
                expRsc.printStackTrace();
            }
        }
        BaseLogger.log("2", null, null, "Return generateTranId......[" + presentationID + "]");
        return presentationID;
    }

    private String getJSObjValue(JSONObject userTaskData, String key) {
        String value = "";
        if (userTaskData != null && userTaskData.has(key)) {
            try {
                value = (String)userTaskData.get(key);
            }
            catch (JSONException e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "UserTaskDao Exception :" + (Object)((Object)e));
            }
        }
        return value;
    }

    private String sendEmail(UserTask userTask, String transDB, String formatCode) throws Exception {
        BaseLogger.log("3", null, null, "sendEmail :: userTask [" + userTask + "],formatCode[" + formatCode + "]");
        String retString = "Success";
        EMail email = new EMail();
        String to = "";
        String cc = "";
        String bcc = "";
        String sub = "";
        String body = "";
        String emailId = "";
        String CcEmailId = "";
        String BccEemailId = "";
        String copyToEmailId = "";
        Connection userConn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            JSONObject userTaskjsObj = userTask.toJson();
            BaseLogger.log("3", null, null, ". Sending email for " + userTaskjsObj + " course.");
            if (userTaskjsObj == null) {
                return "UserTask Send Mail Fail.";
            }
            try {
                ConnDriver connDriver = new ConnDriver();
                userConn = connDriver.getConnectDB(transDB);
                String userSql = "SELECT SEND_TO,COPY_TO,BLIND_COPY,SUBJECT,BODY_TEXT FROM MAIL_FORMAT WHERE FORMAT_CODE = ? ";
                pstmt = userConn.prepareStatement(userSql);
                pstmt.setString(1, formatCode);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    to = this.checkNull(rs.getString("SEND_TO"));
                    cc = this.checkNull(rs.getString("COPY_TO"));
                    bcc = this.checkNull(rs.getString("BLIND_COPY"));
                    sub = rs.getString("SUBJECT");
                    body = rs.getString("BODY_TEXT");
                }
                emailId = this.getTargetEmail(to, userTask, transDB);
                CcEmailId = this.getTargetEmail(cc, userTask, transDB);
                BccEemailId = this.getTargetEmail(bcc, userTask, transDB);
                pstmt.close();
                rs.close();
                userConn.close();
                SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy hh:mm:ss a");
                String addDateFormated = formatter.format(userTask.getAddDate());
                String statusDateFormated = formatter.format(userTask.getStatusDate());
                userTaskjsObj.put("addDate", (Object)addDateFormated);
                userTaskjsObj.put("statusDate", (Object)statusDateFormated);
                String userName = this.getUserName(userTask.getAddUser(), transDB);
                String assignedUserName = this.getUserName(userTask.getUserIdAssigned(), transDB);
                userTaskjsObj.put("userName", (Object)userName);
                userTaskjsObj.put("assignedUserName", (Object)assignedUserName);
                BaseLogger.log("3", null, null, ". Sending email userTaskjsObj:: " + userTaskjsObj);
                BaseLogger.log("3", null, null, "transDB:" + transDB);
                StringBuilder mailXmlData = new StringBuilder("<root>");
                mailXmlData.append("<TO_ADD><![CDATA[" + emailId + "]]></TO_ADD>");
                if (cc != null && cc.trim().length() > 0) {
                    mailXmlData.append("<CC_ADD><![CDATA[" + CcEmailId + "]]></CC_ADD>");
                }
                if (bcc != null && bcc.trim().length() > 0) {
                    mailXmlData.append("<BCC_ADD><![CDATA[" + BccEemailId + "]]></BCC_ADD>");
                }
                mailXmlData.append("<SUBJECT><![CDATA[" + sub + "]]></SUBJECT>");
                mailXmlData.append("<MESSAGE><![CDATA[" + this.getFormatedEmailBody(body, userTaskjsObj) + "]]></MESSAGE>");
                mailXmlData.append("<MESSAGE_TYPE><![CDATA[text/html]]></MESSAGE_TYPE>");
                mailXmlData.append("<EMAIL_TYPE><![CDATA[page]]></EMAIL_TYPE>");
                mailXmlData.append("</root>");
                BaseLogger.log("3", null, null, "Send Email :mailXmlData:" + mailXmlData);
                String result = email.sendMail(mailXmlData.toString(), null, this.userInfo);
                BaseLogger.log("3", null, null, result);
            }
            catch (Exception e) {
                BaseLogger.log("3", null, null, "sendEmail:" + e);
            }
        }
        finally {
            if (pstmt != null) {
                try {
                    if (userConn != null) {
                        userConn.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        return "mail send successfully";
    }

    private String getFormatedEmailBody(String bodyTextData, JSONObject jsonObj) throws ITMException {
        BaseLogger.log("3", null, null, "getFormatedEmailBody::bodyTextData[" + bodyTextData + "]");
        String startFindStr = "#:";
        String endFindStr = ":#";
        String colFullName = "";
        String colName = "";
        String currColVal = "";
        int currentIndex = 0;
        int nextSearchIndex = 0;
        try {
            if (bodyTextData != null) {
                while (bodyTextData.indexOf(startFindStr, nextSearchIndex) != -1) {
                    BaseLogger.log("3", null, null, nextSearchIndex);
                    currColVal = "";
                    currentIndex = bodyTextData.indexOf(startFindStr, nextSearchIndex);
                    String firstPart = bodyTextData.substring(0, currentIndex);
                    String lastPart = bodyTextData.substring(currentIndex, bodyTextData.length());
                    colFullName = lastPart.substring(0, lastPart.indexOf(endFindStr) + 2);
                    colName = colFullName.substring(startFindStr.length(), colFullName.lastIndexOf(endFindStr));
                    BaseLogger.log("3", null, null, "colName :::" + colName);
                    if (jsonObj.has(colName)) {
                        currColVal = jsonObj.getString(colName);
                    }
                    BaseLogger.log("3", null, null, "currColVal[" + currColVal + "]");
                    bodyTextData = String.valueOf(firstPart) + lastPart.replaceFirst(colFullName, currColVal);
                    nextSearchIndex = currentIndex + currColVal.length();
                    bodyTextData = bodyTextData.replaceAll("#TOMCATE_HOME#", CommonConstants.TOMCAT_HOME);
                    BaseLogger.log("3", null, null, "Formatted bodyTextData" + bodyTextData);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Exception:" + e);
            throw new ITMException(e);
        }
        BaseLogger.log("0", null, null, "getFormatedEmailBody::sending bodyTextData : " + bodyTextData);
        return bodyTextData;
    }

    private void sendNotification(final String to, final String postData, final String userCode) {
        BaseLogger.log("0", null, null, "send notification send to[" + to + "], postData[" + postData + "]");
        new Thread(){

            @Override
            public void run() {
                try {
                    BaseLogger.log("0", null, null, "start notification send to[" + to + "]");
                    if (to.length() > 1) {
                        ArrayList<String> userIdsListArr = new ArrayList<String>();
                        userIdsListArr.add(to);
                        AppConnectParm appConnectParm = null;
                        InitialContext context = null;
                        PublishPushNotificationEJB notificationRemote = new PublishPushNotificationEJB();
                        BaseLogger.log("0", null, null, "send notification userIdsListArr[" + userIdsListArr + "]");
                        appConnectParm = new AppConnectParm();
                        context = new InitialContext(appConnectParm.getProperty());
                        notificationRemote.invockPushNotification(postData, userCode, "T", "", userIdsListArr, "", "", " ", userCode, 0, UserTaskDao.this.userInfo);
                    }
                }
                catch (Exception ex) {
                    BaseLogger.log("0", null, null, "Exception in thread while sending notification : " + ex);
                }
            }
        }.start();
    }

    private String getEmailID(String userCode, String transDB) {
        DBAccessEJB dbAccessEJB = new DBAccessEJB();
        String emailId = null;
        try {
            emailId = dbAccessEJB.getDBColumnValue(" users ", " email_id ", " code = '" + userCode + "'", transDB);
        }
        catch (ITMException | RemoteException e) {
            e.printStackTrace();
        }
        return emailId;
    }

    private String getUserName(String userCode, String transDB) {
        String userName = null;
        DBAccessEJB dbAccessEJB = new DBAccessEJB();
        try {
            userName = dbAccessEJB.getDBColumnValue(" users ", "name", " code = '" + userCode + "'", transDB);
        }
        catch (ITMException | RemoteException e) {
            e.printStackTrace();
        }
        return userName;
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    private String getReporting(String userCode, String transDB) {
        String reportTo = null;
        DBAccessEJB dbAccessEJB = new DBAccessEJB();
        try {
            reportTo = dbAccessEJB.getDBColumnValue(" employee ", "report_to", " emp_code = '" + userCode + "'", transDB);
        }
        catch (ITMException | RemoteException e) {
            e.printStackTrace();
        }
        return reportTo;
    }

    private static boolean isValidEmail(String email) {
        String emailRegex = "^[a-zA-Z0-9_+&*-]+(?:\\.[a-zA-Z0-9_+&*-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,7}$";
        Pattern pat = Pattern.compile(emailRegex);
        if (email == null) {
            return false;
        }
        return pat.matcher(email).matches();
    }

    private String getTargetEmail(String target, UserTask userTask, String transDB) {
        String targetEmail = "";
        if (target.length() > 0) {
            if ("userId".equalsIgnoreCase(target) || "user_id".equalsIgnoreCase(target)) {
                targetEmail = this.getEmailID(userTask.getUserId(), transDB);
            } else if ("userIdAssigned".equalsIgnoreCase(target) || "user_id__assigned".equalsIgnoreCase(target)) {
                targetEmail = this.getEmailID(userTask.getUserIdAssigned(), transDB);
            } else if ("reportTo".equalsIgnoreCase(target) || "report_to".equalsIgnoreCase(target)) {
                String reportTo = this.checkNull(this.getReporting(userTask.getUserIdAssigned(), transDB));
                targetEmail = this.getEmailID(reportTo, transDB);
            } else if (target.indexOf(",") != -1) {
                BaseLogger.log("3", null, null, "getTargetEmail multiple tagets[" + target + "]");
                String[] targets = target.split(",");
                ArrayList<String> targetEmails = new ArrayList<String>();
                String[] stringArray = targets;
                int n = targets.length;
                int n2 = 0;
                while (n2 < n) {
                    String _target = stringArray[n2];
                    targetEmails.add(this.getTargetEmail(_target, userTask, transDB));
                    ++n2;
                }
                targetEmail = targetEmails.toString();
                targetEmail = targetEmail.replaceAll("[", "").replaceAll("]", "");
                BaseLogger.log("3", null, null, "getTargetEmail multiple targetEmails[" + targetEmails + "]targetEmail[" + targetEmail + "]");
            } else {
                targetEmail = UserTaskDao.isValidEmail(target) ? target : "";
            }
        }
        return targetEmail;
    }
}

