package ibase.webitm.ejb.wsfa.masters;

import ibase.system.config.*;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import javax.ejb.*;
import org.w3c.dom.*;

//@Stateless		commented by Sagar M [22 Nov 2018].

public class SpecialitySeries extends ValidatorEJB implements SpecialityRemote,SpecialityLocal{

	E12GenericUtility genericUtility = new E12GenericUtility();
	// Code for Validation
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}


	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			System.out.println("Speciality:wfValData value of xmlString ["+xmlString+"]");
			System.out.println("Speciality:wfValData value of xmlString1 ["+xmlString1+"]");
			System.out.println("Speciality:wfValData value of xmlString2 ["+xmlString2+"]");
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println ("ErrString: " + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception: Speciality: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println ("Returning from Speciality wfValData");
		return (errString);
	}
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0,currentFormNo =0,childNodeListLength =0,cnt =0;

		String childNodeName = null,childNodeValue = null;
		String errString = "";
		String errCode = "";
		Connection conn = null;
		String userId = "";
		int count = 0;
		String loginSite = "";
		String spl_code = "",item_ser = "",activeYN="";
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		try
		{
			//ConnDriver connDriver = new ConnDriver(); //Commented by vinayak on [11/07/2016]
			//conn = connDriver.getConnectDB("DriverITM"); //Commented by vinayak on [11/07/2016]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println(" ***********Validation for Speciality Detail  "+currentFormNo);
			switch(currentFormNo)
			{
				case 1 :
					System.out.println("Validation for Detail 1 Brand..........");
					System.out.println("Validation for Speciality.........."+dom.getElementsByTagName("Detail1"));
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
				    childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{

						childNode = childNodeList.item(ctr);
						System.out.println("childNode.........."+ctr+"       "+childNode);
						childNodeName = childNode.getNodeName();
						System.out.println("childNodeName.........."+ctr+"       "+childNodeName);
						if(childNode.getFirstChild()!= null)
						{
							childNodeValue = childNode.getFirstChild().getNodeValue();
						}
						if(childNodeName.equalsIgnoreCase("spl_code"))
						{
							System.out.println(" Validaion   for field "+childNodeName);
							spl_code = genericUtility.getColumnValue("spl_code", dom);

							if(spl_code == null || spl_code.trim().length() == 0)
							{
								errCode = "NULSPLCODE";
								errString =  getErrorString("spl_code",errCode,userId);
								break ;
							}
							else if(spl_code != null && spl_code.trim().length() > 0)
							{
								cnt =  isValueExist("SPECIALITY","spl_code",spl_code, conn);
								if(cnt == 0)
								{
									if(editFlag.equals("A"))
									{
										errCode = "UNINVALSPL";
										errString =  getErrorString("spl_code",errCode,userId);
										break ;
									}
									else if(editFlag.equals("E"))
									{
										errCode = "UNINACTSPL";
										errString =  getErrorString("spl_code",errCode,userId);
										//break ;
									}

								}
							}
						}
						if(childNodeName.equalsIgnoreCase("item_ser"))
						{
							System.out.println(" Validaion   for field "+childNodeName);
							item_ser = genericUtility.getColumnValue("item_ser", dom);
							spl_code = genericUtility.getColumnValue("spl_code", dom);

							if(item_ser == null || item_ser.trim().length() == 0)
							{
								errCode = "NULISRCODE";
								errString =  getErrorString("item_ser",errCode,userId);
								break ;
							}
							else if(item_ser != null && item_ser.trim().length() > 0)
							{
								cnt =  isValueExist("ITEMSER","item_ser",item_ser, conn);
								if(cnt == 0)
								{
									errCode = "ITMNOTEXT";
									errString =  getErrorString("item_ser",errCode,userId);
									break ;
								}
								else if(cnt > 0)
								{
									//String sql = " SELECT COUNT(*) AS COUNT FROM ITEMSER WHERE item_ser = ? AND site_code = ? " ;	 // COMMENTED BY VISHAKHA [16.06.2015]
									String sql = " SELECT COUNT(*) AS COUNT FROM ITEMSER WHERE item_ser = ? AND SER_TYPE IN ('F','0') " ;	// NEW CHANGES ADDED BY VISHAKHA [16.06.2015]
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, item_ser);
									//pstmt.setString(2, loginSite);   // COMMENTED BY VISHAKHA [16.06.2015]
									rSet = pstmt.executeQuery();
									if( rSet.next() )
									{
										count  = rSet.getInt("COUNT");
									}
									if ( rSet != null )
									{
										rSet.close();
										rSet = null;
									}
									if ( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}


									if(count == 0)
									{
										errCode = "VMITMST";
										errString =  getErrorString("item_ser",errCode,userId);
										break ;
									}
								}
							}
							if(editFlag.equals("A"))
							{
								if(spl_code != null && spl_code.trim().length() > 0)
								{
									if(item_ser != null && item_ser.trim().length() > 0)
									{
											String strSQL = "SELECT COUNT(*) AS COUNT FROM SPECIALITY_SERIES WHERE SPL_CODE = ? AND ITEM_SER = ? ";
											pstmt = conn.prepareStatement(strSQL);
											pstmt.setString(1,spl_code);
											pstmt.setString(2,item_ser);
											rSet = pstmt.executeQuery();
											if( rSet.next() )
											{
												count  = rSet.getInt("COUNT");
											}
											if ( rSet != null )
											{
												rSet.close();
												rSet = null;
											}
											if ( pstmt != null )
											{
												pstmt.close();
												pstmt = null;
											}


											if(count > 0)
											{
												errCode = "VMVLDSPTY";
												errString =  getErrorString("state_code",errCode,userId);
												break ;
											}
									  }
								}
							}

						}
						if(childNodeName.equalsIgnoreCase("active_yn"))
						{
							if(editFlag.equals("E"))
							{
								activeYN = childNode.getFirstChild().getNodeValue().trim();
								spl_code = genericUtility.getColumnValue("spl_code", dom);
								item_ser = genericUtility.getColumnValue("item_ser", dom);

								if(activeYN.equals("N"))
								{
									String strSQL = "SELECT COUNT(*) AS COUNT FROM STRG_SERIES WHERE SPL_CODE = ? AND ITEM_SER = ? AND STATUS='Y'"; // Changes by hariom s for active doctor on [26-03-2020]      
									pstmt = conn.prepareStatement(strSQL);
									pstmt.setString(1,spl_code);
									pstmt.setString(2,item_ser);
									rSet = pstmt.executeQuery();
									if( rSet.next() )
									{
										cnt  = rSet.getInt("COUNT");
									}
									if ( rSet != null )
									{
										rSet.close();
										rSet = null;
									}
									if ( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}

									if(cnt > 0)
									{
										errCode = "VTACTSPL"; // CHANGES BY VISHAKHA[27/05/2015] [To change the message][Start]
										errString =  getErrorString("active_yn",errCode,userId);
										break ;
									}

								}
							}
						}

					}

			}//END SWITCH
		}//END TRY
		catch(Exception e)
		{
			System.out.println("Exception ::"+e);
			e.printStackTrace();
			errString=e.getMessage();
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}
			System.out.println(" Speciality Validation End and Connection is Closed");
		}
		System.out.println("ErrString ::"+errString);
		return errString;
	}//END OF VALIDATION
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			System.out.println("Speciality:itemChanged value of xmlString ["+xmlString+"]");
			System.out.println("Speciality:itemChanged value of xmlString ["+xmlString1+"]");
			System.out.println("Speciality:itemChanged value of xmlString ["+xmlString2+"]");
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception : Speciality :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from Speciality itemChanged");
		return errString;
	 }
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{

		int currentFormNo = 0;
		StringBuffer valueXmlString =null;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level

		String code="";
		String userId="";
		String userSite="";
		String userSiteDescr="";
		String chgDate = "";
		String chgUser = "";
		String chgTerm = "";
		String item_ser = "",item_serDsc = "",spl_code = "", spl_descr = "";
		int seq=0;
		int tId=0,updCnt=0;
		Connection connection = null;
		//ConnDriver connDriver = null;
		Statement stmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		try
		{
			//connDriver = new ConnDriver(); //Commented by vinayak on [11/07/2016]
			//connection = connDriver.getConnectDB("Driver");//Commented by vinayak on [11/07/2016]
			connection = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			userSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			chgDate = sdf.format(new java.util.Date());
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");

			if (objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n<Detail1>\r\n");
			switch (currentFormNo)
			{
				case 1:
					if (currentColumn.equalsIgnoreCase("itm_default"))
					{
						System.out.println("value of userId"+userId);
						System.out.println("value of userSite"+userSite);
						System.out.println("value of chgDate"+chgDate);
						System.out.println("value of chgUser"+chgUser);
						System.out.println("value of chgterm"+chgTerm);
						valueXmlString.append("<mkt_focus>").append("<![CDATA[H]]>").append("</mkt_focus>");
						valueXmlString.append("<active_yn>").append("<![CDATA[Y]]>").append("</active_yn>");
						valueXmlString.append("<chg_date><![CDATA[").append(checkNull(chgDate)).append("]]></chg_date>\r\n");
						valueXmlString.append("<chg_user><![CDATA[").append(checkNull(chgUser)).append("]]></chg_user>\r\n");
						valueXmlString.append("<chg_term><![CDATA[").append(checkNull(chgTerm)).append("]]></chg_term>\r\n");
					}
					else if(currentColumn.equalsIgnoreCase("itm_defaultedit"))
					{

						spl_code = genericUtility.getColumnValue("spl_code", dom);
						spl_descr = getFieldValue("DESCR", "SPECIALITY", "spl_code", spl_code, connection);
						valueXmlString.append("<spl_code protect=\"1\">").append("<![CDATA[" + spl_code + "]]>").append("</spl_code>");
						valueXmlString.append("<speciality_descr protect=\"1\">").append("<![CDATA[" + spl_descr + "]]>").append("</speciality_descr>");

						item_ser = genericUtility.getColumnValue("item_ser", dom);
						item_serDsc = getFieldValue("DESCR", "ITEMSER", "item_ser", item_ser, connection);
						valueXmlString.append("<item_ser protect=\"1\">").append("<![CDATA[" + item_ser + "]]>").append("</item_ser>");
						valueXmlString.append("<itemser_descr protect=\"1\">").append("<![CDATA[" + item_serDsc + "]]>").append("</itemser_descr>");
					}
					else if(currentColumn.trim().equalsIgnoreCase("spl_code"))
					{
						spl_code = genericUtility.getColumnValue("spl_code", dom);
						String sql = " SELECT DESCR FROM SPECIALITY WHERE SPL_CODE = ? AND ACTIVE_YN='Y' " ;
						pstmt = connection.prepareStatement(sql);
						pstmt.setString(1, spl_code);
						rs = pstmt.executeQuery();
						if(rs.next())
						  {
							 valueXmlString.append("<speciality_descr>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</speciality_descr>");
						  }
						  else
						  {
							valueXmlString.append("<speciality_descr>").append("<![CDATA[]]>").append("</speciality_descr>");
						  }
						if( rs != null )
						{
							rs.close();
							rs=null;
						}
						if( pstmt != null )
						{
							pstmt.close();
							pstmt=null;
						}
					}
					else if(currentColumn.trim().equalsIgnoreCase("item_ser"))
					{
						item_ser = genericUtility.getColumnValue("item_ser", dom);
						//String sql = " SELECT DESCR FROM ITEMSER WHERE item_ser = ? AND site_code = ? " ;   // COMMENTED BY VISHAKHA [16.06.2015]
						String sql = " SELECT DESCR FROM ITEMSER WHERE item_ser = ? AND SER_TYPE = 'F' " ;	// NEW CHANGES ADDED BY VISHAKHA [16.06.2015]
						pstmt = connection.prepareStatement(sql);
						pstmt.setString(1, item_ser);
						//pstmt.setString(2, userSite);  // COMMENTED BY VISHAKHA [16.06.2015]
						rs = pstmt.executeQuery();
						if(rs.next())
						  {
							 valueXmlString.append("<itemser_descr>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</itemser_descr>");
						  }
						  else
						  {
							valueXmlString.append("<itemser_descr>").append("<![CDATA[]]>").append("</itemser_descr>");
						  }
						if( rs != null )
						{
							rs.close();
							rs=null;
						}
						if( pstmt != null )
						{
							pstmt.close();
							pstmt=null;
						}

					  }
					break;
				}
		}catch (Exception e)
		{
			System.out.println ("Exception :Speciality :itemChanged(Document,String):" + e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if(connection != null)
				{
					connection.close();
					connection = null;
				}
	        }
			catch(Exception e)
			{
				System.out.println(e.getMessage());
			}
		}
		valueXmlString.append ("</Detail1>\r\n");
		valueXmlString.append("</Root>\r\n");
		System.out.println("Speciality :itemChanged(Document,String):return valueXmlString"+valueXmlString);
		return valueXmlString.toString();
	}
	private String getFieldValue(String column,String tableName, String columnName, String columnValue,Connection conn) throws ITMException // throws added by kailash on 11-04-18.
    {
    	PreparedStatement pstmt = null;
        ResultSet rs = null;
        String value = null;
        String sql = null;

        sql = " select "+column+" from "+tableName+" where "+columnName+" = '" + columnValue + "' ";
        try
        {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            System.out.println("\n\n\n Query Executed " + sql+ "\n\n******************");
            if(rs.next())
            {
            	value = rs.getString(1) != null ? rs.getString(1) : " ";
            }
            else
            {
            	value = " ";
            }
            rs.close();
            pstmt.close();
        }
        catch(Exception exception)
        {
            exception.printStackTrace();
            System.out.println("Exception ::" + exception.getMessage());
            throw new ITMException(exception); //added by Kailash on 11-04-2018.
        }
        return value;
    }
	private int isValueExist(String tableName, String columnName, String columnValue,Connection conn)  throws ITMException // throws added by kailash on 11-04-18.
    {
    	PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = null;
        int cnt = 0 ;
        String condt="";
        if(tableName.equals("SPECIALITY"))
        {
        	condt=" AND ACTIVE_YN = 'Y' ";
        }
        sql = " select count(1) as count from "+tableName+" where "+columnName+" = '" + columnValue + "' "+condt+" ";
        try
        {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            System.out.println("\n\n\n Query Executed " + sql+ "\n\n******************");
            if(rs.next())
            {
            	cnt = rs.getInt("count");
            }
            rs.close();
            pstmt.close();
            System.out.println("cnt--------------"+cnt);
        }
        catch(Exception exception)
        {
            exception.printStackTrace();
            System.out.println("Exception ::" + exception.getMessage());
            throw new ITMException(exception); //added by Kailash on 11-04-2018.
        }
        return cnt;
    }
	private String checkNull(String input)
	{
		if (input == null)
		{
			input = "";
		}
		else
		{
			input =input.trim();
		}
		return input;
	}

}
