/**
@Author: Piyush
@Reason: To get Savex Report
@Date: 08/09/10
**/

package ibase.webitm.bean.wsfa;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.servlet.http.HttpSession;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.wsfa.transactions.ViewReportActionEJB;
import ibase.webitm.utility.ITMException;

public class SavexViewReportBean {
	E12GenericUtility genericUtility = new E12GenericUtility();// Added by vinayak on [12/07/2016]
	private ibase.utility.UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private String objName = "";
	private String user_lang = "en";
	private String user_country = "US";

	public SavexViewReportBean(String objName, HttpSession sessionCtx) throws ITMException {
		try {
			this.objName = objName;
			this.sessionCtx = sessionCtx;
			this.userInfo = (ibase.utility.UserInfoBean) this.sessionCtx.getAttribute("USER_INFO");
			// Changed by Pramod on 08-01-11[WS01SUN030 ||Generating country wise, language
			// wise xsl and reading the same.Getting user language and country]starts
			this.user_lang = this.userInfo.getUserLanguage();
			this.user_country = this.userInfo.getUserCountry();
			// Changed by Pramod on 08-01-11[WS01SUN030 ||Generating country wise, language
			// wise xsl and reading the same.Getting user language and country]Ends
		} catch (Exception e) {
			throw new ITMException(e);
		}
	}
	public SavexViewReportBean() throws ITMException {
		System.out.println(":SavexViewReportBean Called................:");
	}

	public String getReportHtmlStr(String objName, String salesPers, String workDate, String userInfoStr, UserInfoBean userInfo )
			throws ITMException {
		String reportstr = "";

		try {
			// InitialContext ctx = new InitialContext( new AppConnectParm().getProperty()
			// );

			ViewReportActionEJB dReportRem = new ViewReportActionEJB();
			//Added By Ravindra C on 13-09-19 for dynamic connection - Start
			//reportstr = dReportRem.viewReport(workDate, salesPers, true, userInfo );
			reportstr = dReportRem.viewReport(workDate, salesPers, true, userInfo );
			// Changed By rohan [WS01SUN063 || To get another XSL file if Requried XSL file
			// not found]
			// String xslFileName = getXSLFileName( objName + "_view_report_" +
			// this.user_lang + "_" + this.user_country + ".xsl" );
			String xslFileName = getXSLFileName(
					objName + "_view_report_" + this.user_lang + "_" + this.user_country + ".xsl",
					objName + "_view_report_" + "en" + "_" + "US" + ".xsl");
			reportstr = (new ibase.utility.E12GenericUtility()).transformToString(xslFileName, reportstr,
					CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html");
		} catch (Exception e) {
			throw new ITMException(e);
		}
		System.out.println("reportstr -->::["+ reportstr +"]");
		return reportstr;
	}

	// Changed by rohan [WS01SUN063 || To get another XSL file if Requried XSL file
	// not found]
	// private String getXSLFileName( String xslFileName)throws ITMException
	private String getXSLFileName(String xslFileName, String xslFileName1) throws ITMException {
		String retFileName = null;
		try {
			String defaultPath = null;
			if (CommonConstants.APPLICATION_CONTEXT != null) {
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			} else {
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator
						+ CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File(defaultPath + File.separator + "xsl" + File.separator + CommonConstants.THEME
					+ File.separator + "WIZARD");
			if (!xslPath.exists()) {
				xslPath.mkdir();
			}
			File xslFile = new File(xslPath, xslFileName);
			if (xslFile.exists()) {
				retFileName = xslFile.getAbsolutePath();
			} else {
				// Changed by rohan [WS01SUN063 || To get another XSL file if Requried XSL file
				// not found]
				// throw new ITMException( new Exception("Wizard XSL file Not Found") );
				File xslFile1 = new File(xslPath, xslFileName1);
				retFileName = xslFile1.getAbsolutePath();
				if (!xslFile1.exists()) {
					throw new ITMException(
							new Exception("Wizard XSL file Not Found" + " at Location [" + retFileName + "]"));
				}
				// Changed by rohan [WS01SUN063 || To get another XSL file if Requried XSL file
				// not found] Ends
			}
		} catch (Exception e) {
			throw new ITMException(e);
		}
		return retFileName;
	}

	// Added by Vishakha [11/01/2016] to get IS_RUSSIA flag [start]

	public String getRussia(String empCode) throws ITMException {
		String isRussia = "N";
		Connection conn = null;
		ConnDriver mConnDriver = null;
		PreparedStatement rstmt = null;
		ResultSet rrs = null;
		try {

			mConnDriver = new ConnDriver();
			conn = mConnDriver.getConnectDB("Driver");
			String itemSer = "";
			String empSite = "";

			String rusSql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
			rstmt = conn.prepareStatement(rusSql);
			rstmt.setString(1, empCode);

			rrs = rstmt.executeQuery();
			if (rrs.next()) {
				empSite = rrs.getString("SITE_CODE__DEF").trim();
			}
			if (rrs != null) {
				rrs.close();
				rrs = null;
			}
			if (rstmt != null) {
				rstmt.close();
				rstmt = null;
			}

			System.out.println("value of empSite is::........." + empSite);

			String getSalesPerData = " SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER,SALES_PERS "
					+ " WHERE ( ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER(+) ) AND  SALES_PERS.SALES_PERS = ? ";

			rstmt = conn.prepareStatement(getSalesPerData);
			rstmt.setString(1, empCode);

			rrs = rstmt.executeQuery();
			if (rrs.next()) {
				itemSer = rrs.getString("ITEM_SER").trim();
			}
			if (rrs != null) {
				rrs.close();
				rrs = null;
			}
			if (rstmt != null) {
				rstmt.close();
				rstmt = null;
			}

			String param = " SELECT PARM_VALUE  " + " FROM SFAPARM  " + " WHERE ORG_UNIT =?  " + " AND ACTIVE='Y'  "
					+ " AND PARM_NAME='IS_RUSSIA' ";

			rstmt = conn.prepareStatement(param);
			rstmt.setString(1, empSite + "_" + itemSer);
			rrs = rstmt.executeQuery();
			if (rrs.next()) {
				isRussia = rrs.getString(1).trim();
			}
			if (rrs != null) {
				rrs.close();
				rrs = null;
			}
			if (rstmt != null) {
				rstmt.close();
				rstmt = null;
			}
			System.out.println("value of isRussia is::........." + isRussia);
		} catch (Exception e) {
			e.printStackTrace();
		}

		finally {
			try {
				if (rrs != null) {
					rrs.close();
					rrs = null;
				}

				if (rstmt != null) {
					rstmt.close();
					rstmt = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e) {
			}
		}
		return isRussia;
	}

	// Added by Vishakha [11/01/2016] to get IS_RUSSIA flag [end]

}