/*
 * Decompiled with CFR 0.152.
 */
package ibase.system.config;

import ibase.system.config.ConnectionMonitor;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.InfinispanLocal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.InitialContext;

public class StatementMonitor
extends ConnectionMonitor {
    private String connectionId;
    private String statementId;
    private String statementType;
    private String sql;
    private String status;
    private Date startTime;
    private Date endTime;
    private String className;
    private String methodName;
    private int lineNo;
    private String stackTrace;
    SimpleDateFormat dateFormat = new SimpleDateFormat(CommonConstants.APPL_DATETIME_FORMAT);

    static {
        try {
            if (CommonConstants.CACHE_OPT != 0) {
                jndiProperties = new Hashtable();
                jndiProperties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
                ctx = new InitialContext(jndiProperties);
                infinispanLocalObj = (InfinispanLocal)ctx.lookup("ibase/InfinispanEJB/local");
                BaseLogger.log("3", null, null, "StatementMonitor infinispanLocalObj created.....");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in StatementMonitor static block:[" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    public StatementMonitor(String connectionId, String statementId, String statementType, String sql, String status, Date startTime, Date endTime, String className, String methodName, int lineNo, String stackTrace) {
        this.connectionId = connectionId;
        this.statementId = statementId;
        this.statementType = statementType;
        this.sql = sql;
        this.status = status;
        this.startTime = startTime;
        this.endTime = endTime;
        this.className = className;
        this.methodName = methodName;
        this.lineNo = lineNo;
        this.stackTrace = stackTrace;
    }

    @Override
    public String getConnectionId() {
        return this.connectionId;
    }

    @Override
    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public String getStatementId() {
        return this.statementId;
    }

    public void setStatementId(String statementId) {
        this.statementId = statementId;
    }

    public String getStatementType() {
        return this.statementType;
    }

    public void setStatementType(String statementType) {
        this.statementType = statementType;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public int getLineNo() {
        return this.lineNo;
    }

    @Override
    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    @Override
    public String getStackTrace() {
        return this.stackTrace;
    }

    @Override
    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void updateStatementMonitorDetails() {
        try {
            if (CommonConstants.CACHE_OPT != 0 && infinispanLocalObj != null && infinispanLocalObj.containsConnInfo(this.connectionId)) {
                ConnectionMonitor oldConnenctionInfoObj;
                ConnectionMonitor newConnenctionInfoObj = oldConnenctionInfoObj = infinispanLocalObj.getConnInfo(this.connectionId);
                HashMap<String, StatementMonitor> statementMap = oldConnenctionInfoObj.getStatementMap();
                if (statementMap.containsKey(this.statementId)) {
                    if ("clean".equalsIgnoreCase(this.status)) {
                        statementMap.remove(this.statementId);
                    }
                } else {
                    statementMap.put(this.statementId, this);
                }
                newConnenctionInfoObj.setStatementMap(statementMap);
                infinispanLocalObj.putConnInfo(this.connectionId, newConnenctionInfoObj);
                newConnenctionInfoObj = null;
                oldConnenctionInfoObj = null;
                Object var3_4 = null;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in updateStatementMonitorDetails:[" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        String startTime = "";
        String endTime = "";
        if (this.startTime != null) {
            startTime = this.dateFormat.format(this.startTime);
        }
        if (this.endTime != null) {
            endTime = this.dateFormat.format(this.endTime);
        }
        StringBuffer statementMonitorDetailsBuf = new StringBuffer();
        statementMonitorDetailsBuf.append("<sql>");
        statementMonitorDetailsBuf.append("<![CDATA[").append(this.sql).append("]]>");
        statementMonitorDetailsBuf.append("</sql>");
        statementMonitorDetailsBuf.append("<startTime>");
        statementMonitorDetailsBuf.append("<![CDATA[").append(startTime).append("]]>");
        statementMonitorDetailsBuf.append("</startTime>");
        statementMonitorDetailsBuf.append("<endTime>");
        statementMonitorDetailsBuf.append("<![CDATA[").append(endTime).append("]]>");
        statementMonitorDetailsBuf.append("</endTime>");
        statementMonitorDetailsBuf.append("<className>");
        statementMonitorDetailsBuf.append("<![CDATA[").append(this.className).append("]]>");
        statementMonitorDetailsBuf.append("</className>");
        statementMonitorDetailsBuf.append("<methodName>");
        statementMonitorDetailsBuf.append("<![CDATA[").append(this.methodName).append("]]>");
        statementMonitorDetailsBuf.append("</methodName>");
        statementMonitorDetailsBuf.append("<lineNo>");
        statementMonitorDetailsBuf.append("<![CDATA[").append(this.lineNo).append("]]>");
        statementMonitorDetailsBuf.append("</lineNo>");
        statementMonitorDetailsBuf.append("<stackTrace>");
        statementMonitorDetailsBuf.append("<![CDATA[").append(this.stackTrace).append("]]>");
        statementMonitorDetailsBuf.append("</stackTrace>");
        return statementMonitorDetailsBuf.toString();
    }
}

