/*
 * Decompiled with CFR 0.152.
 */
package ibase.scheduler.bean;

import ibase.scheduler.bean.Listener;
import ibase.scheduler.bean.MyTimerMBean;
import ibase.scheduler.utility.ScheduleModel;
import ibase.utility.BaseLogger;
import java.util.Date;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.timer.TimerNotification;
import org.jboss.util.ServiceMBeanSupport;

public class MyTimer
extends ServiceMBeanSupport
implements MyTimerMBean {
    private MBeanServer server;
    private ObjectName timer;
    private long timeout;
    private Object timeoutTimer;
    private Listener listener;

    @Override
    public void init() throws MalformedObjectNameException, InstanceNotFoundException {
        try {
            Set<ObjectInstance> mbeans = this.server.queryMBeans(new ObjectName("DefaultDomain", "service", "timer"), null);
            if (!mbeans.isEmpty()) {
                this.timer = mbeans.iterator().next().getObjectName();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :MyTimer :init :==>\n" + e);
            e.printStackTrace();
        }
    }

    @Override
    public void start(String name, ScheduleModel schModel, Date startDate) throws InstanceNotFoundException, MBeanException, ReflectionException {
        try {
            BaseLogger.log("3", null, null, "Creating Listener...");
            this.listener = new Listener();
            BaseLogger.log("3", null, null, "Registering Listener to MBeanServer..");
            this.server.addNotificationListener(this.timer, this.listener, (NotificationFilter)new Filter(), (Object)schModel);
            BaseLogger.log("3", null, null, "Invoking addNotification with :[" + name + "][][null][" + startDate + "][" + new Long(this.timeout) + "][" + new Long(0L) + "] for type :[" + String.class.getName() + "][" + String.class.getName() + "][java.lang.Object][java.util.Date][" + Long.TYPE.getName() + "][" + Long.TYPE.getName() + "]");
            Object[] objectArray = new Object[6];
            objectArray[0] = name;
            objectArray[1] = "";
            objectArray[3] = startDate;
            objectArray[4] = new Long(this.timeout);
            objectArray[5] = new Long(0L);
            this.timeoutTimer = this.server.invoke(this.timer, "addNotification", objectArray, new String[]{String.class.getName(), String.class.getName(), "java.lang.Object", "java.util.Date", Long.TYPE.getName(), Long.TYPE.getName()});
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :MyTimer :start :==>\n" + e);
            e.printStackTrace();
        }
    }

    @Override
    public void stop(String name) {
        try {
            this.server.removeNotificationListener(this.timer, this.listener);
            this.server.invoke(this.timer, "removeNotifications", new Object[]{name}, new String[]{"java.lang.String"});
        }
        catch (Exception e) {
            System.err.println("Exception :MyTimer :stop :==>\n" + e);
            e.printStackTrace();
        }
    }

    @Override
    public void setTimeout(long seconds) {
        this.timeout = seconds;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    public String getName() {
        return "MyTimer";
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        BaseLogger.log("2", null, null, "objectName in preregister: " + name);
        return super.preRegister(this.server, name);
    }

    class Filter
    implements NotificationFilter {
        Filter() {
        }

        @Override
        public boolean isNotificationEnabled(Notification pNotification) {
            if (pNotification instanceof TimerNotification) {
                TimerNotification lTimerNotification = (TimerNotification)pNotification;
                return lTimerNotification.getNotificationID().equals(MyTimer.this.timeoutTimer);
            }
            return false;
        }
    }
}

