/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility.training.bankIntegration;

import ibase.utility.UserInfoBean;
import ibase.utility.training.bankIntegration.UNSHSBCXML;
import ibase.utility.training.bankIntegration.UnsHsbcTagsPOJO;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BankSpecificXML {
    public static void main(String[] args) {
        UnsHsbcTagsPOJO unsHsbcTagsPOJO = new UnsHsbcTagsPOJO();
        System.out.println(BankSpecificXML.buildXML(unsHsbcTagsPOJO));
    }

    public static String buildXML(UnsHsbcTagsPOJO unsHsbcTagsPOJO) {
        UserInfoBean userInfo = new UserInfoBean();
        UNSHSBCXML unshsbcxml = new UNSHSBCXML();
        unshsbcxml.setUnsHsbcXMLValues(unsHsbcTagsPOJO, userInfo);
        String result = "";
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.newDocument();
            Element rootElement = doc.createElement("Document");
            rootElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
            rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
            doc.appendChild(rootElement);
            Element cstmrCdtTrfInitn = doc.createElement("CstmrCdtTrfInitn");
            rootElement.appendChild(cstmrCdtTrfInitn);
            Element grpHdr = doc.createElement("GrpHdr");
            cstmrCdtTrfInitn.appendChild(grpHdr);
            BankSpecificXML.createElementWithValue(doc, grpHdr, "MsgId", unsHsbcTagsPOJO.getMsgId());
            BankSpecificXML.createElementWithValue(doc, grpHdr, "CreDtTm", unsHsbcTagsPOJO.getCreDtTm());
            Element authstn = doc.createElement("Authstn");
            grpHdr.appendChild(authstn);
            BankSpecificXML.createElementWithValue(doc, authstn, "Cd", "ILEV");
            BankSpecificXML.createElementWithValue(doc, grpHdr, "NbOfTxs", "1");
            BankSpecificXML.createElementWithValue(doc, grpHdr, "CtrlSum", "10.00");
            Element initgPty = doc.createElement("InitgPty");
            grpHdr.appendChild(initgPty);
            Element nm = doc.createElement("Nm");
            initgPty.appendChild(nm);
            nm.appendChild(doc.createTextNode("XSDF Private Limited"));
            Element id = doc.createElement("Id");
            initgPty.appendChild(id);
            Element orgId = doc.createElement("OrgId");
            id.appendChild(orgId);
            Element othr = doc.createElement("Othr");
            orgId.appendChild(othr);
            BankSpecificXML.createElementWithValue(doc, othr, "Id", "ABCXXXXX001");
            Element pmtInf = doc.createElement("PmtInf");
            cstmrCdtTrfInitn.appendChild(pmtInf);
            BankSpecificXML.createElementWithValue(doc, pmtInf, "PmtInfId", "153043");
            BankSpecificXML.createElementWithValue(doc, pmtInf, "PmtMtd", "TRF");
            BankSpecificXML.createElementWithValue(doc, pmtInf, "NbOfTxs", "1");
            BankSpecificXML.createElementWithValue(doc, pmtInf, "CtrlSum", "10.00");
            BankSpecificXML.createElementWithValue(doc, pmtInf, "ReqdExctnDt", "2022-02-04");
            Element dbtr = doc.createElement("Dbtr");
            pmtInf.appendChild(dbtr);
            BankSpecificXML.createElementWithValue(doc, dbtr, "Nm", "Cactus Communications Private Limited");
            Element pstlAdr = doc.createElement("PstlAdr");
            dbtr.appendChild(pstlAdr);
            BankSpecificXML.createElementWithValue(doc, pstlAdr, "StrtNm", "510, Shalimar Morya Park");
            BankSpecificXML.createElementWithValue(doc, pstlAdr, "PstCd", "400053");
            BankSpecificXML.createElementWithValue(doc, pstlAdr, "TwnNm", "Mumbai");
            BankSpecificXML.createElementWithValue(doc, pstlAdr, "CtrySubDvsn", "Maharashtra");
            BankSpecificXML.createElementWithValue(doc, pstlAdr, "Ctry", "IN");
            Element dbtrAcct = doc.createElement("DbtrAcct");
            pmtInf.appendChild(dbtrAcct);
            Element dbtrAcctId = doc.createElement("Id");
            dbtrAcct.appendChild(dbtrAcctId);
            Element dbtrAcctIdOthr = doc.createElement("Othr");
            dbtrAcctId.appendChild(dbtrAcctIdOthr);
            BankSpecificXML.createElementWithValue(doc, dbtrAcctIdOthr, "Id", "006XXXXXXX001");
            BankSpecificXML.createElementWithValue(doc, dbtrAcct, "Ccy", "INR");
            Element dbtrAgt = doc.createElement("DbtrAgt");
            pmtInf.appendChild(dbtrAgt);
            Element finInstId = doc.createElement("FinInstnId");
            dbtrAgt.appendChild(finInstId);
            Element clrSysMmbId = doc.createElement("ClrSysMmbId");
            finInstId.appendChild(clrSysMmbId);
            Element mmbId = doc.createElement("MmbId");
            clrSysMmbId.appendChild(mmbId);
            Element finInstnIdPstlAdr = doc.createElement("PstlAdr");
            finInstId.appendChild(finInstnIdPstlAdr);
            BankSpecificXML.createElementWithValue(doc, finInstnIdPstlAdr, "Ctry", "IN");
            Element cdtTrfTxInf = doc.createElement("CdtTrfTxInf");
            pmtInf.appendChild(cdtTrfTxInf);
            Element pmtId = doc.createElement("PmtId");
            cdtTrfTxInf.appendChild(pmtId);
            BankSpecificXML.createElementWithValue(doc, pmtId, "InstrId", "14511");
            BankSpecificXML.createElementWithValue(doc, pmtId, "EndToEndId", "14511");
            Element pmtTpInf = doc.createElement("PmtTpInf");
            cdtTrfTxInf.appendChild(pmtTpInf);
            Element svcLvl = doc.createElement("SvcLvl");
            pmtTpInf.appendChild(svcLvl);
            BankSpecificXML.createElementWithValue(doc, svcLvl, "Cd", "URNS");
            Element ctgyPurp = doc.createElement("CtgyPurp");
            pmtTpInf.appendChild(ctgyPurp);
            BankSpecificXML.createElementWithValue(doc, ctgyPurp, "Cd", "SUPP");
            Element amt = doc.createElement("Amt");
            cdtTrfTxInf.appendChild(amt);
            HashMap<String, String> attributesForInstdAmt = new HashMap<String, String>();
            attributesForInstdAmt.put("Ccy", "INR");
            BankSpecificXML.createElementWithAttributesAndValue(doc, amt, "InstdAmt", "10.00", attributesForInstdAmt);
            Element cdtrAgt = doc.createElement("CdtrAgt");
            cdtTrfTxInf.appendChild(cdtrAgt);
            Element finInstnId = doc.createElement("FinInstnId");
            cdtrAgt.appendChild(finInstnId);
            Element finInstnIdclrSysMmbId = doc.createElement("ClrSysMmbId");
            finInstnId.appendChild(finInstnIdclrSysMmbId);
            BankSpecificXML.createElementWithValue(doc, finInstnIdclrSysMmbId, "MmbId", "KKBK0000958");
            BankSpecificXML.createElementWithValue(doc, finInstnId, "Nm", "Kotak Mahindra Bank Ltd");
            Element cdtrAgtFinInstnIdPstlAdr = doc.createElement("PstlAdr");
            finInstnId.appendChild(cdtrAgtFinInstnIdPstlAdr);
            BankSpecificXML.createElementWithValue(doc, cdtrAgtFinInstnIdPstlAdr, "Ctry", "IN");
            Element cdtr = doc.createElement("Cdtr");
            cdtTrfTxInf.appendChild(cdtr);
            BankSpecificXML.createElementWithValue(doc, cdtr, "Nm", "PRASHANT HINGAD");
            Element cdtrPstlAdr = doc.createElement("PstlAdr");
            cdtr.appendChild(cdtrPstlAdr);
            BankSpecificXML.createElementWithValue(doc, cdtrPstlAdr, "StrtNm", "B002 NEW GURUKRUPA SOCIETY");
            BankSpecificXML.createElementWithValue(doc, cdtrPstlAdr, "Ctry", "IN");
            Element cdtrId = doc.createElement("Id");
            cdtr.appendChild(cdtrId);
            Element cdtrOrgId = doc.createElement("OrgId");
            cdtrId.appendChild(cdtrOrgId);
            Element orgIdOthr = doc.createElement("Othr");
            cdtrOrgId.appendChild(orgIdOthr);
            BankSpecificXML.createElementWithValue(doc, orgIdOthr, "Id", "CIC01847");
            Element cdtrAcct = doc.createElement("CdtrAcct");
            cdtTrfTxInf.appendChild(cdtrAcct);
            Element cdtrAcctId = doc.createElement("Id");
            cdtrAcct.appendChild(cdtrAcctId);
            Element cdtrAcctIdOthr = doc.createElement("Othr");
            cdtrAcctId.appendChild(cdtrAcctIdOthr);
            BankSpecificXML.createElementWithValue(doc, cdtrAcctIdOthr, "Id", "0012996766");
            BankSpecificXML.createElementWithValue(doc, cdtrAcct, "Nm", "Prashant Hingad");
            Element rltdRmtInf = doc.createElement("RltdRmtInf");
            cdtTrfTxInf.appendChild(rltdRmtInf);
            BankSpecificXML.createElementWithValue(doc, rltdRmtInf, "RmtLctnMtd", "EMAL");
            BankSpecificXML.createElementWithValue(doc, rltdRmtInf, "RmtLctnElctrncAdr", "prashant.hingad@cactusglobal.com");
            Element rmtInf = doc.createElement("RmtInf");
            cdtTrfTxInf.appendChild(rmtInf);
            Element strd = doc.createElement("Strd");
            rmtInf.appendChild(strd);
            Element rfrdDocInf = doc.createElement("RfrdDocInf");
            strd.appendChild(rfrdDocInf);
            BankSpecificXML.createElementWithValue(doc, rfrdDocInf, "Nb", "TEST_PRASHANT");
            BankSpecificXML.createElementWithValue(doc, rfrdDocInf, "RltdDt", "2022-01-24");
            Element cdtrRefInf = doc.createElement("CdtrRefInf");
            strd.appendChild(cdtrRefInf);
            Element tp = doc.createElement("Tp");
            cdtrRefInf.appendChild(tp);
            Element cdOrPrtry = doc.createElement("CdOrPrtry");
            tp.appendChild(cdOrPrtry);
            BankSpecificXML.createElementWithValue(doc, cdOrPrtry, "Prtry", "/AMNT/10.00");
            BankSpecificXML.createElementWithValue(doc, cdtrRefInf, "Ref", "/TDSA/0");
            BankSpecificXML.createElementWithValue(doc, strd, "AddtlRmtInf", "/NAMT/10.00");
            result = BankSpecificXML.getStringFromDocument(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String getStringFromDocument(Document doc) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource domSource = new DOMSource(doc);
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            transformer.transform(domSource, sr);
            return sw.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void createElementWithValue(Document doc, Element parent, String tagName, String textContent) {
        Element element = doc.createElement(tagName);
        element.appendChild(doc.createTextNode(textContent));
        parent.appendChild(element);
    }

    private static void createElementWithAttributesAndValue(Document doc, Element parent, String tagName, String textContent, Map<String, String> attributes) {
        Element element = doc.createElement(tagName);
        element.appendChild(doc.createTextNode(textContent));
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                element.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        parent.appendChild(element);
    }
}

