package ibase.webitm.utility.wsfa;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.naming.InitialContext;

import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.wsfa.transactions.StrgMeetDCRWizard;
import ibase.webitm.utility.ITMException;

public class StockTransactionCreation extends ValidatorEJB
{

	public JSONObject transactionCreation(String locCode,String aproverEmpCode,String empCodeAprv,String siteCode,String dcrID, String loadNo, String vehicleNo,Connection conn) throws ITMException
	{
		System.out.println("transactionCreation method of StockTransactionCreation java compoent["+locCode+"]");
		PreparedStatement pstmt=null;
		
		ResultSet rs=null;
		JSONObject obj = new JSONObject();
		String returnString="";
		try
		{
			if ( getUserInfo() == null )
			{
				CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
				setUserInfo( commonDBAccessEJB.createUserInfo( empCodeAprv ) );
			}
			java.util.Date date = Calendar.getInstance().getTime();
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			String currentDate = dtFormat.format( date );
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext initialContext = new InitialContext(appConnect.getProperty());
			String itemSer="",itemSerDescr="",siteCodeDescr="";
			String sql="SELECT SP.ITEM_SER,I.DESCR FROM SALES_PERS SP,ITEMSER I  WHERE SP.SALES_PERS=? AND SP.ITEM_SER=I.ITEM_SER";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, locCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				itemSer=checkNull(rs.getString("ITEM_SER"));
				itemSerDescr=checkNull(rs.getString("DESCR"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("transactionCreation method of StockTransactionCreation java itemSer["+itemSer+"]");

			String siteSql="SELECT DESCR FROM SITE WHERE SITE_CODE=?";
			pstmt = conn.prepareStatement(siteSql);
			pstmt.setString(1, siteCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				siteCodeDescr=checkNull(rs.getString("DESCR"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("transactionCreation method of StockTransactionCreation java siteCodeDescr["+siteCodeDescr+"]");

			/*--Commented and changed by Gulzar on 03MAR2024 as load no getting passed wrong.
			//String vehicleNo="",loadNo="";
			String eventDate="";

			String sprsSql="SELECT EVENT_DATE AS EVENT_DATE,SALES_PERS AS SALES_PERS FROM SPRS_ACT_TRAN WHERE DCR_ID=? ";
			pstmt =  conn.prepareStatement(sprsSql);
			pstmt.setString(1, dcrID);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				eventDate=checkNull(rs.getString("EVENT_DATE"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("transactionCreation method of StockTransactionCreation java eventDate["+eventDate+"]");

			String maxDaySummDate="";
			if(eventDate != null && eventDate.trim().length() > 0) 
			{
				String daySummMaxSQL="SELECT MAX(EVENT_DATE)AS MAX_DAY_SUMM_DATE FROM SPRS_DAY_SUMM WHERE SALES_PERS=? AND EVENT_DATE<=? ";
				pstmt =  conn.prepareStatement(daySummMaxSQL);
				pstmt.setString(1, locCode);
				pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(eventDate));
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					maxDaySummDate=checkNull(rs.getString("MAX_DAY_SUMM_DATE"));
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}

			System.out.println("transactionCreation method of StockTransactionCreation java maxDaySummDate["+maxDaySummDate+"]");
			
			if(maxDaySummDate != null && maxDaySummDate.trim().length() > 0) 
			{
				String daySummSql="SELECT SDA.LOAD_NO AS LOAD_NO,SDA.VEH_NO AS VEHICLE_NO FROM SPRS_DAY_SUMM SDA WHERE TRIM(SDA.SALES_PERS)=TRIM(?) AND SDA.EVENT_DATE=?";
				pstmt =  conn.prepareStatement(daySummSql);
				pstmt.setString(1, locCode);
				pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(maxDaySummDate));
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					vehicleNo = checkNull(rs.getString("VEHICLE_NO"));
					loadNo = checkNull(rs.getString("LOAD_NO"));

				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			*/
			//End Changes by gulzar
			String locationCodeTo="",locationCodeToDescr="";

			
			String locCodeToSql="SELECT LOC_CODE,DESCR FROM LOCATION WHERE SITE_CODE=? AND LOC_TYPE='DP'";
			pstmt =  conn.prepareStatement(locCodeToSql);
			pstmt.setString(1, siteCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				locationCodeTo = checkNull(rs.getString("LOC_CODE"));
				locationCodeToDescr = checkNull(rs.getString("DESCR"));

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
				
			System.out.println("transactionCreation method of StockTransactionCreation java vehicleNo["+vehicleNo+"]");
			String objContext="1";
			StringBuffer processDynXmlString=new StringBuffer();
			processDynXmlString.append("<DocumentRoot><description>Datawindow Root</description><group0>");
			processDynXmlString.append("<description>Group0 description</description><Header0><description>Header0 members</description>");
			processDynXmlString.append("<objName><![CDATA[stock_transfer]]></objName>");
			processDynXmlString.append("<pageContext><![CDATA[1]]></pageContext>");
			processDynXmlString.append("<objContext><![CDATA[1]]></objContext>");
			processDynXmlString.append("<editFlag><![CDATA[A]]></editFlag>");
			processDynXmlString.append("<focusedColumn><![CDATA[]]></focusedColumn>");
			processDynXmlString.append("<action><![CDATA[SAVE]]></action>");
			processDynXmlString.append("<elementName><![CDATA[]]></elementName>");
			processDynXmlString.append("<keyValue><![CDATA[1]]></keyValue>");
			processDynXmlString.append("<taxKeyValue><![CDATA[]]></taxKeyValue>");
			processDynXmlString.append("<saveLevel><![CDATA[1]]></saveLevel>");
			processDynXmlString.append("<forcedSave><![CDATA[false]]></forcedSave>");
			processDynXmlString.append("<taxInFocus><![CDATA[false]]></taxInFocus>");
			processDynXmlString.append("<Detail1 dbID='' domID='1'  objContext='"+objContext+"'  objName='stock_transfer'>");
			processDynXmlString.append("<attribute IS_CHANGE='Y' pkNames='' selected='N' status='N' updateFlag='A'/>");
			processDynXmlString.append("<tran_id><![CDATA[]]></tran_id>");
			processDynXmlString.append("<tran_date><![CDATA[").append( currentDate ).append("]]></tran_date>");
			processDynXmlString.append("<site_code><![CDATA[").append( siteCode ).append("]]></site_code>");
			processDynXmlString.append("<ref_ser__for><![CDATA[").append("XFRX").append("]]></ref_ser__for>");
			processDynXmlString.append("<ref_id__for><![CDATA[").append( loadNo ).append("]]></ref_id__for>");
			processDynXmlString.append("<reas_code><![CDATA[").append( "R05" ).append("]]></reas_code>");
			processDynXmlString.append("<item_ser><![CDATA[").append(itemSer).append("]]></item_ser>");
			processDynXmlString.append("<confirmed><![CDATA[").append( "N" ).append("]]></confirmed>");
			processDynXmlString.append("<conf_date><![CDATA[]]></conf_date>");
			processDynXmlString.append("<emp_code__aprv><![CDATA[").append(aproverEmpCode).append("]]></emp_code__aprv>");
			processDynXmlString.append("<chg_date><![CDATA[").append(currentDate).append("]]></chg_date>");
			processDynXmlString.append("<chg_term><![CDATA[").append("SYSTEM").append("]]></chg_term>");
			processDynXmlString.append("<chg_user><![CDATA[").append(empCodeAprv).append("]]></chg_user>");
			processDynXmlString.append("<site_descr><![CDATA[").append(siteCodeDescr).append("]]></site_descr>");
			processDynXmlString.append("<full_name><![CDATA[").append("").append("]]></full_name>");
			processDynXmlString.append("<tran_type><![CDATA[").append("I").append("]]></tran_type>");
			processDynXmlString.append("<truck_no><![CDATA[").append(vehicleNo).append("]]></truck_no>");
			processDynXmlString.append("<ref_date><![CDATA[").append(currentDate).append("]]></ref_date>");
			processDynXmlString.append("<descr><![CDATA[").append(itemSerDescr).append("]]></descr>");			
			processDynXmlString.append("</Detail1>");
			
			int lineNo=1;
			int quantity=0;
			int noart=2;
			int detailCnt = 0;
			String lotNoFr="",lotSlFr="",itemCode="",itemDecsr="";
			String stockSql="SELECT S.QUANTITY,S.LOT_NO,S.LOT_SL,S.ITEM_CODE,I.DESCR AS ITEM_DESCR ,L.DESCR AS LOC_FR FROM STOCK S ,ITEM I,LOCATION L " + 
					"WHERE  S.LOC_CODE= ? AND S.ITEM_CODE=I.ITEM_CODE AND S.LOC_CODE=L.LOC_CODE AND I.ITEM_SER=? AND S.SITE_CODE=? AND S.QUANTITY > 0 ";
			pstmt =  conn.prepareStatement(stockSql);
			pstmt.setString(1, locCode);
			pstmt.setString(2, itemSer);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				detailCnt = detailCnt+1;
				quantity = rs.getInt("QUANTITY");
				lotNoFr = rs.getString("LOT_NO");
				lotSlFr = rs.getString("LOT_SL");
				itemCode = checkNull(rs.getString("ITEM_CODE"));
				itemDecsr = checkNull(rs.getString("ITEM_DESCR"));

				System.out.println("transactionCreation objContext String["+objContext+"]Integer.parseInt(objContext.trim())["+Integer.parseInt(objContext.trim())+"]lotSlFr["+lotSlFr+"]itemCode["+itemCode+"]itemDecsr["+itemDecsr+"]");
				
				objContext="2";
				processDynXmlString.append("<Detail2 dbID='' domID='"+lineNo+"'  objContext='"+objContext+"'  objName='stock_transfer'>");
				processDynXmlString.append("<attribute IS_CHANGE='Y' pkNames='' selected='N' status='N' updateFlag='A'/>");
				processDynXmlString.append("<tran_id><![CDATA[]]></tran_id>");
				processDynXmlString.append("<line_no><![CDATA[").append( lineNo ).append("]]></line_no>");
				processDynXmlString.append("<item_code><![CDATA[").append( itemCode ).append("]]></item_code>");
				processDynXmlString.append("<quantity><![CDATA[").append(quantity).append("]]></quantity>");
				processDynXmlString.append("<loc_code__fr><![CDATA[").append(locCode ).append("]]></loc_code__fr>");
				processDynXmlString.append("<loc_code__to><![CDATA[").append( locationCodeTo ).append("]]></loc_code__to>");
				processDynXmlString.append("<lot_no__fr><![CDATA[").append(lotNoFr).append("]]></lot_no__fr>");
				processDynXmlString.append("<lot_no__to><![CDATA[").append(lotNoFr).append("]]></lot_no__to>");
				processDynXmlString.append("<lot_sl__fr><![CDATA[").append(lotSlFr).append("]]></lot_sl__fr>");
				processDynXmlString.append("<lot_sl__to><![CDATA[").append(lotSlFr).append("]]></lot_sl__to>");
				processDynXmlString.append("<remarks><![CDATA[]]></remarks>");
				processDynXmlString.append("<acct_code__cr><![CDATA[").append("LDMY01").append("]]></acct_code__cr>");
				processDynXmlString.append("<acct_code__dr><![CDATA[").append("LDMY01").append("]]></acct_code__dr>");
				processDynXmlString.append("<cctr_code__dr><![CDATA[").append("LDMY").append("]]></cctr_code__dr>");
				processDynXmlString.append("<cctr_code__cr><![CDATA[").append("LDMY").append("]]></cctr_code__cr>");
				processDynXmlString.append("<item_descr><![CDATA[").append(itemDecsr).append("]]></item_descr>");
				processDynXmlString.append("<loc_descr__to><![CDATA[").append(locationCodeToDescr).append("]]></loc_descr__to>");
				processDynXmlString.append("<no_art><![CDATA[").append(noart).append("]]></no_art>");			
				processDynXmlString.append("</Detail2>");
				
				lineNo++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			processDynXmlString.append("</Header0></group0></DocumentRoot>");
			System.out.println("No data found in Stock. Details not created detailCnt =["+detailCnt+"]");
			
			if(detailCnt > 0)
			{
				String XmlString = processDynXmlString.toString();
				System.out.println("transactionCreation method of StockTransactionCreation java XmlString["+XmlString+"]getUserInfo()["+getUserInfo()+"]");
				
				MasterStatefulLocal masterStateful = (MasterStatefulLocal)initialContext.lookup("ibase/MasterStatefulEJB/local");
				returnString = masterStateful.processRequest( getUserInfo(), XmlString, false, conn);
				System.out.println("returnString:::::123"+returnString);
				if(!returnString.contains("Errors") || ! returnString.contains("errors"))
				{
					if(returnString != null && returnString.trim().length()!=0)
					{
						E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
						Document dom3 = genericUtility.parseString(returnString);
						String tranid = genericUtility.getColumnValue("TranID", dom3);
						System.out.println("tranid dom3 date ["+tranid+"] ");
						obj = getvantowarhouseJson(tranid,conn, loadNo);
					}
				}
				//System.out.println("vanstock json :: "+obj.toString());
				if(obj != null && obj.toString().equalsIgnoreCase("{}"))
				{
					return null;
				}
				else
				{
					return obj;
				}
			}
			else
			{
				System.out.println("No data found in Stock. Details not created");
				obj = null;
			}
		}
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		finally 
		{
			try 
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
	    }
		return obj;
	}

	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	
	public JSONObject getvantowarhouseJson(String tranid, Connection conn, String loadNo) throws ITMException 
	{
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		JSONObject obj = new JSONObject();
		JSONArray VanStockArray = new JSONArray();

		try 
		{
			StrgMeetDCRWizard strgMeetDCRWizard=new StrgMeetDCRWizard();
			String companyDB = strgMeetDCRWizard.getSfaParmValue("ALL","API_DB_NAME_VAL",conn);
			String userNameDB = strgMeetDCRWizard.getSfaParmValue("ALL","API_DB_USER_VAL",conn);
			String passwordDB = strgMeetDCRWizard.getSfaParmValue("ALL","API_DB_PASS_VAL",conn);
			
			int counter = 1;
			int itemLine=0;

			String vanSql = "SELECT ST.TRAN_DATE,LOC_FROM.LOC_GROUP AS FROM_WARE_HOUSE,LOC_TO.LOC_GROUP AS TO_WARE_HOUSE,ST.TRAN_ID," + 
					"STD.ITEM_CODE,ITEM.DESCR AS ITEM_DESCR,STD.LOT_NO__FR AS BATCH,STD.QUANTITY,LOC_FROM.LOC_PHY_AREA AS FR_BIN," + 
					"2 AS FR_BIN_ACTION,LOC_TO.LOC_PHY_AREA AS TO_BIN,1 AS TO_BIN_ACTION FROM stock_transfer ST,STOCK_TRANSFER_DET STD," + 
					"LOCATION LOC_FROM,LOCATION LOC_TO,ITEM ITEM WHERE ST.TRAN_ID=STD.TRAN_ID AND ST.TRAN_ID =? AND ITEM.ITEM_CODE=STD.ITEM_CODE AND LOC_FROM.LOC_CODE=STD.LOC_CODE__FR AND LOC_TO.LOC_CODE=LOC_CODE__TO";
			System.out.println("inside vanstocksql ::"+vanSql);
			pstmt = conn.prepareStatement(vanSql);
			pstmt.setString(1, tranid);
			rs = pstmt.executeQuery();
			while(rs.next()) 
			{
				String tranDate= (rs.getDate("TRAN_DATE")).toString();
				String locGroupFrom = rs.getString("FROM_WARE_HOUSE");
				String locGroupTo = rs.getString("TO_WARE_HOUSE");
				//String tranID = rs.getString("TRAN_ID");
				String itemCodeVan = rs.getString("ITEM_CODE");
				String itemDescr = rs.getString("ITEM_DESCR");
				String batch = rs.getString("BATCH");
				double quantityVan = rs.getDouble("QUANTITY");
				String binAbsEntryFrom = rs.getString("FR_BIN");
				int frBinAction = rs.getInt("FR_BIN_ACTION");
				String binAbsEntryTo = rs.getString("TO_BIN");
				int toBinAction = rs.getInt("TO_BIN_ACTION");
				
				JSONObject BinAllocationObj = new JSONObject();
				JSONObject BatchNumbersObj = new JSONObject();
				JSONObject VanStockObj = new JSONObject();
				
				JSONArray BinAllocationArray = new JSONArray();
				JSONArray BatchNumbersArray = new JSONArray();
				if(counter == 1)
				{
					/*obj.put("CompanyDB", "Z_LBCP_MOB_APP");
					obj.put("Password", "Sap@1234");
					obj.put("UserName", "manager");*/
					
					obj.put("CompanyDB", companyDB);
					obj.put("Password", passwordDB);
					obj.put("UserName", userNameDB);
					
					obj.put("DocDate",tranDate);
					obj.put("FromWarehouse", locGroupFrom);
					obj.put("ToWarehouse",locGroupTo);
					obj.put("U_SOM", "M");
					obj.put("U_MTID", tranid);
					obj.put("U_MLDN", loadNo);
				}
				
				VanStockObj.put("LineNum", itemLine);
				VanStockObj.put("ItemCode", itemCodeVan);
				VanStockObj.put("ItemDescription", itemDescr);
				VanStockObj.put("Quantity", quantityVan);
				
				BatchNumbersObj.put("BatchNumber", batch);
				BatchNumbersObj.put("Quantity", quantityVan);
				BatchNumbersObj.put("BaseLineNumber", itemLine);
				BatchNumbersObj.put("ItemCode",itemCodeVan);
				
				BatchNumbersArray.put(BatchNumbersObj);
				VanStockObj.put("BatchNumbers",BatchNumbersArray);
				
				BinAllocationObj.put("BinAbsEntry",binAbsEntryFrom);
				BinAllocationObj.put("Quantity", quantityVan);
				BinAllocationObj.put("SerialAndBatchNumbersBaseLine", itemLine);
				BinAllocationObj.put("BinActionType", frBinAction);
				BinAllocationObj.put("BaseLineNumber",itemLine);
				
				BinAllocationArray.put(BinAllocationObj);
								
				VanStockObj.put("StockTransferLinesBinAllocations", BinAllocationArray);
				VanStockArray.put(VanStockObj);
				obj.put("StockTransferLines", VanStockArray);
				counter++;
				itemLine++;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("vantowarhouse json :: "+obj.toString());
			if(obj.toString().equalsIgnoreCase("{}"))
			{
				return null;
			}
			else
			{
				return obj;
			}

		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}

			} 
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
	}

}