/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import com.sybase.jaguar.management.jdk12utils.ArrayList;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.Messages;
import ibase.webitm.ejb.ValidatorLocal;
import ibase.webitm.ejb.ValidatorRemote;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class ValidatorEJB
implements ValidatorRemote,
ValidatorLocal {
    protected static String DB_NAME = null;
    private UserInfoBean userInfo = null;
    public String createId = null;
    public String activateId = null;
    public String XTRAParamUserId = null;
    private String winName = "";
    private String columnValue = "";
    protected static HashMap USER_DEFINED_VALUE_MAP = null;
    public Connection conn = null;
    private HashMap isFormModifiedDataList = new HashMap();
    private ArrayList errList = new ArrayList();
    private ArrayList errFields = new ArrayList();
    private String objName = "";
    public String formName = "";
    @Resource
    private SessionContext cSessionContext;

    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    @Override
    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
        BaseLogger.log("2", userInfo, null, "ValidatorEJB.setUserInfo() : user Id : [" + this.userInfo.getLoginCode() + "]\n" + "Create Id [" + this.createId + "] ActivateId :[" + this.activateId + "]");
    }

    public void setXTRAParamUser(String userId) {
        this.XTRAParamUserId = userId;
    }

    public ValidatorEJB() {
        try {
            this.userInfo = null;
            this.createId = "C" + ValidatorEJB.generateRandomString();
            BaseLogger.log("1", this.userInfo, null, "Creating EJB...");
            BaseLogger.log("1", this.userInfo, null, "Calling CommonConstants.setIBASEHOME()..........");
            if (CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0) {
                CommonConstants.setIBASEHOME();
            }
            DB_NAME = CommonConstants.DB_NAME;
            if (USER_DEFINED_VALUE_MAP == null) {
                BaseLogger.log("1", this.userInfo, null, "Initailizing HashMap...........");
                USER_DEFINED_VALUE_MAP = new HashMap();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :ValidatorEJB :ejbCreate :==>" + e);
            e.printStackTrace();
        }
        BaseLogger.log("1", this.userInfo, null, "ValidatorEJB Constructor ");
    }

    @PostConstruct
    public void ejbCreate() {
        try {
            this.userInfo = null;
            this.createId = "C" + ValidatorEJB.generateRandomString();
            BaseLogger.log("3", this.userInfo, null, "Creating EJB...");
            BaseLogger.log("3", this.userInfo, null, "Calling CommonConstants.setIBASEHOME()..........");
            if (CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0) {
                CommonConstants.setIBASEHOME();
            }
            DB_NAME = CommonConstants.DB_NAME;
            if (USER_DEFINED_VALUE_MAP == null) {
                BaseLogger.log("3", this.userInfo, null, "Initailizing HashMap...........");
                USER_DEFINED_VALUE_MAP = new HashMap();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :ValidatorEJB :ejbCreate :==>" + e);
            e.printStackTrace();
        }
        BaseLogger.log("2", this.userInfo, null, "ValidatorEJB Created ");
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
        BaseLogger.log("2", this.userInfo, null, "ValidatorEJB.ejbActivate()");
        this.userInfo = null;
        this.activateId = "A" + ValidatorEJB.generateRandomString();
    }

    public void ejbPassivate() {
    }

    @Override
    public boolean isError(String msgNo) throws RemoteException, ITMException {
        Connection conn = null;
        Statement stmt1 = null;
        ResultSet rs1 = null;
        String msgType = "";
        boolean checkNext = true;
        try {
            try {
                conn = this.getConnection();
                stmt1 = conn.createStatement();
                rs1 = stmt1.executeQuery("SELECT MSG_TYPE,MSG_NO FROM MESSAGES WHERE MSG_NO='" + msgNo + "'");
                if (rs1.next()) {
                    msgType = rs1.getString(1);
                }
                if (msgType == null || msgType.length() == 0) {
                    msgType = "E";
                }
                checkNext = msgType.trim().equals("E");
                rs1.close();
                stmt1.close();
                conn.close();
            }
            catch (ITMException itme) {
                BaseLogger.log("0", this.userInfo, null, "ITMException : [ValidatorEJB][isError] :==>\n");
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorEJB][isError] :==>\n" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (rs1 != null) {
                        rs1.close();
                        rs1 = null;
                    }
                    if (stmt1 != null) {
                        stmt1.close();
                        stmt1 = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException se) {
                BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorNEJB][isCctrCode] :==>\n" + se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
        }
        return checkNext;
    }

    public boolean isError(Connection con, String msgNo) throws RemoteException, ITMException {
        Statement stmt1 = null;
        ResultSet rs1 = null;
        String msgType = "";
        boolean checkNext = true;
        try {
            try {
                stmt1 = con.createStatement();
                rs1 = stmt1.executeQuery("SELECT MSG_TYPE,MSG_NO FROM MESSAGES WHERE MSG_NO='" + msgNo + "'");
                if (rs1.next()) {
                    msgType = rs1.getString(1);
                }
                if (msgType == null || msgType.length() == 0) {
                    msgType = "E";
                }
                checkNext = msgType.trim().equals("E");
                rs1.close();
                stmt1.close();
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorEJB][isError] :==>\n" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
            }
            catch (SQLException se) {
                BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorNEJB][isCctrCode] :==>\n" + se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
        }
        return checkNext;
    }

    @Override
    public String buildErrorString(String xmlString) throws RemoteException, ITMException {
        StringBuffer errXmlString = new StringBuffer();
        try {
            errXmlString.append("<?xml version=\"1.0\"?><Root>\r\n<Errors>\r\n");
            errXmlString.append(xmlString);
            errXmlString.append("</Errors>\r\n</Root>");
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorEJB][buildErrorString] :==>\n" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errXmlString.toString();
    }

    public String getErrorString(String columnName, String msgNo, String userId, String columnValue, String winName) throws RemoteException, ITMException {
        this.winName = winName;
        this.columnValue = columnValue;
        return this.getErrorString(columnName, msgNo, userId);
    }

    public String getErrorString(String columnName, String msgNo, String userId) throws RemoteException, ITMException {
        Connection conn = null;
        Statement stmt = null;
        Statement stmt1 = null;
        Statement pStmt = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        String msgType = "";
        String msgString = "";
        String msgDescription = "";
        String lmsgString = "";
        String profileId = "";
        String errSource = "";
        String tempMsgType = "";
        String msgOption = "";
        String msgTime = "";
        String redirerr = "";
        String soundPlay = "";
        try {
            try {
                conn = this.getConnection();
                String sqlQuery = "SELECT MSG_TYPE,MSG_STR,MSG_DESCR,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE FROM MESSAGES WHERE MSG_NO='" + msgNo + "'";
                stmt = conn.prepareStatement(sqlQuery);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    msgType = rs.getString("MSG_TYPE");
                    msgString = rs.getString("MSG_STR");
                    msgDescription = rs.getString("MSG_DESCR");
                    errSource = rs.getString("ERR_SOURCE");
                    msgOption = rs.getString("MSG_OPT");
                    msgTime = rs.getString("MSG_TIME");
                    soundPlay = rs.getString("ALARM");
                } else {
                    lmsgString = "Message Not Defined >>" + msgNo;
                    msgDescription = String.valueOf(Messages.getString("ValidatorEJB_messageIdNotFound")) + " [" + msgNo + "]";
                    msgType = "E";
                    msgString = "";
                }
                if (msgType.equals("E") || msgType.trim().length() == 0) {
                    String sqlQuery1 = "SELECT PROFILE_ID FROM USERS WHERE CODE='" + userId + "'";
                    stmt1 = conn.prepareStatement(sqlQuery1);
                    rs1 = stmt1.executeQuery();
                    if (rs1.next()) {
                        profileId = rs1.getString("profile_id");
                        if (profileId == null) {
                            profileId = "";
                        }
                        if ((rs2 = (pStmt = conn.prepareStatement(sqlQuery1 = "SELECT MSG_TYPE FROM MESSAGES_LEVEL WHERE MSG_NO='" + msgNo.trim() + "' AND ( PROFILE_ID='" + profileId.trim() + "' OR PROFILE_ID = 'X' )")).executeQuery()).next()) {
                            tempMsgType = rs2.getString("msg_type");
                        }
                        rs2.close();
                    }
                    if (tempMsgType != null && tempMsgType.trim().length() > 0) {
                        msgType = tempMsgType;
                    }
                }
                if (msgType.equals("W")) {
                    msgString = "Warning : " + msgString;
                } else if (msgType.equals("P")) {
                    msgString = "Prompt : " + msgString;
                } else if (msgType.equals("F")) {
                    msgString = "Information : " + msgString;
                } else {
                    msgType = "E";
                    msgString = "Error : " + msgString;
                }
                if (errSource != null && errSource.trim().equals("D")) {
                    msgDescription = String.valueOf(msgDescription) + " * From Database ";
                }
                if (redirerr == null || redirerr.trim().length() == 0) {
                    redirerr = "1";
                }
                if (msgOption != null && msgOption.trim().equals("M")) {
                    redirerr = redirerr.trim().equals("1") ? "2" : "1";
                }
                if (rs != null) {
                    rs.close();
                    stmt.close();
                }
                if (rs1 != null) {
                    rs1.close();
                    stmt1.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                conn.close();
            }
            catch (ITMException itme) {
                BaseLogger.log("0", this.userInfo, null, "ITMException : [ValidatorEJB][getErrorString] :==>\n" + itme.getMessage());
                throw itme;
            }
            catch (SQLException se) {
                lmsgString = "Database Error >>" + se.getErrorCode();
                msgDescription = se.getMessage();
                msgType = "";
                msgString = "";
                BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorEJB][getErrorString] :==>\n" + se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorEJB][getErrorString] :==>\n" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException se) {
                lmsgString = "Database Error >>" + se.getErrorCode();
                msgDescription = se.getMessage();
                msgType = "";
                msgString = "";
                BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorNEJB][getErrorString] :==>\n" + se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
        }
        StringBuffer errStringXml = new StringBuffer();
        errStringXml.append("<?xml version=\"1.0\"?>\r\n<Root><Errors>\r\n");
        errStringXml.append("<error id=\"");
        errStringXml.append(msgNo).append("\" type=\"").append(msgType).append("\" column_value=\"").append(this.columnValue);
        errStringXml.append("\" column_name=\"").append(columnName).append("\">\r\n");
        errStringXml.append("<message><![CDATA[ " + msgString + "]]></message>");
        errStringXml.append("<description><![CDATA[" + msgDescription + "]]></description>");
        errStringXml.append("<type><![CDATA[" + msgType + "]]></type>");
        errStringXml.append("<time><![CDATA[" + msgTime + "]]></time>");
        errStringXml.append("<alarm><![CDATA[" + soundPlay + "]]></alarm>");
        errStringXml.append("<source><![CDATA[" + errSource + "]]></source>");
        errStringXml.append("<trace><![CDATA[]]></trace>");
        errStringXml.append("<redirect><![CDATA[" + redirerr + "]]></redirect>");
        errStringXml.append("</error>").append("</Errors></Root>");
        return errStringXml.toString();
    }

    public Document parseString(String xmlString) throws RemoteException, ITMException {
        Document dom1 = null;
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            xmlString = genericUtility.setXmlDec(xmlString);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, CommonConstants.ENCODING);
            ByteArrayInputStream baos = new ByteArrayInputStream(xmlString.getBytes(CommonConstants.ENCODING));
            dom1 = db.parse(baos);
        }
        catch (Exception e) {
            dom1 = null;
            BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorEJB][parseString] :==>\n" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return dom1;
    }

    public String getColumnValue(String colName, Document dom) throws RemoteException, ITMException {
        String colValue = "";
        try {
            colValue = this.getColumnValue(colName, dom, "1");
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorEJB][getColumnValue(1)] :==>\n");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorEJB][getColumnValue(1)] :==>\n" + e.getMessage());
        }
        return colValue;
    }

    public String getColumnValue(String colName, Document dom, String formNo) throws RemoteException, ITMException {
        Node elementName = null;
        Node parentNode = null;
        NodeList elementList = null;
        Element elementAttr = null;
        String columnName = "";
        String columnValue = null;
        boolean continueLoop = true;
        boolean isFormNo = false;
        try {
            elementList = dom.getElementsByTagName(colName);
            if (Integer.parseInt(formNo) < 1) {
                isFormNo = true;
            }
            int ctr = 0;
            while (ctr < elementList.getLength()) {
                elementName = elementList.item(ctr);
                parentNode = elementName.getParentNode();
                elementAttr = (Element)parentNode;
                if (elementAttr.getAttribute("objContext").equals(formNo) || isFormNo) {
                    columnName = elementName.getNodeName();
                    columnValue = "";
                    columnValue = elementName.getFirstChild() != null ? elementName.getFirstChild().getNodeValue().trim() : null;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorEJB][getColumnValue(2)] :==>\n" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return columnValue;
    }

    @Override
    public String getColumnValue(String colName, Document dom, String formNo, String domID) throws RemoteException, ITMException {
        BaseLogger.log("2", this.userInfo, null, "Getting column value for column :" + colName + ": formNo :" + formNo + ": domID :" + domID);
        Node elementName = null;
        Node parentNode = null;
        NodeList elementList = null;
        Element elementAttr = null;
        String columnName = "";
        String columnValue = null;
        boolean continueLoop = true;
        boolean isFormNo = false;
        try {
            elementList = dom.getElementsByTagName(colName);
            if (Integer.parseInt(formNo) < 1) {
                isFormNo = true;
            }
            BaseLogger.log("3", this.userInfo, null, "No. of  :" + elementList.getLength());
            int ctr = 0;
            while (ctr < elementList.getLength()) {
                elementName = elementList.item(ctr);
                parentNode = elementName.getParentNode();
                elementAttr = (Element)parentNode;
                if (elementAttr.getAttribute("objContext").equals(formNo) && elementAttr.getAttribute("domID").equals(domID) || isFormNo) {
                    columnName = elementName.getNodeName();
                    columnValue = "";
                    columnValue = elementName.getFirstChild() != null ? elementName.getFirstChild().getNodeValue().trim() : null;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorEJB][getColumnValue(2)] :==>\n" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "Returning column value :" + columnValue);
        return columnValue;
    }

    public Connection getConnection() throws RemoteException, ITMException {
        Connection conn = null;
        ConnDriver connDriver = new ConnDriver();
        try {
            BaseLogger.log("3", this.userInfo, null, " In ValidatorEJB :: getConnection() :: [" + this.userInfo + "]");
            if (this.userInfo != null) {
                if (this.XTRAParamUserId != null && !this.XTRAParamUserId.equalsIgnoreCase(this.userInfo.getLoginCode())) {
                    BaseLogger.log("3", this.userInfo, null, "ValidatorEJB.getConnection()");
                    Exception exp = new Exception("createId : [" + this.createId + "] ActivateId [" + this.activateId + "]" + " UserInfo.userId [" + this.userInfo.getLoginCode() + "] XTRAParam.UserId [" + this.XTRAParamUserId + "]");
                    exp.printStackTrace();
                } else {
                    BaseLogger.log("3", this.userInfo, null, "ValidatorEJB.getConnection() : userInfo.loginCode [" + this.userInfo.getLoginCode() + "]" + " loginCode xtraParam [" + this.XTRAParamUserId + "]");
                }
            } else {
                BaseLogger.log("3", this.userInfo, null, " ValidatorEJB :: UserInfo is null :: So that creating connection using Driver....");
                throw new ITMException(new Exception("UserInfo is null."));
            }
            String transDB = this.userInfo.getTransDB();
            BaseLogger.log("3", this.userInfo, null, " ValidatorEJB getConnection :: transDB :: [" + transDB + "] \nUser :: [" + this.userInfo.getLoginCode() + "]");
            conn = connDriver.getConnectDB(this.userInfo);
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorEJB][getConnection] :==>\n" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return conn;
    }

    public java.util.Date getDateObject(String date) throws RemoteException, ITMException {
        java.util.Date dat = null;
        Object df = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.getApplDateFormat());
            dat = simpleDateFormat.parse(date);
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :ValidatorEJB :getDateObject :==>\n" + e.getMessage());
        }
        return dat;
    }

    public String getApplDateFormat() throws ITMException, Exception {
        String dateFormatStr = null;
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            dateFormatStr = genericUtility.getApplDateFormat();
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :ValidatorEJB :getApplDateFormat :==>\n" + e);
            throw new ITMException(e);
        }
        return dateFormatStr;
    }

    public String getDBDateFormat() throws ITMException, Exception {
        String dateFormatStr = null;
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            dateFormatStr = genericUtility.getDBDateFormat();
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :ValidatorEJB :getDBDateFormat :==>\n" + e);
            throw new ITMException(e);
        }
        return dateFormatStr;
    }

    public String getTaxChapter(String itemCode, String itemSer, char supOrCust, String code, String siteCode) throws RemoteException, ITMException {
        String taxChapter = "";
        String errcode = "";
        String sql = "";
        Connection connectionObject = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        try {
            sql = "SELECT TAX_CHAP FROM ITEM WHERE ITEM_CODE = '" + itemCode + "'";
            connectionObject = this.getConnection();
            Statement stmt = connectionObject.createStatement();
            rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                sql = "SELECT TAX_CHAP FROM ITEMSER WHERE ITEM_SER = '" + itemSer + "'";
                rs1 = stmt.executeQuery(sql);
                if (!rs1.next()) {
                    if (supOrCust == 'S' || supOrCust == 's') {
                        sql = "SELECT TAX_CHAP FROM SUPPLIER WHERE SUPP_CODE ='" + code + "'";
                        rs2 = stmt.executeQuery(sql);
                        if (rs2.next()) {
                            taxChapter = rs2.getString(1);
                        }
                    } else {
                        sql = "SELECT TAX_CHAP FROM CUSTOMER WHERE CUST_CODE ='" + code + "'";
                        rs2 = stmt.executeQuery(sql);
                        if (rs2.next()) {
                            taxChapter = rs2.getString(1);
                            BaseLogger.log("3", this.userInfo, null, " u r in  customer");
                        }
                    }
                } else {
                    taxChapter = rs1.getString(1);
                    BaseLogger.log("3", this.userInfo, null, " u r in  itemser");
                }
            } else {
                taxChapter = rs.getString(1);
                BaseLogger.log("3", this.userInfo, null, " u r in  item");
            }
            connectionObject.close();
        }
        catch (Exception e) {
            taxChapter = "";
            BaseLogger.log("0", this.userInfo, null, "Exception :ValidatorEJB : getTaxChap ==>" + e.getMessage());
        }
        return taxChapter;
    }

    public String getItemSeries(String itemCode, String siteCode, String tranDate, String sundryCode, char sundryType) throws RemoteException, ITMException {
        String itemSer = "";
        String errCode = "";
        String othSer = "";
        String invSer = "";
        Connection connectionObject = null;
        Statement stmt = null;
        Statement pstmt = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        String sql = "";
        try {
            try {
                if (connectionObject == null) {
                    connectionObject = this.getConnection();
                }
                if (!(rs = (stmt = connectionObject.createStatement()).executeQuery(sql = "SELECT ITEM_SER  FROM SITEITEM WHERE SITE_CODE ='" + siteCode + "' AND ITEM_CODE = '" + itemCode + "'")).next()) {
                    E12GenericUtility genericUtility = new E12GenericUtility();
                    sql = "SELECT ITEM_SER FROM ITEMSER_CHANGE WHERE ITEM_CODE = ? AND EFF_DATE <= ? AND (VALID_UPTO >= ? OR VALID_UPTO IS NULL)";
                    pstmt = connectionObject.prepareStatement(sql);
                    pstmt.setString(1, itemCode);
                    pstmt.setTimestamp(2, Timestamp.valueOf(genericUtility.getValidDateTimeString(tranDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
                    pstmt.setTimestamp(3, Timestamp.valueOf(genericUtility.getValidDateTimeString(tranDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
                    rs1 = pstmt.executeQuery();
                    if (!rs1.next()) {
                        sql = "SELECT ITEM_SER__OLD FROM ITEMSER_CHANGE WHERE ITEM_CODE = ? AND EFF_DATE >= ? AND (VALID_UPTO >= ? OR VALID_UPTO IS NULL) AND EFF_DATE = (SELECT MIN(EFF_DATE) FROM ITEMSER_CHANGE WHERE ITEM_CODE = ? )";
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        pstmt = connectionObject.prepareStatement(sql);
                        pstmt.setString(1, itemCode);
                        pstmt.setTimestamp(2, Timestamp.valueOf(genericUtility.getValidDateTimeString(tranDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
                        pstmt.setTimestamp(3, Timestamp.valueOf(genericUtility.getValidDateTimeString(tranDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
                        pstmt.setString(4, itemCode);
                        rs2 = pstmt.executeQuery();
                        if (!rs2.next()) {
                            sql = "SELECT ITEM_SER  FROM ITEM WHERE ITEM_CODE = '" + itemCode + "'";
                            if (stmt != null) {
                                stmt.close();
                                stmt = null;
                            }
                            if ((rs3 = (stmt = connectionObject.createStatement()).executeQuery(sql)).next()) {
                                itemSer = rs3.getString(1);
                            }
                            if (stmt != null) {
                                stmt.close();
                                stmt = null;
                            }
                        } else {
                            itemSer = rs2.getString(1);
                        }
                    } else {
                        itemSer = rs1.getString(1);
                    }
                } else {
                    itemSer = rs.getString(1);
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (sundryType == 'C') {
                    sql = "SELECT ITEM_SER__INV FROM CUSTOMER_SERIES WHERE CUST_CODE = '" + sundryCode + "' AND ITEM_SER ='" + itemSer + "'";
                    if (stmt == null) {
                        stmt = connectionObject.createStatement();
                    }
                    if ((rs = stmt.executeQuery(sql)).next()) {
                        itemSer = rs.getString(1);
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
            }
            catch (Exception e) {
                itemSer = "";
                BaseLogger.log("0", this.userInfo, null, "Exception :ItemSer  : itemSeries ==>" + e.getMessage());
                try {
                    if (connectionObject != null) {
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        connectionObject.close();
                        connectionObject = null;
                    }
                }
                catch (Exception e2) {
                    System.err.println("Exception :ValidatorEJB :getItemSeries :\n" + e2.getMessage());
                    throw new ITMException(e2);
                }
            }
        }
        finally {
            try {
                if (connectionObject != null) {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    connectionObject.close();
                    connectionObject = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :ValidatorEJB :getItemSeries :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return itemSer;
    }

    public String getTaxClass(char supOrCust, String code, String itemCode, String siteCode) throws RemoteException, ITMException {
        String taxClass = "";
        String errcode = "";
        Connection connectionObject = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        String sql = "";
        try {
            connectionObject = this.getConnection();
            Statement stmt = connectionObject.createStatement();
            if (supOrCust == 'S' || supOrCust == 's') {
                sql = "SELECT TAX_CLASS FROM SUPPLIER WHERE SUPP_CODE='" + code + "'";
                rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    taxClass = rs.getString(1);
                }
            } else {
                sql = "SELECT TAX_CLASS FROM SITE_CUSTOMER WHERE SITE_CODE='" + siteCode + "' AND CUST_CODE='" + code + "'";
                rs1 = stmt.executeQuery(sql);
                if (rs1.next()) {
                    taxClass = rs1.getString(1);
                } else {
                    sql = "SELECT TAX_CLASS FROM CUSTOMER WHERE CUST_CODE='" + code + "'";
                    rs2 = stmt.executeQuery(sql);
                    if (rs2.next()) {
                        taxClass = rs2.getString(1);
                    }
                }
            }
            BaseLogger.log("0", this.userInfo, null, itemCode);
            if (itemCode.length() > 0 && taxClass.trim().length() == 0 && (rs2 = stmt.executeQuery(sql = "SELECT TAX_CLASS FROM ITEM WHERE ITEM_CODE='" + itemCode + "'")).next()) {
                taxClass = rs2.getString(1);
            }
        }
        catch (Exception e) {
            taxClass = "";
            BaseLogger.log("0", this.userInfo, null, "Exception :Taxcl : taxcl ==>" + e.getMessage());
        }
        return taxClass;
    }

    public String getTaxEnv(String frStation, String toStation, String taxChap, String taxClass, String siteCode) {
        String taxEnv = "";
        String errCode = "";
        String lsPrefix = "";
        Connection connectionObject = null;
        String toState = "";
        String frState = "";
        ResultSet rs = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        ResultSet rs4 = null;
        ResultSet rs5 = null;
        ResultSet rs6 = null;
        ResultSet rs7 = null;
        ResultSet rs8 = null;
        ResultSet rs9 = null;
        String sql = "";
        try {
            connectionObject = this.getConnection();
            Statement stmt = connectionObject.createStatement();
            sql = "SELECT STATE_CODE FROM STATION WHERE STAN_CODE = '" + frStation + "'";
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                frState = rs.getString(1);
            }
            if ((rs = stmt.executeQuery(sql = "SELECT STATE_CODE FROM STATION WHERE STAN_CODE = '" + toStation + "'")).next()) {
                toState = rs.getString(1);
            }
            sql = "SELECT TAX_ENV FROM TENVSTAN WHERE STAN_CODE__FR = '" + frStation + "' AND stan_code__to = '" + toStation + "' AND tax_class = '" + taxClass + "' AND tax_chap = '" + taxChap + "'";
            rs = stmt.executeQuery(sql);
            if (taxEnv.trim().length() == 0 || taxEnv != null) {
                if (!rs.next()) {
                    sql = "SELECT TAX_ENV FROM TENVSTAN WHERE STAN_CODE__FR = '" + frStation + "' AND stan_code__to = '" + toStation + "' AND tax_class is null AND  tax_chap = '" + taxChap + "'";
                    rs1 = stmt.executeQuery(sql);
                    if (!rs1.next()) {
                        sql = "SELECT TAX_ENV FROM TENVSTAN WHERE STAN_CODE__FR = '" + frStation + "' AND stan_code__to = '" + toStation + "' AND tax_class= '" + taxClass + "' AND tax_chap is NULL ";
                        rs2 = stmt.executeQuery(sql);
                        if (!rs2.next()) {
                            sql = "SELECT TAX_ENV FROM TENVSTAN WHERE STAN_CODE__FR = '" + frStation + "' AND stan_code__to = '" + toStation + "' AND tax_class is null AND tax_chap is NULL ";
                            rs2 = stmt.executeQuery(sql);
                            if (rs2.next()) {
                                taxEnv = rs2.getString(1);
                            }
                        } else {
                            taxEnv = rs2.getString(1);
                        }
                    } else {
                        taxEnv = rs1.getString(1);
                    }
                } else {
                    taxEnv = rs.getString(1);
                }
            }
            if (!(rs3 = stmt.executeQuery(sql = "SELECT STATE_CODE FROM STATION WHERE STAN_CODE ='" + frStation + "'")).next()) {
                sql = "SELECT STATE_CODE FROM STATION WHERE STAN_CODE = '" + toStation + "'";
                rs4 = stmt.executeQuery(sql);
                if (!rs4.next()) {
                    sql = "SELECT TAX_ENV FROM TENVSTAN WHERE STATE_CODE__FR = '" + frStation + "' AND state_code__to= '" + toStation + "' AND stan_code__fr = '' AND stan_code__to = '' AND tax_class = '" + taxClass + "' AND tax_chap ='" + taxChap + "'";
                    rs5 = stmt.executeQuery(sql);
                    if (!rs5.next()) {
                        sql = "SELECT TAX_ENV FROM TENVSTAN WHERE STATE_CODE__FR = '" + frStation + "' AND state_code__to = '" + toStation + "' AND stan_code__fr = '' AND stan_code__to = ''";
                        rs6 = stmt.executeQuery(sql);
                        if (!rs6.next()) {
                            sql = "SELECT TAX_ENV FROM TENVSTAN WHERE STATE_CODE__FR = '" + frStation + "' AND state_code__to = '" + toStation + "' AND stan_code__fr = '' AND stan_code__to = '' AND tax_class = '" + taxClass + "' AND tax_chap = ''";
                            rs7 = stmt.executeQuery(sql);
                            if (!rs7.next()) {
                                sql = "SELECT TAX_ENV FROM TENVSTAN WHERE STATE_CODE__FR = '" + frStation + "' AND state_code__to = '" + toStation + "' AND stan_code__fr ='' AND stan_code__to = '' AND tax_class = '' AND tax_chap = ''";
                                rs8 = stmt.executeQuery(sql);
                                if (rs8.next()) {
                                    taxEnv = rs8.getString(1);
                                }
                            } else {
                                taxEnv = rs7.getString(1);
                            }
                        } else {
                            taxEnv = rs6.getString(1);
                        }
                    } else {
                        taxEnv = rs5.getString(1);
                    }
                } else {
                    toState = rs4.getString(1);
                }
            } else {
                frState = rs3.getString(1);
            }
            if ((rs9 = stmt.executeQuery(sql = "SELECT TAX_ENV_PREFIX FROM SITE WHERE SITE_CODE = '" + siteCode + "'")).next()) {
                lsPrefix = rs9.getString(1);
            }
            if (lsPrefix != null) {
                taxEnv = String.valueOf(lsPrefix.trim()) + taxEnv.trim();
            }
            connectionObject.close();
        }
        catch (Exception e) {
            taxEnv = "";
            BaseLogger.log("0", this.userInfo, null, "Exception :TaxEnv : taxEnv ==>" + e.getMessage());
        }
        return taxEnv;
    }

    @Override
    public String wfValData() throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
        this.formName = "";
        String errorStr = "";
        try {
            errorStr = this.wfValData(xmlString, xmlString1, xmlString2, objContext, editFlag, xtraParams, this.formName);
        }
        catch (Exception e) {
            System.out.println("Exception wfValData [" + this.getClass().getSimpleName() + "] : [wfValData(S)] " + e.getMessage());
            throw new ITMException(e);
        }
        return errorStr;
    }

    @Override
    public String wfValData(String xmlString, String xmlString1, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
        String xmlString2 = "";
        String errorStr = "";
        this.formName = "";
        try {
            errorStr = this.wfValData(xmlString, xmlString1, xmlString2, objContext, editFlag, xtraParams, this.formName);
        }
        catch (Exception e) {
            System.out.println("Exception wfValData [" + this.getClass().getSimpleName() + "] : [wfValData(S)] " + e.getMessage());
            throw new ITMException(e);
        }
        return errorStr;
    }

    @Override
    public String wfValData(Document dom, Document dom1, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String pageValidate() throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String pageValidate(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String pageValidate(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String pageValidate(String xmlString, String xmlString1, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String pageValidate(Document dom, Document dom1, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String itemChanged() throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
        String retStr = "";
        this.formName = "";
        try {
            retStr = this.itemChanged(xmlString, xmlString1, xmlString2, objContext, currentColumn, editFlag, xtraParams, this.formName);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retStr;
    }

    @Override
    public String itemChanged(String xmlString, String xmlString1, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
        String retStr = "";
        String xmlString2 = "";
        this.formName = "";
        try {
            retStr = this.itemChanged(xmlString, xmlString1, xmlString2, objContext, currentColumn, editFlag, xtraParams, this.formName);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retStr;
    }

    @Override
    public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String itemChanged(Document dom, Document dom1, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String preSave(String arg1, String editFlag, String xtraParams) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String preSaveForm(String arg1, String arg2, String objContext, String editFlag, String xtraParam) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String preSaveRec(String arg1, String arg2, String objContext, String editFlag, String xtraParam) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String postSave(String arg1, String editFlag, String xtraParams) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String postSaveForm(String arg1, String arg2, String objContext, String editFlag, String xtraParam) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String postSaveRec(String arg1, String arg2, String objContext, String editFlag, String xtraParam) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String preSave(String arg1, String editFlag, String xtraParams, Connection con) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String preSaveForm(String arg1, String arg2, String objContext, String editFlag, String xtraParam, Connection con) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String preSaveRec(String arg1, String arg2, String objContext, String editFlag, String xtraParam, Connection con) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String postSave(String arg1, String editFlag, String xtraParams, Connection con) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String postSaveForm(String arg1, String arg2, String objContext, String editFlag, String xtraParam, Connection con) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String postSaveRec(String arg1, String arg2, String objContext, String editFlag, String xtraParam, Connection con) throws RemoteException, ITMException {
        return "";
    }

    public String salesForecastRolledUp(String xmlString, String windowName) throws RemoteException, ITMException {
        return "";
    }

    public String salesForecastRolledUp() throws RemoteException, ITMException {
        return "";
    }

    public String salesForecastRolledUp(Document dom, String windowName) throws RemoteException, ITMException {
        return "";
    }

    public String mcMaintSchGen() throws RemoteException, ITMException {
        return "";
    }

    public String mcMaintSchGen(String xmlString, String windowName) throws RemoteException, ITMException {
        return "";
    }

    public String mcMaintSchGen(Document dom, String windowName) throws RemoteException, ITMException {
        return "";
    }

    public String createOrder() throws RemoteException, ITMException {
        return "";
    }

    public String createOrder(String xmlString, String windowName) throws RemoteException, ITMException {
        return "";
    }

    public String createOrder(Document dom, String windowName) throws RemoteException, ITMException {
        return "";
    }

    public String generalValidate(Document dom, String fldName, String windowName) throws RemoteException, ITMException {
        Connection con = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs1 = null;
        StringBuffer sql1 = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs2 = null;
        Object sql2 = null;
        PreparedStatement pstmt3 = null;
        ResultSet rs3 = null;
        StringBuffer sql3 = null;
        String blankOption = "";
        String errorCd = "";
        String errString = "";
        String valType = "";
        String fldMin = "";
        String fldMax = "";
        String fldType = "";
        String paraNames = "";
        String paraName = "";
        String paraValue = "";
        String outValues = "";
        String userId = "";
        java.util.Date checkDate = null;
        String fldValue = "";
        String fldVal = "";
        String fldValMn = "";
        String fldValMx = "";
        String outVar = "";
        String outValue = "";
        String givenValue = "";
        int mvt = 0;
        int cnt = 0;
        StringTokenizer st = null;
        StringTokenizer st1 = null;
        String columnValue = "";
        boolean checkNextError = true;
        try {
            con = this.getConnection();
            sql1 = new StringBuffer();
            userId = this.getColumnValue("user_id", dom);
            sql1.append("SELECT ERROR_CD, BLANK_OPT, VAL_TYPE, FLD_MIN, FLD_MAX, FLD_TYPE, SQL_INPUT ");
            sql1.append("FROM GENMST WHERE FLD_NAME = ?  AND MOD_NAME = ?");
            pstmt1 = con.prepareStatement(sql1.toString());
            pstmt1.setString(1, fldName);
            pstmt1.setString(2, windowName);
            rs1 = pstmt1.executeQuery();
            if (rs1.next()) {
                mvt = 2;
            } else {
                pstmt1.setString(1, fldName);
                pstmt1.setString(2, "X");
                rs1 = pstmt1.executeQuery();
                if (rs1.next()) {
                    mvt = 1;
                }
            }
            blankOption = rs1.getString(2);
            errorCd = rs1.getString(1);
            valType = rs1.getString(3);
            fldMin = rs1.getString(4);
            fldMax = rs1.getString(5);
            fldType = rs1.getString(6);
            paraNames = rs1.getString(7);
            sql3 = new StringBuffer();
            sql3.append("SELECT COUNT(1) FROM GENCODES WHERE FLD_NAME=? AND MOD_NAME=? AND FLD_VALUE=? AND ACTIVE='Y'");
            pstmt3 = con.prepareStatement(sql3.toString());
            if (mvt != 0 && blankOption.equalsIgnoreCase("Y") && checkNextError && ((columnValue = this.getColumnValue(fldName, dom)) == null || columnValue.length() == 0)) {
                errString = this.getErrorString(fldName, errorCd, userId);
                checkNextError = false;
            }
            columnValue = this.getColumnValue(fldName, dom);
            if (valType.equalsIgnoreCase("S")) {
                fldValMn = fldMin;
                fldValMx = fldMax;
                if (fldType.equalsIgnoreCase("C") && checkNextError) {
                    char fldValu = columnValue.charAt(1);
                    fldValue = String.valueOf(fldVal);
                    if (fldValue.compareTo(fldValMn) < 0 || fldValue.compareTo(fldValMx) > 0) {
                        errString = this.getErrorString(fldName, errorCd, userId);
                        checkNextError = false;
                    }
                } else if (fldType.equalsIgnoreCase("N") && checkNextError) {
                    if (Double.parseDouble(columnValue) < Double.parseDouble(fldValMn) || Double.parseDouble(columnValue) > Double.parseDouble(fldValMx)) {
                        errString = this.getErrorString(fldName, errorCd, userId);
                        checkNextError = false;
                    }
                } else if (checkNextError && ((checkDate = this.getDateObject(columnValue)).compareTo(this.getDateObject(fldValMn)) < 0 || checkDate.compareTo(this.getDateObject(fldValMx)) > 0)) {
                    errString = this.getErrorString(fldName, errorCd, userId);
                    checkNextError = false;
                }
            } else if (valType.equalsIgnoreCase("X")) {
                fldValMn = this.getColumnValue(fldMin, dom);
                if (fldValMn == null) {
                    fldValMn = fldMin;
                }
                if ((fldValMx = this.getColumnValue(fldMax, dom)) == null) {
                    fldValMx = fldMax;
                }
                if (fldType.equalsIgnoreCase("C") && checkNextError) {
                    char fldValu = columnValue.charAt(1);
                    fldValue = String.valueOf(fldVal);
                    if (fldValue.compareTo(fldValMn) < 0 || fldValue.compareTo(fldValMx) > 0) {
                        errString = this.getErrorString(fldName, errorCd, userId);
                        checkNextError = false;
                    }
                } else if (fldType.equalsIgnoreCase("N") && checkNextError) {
                    if (Double.parseDouble(columnValue) < Double.parseDouble(fldValMn) || Double.parseDouble(columnValue) > Double.parseDouble(fldValMx)) {
                        errString = this.getErrorString(fldName, errorCd, userId);
                        checkNextError = false;
                    }
                } else if (checkNextError && ((checkDate = this.getDateObject(columnValue)).compareTo(this.getDateObject(fldValMn)) < 0 || checkDate.compareTo(this.getDateObject(fldValMx)) > 0)) {
                    errString = this.getErrorString(fldName, errorCd, userId);
                    checkNextError = false;
                }
            } else if (valType.equalsIgnoreCase("Q")) {
                pstmt2 = con.prepareStatement(fldMin);
                st = new StringTokenizer(paraNames, ",");
                cnt = 1;
                if (st != null && checkNextError) {
                    while (st.hasMoreTokens()) {
                        paraName = st.nextToken();
                        paraValue = "";
                        paraValue = this.getColumnValue(paraName, dom);
                        pstmt2.setObject(cnt, paraValue);
                        ++cnt;
                    }
                    rs2 = pstmt2.executeQuery();
                    st1 = new StringTokenizer(fldMax, ",");
                    if (st1 == null && checkNextError) {
                        errString = this.getErrorString("", "CONFIGUREERR", userId);
                        checkNextError = false;
                    } else if (checkNextError) {
                        while (st1.hasMoreTokens() && checkNextError) {
                            outVar = st1.nextToken();
                            outValue = rs2.getString(outVar);
                            if (outValue.equals(givenValue = this.getColumnValue(outVar, dom))) continue;
                            errString = this.getErrorString(fldName, errorCd, userId);
                            checkNextError = false;
                        }
                    }
                } else if (checkNextError) {
                    errString = this.getErrorString("", "CONFIGUREERR", userId);
                    checkNextError = false;
                }
            } else if (valType.equalsIgnoreCase("F")) {
                columnValue = this.getColumnValue(fldName, dom);
            } else if (mvt == 1) {
                columnValue = this.getColumnValue(fldName, dom);
                pstmt3.setString(1, fldName);
                pstmt3.setString(2, "X");
                pstmt3.setObject(3, columnValue);
                rs3 = pstmt3.executeQuery();
                if (rs3.next() && rs3.getInt(1) == 0 && checkNextError) {
                    errString = this.getErrorString(fldName, errorCd, userId);
                    checkNextError = false;
                }
            } else {
                columnValue = this.getColumnValue(fldName, dom);
                pstmt3.setString(1, fldName);
                pstmt3.setString(2, windowName);
                pstmt3.setObject(3, columnValue);
                rs3 = pstmt3.executeQuery();
                if (rs3.next() && rs3.getInt(1) == 0 && checkNextError) {
                    errString = this.getErrorString(fldName, errorCd, userId);
                    checkNextError = false;
                }
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException : ValidatorEJB : genValidate :==>\n" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : ValidatorEJB : genValidate :==>\n" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    public float timeDiff(java.util.Date d1, java.util.Date d2) throws RemoteException, ITMException {
        long t1 = d1.getTime();
        long t2 = d2.getTime();
        long t3 = t1 - t2;
        float hr = (float)t3 / 3600000.0f;
        float min = (float)((int)((hr - (float)((int)hr)) * 60.0f)) / 100.0f;
        float time = (float)((int)hr) + min;
        return time;
    }

    public int getParameterCount(String str) throws RemoteException, ITMException {
        int indx = 0;
        int cnt = 0;
        try {
            while (indx != -1) {
                ++indx;
                indx = str.indexOf(63, indx);
                ++cnt;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : ValidatorEJB : genParameterCount :==>\n" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return --cnt;
    }

    public String isBankCode(String siteCode, String bankCode, String modName) throws RemoteException, ITMException {
        String errCode = "";
        Connection con = null;
        Statement stmt1 = null;
        Statement stmt2 = null;
        Statement stmt3 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        String sql1 = "";
        try {
            con = this.getConnection();
            sql1 = "SELECT COUNT(1) FROM BANK WHERE BANK_CODE = '" + bankCode + "'";
            stmt1 = con.createStatement();
            rs1 = stmt1.executeQuery(sql1);
            if (rs1.next()) {
                long counter = rs1.getLong(1);
                if (counter == 0L) {
                    errCode = "VMBANK1";
                }
            } else {
                String colValue;
                sql1 = "SELECT SITE_CODE FROM BANK WHERE BANK_CODE = '" + bankCode + "'";
                stmt2 = con.createStatement();
                rs2 = stmt1.executeQuery(sql1);
                if (rs2.next() && !(colValue = rs2.getString(1)).trim().equals(siteCode)) {
                    long counter;
                    sql1 = "SELECT COUNT(1) FROM SITE_BANK WHERE SITE_CODE ='" + siteCode + "' AND BANK_CODE = '" + bankCode + "'";
                    stmt3 = con.createStatement();
                    rs3 = stmt1.executeQuery(sql1);
                    if (rs3.next() && (counter = rs3.getLong(1)) == 0L) {
                        errCode = "VMBANKMIS1";
                    }
                }
                errCode = "VMBANK1";
            }
            if (rs1 != null) {
                rs1.close();
                rs1 = null;
            }
            if (stmt1 != null) {
                stmt1.close();
                stmt1 = null;
            }
            if (rs2 != null) {
                rs2.close();
                rs2 = null;
            }
            if (stmt2 != null) {
                stmt2.close();
                stmt2 = null;
            }
            if (rs3 != null) {
                rs3.close();
                rs3 = null;
            }
            if (stmt3 != null) {
                stmt3.close();
                stmt3 = null;
            }
            con.close();
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : ValidatorEJB : isBankCode :==>\n" + e.getMessage());
            e.printStackTrace();
            errCode = e.getMessage();
            throw new ITMException(e);
        }
        return errCode;
    }

    public String isBankCode(Connection conn, String siteCode, String bankCode, String modName) throws RemoteException, ITMException {
        String errCode = "";
        Statement stmt1 = null;
        Statement stmt2 = null;
        Statement stmt3 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        String sql1 = "";
        try {
            try {
                sql1 = "SELECT COUNT(1) FROM BANK WHERE BANK_CODE = '" + bankCode + "'";
                stmt1 = conn.createStatement();
                rs1 = stmt1.executeQuery(sql1);
                if (rs1.next()) {
                    long counter = rs1.getLong(1);
                    if (counter == 0L) {
                        errCode = "VMBANK1";
                    }
                } else {
                    String colValue;
                    sql1 = "SELECT SITE_CODE FROM BANK WHERE BANK_CODE = '" + bankCode + "'";
                    stmt2 = conn.createStatement();
                    rs2 = stmt1.executeQuery(sql1);
                    if (rs2.next() && !(colValue = rs2.getString(1)).trim().equals(siteCode)) {
                        long counter;
                        sql1 = "SELECT COUNT(1) FROM SITE_BANK WHERE SITE_CODE ='" + siteCode + "' AND BANK_CODE = '" + bankCode + "'";
                        stmt3 = conn.createStatement();
                        rs3 = stmt1.executeQuery(sql1);
                        if (rs3.next() && (counter = rs3.getLong(1)) == 0L) {
                            errCode = "VMBANKMIS1";
                        }
                    }
                    errCode = "VMBANK1";
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (stmt2 != null) {
                    stmt2.close();
                    stmt2 = null;
                }
                if (rs3 != null) {
                    rs3.close();
                    rs3 = null;
                }
                if (stmt3 != null) {
                    stmt3.close();
                    stmt3 = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception : ValidatorEJB : isBankCode :==>\n" + e.getMessage());
                e.printStackTrace();
                errCode = e.getMessage();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (stmt2 != null) {
                    stmt2.close();
                    stmt2 = null;
                }
                if (rs3 != null) {
                    rs3.close();
                    rs3 = null;
                }
                if (stmt3 != null) {
                    stmt3.close();
                    stmt3 = null;
                }
            }
            catch (SQLException se) {
                BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorNEJB][isCctrCode] :==>\n" + se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
        }
        return errCode;
    }

    public String isSiteCode(String siteCode, String modName) throws RemoteException, ITMException {
        String errCode = "";
        String sql1 = "";
        Connection con = null;
        Statement stmt1 = null;
        ResultSet rs1 = null;
        try {
            try {
                long counter;
                con = this.getConnection();
                sql1 = "SELECT COUNT(1) FROM SITE WHERE SITE_CODE = '" + siteCode + "'";
                stmt1 = con.createStatement();
                rs1 = stmt1.executeQuery(sql1);
                if (rs1.next() && (counter = rs1.getLong(1)) == 0L) {
                    errCode = "VMSITE1";
                }
                rs1.close();
                stmt1.close();
                con.close();
            }
            catch (ITMException itme) {
                BaseLogger.log("0", this.userInfo, null, "ITMException : ValidatorEJB : isSiteCode :==>\n");
                errCode = itme.getMessage();
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception : ValidatorEJB : isSiteCode :==>\n" + e.getMessage());
                e.printStackTrace();
                errCode = e.getMessage();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (con != null) {
                    if (rs1 != null) {
                        rs1.close();
                        rs1 = null;
                    }
                    if (stmt1 != null) {
                        stmt1.close();
                        stmt1 = null;
                    }
                    con.close();
                    con = null;
                }
            }
            catch (SQLException se) {
                BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorNEJB][isCctrCode] :==>\n" + se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
        }
        return errCode;
    }

    public String isSiteCode(Connection conn, String siteCode, String modName) throws RemoteException, ITMException {
        String errCode = "";
        String sql1 = "";
        Statement stmt1 = null;
        ResultSet rs1 = null;
        try {
            try {
                long counter;
                sql1 = "SELECT COUNT(1) FROM SITE WHERE SITE_CODE = '" + siteCode + "'";
                stmt1 = conn.createStatement();
                rs1 = stmt1.executeQuery(sql1);
                if (rs1.next() && (counter = rs1.getLong(1)) == 0L) {
                    errCode = "VMSITE1";
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception : ValidatorEJB : isSiteCode :==>\n" + e.getMessage());
                e.printStackTrace();
                errCode = e.getMessage();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
            }
            catch (SQLException se) {
                BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorNEJB][isCctrCode] :==>\n" + se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
        }
        return errCode;
    }

    public String isCctrCode(String acctCode, String cctrCode, String modName) throws RemoteException, ITMException {
        String errCode = "";
        String sql1 = "";
        Connection con = null;
        Statement stmt1 = null;
        ResultSet rs1 = null;
        Statement stmt2 = null;
        ResultSet rs2 = null;
        try {
            try {
                con = this.getConnection();
                if (cctrCode.length() > 0 && cctrCode != null) {
                    long counter;
                    sql1 = "SELECT COUNT(1) FROM COSTCTR WHERE CCTR_CODE = '" + cctrCode + "'";
                    stmt1 = con.createStatement();
                    rs1 = stmt1.executeQuery(sql1);
                    if (rs1.next() && (counter = rs1.getLong(1)) == 0L) {
                        errCode = "VMCCTR1";
                    }
                } else {
                    sql1 = "SELECT COUNT(1) FROM ACCOUNTS_CCTR WHERE ACCT_CODE = '" + acctCode + "' AND CCTR_CODE = '" + cctrCode + "'";
                    stmt2 = con.createStatement();
                    rs2 = stmt2.executeQuery(sql1);
                    if (rs2.next()) {
                        long counter = rs2.getLong(1);
                        if (counter > 0L) {
                            errCode = "VMCCTR2";
                        } else if (counter == 0L && cctrCode.length() > 0 && cctrCode != null) {
                            errCode = "VMCCTR2";
                        }
                    }
                }
            }
            catch (ITMException itme) {
                BaseLogger.log("0", this.userInfo, null, "ITMException : ValidatorEJB : isCctrCode :==>\n");
                errCode = itme.getMessage();
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception : ValidatorEJB : isCctrCode :==>\n" + e.getMessage());
                e.printStackTrace();
                errCode = e.getMessage();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (stmt2 != null) {
                    stmt2.close();
                    stmt2 = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (SQLException se) {
                BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorNEJB][isCctrCode] :==>\n" + se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
        }
        return errCode;
    }

    public String isCctrCode(Connection conn, String acctCode, String cctrCode, String modName) throws RemoteException, ITMException {
        String errCode = "";
        String sql1 = "";
        Statement stmt1 = null;
        ResultSet rs1 = null;
        Statement stmt2 = null;
        ResultSet rs2 = null;
        try {
            try {
                if (cctrCode.length() > 0 && cctrCode != null) {
                    long counter;
                    sql1 = "SELECT COUNT(1) FROM COSTCTR WHERE CCTR_CODE = '" + cctrCode + "'";
                    stmt1 = conn.createStatement();
                    rs1 = stmt1.executeQuery(sql1);
                    if (rs1.next() && (counter = rs1.getLong(1)) == 0L) {
                        errCode = "VMCCTR1";
                    }
                } else {
                    sql1 = "SELECT COUNT(1) FROM ACCOUNTS_CCTR WHERE ACCT_CODE = '" + acctCode + "' AND CCTR_CODE = '" + cctrCode + "'";
                    stmt2 = conn.createStatement();
                    rs2 = stmt2.executeQuery(sql1);
                    if (rs2.next()) {
                        long counter = rs2.getLong(1);
                        if (counter > 0L) {
                            errCode = "VMCCTR2";
                        } else if (counter == 0L && cctrCode.length() > 0 && cctrCode != null) {
                            errCode = "VMCCTR2";
                        }
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception : ValidatorEJB : isCctrCode :==>\n" + e.getMessage());
                e.printStackTrace();
                errCode = e.getMessage();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (stmt2 != null) {
                    stmt2.close();
                    stmt2 = null;
                }
            }
            catch (SQLException se) {
                BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorNEJB][isCctrCode] :==>\n" + se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
        }
        return errCode;
    }

    public String isAcctCode(String siteCode, String acctCode, String modName) throws RemoteException, ITMException {
        String errCode = "";
        String siteSpec = "";
        Connection con = null;
        String sql1 = "";
        Statement stmt1 = null;
        ResultSet rs1 = null;
        String sql2 = "";
        Statement stmt2 = null;
        ResultSet rs2 = null;
        String sql3 = "";
        Statement stmt3 = null;
        ResultSet rs3 = null;
        StringBuffer sql4 = null;
        Statement stmt4 = null;
        ResultSet rs4 = null;
        try {
            try {
                con = this.getConnection();
                sql1 = "SELECT VAR_VALUE FROM FINPARM WHERE PRD_CODE = '999999' AND VAR_NAME = 'SITE_SPECIFIC_ACCT'";
                stmt1 = con.createStatement();
                rs1 = stmt1.executeQuery(sql1);
                if (rs1.next()) {
                    sql2 = "SELECT COUNT(1) FROM ACCOUNTS WHERE ACCT_CODE = '" + acctCode + "'";
                    stmt2 = con.createStatement();
                    rs2 = stmt1.executeQuery(sql2);
                    if (rs2.next()) {
                        if (rs2.getLong(1) != 0L) {
                            sql3 = "SELECT ACTIVE FROM ACCOUNTS WHERE ACCT_CODE = '" + acctCode + "'";
                            stmt3 = con.createStatement();
                            rs3 = stmt3.executeQuery(sql3);
                            if (rs3.next()) {
                                if (!rs3.getString(1).equals("Y")) {
                                    errCode = "VMACCTA";
                                } else {
                                    siteSpec = rs1.getString(1).trim();
                                    if (siteSpec.equals("Y") && siteSpec != null) {
                                        sql4 = new StringBuffer();
                                        sql4.append("SELECT COUNT(1) FROM SITE_ACCOUNT WHERE SITE_CODE = '");
                                        sql4.append(siteCode).append("' AND ACCT_CODE = '");
                                        sql4.append(acctCode).append("'");
                                        stmt4 = con.createStatement();
                                        rs4 = stmt4.executeQuery(sql4.toString());
                                        if (rs4.next() && rs4.getLong(1) == 0L) {
                                            errCode = "VMACCT4";
                                        }
                                    }
                                }
                            }
                        } else {
                            errCode = "VMACCT1";
                        }
                    }
                }
                if (rs3 != null) {
                    rs3.close();
                    rs3 = null;
                }
                if (stmt3 != null) {
                    stmt3.close();
                    stmt3 = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (stmt2 != null) {
                    stmt2.close();
                    stmt2 = null;
                }
                if (rs4 != null) {
                    rs4.close();
                    rs4 = null;
                }
                if (stmt4 != null) {
                    stmt4.close();
                    stmt4 = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (ITMException itme) {
                BaseLogger.log("0", this.userInfo, null, "ITMException : ValidatorEJB : isAcctCode :==>\n" + itme.getMessage());
                errCode = itme.getMessage();
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception : ValidatorEJB : isAcctCode :==>\n" + e.getMessage());
                e.printStackTrace();
                errCode = e.getMessage();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs3 != null) {
                    rs3.close();
                    rs3 = null;
                }
                if (stmt3 != null) {
                    stmt3.close();
                    stmt3 = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (stmt2 != null) {
                    stmt2.close();
                    stmt2 = null;
                }
                if (rs4 != null) {
                    rs4.close();
                    rs4 = null;
                }
                if (stmt4 != null) {
                    stmt4.close();
                    stmt4 = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return errCode;
    }

    public String isAcctCode(Connection conn, String siteCode, String acctCode, String modName) throws RemoteException, ITMException {
        String errCode = "";
        String siteSpec = "";
        String sql1 = "";
        Statement stmt1 = null;
        ResultSet rs1 = null;
        String sql2 = "";
        Statement stmt2 = null;
        ResultSet rs2 = null;
        String sql3 = "";
        Statement stmt3 = null;
        ResultSet rs3 = null;
        StringBuffer sql4 = null;
        Statement stmt4 = null;
        ResultSet rs4 = null;
        try {
            try {
                sql1 = "SELECT VAR_VALUE FROM FINPARM WHERE PRD_CODE = '999999' AND VAR_NAME = 'SITE_SPECIFIC_ACCT'";
                stmt1 = conn.createStatement();
                rs1 = stmt1.executeQuery(sql1);
                if (rs1.next()) {
                    sql2 = "SELECT COUNT(1) FROM ACCOUNTS WHERE ACCT_CODE = '" + acctCode + "'";
                    stmt2 = conn.createStatement();
                    rs2 = stmt1.executeQuery(sql2);
                    if (rs2.next()) {
                        if (rs2.getLong(1) != 0L) {
                            sql3 = "SELECT ACTIVE FROM ACCOUNTS WHERE ACCT_CODE = '" + acctCode + "'";
                            stmt3 = conn.createStatement();
                            rs3 = stmt3.executeQuery(sql3);
                            if (rs3.next()) {
                                if (!rs3.getString(1).equals("Y")) {
                                    errCode = "VMACCTA";
                                } else {
                                    siteSpec = rs1.getString(1).trim();
                                    if (siteSpec.equals("Y") && siteSpec != null) {
                                        sql4 = new StringBuffer();
                                        sql4.append("SELECT COUNT(1) FROM SITE_ACCOUNT WHERE SITE_CODE = '");
                                        sql4.append(siteCode).append("' AND ACCT_CODE = '");
                                        sql4.append(acctCode).append("'");
                                        stmt4 = conn.createStatement();
                                        rs4 = stmt4.executeQuery(sql4.toString());
                                        if (rs4.next() && rs4.getLong(1) == 0L) {
                                            errCode = "VMACCT4";
                                        }
                                    }
                                }
                            }
                        } else {
                            errCode = "VMACCT1";
                        }
                    }
                }
                if (rs3 != null) {
                    rs3.close();
                    rs3 = null;
                }
                if (stmt3 != null) {
                    stmt3.close();
                    stmt3 = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (stmt2 != null) {
                    stmt2.close();
                    stmt2 = null;
                }
                if (rs4 != null) {
                    rs4.close();
                    rs4 = null;
                }
                if (stmt4 != null) {
                    stmt4.close();
                    stmt4 = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception : ValidatorEJB : isAcctCode :==>\n" + e.getMessage());
                e.printStackTrace();
                errCode = e.getMessage();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs3 != null) {
                    rs3.close();
                    rs3 = null;
                }
                if (stmt3 != null) {
                    stmt3.close();
                    stmt3 = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (stmt2 != null) {
                    stmt2.close();
                    stmt2 = null;
                }
                if (rs4 != null) {
                    rs4.close();
                    rs4 = null;
                }
                if (stmt4 != null) {
                    stmt4.close();
                    stmt4 = null;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return errCode;
    }

    public String isFinEntity(String finEntity, String modName) throws RemoteException, ITMException {
        String errCode = "";
        String sql1 = "";
        Connection con = null;
        Statement stmt1 = null;
        ResultSet rs1 = null;
        try {
            long counter;
            con = this.getConnection();
            sql1 = "SELECT COUNT(1) FROM FINENT WHERE FIN_ENTITY = '" + finEntity + "'";
            stmt1 = con.createStatement();
            rs1 = stmt1.executeQuery(sql1);
            if (rs1.next() && (counter = rs1.getLong(1)) == 0L) {
                errCode = "VMFENTY1";
            }
            stmt1.close();
            con.close();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException : ValidatorEJB : isFinEntity :==>\n" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : ValidatorEJB : isFinEntity :==>\n" + e.getMessage());
            e.printStackTrace();
            errCode = e.getMessage();
            throw new ITMException(e);
        }
        return errCode;
    }

    public String confirmRecord(String tranIdFrom, String tranIdTo) throws RemoteException, ITMException {
        String errCode = "";
        Connection con = null;
        String sql1 = "";
        Object stmt1 = null;
        Object rs = null;
        try {
            con = this.getConnection();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException : ValidatorEJB : confirmRecord :==>\n" + itme.getMessage());
            errCode = itme.getMessage();
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : ValidatorEJB : confirmRecord :==>\n" + e.getMessage());
            e.printStackTrace();
            errCode = e.getMessage();
            throw new ITMException(e);
        }
        return errCode;
    }

    public String getEnvDis(String prdCode, String varName, Connection con) throws RemoteException, ITMException {
        String varValue = "";
        StringBuffer sql = null;
        Connection conn = null;
        Statement stmt101 = null;
        ResultSet rs101 = null;
        try {
            conn = con;
            sql = new StringBuffer();
            sql.append("SELECT VAR_VALUE FROM DISPARM WHERE ");
            sql.append("PRD_CODE = '").append(prdCode).append("' AND ");
            sql.append("VAR_NAME = '").append(varName).append("' ");
            stmt101 = conn.createStatement();
            rs101 = stmt101.executeQuery(sql.toString());
            varValue = rs101.next() ? rs101.getString(1) : "NULLFOUND";
            rs101.close();
            stmt101.close();
            stmt101 = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : ValidatorEJB : getEnvDis :==>\n" + e.getMessage());
            varValue = e.getMessage();
            throw new ITMException(e);
        }
        return varValue;
    }

    public String sparesReqGen() throws RemoteException, ITMException {
        return "";
    }

    public String sparesReqGen(String xmlString, String windowName) throws RemoteException, ITMException {
        return "";
    }

    public String sparesReqGen(Document dom, String windowName) throws RemoteException, ITMException {
        return "";
    }

    public String isCustomer(String siteCode, String custCode, String modName, Connection conn) throws RemoteException, ITMException {
        String active = "";
        String errCode = "";
        String blackList = "";
        String sql21 = "";
        Statement stmt21 = null;
        PreparedStatement pstmt = null;
        ResultSet rs21 = null;
        StringBuffer sql22 = null;
        Object stmt22 = null;
        ResultSet rs22 = null;
        String sql23 = "";
        Object stmt23 = null;
        ResultSet rs23 = null;
        String sql24 = "";
        Object stmt24 = null;
        ResultSet rs24 = null;
        try {
            sql21 = "SELECT VAR_VALUE FROM DISPARM WHERE PRD_CODE = '999999' AND VAR_NAME = 'SITE_SPECIFIC_CUST'";
            stmt21 = conn.createStatement();
            rs21 = stmt21.executeQuery(sql21);
            if (rs21.next()) {
                String disparmVal;
                String string = disparmVal = rs21.getString(1) == null ? "" : rs21.getString(1).trim();
                if ("Y".equals(disparmVal)) {
                    sql22 = new StringBuffer();
                    sql22.append("SELECT ACTIVE_YN FROM SITE_CUSTOMER WHERE SITE_CODE = ? AND CUST_CODE = ? ");
                    pstmt = conn.prepareStatement(sql22.toString());
                    pstmt.setString(1, siteCode);
                    pstmt.setString(2, custCode);
                    rs22 = pstmt.executeQuery();
                    if (rs22.next()) {
                        String string2 = active = rs22.getString(1) == null ? "" : rs22.getString(1).trim();
                        if (active.length() > 0) {
                            if ("N".equals(active)) {
                                errCode = "VTCUST7";
                            } else if (active.trim().length() == 0) {
                                errCode = "VTCUSTCD2";
                            }
                        } else {
                            errCode = "VTCUSTCD2";
                        }
                    } else {
                        errCode = "VTCUSTCD2";
                    }
                    rs22.close();
                    rs22 = null;
                    pstmt.close();
                    pstmt = null;
                }
            }
            rs21.close();
            rs21 = null;
            stmt21.close();
            stmt21 = null;
            sql23 = "SELECT CASE WHEN COUNT(1) IS NULL THEN 0 ELSE COUNT(1) END FROM CUSTOMER WHERE CUST_CODE = ? ";
            pstmt = conn.prepareStatement(sql23);
            pstmt.setString(1, custCode);
            rs23 = pstmt.executeQuery();
            if (rs23.next() && rs23.getInt(1) == 0) {
                errCode = "VTCUSTCD1";
            }
            rs23.close();
            pstmt.close();
            if (errCode == null || errCode.length() == 0) {
                sql24 = "SELECT BLACK_LISTED FROM CUSTOMER WHERE CUST_CODE = ? ";
                pstmt = conn.prepareStatement(sql24);
                pstmt.setString(1, custCode);
                rs24 = pstmt.executeQuery();
                if (rs24.next()) {
                    blackList = rs24.getString(1);
                    if (blackList == null || blackList.trim().length() == 0) {
                        blackList = "N";
                    }
                } else {
                    blackList = "N";
                }
                if (blackList != null && "Y".equals(blackList)) {
                    errCode = modName != null && ("S-RET".equals(modName) || "MDRCRD".equals(modName) || "MDRCRC".equals(modName) || "DRNRCP".equals(modName) || "CRNRCP".equals(modName) || "RCP".equals(modName) || "R-DIS".equals(modName) || "M-RCP".equals(modName)) ? "VTCUSTCD6" : "VTCUSTCD3";
                }
                rs24.close();
                pstmt.close();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : ValidatorEJB : isCustomer :==>\n" + e.getMessage());
            e.printStackTrace();
            errCode = e.getMessage();
            throw new ITMException(e);
        }
        return errCode;
    }

    public String getValueFromXTRA_PARAMS(String xtraParams, String searchParam) throws RemoteException, ITMException {
        String argument = "-1";
        try {
            int searchParamPos = xtraParams.indexOf(searchParam);
            if (searchParamPos != -1) {
                int equalsPos = xtraParams.indexOf("=", searchParamPos);
                int endPos = xtraParams.indexOf("~", equalsPos);
                if (endPos < 0) {
                    endPos = xtraParams.length();
                }
                if ((argument = xtraParams.substring(equalsPos + 1, endPos)) != null && ("null".equalsIgnoreCase(argument) || "undefined".equalsIgnoreCase(argument))) {
                    argument = "";
                }
            }
            BaseLogger.log("3", this.userInfo, null, "Value of " + searchParam + " : " + argument);
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :ValidatorNEJB :getValueFromXTRA_PARAMS :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return argument;
    }

    public String getErrorString(String columnName, String msgNo, String userId, String oldErrString) throws RemoteException, ITMException {
        Connection conn = null;
        Statement pStmt = null;
        Statement pStmtProID = null;
        Statement stmt = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        String msgType = "";
        String msgString = "";
        String msgDescription = "";
        String lmsgString = "";
        String profileId = "";
        String errSource = "";
        String tempMsgType = "";
        String msgOption = "";
        String redirerr = "";
        String soundPlay = "";
        StringBuffer newErrString = null;
        try {
            try {
                conn = this.getConnection();
                String sqlQuery = "SELECT MSG_TYPE,MSG_STR,MSG_DESCR,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE FROM MESSAGES WHERE MSG_NO='" + msgNo + "'";
                stmt = conn.prepareStatement(sqlQuery);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    msgType = rs.getString("MSG_TYPE");
                    msgString = rs.getString("MSG_STR");
                    msgDescription = rs.getString("MSG_DESCR");
                    msgOption = rs.getString("MSG_OPT");
                    soundPlay = rs.getString("ALARM");
                    errSource = rs.getString("ERR_SOURCE");
                } else {
                    lmsgString = "Message Not Defined >>" + msgNo;
                    msgDescription = String.valueOf(Messages.getString("ValidatorEJB_messageIdNotFound")) + "[" + msgNo + "]";
                    msgType = "E";
                    msgString = "";
                }
                if (msgType.equals("E") || msgType.trim().length() == 0) {
                    String sqlQuery1 = "SELECT PROFILE_ID FROM USERS WHERE CODE='" + userId + "'";
                    pStmtProID = conn.prepareStatement(sqlQuery1);
                    rs1 = pStmtProID.executeQuery();
                    if (rs1.next()) {
                        profileId = rs1.getString("PROFILE_ID");
                        if (profileId == null) {
                            profileId = "";
                        }
                        if ((rs2 = (pStmt = conn.prepareStatement(sqlQuery1 = "SELECT MSG_TYPE FROM MESSAGES_LEVEL WHERE MSG_NO='" + msgNo.trim() + "' AND ( PROFILE_ID='" + profileId.trim() + "' OR PROFILE_ID = 'X' )")).executeQuery()).next()) {
                            tempMsgType = rs2.getString("MSG_TYPE");
                        }
                    }
                    if (tempMsgType != null && tempMsgType.trim().length() > 0) {
                        msgType = tempMsgType;
                    }
                }
                if (msgType.equals("W")) {
                    msgString = "Warning : " + msgString;
                } else if (msgType.equals("P")) {
                    msgString = "Prompt : " + msgString;
                } else if (msgType.equals("F")) {
                    msgString = "Information : " + msgString;
                } else {
                    msgType = "E";
                    msgString = "Error : " + msgString;
                }
                if (errSource != null && errSource.trim().equals("D")) {
                    msgDescription = String.valueOf(msgDescription) + " * From Database ";
                }
                if (redirerr == null || redirerr.trim().length() == 0) {
                    redirerr = "1";
                }
                if (msgOption != null && msgOption.trim().equals("M")) {
                    redirerr = redirerr.trim().equals("1") ? "2" : "1";
                }
            }
            catch (ITMException itme) {
                BaseLogger.log("0", this.userInfo, null, "ITMException : [ValidatorNEJB][getErrorString] :==>\n" + itme.getMessage());
                throw itme;
            }
            catch (SQLException se) {
                lmsgString = "Database Error >>" + se.getErrorCode();
                msgDescription = se.getMessage();
                msgType = "";
                msgString = "";
                BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorNEJB][getErrorString] :==>\n" + se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorNEJB][getErrorString] :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (pStmtProID != null) {
                    pStmtProID.close();
                    pStmtProID = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException se) {
                lmsgString = "Database Error >>" + se.getErrorCode();
                msgDescription = se.getMessage();
                msgType = "";
                msgString = "";
                BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorNEJB][getErrorString] :==>\n" + se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
        }
        StringBuffer errStringXml = new StringBuffer();
        errStringXml.append("<error id=\"");
        errStringXml.append(msgNo).append("\" type=\"").append(msgType).append("\" column_name=\"");
        errStringXml.append(columnName).append("\">\r\n");
        errStringXml.append("<message><![CDATA[ " + msgString + "]]></message>");
        errStringXml.append("<description><![CDATA[" + msgDescription + "]]></description>");
        errStringXml.append("<type><![CDATA[" + msgType + "]]></type>");
        errStringXml.append("<option><![CDATA[" + msgOption + "]]></option>");
        errStringXml.append("<alarm><![CDATA[" + soundPlay + "]]></alarm>");
        errStringXml.append("<source><![CDATA[" + errSource + "]]></source>");
        errStringXml.append("<trace><![CDATA[]]></trace>");
        errStringXml.append("<redirect><![CDATA[" + redirerr + "]]></redirect>\r\n</error>\r\n");
        try {
            if (oldErrString != null && oldErrString.length() > 0) {
                E12GenericUtility genUtil = new E12GenericUtility();
                Document oldErrDom = genUtil.parseString(oldErrString);
                Node errorsNode = oldErrDom.getElementsByTagName("Errors").item(0);
                if (errorsNode != null) {
                    Node importedNode = oldErrDom.importNode(genUtil.parseString(errStringXml.toString()), true);
                    errorsNode.appendChild(importedNode);
                    newErrString = new StringBuffer(genUtil.serializeDom(oldErrDom));
                }
            } else {
                newErrString = new StringBuffer("<?xml version=\"1.0\"?><Root>\r\n<Errors>\r\n");
                newErrString.append(errStringXml);
                newErrString.append("</Errors>\r\n</Root>");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newErrString.toString();
    }

    public String isItem(String siteCode, String itemCode, String modName, Connection conn) throws RemoteException, ITMException {
        String errCode = "";
        String active = "";
        String sql21 = "";
        Statement stmt21 = null;
        ResultSet rs21 = null;
        String sql22 = "";
        Statement stmt22 = null;
        ResultSet rs22 = null;
        StringBuffer sql23 = null;
        Statement stmt23 = null;
        ResultSet rs23 = null;
        String sql24 = "";
        Statement stmt24 = null;
        ResultSet rs24 = null;
        try {
            sql21 = "SELECT ACTIVE FROM ITEM WHERE ITEM_CODE = '" + itemCode + "'";
            stmt21 = conn.createStatement();
            rs21 = stmt21.executeQuery(sql21);
            if (rs21.next()) {
                active = rs21.getString(1);
            } else {
                errCode = "VTITEM1";
            }
            if (active == null || active.trim().length() == 0) {
                active = "Y";
            }
            if (!active.equals("Y")) {
                errCode = modName.equals("S-RET") || modName.equals("SRFRM") ? "VTITEM9" : "VTITEM4";
            }
            stmt21.close();
            sql22 = "SELECT VAR_VALUE FROM DISPARM WHERE PRD_CODE = '999999' and VAR_NAME = 'SITE_SPECIFIC_ITEM'";
            stmt22 = conn.createStatement();
            rs22 = stmt22.executeQuery(sql22.toString());
            if (rs22.next()) {
                if (rs22.getString(1).equals("Y")) {
                    sql23 = new StringBuffer();
                    sql23.append("SELECT CASE WHEN ACTIVE IS NULL THEN 'Y' ELSE ACTIVE END FROM SITEITEM WHERE SITE_CODE = '");
                    sql23.append(siteCode).append("' AND ITEM_CODE = '").append(itemCode).append("'");
                    stmt23 = conn.createStatement();
                    rs23 = stmt23.executeQuery(sql23.toString());
                    if (rs23.next()) {
                        if (rs23.getString(1).equals("N")) {
                            errCode = "VTITEM4";
                        }
                    } else {
                        errCode = modName.equals("D-ORD") ? "VTITEM3A" : "VTITEM3";
                    }
                    stmt23.close();
                } else {
                    sql24 = "SELECT CASE WHEN COUNT(1) IS NULL THEN 0 ELSE COUNT(1) END FROM ITEM WHERE ITEM_CODE = '" + itemCode + "'";
                    stmt24 = conn.createStatement();
                    rs24 = stmt24.executeQuery(sql24);
                    if (rs24.next() && rs24.getInt(1) == 0) {
                        errCode = "VTITEM1";
                    }
                    stmt24.close();
                }
            }
            stmt22.close();
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : ValidatorEJB : isItem :==>\n" + e.getMessage());
            e.printStackTrace();
            errCode = e.getMessage();
            throw new ITMException(e);
        }
        return errCode;
    }

    @Override
    public boolean accPosted(String table, String field, String colval, Connection conn) throws RemoteException {
        Statement stmt = null;
        ResultSet rssp = null;
        StringBuffer sqlBuffer = new StringBuffer();
        boolean flag = false;
        sqlBuffer.append("SELECT COUNT(1) FROM " + table + " WHERE " + field + " = '");
        sqlBuffer.append(colval).append("' AND POSTED_ACCOUNTS = 'Y'");
        BaseLogger.log("3", this.userInfo, null, "[ConfirmPolicyEJB accPosted: ] " + sqlBuffer.toString());
        try {
            stmt = conn.createStatement();
            rssp = stmt.executeQuery(sqlBuffer.toString());
            if (rssp.next() && rssp.getInt(1) != 0) {
                flag = true;
            }
            rssp.close();
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorNEJB]: : accPosted(String table,String field,String colval,Connection conn)");
            e.printStackTrace();
        }
        BaseLogger.log("2", this.userInfo, null, "[ValidatorNEJB accPosted Flag: ] " + flag);
        return flag;
    }

    @Override
    public String validateDateString(String dateStr) throws RemoteException, ITMException {
        int index = 0;
        int day = -1;
        int month = -1;
        int daysInMonth = -1;
        String errCode = "";
        int year = -1;
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            String dateStrFormat = genericUtility.getApplDateFormat();
            BaseLogger.log("0", this.userInfo, null, dateStrFormat);
            if (dateStrFormat.indexOf("/") != -1) {
                dateStr = dateStr.replace('/', '-');
            } else if (dateStrFormat.indexOf(".") != -1) {
                dateStr = dateStr.replace('.', '-');
            }
            if (dateStr.indexOf("-") != -1) {
                index = dateStr.indexOf("-");
                day = Integer.parseInt(dateStr.substring(0, index));
                BaseLogger.log("0", this.userInfo, null, day);
            }
            month = Integer.parseInt(dateStr.substring(index + 1, index + 3));
            BaseLogger.log("0", this.userInfo, null, month);
            year = Integer.parseInt(dateStr.substring(index + 4, index + 6));
            BaseLogger.log("0", this.userInfo, null, year);
            if (year % 4 == 0 && (year % 100 != 0 || year % 400 == 0) && month == 2) {
                daysInMonth = 29;
                if (day > daysInMonth) {
                    errCode = "VUDAT1";
                }
            } else if (month == 2) {
                daysInMonth = 28;
                if (day > daysInMonth) {
                    errCode = "VUDAT1";
                }
            } else if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
                daysInMonth = 31;
                if (day > daysInMonth) {
                    errCode = "VUDAT1";
                }
            } else if ((month == 4 || month == 6 || month == 9 || month == 11) && day > (daysInMonth = 30)) {
                errCode = "VUDAT1";
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :validateDataString(String):" + e.getMessage() + ":");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errCode;
    }

    @Override
    public boolean isError(String msgNo, UserInfoBean userInfo) throws RemoteException, ITMException {
        Connection conn = null;
        Statement stmt1 = null;
        ResultSet rs1 = null;
        String msgType = "";
        boolean checkNext = true;
        try {
            conn = this.getConnection();
            stmt1 = conn.createStatement();
            rs1 = stmt1.executeQuery("SELECT MSG_TYPE,MSG_NO FROM MESSAGES WHERE MSG_NO='" + msgNo + "'");
            if (rs1.next()) {
                msgType = rs1.getString(1);
            }
            if (msgType == null || msgType.length() == 0) {
                msgType = "E";
            }
            checkNext = msgType.trim().equals("E");
            rs1.close();
            stmt1.close();
            conn.close();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException : [ValidatorEJB][isError] :==>\n");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception : [ValidatorEJB][isError] :==>\n" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return checkNext;
    }

    public String getErrorString(String columnName, String msgNo, String userId, UserInfoBean userInfo) throws RemoteException, ITMException {
        Connection conn = null;
        Statement pStmt = null;
        Statement stmt = null;
        Statement stmt1 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        String msgType = "";
        String msgString = "";
        String msgDescription = "";
        String lmsgString = "";
        String profileId = "";
        String errSource = "";
        String tempMsgType = "";
        String msgOption = "";
        String msgTime = "";
        String redirerr = "";
        String soundPlay = "";
        String transDB = userInfo.getTransDB();
        try {
            try {
                conn = this.getConnection();
                String sqlQuery = "SELECT MSG_TYPE,MSG_STR,MSG_DESCR,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE FROM MESSAGES WHERE MSG_NO='" + msgNo + "'";
                stmt = conn.prepareStatement(sqlQuery);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    msgType = rs.getString("MSG_TYPE");
                    msgString = rs.getString("MSG_STR");
                    msgDescription = rs.getString("MSG_DESCR");
                    errSource = rs.getString("ERR_SOURCE");
                    msgOption = rs.getString("MSG_OPT");
                    msgTime = rs.getString("MSG_TIME");
                    soundPlay = rs.getString("ALARM");
                } else {
                    lmsgString = "Message Not Defined >>" + msgNo;
                    msgDescription = String.valueOf(Messages.getString("ValidatorEJB_messageIdNotFound")) + "[" + msgNo + "]";
                    msgType = "E";
                    msgString = "";
                }
                if (msgType.equals("E") || msgType.trim().length() == 0) {
                    String sqlQuery1 = "SELECT PROFILE_ID FROM USERS WHERE CODE='" + userId + "'";
                    stmt1 = conn.prepareStatement(sqlQuery);
                    rs1 = stmt1.executeQuery();
                    if (rs1.next()) {
                        profileId = rs1.getString("profile_id");
                        if (profileId == null) {
                            profileId = "";
                        }
                        if ((rs2 = (pStmt = conn.prepareStatement(sqlQuery1 = "SELECT MSG_TYPE FROM MESSAGES_LEVEL WHERE MSG_NO='" + msgNo.trim() + "' AND ( PROFILE_ID='" + profileId.trim() + "' OR PROFILE_ID = 'X' )")).executeQuery()).next()) {
                            tempMsgType = rs2.getString("msg_type");
                        }
                        rs2.close();
                    }
                    if (tempMsgType != null && tempMsgType.trim().length() > 0) {
                        msgType = tempMsgType;
                    }
                }
                if (msgType.equals("W")) {
                    msgString = "Warning : " + msgString;
                } else if (msgType.equals("P")) {
                    msgString = "Prompt : " + msgString;
                } else if (msgType.equals("F")) {
                    msgString = "Information : " + msgString;
                } else {
                    msgType = "E";
                    msgString = "Error : " + msgString;
                }
                if (errSource != null && errSource.trim().equals("D")) {
                    msgDescription = String.valueOf(msgDescription) + " * From Database ";
                }
                if (redirerr == null || redirerr.trim().length() == 0) {
                    redirerr = "1";
                }
                if (msgOption != null && msgOption.trim().equals("M")) {
                    redirerr = redirerr.trim().equals("1") ? "2" : "1";
                }
                if (rs != null) {
                    rs.close();
                    stmt.close();
                }
                if (rs1 != null) {
                    rs1.close();
                    stmt1.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "ITMException : [ValidatorEJB][getErrorString] :==>\n" + itme.getMessage());
                throw itme;
            }
            catch (SQLException se) {
                lmsgString = "Database Error >>" + se.getErrorCode();
                msgDescription = se.getMessage();
                msgType = "";
                msgString = "";
                BaseLogger.log("0", userInfo, null, "Exception : [ValidatorEJB][getErrorString] :==>\n" + se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception : [ValidatorEJB][getErrorString] :==>\n" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception exception) {}
        }
        StringBuffer errStringXml = new StringBuffer();
        errStringXml.append("<?xml version=\"1.0\"?>\r\n<Root><Errors>\r\n");
        errStringXml.append("<error id=\"");
        errStringXml.append(msgNo).append("\" type=\"").append(msgType).append("\" column_name=\"");
        errStringXml.append(columnName).append("\">\r\n");
        errStringXml.append("<message><![CDATA[ " + msgString + "]]></message>");
        errStringXml.append("<description><![CDATA[" + msgDescription + "]]></description>");
        errStringXml.append("<type><![CDATA[" + msgType + "]]></type>");
        errStringXml.append("<time><![CDATA[" + msgTime + "]]></time>");
        errStringXml.append("<alarm><![CDATA[" + soundPlay + "]]></alarm>");
        errStringXml.append("<source><![CDATA[" + errSource + "]]></source>");
        errStringXml.append("<trace><![CDATA[]]></trace>");
        errStringXml.append("<redirect><![CDATA[" + redirerr + "]]></redirect>");
        errStringXml.append("</error>").append("</Errors></Root>");
        return errStringXml.toString();
    }

    public Connection getConnection(String connfileName, UserInfoBean userInfo) throws RemoteException, ITMException {
        Connection conn = null;
        try {
            this.userInfo = userInfo;
            conn = this.getConnection();
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception : [ValidatorEJB][getConnection] :==>\n" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return conn;
    }

    public String getTaxChapter(String itemCode, String itemSer, char supOrCust, String code, String siteCode, UserInfoBean userInfo) throws RemoteException, ITMException {
        String taxChapter = "";
        String errcode = "";
        String sql = "";
        Connection connectionObject = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        try {
            sql = "SELECT TAX_CHAP FROM ITEM WHERE ITEM_CODE = '" + itemCode + "'";
            String transDB = userInfo.getTransDB();
            ConnDriver mConnDriver = new ConnDriver();
            connectionObject = mConnDriver.getConnectDB(transDB);
            Statement stmt = connectionObject.createStatement();
            rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                sql = "SELECT TAX_CHAP FROM ITEMSER WHERE ITEM_SER = '" + itemSer + "'";
                rs1 = stmt.executeQuery(sql);
                if (!rs1.next()) {
                    if (supOrCust == 'S' || supOrCust == 's') {
                        sql = "SELECT TAX_CHAP FROM SUPPLIER WHERE SUPP_CODE ='" + code + "'";
                        rs2 = stmt.executeQuery(sql);
                        if (rs2.next()) {
                            taxChapter = rs2.getString(1);
                        }
                    } else {
                        sql = "SELECT TAX_CHAP FROM CUSTOMER WHERE CUST_CODE ='" + code + "'";
                        rs2 = stmt.executeQuery(sql);
                        if (rs2.next()) {
                            taxChapter = rs2.getString(1);
                            BaseLogger.log("3", userInfo, null, " u r in  customer");
                        }
                    }
                } else {
                    taxChapter = rs1.getString(1);
                    BaseLogger.log("3", userInfo, null, " u r in  itemser");
                }
            } else {
                taxChapter = rs.getString(1);
                BaseLogger.log("3", userInfo, null, " u r in  item");
            }
            connectionObject.close();
        }
        catch (Exception e) {
            taxChapter = "";
            BaseLogger.log("0", userInfo, null, "Exception :ValidatorEJB : getTaxChap ==>" + e.getMessage());
        }
        return taxChapter;
    }

    public String getItemSeries(String itemCode, String siteCode, String tranDate, String sundryCode, char sundryType, UserInfoBean userInfo) throws RemoteException, ITMException {
        String itemSer = "";
        String errCode = "";
        String othSer = "";
        String invSer = "";
        Connection connectionObject = null;
        Statement stmt = null;
        Statement pstmt = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        String sql = "";
        try {
            try {
                String transDB = userInfo.getTransDB();
                if (connectionObject == null) {
                    ConnDriver mConnDriver = new ConnDriver();
                    connectionObject = mConnDriver.getConnectDB(transDB);
                }
                if (!(rs = (stmt = connectionObject.createStatement()).executeQuery(sql = "SELECT ITEM_SER  FROM SITEITEM WHERE SITE_CODE ='" + siteCode + "' AND ITEM_CODE = '" + itemCode + "'")).next()) {
                    E12GenericUtility genericUtility = new E12GenericUtility();
                    sql = "SELECT ITEM_SER FROM ITEMSER_CHANGE WHERE ITEM_CODE = ? AND EFF_DATE <= ? AND (VALID_UPTO >= ? OR VALID_UPTO IS NULL)";
                    pstmt = connectionObject.prepareStatement(sql);
                    pstmt.setString(1, itemCode);
                    pstmt.setTimestamp(2, Timestamp.valueOf(genericUtility.getValidDateTimeString(tranDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
                    pstmt.setTimestamp(3, Timestamp.valueOf(genericUtility.getValidDateTimeString(tranDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
                    rs1 = pstmt.executeQuery();
                    if (!rs1.next()) {
                        sql = "SELECT ITEM_SER__OLD FROM ITEMSER_CHANGE WHERE ITEM_CODE = ? AND EFF_DATE >= ? AND (VALID_UPTO >= ? OR VALID_UPTO IS NULL) AND EFF_DATE = (SELECT MIN(EFF_DATE) FROM ITEMSER_CHANGE WHERE ITEM_CODE = ? )";
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        pstmt = connectionObject.prepareStatement(sql);
                        pstmt.setString(1, itemCode);
                        pstmt.setTimestamp(2, Timestamp.valueOf(genericUtility.getValidDateTimeString(tranDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
                        pstmt.setTimestamp(3, Timestamp.valueOf(genericUtility.getValidDateTimeString(tranDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
                        pstmt.setString(4, itemCode);
                        rs2 = pstmt.executeQuery();
                        if (!rs2.next()) {
                            sql = "SELECT ITEM_SER  FROM ITEM WHERE ITEM_CODE = '" + itemCode + "'";
                            if (stmt != null) {
                                stmt.close();
                                stmt = null;
                            }
                            if ((rs3 = (stmt = connectionObject.createStatement()).executeQuery(sql)).next()) {
                                itemSer = rs3.getString(1);
                            }
                            if (stmt != null) {
                                stmt.close();
                                stmt = null;
                            }
                        } else {
                            itemSer = rs2.getString(1);
                        }
                    } else {
                        itemSer = rs1.getString(1);
                    }
                } else {
                    itemSer = rs.getString(1);
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (sundryType == 'C') {
                    sql = "SELECT ITEM_SER__INV FROM CUSTOMER_SERIES WHERE CUST_CODE = '" + sundryCode + "' AND ITEM_SER ='" + itemSer + "'";
                    if (stmt == null) {
                        stmt = connectionObject.createStatement();
                    }
                    if ((rs = stmt.executeQuery(sql)).next()) {
                        itemSer = rs.getString(1);
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
            }
            catch (Exception e) {
                itemSer = "";
                BaseLogger.log("0", userInfo, null, "Exception :ItemSer  : itemSeries ==>" + e.getMessage());
                try {
                    if (connectionObject != null) {
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        connectionObject.close();
                        connectionObject = null;
                    }
                }
                catch (Exception e2) {
                    System.err.println("Exception :ValidatorEJB :getItemSeries :\n" + e2.getMessage());
                    throw new ITMException(e2);
                }
            }
        }
        finally {
            try {
                if (connectionObject != null) {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    connectionObject.close();
                    connectionObject = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :ValidatorEJB :getItemSeries :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return itemSer;
    }

    public String getTaxClass(char supOrCust, String code, String itemCode, String siteCode, UserInfoBean userInfo) throws RemoteException, ITMException {
        String taxClass = "";
        String errcode = "";
        Connection connectionObject = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        String sql = "";
        try {
            String transDB = userInfo.getTransDB();
            ConnDriver mConnDriver = new ConnDriver();
            connectionObject = mConnDriver.getConnectDB(transDB);
            Statement stmt = connectionObject.createStatement();
            if (supOrCust == 'S' || supOrCust == 's') {
                sql = "SELECT TAX_CLASS FROM SUPPLIER WHERE SUPP_CODE='" + code + "'";
                rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    taxClass = rs.getString(1);
                }
            } else {
                sql = "SELECT TAX_CLASS FROM SITE_CUSTOMER WHERE SITE_CODE='" + siteCode + "' AND CUST_CODE='" + code + "'";
                rs1 = stmt.executeQuery(sql);
                if (rs1.next()) {
                    taxClass = rs1.getString(1);
                } else {
                    sql = "SELECT TAX_CLASS FROM CUSTOMER WHERE CUST_CODE='" + code + "'";
                    rs2 = stmt.executeQuery(sql);
                    if (rs2.next()) {
                        taxClass = rs2.getString(1);
                    }
                }
            }
            BaseLogger.log("0", userInfo, null, itemCode);
            if (itemCode.length() > 0 && taxClass.trim().length() == 0 && (rs2 = stmt.executeQuery(sql = "SELECT TAX_CLASS FROM ITEM WHERE ITEM_CODE='" + itemCode + "'")).next()) {
                taxClass = rs2.getString(1);
            }
        }
        catch (Exception e) {
            taxClass = "";
            BaseLogger.log("0", userInfo, null, "Exception :Taxcl : taxcl ==>" + e.getMessage());
        }
        return taxClass;
    }

    public String getTaxEnv(String frStation, String toStation, String taxChap, String taxClass, String siteCode, UserInfoBean userInfo) {
        String taxEnv = "";
        String errCode = "";
        String lsPrefix = "";
        Connection connectionObject = null;
        String toState = "";
        String frState = "";
        ResultSet rs = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        ResultSet rs4 = null;
        ResultSet rs5 = null;
        ResultSet rs6 = null;
        ResultSet rs7 = null;
        ResultSet rs8 = null;
        ResultSet rs9 = null;
        String sql = "";
        try {
            String transDB = userInfo.getTransDB();
            ConnDriver mConnDriver = new ConnDriver();
            connectionObject = mConnDriver.getConnectDB(transDB);
            Statement stmt = connectionObject.createStatement();
            sql = "SELECT STATE_CODE FROM STATION WHERE STAN_CODE = '" + frStation + "'";
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                frState = rs.getString(1);
            }
            if ((rs = stmt.executeQuery(sql = "SELECT STATE_CODE FROM STATION WHERE STAN_CODE = '" + toStation + "'")).next()) {
                toState = rs.getString(1);
            }
            sql = "SELECT TAX_ENV FROM TENVSTAN WHERE STAN_CODE__FR = '" + frStation + "' AND stan_code__to = '" + toStation + "' AND tax_class = '" + taxClass + "' AND tax_chap = '" + taxChap + "'";
            rs = stmt.executeQuery(sql);
            if (taxEnv.trim().length() == 0 || taxEnv != null) {
                if (!rs.next()) {
                    sql = "SELECT TAX_ENV FROM TENVSTAN WHERE STAN_CODE__FR = '" + frStation + "' AND stan_code__to = '" + toStation + "' AND tax_class is null AND  tax_chap = '" + taxChap + "'";
                    rs1 = stmt.executeQuery(sql);
                    if (!rs1.next()) {
                        sql = "SELECT TAX_ENV FROM TENVSTAN WHERE STAN_CODE__FR = '" + frStation + "' AND stan_code__to = '" + toStation + "' AND tax_class= '" + taxClass + "' AND tax_chap is NULL ";
                        rs2 = stmt.executeQuery(sql);
                        if (!rs2.next()) {
                            sql = "SELECT TAX_ENV FROM TENVSTAN WHERE STAN_CODE__FR = '" + frStation + "' AND stan_code__to = '" + toStation + "' AND tax_class is null AND tax_chap is NULL ";
                            rs2 = stmt.executeQuery(sql);
                            if (rs2.next()) {
                                taxEnv = rs2.getString(1);
                            }
                        } else {
                            taxEnv = rs2.getString(1);
                        }
                    } else {
                        taxEnv = rs1.getString(1);
                    }
                } else {
                    taxEnv = rs.getString(1);
                }
            }
            if (!(rs3 = stmt.executeQuery(sql = "SELECT STATE_CODE FROM STATION WHERE STAN_CODE ='" + frStation + "'")).next()) {
                sql = "SELECT STATE_CODE FROM STATION WHERE STAN_CODE = '" + toStation + "'";
                rs4 = stmt.executeQuery(sql);
                if (!rs4.next()) {
                    sql = "SELECT TAX_ENV FROM TENVSTAN WHERE STATE_CODE__FR = '" + frStation + "' AND state_code__to= '" + toStation + "' AND stan_code__fr = '' AND stan_code__to = '' AND tax_class = '" + taxClass + "' AND tax_chap ='" + taxChap + "'";
                    rs5 = stmt.executeQuery(sql);
                    if (!rs5.next()) {
                        sql = "SELECT TAX_ENV FROM TENVSTAN WHERE STATE_CODE__FR = '" + frStation + "' AND state_code__to = '" + toStation + "' AND stan_code__fr = '' AND stan_code__to = ''";
                        rs6 = stmt.executeQuery(sql);
                        if (!rs6.next()) {
                            sql = "SELECT TAX_ENV FROM TENVSTAN WHERE STATE_CODE__FR = '" + frStation + "' AND state_code__to = '" + toStation + "' AND stan_code__fr = '' AND stan_code__to = '' AND tax_class = '" + taxClass + "' AND tax_chap = ''";
                            rs7 = stmt.executeQuery(sql);
                            if (!rs7.next()) {
                                sql = "SELECT TAX_ENV FROM TENVSTAN WHERE STATE_CODE__FR = '" + frStation + "' AND state_code__to = '" + toStation + "' AND stan_code__fr ='' AND stan_code__to = '' AND tax_class = '' AND tax_chap = ''";
                                rs8 = stmt.executeQuery(sql);
                                if (rs8.next()) {
                                    taxEnv = rs8.getString(1);
                                }
                            } else {
                                taxEnv = rs7.getString(1);
                            }
                        } else {
                            taxEnv = rs6.getString(1);
                        }
                    } else {
                        taxEnv = rs5.getString(1);
                    }
                } else {
                    toState = rs4.getString(1);
                }
            } else {
                frState = rs3.getString(1);
            }
            if ((rs9 = stmt.executeQuery(sql = "SELECT TAX_ENV_PREFIX FROM SITE WHERE SITE_CODE = '" + siteCode + "'")).next()) {
                lsPrefix = rs9.getString(1);
            }
            if (lsPrefix != null) {
                taxEnv = String.valueOf(lsPrefix.trim()) + taxEnv.trim();
            }
            connectionObject.close();
        }
        catch (Exception e) {
            taxEnv = "";
            BaseLogger.log("0", userInfo, null, "Exception :TaxEnv : taxEnv ==>" + e.getMessage());
        }
        return taxEnv;
    }

    @Override
    public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams, UserInfoBean userInfo) throws RemoteException, ITMException {
        String errorStr = "";
        this.formName = "";
        this.setUserInfo(userInfo);
        try {
            errorStr = this.wfValData(xmlString, xmlString1, xmlString2, objContext, editFlag, xtraParams, this.formName);
        }
        catch (Exception e) {
            System.out.println("Exception wfValData [" + this.getClass().getSimpleName() + "] : [wfValData(S)] " + e.getMessage());
            throw new ITMException(e);
        }
        return errorStr;
    }

    @Override
    public String pageValidate(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String pageValidate(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams, UserInfoBean userInfo) throws RemoteException, ITMException {
        String retStr = "";
        this.setUserInfo(userInfo);
        this.formName = "";
        try {
            retStr = this.itemChanged(xmlString, xmlString1, xmlString2, objContext, currentColumn, editFlag, xtraParams, this.formName);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retStr;
    }

    @Override
    public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String preSave(String arg1, String editFlag, String xtraParams, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String preSaveForm(String arg1, String arg2, String objContext, String editFlag, String xtraParam, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String preSaveRec(String arg1, String arg2, String objContext, String editFlag, String xtraParam, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String postSave(String arg1, String editFlag, String xtraParams, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String postSaveForm(String arg1, String arg2, String objContext, String editFlag, String xtraParam, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String postSaveRec(String arg1, String arg2, String objContext, String editFlag, String xtraParam, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String preSave(String arg1, String editFlag, String xtraParams, Connection con, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String preSaveForm(String arg1, String arg2, String objContext, String editFlag, String xtraParam, Connection con, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String preSaveRec(String arg1, String arg2, String objContext, String editFlag, String xtraParam, Connection con, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String postSave(String arg1, String editFlag, String xtraParams, Connection con, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String postSaveForm(String arg1, String arg2, String objContext, String editFlag, String xtraParam, Connection con, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String postSaveRec(String arg1, String arg2, String objContext, String editFlag, String xtraParam, Connection con, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    public String salesForecastRolledUp(String xmlString, String windowName, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    public String salesForecastRolledUp(UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    public String salesForecastRolledUp(Document dom, String windowName, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    public String mcMaintSchGen(UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    public String mcMaintSchGen(String xmlString, String windowName, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    public String mcMaintSchGen(Document dom, String windowName, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    public String createOrder(UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    public String createOrder(String xmlString, String windowName, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    public String createOrder(Document dom, String windowName, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    public String generalValidate(Document dom, String fldName, String windowName, UserInfoBean userInfo) throws RemoteException, ITMException {
        Connection con = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs1 = null;
        StringBuffer sql1 = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs2 = null;
        Object sql2 = null;
        PreparedStatement pstmt3 = null;
        ResultSet rs3 = null;
        StringBuffer sql3 = null;
        String blankOption = "";
        String errorCd = "";
        String errString = "";
        String valType = "";
        String fldMin = "";
        String fldMax = "";
        String fldType = "";
        String paraNames = "";
        String paraName = "";
        String paraValue = "";
        String outValues = "";
        String userId = "";
        java.util.Date checkDate = null;
        String fldValue = "";
        String fldVal = "";
        String fldValMn = "";
        String fldValMx = "";
        String outVar = "";
        String outValue = "";
        String givenValue = "";
        int mvt = 0;
        int cnt = 0;
        StringTokenizer st = null;
        StringTokenizer st1 = null;
        String columnValue = "";
        boolean checkNextError = true;
        try {
            String transDB = userInfo.getTransDB();
            ConnDriver mConnDriver = new ConnDriver();
            con = mConnDriver.getConnectDB(transDB);
            sql1 = new StringBuffer();
            userId = this.getColumnValue("user_id", dom);
            sql1.append("SELECT ERROR_CD, BLANK_OPT, VAL_TYPE, FLD_MIN, FLD_MAX, FLD_TYPE, SQL_INPUT ");
            sql1.append("FROM GENMST WHERE FLD_NAME = ?  AND MOD_NAME = ?");
            pstmt1 = con.prepareStatement(sql1.toString());
            pstmt1.setString(1, fldName);
            pstmt1.setString(2, windowName);
            rs1 = pstmt1.executeQuery();
            if (rs1.next()) {
                mvt = 2;
            } else {
                pstmt1.setString(1, fldName);
                pstmt1.setString(2, "X");
                rs1 = pstmt1.executeQuery();
                if (rs1.next()) {
                    mvt = 1;
                }
            }
            blankOption = rs1.getString(2);
            errorCd = rs1.getString(1);
            valType = rs1.getString(3);
            fldMin = rs1.getString(4);
            fldMax = rs1.getString(5);
            fldType = rs1.getString(6);
            paraNames = rs1.getString(7);
            sql3 = new StringBuffer();
            sql3.append("SELECT COUNT(1) FROM GENCODES WHERE FLD_NAME=? AND MOD_NAME=? AND FLD_VALUE=? AND ACTIVE='Y'");
            pstmt3 = con.prepareStatement(sql3.toString());
            if (mvt != 0 && blankOption.equalsIgnoreCase("Y") && checkNextError && ((columnValue = this.getColumnValue(fldName, dom)) == null || columnValue.length() == 0)) {
                errString = this.getErrorString(fldName, errorCd, userId, "", userInfo);
                checkNextError = false;
            }
            columnValue = this.getColumnValue(fldName, dom);
            if (valType.equalsIgnoreCase("S")) {
                fldValMn = fldMin;
                fldValMx = fldMax;
                if (fldType.equalsIgnoreCase("C") && checkNextError) {
                    char fldValu = columnValue.charAt(1);
                    fldValue = String.valueOf(fldVal);
                    if (fldValue.compareTo(fldValMn) < 0 || fldValue.compareTo(fldValMx) > 0) {
                        errString = this.getErrorString(fldName, errorCd, userId, "", userInfo);
                        checkNextError = false;
                    }
                } else if (fldType.equalsIgnoreCase("N") && checkNextError) {
                    if (Double.parseDouble(columnValue) < Double.parseDouble(fldValMn) || Double.parseDouble(columnValue) > Double.parseDouble(fldValMx)) {
                        errString = this.getErrorString(fldName, errorCd, userId, "", userInfo);
                        checkNextError = false;
                    }
                } else if (checkNextError && ((checkDate = this.getDateObject(columnValue)).compareTo(this.getDateObject(fldValMn)) < 0 || checkDate.compareTo(this.getDateObject(fldValMx)) > 0)) {
                    errString = this.getErrorString(fldName, errorCd, userId, "", userInfo);
                    checkNextError = false;
                }
            } else if (valType.equalsIgnoreCase("X")) {
                fldValMn = this.getColumnValue(fldMin, dom);
                if (fldValMn == null) {
                    fldValMn = fldMin;
                }
                if ((fldValMx = this.getColumnValue(fldMax, dom)) == null) {
                    fldValMx = fldMax;
                }
                if (fldType.equalsIgnoreCase("C") && checkNextError) {
                    char fldValu = columnValue.charAt(1);
                    fldValue = String.valueOf(fldVal);
                    if (fldValue.compareTo(fldValMn) < 0 || fldValue.compareTo(fldValMx) > 0) {
                        errString = this.getErrorString(fldName, errorCd, userId);
                        checkNextError = false;
                    }
                } else if (fldType.equalsIgnoreCase("N") && checkNextError) {
                    if (Double.parseDouble(columnValue) < Double.parseDouble(fldValMn) || Double.parseDouble(columnValue) > Double.parseDouble(fldValMx)) {
                        errString = this.getErrorString(fldName, errorCd, userId, "", userInfo);
                        checkNextError = false;
                    }
                } else if (checkNextError && ((checkDate = this.getDateObject(columnValue)).compareTo(this.getDateObject(fldValMn)) < 0 || checkDate.compareTo(this.getDateObject(fldValMx)) > 0)) {
                    errString = this.getErrorString(fldName, errorCd, userId, "", userInfo);
                    checkNextError = false;
                }
            } else if (valType.equalsIgnoreCase("Q")) {
                pstmt2 = con.prepareStatement(fldMin);
                st = new StringTokenizer(paraNames, ",");
                cnt = 1;
                if (st != null && checkNextError) {
                    while (st.hasMoreTokens()) {
                        paraName = st.nextToken();
                        paraValue = "";
                        paraValue = this.getColumnValue(paraName, dom);
                        pstmt2.setObject(cnt, paraValue);
                        ++cnt;
                    }
                    rs2 = pstmt2.executeQuery();
                    st1 = new StringTokenizer(fldMax, ",");
                    if (st1 == null && checkNextError) {
                        errString = this.getErrorString("", "CONFIGUREERR", userId, "", userInfo);
                        checkNextError = false;
                    } else if (checkNextError) {
                        while (st1.hasMoreTokens() && checkNextError) {
                            outVar = st1.nextToken();
                            outValue = rs2.getString(outVar);
                            if (outValue.equals(givenValue = this.getColumnValue(outVar, dom))) continue;
                            errString = this.getErrorString(fldName, errorCd, userId, "", userInfo);
                            checkNextError = false;
                        }
                    }
                } else if (checkNextError) {
                    errString = this.getErrorString("", "CONFIGUREERR", userId, "", userInfo);
                    checkNextError = false;
                }
            } else if (valType.equalsIgnoreCase("F")) {
                columnValue = this.getColumnValue(fldName, dom);
            } else if (mvt == 1) {
                columnValue = this.getColumnValue(fldName, dom);
                pstmt3.setString(1, fldName);
                pstmt3.setString(2, "X");
                pstmt3.setObject(3, columnValue);
                rs3 = pstmt3.executeQuery();
                if (rs3.next() && rs3.getInt(1) == 0 && checkNextError) {
                    errString = this.getErrorString(fldName, errorCd, userId, "", userInfo);
                    checkNextError = false;
                }
            } else {
                columnValue = this.getColumnValue(fldName, dom);
                pstmt3.setString(1, fldName);
                pstmt3.setString(2, windowName);
                pstmt3.setObject(3, columnValue);
                rs3 = pstmt3.executeQuery();
                if (rs3.next() && rs3.getInt(1) == 0 && checkNextError) {
                    errString = this.getErrorString(fldName, errorCd, userId, "", userInfo);
                    checkNextError = false;
                }
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException : ValidatorEJB : genValidate :==>\n" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception : ValidatorEJB : genValidate :==>\n" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    public String isBankCode(String siteCode, String bankCode, String modName, UserInfoBean userInfo) throws RemoteException, ITMException {
        String errCode = "";
        Connection con = null;
        Statement stmt1 = null;
        Statement stmt2 = null;
        Statement stmt3 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        String sql1 = "";
        try {
            String transDB = userInfo.getTransDB();
            ConnDriver mConnDriver = new ConnDriver();
            con = mConnDriver.getConnectDB(transDB);
            sql1 = "SELECT COUNT(1) FROM BANK WHERE BANK_CODE = '" + bankCode + "'";
            stmt1 = con.createStatement();
            rs1 = stmt1.executeQuery(sql1);
            if (rs1.next()) {
                long counter = rs1.getLong(1);
                if (counter == 0L) {
                    errCode = "VMBANK1";
                }
            } else {
                String colValue;
                sql1 = "SELECT SITE_CODE FROM BANK WHERE BANK_CODE = '" + bankCode + "'";
                stmt2 = con.createStatement();
                rs2 = stmt1.executeQuery(sql1);
                if (rs2.next() && !(colValue = rs2.getString(1)).trim().equals(siteCode)) {
                    long counter;
                    sql1 = "SELECT COUNT(1) FROM SITE_BANK WHERE SITE_CODE ='" + siteCode + "' AND BANK_CODE = '" + bankCode + "'";
                    stmt3 = con.createStatement();
                    rs3 = stmt1.executeQuery(sql1);
                    if (rs3.next() && (counter = rs3.getLong(1)) == 0L) {
                        errCode = "VMBANKMIS1";
                    }
                }
                errCode = "VMBANK1";
            }
            if (rs1 != null) {
                rs1.close();
                rs1 = null;
            }
            if (stmt1 != null) {
                stmt1.close();
                stmt1 = null;
            }
            if (rs2 != null) {
                rs2.close();
                rs2 = null;
            }
            if (stmt2 != null) {
                stmt2.close();
                stmt2 = null;
            }
            if (rs3 != null) {
                rs3.close();
                rs3 = null;
            }
            if (stmt3 != null) {
                stmt3.close();
                stmt3 = null;
            }
            con.close();
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception : ValidatorEJB : isBankCode :==>\n" + e.getMessage());
            e.printStackTrace();
            errCode = e.getMessage();
            throw new ITMException(e);
        }
        return errCode;
    }

    public String isSiteCode(String siteCode, String modName, UserInfoBean userInfo) throws RemoteException, ITMException {
        String errCode = "";
        String sql1 = "";
        Connection con = null;
        Statement stmt1 = null;
        ResultSet rs1 = null;
        try {
            long counter;
            String transDB = userInfo.getTransDB();
            ConnDriver mConnDriver = new ConnDriver();
            con = mConnDriver.getConnectDB(transDB);
            sql1 = "SELECT COUNT(1) FROM SITE WHERE SITE_CODE = '" + siteCode + "'";
            stmt1 = con.createStatement();
            rs1 = stmt1.executeQuery(sql1);
            if (rs1.next() && (counter = rs1.getLong(1)) == 0L) {
                errCode = "VMSITE1";
            }
            rs1.close();
            stmt1.close();
            con.close();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException : ValidatorEJB : isSiteCode :==>\n");
            errCode = itme.getMessage();
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception : ValidatorEJB : isSiteCode :==>\n" + e.getMessage());
            e.printStackTrace();
            errCode = e.getMessage();
            throw new ITMException(e);
        }
        return errCode;
    }

    public String isCctrCode(String acctCode, String cctrCode, String modName, UserInfoBean userInfo) throws RemoteException, ITMException {
        String errCode = "";
        String sql1 = "";
        Connection con = null;
        Statement stmt1 = null;
        ResultSet rs1 = null;
        Statement stmt2 = null;
        ResultSet rs2 = null;
        try {
            try {
                String transDB = userInfo.getTransDB();
                ConnDriver mConnDriver = new ConnDriver();
                con = mConnDriver.getConnectDB(transDB);
                if (cctrCode.length() > 0 && cctrCode != null) {
                    long counter;
                    sql1 = "SELECT COUNT(1) FROM COSTCTR WHERE CCTR_CODE = '" + cctrCode + "'";
                    stmt1 = con.createStatement();
                    rs1 = stmt1.executeQuery(sql1);
                    if (rs1.next() && (counter = rs1.getLong(1)) == 0L) {
                        errCode = "VMCCTR1";
                    }
                } else {
                    sql1 = "SELECT COUNT(1) FROM ACCOUNTS_CCTR WHERE ACCT_CODE = '" + acctCode + "' AND CCTR_CODE = '" + cctrCode + "'";
                    stmt2 = con.createStatement();
                    rs2 = stmt2.executeQuery(sql1);
                    if (rs2.next()) {
                        long counter = rs2.getLong(1);
                        if (counter > 0L) {
                            errCode = "VMCCTR2";
                        } else if (counter == 0L && cctrCode.length() > 0 && cctrCode != null) {
                            errCode = "VMCCTR2";
                        }
                    }
                }
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "ITMException : ValidatorEJB : isCctrCode :==>\n");
                errCode = itme.getMessage();
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception : ValidatorEJB : isCctrCode :==>\n" + e.getMessage());
                e.printStackTrace();
                errCode = e.getMessage();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (stmt2 != null) {
                    stmt2.close();
                    stmt2 = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (SQLException se) {
                BaseLogger.log("0", userInfo, null, "Exception : [ValidatorNEJB][isCctrCode] :==>\n" + se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
        }
        return errCode;
    }

    public String isAcctCode(String siteCode, String acctCode, String modName, UserInfoBean userInfo) throws RemoteException, ITMException {
        String errCode = "";
        String siteSpec = "";
        Connection con = null;
        String sql1 = "";
        Statement stmt1 = null;
        ResultSet rs1 = null;
        String sql2 = "";
        Statement stmt2 = null;
        ResultSet rs2 = null;
        String sql3 = "";
        Statement stmt3 = null;
        ResultSet rs3 = null;
        StringBuffer sql4 = null;
        Statement stmt4 = null;
        ResultSet rs4 = null;
        try {
            try {
                String transDB = userInfo.getTransDB();
                ConnDriver mConnDriver = new ConnDriver();
                con = mConnDriver.getConnectDB(transDB);
                sql1 = "SELECT VAR_VALUE FROM FINPARM WHERE PRD_CODE = '999999' AND VAR_NAME = 'SITE_SPECIFIC_ACCT'";
                stmt1 = con.createStatement();
                rs1 = stmt1.executeQuery(sql1);
                if (rs1.next()) {
                    sql2 = "SELECT COUNT(1) FROM ACCOUNTS WHERE ACCT_CODE = '" + acctCode + "'";
                    stmt2 = con.createStatement();
                    rs2 = stmt1.executeQuery(sql2);
                    if (rs2.next()) {
                        if (rs2.getLong(1) != 0L) {
                            sql3 = "SELECT ACTIVE FROM ACCOUNTS WHERE ACCT_CODE = '" + acctCode + "'";
                            stmt3 = con.createStatement();
                            rs3 = stmt3.executeQuery(sql3);
                            if (rs3.next()) {
                                if (!rs3.getString(1).equals("Y")) {
                                    errCode = "VMACCTA";
                                } else {
                                    siteSpec = rs1.getString(1).trim();
                                    if (siteSpec.equals("Y") && siteSpec != null) {
                                        sql4 = new StringBuffer();
                                        sql4.append("SELECT COUNT(1) FROM SITE_ACCOUNT WHERE SITE_CODE = '");
                                        sql4.append(siteCode).append("' AND ACCT_CODE = '");
                                        sql4.append(acctCode).append("'");
                                        stmt4 = con.createStatement();
                                        rs4 = stmt4.executeQuery(sql4.toString());
                                        if (rs4.next() && rs4.getLong(1) == 0L) {
                                            errCode = "VMACCT4";
                                        }
                                    }
                                }
                            }
                        } else {
                            errCode = "VMACCT1";
                        }
                    }
                }
                if (rs3 != null) {
                    rs3.close();
                    rs3 = null;
                }
                if (stmt3 != null) {
                    stmt3.close();
                    stmt3 = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (stmt2 != null) {
                    stmt2.close();
                    stmt2 = null;
                }
                if (rs4 != null) {
                    rs4.close();
                    rs4 = null;
                }
                if (stmt4 != null) {
                    stmt4.close();
                    stmt4 = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "ITMException : ValidatorEJB : isAcctCode :==>\n" + itme.getMessage());
                errCode = itme.getMessage();
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception : ValidatorEJB : isAcctCode :==>\n" + e.getMessage());
                e.printStackTrace();
                errCode = e.getMessage();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs3 != null) {
                    rs3.close();
                    rs3 = null;
                }
                if (stmt3 != null) {
                    stmt3.close();
                    stmt3 = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (stmt1 != null) {
                    stmt1.close();
                    stmt1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (stmt2 != null) {
                    stmt2.close();
                    stmt2 = null;
                }
                if (rs4 != null) {
                    rs4.close();
                    rs4 = null;
                }
                if (stmt4 != null) {
                    stmt4.close();
                    stmt4 = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return errCode;
    }

    public String isFinEntity(String finEntity, String modName, UserInfoBean userInfo) throws RemoteException, ITMException {
        String errCode = "";
        String sql1 = "";
        Connection con = null;
        Statement stmt1 = null;
        ResultSet rs1 = null;
        try {
            long counter;
            String transDB = userInfo.getTransDB();
            ConnDriver mConnDriver = new ConnDriver();
            con = mConnDriver.getConnectDB(transDB);
            sql1 = "SELECT COUNT(1) FROM FINENT WHERE FIN_ENTITY = '" + finEntity + "'";
            stmt1 = con.createStatement();
            rs1 = stmt1.executeQuery(sql1);
            if (rs1.next() && (counter = rs1.getLong(1)) == 0L) {
                errCode = "VMFENTY1";
            }
            stmt1.close();
            con.close();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException : ValidatorEJB : isFinEntity :==>\n" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception : ValidatorEJB : isFinEntity :==>\n" + e.getMessage());
            e.printStackTrace();
            errCode = e.getMessage();
            throw new ITMException(e);
        }
        return errCode;
    }

    public String nfCheckPeriod(String modCode, java.util.Date tranDate, String siteCode, Connection conn) throws RemoteException, ITMException {
        Connection con = null;
        String errCode = "";
        String prdCode = "";
        String stat = "";
        String sql = "";
        Date procDate = null;
        ResultSet rsPeriod = null;
        Statement stmtPeriod = null;
        String dtFormat = "";
        SimpleDateFormat dtf = null;
        Object currDate = null;
        String dateString = "";
        Statement pstmt = null;
        try {
            try {
                con = conn;
                E12GenericUtility genericUtility = new E12GenericUtility();
                dtFormat = genericUtility.getApplDateFormat();
                dtf = new SimpleDateFormat(dtFormat);
                dateString = dtf.format(tranDate);
                BaseLogger.log("3", this.userInfo, null, "Converted Date : " + dateString);
                if (!"ADM_FIN_PUR_SAL_MFG_IC_DIS_HLT".equals(modCode.toUpperCase())) {
                    sql = "SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
                    pstmt = con.prepareStatement(sql);
                    pstmt.setTimestamp(1, Timestamp.valueOf(genericUtility.getValidDateTimeString(dateString, dtFormat, genericUtility.getDBDateFormat())));
                    rsPeriod = pstmt.executeQuery();
                    if (rsPeriod.next()) {
                        prdCode = rsPeriod.getString(1);
                    } else {
                        errCode = "VTPRD1";
                    }
                    if (pstmt != null) {
                        rsPeriod.close();
                        pstmt.close();
                        pstmt = null;
                    }
                    if (errCode.length() == 0) {
                        if (modCode.equals("ADM")) {
                            sql = "SELECT STAT_ADM,PROC_DATE FROM PERIOD_STAT WHERE SITE_CODE = '" + siteCode + "' AND PRD_CODE = '" + prdCode + "'";
                            stmtPeriod = con.createStatement();
                            rsPeriod = stmtPeriod.executeQuery(sql);
                            if (rsPeriod.next()) {
                                stat = rsPeriod.getString(1);
                                procDate = rsPeriod.getDate(2);
                                if (stat.equals("N")) {
                                    errCode = "VTPRDADM";
                                } else if (procDate.compareTo(tranDate) > 0) {
                                    errCode = "VTPRDTADM";
                                }
                            }
                            rsPeriod.close();
                        } else if (modCode.equals("FIN")) {
                            sql = "SELECT STAT_FIN,PROC_DATE FROM PERIOD_STAT WHERE SITE_CODE = '" + siteCode + "' AND PRD_CODE = '" + prdCode + "'";
                            stmtPeriod = con.createStatement();
                            rsPeriod = stmtPeriod.executeQuery(sql);
                            if (rsPeriod.next()) {
                                stat = rsPeriod.getString(1);
                                procDate = rsPeriod.getDate(2);
                                if (stat.equals("N")) {
                                    errCode = "VTPRDFIN";
                                } else if (procDate.compareTo(tranDate) > 0) {
                                    errCode = "VTPRDTFIN";
                                }
                            }
                            rsPeriod.close();
                        } else if (modCode.equals("PUR")) {
                            sql = "SELECT STAT_PUR,PROC_DATE FROM PERIOD_STAT WHERE SITE_CODE = '" + siteCode + "' AND PRD_CODE = '" + prdCode + "'";
                            stmtPeriod = con.createStatement();
                            rsPeriod = stmtPeriod.executeQuery(sql);
                            if (rsPeriod.next()) {
                                stat = rsPeriod.getString(1);
                                procDate = rsPeriod.getDate(2);
                                if (stat.equals("N")) {
                                    errCode = "VTPRDPUR";
                                } else if (procDate.compareTo(tranDate) > 0) {
                                    errCode = "VTPRDTPUR";
                                }
                            }
                            rsPeriod.close();
                        } else if (modCode.equals("SAL")) {
                            sql = "SELECT STAT_SAL,PROC_DATE FROM PERIOD_STAT WHERE SITE_CODE = '" + siteCode + "' AND PRD_CODE = '" + prdCode + "'";
                            stmtPeriod = con.createStatement();
                            rsPeriod = stmtPeriod.executeQuery(sql);
                            if (rsPeriod.next()) {
                                stat = rsPeriod.getString(1);
                                procDate = rsPeriod.getDate(2);
                                if (stat.equals("N")) {
                                    errCode = "VTPRDSAL";
                                } else if (procDate.compareTo(tranDate) > 0) {
                                    errCode = "VTPRDTSAL";
                                }
                            }
                            rsPeriod.close();
                        } else if (modCode.equals("MFG")) {
                            sql = "SELECT STAT_MFG,PROC_DATE FROM PERIOD_STAT WHERE SITE_CODE = '" + siteCode + "' AND PRD_CODE = '" + prdCode + "'";
                            stmtPeriod = con.createStatement();
                            rsPeriod = stmtPeriod.executeQuery(sql);
                            if (rsPeriod.next()) {
                                stat = rsPeriod.getString(1);
                                procDate = rsPeriod.getDate(2);
                                if (stat.equals("N")) {
                                    errCode = "VTPRDMFG";
                                } else if (procDate.compareTo(tranDate) > 0) {
                                    errCode = "VTPRDTMFG";
                                }
                            }
                            rsPeriod.close();
                        } else if (modCode.equals("IC") || modCode.equals("DIS")) {
                            sql = "SELECT STAT_IC,PROC_DATE FROM PERIOD_STAT WHERE SITE_CODE = '" + siteCode + "' AND PRD_CODE = '" + prdCode + "'";
                            stmtPeriod = con.createStatement();
                            rsPeriod = stmtPeriod.executeQuery(sql);
                            if (rsPeriod.next()) {
                                stat = rsPeriod.getString(1);
                                procDate = rsPeriod.getDate(2);
                                if (stat.equals("N")) {
                                    errCode = "VTPRDIC";
                                } else if (procDate.compareTo(tranDate) > 0) {
                                    errCode = "VTPRDTDIC";
                                }
                            }
                            rsPeriod.close();
                        } else if (modCode.equals("HLT")) {
                            sql = "SELECT STAT_HLT,PROC_DATE FROM PERIOD_STAT WHERE SITE_CODE = '" + siteCode + "' AND PRD_CODE = '" + prdCode + "'";
                            stmtPeriod = con.createStatement();
                            rsPeriod = stmtPeriod.executeQuery(sql);
                            if (rsPeriod.next()) {
                                stat = rsPeriod.getString(1);
                                procDate = rsPeriod.getDate(2);
                                if (stat.equals("N")) {
                                    errCode = "VTPRDHLT";
                                } else if (procDate.compareTo(tranDate) > 0) {
                                    errCode = "VTPRDTHLT";
                                }
                            } else {
                                errCode = "VTPRDHLT";
                            }
                            rsPeriod.close();
                        }
                        if (stmtPeriod != null) {
                            rsPeriod.close();
                            rsPeriod = null;
                            stmtPeriod.close();
                            stmtPeriod = null;
                        }
                    }
                }
            }
            catch (ITMException itme) {
                BaseLogger.log("0", this.userInfo, null, "ITmException : ValidatorNEJB : nfCheckPeriod :==>\n");
                errCode = itme.getMessage();
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception : ValidatorNEJB : nfCheckPeriod :==>\n" + e.getMessage());
                e.printStackTrace();
                errCode = e.getMessage();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (stmtPeriod != null) {
                    stmtPeriod.close();
                    stmtPeriod = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Finally Exception : ValidatorNEJB : nfCheckPeriod : ==>\n" + e.getMessage());
                e.printStackTrace();
                errCode = e.getMessage();
                throw new ITMException(e);
            }
        }
        return errCode;
    }

    public String confirmRecord(String tranIdFrom, String tranIdTo, UserInfoBean userInfo) throws RemoteException, ITMException {
        String errCode = "";
        Connection con = null;
        String sql1 = "";
        Object stmt1 = null;
        Object rs = null;
        try {
            String transDB = userInfo.getTransDB();
            ConnDriver mConnDriver = new ConnDriver();
            con = mConnDriver.getConnectDB(transDB);
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException : ValidatorEJB : confirmRecord :==>\n" + itme.getMessage());
            errCode = itme.getMessage();
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception : ValidatorEJB : confirmRecord :==>\n" + e.getMessage());
            e.printStackTrace();
            errCode = e.getMessage();
            throw new ITMException(e);
        }
        return errCode;
    }

    public String sparesReqGen(UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    public String sparesReqGen(String xmlString, String windowName, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    public String sparesReqGen(Document dom, String windowName, UserInfoBean userInfo) throws RemoteException, ITMException {
        return "";
    }

    public String getErrorString(String columnName, String msgNo, String userId, String oldErrString, UserInfoBean userInfo) throws RemoteException, ITMException {
        Connection conn = null;
        Statement pStmt = null;
        Statement pStmtProID = null;
        Statement stmt = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        String msgType = "";
        String msgString = "";
        String msgDescription = "";
        String lmsgString = "";
        String profileId = "";
        String errSource = "";
        String tempMsgType = "";
        String msgOption = "";
        String redirerr = "";
        String soundPlay = "";
        StringBuffer newErrString = null;
        try {
            try {
                conn = this.getConnection();
                String sqlQuery = "SELECT MSG_TYPE,MSG_STR,MSG_DESCR,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE FROM MESSAGES WHERE MSG_NO='" + msgNo + "'";
                stmt = conn.prepareStatement(sqlQuery);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    msgType = rs.getString("MSG_TYPE");
                    msgString = rs.getString("MSG_STR");
                    msgDescription = rs.getString("MSG_DESCR");
                    msgOption = rs.getString("MSG_OPT");
                    soundPlay = rs.getString("ALARM");
                    errSource = rs.getString("ERR_SOURCE");
                } else {
                    lmsgString = "Message Not Defined >>" + msgNo;
                    msgDescription = String.valueOf(Messages.getString("ValidatorEJB_messageIdNotFound")) + "[" + msgNo + "]";
                    msgType = "E";
                    msgString = "";
                }
                if (msgType.equals("E") || msgType.trim().length() == 0) {
                    String sqlQuery1 = "SELECT PROFILE_ID FROM USERS WHERE CODE='" + userId + "'";
                    pStmtProID = conn.prepareStatement(sqlQuery1);
                    rs1 = pStmtProID.executeQuery();
                    if (rs1.next()) {
                        profileId = rs1.getString("PROFILE_ID");
                        if (profileId == null) {
                            profileId = "";
                        }
                        if ((rs2 = (pStmt = conn.prepareStatement(sqlQuery1 = "SELECT MSG_TYPE FROM MESSAGES_LEVEL WHERE MSG_NO='" + msgNo.trim() + "' AND ( PROFILE_ID='" + profileId.trim() + "' OR PROFILE_ID = 'X' )")).executeQuery()).next()) {
                            tempMsgType = rs2.getString("MSG_TYPE");
                        }
                    }
                    if (tempMsgType != null && tempMsgType.trim().length() > 0) {
                        msgType = tempMsgType;
                    }
                }
                if (msgType.equals("W")) {
                    msgString = "Warning : " + msgString;
                } else if (msgType.equals("P")) {
                    msgString = "Prompt : " + msgString;
                } else if (msgType.equals("F")) {
                    msgString = "Information : " + msgString;
                } else {
                    msgType = "E";
                    msgString = "Error : " + msgString;
                }
                if (errSource != null && errSource.trim().equals("D")) {
                    msgDescription = String.valueOf(msgDescription) + " * From Database ";
                }
                if (redirerr == null || redirerr.trim().length() == 0) {
                    redirerr = "1";
                }
                if (msgOption != null && msgOption.trim().equals("M")) {
                    redirerr = redirerr.trim().equals("1") ? "2" : "1";
                }
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "ITMException : [ValidatorNEJB][getErrorString] :==>\n" + itme.getMessage());
                throw itme;
            }
            catch (SQLException se) {
                lmsgString = "Database Error >>" + se.getErrorCode();
                msgDescription = se.getMessage();
                msgType = "";
                msgString = "";
                BaseLogger.log("0", userInfo, null, "Exception : [ValidatorNEJB][getErrorString] :==>\n" + se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception : [ValidatorNEJB][getErrorString] :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (pStmtProID != null) {
                    pStmtProID.close();
                    pStmtProID = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException se) {
                lmsgString = "Database Error >>" + se.getErrorCode();
                msgDescription = se.getMessage();
                msgType = "";
                msgString = "";
                BaseLogger.log("0", userInfo, null, "Exception : [ValidatorNEJB][getErrorString] :==>\n" + se.getMessage());
                se.printStackTrace();
                throw new ITMException(se);
            }
        }
        StringBuffer errStringXml = new StringBuffer();
        errStringXml.append("<error id=\"");
        errStringXml.append(msgNo).append("\" type=\"").append(msgType).append("\" column_name=\"");
        errStringXml.append(columnName).append("\">\r\n");
        errStringXml.append("<message><![CDATA[ " + msgString + "]]></message>");
        errStringXml.append("<description><![CDATA[" + msgDescription + "]]></description>");
        errStringXml.append("<type><![CDATA[" + msgType + "]]></type>");
        errStringXml.append("<option><![CDATA[" + msgOption + "]]></option>");
        errStringXml.append("<alarm><![CDATA[" + soundPlay + "]]></alarm>");
        errStringXml.append("<source><![CDATA[" + errSource + "]]></source>");
        errStringXml.append("<trace><![CDATA[]]></trace>");
        errStringXml.append("<redirect><![CDATA[" + redirerr + "]]></redirect>\r\n</error>\r\n");
        try {
            if (oldErrString != null && oldErrString.length() > 0) {
                E12GenericUtility genUtil = new E12GenericUtility();
                Document oldErrDom = genUtil.parseString(oldErrString);
                Node errorsNode = oldErrDom.getElementsByTagName("Errors").item(0);
                if (errorsNode != null) {
                    Node importedNode = oldErrDom.importNode(genUtil.parseString(errStringXml.toString()), true);
                    errorsNode.appendChild(importedNode);
                    newErrString = new StringBuffer(genUtil.serializeDom(oldErrDom));
                }
            } else {
                newErrString = new StringBuffer("<?xml version=\"1.0\"?><Root>\r\n<Errors>\r\n");
                newErrString.append(errStringXml);
                newErrString.append("</Errors>\r\n</Root>");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newErrString.toString();
    }

    public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException, ITMException {
        return "";
    }

    public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException, ITMException {
        Document dom = null;
        Document domHdr = null;
        Document domAll = null;
        String valueXmlString = "";
        E12GenericUtility genericUtility = new E12GenericUtility();
        this.conn = this.getConnection();
        this.formName = formName;
        try {
            try {
                if (xmlString != null && xmlString.trim().length() > 0) {
                    dom = genericUtility.parseString(xmlString);
                }
                if (xmlString1 != null && xmlString1.trim().length() > 0) {
                    domHdr = genericUtility.parseString(xmlString1);
                }
                if (xmlString2 != null && xmlString2.trim().length() > 0) {
                    domAll = genericUtility.parseString(xmlString2);
                }
                this.objName = this.getObjName(dom, objContext);
                valueXmlString = this.wfValData(dom, domHdr, domAll, objContext, editFlag, xtraParams);
                valueXmlString = this.getValDataErrorString();
            }
            catch (Exception e) {
                System.out.println("Exception [" + this.getClass().getSimpleName() + "] : [wfValData(S)] " + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (this.conn != null) {
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception e1) {
                System.out.println("Exception in closing connection[" + this.getClass().getSimpleName() + "] : [wfValData(S)] " + e1.getMessage());
            }
        }
        return valueXmlString;
    }

    public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams, UserInfoBean userInfo, String formName) throws RemoteException, ITMException {
        return "";
    }

    public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams, UserInfoBean userInfo, String formName) throws RemoteException, ITMException {
        String errorStr = "";
        this.formName = formName;
        this.setUserInfo(userInfo);
        try {
            errorStr = this.wfValData(xmlString, xmlString1, xmlString2, objContext, editFlag, xtraParams, this.formName);
        }
        catch (Exception e) {
            System.out.println("Exception wfValData [" + this.getClass().getSimpleName() + "] : [wfValData(S)] " + e.getMessage());
            throw new ITMException(e);
        }
        return errorStr;
    }

    public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams, String formName) throws RemoteException, ITMException {
        Document dom = null;
        Document domHdr = null;
        Document domAll = null;
        String valueXmlString = "";
        E12GenericUtility genericUtility = new E12GenericUtility();
        this.formName = formName;
        this.conn = this.getConnection();
        this.isFormModifiedDataList = new HashMap();
        try {
            try {
                if (xmlString != null && xmlString.trim().length() > 0) {
                    dom = genericUtility.parseString(xmlString);
                }
                if (xmlString1 != null && xmlString1.trim().length() > 0) {
                    domHdr = genericUtility.parseString(xmlString1);
                }
                if (xmlString2 != null && xmlString2.trim().length() > 0) {
                    domAll = genericUtility.parseString(xmlString2);
                }
                this.objName = this.getObjName(dom, objContext);
                valueXmlString = this.itemChanged(dom, domHdr, domAll, objContext, currentColumn, editFlag, xtraParams);
                valueXmlString = this.getChangedData(dom, domHdr, domAll, objContext, currentColumn, editFlag, xtraParams);
            }
            catch (Exception e) {
                System.out.println("Exception [" + this.getClass().getSimpleName() + "] : [itemChanged(S)] " + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (this.conn != null) {
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception e1) {
                System.out.println("Exception in closing connection[" + this.getClass().getSimpleName() + "] : [itemChanged(S)] " + e1.getMessage());
            }
        }
        return valueXmlString;
    }

    public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams, String formName) throws RemoteException, ITMException {
        return "";
    }

    public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams, UserInfoBean userInfo, String formName) throws RemoteException, ITMException {
        String retStr = "";
        this.formName = formName;
        this.setUserInfo(userInfo);
        try {
            retStr = this.itemChanged(xmlString, xmlString1, xmlString2, objContext, currentColumn, editFlag, xtraParams, this.formName);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retStr;
    }

    public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams, UserInfoBean userInfo, String formName) throws RemoteException, ITMException {
        return "";
    }

    private static String generateRandomString() {
        String randomStr = "";
        char[] characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890abcdefghijklmnopqrstuvwxyz".toCharArray();
        int i = 0;
        int cLen = characters.length;
        while (i < 5) {
            int num = (int)Math.floor(Math.random() * (double)cLen);
            randomStr = String.valueOf(randomStr) + String.valueOf(characters[num]);
            ++i;
        }
        String time = String.valueOf(new java.util.Date().getHours()) + "-" + new java.util.Date().getMinutes();
        return String.valueOf(time) + randomStr;
    }

    public String getChangedData(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
        E12GenericUtility genericUtility = new E12GenericUtility();
        StringBuffer valueXmlString = new StringBuffer();
        Object parentNodeList = null;
        boolean currForm = false;
        boolean formNo = false;
        try {
            System.out.println("isFormModifiedDataList in getChangedData [ " + this.isFormModifiedDataList.toString() + " ]");
            valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
            valueXmlString.append(editFlag).append("</editFlag></header>");
            int fno = 1;
            while (fno < 11) {
                String formKey = "Detail" + fno;
                if (this.isFormModifiedDataList.containsKey(formKey)) {
                    int colCnt = 0;
                    HashMap hm = (HashMap)this.isFormModifiedDataList.get("Detail" + fno);
                    System.out.println("isFormModifiedDataList in getChangedData [colCnt =  " + fno + "] :: [ " + hm.toString() + " ]");
                    System.out.println("isFormModifiedDataList in getChangedData [colCnt-A =  " + fno + "] :: [ " + hm.toString() + " ]");
                    for (Object key : hm.keySet()) {
                        System.out.println("isFormModifiedDataList in getChangedData [colCnt-B =  " + fno + "] :: hm.get(key) :: [ " + hm.get(key).toString() + " ]");
                        HashMap hmc = (HashMap)hm.get(key);
                        String colName = (String)key;
                        System.out.println("isFormModifiedDataList in getChangedData [colCnt-C =  " + fno + "] :: cOLUMN nAME :: [ " + colName + " ]");
                        String colVal = "";
                        colVal = ("" + fno).equalsIgnoreCase(objContext) ? this.whenNull(genericUtility.getColumnValue(colName, dom)) : this.whenNull(genericUtility.getColumnValue(colName, dom1));
                        System.out.println("isFormModifiedDataList in getChangedData [colCnt-D =  " + fno + "] :: cOLUMN vALUE :: [ " + colVal + " ]");
                        if (++colCnt == 1) {
                            valueXmlString.append("<Detail" + fno + ">\r\n");
                        }
                        valueXmlString.append("<" + colName);
                        if (hmc.containsKey("protect")) {
                            valueXmlString.append(" protect=\"" + (String)hmc.get("protect") + "\"");
                        }
                        valueXmlString.append("><![CDATA[" + colVal + "]]></" + colName + ">\r\n");
                    }
                    if (colCnt > 0) {
                        valueXmlString.append("</Detail" + fno + ">\r\n");
                    }
                }
                ++fno;
            }
            valueXmlString.append("</Root>\r\n");
        }
        catch (Exception e) {
            System.out.println("Exception [" + this.getClass().getSimpleName() + "] : [getChangedData] " + e.getMessage());
            throw new ITMException(e);
        }
        System.out.println("Value returned from  [" + this.getClass().getSimpleName() + "] : [getChangedData] :::: [ " + valueXmlString.toString() + " ]");
        return valueXmlString.toString();
    }

    public void setItem(Document dom, int rowNum, String colName, String colVal) throws RemoteException, ITMException {
        try {
            colVal = this.whenNull(colVal);
            this.setFieldValue(dom, colName, colVal);
            NodeList parentNodeList = null;
            int currForm = 0;
            int i = 1;
            while (i < 11) {
                parentNodeList = dom.getElementsByTagName("Detail" + i);
                if (parentNodeList != null && parentNodeList.getLength() > 0) {
                    currForm = i;
                    break;
                }
                ++i;
            }
            System.out.println("Current Form No in setItem [ " + currForm + " ]");
            if (currForm > 0) {
                HashMap hm = new HashMap();
                HashMap hmc = new HashMap();
                if (this.isFormModifiedDataList.containsKey("Detail" + currForm)) {
                    hm = (HashMap)this.isFormModifiedDataList.get("Detail" + currForm);
                    if (this.isFormModifiedDataList.containsKey(colName)) {
                        hmc = (HashMap)hm.get(colName);
                    }
                }
                hmc.put("MODIFIED", "TRUE");
                hm.put(colName, hmc);
                this.isFormModifiedDataList.put("Detail" + currForm, hm);
                System.out.println("isFormModifiedDataList in setItem [ " + this.isFormModifiedDataList.toString() + " ]");
            }
        }
        catch (Exception e) {
            System.out.println("Exception [" + this.getClass().getSimpleName() + "] : [setItem] " + e.getMessage());
            throw new ITMException(e);
        }
    }

    public void setItem(Document dom, int rowNum, String colName, int colVal) throws RemoteException, ITMException {
        try {
            String strVal = "";
            strVal = String.valueOf(colVal);
            this.setItem(dom, rowNum, colName, strVal);
        }
        catch (Exception e) {
            System.out.println("Exception [" + this.getClass().getSimpleName() + "] : [setItem] " + e.getMessage());
            throw new ITMException(e);
        }
    }

    public void setItem(Document dom, int rowNum, String colName, double colVal) throws RemoteException, ITMException {
        try {
            String strVal = "";
            strVal = String.valueOf(colVal);
            this.setItem(dom, rowNum, colName, strVal);
        }
        catch (Exception e) {
            System.out.println("Exception [" + this.getClass().getSimpleName() + "] : [setItem] " + e.getMessage());
            throw new ITMException(e);
        }
    }

    public void setItem(Document dom, int rowNum, String colName, float colVal) throws RemoteException, ITMException {
        try {
            String strVal = "";
            strVal = String.valueOf(colVal);
            this.setItem(dom, rowNum, colName, strVal);
        }
        catch (Exception e) {
            System.out.println("Exception [" + this.getClass().getSimpleName() + "] : [setItem] " + e.getMessage());
            throw new ITMException(e);
        }
    }

    public void setItem(Document dom, int rowNum, String colName, long colVal) throws RemoteException, ITMException {
        try {
            String strVal = "";
            strVal = String.valueOf(colVal);
            this.setItem(dom, rowNum, colName, strVal);
        }
        catch (Exception e) {
            System.out.println("Exception [" + this.getClass().getSimpleName() + "] : [setItem] " + e.getMessage());
            throw new ITMException(e);
        }
    }

    public void setItem(Document dom, int rowNum, String colName, java.util.Date colVal) throws RemoteException, ITMException {
        try {
            String strVal = "";
            E12GenericUtility genericUtility = new E12GenericUtility();
            if (colVal == null) {
                strVal = "";
            } else {
                String dtFormat = genericUtility.getApplDateFormat();
                SimpleDateFormat dtf = new SimpleDateFormat(dtFormat);
                strVal = dtf.format(colVal);
            }
            this.setItem(dom, rowNum, colName, strVal);
        }
        catch (Exception e) {
            System.out.println("Exception [" + this.getClass().getSimpleName() + "] : [setItem] " + e.getMessage());
            throw new ITMException(e);
        }
    }

    public void setFieldValue(Document dom, String nodeName, String nodeVal) throws RemoteException, ITMException {
        try {
            Node tempNode = dom.getElementsByTagName(nodeName).item(0);
            if (tempNode != null) {
                if (tempNode.getFirstChild() == null) {
                    CDATASection cDataSection = dom.createCDATASection(nodeVal);
                    tempNode.appendChild(cDataSection);
                } else {
                    tempNode.getFirstChild().setNodeValue(nodeVal);
                }
            }
            tempNode = null;
        }
        catch (Exception e) {
            System.out.println("Exception [" + this.getClass().getSimpleName() + "] : [setFieldValue] " + e.getMessage());
            throw new ITMException(e);
        }
    }

    public String getItemString(Document dom, int rowNum, String colName) throws RemoteException, ITMException {
        String colVal = "";
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            colVal = genericUtility.getColumnValue(colName, dom);
            if (colVal == null) {
                colVal = "";
            }
        }
        catch (Exception e) {
            System.out.println("Exception [" + this.getClass().getSimpleName() + "] : [getItemString] " + e.getMessage());
            throw new ITMException(e);
        }
        return colVal;
    }

    public String getItemDate(Document dom, int rowNum, String colName) throws RemoteException, ITMException {
        String colVal = "";
        java.util.Date dateVal = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            colVal = genericUtility.getColumnValue(colName, dom);
            if (colVal == null) {
                colVal = "";
            } else {
                dateVal = genericUtility.getDateObject(colVal);
            }
        }
        catch (Exception e) {
            System.out.println("Exception [" + this.getClass().getSimpleName() + "] : [getItemString] " + e.getMessage());
            throw new ITMException(e);
        }
        return colVal;
    }

    public void gbfItemchgModifierDs(Document dom, String colName, String attributeName, String attributeValue) throws RemoteException, ITMException {
        try {
            NodeList parentNodeList = null;
            int currForm = 0;
            int i = 1;
            while (i < 11) {
                parentNodeList = dom.getElementsByTagName("Detail" + i);
                if (parentNodeList != null && parentNodeList.getLength() > 0) {
                    currForm = i;
                    break;
                }
                ++i;
            }
            if (currForm > 0) {
                E12GenericUtility genericUtility = new E12GenericUtility();
                HashMap hm = new HashMap();
                HashMap hmc = new HashMap();
                if (this.isFormModifiedDataList.containsKey("Detail" + currForm)) {
                    hm = (HashMap)this.isFormModifiedDataList.get("Detail" + currForm);
                    if (this.isFormModifiedDataList.containsKey(colName)) {
                        hmc = (HashMap)hm.get(colName);
                    }
                }
                hmc.put("MODIFIED", "TRUE");
                hmc.put(attributeName, attributeValue);
                hm.put(colName, hmc);
                this.isFormModifiedDataList.put("Detail" + currForm, hm);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorNEJB][gbfItemchgModifierDs] :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public String whenNull(String strVal) {
        if (strVal == null) {
            strVal = "";
        }
        return strVal;
    }

    public String whenNull(String strVal, boolean toBeTrimmed) {
        if (strVal == null) {
            strVal = "";
        }
        if (toBeTrimmed) {
            strVal = strVal.trim();
        }
        return strVal;
    }

    public String insertError(String errorCode, String focusFieldName) throws RemoteException, ITMException {
        String msgType = "E";
        String profileId = "";
        StringBuffer errorBuffer = new StringBuffer();
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            this.errList.add((Object)errorCode);
            this.errFields.add((Object)focusFieldName);
            String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
            pst = this.conn.prepareStatement(sql);
            pst.setString(1, errorCode);
            rs = pst.executeQuery();
            if (rs.next()) {
                msgType = rs.getString("MSG_TYPE");
            }
            rs.close();
            rs = null;
            pst.close();
            pst = null;
            profileId = this.userInfo.getProfileId();
            if (this.winName != null && this.winName.trim().length() > 0) {
                sql = "SELECT MSG_TYPE FROM MESSAGES_LEVEL WHERE PROFILE_ID = ? AND MSG_NO = ? AND ? = WIN_NAME";
                pst = this.conn.prepareStatement(sql);
                pst.setString(1, profileId);
                pst.setString(2, errorCode);
                pst.setString(3, this.winName);
            } else {
                sql = "SELECT MSG_TYPE FROM MESSAGES_LEVEL WHERE PROFILE_ID = ? AND MSG_NO = ?";
                pst = this.conn.prepareStatement(sql);
                pst.setString(1, profileId);
                pst.setString(2, errorCode);
            }
            rs = pst.executeQuery();
            if (rs.next()) {
                msgType = rs.getString("MSG_TYPE");
            }
            rs.close();
            rs = null;
            pst.close();
            pst = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorNEJB][insertError] :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        BaseLogger.log("0", this.userInfo, null, "insertError -- errList [" + this.errList.toString() + "]  Msg Type [" + msgType + "]");
        return msgType;
    }

    private String getValDataErrorString() throws RemoteException, ITMException {
        ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
        StringBuffer errrorBuffer = new StringBuffer();
        String userId = this.userInfo.getLoginCode();
        try {
            int errLen = this.errList.size();
            if (errLen > 0) {
                errrorBuffer.append("<Root>\r\n<Errors>\r\n");
            }
            int i = 0;
            while (i < errLen) {
                String errorStr = this.whenNull(itmDBAccessEJB.getErrorString((String)this.errFields.get(i), (String)this.errList.get(i), userId, "", this.conn));
                int p1 = errorStr.indexOf("<error");
                if (p1 != -1) {
                    errorStr = "\r\n" + errorStr.substring(p1);
                }
                if ((p1 = errorStr.indexOf("</error>")) != -1) {
                    errorStr = String.valueOf(errorStr.substring(0, p1 + 8)) + "\r\n";
                }
                BaseLogger.log("0", this.userInfo, null, "getValDataErrorString -- errorStr [" + errorStr + "]");
                errrorBuffer.append(errorStr);
                BaseLogger.log("0", this.userInfo, null, "getValDataErrorString -- errrorBuffer [" + errrorBuffer.toString() + "]");
                ++i;
            }
            if (errLen > 0) {
                errrorBuffer.append("</Errors>\r\n</Root>\r\n");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : [ValidatorNEJB][insertError] :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return errrorBuffer.toString();
    }

    private String getObjName(Document dom, String objContext) {
        NamedNodeMap etlAttributes;
        Node elementName = null;
        Object parentNode = null;
        NodeList elementList = null;
        Object elementAttr = null;
        String objName = "";
        elementList = dom.getElementsByTagName("Detail" + objContext);
        elementName = elementList.item(0);
        if (elementName != null && ("Detail" + objContext).equalsIgnoreCase(elementName.getNodeName()) && (etlAttributes = elementName.getAttributes()) != null && etlAttributes.getNamedItem("objName") != null) {
            objName = etlAttributes.getNamedItem("objName").getNodeValue();
        }
        return objName;
    }

    public String gbfGetArgval(String xtraParams, String argName) {
        String retVal = "";
        try {
            retVal = this.getValueFromXTRA_PARAMS(xtraParams, argName);
            if (retVal != null && retVal.equalsIgnoreCase("-1")) {
                retVal = "";
            }
        }
        catch (Exception e) {
            retVal = "";
        }
        return retVal;
    }
}

