/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import oracle.sql.CLOB;

public class APIUtility {
    public void writeApiCallLog(UserInfoBean userInfo, StringBuffer responseInfo, String callStatus, String appId, String ipAddress) throws ITMException {
        this.writeApiCallLog(userInfo, responseInfo.toString(), callStatus, appId, ipAddress, "", "", "", "", "", "", "");
    }

    public void writeApiCallLog(UserInfoBean userInfo, String responseInfo, String callStatus, String appId, String ipAddress, String requestData, String apiName, String apiURL, String apiScope, String apiType, String refId, String refSer) throws ITMException {
        BaseLogger.log("3", null, null, "userInfo:: APIUtility[" + userInfo + "]");
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String tranID = "";
        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
        ConnDriver connDriver = new ConnDriver();
        String siteCode = "NA";
        String userCode = "NA";
        String chgTerm = ipAddress;
        String enterprise = "NA";
        try {
            try {
                if (userInfo != null) {
                    conn = connDriver.getConnectDB(userInfo);
                    tranID = commonDBAccessEJB.generateSeq("comm_log_seq", 15, userInfo.getTransDB());
                    siteCode = userInfo.getSiteCode();
                    userCode = userInfo.getLoginCode();
                    enterprise = userInfo.getEnterprise();
                } else {
                    conn = connDriver.getConnectDB("Driver");
                    tranID = commonDBAccessEJB.generateSeq("comm_log_seq", 15, "Driver");
                }
                String responseInfoString = responseInfo.toString();
                BaseLogger.log("3", null, null, "APIUtility.writeApiCallLog() siteCode : [" + siteCode + "]");
                BaseLogger.log("3", null, null, "APIUtility.writeApiCallLog() userCode : [" + userCode + "]");
                BaseLogger.log("3", null, null, "APIUtility.writeApiCallLog() chgTerm  : [" + chgTerm + "]");
                DatabaseMetaData md = conn.getMetaData();
                rs = md.getColumns(null, null, "API_CALL_LOG", "APP_ID");
                String sqlQuery = "";
                if (rs.next()) {
                    sqlQuery = "INSERT INTO API_CALL_LOG (TRAN_ID,CALL_DATE,SITE_CODE,USER_ID,CALL_TYPE,REC_TYPE,NO_OF_RECORDS,CALL_STATUS,RESPONSE_ID,RESPONSE_INFO,CHG_USER,CHG_DATE,CHG_TERM,APP_ID, ENTERPRISE, REQUEST_DATA, API_NAME, API_TYPE, API_URL, API_SCOPE, REF_ID, REF_SER ) \nVALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    pstmt = conn.prepareStatement(sqlQuery);
                    pstmt.setString(1, tranID);
                    pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(3, siteCode);
                    pstmt.setString(4, userCode);
                    pstmt.setString(5, "E");
                    pstmt.setString(6, "");
                    pstmt.setString(7, "");
                    pstmt.setString(8, callStatus);
                    pstmt.setString(9, this.getResponseID());
                    CLOB responseInfoClob = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                    responseInfoClob.putString(1L, responseInfoString);
                    pstmt.setClob(10, (Clob)responseInfoClob);
                    pstmt.setString(11, userCode);
                    pstmt.setTimestamp(12, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(13, chgTerm);
                    pstmt.setString(14, appId);
                    pstmt.setString(15, enterprise);
                    CLOB requestDataClob = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                    requestDataClob.putString(1L, requestData);
                    pstmt.setClob(16, (Clob)requestDataClob);
                    pstmt.setString(17, apiName);
                    pstmt.setString(18, apiType);
                    pstmt.setString(19, apiURL);
                    pstmt.setString(20, apiScope);
                    pstmt.setString(21, refId);
                    pstmt.setString(22, refSer);
                    int insCnt = pstmt.executeUpdate();
                    if (insCnt > 0) {
                        conn.commit();
                    }
                    BaseLogger.log("3", null, null, "APIUtility.writeApiCallLog() APP_ID EXISTS");
                } else {
                    sqlQuery = "INSERT INTO API_CALL_LOG (TRAN_ID,CALL_DATE,SITE_CODE,USER_ID,CALL_TYPE,REC_TYPE,NO_OF_RECORDS,CALL_STATUS,RESPONSE_ID,RESPONSE_INFO,CHG_USER,CHG_DATE,CHG_TERM, ENTERPRISE, REQUEST_DATA, API_NAME, API_TYPE, API_URL, API_SCOPE, REF_ID, REF_SER) \nVALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    pstmt = conn.prepareStatement(sqlQuery);
                    pstmt.setString(1, tranID);
                    pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(3, siteCode);
                    pstmt.setString(4, userCode);
                    pstmt.setString(5, "E");
                    pstmt.setString(6, "");
                    pstmt.setString(7, "");
                    pstmt.setString(8, callStatus);
                    pstmt.setString(9, this.getResponseID());
                    CLOB responseInfoClob = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                    responseInfoClob.putString(1L, responseInfoString);
                    pstmt.setClob(10, (Clob)responseInfoClob);
                    pstmt.setString(11, userCode);
                    pstmt.setTimestamp(12, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(13, chgTerm);
                    pstmt.setString(14, enterprise);
                    CLOB requestDataClob = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                    requestDataClob.putString(1L, requestData);
                    pstmt.setClob(15, (Clob)requestDataClob);
                    pstmt.setString(16, apiName);
                    pstmt.setString(17, apiType);
                    pstmt.setString(18, apiURL);
                    pstmt.setString(19, apiScope);
                    pstmt.setString(20, refId);
                    pstmt.setString(21, refSer);
                    int insCnt = pstmt.executeUpdate();
                    if (insCnt > 0) {
                        conn.commit();
                    }
                    BaseLogger.log("3", null, null, "APIUtility.writeApiCallLog() APP_ID DOESN'T EXISTS");
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "APIUtility.writeApiCallLog() Exception message.........:" + E12GenericUtility.getStackTrace(e));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "APIUtility.writeApiCallLog() finally Exception message.........:" + E12GenericUtility.getStackTrace(e));
            }
        }
    }

    public void updateApiCallLog(UserInfoBean userInfo, String responseInfo, String callStatus, String appId, String ipAddress, String requestData, String apiName, String apiURL, String apiScope, String apiType, String refId, String refSer, String tranId) throws ITMException {
        Connection conn = null;
        Statement pstmt = null;
        Statement preparedStatement = null;
        ResultSet rs = null;
        ConnDriver connDriver = new ConnDriver();
        String siteCode = "NA";
        String userCode = "NA";
        String chgTerm = ipAddress;
        try {
            try {
                if (userInfo != null) {
                    conn = connDriver.getConnectDB(userInfo);
                    siteCode = userInfo.getSiteCode();
                    userCode = userInfo.getLoginCode();
                } else {
                    conn = connDriver.getConnectDB();
                }
                String responseInfoString = responseInfo.toString();
                BaseLogger.log("3", null, null, "APIUtility.updateApiCallLog() tranId : [" + tranId + "]");
                BaseLogger.log("3", null, null, "APIUtility.updateApiCallLog() siteCode : [" + siteCode + "]");
                BaseLogger.log("3", null, null, "APIUtility.updateApiCallLog() userCode : [" + userCode + "]");
                BaseLogger.log("3", null, null, "APIUtility.updateApiCallLog() chgTerm  : [" + chgTerm + "]");
                String sqlQuery = "SELECT COUNT(*) AS COUNT FROM API_CALL_LOG WHERE TRAN_ID = '" + tranId + "'";
                preparedStatement = conn.prepareStatement(sqlQuery);
                rs = preparedStatement.executeQuery();
                if (rs.next()) {
                    int logCount = rs.getInt("COUNT");
                    BaseLogger.log("3", null, null, "APIUtility.updateApiCallLog() logCount = [" + logCount + "]");
                    if (logCount > 0) {
                        sqlQuery = "UPDATE API_CALL_LOG SET CALL_DATE = ?, CALL_STATUS = ?, RESPONSE_INFO = ?, REQUEST_DATA = ?, CHG_USER = ?, CHG_DATE = ?, CHG_TERM = ? WHERE TRAN_ID = ?";
                        pstmt = conn.prepareStatement(sqlQuery);
                        pstmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                        pstmt.setString(2, callStatus);
                        CLOB responseInfoClob = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                        responseInfoClob.putString(1L, responseInfoString);
                        pstmt.setClob(3, (Clob)responseInfoClob);
                        CLOB requestDataClob = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                        requestDataClob.putString(1L, requestData);
                        pstmt.setClob(4, (Clob)requestDataClob);
                        pstmt.setString(5, userCode);
                        pstmt.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                        pstmt.setString(7, chgTerm);
                        pstmt.setString(8, tranId);
                        int updateCount = pstmt.executeUpdate();
                        BaseLogger.log("3", null, null, "APIUtility.updateApiCallLog() updateCount = [" + updateCount + "]");
                        if (updateCount > 0) {
                            conn.commit();
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                    } else {
                        this.writeApiCallLog(userInfo, responseInfoString, callStatus, appId, ipAddress, requestData, apiName, apiURL, apiScope, apiType, refId, refSer);
                    }
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                    preparedStatement = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "APIUtility.updateApiCallLog() Exception message.........:" + E12GenericUtility.getStackTrace(e));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                    preparedStatement = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "APIUtility.updateApiCallLog() finally Exception message.........:" + E12GenericUtility.getStackTrace(e));
            }
        }
    }

    public String getResponseID() {
        String result = "";
        return result;
    }

    public ArrayList<String> getAPIKey(UserInfoBean userInfo, String apiName) {
        String resultStr = "";
        Connection con = null;
        Statement stmt = null;
        ResultSet mResultSet = null;
        Statement entStmt = null;
        ResultSet entResultSet = null;
        ArrayList<String> apiKeyParams = new ArrayList<String>();
        String sql = "";
        String licenseKey = "";
        String apiScope = "";
        ConnDriver mConnDriver = new ConnDriver();
        try {
            try {
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd-MMM-yy");
                LocalDateTime now = LocalDateTime.now();
                String sysDate = dtf.format(now);
                con = mConnDriver.getConnectDB("Driver");
                sql = "select COUNT(*) AS count from ENT_EXT_API_KEY where ENTERPRISE = ? AND API_NAME = ? AND API_SCOPE = ? AND EFF_FROM <= ? AND (VALID_UPTO is null OR VALID_UPTO = '' OR VALID_UPTO >= ?)";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, userInfo.getEnterprise());
                stmt.setString(2, apiName);
                stmt.setString(3, "E");
                stmt.setString(4, sysDate);
                stmt.setString(5, sysDate);
                mResultSet = stmt.executeQuery();
                while (mResultSet.next()) {
                    int cnt = mResultSet.getInt("count");
                    if (cnt > 0) {
                        sql = "select API_KEY from ENT_EXT_API_KEY where ENTERPRISE = ? AND API_NAME = ? AND API_SCOPE = ? AND EFF_FROM <= ? AND (VALID_UPTO is null OR VALID_UPTO = '' OR VALID_UPTO >= ?)";
                        entStmt = con.prepareStatement(sql);
                        entStmt.setString(1, userInfo.getEnterprise());
                        entStmt.setString(2, apiName);
                        entStmt.setString(3, "E");
                        entStmt.setString(4, sysDate);
                        entStmt.setString(5, sysDate);
                        entResultSet = entStmt.executeQuery();
                        while (entResultSet.next()) {
                            apiKeyParams.add(entResultSet.getString("API_KEY"));
                            apiKeyParams.add("E");
                        }
                        BaseLogger.log("3", null, null, "InvoiceReader readInvoice() apiKeyParams 490:::" + apiKeyParams);
                        entResultSet.close();
                        entResultSet = null;
                        entStmt.close();
                        entStmt = null;
                        continue;
                    }
                    sql = "select * from ENT_EXT_API_KEY where API_NAME = ? AND API_SCOPE = ?  AND EFF_FROM <= ? AND (VALID_UPTO is null OR VALID_UPTO = '' OR VALID_UPTO >= ?)";
                    entStmt = con.prepareStatement(sql);
                    entStmt.setString(1, apiName);
                    entStmt.setString(2, "G");
                    entStmt.setString(3, sysDate);
                    entStmt.setString(4, sysDate);
                    entResultSet = entStmt.executeQuery();
                    while (entResultSet.next()) {
                        apiKeyParams.add(entResultSet.getString("API_KEY"));
                        apiKeyParams.add("G");
                    }
                    BaseLogger.log("3", null, null, "InvoiceReader readInvoice() apiKeyParams 511:::" + apiKeyParams);
                    entResultSet.close();
                    entResultSet = null;
                    entStmt.close();
                    entStmt = null;
                }
                try {
                    if (mResultSet != null) {
                        mResultSet.close();
                        mResultSet = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (con != null) {
                        con.close();
                        con = null;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "APIUTILITY.getAPIKey()", "Exception in getAPIKey : " + e);
                try {
                    if (mResultSet != null) {
                        mResultSet.close();
                        mResultSet = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (con != null) {
                        con.close();
                        con = null;
                    }
                    if (con != null) {
                        con.close();
                    }
                    if (entStmt != null) {
                        entStmt.close();
                    }
                    if (entResultSet != null) {
                        entResultSet.close();
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (mResultSet != null) {
                    mResultSet.close();
                    mResultSet = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
                if (con != null) {
                    con.close();
                }
                if (entStmt != null) {
                    entStmt.close();
                }
                if (entResultSet != null) {
                    entResultSet.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return apiKeyParams;
    }
}

