/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.XML2DBEJB;
import ibase.webitm.utility.ITMException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TncUtils {
    public static TncUtils getInstance() {
        return new TncUtils();
    }

    public String saveTNCAgreement(String objName, int noOfForms, String completeXml, UserInfoBean userInfo) throws ITMException {
        String retString = "";
        try {
            String refser = "";
            String wrkflwInit = "";
            String wrkflwOpt = "0";
            String editFlag = "A";
            String pkValues = "";
            String prcInstId = "";
            String auditDataXmlBefore = "";
            String auditXMLString = "";
            String headerPKFieldValues = null;
            String loginCode = userInfo.getLoginCode();
            String tncCode = this.getColumnValue(completeXml, "1", "TNC_CODE");
            boolean isWrkflwInitiated = false;
            boolean isAutoConfirm = false;
            boolean genKey = false;
            boolean isAuditTrailOn = false;
            boolean isWrkflwToBeInitiated = false;
            InitialContext ctx = null;
            DBAccessEJB dbAccess = null;
            try {
                AppConnectParm appConnect = new AppConnectParm();
                ctx = new InitialContext(appConnect.getProperty());
                dbAccess = new DBAccessEJB();
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "ITMException :TncUtils :saveTNCAgreement :==>");
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :TncUtils :saveTNCAgreement :==>");
                throw new ITMException(e);
            }
            HashMap objDetailMap = dbAccess.getObjDetailMap(objName, userInfo);
            if (objDetailMap != null) {
                String keyFlag;
                refser = objDetailMap.get("REF_SER") != null ? (String)objDetailMap.get("REF_SER") : null;
                isAutoConfirm = objDetailMap.get("AUTO_CONFIRM") != null && "Y".equalsIgnoreCase((String)objDetailMap.get("AUTO_CONFIRM"));
                wrkflwInit = (String)objDetailMap.get("WRKFLW_INIT");
                String string = wrkflwOpt = objDetailMap.get("WORKFLOW_OPT") != null ? (String)objDetailMap.get("WORKFLOW_OPT") : wrkflwOpt;
                if (Integer.parseInt(wrkflwOpt) > 1) {
                    isWrkflwToBeInitiated = true;
                }
                if ((keyFlag = (String)objDetailMap.get("KEY_FLAG")) != null && keyFlag.equalsIgnoreCase("A")) {
                    genKey = true;
                }
            }
            BaseLogger.log("3", userInfo, null, "GENKEY..." + genKey + " loginCode[" + loginCode + "]");
            StringBuffer dataBuff = new StringBuffer("<Root>");
            dataBuff.append("<Header0>");
            dataBuff.append("<objName><![CDATA[" + objName + "]]></objName>");
            dataBuff.append("<pageContext><![CDATA[2]]></pageContext>");
            dataBuff.append("<editFlag><![CDATA[").append(editFlag).append("]]></editFlag>");
            dataBuff.append("<focusedColumn><![CDATA[]]></focusedColumn>");
            dataBuff.append("<action><![CDATA[").append(editFlag == "E" ? "EDIT" : "SAVE").append("]]></action>");
            dataBuff.append("<elementName><![CDATA[]]></elementName>");
            dataBuff.append("<taxKeyValue><![CDATA[]]></taxKeyValue>");
            dataBuff.append("<taxInFocus><![CDATA[false]]></taxInFocus>");
            dataBuff.append("<objContext><![CDATA[1]]></objContext>");
            dataBuff.append("<forcedSave><![CDATA[true]]></forcedSave>");
            dataBuff.append("<keyValue><![CDATA[1]]></keyValue>");
            dataBuff.append("<pkValues><![CDATA[").append(pkValues).append("]]></pkValues>");
            dataBuff.append("<saveLevel><![CDATA[1]]></saveLevel>");
            dataBuff.append("<wrkflwProcInstId><![CDATA[" + prcInstId + "]]></wrkflwProcInstId>");
            dataBuff.append("<description>Header0 members</description>");
            dataBuff.append("</Header0>");
            E12GenericUtility genericUtility = new E12GenericUtility();
            Node detailNode = genericUtility.parseString(completeXml).getElementsByTagName("Header0").item(0);
            if (detailNode != null) {
                String strDetNode = genericUtility.serializeDom(detailNode);
                dataBuff.append(strDetNode.substring(strDetNode.indexOf("<Header0>") + "<Header0>".length(), strDetNode.indexOf("</Header0>")).trim());
            }
            dataBuff.append("</Root>");
            XML2DBEJB xml2dbejb = new XML2DBEJB();
            BaseLogger.log("3", userInfo, null, "dataBuff.toString() before saveXML2DB[" + dataBuff.toString() + "]");
            String xtraParams = this.getXtraParams(userInfo);
            retString = xml2dbejb.saveXML2DB(refser, dataBuff.toString(), objName, editFlag, noOfForms, genKey, loginCode, pkValues, isAutoConfirm, xtraParams, null, wrkflwInit, isWrkflwToBeInitiated, wrkflwOpt, auditDataXmlBefore, auditXMLString, headerPKFieldValues, isWrkflwInitiated, isAuditTrailOn, userInfo);
            String dispMessage = this.checkNull(this.getDBColumnValue("MESSAGES", "MSG_DESCR", " WHERE MSG_NO='COCACCEPT'", userInfo.getTransDB()));
            if (dispMessage.length() > 0) {
                retString = dispMessage;
            }
            BaseLogger.log("3", userInfo, null, "After click on Aggree TNC[" + retString + "]");
            xml2dbejb = null;
            dbAccess = null;
        }
        catch (ITMException itme) {
            itme.printStackTrace();
            throw itme;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return retString;
    }

    public ArrayList<String> getAgreedTNCCodes(String user_code, String transDB) throws ITMException {
        BaseLogger.log("2", null, null, "In getAgreedTNCCodes() method  user_code[" + user_code + "] ");
        ArrayList<String> agreedTNCList = new ArrayList<String>();
        Connection connection = null;
        Statement pStmt = null;
        ResultSet rs = null;
        try {
            try {
                String sql = "SELECT TNC_CODE FROM TNC_ACCEPT WHERE USER_CODE = '" + user_code + "'";
                BaseLogger.log("3", null, null, " getAgreedTNCCodes :: sql [" + sql + "]");
                ConnDriver conn = new ConnDriver();
                connection = conn.getConnectDB(transDB);
                pStmt = connection.prepareStatement(sql);
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    agreedTNCList.add(this.checkNull(rs.getString("TNC_CODE")));
                }
                sql = null;
            }
            catch (ITMException e) {
                BaseLogger.log("0", null, null, "getAgreedTNCCodes : ITMException [" + e.getMessage() + "]");
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "getAgreedTNCCodes : Exception [" + e.getMessage() + "]");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :TncUtils :getAgreedTNCCodes :==>finally" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return agreedTNCList;
    }

    public ArrayList<String> getApplTNCCodes(String user_code, String join_date, String site_code, String emp_code, String transDB) throws ITMException {
        BaseLogger.log("2", null, null, "In getApplTNCCodes() method  user_code[" + user_code + "] join_date[" + join_date + "] site_code[" + site_code + "] emp_code[" + emp_code + "]");
        site_code = this.getDBColumnValue("EMPLOYEE", "EMP_SITE", " WHERE EMP_CODE = '" + emp_code + "'", transDB);
        ArrayList<String> applTNCList = new ArrayList<String>();
        Connection connection = null;
        Statement pStmt = null;
        ResultSet rs = null;
        int tncApplAfter = 0;
        String sql = null;
        try {
            try {
                sql = "SELECT PAR_VALUE FROM SITE_ENV  WHERE MODULE_CODE='TNC' AND PAR_NAME='TNC_APPL_AFTER'  AND SITE_CODE='" + site_code + "' ";
                BaseLogger.log("3", null, null, " getApplTNCCodes :: sql of SITE_ENV table  [" + sql + "]");
                ConnDriver conn = new ConnDriver();
                connection = conn.getConnectDB(transDB);
                pStmt = connection.prepareStatement(sql);
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    tncApplAfter = Integer.parseInt(this.checkNull(rs.getString("PAR_VALUE")));
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                BaseLogger.log("3", null, null, "join_date in dd-MMM-yyyy [" + join_date + "]");
                if (join_date != null && join_date.trim().length() > 0) {
                    join_date = new E12GenericUtility().getValidDateString(join_date, "dd-MMM-yyyy", CommonConstants.DB_DATE_FORMAT);
                    BaseLogger.log("3", null, null, "join_date in " + CommonConstants.DB_DATE_FORMAT + " [" + join_date + "]");
                    SimpleDateFormat sdf = new SimpleDateFormat(CommonConstants.DB_DATE_FORMAT);
                    Date currDate = new Date(System.currentTimeMillis());
                    Date joinDate = sdf.parse(join_date);
                    Calendar cald = Calendar.getInstance();
                    cald.setTime(joinDate);
                    cald.add(5, tncApplAfter);
                    Date tncApplFromDate = cald.getTime();
                    String currDateStr = new E12GenericUtility().getValidDateString(sdf.format(currDate), CommonConstants.DB_DATE_FORMAT, "dd-MMM-yyyy");
                    String joinDateStr = sdf.format(joinDate);
                    String tncApplFromDateStr = sdf.format(tncApplFromDate);
                    BaseLogger.log("3", null, null, "currDate : [" + currDateStr + "] \n joinDate: [" + joinDateStr + "]\n tncApplFromDate : [" + tncApplFromDateStr + "]");
                    BaseLogger.log("3", null, null, String.valueOf(currDateStr) + " After " + tncApplFromDate + ":" + this.compare(currDate, tncApplFromDate));
                    if (this.compare(currDate, tncApplFromDate)) {
                        sql = "SELECT TNC_CODE FROM TNC_DOC_MST WHERE ( INSTR(SITE_CODE__APPL, '" + site_code + "' ) > 0  OR (FIN_ENTITY = 'ALL' and SITE_CODE__APPL = 'ALL') " + "OR (INSTR(FIN_ENTITY , (select fin_entity from site where site_code = '" + site_code + "')) > 0 " + "and SITE_CODE__APPL = 'ALL') ) " + "AND '" + currDateStr + "'  BETWEEN DATE_FROM AND DATE_TO";
                        BaseLogger.log("3", null, null, " getApplTNCCodes :: sql of TNC_DOC_MST table  [" + sql + "]");
                        pStmt = connection.prepareStatement(sql);
                        rs = pStmt.executeQuery();
                        while (rs.next()) {
                            applTNCList.add(this.checkNull(rs.getString("TNC_CODE")));
                        }
                    }
                }
                sql = null;
            }
            catch (ITMException e) {
                BaseLogger.log("0", null, null, "getApplTNCCodes : ITMException [" + e.getMessage() + "]");
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "getApplTNCCodes : Exception [" + e.getMessage() + "]");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :CocUtls :getApplTNCCodes :==>finally" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return applTNCList;
    }

    public String getApplTNCDetail(String userCode, ArrayList<String> agreedTNCList, ArrayList<String> applTNCList, String clientIP, String empCode, String transDB) throws ITMException {
        BaseLogger.log("2", null, null, "In getApplTNCDetail() method  agreedTNCList ==" + agreedTNCList + "\n applTNCList ==" + applTNCList);
        Connection connection = null;
        Statement pStmt = null;
        ResultSet rs = null;
        StringBuilder defaultData = new StringBuilder();
        defaultData.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?> ");
        defaultData.append("<ROOT>");
        try {
            try {
                ConnDriver conn = new ConnDriver();
                connection = conn.getConnectDB(transDB);
                String finentDescr = this.getDBColumnValue(" FINENT, SITE, EMPLOYEE ", " FINENT.DESCR ", " WHERE EMPLOYEE.EMP_CODE = '" + this.checkNull(empCode) + "' AND EMPLOYEE.EMP_SITE = SITE.SITE_CODE AND SITE.FIN_ENTITY = FINENT.FIN_ENTITY ", "DESCR", transDB);
                BaseLogger.log("3", null, null, "------>>>> finentDescr[" + finentDescr + "]");
                Iterator<String> tncCodeList = applTNCList.iterator();
                String sql = null;
                while (tncCodeList.hasNext()) {
                    String tncCode = tncCodeList.next();
                    String dateAccept = this.getDBColumnValue("TNC_ACCEPT", "DATE_ACCEPT", " WHERE USER_CODE='" + this.checkNull(userCode) + "' AND TNC_CODE='" + this.checkNull(tncCode) + "' ", transDB);
                    dateAccept = this.checkNull(this.getDateFormat(dateAccept));
                    String dateIgnoreCount = this.getDBColumnValue("TNC_IGNORE", "COUNT(TNC_CODE)", " WHERE USER_CODE='" + this.checkNull(userCode) + "' AND TNC_CODE='" + this.checkNull(tncCode) + "' ", transDB);
                    sql = " SELECT DATE_FROM, DATE_TO, TNC_TYPE, TNC_DOC_NAME, TNC_DOC_TYPE, DOC_VER, TNC_DOC_DESCR,ALLOW_IGNORE FROM TNC_DOC_MST  WHERE TNC_CODE = '" + tncCode + "'";
                    BaseLogger.log("3", null, null, " getApplTNCDetail :: sql [" + sql + "]");
                    pStmt = connection.prepareStatement(sql);
                    rs = pStmt.executeQuery();
                    defaultData.append("<Detail1>");
                    while (rs.next()) {
                        String tncDocName = String.valueOf(this.checkNull(rs.getString("TNC_DOC_NAME"))) + "." + this.checkNull(rs.getString("TNC_DOC_TYPE"));
                        String dateFrom = this.checkNull(rs.getString("DATE_FROM"));
                        String dateTo = this.checkNull(rs.getString("DATE_TO"));
                        String tncType = this.checkNull(rs.getString("TNC_TYPE"));
                        String docVer = this.checkNull(rs.getString("DOC_VER"));
                        String tncDocDescr = this.checkNull(rs.getString("TNC_DOC_DESCR"));
                        String tncAllowIgnore = this.checkNull(rs.getString("ALLOW_IGNORE"));
                        defaultData.append("<TNC_CODE>").append("<![CDATA[" + tncCode + "]]>").append("</TNC_CODE>\n");
                        defaultData.append("<TNC_TYPE>").append("<![CDATA[" + tncType + "]]>").append("</TNC_TYPE>\n");
                        defaultData.append("<TNC_DOC_NAME> ").append("<![CDATA[" + tncDocName + "]]>").append("</TNC_DOC_NAME>\n");
                        defaultData.append("<DOC_VER>").append("<![CDATA[" + docVer + "]]>").append("</DOC_VER>\n");
                        defaultData.append("<DATE_FROM>").append("<![CDATA[" + dateFrom + "]]>").append("</DATE_FROM>\n");
                        defaultData.append("<DATE_TO>").append("<![CDATA[" + dateTo + "]]>").append("</DATE_TO>\n");
                        defaultData.append("<DATE_ACCEPT>").append("<![CDATA[" + this.checkNull(dateAccept) + "]]>").append("</DATE_ACCEPT>\n");
                        defaultData.append("<IS_AGREE>").append("<![CDATA[" + agreedTNCList.contains(tncCode) + "]]>").append("</IS_AGREE>\n");
                        defaultData.append("<USER_CODE>").append("<![CDATA[" + this.checkNull(userCode) + "]]>").append("</USER_CODE>\n");
                        defaultData.append("<CHG_USER>").append("<![CDATA[" + this.checkNull(userCode) + "]]>").append("</CHG_USER>\n");
                        defaultData.append("<CHG_DATE>").append("<![CDATA[" + new Date(System.currentTimeMillis()) + "]]>").append("</CHG_DATE>\n");
                        defaultData.append("<CHG_TERM>").append("<![CDATA[" + this.checkNull(clientIP) + "]]>").append("</CHG_TERM>\n");
                        defaultData.append("<FINENT_DESCR>").append("<![CDATA[" + this.checkNull(finentDescr) + "]]>").append("</FINENT_DESCR>\n");
                        defaultData.append("<TNC_DOC_DESCR>").append("<![CDATA[" + tncDocDescr + "]]>").append("</TNC_DOC_DESCR>\n");
                        if ((tncAllowIgnore.equalsIgnoreCase("0") || tncAllowIgnore.equalsIgnoreCase(dateIgnoreCount)) && dateAccept.length() == 0) {
                            defaultData.append("<ALLOW_IGNORE>").append("<![CDATA[false]]>").append("</ALLOW_IGNORE>\n");
                        } else {
                            defaultData.append("<ALLOW_IGNORE>").append("<![CDATA[true]]>").append("</ALLOW_IGNORE>\n");
                        }
                        defaultData.append("<DATE_IGNORE>").append("<![CDATA[]]>").append("</DATE_IGNORE>\n");
                    }
                    defaultData.append("</Detail1>");
                    BaseLogger.log("3", null, null, "defaultData====[" + defaultData + "]");
                    tncCode = null;
                    dateAccept = null;
                }
                sql = null;
                defaultData.append("</ROOT>");
            }
            catch (ITMException e) {
                BaseLogger.log("0", null, null, "getApplTNCDetail : ITMException [" + e.getMessage() + "]");
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "getApplTNCDetail : Exception [" + e.getMessage() + "]");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :CocUtils :getApplTNCDetail :==>finally" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return defaultData.toString();
    }

    public String getTNCAgreementXML(String objName, String tncSaveXml, String dateAccept) throws ITMException {
        String userCode = this.getColumnValue(tncSaveXml, "1", "USER_CODE");
        String tncCode = this.getColumnValue(tncSaveXml, "1", "TNC_CODE");
        String chgUser = this.getColumnValue(tncSaveXml, "1", "CHG_USER");
        String chgDate = this.getColumnValue(tncSaveXml, "1", "CHG_DATE");
        String chgTerm = this.getColumnValue(tncSaveXml, "1", "CHG_TERM");
        BaseLogger.log("2", null, null, "getTNCAgreementXML userCode[" + userCode + "] tncCode[" + tncCode + "]");
        StringBuilder completeDataBuff = new StringBuilder();
        completeDataBuff.append("<Detail1 objContext=\"1\" objName=\"" + objName + "\" domID=\"1\" dbID=\"\" selected=\"Y\" >");
        completeDataBuff.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
        completeDataBuff.append("<user_code>").append("<![CDATA[" + userCode + "]]>").append("</user_code>");
        completeDataBuff.append("<tnc_code>").append("<![CDATA[" + tncCode + "]]>").append("</tnc_code>");
        completeDataBuff.append("<date_accept>").append("<![CDATA[" + dateAccept + "]]>").append("</date_accept>");
        completeDataBuff.append("<tran_id>").append("<![CDATA[]]>").append("</tran_id>");
        completeDataBuff.append("<chg_user>").append("<![CDATA[" + chgUser + "]]>").append("</chg_user>");
        completeDataBuff.append("<chg_date>").append("<![CDATA[" + chgDate + "]]>").append("</chg_date>");
        completeDataBuff.append("<chg_term>").append("<![CDATA[" + chgTerm + "]]>").append("</chg_term>");
        completeDataBuff.append("</Detail1>");
        StringBuffer xmlStringBufHeader = new StringBuffer("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>");
        xmlStringBufHeader.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 description</description><Header0><Errors></Errors><description>Header0 members</description>");
        StringBuffer xmlStringBufFooter = new StringBuffer("</Header0></group0></DocumentRoot>");
        String completeDataStr = String.valueOf(xmlStringBufHeader.toString()) + completeDataBuff.toString() + xmlStringBufFooter.toString();
        BaseLogger.log("2", null, null, "\n\n\n getTNCAgreementXML : completeDataStr[" + completeDataStr + "]");
        return completeDataStr;
    }

    public String getTNCIgnoreXML(String objName, String tncSaveXml, String dateIgnore) throws ITMException {
        String userCode = this.getColumnValue(tncSaveXml, "1", "USER_CODE");
        String tncCode = this.getColumnValue(tncSaveXml, "1", "TNC_CODE");
        String chgUser = this.getColumnValue(tncSaveXml, "1", "CHG_USER");
        String chgDate = this.getColumnValue(tncSaveXml, "1", "CHG_DATE");
        String chgTerm = this.getColumnValue(tncSaveXml, "1", "CHG_TERM");
        StringBuilder completeDataBuff = new StringBuilder();
        completeDataBuff.append("<Detail1 objContext=\"1\" objName=\"" + objName + "\" domID=\"1\" dbID=\"\" selected=\"Y\" >");
        completeDataBuff.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
        completeDataBuff.append("<user_code>").append("<![CDATA[" + userCode + "]]>").append("</user_code>");
        completeDataBuff.append("<tnc_code>").append("<![CDATA[" + tncCode + "]]>").append("</tnc_code>");
        completeDataBuff.append("<date_ignore>").append("<![CDATA[" + dateIgnore + "]]>").append("</date_ignore>");
        completeDataBuff.append("<tran_id>").append("<![CDATA[]]>").append("</tran_id>");
        completeDataBuff.append("<chg_user>").append("<![CDATA[" + chgUser + "]]>").append("</chg_user>");
        completeDataBuff.append("<chg_date>").append("<![CDATA[" + chgDate + "]]>").append("</chg_date>");
        completeDataBuff.append("<chg_term>").append("<![CDATA[" + chgTerm + "]]>").append("</chg_term>");
        completeDataBuff.append("</Detail1>");
        StringBuffer xmlStringBufHeader = new StringBuffer("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>");
        xmlStringBufHeader.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 description</description><Header0><Errors></Errors><description>Header0 members</description>");
        StringBuffer xmlStringBufFooter = new StringBuffer("</Header0></group0></DocumentRoot>");
        String completeDataStr = String.valueOf(xmlStringBufHeader.toString()) + completeDataBuff.toString() + xmlStringBufFooter.toString();
        BaseLogger.log("2", null, null, "\n\n\n getTNCIgnoreAgreementXML : completeDataStr[" + completeDataStr + "]");
        return completeDataStr;
    }

    public boolean compare(Date d1, Date d2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(d1);
        cal2.setTime(d2);
        return cal1.after(cal2);
    }

    public String getDBColumnValue(String tableName, String columnName, String condition, String transDB) throws ITMException {
        return this.getDBColumnValue(tableName, columnName, condition, "", transDB);
    }

    public String getDBColumnValue(String tableName, String columnName, String condition, String selectColumnName, String transDB) throws ITMException {
        String sql = "";
        String returnValue = "";
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                sql = " SELECT " + columnName + " FROM " + tableName + " " + condition;
                if (this.checkNull(selectColumnName).length() > 0) {
                    columnName = selectColumnName;
                }
                if ((rs = (pstmt = conn.prepareStatement(sql)).executeQuery()).next()) {
                    returnValue = rs.getString(columnName);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exp) {
                BaseLogger.log("0", null, null, "Excepton in getDBColumnValue -- >" + exp.getMessage());
                exp.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException se) {
                    se.printStackTrace();
                    throw new ITMException(se);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
                throw new ITMException(se);
            }
        }
        return returnValue;
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    private String getColumnValue(String formDetailXml, String formNo, String colName) {
        String colValue = "";
        try {
            Document xmlDom = new E12GenericUtility().parseString(formDetailXml);
            NodeList retFormDetailNodeList = xmlDom.getElementsByTagName("Detail" + formNo);
            Node retFormDetailNode = retFormDetailNodeList.item(0);
            if (retFormDetailNode != null) {
                NodeList childNodeList = retFormDetailNode.getChildNodes();
                int childNodeListLen = childNodeList.getLength();
                int childCntr = 0;
                while (childCntr < childNodeListLen) {
                    String childNodeName = childNodeList.item(childCntr).getNodeName();
                    if (childNodeName.equalsIgnoreCase(colName) && childNodeList.item(childCntr).getFirstChild() != null) {
                        colValue = childNodeList.item(childCntr).getFirstChild().getNodeValue();
                        BaseLogger.log("3", null, null, "In  getColumnValue ::" + colName + "[" + colValue + "]" + formNo);
                    }
                    ++childCntr;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in getColumnValue" + e.getMessage());
            e.printStackTrace();
        }
        return colValue;
    }

    public String getXtraParams(UserInfoBean userInfoBean) throws Exception {
        String XTRA_PARAMS_SEPARATOR = "~~";
        StringBuffer xtraParamsBuff = new StringBuffer();
        xtraParamsBuff.append("loginCode=" + userInfoBean.getLoginCode());
        xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginEmpCode=" + userInfoBean.getEmpCode());
        xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginSiteCode=" + userInfoBean.getSiteCode());
        xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("entityCode=" + userInfoBean.getEntityCode());
        xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("profileId=" + userInfoBean.getProfileId());
        xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("userType=" + userInfoBean.getUserType());
        xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("runMode=I");
        xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_lang=" + userInfoBean.getUserLanguage());
        xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_country=" + userInfoBean.getUserCountry());
        xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("charEnc=" + userInfoBean.getCharEnc());
        xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("termId=" + userInfoBean.getRemoteHost());
        String chgTerm = userInfoBean.getRemoteHostName();
        if (chgTerm != null && chgTerm.length() > 15) {
            chgTerm = chgTerm.substring(0, 15);
        } else if (chgTerm == null || chgTerm.length() == 0) {
            chgTerm = userInfoBean.getRemoteHost();
        }
        xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("chgTerm=" + chgTerm);
        BaseLogger.log("2", null, null, "xtraParamsBuff [" + xtraParamsBuff + "]");
        return xtraParamsBuff.toString();
    }

    private String getDateFormat(String date) throws ITMException, Exception {
        String formatedDate = "";
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            SimpleDateFormat format1 = new SimpleDateFormat(genericUtility.getDBDateTimeFormat());
            SimpleDateFormat format2 = new SimpleDateFormat(genericUtility.getApplDateFormat());
            Date dateNew = format1.parse(date);
            formatedDate = format2.format(dateNew);
            System.out.println("formatedDate==== " + formatedDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formatedDate;
    }
}

