/*
 * Decompiled with CFR 0.152.
 */
package ibase.scheduler.ejb;

import ibase.scheduler.ejb.BaseRegisteredEJB;
import ibase.scheduler.ejb.ExecuteBGProcessLocal;
import ibase.scheduler.ejb.ExecuteBGProcessRemote;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.EventManagerEJB;
import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class ExecuteBGProcessEJB
extends BaseRegisteredEJB
implements ExecuteBGProcessLocal,
ExecuteBGProcessRemote {
    final String XTRA_PARAMS_SEPARATOR = "~~";
    String sysdateStr = "";
    String DB_NAME = CommonConstants.DB_NAME;
    int maxQueues = 1;

    @Override
    public String schedule(HashMap map) throws RemoteException, BaseException {
        return "";
    }

    @Override
    public String schedule(String name) throws BaseException {
        try {
            BaseLogger.log("3", null, null, "CALLING EXECUTE BACKGROUND PROCESS");
            String jobId = "";
            String objName = "";
            String objType = "";
            String param1 = "";
            String param2 = "";
            String userId = "";
            String preUser = "";
            String loginSite = "";
            ArrayList userInfo = null;
            this.sysdateStr = "DB2".equalsIgnoreCase(this.DB_NAME) ? " current timestamp " : ("MSSQL".equalsIgnoreCase(this.DB_NAME) ? " getdate() " : " sysdate ");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(name.getBytes()));
            NodeList actualparameterList = doc.getElementsByTagName("ACTUALPARAMETER");
            if (actualparameterList != null) {
                int i = 0;
                while (i < actualparameterList.getLength()) {
                    Node actualparameterNode = actualparameterList.item(i);
                    if (actualparameterNode.getNodeType() == 1 && actualparameterNode.getNodeName().equals("ACTUALPARAMETER") && actualparameterNode.getFirstChild() != null && actualparameterNode.getFirstChild().getNodeValue() != null && !actualparameterNode.getFirstChild().getNodeValue().equalsIgnoreCase("null") && !actualparameterNode.getFirstChild().getNodeValue().equalsIgnoreCase("")) {
                        this.maxQueues = Integer.parseInt(actualparameterNode.getFirstChild().getNodeValue());
                        BaseLogger.log("3", null, null, " Selected QUEUE [" + actualparameterNode.getFirstChild().getNodeValue() + "]");
                    }
                    ++i;
                }
            }
            ArrayList processIds = null;
            while ((processIds = this.getPendingProcesses()) != null) {
                int i = 0;
                while (i < processIds.size()) {
                    ArrayList process = (ArrayList)processIds.get(i);
                    jobId = (String)process.get(0);
                    objName = (String)process.get(1);
                    objType = (String)process.get(2);
                    param1 = (String)process.get(3);
                    param2 = (String)process.get(4);
                    userId = (String)process.get(5);
                    loginSite = (String)process.get(6);
                    BaseLogger.log("3", null, null, "ExecuteBGProcess  jobId [" + jobId + "]  objName [" + objName + "] objType [" + objType + "] param1 [" + param1 + "]  param2 [" + param2 + "]  userId  [" + userId + "] loginSite [" + loginSite + "]");
                    if (preUser != null && userInfo != null && preUser.length() != 0 && userId != null) {
                        if (!preUser.trim().equalsIgnoreCase(userId.trim())) {
                            preUser = userId.trim();
                            userInfo = this.getUserInfo(jobId, objName, userId);
                        }
                    } else {
                        userInfo = this.getUserInfo(jobId, objName, userId);
                    }
                    if (objType.equalsIgnoreCase("P")) {
                        this.executeProcessActivity(jobId, objName, objType, param1, param2, userId, userInfo, loginSite);
                    } else if (objType.equalsIgnoreCase("B")) {
                        this.executeBIReportActivity(jobId, objName, objType, param1, param2, userId, userInfo);
                    } else if (objType.equalsIgnoreCase("R")) {
                        this.executeReportActivity(jobId, objName, objType, param1, param2, userId, userInfo);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "ExecuteBGProcess   : schedule   [" + e.getMessage() + "] ");
            e.printStackTrace();
        }
        return "";
    }

    private void executeReportActivity(String jobId, String objName, String objType, String param1, String param2, String userId, ArrayList userInfo) {
        Connection connObj = null;
        Statement pstmt = null;
        String sql = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connObj = connDriver.getConnectDB("Driver");
                BaseLogger.log("3", null, null, "executeReportActivity.............");
                sql = "UPDATE BACKGROUND_JOB SET JOB_STAT='I' WHERE JOB_ID='" + jobId + "' AND OBJ_NAME='" + objName + "' AND USER_ID='" + userId + "'";
                pstmt = connObj.prepareStatement(sql);
                pstmt.executeUpdate();
                connObj.commit();
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (connObj != null) {
                        connObj.close();
                        connObj = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (connObj != null) {
                    connObj.close();
                    connObj = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void executeBIReportActivity(String jobId, String objName, String objType, String param1, String param2, String userId, ArrayList userInfo) {
        BaseLogger.log("9", null, null, "executeBIReportActivity.............");
    }

    private String executeProcessActivity(String jobId, String objName, String objType, String param1, String param2, String userId, ArrayList userInfo, String loginSite) throws Exception {
        String retStr;
        block36: {
            BaseLogger.log("9", null, null, " E X E C U T E    P R O C E S S A C T I V I T Y");
            retStr = "";
            Connection connObj = null;
            boolean isProcess = true;
            Statement pstmt = null;
            Statement stmt = null;
            String sql = null;
            String stat = null;
            try {
                try {
                    ConnDriver connDriver = new ConnDriver();
                    connObj = connDriver.getConnectDB("Driver");
                    sql = "UPDATE BACKGROUND_JOB SET JOB_STAT='I' WHERE JOB_ID='" + jobId + "' AND OBJ_NAME='" + objName + "' AND USER_ID='" + userId + "'";
                    pstmt = connObj.prepareStatement(sql);
                    pstmt.executeUpdate();
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    connObj.setAutoCommit(false);
                    stmt = connObj.createStatement();
                    if (this.DB_NAME.equalsIgnoreCase("ORACLE")) {
                        sql = "SELECT JOB_STAT FROM BACKGROUND_JOB WHERE JOB_ID = '" + jobId + "' FOR UPDATE NOWAIT ";
                    } else if (this.DB_NAME.equalsIgnoreCase("DB2")) {
                        sql = "SELECT JOB_STAT FROM BACKGROUND_JOB WHERE JOB_ID = '" + jobId + "' FOR UPDATE ";
                    } else if (this.DB_NAME.equalsIgnoreCase("MSSQL")) {
                        sql = "SELECT JOB_STAT FROM BACKGROUND_JOB ( UPDLOCK ) WHERE JOB_ID = '" + jobId + "'";
                    }
                    BaseLogger.log("9", null, null, "BackgroundJobCancelEJB:connUpdation  " + sql);
                    ResultSet rs = stmt.executeQuery(sql);
                    if (rs.next()) {
                        stat = rs.getString("JOB_STAT");
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    BaseLogger.log("9", null, null, "BackgroundJobCancelEJB :connUpdation: " + stat);
                    if (stat != null && stat.trim().length() > 0) {
                        if ("X".equalsIgnoreCase(stat)) {
                            isProcess = false;
                        }
                    } else {
                        isProcess = false;
                    }
                    if (isProcess) {
                        try {
                            String xtraXml = null;
                            xtraXml = this.getXtraParams(userInfo, jobId);
                            E12GenericUtility genericUtility = new E12GenericUtility();
                            Document detailDom = genericUtility.getDocument(param1);
                            Document tranDom = genericUtility.getDocument(param2);
                            AppConnectParm appConnect = new AppConnectParm();
                            InitialContext ctx = new InitialContext(appConnect.getProperty());
                            String objectName = objName != null ? objName.trim() : objName;
                            EventManagerEJB eventManager = new EventManagerEJB();
                            retStr = eventManager.executeSystemEvent(objectName, "process", null, tranDom, detailDom, xtraXml, null);
                            if (retStr != null) {
                                boolean errorStatus = this.getReturnStaus(retStr);
                                BaseLogger.log("9", null, null, "errorStatus   [ " + errorStatus + " ] ");
                                if (!errorStatus) {
                                    sql = "UPDATE BACKGROUND_JOB SET EXEC_RESULT='" + this.getTraceData(retStr) + "',JOB_STAT='C',EXEC_DATE= " + this.sysdateStr + " WHERE JOB_ID='" + jobId + "' AND OBJ_NAME='" + objName + "' AND USER_ID='" + userId + "'";
                                    pstmt = connObj.prepareStatement(sql);
                                    pstmt.executeUpdate();
                                    connObj.commit();
                                    if (pstmt != null) {
                                        pstmt.close();
                                        pstmt = null;
                                    }
                                } else {
                                    connObj.commit();
                                    this.updateErrorMessage(jobId, objName, userId, null, retStr);
                                }
                            }
                            eventManager = null;
                        }
                        catch (Exception e) {
                            connObj.rollback();
                            BaseLogger.log("3", null, null, "Exception :executeProcessActivity :executeSystemEvent :==>" + e.getMessage());
                            this.updateErrorMessage(jobId, objName, userId, e, null);
                        }
                        break block36;
                    }
                    connObj.rollback();
                }
                catch (Exception e) {
                    connObj.rollback();
                    BaseLogger.log("0", null, null, "ExecuteBGProcess  : executeProcessActivity   " + e.getMessage());
                    this.updateErrorMessage(jobId, objName, userId, e, null);
                    try {
                        if (connObj != null) {
                            connObj.close();
                            connObj = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                    }
                    catch (Exception finallye) {
                        BaseLogger.log("0", null, null, "Exception in finally ExcecuteBGProcess  :getPendingProcesses  [Error while retriving the pending process fromthe backgrounf table]");
                        finallye.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (connObj != null) {
                        connObj.close();
                        connObj = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (Exception finallye) {
                    BaseLogger.log("0", null, null, "Exception in finally ExcecuteBGProcess  :getPendingProcesses  [Error while retriving the pending process fromthe backgrounf table]");
                    finallye.printStackTrace();
                }
            }
        }
        return retStr;
    }

    private boolean getReturnStaus(String retStr) {
        boolean isError;
        block5: {
            isError = false;
            try {
                Document dom;
                NodeList nodeList;
                BaseLogger.log("3", null, null, "  GET RETURN STAUS  [" + retStr + "]  ");
                if (retStr == null || retStr.trim().length() == 0 || (nodeList = (dom = new E12GenericUtility().getDocument(retStr)).getElementsByTagName("Errors")) == null || nodeList.item(0) == null) break block5;
                NodeList chileNodeList = nodeList.item(0).getChildNodes();
                int nodeCnt = 0;
                while (nodeCnt < chileNodeList.getLength()) {
                    Node childNode = chileNodeList.item(nodeCnt);
                    if (childNode != null && childNode.getNodeName() != null && childNode.getNodeName().equalsIgnoreCase("error")) {
                        String type;
                        BaseLogger.log("3", null, null, "childNode   [" + childNode.getNodeName() + "]");
                        Node typeNode = childNode.getAttributes().getNamedItem("type");
                        if (typeNode != null && "E".equalsIgnoreCase(type = typeNode.getNodeValue())) {
                            BaseLogger.log("3", null, null, "getReturnStaus   :  type  [" + type + "]");
                            isError = true;
                            break;
                        }
                    }
                    ++nodeCnt;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "ExecuteBGProcess  : executeProcessActivity   " + e.getMessage());
                e.printStackTrace();
            }
        }
        return isError;
    }

    private ArrayList getPendingProcesses() throws Exception {
        boolean isPresent;
        ArrayList pendingjobs;
        block23: {
            Connection connObj = null;
            Statement stmt = null;
            pendingjobs = null;
            isPresent = false;
            Blob param1Bolb = null;
            Blob param2Bolb = null;
            String sql = null;
            try {
                try {
                    ConnDriver connDriver = new ConnDriver();
                    connObj = connDriver.getConnectDB("Driver");
                    sql = this.DB_NAME.equalsIgnoreCase("ORACLE") ? "SELECT JOB_ID,OBJ_NAME,OBJ_TYPE,OBJ_PARAM1,OBJ_PARAM2,JOB_STAT,USER_ID,LOGIN_SITE FROM BACKGROUND_JOB WHERE (JOB_STAT='P' AND QUEUE_ID = " + this.maxQueues + ") ORDER BY TO_NUMBER(JOB_ID)" : (this.DB_NAME.equalsIgnoreCase("DB2") ? "SELECT JOB_ID,OBJ_NAME,OBJ_TYPE,OBJ_PARAM1,OBJ_PARAM2,JOB_STAT,USER_ID,LOGIN_SITE FROM BACKGROUND_JOB WHERE (JOB_STAT='P' AND QUEUE_ID = " + this.maxQueues + ") ORDER BY DECIMAL(JOB_ID)" : (this.DB_NAME.equalsIgnoreCase("MSSQL") ? "SELECT JOB_ID,OBJ_NAME,OBJ_TYPE,OBJ_PARAM1,OBJ_PARAM2,JOB_STAT,USER_ID,LOGIN_SITE FROM BACKGROUND_JOB WHERE (JOB_STAT='P' AND QUEUE_ID = " + this.maxQueues + ") ORDER BY DECIMAL(JOB_ID)" : "SELECT JOB_ID,OBJ_NAME,OBJ_TYPE,OBJ_PARAM1,OBJ_PARAM2,JOB_STAT,USER_ID,LOGIN_SITE FROM BACKGROUND_JOB WHERE (JOB_STAT='P' AND QUEUE_ID = " + this.maxQueues + ") ORDER BY JOB_ID"));
                    stmt = connObj.prepareStatement(sql);
                    ResultSet rs = stmt.executeQuery(sql);
                    pendingjobs = new ArrayList();
                    while (rs.next()) {
                        byte[] b;
                        long start;
                        isPresent = true;
                        String id = rs.getString("JOB_ID");
                        ArrayList<String> jobArray = new ArrayList<String>();
                        jobArray.add(id);
                        jobArray.add(rs.getString("OBJ_NAME"));
                        jobArray.add(rs.getString("OBJ_TYPE"));
                        param1Bolb = rs.getBlob("OBJ_PARAM1");
                        param2Bolb = rs.getBlob("OBJ_PARAM2");
                        if (param1Bolb != null) {
                            start = 1L;
                            b = param1Bolb.getBytes(start, (int)param1Bolb.length());
                            jobArray.add(new String(b));
                            BaseLogger.log("3", null, null, "ExecuteBGProcessEJB    ....getPendingProcesses  reading BLOB" + new String(b));
                        }
                        if (param2Bolb != null) {
                            start = 1L;
                            b = param1Bolb.getBytes(start, (int)param1Bolb.length());
                            jobArray.add(new String(b));
                            BaseLogger.log("3", null, null, "ExecuteBGProcessEJB    ....getPendingProcesses  reading BLOB" + new String(b));
                        }
                        jobArray.add(rs.getString("USER_ID"));
                        jobArray.add(rs.getString("LOGIN_SITE"));
                        pendingjobs.add(jobArray);
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception in try ExcecuteBGProcess  :getPendingProcesses  [Error while retriving the pending process fromthe backgrounf table]");
                    e.printStackTrace();
                    try {
                        if (connObj != null) {
                            connObj.close();
                            connObj = null;
                        }
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        break block23;
                    }
                    catch (Exception finallye) {
                        BaseLogger.log("0", null, null, "Exception in finally ExcecuteBGProcess  :getPendingProcesses  [Error while retriving the pending process fromthe backgrounf table]");
                        finallye.printStackTrace();
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (connObj != null) {
                        connObj.close();
                        connObj = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (Exception finallye) {
                    BaseLogger.log("0", null, null, "Exception in finally ExcecuteBGProcess  :getPendingProcesses  [Error while retriving the pending process fromthe backgrounf table]");
                    finallye.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (connObj != null) {
                    connObj.close();
                    connObj = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception finallye) {
                BaseLogger.log("0", null, null, "Exception in finally ExcecuteBGProcess  :getPendingProcesses  [Error while retriving the pending process fromthe backgrounf table]");
                finallye.printStackTrace();
            }
        }
        if (!isPresent) {
            BaseLogger.log("0", null, null, "..............ALL PROCESS COMPLETED , NO PROCESS REMAIN FOR THE EXECUTION ..........");
            return null;
        }
        return pendingjobs;
    }

    private ArrayList getUserInfo(String jobId, String objName, String userId) throws Exception {
        ArrayList<String> userInfo;
        block20: {
            BaseLogger.log("2", null, null, "ExecuteBGProcess  ..........getUserInfo..............Start");
            Connection connObj = null;
            Statement stmt = null;
            String usrLev = null;
            String siteCode = null;
            userInfo = null;
            try {
                try {
                    userInfo = new ArrayList<String>();
                    ConnDriver connDriver = new ConnDriver();
                    connObj = connDriver.getConnectDB("Driver");
                    String sql = "SELECT USR.NAME,USR.USR_LEV,USR.USER_TYPE,USR.ENTITY_CODE,USR.PROFILE_ID,USR.SITE_CODE__DEF,USR.EMP_CODE,USR.CHG_TERM FROM USERS USR WHERE CODE = '" + userId + "'";
                    stmt = connObj.prepareStatement(sql);
                    ResultSet rs = stmt.executeQuery();
                    while (rs.next()) {
                        usrLev = rs.getString("USR_LEV");
                        siteCode = rs.getString("SITE_CODE__DEF");
                        userInfo.add(userId);
                        userInfo.add(rs.getString("EMP_CODE"));
                        userInfo.add(this.getSiteCode(userId, siteCode != null && siteCode.trim().length() > 0 ? siteCode.trim() : siteCode, usrLev));
                        userInfo.add(rs.getString("ENTITY_CODE"));
                        userInfo.add(rs.getString("PROFILE_ID"));
                        userInfo.add(rs.getString("USER_TYPE"));
                        userInfo.add(rs.getString("CHG_TERM"));
                        userInfo.add(CommonConstants.ENCODING);
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "ExecuteBGProcess  :  getUserInfo  [" + e.getMessage() + "]");
                    this.updateErrorMessage(jobId, objName, userId, e, null);
                    e.printStackTrace();
                    try {
                        if (connObj != null) {
                            connObj.close();
                            connObj = null;
                        }
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        break block20;
                    }
                    catch (Exception finallye) {
                        BaseLogger.log("0", null, null, "Exception in finally ExcecuteBGProcess  :getUserInfo  [Error while updating error string in background table]");
                        this.updateErrorMessage(jobId, objName, userId, finallye, null);
                        finallye.printStackTrace();
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (connObj != null) {
                        connObj.close();
                        connObj = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (Exception finallye) {
                    BaseLogger.log("0", null, null, "Exception in finally ExcecuteBGProcess  :getUserInfo  [Error while updating error string in background table]");
                    this.updateErrorMessage(jobId, objName, userId, finallye, null);
                    finallye.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (connObj != null) {
                    connObj.close();
                    connObj = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception finallye) {
                BaseLogger.log("0", null, null, "Exception in finally ExcecuteBGProcess  :getUserInfo  [Error while updating error string in background table]");
                this.updateErrorMessage(jobId, objName, userId, finallye, null);
                finallye.printStackTrace();
            }
        }
        BaseLogger.log("2", null, null, "ExecuteBGProcess  ..........getUserInfo..............End");
        return userInfo;
    }

    private String getSiteCode(String mUserID, String siteCode, String userLevel) throws BaseException {
        BaseLogger.log("2", null, null, "Checking site access status for User ID :[" + mUserID + "] Site Code :[" + siteCode + "] User Level :[" + userLevel + "]");
        String siteAccessStatus = "INVALID_SITE";
        Statement stmt = null;
        ResultSet rs = null;
        Connection mConnection = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                mConnection = connDriver.getConnectDB("Driver");
                int siteStatusInt = -1;
                String selectQuery = "SELECT COUNT( SITE_CODE ) FROM SITE WHERE SITE_CODE='" + siteCode + "'";
                stmt = mConnection.createStatement();
                rs = stmt.executeQuery(selectQuery);
                if (rs.next()) {
                    siteStatusInt = rs.getInt(1);
                    BaseLogger.log("3", null, null, "Count from SITE :[" + siteStatusInt + "]");
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (siteStatusInt == 1 && userLevel != null && userLevel.length() > 0) {
                    int userLevelInt = Integer.parseInt(userLevel);
                    if (userLevelInt > 1) {
                        selectQuery = "SELECT COUNT( SITE_CODE ) FROM USER_SITE WHERE USER_ID='" + mUserID + "' AND SITE_CODE='" + siteCode + "'";
                        stmt = mConnection.createStatement();
                        rs = stmt.executeQuery(selectQuery);
                        if (rs.next()) {
                            siteStatusInt = rs.getInt(1);
                            BaseLogger.log("3", null, null, "Count from USER_SITE :[" + siteStatusInt + "]");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        mConnection.close();
                        siteAccessStatus = siteStatusInt == 0 ? "INACCESSIBLE_SITE" : siteCode;
                    } else {
                        siteAccessStatus = siteCode;
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :ExecuteBGProcess :checkSiteAccessStatus :==>");
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, " Exception :ExecuteBGProcess :" + e);
                throw new BaseException(e);
            }
        }
        BaseLogger.log("2", null, null, "[ExecuteBGProcess]Returning checkSiteAccessStatus :" + siteAccessStatus);
        return siteAccessStatus;
    }

    private void updateErrorMessage(String jobId, String objName, String userId, Exception exe, String errorStatus) {
        Connection connObj = null;
        Statement stmt = null;
        String sql = null;
        try {
            try {
                BaseLogger.log("3", null, null, "updateErrorMessage  ..............");
                ConnDriver connDriver = new ConnDriver();
                connObj = connDriver.getConnectDB("Driver");
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                String errorString = "";
                if (exe != null) {
                    exe.printStackTrace(pw);
                    errorString = sw != null && sw.toString().length() >= 2000 ? sw.toString().substring(0, 1999) : sw.toString();
                    sql = "UPDATE BACKGROUND_JOB SET EXECP_TRACE='" + this.getTraceData(errorString) + "',JOB_STAT='E',EXEC_DATE= " + this.sysdateStr + " WHERE JOB_ID='" + jobId + "' AND OBJ_NAME='" + objName + "' AND USER_ID='" + userId + "'";
                } else {
                    BaseLogger.log("3", null, null, "updateErrorMessage    updating Error string in EXECP_TRACE...................");
                    String execpTrace = String.valueOf(this.getErrorString(errorStatus, "message")) + " " + this.getErrorString(errorStatus, "description") + " " + this.getErrorString(errorStatus, "trace");
                    String messageString = this.getErrorString(errorString, "message");
                    BaseLogger.log("3", null, null, "updateErrorMessage:Type E:execpTrace[" + execpTrace + "]messageString[" + messageString + "]");
                    execpTrace = execpTrace != null && execpTrace.trim().length() > 2000 ? execpTrace.substring(0, 1999) : execpTrace;
                    messageString = messageString != null && messageString.trim().length() > 2000 ? messageString.substring(0, 1999) : messageString;
                    sql = "UPDATE BACKGROUND_JOB SET EXECP_TRACE='" + execpTrace + "',JOB_STAT='E',EXEC_DATE= " + this.sysdateStr + ",EXEC_RESULT='" + messageString + "' WHERE JOB_ID='" + jobId + "' AND OBJ_NAME='" + objName + "' AND USER_ID='" + userId + "'";
                }
                BaseLogger.log("3", null, null, "sql [" + sql + "]");
                stmt = connObj.prepareStatement(sql);
                stmt.executeUpdate();
                connObj.commit();
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                connObj.close();
            }
            catch (Exception e) {
                try {
                    if (connObj != null) {
                        connObj.rollback();
                    }
                }
                catch (Exception catche) {
                    BaseLogger.log("0", null, null, "Exception in catch ExecuteBGProcess  :  updateErrorMessage  [" + catche.getMessage() + "]");
                    catche.printStackTrace();
                }
                BaseLogger.log("3", null, null, "ExecuteBGProcess  :  updateErrorMessage  [" + e.getMessage() + "]");
                e.printStackTrace();
                try {
                    if (connObj != null) {
                        connObj.close();
                        connObj = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (Exception finallye) {
                    BaseLogger.log("0", null, null, "Exception in finally ExcecuteBGProcess  :updateErrorMessage  [Error while updating error string in background table]");
                    finallye.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (connObj != null) {
                    connObj.close();
                    connObj = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception finallye) {
                BaseLogger.log("0", null, null, "Exception in finally ExcecuteBGProcess  :updateErrorMessage  [Error while updating error string in background table]");
                finallye.printStackTrace();
            }
        }
    }

    private boolean updateStatusToI(String jobId, String objName, String userId, Connection connObj) {
        boolean processStatus;
        block28: {
            Statement pstmt = null;
            Statement stmt = null;
            String sql = null;
            String stat = null;
            processStatus = true;
            try {
                try {
                    sql = "UPDATE BACKGROUND_JOB SET JOB_STAT='I' WHERE JOB_ID='" + jobId + "' AND OBJ_NAME='" + objName + "' AND USER_ID='" + userId + "'";
                    pstmt = connObj.prepareStatement(sql);
                    pstmt.executeUpdate();
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    connObj.setAutoCommit(false);
                    stmt = connObj.createStatement();
                    if (this.DB_NAME.equalsIgnoreCase("ORACLE")) {
                        sql = "SELECT JOB_STAT FROM BACKGROUND_JOB WHERE JOB_ID = '" + jobId + "' FOR UPDATE NOWAIT ";
                    } else if (this.DB_NAME.equalsIgnoreCase("DB2")) {
                        sql = "SELECT JOB_STAT FROM BACKGROUND_JOB WHERE JOB_ID = '" + jobId + "' FOR UPDATE ";
                    } else if (this.DB_NAME.equalsIgnoreCase("MSSQL")) {
                        sql = "SELECT JOB_STAT FROM BACKGROUND_JOB ( UPDLOCK ) WHERE JOB_ID = '" + jobId + "'";
                    }
                    BaseLogger.log("3", null, null, "BackgroundJobCancelEJB:connUpdation  " + sql);
                    ResultSet rs = stmt.executeQuery(sql);
                    if (rs.next()) {
                        stat = rs.getString("JOB_STAT");
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    BaseLogger.log("3", null, null, "BackgroundJobCancelEJB :connUpdation: " + stat);
                    if (stat != null && stat.trim().length() > 0) {
                        if ("X".equalsIgnoreCase(stat)) {
                            processStatus = false;
                        }
                        break block28;
                    }
                    processStatus = false;
                }
                catch (Exception e) {
                    try {
                        connObj.rollback();
                        BaseLogger.log("3", null, null, "ExecuteBGProcess  :  updateResultToDB [Error while updating result or status in background table] [" + e.getMessage() + "]");
                        this.updateErrorMessage(jobId, objName, userId, e, null);
                        e.printStackTrace();
                        processStatus = false;
                    }
                    catch (Exception catche) {
                        BaseLogger.log("0", null, null, "ExecuteBGProcess  :  updateResultToDB [Error while updating result or status in background table] [" + e.getMessage() + "]");
                        e.printStackTrace();
                        processStatus = false;
                    }
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                    }
                    catch (Exception finallye) {
                        finallye.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (Exception finallye) {
                    finallye.printStackTrace();
                }
            }
        }
        return processStatus;
    }

    private void updateStatusToC(String jobId, String objName, String userId, String retStr, Connection connObj) {
        Statement stmt = null;
        String sql = "";
        try {
            try {
                sql = "UPDATE BACKGROUND_JOB SET EXEC_RESULT='" + this.getTraceData(retStr) + "',JOB_STAT='C',EXEC_DATE= " + this.sysdateStr + " WHERE JOB_ID='" + jobId + "' AND OBJ_NAME='" + objName + "' AND USER_ID='" + userId + "'";
                stmt = connObj.prepareStatement(sql);
                stmt.executeUpdate();
                connObj.commit();
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                connObj.close();
            }
            catch (Exception e) {
                try {
                    if (connObj != null) {
                        connObj.rollback();
                    }
                    BaseLogger.log("0", null, null, "ExecuteBGProcess  :  updateStatusToC catch [Error while updating result in background table] [" + e.getMessage() + "]");
                    this.updateErrorMessage(jobId, objName, userId, e, null);
                }
                catch (Exception catche) {
                    BaseLogger.log("0", null, null, "ExecuteBGProcess  :  updateResultToDB  catch of catch [Error while updating result in background table] [" + e.getMessage() + "]");
                    this.updateErrorMessage(jobId, objName, userId, e, null);
                    e.printStackTrace();
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getXtraParams(ArrayList userInfo, String jobID) throws Exception {
        String user_lang = "en";
        String user_country = "US";
        String chgTerm = "US";
        StringBuffer xtraParamsBuff = new StringBuffer();
        String loginCode = (String)userInfo.get(0);
        loginCode = loginCode != null && loginCode.trim().length() > 0 ? loginCode.trim() : loginCode;
        xtraParamsBuff.append("loginCode=" + loginCode);
        xtraParamsBuff.append("~~").append("loginEmpCode=" + userInfo.get(1));
        xtraParamsBuff.append("~~").append("loginSiteCode=" + userInfo.get(2));
        xtraParamsBuff.append("~~").append("entityCode=" + userInfo.get(3));
        xtraParamsBuff.append("~~").append("profileId=" + userInfo.get(4));
        xtraParamsBuff.append("~~").append("userType=" + userInfo.get(5));
        xtraParamsBuff.append("~~").append("runMode=I");
        xtraParamsBuff.append("~~").append("user_lang=" + user_lang);
        xtraParamsBuff.append("~~").append("user_country=" + user_country);
        xtraParamsBuff.append("~~").append("site_code=" + userInfo.get(2));
        xtraParamsBuff.append("~~").append("termId=" + userInfo.get(6));
        xtraParamsBuff.append("~~").append("charEnc=" + userInfo.get(7));
        xtraParamsBuff.append("~~").append("jobID=" + jobID);
        BaseLogger.log("2", null, null, "[ExecuteBGProcessEJB]XTRA_PARAMS :" + xtraParamsBuff.toString());
        return xtraParamsBuff.toString();
    }

    private String getTraceData(String errorString) throws Exception {
        String traceData = null;
        try {
            if (errorString.indexOf("Errors") != -1) {
                Document doc = new E12GenericUtility().parseString(errorString);
                NodeList nodeList = doc.getElementsByTagName("trace");
                int nodeListLen = nodeList.getLength();
                BaseLogger.log("3", null, null, "traceListLength [" + nodeListLen + "] ");
                int ctrPrnt = 0;
                while (ctrPrnt < nodeListLen) {
                    Node currentNode = nodeList.item(ctrPrnt);
                    traceData = currentNode.getNodeName().equalsIgnoreCase("trace") && currentNode.getFirstChild() != null ? currentNode.getFirstChild().getNodeValue() : traceData;
                    ++ctrPrnt;
                }
            } else {
                traceData = errorString;
            }
            traceData = traceData != null && traceData.trim().length() > 2000 ? traceData.substring(0, 1999) : traceData;
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Exception :ExecuteBGProcess :getTraceData :==>");
            throw new BaseException(e);
        }
        return traceData;
    }

    private String getErrorString(String errorString, String errorTag) throws Exception {
        String traceData = null;
        try {
            if (errorString.indexOf("Errors") != -1) {
                Document doc = new E12GenericUtility().parseString(errorString);
                NodeList nodeList = doc.getElementsByTagName(errorTag);
                int nodeListLen = nodeList.getLength();
                BaseLogger.log("3", null, null, "traceListLength [" + nodeListLen + "] ");
                int ctrPrnt = 0;
                while (ctrPrnt < nodeListLen) {
                    Node currentNode = nodeList.item(ctrPrnt);
                    traceData = currentNode.getNodeName().equalsIgnoreCase(errorTag) && currentNode.getFirstChild() != null ? currentNode.getFirstChild().getNodeValue() : traceData;
                    ++ctrPrnt;
                }
            } else {
                traceData = errorString;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ExecuteBGProcess :getTraceData :==>");
            throw new BaseException(e);
        }
        return traceData;
    }
}

