package ibase.webitm.ejb.wsfa.masters;

import ibase.utility.BaseException;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;

import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;

//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].
public class StrgCustUpdateGeoPosEJB extends ActionHandlerEJB implements StrgCustUpdateGeoPosLocal, StrgCustUpdateGeoPosRemote
{
	@Override
	public String updateCustomerGeoPos(String sc_code, String xtraParams, String forcedFlag) throws BaseException
	{
		String resultString = "";
		System.out.println("In updateCustomerGeoPos sc_code["+sc_code+"]");
		System.out.println("In updateCustomerGeoPos xtraParams["+xtraParams+"]");
		System.out.println("In updateCustomerGeoPos forcedFlag["+forcedFlag+"]");

		boolean isError = false;
		Connection mConnection = null;
		PreparedStatement mStatement = null;
		ResultSet mResultSet = null;
		PreparedStatement updateStatement = null;

		try
		{
			ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
			if(mConnection == null)
			{
				mConnection = getConnection();
				mConnection.setAutoCommit( false );
			}
			if( sc_code.indexOf(":") != -1 )
			{
				sc_code = sc_code.replaceAll(":", "").trim();
				System.out.println("sc_code:::["+sc_code+"]");
			}
			String query = ""; //$NON-NLS-1$
			String latLng = "";
			query = "select geo_pos from place_time_ent where entity_code = ?";
			mStatement = mConnection.prepareStatement(query);
			mStatement.setString(1, sc_code);
			mResultSet = mStatement.executeQuery();
		    if( mResultSet.next() )
		    {
		    	latLng = mResultSet.getString(1);
		    }
		    else
		    {
				query = "select addr1 || ' ' || addr2 || ' ' || addr3 || ', ' || city as Address from strg_customer where sc_code = ?";
				mStatement = mConnection.prepareStatement(query);
				mStatement.setString(1, sc_code);
				mResultSet = mStatement.executeQuery();
			    if( mResultSet.next() )
			    {
			    	String address = mResultSet.getString(1);
			    	String[] latLngArr = getLatLongPositions( address );
			    	latLng = latLngArr[0] + ", " + latLngArr[1];
			    }
			    if(mStatement!=null)
				{
					mStatement.close();
					mStatement=null;
				}
				if(mResultSet!=null)
				{
					mResultSet.close();
					mResultSet = null;
				}
		    }
		    if(mStatement!=null)
			{
				mStatement.close();
				mStatement=null;
			}
			if(mResultSet!=null)
			{
				mResultSet.close();
				mResultSet = null;
			}
			if( E12GenericUtility.checkNull(latLng).length() > 0 )
			{
		    	query = "update strg_customer set geo_pos = ? where sc_code = ?";
		    	updateStatement = mConnection.prepareStatement(query);
		    	updateStatement.setString(1, latLng);
		    	updateStatement.setString(2, sc_code);
				int count = updateStatement.executeUpdate();
				if(updateStatement!=null)
				{
					updateStatement.close();
					updateStatement=null;
				}
				if( count > 0 )
				{
					resultString =	itmDBAccessEJB.getErrorString("","GEOPOSSUCC","");
				}
				else
				{
					resultString = itmDBAccessEJB.getErrorString("","GEOPOSFLD","");
				}
			}
			else
			{
				resultString = itmDBAccessEJB.getErrorString("","GEOPOSFLD","");
			}
		}
		catch ( Exception e)
		{
			try
			{
				isError = true;
				System.out.println("Exception in DeviationReportEJB.getMRDeviationData():["+e.getMessage()+"]");
				resultString =	new ITMDBAccessEJB().getErrorString("","GEOPOSFLD","");
				e.printStackTrace();
				//throw new ITMException(e);
			}
			catch (RemoteException e1)
			{
				e1.printStackTrace();
			}
		}
		finally
		{
			try
			{
				if(mStatement!=null)
				{
					mStatement.close();
					mStatement=null;
				}
				if(mResultSet!=null)
				{
					mResultSet.close();
					mResultSet = null;
				}
				if(updateStatement!=null)
				{
					updateStatement.close();
					updateStatement=null;
				}
				if(mConnection!= null && !mConnection.isClosed())
				{
					if( isError )
					{
						mConnection.rollback();
						System.out.println("DeviationReportEJB Connection rollback........");
					}
					else
					{
						mConnection.commit();
						System.out.println("DeviationReportEJB Connection commited........");
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("DeviationReportEJB.getMRDeviationData.finally["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		return resultString;

	}

	public static String[] getLatLongPositions(String address) throws Exception
	{
	    int responseCode = 0;
	    System.out.println("getLatLongPositions of address:["+address+"]");
	    String api = "http://maps.googleapis.com/maps/api/geocode/xml?address=" + URLEncoder.encode(address, "UTF-8") + "&sensor=false";
	    System.out.println("URL : "+api);
	    URL url = new URL(api);
	    HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
	    httpConnection.connect();
	    responseCode = httpConnection.getResponseCode();
	    System.out.println("responseCode::["+responseCode+"]");
	    if(responseCode == 200)
	    {
	      DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();;
	      Document document = builder.parse(httpConnection.getInputStream());
	      XPathFactory xPathfactory = XPathFactory.newInstance();
	      XPath xpath = xPathfactory.newXPath();
	      XPathExpression expr = xpath.compile("/GeocodeResponse/status");
	      String status = (String)expr.evaluate(document, XPathConstants.STRING);
	      System.out.println("status::["+status+"]");
	      if(status.equals("OK"))
	      {
	    	 System.out.println("xpath:::"+xpath);
	         expr = xpath.compile("//geometry/location/lat");
	         System.out.println("expr:::"+expr);
	         String latitude = (String)expr.evaluate(document, XPathConstants.STRING);
	         System.out.println("latitude:::"+latitude);
	         expr = xpath.compile("//geometry/location/lng");
	         System.out.println("expr:::"+expr);
	         String longitude = (String)expr.evaluate(document, XPathConstants.STRING);
	         System.out.println("longitude:::"+longitude);
	         return new String[] {latitude, longitude};
	      }
	      else if(status.equals("OVER_QUERY_LIMIT"))
	      {
	    	  Thread.sleep(1000);
	    	  return getLatLongPositions(address);
	      }
	      else
	      {
	         throw new Exception("Error from the API - response status: "+status);
	      }
	    }
	    return null;
	}
}