/*Created BY shraddha M to Display Brand Campaign RX History 
 * 09-MAR-2021 (W20LSUN009 )
 */

package ibase.webitm.bean.wsfa;

import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.wsfa.transactions.RxHistoryData;


public class CampgnRxHistoryBean
{
	private String salesPerson = "";
	private String tranDate   = "";
	private String objName   = "";
	private String strgCode = "";
	private String tranID   = "";
	private String brandCode   = "";
	private String user_lang ="en"; 
	private String user_country = "US";
	private UserInfoBean userInfo = null;
	
	public String getSalesPerson()
	{
		return salesPerson;
	}
	public void setSalesPerson(String salesPerson) 
	{
		this.salesPerson = salesPerson;
	}
	
	public String getTranDate() 
	{
		return tranDate;
	}
	public void setEventDate(String tranDate) 
	{
		this.tranDate = tranDate;
	}
	
	public String getobjName() 
	{
		return objName;
	}
	public void setobjName(String objName) 
	{
		this.objName = objName;
	}
	
	public String getTranId() 
	{
		return tranID;
	}
	public void setTranId(String tranID) 
	{
		this.tranID = tranID;
		System.out.println("getTranId::>>"+tranID);
	}
	
	public String getbrandCode() 
	{
		return brandCode;
	}
	public void setbrandCode(String brandCode) 
	{
		this.brandCode = brandCode;
	}
	
	public UserInfoBean getUserInfo()
	{
		return this.userInfo;
	}
	public void setUserInfo(UserInfoBean userInfo) 
	{
		
		this.userInfo = userInfo;
		System.out.println("getUserInfo::>>"+userInfo);
	}
	
	
	public String getRxHistoryData(String salesPers,String strgCode,String brandCode,String campaignId,UserInfoBean userInfo) throws RemoteException, ITMException
	{
		System.out.println("getRxHistoryData..brandCode...."+brandCode+", "+strgCode);
		String profileId="";
		String summrxHistoryData = "";
		try 
		{
			profileId=userInfo.getProfileId();
			if(profileId!=null && profileId.trim().length()>0)
			{
				profileId=profileId.trim();
			}
			
			RxHistoryData rxHistoryData = new RxHistoryData();
			String summaryData = rxHistoryData.getData(salesPers,strgCode,brandCode,campaignId,userInfo);
			String xslFileName = getXSLFileName( "brand_campaign_rx_history_view.xsl" );
			
			System.out.println("xslFileName ::"+xslFileName);
			E12GenericUtility genericUtility = new E12GenericUtility();
			
			Document errorStrDom = genericUtility.parseString( summaryData );
			NodeList errorStrNodeList =  errorStrDom.getElementsByTagName("Detail2");
			int length = errorStrNodeList.getLength();
			
			System.out.println("length : ["+ length +"]");
			
			if(length == 0)
			{
				return summrxHistoryData;
			}
			else
			{
				summrxHistoryData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, summaryData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			}
				
		} 
		catch (Exception e) 
		{
			System.out.println("Exception :CampgnRxHistoryBean :getRxHistoryData:==>");
			throw new ITMException(e);
		}
		System.out.println("summrxHistoryData::::::;"+summrxHistoryData);
		return summrxHistoryData;
	}
	
	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		System.out.println("retFileName ::"+retFileName);
		return retFileName;
	}
	
}
