/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.UploadTemplateMapping;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;

public class XLS2XMLGenerator {
    ServletContext servletCtx = null;
    String loginCode = null;
    String objName = null;
    String currPKNames = null;
    ArrayList tableList = null;
    Connection con = null;

    public XLS2XMLGenerator(String loginCode, String fileName, ServletContext context) throws Exception {
        this.servletCtx = context;
        this.loginCode = loginCode;
        this.setDBConn(fileName);
    }

    public XLS2XMLGenerator() throws Exception {
    }

    private void setDBConn(String fileName) throws Exception {
        ConnDriver connDriver = new ConnDriver();
        this.con = connDriver.getConnectDB("DriverFileUpload", fileName);
    }

    public String[] generateXML() throws Exception {
        Statement stmt = null;
        Statement stmtHeader = null;
        Statement stmtCount = null;
        ResultSet rsCount = null;
        ResultSet rsHeader = null;
        StringBuffer detailBuff = null;
        String[] retXMLString = null;
        String updateQuery = null;
        int count = 0;
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                this.readMetadata();
                String headerTable = (String)this.tableList.get(0);
                String seleCountQuery = "SELECT count(*) FROM [" + headerTable + "]";
                stmtCount = this.con.createStatement();
                rsCount = stmtCount.executeQuery(seleCountQuery);
                while (rsCount.next()) {
                    count = rsCount.getInt(1);
                }
                retXMLString = new String[count];
                if (rsCount != null) {
                    rsCount.close();
                    rsCount = null;
                }
                if (stmtCount != null) {
                    stmtCount.close();
                    stmtCount = null;
                }
                String selheaderQuery = "SELECT * FROM [" + headerTable + "]";
                headerTable = headerTable.substring(0, headerTable.length() - 1);
                stmtHeader = this.con.createStatement();
                rsHeader = stmtHeader.executeQuery(selheaderQuery);
                ResultSetMetaData rsmdataHeader = rsHeader.getMetaData();
                int noOfColsHeader = rsmdataHeader.getColumnCount();
                int domId = 1;
                String data = null;
                int index = 0;
                while (rsHeader.next()) {
                    StringBuffer fieldDataBuff = new StringBuffer();
                    StringBuffer sqlBuff = new StringBuffer("");
                    detailBuff = new StringBuffer();
                    String currPkValue = null;
                    String currPkName = null;
                    detailBuff.append("<" + headerTable + " dbID='' " + "domID='" + domId++ + "' objName='" + this.objName + "'>\n");
                    detailBuff.append("<attribute pkNames='' status='N' updateFlag='N' selected='N'/>\n");
                    int j = 1;
                    while (j <= noOfColsHeader) {
                        String columnNameFrmRsmd = rsmdataHeader.getColumnName(j);
                        int metaType = rsmdataHeader.getColumnType(j);
                        data = rsHeader.getString(j);
                        if (this.currPKNames != null) {
                            StringTokenizer pkNameTokens = new StringTokenizer(this.currPKNames, ":");
                            while (pkNameTokens.hasMoreTokens()) {
                                String currPKName = pkNameTokens.nextToken();
                                if (!columnNameFrmRsmd.equalsIgnoreCase(currPKName)) continue;
                                currPkName = currPKName;
                                currPkValue = data;
                                if (data == null) continue;
                                if (sqlBuff.indexOf("WHERE") == -1) {
                                    sqlBuff.append(" WHERE ");
                                }
                                if (metaType == 4 || metaType == 3 || metaType == 6 || metaType == 8) {
                                    sqlBuff.append(currPkName).append("= ").append(currPkValue).append(" AND ");
                                    continue;
                                }
                                sqlBuff.append(currPkName).append("= '").append(currPkValue).append("' AND ");
                            }
                            updateQuery = sqlBuff.toString();
                            if (updateQuery.endsWith(" AND ")) {
                                updateQuery = updateQuery.substring(0, updateQuery.length() + 1 - " AND ".length());
                            }
                        }
                        if (data == null) {
                            data = "";
                        }
                        fieldDataBuff.append("<" + columnNameFrmRsmd.toLowerCase() + "><![CDATA[" + data + "]]></" + columnNameFrmRsmd.toLowerCase() + ">" + "\n");
                        ++j;
                    }
                    detailBuff.append(fieldDataBuff);
                    if (headerTable.equalsIgnoreCase("Detail1")) {
                        detailBuff.append("<chg_date/>\n");
                        detailBuff.append("<chg_user/>\n");
                        detailBuff.append("<chg_term/>\n");
                    }
                    detailBuff.append("</" + headerTable + ">\n");
                    int i = 1;
                    while (i < this.tableList.size()) {
                        String currTable = (String)this.tableList.get(i);
                        detailBuff.append(this.readSheet(currTable, updateQuery));
                        ++i;
                    }
                    retXMLString[index] = detailBuff.toString();
                    ++index;
                }
            }
            catch (Exception e) {
                this.servletCtx.log("[" + this.loginCode + "]Exception :XLS2XMLGenerator :generateXML==>");
                throw e;
            }
        }
        finally {
            try {
                if (this.con != null) {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (rsHeader != null) {
                        rsHeader.close();
                        rsHeader = null;
                    }
                    if (stmtHeader != null) {
                        stmtHeader.close();
                        stmtHeader = null;
                    }
                    if (stmtCount != null) {
                        stmtCount.close();
                        stmtCount = null;
                    }
                    this.con.close();
                    this.con = null;
                }
            }
            catch (Exception e) {
                this.servletCtx.log("[" + this.loginCode + "]Exception :XLS2XMLGenerator :generateXML==>in finally");
                throw e;
            }
        }
        return retXMLString;
    }

    private String readSheet(String sheetName, String updateQuery) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        StringBuffer retXMLStringBuff = new StringBuffer();
        try {
            try {
                String selQuery = "SELECT * FROM [" + sheetName + "] " + updateQuery;
                BaseLogger.log("3", null, null, "selQuery[" + selQuery + "]");
                String currTable = sheetName;
                currTable = currTable.substring(0, currTable.length() - 1);
                stmt = this.con.createStatement();
                rs = stmt.executeQuery(selQuery);
                ResultSetMetaData rsmdata = rs.getMetaData();
                int noOfCols = rsmdata.getColumnCount();
                int domId = 1;
                String data = null;
                while (rs.next()) {
                    StringBuffer fieldDataBuff = new StringBuffer();
                    StringBuffer detailBuff = new StringBuffer();
                    int j = 1;
                    while (j <= noOfCols) {
                        String columnNameFrmRsmd = rsmdata.getColumnName(j);
                        int metaType = rsmdata.getColumnType(j);
                        data = metaType == 93 ? this.displayDate(rs.getDate(j)) : rs.getString(j);
                        if (data == null) {
                            data = "";
                        }
                        fieldDataBuff.append("<" + columnNameFrmRsmd.toLowerCase() + "><![CDATA[" + data + "]]></" + columnNameFrmRsmd.toLowerCase() + ">" + "\n");
                        ++j;
                    }
                    detailBuff.append("<" + currTable + " dbID='' " + "domID='" + domId++ + "' objName='" + this.objName + "'>\n");
                    detailBuff.append("<attribute pkNames='' status='N' updateFlag='N' selected='N'/>\n");
                    detailBuff.append(fieldDataBuff);
                    detailBuff.append("</" + currTable + ">\n");
                    retXMLStringBuff.append(detailBuff);
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Error in readSheet of XLS2XMLGenerator");
                throw e;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
        }
        return retXMLStringBuff.toString();
    }

    private void readMetadata() throws Exception {
        this.setTableList();
        this.setObjName();
        this.setCurrPKName();
    }

    private void setTableList() throws Exception {
        ResultSet rs = null;
        DatabaseMetaData dbmd = this.con.getMetaData();
        rs = dbmd.getTables(null, null, null, null);
        this.tableList = new ArrayList();
        while (rs.next()) {
            String tableName = rs.getString(3);
            if (!tableName.startsWith("Detail")) continue;
            this.tableList.add(tableName);
        }
        if (rs != null) {
            rs.close();
            rs = null;
        }
    }

    private void setObjName() throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                String selQuery = "SELECT OBJ_NAME FROM [Metadata$]";
                stmt = this.con.createStatement();
                rs = stmt.executeQuery(selQuery);
                if (rs.next()) {
                    this.objName = rs.getString("OBJ_NAME");
                    BaseLogger.log("3", null, null, "objName :" + this.objName);
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in setObjName of XLS2XMLGenerator");
                throw e;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private void setCurrPKName() throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                String selQuery = "SELECT PK_NAME FROM [Metadata$]";
                stmt = this.con.createStatement();
                rs = stmt.executeQuery(selQuery);
                if (rs.next()) {
                    this.currPKNames = rs.getString("PK_NAME");
                    BaseLogger.log("3", null, null, "currPKName :" + this.currPKNames);
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in setCurrPKName of XLS2XMLGenerator");
                throw e;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public String getObjName() throws Exception {
        return this.objName;
    }

    private String displayDate(Date date) throws Exception {
        String dateString = null;
        if (date != null) {
            SimpleDateFormat sdfOutput = new SimpleDateFormat("dd.MMM.yyyy");
            dateString = sdfOutput.format(date);
            dateString = dateString.replace('.', '-');
        } else {
            dateString = "";
        }
        return dateString;
    }

    public String[] generateXML(String fileName) throws BiffException, IOException {
        return this.generateXML(fileName, null, null);
    }

    public String[] generateXML(String fileName, String templateName, UploadTemplateMapping templateMapping) throws BiffException, IOException {
        String[] retXMLString = null;
        try {
            BaseLogger.log("3", null, null, "....generateXML().....called");
            BaseLogger.log("3", null, null, "FILE NAME :" + fileName);
            File XLS_path = new File(CommonConstants.DUMP_DIR);
            Workbook workbook = Workbook.getWorkbook((File)new File(XLS_path + File.separator + fileName));
            int numOfSheets = workbook.getNumberOfSheets();
            BaseLogger.log("3", null, null, "XLS2XMLGenerator:generateXML():Number of sheets ======> [" + numOfSheets + "]");
            Sheet sheetmetadata = workbook.getSheet(0);
            String objName = sheetmetadata.getCell(0, 1).getContents();
            this.setJxlObjName(objName);
            String pkNames = E12GenericUtility.checkNull(sheetmetadata.getCell(1, 1).getContents()).replaceAll(",", ":");
            this.setCurrPKName(pkNames);
            BaseLogger.log("3", null, null, "pkNames : [" + pkNames + "]");
            List<String> pkNameList = Arrays.asList(pkNames.split(":"));
            BaseLogger.log("3", null, null, "pkNameList : [" + pkNameList + "]");
            StringBuffer dataBuff = null;
            int index = 0;
            if (E12GenericUtility.checkNull(templateName).length() > 0 && templateMapping != null) {
                LinkedHashMap<String, String> dataMap = templateMapping.buildExcelData(XLS_path.getPath(), workbook);
                retXMLString = new String[dataMap.size()];
                for (Map.Entry<String, String> dataEntry : dataMap.entrySet()) {
                    String value;
                    String key = dataEntry.getKey();
                    retXMLString[index] = value = dataEntry.getValue();
                    ++index;
                }
            } else {
                int j = 1;
                if (j == 1) {
                    BaseLogger.log("3", null, null, "XLS2XMLGenerator:generateXML():Sheet number:[" + j + "]");
                    ArrayList<String> columnNames = new ArrayList<String>();
                    Sheet sheet = workbook.getSheet(j);
                    int noOfColumns = sheet.getColumns();
                    int noOfRows = sheet.getRows();
                    BaseLogger.log("3", null, null, "XLS2XMLGenerator:generateXML():noOfRows in Detail1 [" + noOfRows + "]");
                    retXMLString = new String[noOfRows - 1];
                    ArrayList<Integer> pkColNoList = new ArrayList<Integer>();
                    int m = 0;
                    while (m < noOfColumns) {
                        String colName = sheet.getCell(m, 0).getContents();
                        columnNames.add(colName.replace(" ", "_"));
                        if (pkNameList.contains(colName)) {
                            pkColNoList.add(m);
                        }
                        ++m;
                    }
                    String[] sheetNames = new String[workbook.getNumberOfSheets()];
                    sheetNames = workbook.getSheetNames();
                    int yp = 0;
                    while (yp < workbook.getNumberOfSheets()) {
                        BaseLogger.log("3", null, null, "sheet name " + yp + ":[" + sheetNames[yp] + "]");
                        ++yp;
                    }
                    int index2 = 1;
                    int n = 1;
                    while (n < noOfRows) {
                        boolean endOfFile = false;
                        String tranId = this.getPKFieldValue(sheet, n, pkColNoList);
                        BaseLogger.log("3", null, null, "tran id in Detail1 at row[" + n + "] is [" + tranId + "]");
                        dataBuff = new StringBuffer();
                        dataBuff.append("<Detail" + j + " dbID='" + tranId + "' domID='" + index2 + "' objName='" + objName + "'>");
                        dataBuff.append("\n");
                        dataBuff.append("<attribute pkNames='' status='N' updateFlag='N' selected='N' />");
                        dataBuff.append("\n");
                        int m2 = 0;
                        while (m2 < noOfColumns) {
                            String colName = (String)columnNames.get(m2);
                            if (colName != null && colName.trim().length() > 0) {
                                if (sheet.getCell(m2, n).getContents() != null && "END_OF_FILE".equalsIgnoreCase(sheet.getCell(m2, n).getContents())) {
                                    endOfFile = true;
                                    break;
                                }
                                dataBuff.append("<" + colName + ">" + "<![CDATA[" + sheet.getCell(m2, n).getContents() + "]]>" + "</" + colName + ">");
                                dataBuff.append("\n");
                            }
                            ++m2;
                        }
                        if (endOfFile) break;
                        if (("Detail" + j).equalsIgnoreCase("Detail1")) {
                            dataBuff.append("<chg_date/>\n");
                            dataBuff.append("<chg_user/>\n");
                            dataBuff.append("<chg_term/>\n");
                        }
                        dataBuff.append("</Detail" + j + ">");
                        dataBuff.append("\n");
                        if (numOfSheets > 2) {
                            int m3;
                            int currSheetCols;
                            int currSheetRows;
                            int currSheetNo;
                            if (tranId == "" || tranId == null) {
                                BaseLogger.log("3", null, null, "Enter in single header multiple details case......... tran_id == \"\" || tran_id == null sheetNames[0]" + sheetNames[0]);
                                currSheetNo = 2;
                                while (currSheetNo < numOfSheets) {
                                    ArrayList<String> currColumnNamesDetList = new ArrayList<String>();
                                    BaseLogger.log("3", null, null, "sheet no.[" + currSheetNo + "] in sh md....");
                                    Sheet currSheet = workbook.getSheet(currSheetNo);
                                    currSheetRows = currSheet.getRows();
                                    BaseLogger.log("3", null, null, "sheet[" + currSheetNo + "]Rows[" + currSheetRows + "]");
                                    currSheetCols = currSheet.getColumns();
                                    m3 = 0;
                                    while (m3 < currSheetCols) {
                                        String colNameDet2 = currSheet.getCell(m3, 0).getContents();
                                        currColumnNamesDetList.add(colNameDet2.replace(" ", "_"));
                                        ++m3;
                                    }
                                    int p = 1;
                                    while (p < currSheetRows) {
                                        dataBuff.append("<Detail" + currSheetNo + " dbID='" + "' domID='" + p + "' objName='" + objName + "'>");
                                        dataBuff.append("\n");
                                        dataBuff.append("<attribute pkNames='' status='N' updateFlag='N' selected='N' />");
                                        dataBuff.append("\n");
                                        int q = 0;
                                        while (q < currSheetCols) {
                                            String colNameDet2 = (String)currColumnNamesDetList.get(q);
                                            if (colNameDet2 != null && colNameDet2.trim().length() > 0) {
                                                dataBuff.append("<" + colNameDet2 + ">" + "<![CDATA[" + currSheet.getCell(q, p).getContents() + "]]>" + "</" + colNameDet2 + ">");
                                                dataBuff.append("\n");
                                            }
                                            ++q;
                                        }
                                        dataBuff.append("</Detail" + currSheetNo + ">");
                                        dataBuff.append("\n");
                                        ++p;
                                    }
                                    ++currSheetNo;
                                }
                            } else if (tranId != "" || tranId != null) {
                                BaseLogger.log("3", null, null, "enter in multiple header multiple details case.........sheetNames[0] " + sheetNames[0]);
                                currSheetNo = 2;
                                while (currSheetNo < numOfSheets) {
                                    ArrayList<String> currColumnNamesList = new ArrayList<String>();
                                    pkColNoList = new ArrayList();
                                    Sheet nextSheet = workbook.getSheet(currSheetNo);
                                    currSheetRows = nextSheet.getRows();
                                    BaseLogger.log("3", null, null, "sheet[" + currSheetNo + "]Rows[" + currSheetRows + "]");
                                    currSheetCols = nextSheet.getColumns();
                                    m3 = 0;
                                    while (m3 < currSheetCols) {
                                        String colNameDet2 = nextSheet.getCell(m3, 0).getContents();
                                        currColumnNamesList.add(colNameDet2.replace(" ", "_"));
                                        if (pkNameList.contains(colNameDet2)) {
                                            pkColNoList.add(m3);
                                        }
                                        ++m3;
                                    }
                                    int index1 = 1;
                                    int p = 1;
                                    while (p < currSheetRows) {
                                        String nextSheetPKValue = this.getPKFieldValue(nextSheet, p, pkColNoList);
                                        if (tranId.equals(nextSheetPKValue)) {
                                            dataBuff.append("<Detail" + currSheetNo + " dbID='" + tranId + "' domID='" + index1 + "' objName='" + objName + "'>");
                                            dataBuff.append("\n");
                                            dataBuff.append("<attribute pkNames='' status='N' updateFlag='N' selected='N' />");
                                            dataBuff.append("\n");
                                            int q = 0;
                                            while (q < currSheetCols) {
                                                String colNameDet2 = (String)currColumnNamesList.get(q);
                                                if (colNameDet2 != null && colNameDet2.trim().length() > 0) {
                                                    dataBuff.append("<" + colNameDet2 + ">" + "<![CDATA[" + nextSheet.getCell(q, p).getContents() + "]]>" + "</" + colNameDet2 + ">");
                                                    dataBuff.append("\n");
                                                }
                                                ++q;
                                            }
                                            dataBuff.append("</Detail" + currSheetNo + ">");
                                            dataBuff.append("\n");
                                            ++index1;
                                        }
                                        ++p;
                                    }
                                    ++currSheetNo;
                                }
                            }
                        }
                        BaseLogger.log("3", null, null, "index in XLS2XMLGenerator[" + index + "]dataBuff.toString()[" + dataBuff.toString() + "]retXMLString.length()[" + retXMLString.length + "]");
                        retXMLString[index] = dataBuff.toString();
                        ++index;
                        index2 = numOfSheets > 2 ? 1 : ++index2;
                        ++n;
                    }
                }
            }
            workbook.close();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in XLS2XMLGenerator:GenerateXMl(filename)");
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, "retXMLString[" + retXMLString.length + "]");
        return retXMLString;
    }

    private void setJxlObjName(String objName) {
        this.objName = objName;
    }

    public String getJxlObjName() throws Exception {
        return this.objName;
    }

    private void setCurrPKName(String pkNames) {
        this.currPKNames = pkNames;
    }

    private String getPKFieldValue(Sheet sheet, int rowNum, ArrayList<Integer> pkColNoList) {
        StringBuffer pkFieldValue = new StringBuffer();
        int noOfColumns = sheet.getColumns();
        int colCtr = 0;
        while (colCtr < noOfColumns) {
            if (pkColNoList.contains(colCtr)) {
                String colValue = sheet.getCell(colCtr, rowNum).getContents();
                pkFieldValue.append(colValue).append(":");
            }
            ++colCtr;
        }
        String refId = pkFieldValue.toString();
        if (refId.endsWith(":")) {
            refId = refId.substring(0, refId.length() - 1);
        }
        BaseLogger.log("3", null, null, "getPKFieldValue : rowNum : [" + rowNum + "], refId : [" + refId + "]");
        return refId;
    }
}

