/*
 * Decompiled with CFR 0.152.
 */
package ibase.wrkflw.utility;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.notification.ejb.PublishPushNotificationEJB;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.WorkflowProcessDataMangerEJB;
import ibase.wrkflw.WorkflowProcessInstanceMonitorEJB;
import ibase.wrkflw.utility.SignTrans;
import ibase.wrkflw.utility.WorkflowLogger;
import ibase.wrkflw.utility.WorkflowProcessIdGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.InitialContext;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class MultiSignTrans {
    public String insertSignCtx(String processInstanceId, String roleCodeSign, String entityCode, String formatCode, String xslFileName, String signFor, String context1, String context2, String context3, String signRightsChar) throws RemoteException, BaseException {
        WorkflowLogger.info("[MultiSignTrans]Inserting sign for processInstanceId [" + processInstanceId + "] roleCodeSign :[" + roleCodeSign + "] entityCode :[" + entityCode + "] with context1 [" + context1 + "] context2 [" + context2 + "] context1 [" + context3 + "] signRightsChar [" + signRightsChar + "] ");
        boolean isError = false;
        String retStr = new String("");
        Connection conn = null;
        try {
            retStr = this.insertSignCtx(processInstanceId, roleCodeSign, entityCode, formatCode, xslFileName, signFor, context1, context2, context3, signRightsChar, conn);
        }
        catch (BaseException be) {
            be.printStackTrace();
            String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
            retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
            isError = true;
            WorkflowLogger.info("MultiSignTrans Exception occured : insertSignCtx : [" + be.getMessage() + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
            String workflowErrDirectory = this.sendErrMail(processInstanceId, "");
            retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
            isError = true;
            WorkflowLogger.info("MultiSignTrans Exception occured : insertSignCtx : [" + e.getMessage() + "]");
        }
        return retStr;
    }

    public String insertSignCtx(String processInstanceId, String roleCodeSign, String entityCode, String formatCode, String xslFileName, String signFor, String context1, String context2, String context3, String signRightsChar, Connection conn) throws RemoteException, BaseException {
        SignTrans signTrans = new SignTrans();
        BaseLogger.log("2", null, null, "MultiSignTrans.insertSignCtx()");
        WorkflowLogger.info("[MultiSignTrans]Inserting sign for processInstanceId with connection 222[" + processInstanceId + "] roleCodeSign :[" + roleCodeSign + "] entityCode :[" + entityCode + "] with context1 [" + context1 + "] context2 [" + context2 + "] context1 [" + context3 + "] signRightsChar [" + signRightsChar + "] ");
        boolean isError = false;
        PreparedStatement pStmt = null;
        String retStr = new String("");
        boolean isLocalConn = false;
        UserInfoBean userInfo = new UserInfoBean();
        try {
            try {
                String insertQuery;
                if (conn == null) {
                    conn = this.getConnection();
                    conn.setAutoCommit(false);
                    isLocalConn = true;
                    BaseLogger.log("3", null, null, "MultiSignTrans Local Connection created in >>insertSignCtx >> isLocalConn =[" + isLocalConn + "]");
                }
                String processId = WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId);
                String instanceId = WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId);
                String activityId = WorkflowProcessIdGenerator.getInstance().getActivityId(processInstanceId);
                String seqId = WorkflowProcessIdGenerator.getInstance().getSeqId(processInstanceId);
                WorkflowProcessDataMangerEJB workflowProcessDataManger = new WorkflowProcessDataMangerEJB();
                HashMap paramMap = workflowProcessDataManger.getProcessInputData(processId, Integer.parseInt(instanceId), activityId, Integer.parseInt(seqId), conn);
                workflowProcessDataManger = null;
                WorkflowLogger.info("paramMap " + paramMap);
                String objName = (String)paramMap.get("$OBJ_NAME");
                String refSer = (String)paramMap.get("$REF_SER");
                String refId = (String)paramMap.get("$REF_ID");
                String transInfo = (String)paramMap.get("$XML_DATA_ALL");
                int noOfRows = 0;
                AppConnectParm appConnect = new AppConnectParm();
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                ArrayList roleInfoList = dbAccessEJB.getRoleInfoList(conn, roleCodeSign);
                dbAccessEJB = null;
                int signTransLineNo = this.getMaxLineNoSignTransRole(refSer, refId, roleCodeSign, conn) + 1;
                boolean updStatus = false;
                if ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) || "db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                    insertQuery = "INSERT INTO OBJ_SIGN_TRANS( REF_SER, REF_ID, LINE_NO, ROLE_CODE__SIGN, CREATE_DATE, SIGN_STATUS, TITLE, ROLE_TYPE, ROLE_ENTITY, ENTITY_CODE, PRC_INST__WF, TRANS_INFO, MSG_FRM_FNAME, SIGN_FOR, CONTEXT_1, CONTEXT_2, CONTEXT_3, RIGHTS_CHAR_SIGN,OBJ_NAME ) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?)";
                    WorkflowLogger.info("MultiSignTrans ..Inserting into OBJ_SIGN_TRANS [" + insertQuery + "]");
                    pStmt = conn.prepareStatement(insertQuery);
                    pStmt.setString(1, refSer);
                    pStmt.setString(2, refId);
                    pStmt.setInt(3, signTransLineNo);
                    pStmt.setString(4, roleCodeSign);
                    pStmt.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                    pStmt.setString(6, "U");
                    pStmt.setString(7, "");
                    pStmt.setString(8, (String)roleInfoList.get(0));
                    pStmt.setString(9, (String)roleInfoList.get(1));
                    pStmt.setString(10, entityCode);
                    pStmt.setString(11, processInstanceId);
                    pStmt.setString(14, signFor);
                    pStmt.setString(15, context1);
                    pStmt.setString(16, context2);
                    pStmt.setString(17, context3);
                    pStmt.setString(18, signRightsChar);
                    pStmt.setString(19, objName);
                    byte[] encoded = transInfo.getBytes();
                    ByteArrayInputStream byteArrayIn = new ByteArrayInputStream(encoded);
                    pStmt.setBinaryStream(12, (InputStream)byteArrayIn, byteArrayIn.available());
                    if (xslFileName != null && xslFileName.length() > 0) {
                        pStmt.setString(13, xslFileName);
                    } else {
                        pStmt.setNull(13, 0);
                    }
                    WorkflowLogger.info("Pstmt values refSer :[" + refSer + "], refId :[" + refId + "], lineNo :[" + signTransLineNo + "], roleCodeSign :[" + roleCodeSign + "], roleType :[" + (String)roleInfoList.get(0) + "], roleEntity :[" + (String)roleInfoList.get(1) + "], entityCode :[" + entityCode + "], processInstanceId :[" + processInstanceId + "]");
                    noOfRows = pStmt.executeUpdate();
                    BaseLogger.log("3", null, null, "MultiSignTrans.insertSignCtx() noOfRows : " + noOfRows);
                    pStmt.close();
                    pStmt = null;
                    updStatus = true;
                } else {
                    insertQuery = "INSERT INTO OBJ_SIGN_TRANS(REF_SER, REF_ID, LINE_NO, ROLE_CODE__SIGN, CREATE_DATE, SIGN_STATUS, TITLE, ROLE_TYPE, ROLE_ENTITY, ENTITY_CODE, PRC_INST__WF, TRANS_INFO, MSG_FRM_FNAME, SIGN_FOR, CONTEXT_1, CONTEXT_2, CONTEXT_3, RIGHTS_CHAR_SIGN, USER_INPUT,OBJ_NAME ) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, EMPTY_BLOB(),?,?,?,?,?,?,?,?)";
                    WorkflowLogger.info("MultiSignTrans ..Inserting into OBJ_SIGN_TRANS with context [" + insertQuery + "]");
                    pStmt = conn.prepareStatement(insertQuery);
                    pStmt.setString(1, refSer);
                    pStmt.setString(2, refId);
                    pStmt.setInt(3, signTransLineNo);
                    pStmt.setString(4, roleCodeSign);
                    pStmt.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                    pStmt.setString(6, "U");
                    pStmt.setString(7, "");
                    pStmt.setString(8, (String)roleInfoList.get(0));
                    pStmt.setString(9, (String)roleInfoList.get(1));
                    pStmt.setString(10, entityCode);
                    pStmt.setString(11, processInstanceId);
                    pStmt.setString(13, signFor);
                    pStmt.setString(14, context1);
                    pStmt.setString(15, context2);
                    pStmt.setString(16, context3);
                    pStmt.setString(17, signRightsChar);
                    if (xslFileName != null && xslFileName.length() > 0) {
                        pStmt.setString(12, xslFileName);
                    } else {
                        pStmt.setNull(12, 0);
                    }
                    if ("emp_statuschg".equalsIgnoreCase(objName)) {
                        pStmt.setString(18, "Y");
                    } else {
                        pStmt.setString(18, "N");
                    }
                    pStmt.setString(19, objName);
                    WorkflowLogger.info("Pstmt values refSer :[" + refSer + "], refId :[" + refId + "], lineNo :[" + signTransLineNo + "], roleCodeSign :[" + roleCodeSign + "], roleType :[" + (String)roleInfoList.get(0) + "], roleEntity :[" + (String)roleInfoList.get(1) + "], entityCode :[" + entityCode + "], processInstanceId :[" + processInstanceId + "]");
                    noOfRows = pStmt.executeUpdate();
                    pStmt.close();
                    pStmt = null;
                    String query = "";
                    query = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? "UPDATE OBJ_SIGN_TRANS SET TRANS_INFO_XML = XMLType(?) WHERE REF_SER=? AND REF_ID=? AND LINE_NO=? " : "SELECT TRANS_INFO FROM OBJ_SIGN_TRANS WHERE REF_SER=? AND REF_ID=? AND LINE_NO=? FOR UPDATE NOWAIT";
                    ArrayList<String> bindVarValues = new ArrayList<String>();
                    bindVarValues.add(refSer);
                    bindVarValues.add(refId);
                    bindVarValues.add(String.valueOf(signTransLineNo));
                    ArrayList<String> bindVarTypes = new ArrayList<String>();
                    bindVarTypes.add("String");
                    bindVarTypes.add("String");
                    bindVarTypes.add("Int");
                    updStatus = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? this.updateXMLTypeStr(conn, query, transInfo, bindVarValues, bindVarTypes) : this.updateBlob(conn, query, transInfo, bindVarValues, bindVarTypes);
                }
                WorkflowLogger.info("[MultiSignTrans]Insertion into OBJ_SIGN_TRANS with context done... updStatus [" + updStatus + "]");
                if (updStatus) {
                    BaseLogger.log("3", null, null, "new changes conn!!!!" + conn);
                    conn.commit();
                    this.sendMail(objName, transInfo, refSer, refId, signTransLineNo, formatCode, entityCode, (String)roleInfoList.get(1), xslFileName, conn);
                    retStr = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Success]]></RESULT></ROOT>";
                    try {
                        String tableName = " WF_ROLE_USERS ";
                        String columnName = " USERID ";
                        StringBuilder condition = new StringBuilder();
                        condition.append(" WHERE ROLE_CODE='").append(roleCodeSign).append("' ");
                        ArrayList<String> userIdList = signTrans.getDBColumnValues(tableName, columnName, condition.toString(), conn, userInfo.getTransDB());
                        String tableNm = " USERS ";
                        String columnNm = " CODE ";
                        StringBuilder condn = new StringBuilder();
                        condn.append(" WHERE ENTITY_CODE='").append(entityCode).append("' ");
                        ArrayList<String> userCodeList = signTrans.getDBColumnValues(tableNm, columnNm, condn.toString(), conn, userInfo.getTransDB());
                        userIdList.addAll(userCodeList);
                        WorkflowLogger.info("In SignTrans utility userIdList[" + userIdList + "]");
                        String userMessage = "Workflow : " + signFor;
                        String loginUserCode = "";
                        String notificationType = "";
                        notificationType = "K".equalsIgnoreCase(signRightsChar) ? "" : "approvals";
                        StringBuilder xmlDataBuilder = new StringBuilder("<ROOT>");
                        xmlDataBuilder.append(this.createXMLTag("OBJ_NAME", objName)).append(this.createXMLTag("REF_SER", refSer)).append(this.createXMLTag("REF_ID", refId)).append(this.createXMLTag("LINE_NO", "" + signTransLineNo)).append(this.createXMLTag("USER_ID", userInfo.getLoginCode())).append(this.createXMLTag("SERVER_URL", CommonConstants.TOMCAT_HOME)).append(this.createXMLTag("SITE_CODE", userInfo.getSiteCode())).append("</ROOT>");
                        BaseLogger.log("3", null, null, "xmldatabuilder:::" + xmlDataBuilder.toString());
                        this.publishPushNotificationEJB().invockPushNotification(userMessage, loginUserCode, "W", refId, userIdList, xmlDataBuilder.toString(), refId, refSer, loginUserCode, signTransLineNo, notificationType, userInfo);
                    }
                    catch (Exception ne) {
                        ne.printStackTrace();
                    }
                }
            }
            catch (BaseException be) {
                be.printStackTrace();
                String workflowErrDirectory = this.sendErrMail(processInstanceId, "", conn);
                retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
                isError = true;
                WorkflowLogger.info("MultiSignTrans Exception occured : insertSignCtx : [" + be.getMessage() + "]");
                try {
                    if (conn != null && isError) {
                        BaseLogger.log("3", null, null, "MultiSignTrans  [insertSign]isLocalConn =" + isLocalConn + " and rollback the changes");
                        conn.rollback();
                    }
                    if (conn != null && isLocalConn) {
                        BaseLogger.log("3", null, null, "MultiSignTrans [insertSignCtx]isLocalConn =" + isLocalConn + " and commiting the changes");
                        conn.commit();
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception :MultiSignTrans  :insertSign :==>finally\n" + e.getMessage());
                    WorkflowLogger.info("Exception occured : insertSignCtx : finally : [" + e.getMessage() + "]");
                    throw new BaseException(e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                String workflowErrDirectory = this.sendErrMail(processInstanceId, "", conn);
                retStr = "<ROOT><STATUS><![CDATA[0]]></STATUS><RESULT><![CDATA[Error Occured check in folder " + workflowErrDirectory + " for detail ]]></RESULT></ROOT>";
                isError = true;
                WorkflowLogger.info("MultiSignTrans Exception occured : insertSignCtx : [" + e.getMessage() + "]");
                try {
                    if (conn != null && isError) {
                        BaseLogger.log("3", null, null, "MultiSignTrans  [insertSign]isLocalConn =" + isLocalConn + " and rollback the changes");
                        conn.rollback();
                    }
                    if (conn != null && isLocalConn) {
                        BaseLogger.log("3", null, null, "MultiSignTrans [insertSignCtx]isLocalConn =" + isLocalConn + " and commiting the changes");
                        conn.commit();
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    System.err.println("Exception :MultiSignTrans  :insertSign :==>finally\n" + e2.getMessage());
                    WorkflowLogger.info("Exception occured : insertSignCtx : finally : [" + e2.getMessage() + "]");
                    throw new BaseException(e2);
                }
            }
        }
        finally {
            try {
                if (conn != null && isError) {
                    BaseLogger.log("3", null, null, "MultiSignTrans  [insertSign]isLocalConn =" + isLocalConn + " and rollback the changes");
                    conn.rollback();
                }
                if (conn != null && isLocalConn) {
                    BaseLogger.log("3", null, null, "MultiSignTrans [insertSignCtx]isLocalConn =" + isLocalConn + " and commiting the changes");
                    conn.commit();
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :MultiSignTrans  :insertSign :==>finally\n" + e.getMessage());
                WorkflowLogger.info("Exception occured : insertSignCtx : finally : [" + e.getMessage() + "]");
                throw new BaseException(e);
            }
        }
        return retStr;
    }

    private String sendErrMail(String processInstanceId, String resultStr, Connection conn) {
        String wrkflwErrDirectory = "";
        try {
            WorkflowProcessInstanceMonitorEJB workflowProcessInstanceMonitor = new WorkflowProcessInstanceMonitorEJB();
            wrkflwErrDirectory = workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, resultStr, conn);
            workflowProcessInstanceMonitor = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wrkflwErrDirectory;
    }

    private String sendErrMail(String processInstanceId, String resultStr) {
        String wrkflwErrDirectory = "";
        try {
            WorkflowProcessInstanceMonitorEJB workflowProcessInstanceMonitor = new WorkflowProcessInstanceMonitorEJB();
            wrkflwErrDirectory = workflowProcessInstanceMonitor.sendErrorMail(processInstanceId, resultStr);
            workflowProcessInstanceMonitor = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wrkflwErrDirectory;
    }

    private Connection getConnection() throws BaseException {
        Connection con = null;
        try {
            ConnDriver connDriver = new ConnDriver();
            BaseLogger.log("3", null, null, "CommonConstants.WRKFLW_DB : " + CommonConstants.WRKFLW_DB);
            con = connDriver.getConnectDB(CommonConstants.WRKFLW_DB);
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return con;
    }

    private int getMaxLineNoSignTransRole(String refSer, String refId, String roleCodeSign, Connection conn) throws BaseException {
        WorkflowLogger.info("Getting MaxLineNo from OBJ_SIGN_TRANS ...");
        Statement stmt = null;
        int lineNo = 0;
        try {
            try {
                stmt = conn.createStatement();
                String sql = "SELECT MAX(LINE_NO) AS LINE_NO FROM OBJ_SIGN_TRANS WHERE REF_SER='" + refSer + "' AND REF_ID='" + refId + "' ";
                WorkflowLogger.info(" sql " + sql);
                ResultSet rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    lineNo = rs.getInt("LINE_NO");
                }
                rs.close();
                rs = null;
                stmt.close();
                stmt = null;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        WorkflowLogger.info("From Obj_sign_trans lineNo [" + lineNo + "]");
        return lineNo;
    }

    private boolean updateXMLTypeStr(Connection con, String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes) throws RemoteException, ITMException {
        BaseLogger.log("2", null, null, "MultiSignTrans.updateXMLTypeStr()");
        BaseLogger.log("2", null, null, "@@@@ inside updateXMLType");
        WorkflowLogger.info("query [" + query + "]");
        WorkflowLogger.info("bindVarTypes [" + bindVarTypes + "]");
        WorkflowLogger.info("bindVarValues [" + bindVarValues + "]");
        boolean updStatus = false;
        Statement pStmt = null;
        Object oConnection = null;
        try {
            try {
                byte[] dataByteArray = null;
                E12GenericUtility genericUtility = new E12GenericUtility();
                dataStr = genericUtility.remAllXmlDec(dataStr);
                if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) {
                    dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
                    dataByteArray = dataStr.getBytes();
                } else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) {
                    dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
                    dataByteArray = dataStr.getBytes();
                }
                pStmt = con.prepareStatement(query);
                CLOB dataStrXml = CLOB.createTemporary((Connection)con.getMetaData().getConnection(), (boolean)true, (int)10);
                dataStrXml.putString(1L, dataStr);
                pStmt.setClob(1, (Clob)dataStrXml);
                int ctr = 0;
                while (ctr < bindVarValues.size()) {
                    if (((String)bindVarTypes.get(ctr)).indexOf("String") != -1) {
                        pStmt.setString(ctr + 2, (String)bindVarValues.get(ctr));
                    } else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) {
                        pStmt.setInt(ctr + 2, Integer.parseInt((String)bindVarValues.get(ctr)));
                    }
                    ++ctr;
                }
                int updateCnt = pStmt.executeUpdate();
                BaseLogger.log("3", null, null, "@@@@ updateCnt in updateXMLType" + updateCnt);
                if (updateCnt > 0) {
                    updStatus = true;
                }
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :updateBlob :==>finally\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return updStatus;
    }

    private boolean updateBlob(Connection con, String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes) throws BaseException {
        BaseLogger.log("2", null, null, "MultiSignTrans.updateBlob()");
        WorkflowLogger.info("query [" + query + "]");
        WorkflowLogger.info("bindVarTypes [" + bindVarTypes + "]");
        WorkflowLogger.info("bindVarValues [" + bindVarValues + "]");
        boolean updStatus = false;
        PreparedStatement pStmt = null;
        try {
            try {
                pStmt = con.prepareStatement(query);
                int ctr = 0;
                while (ctr < bindVarValues.size()) {
                    if (((String)bindVarTypes.get(ctr)).indexOf("String") != -1) {
                        pStmt.setString(ctr + 1, (String)bindVarValues.get(ctr));
                    } else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) {
                        pStmt.setInt(ctr + 1, Integer.parseInt((String)bindVarValues.get(ctr)));
                    }
                    ++ctr;
                }
                ResultSet rs = pStmt.executeQuery();
                if (rs.next()) {
                    Blob mapBlob = rs.getBlob(1);
                    OutputStream blobOutputStream = ((BLOB)mapBlob).getBinaryOutputStream();
                    byte[] dataByteArray = null;
                    E12GenericUtility genericUtility = new E12GenericUtility();
                    if ((dataStr = genericUtility.remAllXmlDec(dataStr)) != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
                        dataByteArray = dataStr.getBytes();
                    } else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
                        dataByteArray = dataStr.getBytes();
                    }
                    if (dataByteArray != null) {
                        BaseLogger.log("3", null, null, "Writing to blob data of length [" + dataByteArray.length + "]");
                    }
                    blobOutputStream.write(dataByteArray);
                    blobOutputStream.close();
                    updStatus = true;
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Exception :SignTrans :updateBlob :==>finally\n" + e.getMessage());
                throw new BaseException(e);
            }
        }
        return updStatus;
    }

    private void sendMail(String objName, String xmlString, String refSer, String refId, int lineNo, String formatCode, String entityCode, String entityType, String xslFileName, Connection connection) throws BaseException {
        WorkflowLogger.info("[MultiSignTrans]Sending mail to minimum unsigned signature for objName :[" + objName + "] refSer :[" + refSer + "] refId :[" + refId + "] lineNo :[" + lineNo + "] formatCode :[" + formatCode + "] xmlString length :[" + xmlString.length() + "]");
        boolean emailFlag = false;
        try {
            if (formatCode != null) {
                String mailDomStr = "<ROOT><TRANS_INFO><OBJ_NAME>" + objName + "</OBJ_NAME>" + "<REF_SER>" + refSer + "</REF_SER><REF_ID>" + refId + "</REF_ID>" + "<LINE_NO>" + lineNo + "</LINE_NO><XSL_FILE_NAME>" + xslFileName + "</XSL_FILE_NAME></TRANS_INFO>" + "<MAIL><EMAIL_TYPE>link</EMAIL_TYPE><ENTITY_CODE>" + entityCode + "</ENTITY_CODE>" + "<ENTITY_TYPE>" + entityType + "</ENTITY_TYPE><FORMAT_CODE>" + formatCode + "</FORMAT_CODE>" + "<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>" + "</MAIL><XML_DATA>" + xmlString + "</XML_DATA></ROOT>";
                EMail email = new EMail();
                email.sendMail(mailDomStr, "ITM", connection);
            }
        }
        catch (BaseException be) {
            WorkflowLogger.info("Mail Sending failed");
        }
        catch (Exception e) {
            WorkflowLogger.info("Mail Sending failed");
        }
    }

    private PublishPushNotificationEJB publishPushNotificationEJB() throws BaseException {
        PublishPushNotificationEJB publishPushNotificationEJB = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            BaseLogger.log("3", null, null, "Looking Up for PublishPushNotification EJB with Properties==>\n" + p);
            publishPushNotificationEJB = new PublishPushNotificationEJB();
        }
        catch (BaseException be) {
            BaseLogger.log("0", null, null, "Exception: publishPushNotificationEJB:==>\n" + be);
            throw be;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: publishPushNotificationEJB:==>\n" + e);
            throw new BaseException(e);
        }
        return publishPushNotificationEJB;
    }

    public String createXMLTag(String tagName, String value) {
        return "<" + tagName + "><![CDATA[" + value + "]]></" + tagName + ">";
    }
}

