/*
 * Decompiled with CFR 0.152.
 */
package ibase.bis.ejb;

import ibase.bis.ejb.BISIntentNEntityRecognitionProcess;
import ibase.bis.ejb.BusinessIntentEJB;
import ibase.bis.utility.BISDictionary;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class OpenAiApi
extends BISIntentNEntityRecognitionProcess {
    private final String NLP_AGENT = "OpenAI";
    JSONObject nlpDetailJson = null;

    @Override
    public String processIntent(String inputString) throws ITMException {
        String responseStr;
        block38: {
            BaseLogger.log("3", this.getUserInfo(), null, "In processIntent :: inputString line no 32:::" + inputString);
            responseStr = "";
            BISDictionary bi = new BISDictionary();
            BusinessIntentEJB bisIntentEjb = new BusinessIntentEJB();
            E12GenericUtility e12GenericUtility = new E12GenericUtility();
            JSONObject response = new JSONObject();
            try {
                JSONObject bisDictResp = bi.getProductIdentificationAlias(this.getUserInfo());
                String tempInputStr = inputString;
                String currentInputString = URLEncoder.encode(inputString, CommonConstants.ENCODING);
                String invokeRes = this.invokeIntent(this.getUserInfo(), currentInputString);
                String intentAliasVal = "";
                if (!"".equals(E12GenericUtility.checkNull(invokeRes)) && invokeRes.indexOf("Errors") == -1) {
                    JSONObject invokeResObj = new JSONObject(invokeRes);
                    BaseLogger.log("3", this.getUserInfo(), null, "In processIntent :: invokeResObj line no 50:::" + invokeResObj);
                    String intentVal = invokeResObj.getString("intent");
                    String domainVal = invokeResObj.getString("domain");
                    intentAliasVal = bi.getValueForAlias(bisDictResp, intentVal, domainVal, "vision_assistant");
                    BaseLogger.log("3", this.getUserInfo(), null, "In processIntent :: intentAliasVal line no 52:::" + intentAliasVal);
                    JSONArray intentArr = new JSONArray();
                    JSONObject intentJson = new JSONObject();
                    String intentDescription = "";
                    if (!intentAliasVal.equals(intentVal)) {
                        intentJson.put("confidence", 0);
                        intentJson.put("id", (Object)"403744964305781");
                        intentJson.put("name", (Object)intentAliasVal);
                        intentArr.put((Object)intentJson);
                    } else {
                        String intQueryString = "";
                        String intPineConeVectorURL = "";
                        Map<String, Map<String, String>> pythonServicesMap = CommonConstants.EXTRACTION_PYTHON_SERVICES;
                        APIUtility apiUtility = new APIUtility();
                        String serverUrl = "";
                        if (pythonServicesMap != null) {
                            Map<String, String> proteusSenseServiceDetails = pythonServicesMap.get("DATA_EXTRACTOR");
                            String protocol = proteusSenseServiceDetails.get("PROTOCOL");
                            String host = proteusSenseServiceDetails.get("HOST");
                            String port = E12GenericUtility.checkNull(proteusSenseServiceDetails.get("PORT"));
                            String path = apiUtility.getAPIUrl(this.getUserInfo(), "VectorLookup");
                            if (path.contains("WeaviateVector")) {
                                serverUrl = apiUtility.getAPIUrl(this.getUserInfo(), "WeaviateVector");
                            }
                            intPineConeVectorURL = String.format("%s://%s%s/%s", protocol, host, port, path);
                        }
                        ArrayList<String> openaiParams = apiUtility.getAPIKey(this.getUserInfo(), "OpenAI");
                        ArrayList<String> pineConeAPIParams = apiUtility.getAPIKey(this.getUserInfo(), "PineCone");
                        JSONObject currentIntentJson = new JSONObject();
                        String entitiesVal = "";
                        JSONObject entitiesJsonObject = new JSONObject();
                        JSONArray entitiesJsonArr = invokeResObj.getJSONArray("entities");
                        int i = 0;
                        while (i < entitiesJsonArr.length()) {
                            entitiesJsonObject = entitiesJsonArr.getJSONObject(i);
                            if (entitiesJsonObject.has("type")) {
                                String entitiesTypeVal = entitiesJsonObject.optString("type");
                                if (entitiesJsonObject.has("value")) {
                                    entitiesVal = entitiesJsonObject.optString("value");
                                    String entitiesAlias = "";
                                    if (tempInputStr.contains(entitiesVal)) {
                                        entitiesAlias = bi.getValueForAlias(bisDictResp, entitiesTypeVal.toUpperCase(), domainVal, "vision_assistant");
                                        BaseLogger.log("3", this.getUserInfo(), null, "In processIntent :: entitiesAlias line no 106:::" + entitiesAlias);
                                        entitiesAlias = ":" + entitiesAlias;
                                        tempInputStr = tempInputStr.replace(entitiesVal, entitiesAlias);
                                    }
                                }
                                if (entitiesTypeVal.equalsIgnoreCase("date_range")) {
                                    JSONObject dateRangeJson = new JSONObject();
                                    if (entitiesJsonObject.has("value")) {
                                        dateRangeJson = entitiesJsonObject.getJSONObject("value");
                                    }
                                    Iterator iterator = dateRangeJson.keys();
                                    while (iterator.hasNext()) {
                                        String key = null;
                                        String dateRangeVal = "";
                                        key = (String)iterator.next();
                                        dateRangeVal = dateRangeJson.getString(key);
                                        key = bi.getValueForAlias(bisDictResp, key, domainVal, "vision_assistant");
                                        key = ":" + key;
                                        tempInputStr = tempInputStr.replace(dateRangeVal, key);
                                    }
                                }
                            }
                            ++i;
                        }
                        currentIntentJson.put("1", (Object)tempInputStr);
                        JSONObject intConfigData = new JSONObject();
                        intConfigData.put("index_name", (Object)"vision-masters");
                        intConfigData.put("pineCone_apiKey", (Object)pineConeAPIParams.get(0));
                        intConfigData.put("openAI_apiKey", (Object)openaiParams.get(0));
                        intConfigData.put("queryJson", (Object)currentIntentJson);
                        intConfigData.put("enterprise", (Object)this.getUserInfo().getEnterprise());
                        intConfigData.put("entity_type", (Object)"intent");
                        intConfigData.put("server_url", (Object)serverUrl);
                        String pineConeConfig = intConfigData.toString();
                        ByteArrayInputStream intentDataInputStream = null;
                        StringBuffer queryParam = new StringBuffer();
                        queryParam.append("jsonData=").append(pineConeConfig);
                        intQueryString = queryParam.toString();
                        if (intQueryString != null) {
                            intentDataInputStream = new ByteArrayInputStream(intQueryString.getBytes(StandardCharsets.UTF_8));
                        }
                        byte[] responseData = E12GenericUtility.makeRequest(intPineConeVectorURL, intentDataInputStream, 0, null, "application/json");
                        e12GenericUtility.createAIApiLog(this.getUserInfo(), 1, "bis-assistant", "OpenAI");
                        if (responseData != null) {
                            String responseDataStr = new String(responseData);
                            JSONObject responseDataJson = new JSONObject(responseDataStr);
                            JSONObject innerJson = new JSONObject();
                            innerJson = responseDataJson.getJSONObject("1");
                            intentAliasVal = innerJson.getString("id");
                            intentDescription = innerJson.getString("material_description");
                            if (intentAliasVal.contains("__")) {
                                intentAliasVal = intentAliasVal.substring(0, intentAliasVal.indexOf("__"));
                            }
                            intentJson.put("confidence", 0);
                            intentJson.put("id", (Object)innerJson.getString("id"));
                            intentJson.put("name", (Object)intentAliasVal);
                            intentArr.put((Object)intentJson);
                        }
                    }
                    String entityJsonVal = "";
                    JSONObject entitiesObject = new JSONObject();
                    JSONArray entitiesArr = invokeResObj.getJSONArray("entities");
                    JSONArray entitiesArray = new JSONArray();
                    int i = 0;
                    while (i < entitiesArr.length()) {
                        entitiesObject = entitiesArr.getJSONObject(i);
                        if (entitiesObject.has("type")) {
                            String entitiesTypeVal;
                            String entityFromOpenAI = entitiesTypeVal = entitiesObject.optString("type");
                            JSONObject typeValJson = new JSONObject();
                            if (!(entitiesTypeVal.equalsIgnoreCase("date") || entitiesTypeVal.equalsIgnoreCase("date_range") || entitiesTypeVal.equalsIgnoreCase("month") || entitiesTypeVal.equalsIgnoreCase("day") || entitiesTypeVal.equalsIgnoreCase("period") || entitiesTypeVal.equalsIgnoreCase("year") || entitiesTypeVal.equalsIgnoreCase("duration"))) {
                                if (entitiesObject.has("value")) {
                                    entitiesTypeVal = bi.getValueForAlias(bisDictResp, entitiesTypeVal.toUpperCase(), domainVal, "vision_assistant");
                                    BaseLogger.log("3", this.getUserInfo(), null, "In processIntent :: entitiesTypeVal line no 193:::" + entitiesTypeVal);
                                    String enabled = bisIntentEjb.isVectorLookupEnabled(entitiesTypeVal, this.getUserInfo());
                                    String entityValue = entitiesObject.optString("value");
                                    String openAiEntityVal = entitiesObject.optString("value");
                                    if (enabled.equalsIgnoreCase("Y")) {
                                        JSONObject currentEntityJson = new JSONObject();
                                        entityJsonVal = entitiesObject.optString("value");
                                        currentEntityJson.put("" + i, (Object)entityJsonVal);
                                        String queryString = "";
                                        String pineConeVectorURL = "";
                                        Map<String, Map<String, String>> pythonServicesMap = CommonConstants.EXTRACTION_PYTHON_SERVICES;
                                        APIUtility apiUtility = new APIUtility();
                                        String serverUrl = "";
                                        if (pythonServicesMap != null) {
                                            Map<String, String> proteusSenseServiceDetails = pythonServicesMap.get("DATA_EXTRACTOR");
                                            String protocol = proteusSenseServiceDetails.get("PROTOCOL");
                                            String host = proteusSenseServiceDetails.get("HOST");
                                            String port = E12GenericUtility.checkNull(proteusSenseServiceDetails.get("PORT"));
                                            String path = apiUtility.getAPIUrl(this.getUserInfo(), "VectorLookup");
                                            if (path.contains("WeaviateVector")) {
                                                serverUrl = apiUtility.getAPIUrl(this.getUserInfo(), "WeaviateVector");
                                            }
                                            pineConeVectorURL = String.format("%s://%s%s/%s", protocol, host, port, path);
                                        }
                                        ArrayList<String> openaiParams = apiUtility.getAPIKey(this.getUserInfo(), "OpenAI");
                                        ArrayList<String> pineConeAPIParams = apiUtility.getAPIKey(this.getUserInfo(), "PineCone");
                                        JSONObject configData = new JSONObject();
                                        String lookup = bisIntentEjb.isLookupMethod(entitiesTypeVal, this.getUserInfo());
                                        configData.put("index_name", (Object)"vision-masters");
                                        configData.put("pineCone_apiKey", (Object)pineConeAPIParams.get(0));
                                        configData.put("openAI_apiKey", (Object)openaiParams.get(0));
                                        configData.put("queryJson", (Object)currentEntityJson);
                                        configData.put("enterprise", (Object)this.getUserInfo().getEnterprise());
                                        configData.put("entity_type", (Object)entitiesTypeVal.toLowerCase());
                                        configData.put("server_url", (Object)serverUrl);
                                        configData.put("lookup_parameter", (Object)lookup);
                                        String pineConeConfig = configData.toString();
                                        ByteArrayInputStream postDataInputStream = null;
                                        StringBuffer queryParam = new StringBuffer();
                                        queryParam.append("jsonData=").append(pineConeConfig);
                                        queryString = queryParam.toString();
                                        if (queryString != null) {
                                            postDataInputStream = new ByteArrayInputStream(queryString.getBytes(StandardCharsets.UTF_8));
                                        }
                                        byte[] responseData = E12GenericUtility.makeRequest(pineConeVectorURL, postDataInputStream, 0, null, "application/json");
                                        e12GenericUtility.createAIApiLog(this.getUserInfo(), 1, "bis-assistant", "OpenAI");
                                        String resultStr = new String(responseData);
                                        JSONObject lookupEntityJson = new JSONObject();
                                        if (!"".equals(E12GenericUtility.checkNull(resultStr))) {
                                            String entityDescription = "";
                                            lookupEntityJson = new JSONObject(resultStr);
                                            if (lookupEntityJson.has("" + i)) {
                                                JSONObject lookupJson = new JSONObject();
                                                lookupJson = lookupEntityJson.getJSONObject("" + i);
                                                entityValue = lookupJson.getString("id");
                                                entityDescription = lookupJson.getString("material_description");
                                            }
                                            typeValJson.put("entity", (Object)entitiesTypeVal);
                                            typeValJson.put("value", (Object)entityValue);
                                            typeValJson.put("lookup_descr", (Object)entityDescription);
                                            if (!entityFromOpenAI.equals(entitiesTypeVal)) {
                                                typeValJson.put("open_ai_entity", (Object)entityFromOpenAI);
                                            }
                                            typeValJson.put("open_ai_entity_value", (Object)openAiEntityVal);
                                            entitiesArray.put((Object)typeValJson);
                                            BaseLogger.log("2", null, null, "entitiesArray line no 266::::::: " + entitiesArray);
                                        }
                                    } else {
                                        typeValJson.put("entity", (Object)entitiesTypeVal);
                                        typeValJson.put("value", (Object)entityValue);
                                        if (!entityFromOpenAI.equals(entitiesTypeVal)) {
                                            typeValJson.put("open_ai_entity", (Object)entityFromOpenAI);
                                        }
                                        typeValJson.put("open_ai_entity_value", (Object)openAiEntityVal);
                                        entitiesArray.put((Object)typeValJson);
                                    }
                                }
                            } else if (entitiesTypeVal.equalsIgnoreCase("date_range") || entitiesTypeVal.equalsIgnoreCase("duration")) {
                                JSONObject dateValJson;
                                String dateRangeVal;
                                String key;
                                Iterator iterator;
                                JSONObject dateRangeJson = new JSONObject();
                                if (entitiesObject.has("value")) {
                                    dateRangeJson = entitiesObject.getJSONObject("value");
                                    iterator = dateRangeJson.keys();
                                    while (iterator.hasNext()) {
                                        key = null;
                                        dateRangeVal = "";
                                        key = (String)iterator.next();
                                        dateRangeVal = dateRangeJson.getString(key);
                                        dateValJson = new JSONObject();
                                        dateValJson.put("entity", (Object)key);
                                        dateValJson.put("value", (Object)dateRangeVal);
                                        entitiesArray.put((Object)dateValJson);
                                    }
                                } else {
                                    iterator = entitiesObject.keys();
                                    while (iterator.hasNext()) {
                                        key = null;
                                        dateRangeVal = "";
                                        key = (String)iterator.next();
                                        if ("type".equalsIgnoreCase(key)) continue;
                                        dateRangeVal = dateRangeJson.getString(key);
                                        dateValJson = new JSONObject();
                                        dateValJson.put("entity", (Object)key);
                                        dateValJson.put("value", (Object)dateRangeVal);
                                        entitiesArray.put((Object)dateValJson);
                                    }
                                }
                            } else {
                                typeValJson.put("entity", (Object)entitiesTypeVal);
                                String entityVal = "";
                                if (entitiesObject.has("value")) {
                                    entityVal = entitiesObject.optString("value");
                                }
                                typeValJson.put("value", (Object)entityVal);
                                entitiesArray.put((Object)typeValJson);
                            }
                        }
                        ++i;
                    }
                    response.put("intent", intentArr.get(0));
                    response.put("pinecone_intent_id", (Object)intentVal);
                    response.put("intent_descr", (Object)intentDescription);
                    response.put("entities", (Object)entitiesArray);
                    long startTime = System.currentTimeMillis();
                    JSONObject nlpDetailJson = new JSONObject();
                    nlpDetailJson.put("NLP_AGENT", (Object)"OpenAI");
                    nlpDetailJson.put("NLP_TYPE", (Object)"processIntent");
                    nlpDetailJson.put("NLP_REQ", (Object)"/proteusservices/InvokeIntent/getInvokeIntent");
                    nlpDetailJson.put("NLP_REQ_TIME", startTime);
                    nlpDetailJson.put("NLP_RESP_TIME", System.currentTimeMillis());
                    nlpDetailJson.put("NLP_RESPONSE", (Object)invokeRes);
                    response.put("nlp_details", (Object)nlpDetailJson);
                    response.put("intent_ranking", (Object)intentArr);
                    responseStr = response.toString();
                    BaseLogger.log("2", null, null, "responseStr line no 324::::::: " + responseStr);
                    break block38;
                }
                return invokeRes;
            }
            catch (Exception e) {
                BaseLogger.log("3", this.getUserInfo(), null, "Exception inside processIntent:::::" + e.getMessage());
                ITMException i = new ITMException("JSON", e);
                responseStr = i.getMessage();
                BaseLogger.log("3", this.getUserInfo(), null, "Exception inside processIntent responseStr:::::" + responseStr);
            }
        }
        return responseStr;
    }

    public String invokeIntent(UserInfoBean userInfo, String intentInput) throws RemoteException, Exception {
        String resultStr = "";
        try {
            E12GenericUtility e12GenericUtility = new E12GenericUtility();
            String externalDBServiceUrl = "";
            Map<String, Map<String, String>> pythonServicesMap = CommonConstants.PYTHON_SERVICES;
            Map<String, String> proteusSenseServiceDetails = pythonServicesMap.get("SQL_EXECUTION");
            String protocol = proteusSenseServiceDetails.get("PROTOCOL");
            String host = proteusSenseServiceDetails.get("HOST");
            String port = E12GenericUtility.checkNull(proteusSenseServiceDetails.get("PORT"));
            String path = "/proteusservices/InvokeIntent/getInvokeIntent";
            String queryParamStr = null;
            ByteArrayInputStream postDataInputStream = null;
            APIUtility apiUtility = new APIUtility();
            ArrayList<String> openaiParams = apiUtility.getAPIKey(userInfo, "OpenAI");
            JSONObject headerDetailObj = new JSONObject();
            Field arg = headerDetailObj.getClass().getDeclaredField("map");
            arg.setAccessible(true);
            arg.set(headerDetailObj, new LinkedHashMap());
            arg.setAccessible(false);
            headerDetailObj.put("intent_input", (Object)intentInput);
            headerDetailObj.put("enterprise", (Object)this.getUserInfo().getEnterprise());
            headerDetailObj.put("openAI_APIKey", (Object)openaiParams.get(0));
            StringBuffer queryParam = new StringBuffer();
            queryParam.append("jsonData=").append(headerDetailObj);
            queryParamStr = queryParam.toString();
            BaseLogger.log("3", userInfo, null, "inside invokeIntent print queryParamStr line no 325::::" + queryParamStr);
            if (queryParamStr != null) {
                postDataInputStream = new ByteArrayInputStream(queryParamStr.getBytes(StandardCharsets.UTF_8));
            }
            externalDBServiceUrl = String.format("%s://%s%s/%s", protocol, host, port, path);
            byte[] responseData = E12GenericUtility.makeRequest(externalDBServiceUrl, postDataInputStream, 0, null, "application/json");
            BaseLogger.log("3", userInfo, null, "inside invokeIntent print responseData line no 359::::" + responseData);
            e12GenericUtility.createAIApiLog(userInfo, 1, "bis-assistant", "OpenAI");
            resultStr = new String(responseData);
            BaseLogger.log("3", userInfo, null, "inside invokeIntent print resultStr line no 299::::" + resultStr);
        }
        catch (Exception e) {
            BaseLogger.log("3", this.getUserInfo(), null, "Exception inside processIntent:::::" + e.getMessage());
            throw new ITMException(e);
        }
        return resultStr;
    }
}

