/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import ibase.utility.ApplicationParams;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApplicationMetadata {
    static HashMap APP_PARAMS_LIST = new HashMap();
    static String filePath = "";
    ApplicationParams applicationparams = null;

    static {
        try {
            ApplicationMetadata.loadAppParams();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList getSchedulableActivities() throws BaseException {
        ArrayList<ApplicationParams> schedulableApplnList = new ArrayList<ApplicationParams>();
        try {
            int noOfApplns = 0;
            if (APP_PARAMS_LIST != null) {
                noOfApplns = APP_PARAMS_LIST.size();
            }
            Set keySetOfCtxParm = APP_PARAMS_LIST.keySet();
            Iterator keySetItr = keySetOfCtxParm.iterator();
            int ctxParamCtr = 0;
            while (ctxParamCtr < APP_PARAMS_LIST.size()) {
                String keyname = (String)keySetItr.next();
                ApplicationParams appParam = (ApplicationParams)APP_PARAMS_LIST.get(keyname);
                if (appParam.isSchedulable().equals("1")) {
                    schedulableApplnList.add(appParam);
                }
                ++ctxParamCtr;
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return schedulableApplnList;
    }

    private static boolean loadAppParams() throws BaseException {
        BaseLogger.log("3", null, null, "Inside loadAppParams() Method..");
        try {
            if (CommonConstants.APPLICATION_CONTEXT != null) {
                System.out.println("Inside ApplicationMetadata: if part:");
                filePath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "BaseApplications.xml";
            } else {
                System.out.println("Inside ApplicationMetadata: else part:");
                filePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + "setting" + File.separator + "BaseApplications.xml";
            }
            Document allApplicationDom = new E12GenericUtility().parseFile(filePath);
            NodeList allApplicationList = allApplicationDom.getElementsByTagName("Application");
            int noOfApplication = allApplicationList.getLength();
            int appCtr = 0;
            while (appCtr < noOfApplication) {
                ApplicationParams appParams = new ApplicationParams();
                Node currAppNode = allApplicationList.item(appCtr);
                appParams = ApplicationMetadata.buildAppParamsModel(currAppNode, appParams);
                BaseLogger.log("3", null, null, "---------------AppParams2019" + appParams.toString());
                if (!APP_PARAMS_LIST.containsKey(appParams.getApplnName())) {
                    BaseLogger.log("3", null, null, "Inside loadAppParams() if Block:" + appParams.toString());
                    APP_PARAMS_LIST.put(appParams.getApplnName(), appParams);
                }
                ++appCtr;
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return true;
    }

    private static ApplicationParams buildAppParamsModel(Node appNode, ApplicationParams appParams) throws Exception {
        block26: {
            BaseLogger.log("3", null, null, "Inside buildAppParamsModel::" + appParams.toString());
            String paramId = "";
            String paramDataType = "";
            int paramIndex = 0;
            String paramMode = "";
            String paramValue = "";
            if (appNode == null) break block26;
            NamedNodeMap applnAttribMap = appNode.getAttributes();
            BaseLogger.log("3", null, null, "Inside buildAppParamsModel(): if Block: applnAttribMap[" + applnAttribMap + "]" + " " + appNode.toString());
            appParams.setApplnName(applnAttribMap.getNamedItem("Name").getNodeValue());
            NodeList applnDetailList = appNode.getChildNodes();
            int cnt = 0;
            while (cnt < applnDetailList.getLength()) {
                Node applnDetailNode = applnDetailList.item(cnt);
                if (applnDetailNode.getNodeType() == 1) {
                    if (applnDetailNode.getNodeName().equals("FormalParameters")) {
                        NodeList formalPramsList = applnDetailNode.getChildNodes();
                        int formalCnt = 0;
                        while (formalCnt < formalPramsList.getLength()) {
                            Node formalParamNode = formalPramsList.item(formalCnt);
                            if (formalParamNode.getNodeType() == 1 && formalParamNode.getNodeName().equals("FormalParameter")) {
                                NamedNodeMap formalParamNodeMap = formalParamNode.getAttributes();
                                paramId = formalParamNodeMap.getNamedItem("Id").getNodeValue();
                                paramIndex = Integer.parseInt(formalParamNodeMap.getNamedItem("Index").getNodeValue());
                                paramMode = formalParamNodeMap.getNamedItem("Mode").getNodeValue();
                                if (formalParamNodeMap.getNamedItem("Name") != null) {
                                    paramValue = formalParamNodeMap.getNamedItem("Name").getNodeValue();
                                }
                                BaseLogger.log("3", null, null, "------------------------");
                                String paramType = "";
                                if (formalParamNodeMap.getNamedItem("Type") != null) {
                                    paramType = formalParamNodeMap.getNamedItem("Type").getNodeValue();
                                }
                                NodeList formalParDetList = formalParamNode.getChildNodes();
                                int formalCnt1 = 0;
                                while (formalCnt1 < formalParDetList.getLength()) {
                                    Node formalDetNode = formalParDetList.item(formalCnt1);
                                    if (formalDetNode.getNodeType() == 1 && formalDetNode.getNodeName().equals("DataType")) {
                                        NodeList formalDataTypeList = formalDetNode.getChildNodes();
                                        int formalCnt2 = 0;
                                        while (formalCnt2 < formalDataTypeList.getLength()) {
                                            Node formalDataTypeNode = formalDataTypeList.item(formalCnt2);
                                            if (formalDataTypeNode.getNodeType() == 1 && formalDataTypeNode.getNodeName().equals("BasicType")) {
                                                paramDataType = formalDataTypeNode.getAttributes().getNamedItem("Type").getNodeValue();
                                            }
                                            ++formalCnt2;
                                        }
                                    }
                                    ++formalCnt1;
                                }
                                appParams.addParam(paramId, paramDataType, paramIndex, paramMode, paramValue, paramType);
                            }
                            ++formalCnt;
                        }
                    } else if (applnDetailNode.getNodeName().equals("ExtendedAttributes")) {
                        NodeList extentedAttribList = applnDetailNode.getChildNodes();
                        int extCnt = 0;
                        while (extCnt < extentedAttribList.getLength()) {
                            Node extAttribNode = extentedAttribList.item(extCnt);
                            if (extAttribNode != null && extAttribNode.getNodeType() == 1) {
                                String extAttribName = extAttribNode.getAttributes().getNamedItem("Name").getNodeValue();
                                if ("INPUT_EDITOR".equalsIgnoreCase(extAttribName)) {
                                    String url = extAttribNode.getAttributes().getNamedItem("Value").getNodeValue();
                                    url = ApplicationMetadata.replacewithAmp(url);
                                    appParams.setInputEditor(url);
                                    appParams.addExtenedParam(extAttribName, url);
                                } else {
                                    appParams.addExtenedParam(extAttribName, extAttribNode.getAttributes().getNamedItem("Value").getNodeValue());
                                }
                                if ("SCHEDULABLE".equalsIgnoreCase(extAttribName)) {
                                    appParams.setSchedulable(extAttribNode.getAttributes().getNamedItem("Value").getNodeValue());
                                } else if ("APPLN_TYPE".equalsIgnoreCase(extAttribName)) {
                                    appParams.setApplnType(extAttribNode.getAttributes().getNamedItem("Value").getNodeValue());
                                } else if ("METHOD_NAME".equalsIgnoreCase(extAttribName)) {
                                    appParams.setMethodName(extAttribNode.getAttributes().getNamedItem("Value").getNodeValue());
                                } else if ("COMP_NAME".equalsIgnoreCase(extAttribName)) {
                                    appParams.setCompName(extAttribNode.getAttributes().getNamedItem("Value").getNodeValue());
                                }
                            }
                            ++extCnt;
                        }
                    }
                }
                ++cnt;
            }
        }
        return appParams;
    }

    public ApplicationParams getAppParamsModel(String activityId) throws BaseException, Exception {
        ApplicationParams appParams = null;
        try {
            if (APP_PARAMS_LIST.get(activityId) != null) {
                appParams = (ApplicationParams)APP_PARAMS_LIST.get(activityId);
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return (ApplicationParams)appParams.clone();
    }

    private static String replacewithAmp(String url) throws Exception {
        String urlStr = url;
        while (urlStr.indexOf(59) != -1) {
            BaseLogger.log("3", null, null, "ReplacewithAmp");
            StringBuffer urlBuff = new StringBuffer(urlStr);
            int index = urlBuff.toString().indexOf(59);
            urlBuff.replace(index, index + 1, "&");
            urlStr = urlBuff.toString();
            Object var2_2 = null;
        }
        return urlStr;
    }

    public ApplicationParams getAppParamsModelFromClass(String className) throws BaseException, Exception {
        try {
            Set keySetOfCtxParm = APP_PARAMS_LIST.keySet();
            Iterator keySetItr = keySetOfCtxParm.iterator();
            int paramCtr = 0;
            while (paramCtr < APP_PARAMS_LIST.size()) {
                String keyname = (String)keySetItr.next();
                ApplicationParams appParams = (ApplicationParams)APP_PARAMS_LIST.get(keyname);
                if (appParams.getCompName().equals(className) && appParams.isSchedulable().equals("1")) {
                    return appParams;
                }
                ++paramCtr;
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return null;
    }
}

