package ibase.webitm.ejb.wsfa.transactions;

import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.utility.*;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.system.config.*;
import ibase.scheduler.utility.interfaces.Schedule;
import ibase.utility.CommonConstants;
import java.sql.*;
import java.util.*;
import java.text.*;

public class AutoDCREntrySchedule implements Schedule
{
	public String schedule(HashMap map) throws Exception
    {
	 	System.out.println(schedule((String) map.get("PROCESS_NAME")));
	 	return schedule((String) map.get("PROCESS_NAME"));
    }

    public String schedule(String schedule) throws Exception
    {
    	System.out.println("^^^^^^^ INSERTING INTO AutoEntryDCRSchedule ^^^^^^^");
    	this.generateDCR();
    	return schedule;
    }

    public String schedulePriority(String arg0) throws Exception
    {
    	return null;
    }
	private void generateDCR() throws ITMException
    {
		boolean isError = false;
		Connection conn = null;
		
		try
        {
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			conn.setAutoCommit(false);

			//changed by Rahul Barve on 3-sep-2014
			//GenericUtility genericUtility = GenericUtility.getInstance();
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			String currDate = sdf.format(new java.util.Date());
			
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			
			//String currDateTest = "01/09/12";
			
			Calendar calObj1 = Calendar.getInstance();
			calObj1.setTime(new java.util.Date());
			//calObj1.setTime(sdf.parse(currDateTest));
			calObj1.add(calObj1.MONTH, -1);
			calObj1.set(calObj1.DATE, 1);
			
			java.util.Date dateFrom = calObj1.getTime();
			
			System.out.println("dateFrom =["+dateFrom+"]");
			
			String dateFromStr = sdf.format(dateFrom);
			
			System.out.println("dateFromStr =["+dateFromStr+"]");
			
			int daysInMonth = calObj1.getActualMaximum(calObj1.DAY_OF_MONTH); 
			
			System.out.println("daysInMonth =["+daysInMonth+"]");
			
			
			//check in sprs_act_Tran table
			String checkDCREntry = "SELECT COUNT(1) AS COUNT FROM SPRS_ACT_TRAN WHERE EVENT_DATE = ? AND SALES_PERS = ? ";
			PreparedStatement pstmtCheckDCREntry = conn.prepareStatement(checkDCREntry);
			
			//check in sprs_act_Tran table
			
			//Inserting into sprs_act_tran table   
			String insertSprsActTranSql = "INSERT INTO SPRS_ACT_TRAN(TRAN_ID, EVENT_DATE, ACTIVITY_CODE, SALES_PERS, SPRS_CODE__WW, CHG_DATE, CHG_USER, CHG_TERM, DCR_ID) "+
										"VALUES(?,?,?,?,?,?,?,?,?)";
			
			PreparedStatement pstmtInsertSprsActTran = conn.prepareStatement(insertSprsActTranSql);
			//Inserting into sprs_act_tran table
			
			//Get the OTC sales person
			String getOTCSalesPers = "SELECT SP.SALES_PERS FROM SALES_PERS SP,EMPLOYEE EM "+
					                 " WHERE SP.SALES_PERS = EM.EMP_CODE AND EM.DEPT_CODE = 'SLS' "+
                                     " AND EM.OTHER_INFO is not null AND SP.ITEM_SER = 'OTC'";               

			PreparedStatement pstmtOTCSalesPers = conn.prepareStatement(getOTCSalesPers);              
			ResultSet rsOTCSalesPers = pstmtOTCSalesPers.executeQuery();                         
			   
			while(rsOTCSalesPers.next())
			{
				String otcSalesPers = rsOTCSalesPers.getString("SALES_PERS");
				
				System.out.println("otcSalesPers =["+otcSalesPers+"]");
				
				ArrayList holidayList = getHolidayList(conn, dateFromStr, daysInMonth, otcSalesPers );
				
				System.out.println("holidayList =["+holidayList+"]");
				
				Calendar calObj2 = Calendar.getInstance();
				calObj2.setTime(dateFrom);
				//no of days in month
				for (int days = 1; days <= daysInMonth; days++)
				{
					String eventDateStr = "";
					if( days == 1 )
					{
						eventDateStr = sdf.format(dateFrom);
					}
					else
					{
						calObj2.add(calObj2.DATE, 1);
						java.util.Date eventDate = calObj2.getTime();
						eventDateStr = sdf.format(eventDate);
					}
					
					System.out.println("eventDateStr =["+eventDateStr+"]");
					
					pstmtCheckDCREntry.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
					pstmtCheckDCREntry.setString(2,otcSalesPers);
					
					int checkCount = 0;
					ResultSet rsCheckDCREntry = pstmtCheckDCREntry.executeQuery();
					if(rsCheckDCREntry.next())
					{
						checkCount = rsCheckDCREntry.getInt("COUNT");
					}
					rsCheckDCREntry.close(); rsCheckDCREntry = null;
					pstmtCheckDCREntry.clearParameters();
					
					System.out.println("checkCount =["+checkCount+"]");
					
					if ( checkCount > 0 )
					{
						continue;
					}
					
					//Checking for holiday
					boolean isEventDateHoliday = isHoliday(conn, eventDateStr, otcSalesPers );
					
					System.out.println("isEventDateHoliday =["+isEventDateHoliday+"]");
					
					if (isEventDateHoliday)
					{
						continue;
					}
					//End checking holiday
					
					//Inserting into sprs_act_tran table - START
					String dcrID = generateDCRId(conn);
					pstmtInsertSprsActTran.setString(1, dcrID);
					pstmtInsertSprsActTran.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
					pstmtInsertSprsActTran.setString(3, "NR");
					pstmtInsertSprsActTran.setString(4, otcSalesPers);
					pstmtInsertSprsActTran.setString(5, "");
					pstmtInsertSprsActTran.setTimestamp(6, java.sql.Timestamp.valueOf(currDate));
					pstmtInsertSprsActTran.setString(7, "SYSTEM");
					pstmtInsertSprsActTran.setString(8, "SYSTEM");
					pstmtInsertSprsActTran.setString(9, dcrID);
					int insertSprsActTranCnt = pstmtInsertSprsActTran.executeUpdate();
					
					System.out.println("insertSprsActTranCnt =["+insertSprsActTranCnt+"]");
					
					if(insertSprsActTranCnt > 0)
					{
						System.out.println("Inserted successfully into sprs_act_tran table =["+insertSprsActTranCnt+"]");
					}
					//Inserting into sprs_act_tran table - END
					
					//Inserting into sprs_travel table - START
					
					boolean isSuccess = insertIntoSprsTravel( conn, otcSalesPers, eventDateStr, dcrID );
					if(isSuccess)
					{
						conn.commit();
					}
					else
					{
						conn.rollback();
					}
					

					//Inserting into sprs_travel table - END
				}
			}
			// added by rakesh kumar 24/12/12  
			if ( rsOTCSalesPers != null )
			{
				rsOTCSalesPers.close();
				rsOTCSalesPers = null;
			}
			if(pstmtOTCSalesPers != null )
			{
				pstmtOTCSalesPers.close();
				pstmtOTCSalesPers = null;
			}
			if(pstmtInsertSprsActTran != null )
			{
				pstmtInsertSprsActTran.close();
				pstmtInsertSprsActTran = null;
			}
			if(pstmtCheckDCREntry != null )
			{
				pstmtCheckDCREntry.close();
				pstmtCheckDCREntry = null;
			}
			// ended by rakesh kumar 24/12/12
        }
		catch (Exception e)
		{
			isError = true;
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null && !conn.isClosed())
				{
					if ( !isError )
					{
						conn.commit();
					}
					else
					{
						conn.rollback();
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e){}
		}
    }
	private boolean insertIntoSprsTravel( Connection conn, String salesPers, String dcrDate, String dcrID ) throws ITMException
	{
		boolean isSuccess = false;
		try
		{
			System.out.println("insertIntoSprsTravel is called...........");
			//changed by Rahul Barve on 3-sep-2014
			//GenericUtility genericUtility = GenericUtility.getInstance();
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			//Inserting into sprs_travel table
			String insertSprsTravelSql = "INSERT INTO SPRS_TRAVEL(TRAN_ID, SALES_PERS, TRAVEL_DATE, LOCALITY_CODE, STAN_CODE, STAN_CODE__FROM, TRAVEL_MODE," +
					" OVER_NIGHT, ACTIVITY_CODE, CHG_DATE, CHG_USER, CHG_TERM, OTH_PARTICIPANT, SPRS_CODE__WW, ORDER_OF_VISIT, DCR_ID, LINE_NO) "+
										"VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			
			PreparedStatement pstmtInsertSprsTravel = conn.prepareStatement(insertSprsTravelSql);
			
			java.util.Calendar calendar = java.util.Calendar.getInstance();
			
			System.out.println("dcrDate =["+dcrDate+"]");
			
			calendar.setTime( sdf.parse(dcrDate) );
			
			while(true)
			{
				calendar.add(calendar.DATE, -1);
				String travelDate = sdf.format(calendar.getTime());
				String newDCRDate = travelDate;
				System.out.println("newDCRDate =["+newDCRDate+"]");
				
				calendar.setTime(sdf.parse(newDCRDate));
				
				//Checking for holiday
				boolean isHoliday = isHoliday(conn, travelDate, salesPers );
				System.out.println("isHoliday =["+isHoliday+"]");
				
				if (isHoliday)
				{
					continue;
				}
				//End checking holiday
				int lineNo = 0;
				String getSprsTravelDataSql = "SELECT * FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE = ?";
				PreparedStatement pstmtSprsTravel = conn.prepareStatement(getSprsTravelDataSql);
				pstmtSprsTravel.setString(1, salesPers);
				pstmtSprsTravel.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( newDCRDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
				
				ResultSet rsGetSprsTravel = pstmtSprsTravel.executeQuery();
				while(rsGetSprsTravel.next())
				{
					lineNo++;
					pstmtInsertSprsTravel.setString(1, "");
					pstmtInsertSprsTravel.setString(2, salesPers);
					pstmtInsertSprsTravel.setTimestamp(3, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
					pstmtInsertSprsTravel.setString(4, (rsGetSprsTravel.getString("LOCALITY_CODE") == null) ? "" : rsGetSprsTravel.getString("LOCALITY_CODE").trim());
					pstmtInsertSprsTravel.setString(5, (rsGetSprsTravel.getString("STAN_CODE") == null) ? "" : rsGetSprsTravel.getString("STAN_CODE").trim());
					pstmtInsertSprsTravel.setString(6, (rsGetSprsTravel.getString("STAN_CODE__FROM") == null) ? "" : rsGetSprsTravel.getString("STAN_CODE__FROM").trim());
					pstmtInsertSprsTravel.setString(7, (rsGetSprsTravel.getString("TRAVEL_MODE") == null) ? "" : rsGetSprsTravel.getString("TRAVEL_MODE").trim());
					pstmtInsertSprsTravel.setString(8, (rsGetSprsTravel.getString("OVER_NIGHT") == null) ? "" : rsGetSprsTravel.getString("OVER_NIGHT").trim());
					pstmtInsertSprsTravel.setString(9, "NR");
					pstmtInsertSprsTravel.setTimestamp(10, java.sql.Timestamp.valueOf(currDate));
					pstmtInsertSprsTravel.setString(11, "SYSTEM");
					pstmtInsertSprsTravel.setString(12, "SYSTEM");
					pstmtInsertSprsTravel.setString(13, (rsGetSprsTravel.getString("OTH_PARTICIPANT") == null) ? "" : rsGetSprsTravel.getString("OTH_PARTICIPANT").trim());
					pstmtInsertSprsTravel.setString(14, (rsGetSprsTravel.getString("SPRS_CODE__WW") == null) ? "" : rsGetSprsTravel.getString("SPRS_CODE__WW").trim());
					pstmtInsertSprsTravel.setString(15, (rsGetSprsTravel.getString("ORDER_OF_VISIT") == null) ? "" : rsGetSprsTravel.getString("ORDER_OF_VISIT").trim());
					pstmtInsertSprsTravel.setString(16, dcrID);
					pstmtInsertSprsTravel.setInt(17, lineNo);
					
					int insertSprsTravelCnt = pstmtInsertSprsTravel.executeUpdate();
					System.out.println("insertSprsTravelCnt =["+insertSprsTravelCnt+"]");
					
					pstmtInsertSprsTravel.clearParameters();
					if (insertSprsTravelCnt > 0)
					{
						isSuccess = true;
						System.out.println("inserted successfully into sprs travel =["+insertSprsTravelCnt+"]");
					}
				}
				rsGetSprsTravel.close(); rsGetSprsTravel = null;
				pstmtSprsTravel.close(); pstmtSprsTravel = null;
				if(pstmtInsertSprsTravel != null)
				{
					pstmtInsertSprsTravel.close(); pstmtInsertSprsTravel = null;
				}
				break;
			}
						
		}
		catch(Exception exp)
		{
			System.out.println("Exception : insertIntoSprsTravel :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}
	
	private String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input;
	}

	private String checkNullAndTrim(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	
	private String generateDCRId( Connection conn ) throws ITMException
	{
		String uniqueKey = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{

			System.out.println("StrgSerStatusHistBean : Generating Primary Key ...........");
						
			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_strg_meet_itm_wiz' ";
			pstmt = conn.prepareStatement(keyStringQuery);
			rs = pstmt.executeQuery();			
			
			if(rs.next())
			{
				String keyString = rs.getString("KEY_STRING");
				String keyCol = rs.getString("TRAN_ID_COL");
				String tranSer = rs.getString("REF_SER");
				String xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
				xmlValues = xmlValues + "<Header></Header>";
				xmlValues = xmlValues + "<Detail1>";
				xmlValues = xmlValues +        "<dcr_id></dcr_id>";
				xmlValues = xmlValues + "</Detail1></Root>";
				TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
				uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			}
			rs.close();	rs = null;
			pstmt.close();
			pstmt = null;

		}
		catch(Exception exp)
		{
			System.out.println("Exception : StrgSerStatusHistBean :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : StrgSerStatusHistBean :getUniqueKey :finally==>");
				throw new ITMException(e);
			}
		}
		System.out.println("Generated Primary Key :"+uniqueKey);
		return uniqueKey; 
	}
	private boolean isHoliday(Connection conn, String eventDate, String salesPers ) throws ITMException
	{
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		
		String checkSQL = "";
		
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		
		//ArrayList holidayList = new ArrayList();
		boolean isEventDateHoliday = false;

		try
		{
			eventDate = genericUtility.getValidDateString( eventDate , genericUtility.getApplDateFormat() , "dd-MMM-yyyy");
			checkSQL = "SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
			pstmt = conn.prepareStatement(checkSQL);
			pstmt.setString(1,checkNull(eventDate));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				String code = rs.getString( "CODE" );
				
				checkSQL = "SELECT DDF_GET_EMP_HOLIDAY(?,?,?,?) HOLDATE FROM DUAL ";
				System.out.println("sql [" + checkSQL + "] ");

				pstmt = conn.prepareStatement(checkSQL);
				pstmt.setString(1,checkNull(salesPers));
				pstmt.setString(2,checkNull(code));
				pstmt.setString(3,checkNull(code));
				pstmt.setString(4,checkNull(eventDate));
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					String holDate = rs.getString( 1 ); 
					System.out.println(" holDate [" + holDate + "] ");
					if ( holDate != null && holDate.trim().length() > 0 )
					{
						isEventDateHoliday = true;
					}											                                   
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}				
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("isEventDateHoliday in isHoliday() =["+isEventDateHoliday+"]");
		return isEventDateHoliday;
	}
	private ArrayList getHolidayList(Connection conn, String dateFromStr, int daysInMonth, String salesPers ) throws ITMException
	{
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		
		String checkSQL = "";
		
		PreparedStatement pstmtHolday = null;
		ResultSet rs = null ;
		
		ArrayList holidayList = new ArrayList();

		try
		{
			String periodCode = "";
			String dateFrom = genericUtility.getValidDateString( dateFromStr , genericUtility.getApplDateFormat() , "dd-MMM-yyyy");
			checkSQL = "SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
			PreparedStatement pstmtPeriod = conn.prepareStatement(checkSQL);
			pstmtPeriod.setString(1,checkNull(dateFrom));
			ResultSet rsPeriod = pstmtPeriod.executeQuery();
			if(rsPeriod.next())
			{
				periodCode = rsPeriod.getString( "CODE" );
			}
			System.out.println(" periodCode [" + periodCode + "] ");
			
			checkSQL = "SELECT DDF_GET_EMP_HOLIDAY(?,?,?,?) HOL_DATE FROM DUAL ";
			pstmtHolday = conn.prepareStatement(checkSQL);
			
			java.util.Calendar calendar = java.util.Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat( genericUtility.getApplDateFormat() );
			
			calendar.setTime( sdf.parse(dateFromStr) );
			
			for ( int count = 1; count <= daysInMonth; count++ )
			{
				String currEventDate = sdf.format( calendar.getTime() );
				
				System.out.println(" currEventDate [" + currEventDate + "] ");
				
				calendar.add(calendar.DATE, 1);

				currEventDate = genericUtility.getValidDateTimeString(currEventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());

				pstmtHolday.setString( 1, salesPers );
				pstmtHolday.setString( 2, periodCode );
				pstmtHolday.setString( 3, periodCode );
				pstmtHolday.setTimestamp( 4, java.sql.Timestamp.valueOf(currEventDate) );
	
				ResultSet rsHolday = pstmtHolday.executeQuery();
	
				if( rsHolday.next() )
				{
					String holidayDate = checkNull( rsHolday.getString("HOL_DATE") );
					if( holidayDate.trim().length() > 0 )
					{
						holidayList.add( genericUtility.getValidDateString(holidayDate, "dd-MMM-yyyy", genericUtility.getApplDateFormat()).toUpperCase() ) ;
					}					
				}
				pstmtHolday.clearParameters();
				rsHolday.close(); rsHolday = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmtHolday!=null)
				{
					pstmtHolday.close();
					pstmtHolday = null;
				}				
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}	
		return holidayList;
	}
	
}
