package ibase.webitm.bean.wsfa;

import ibase.utility.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import javax.servlet.http.*;
import java.rmi.RemoteException;
import java.io.*;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import ibase.ejb.CommonDBAccessEJB;

import javax.naming.InitialContext;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.wsfa.transactions.CallReportStatusEJB;
import ibase.webitm.ejb.wsfa.transactions.SalePersCmeWizardEJB;
import ibase.webitm.ejb.wsfa.transactions.SalesPersCmeWIzardRemote;
import ibase.webitm.ejb.wsfa.transactions.StrgCustDeactive;
import ibase.webitm.ejb.wsfa.transactions.StrgCustDeactiveRemote;
import ibase.webitm.ejb.wsfa.transactions.StrgMeetDCRWizard;
import ibase.webitm.ejb.wsfa.transactions.StrgMeetWizardEJB;
import ibase.webitm.ejb.wsfa.transactions.StrgMeetWizardRemote;
import ibase.webitm.ejb.wsfa.transactions.WsfaZuviusDsrWizardEJB;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.ValidatorEJB;
//import ibase.webitm.utility.GenericUtility;//changed by rahul 10-apr-2015
import ibase.webitm.utility.ITMException;     

import java.net.InetAddress;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;
import java.util.TreeMap;


import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Text;


public class StrgMeetWizardBean 
{

	private UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private String objName = "";
	private String user_lang ="en"; 
	private String user_country = "US";
	private UserInfoBean userInfoBean = null;
	static int num = 1;
		
	public StrgMeetWizardBean( String objName, HttpSession sessionCtx ) throws ITMException
	{
		try
		{
			this.objName = objName;
			this.sessionCtx = sessionCtx;
			this.userInfo = ( ibase.utility.UserInfoBean ) this.sessionCtx.getAttribute("USER_INFO");
			
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}

	public StrgMeetWizardBean() throws ITMException
	{
	}
	
	//Added bys sachin satre on [14-nov-16] start
	public UserInfoBean getUserInfo()
	{
		return this.userInfo;
	}
	public void setUserInfo(UserInfoBean userInfo) 
	{
		System.out.println("getUserInfo"+userInfo);
		this.userInfo = userInfo;
		System.out.println("getUserInfo"+userInfo);
	}
	//Added bys sachin satre on [14-nov-16] end
	
	//Added by Gaurav Singh on 20-APR-2015 for displaying item and team data [Start]
	public String getSalesPersTeamList( String salesPers, String strgCode, String selectedTeam ) throws ITMException
	{
		String teamData = "";
		//ITMWizardStatefulRemote itmWizardRemoteTemp = null;
		try
		{
			//added by sachin satre on [14-nov-16] [start]
			Connection connectionObject = null; 
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]
			System.out.println("StrgMeetWizardBean : getSalesPersTeamListMitoch() ::");
			//InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			//itmWizardRemoteTemp = (ibase.webitm.ejb.ITMWizardStatefulRemote)ctx.lookup("ibase/ITMWizardStatefulEJB/remote");
			//teamData = itmWizardRemoteTemp.getSalesPersTeamList( salesPers, strgCode, selectedTeam );
			teamData = getSalesPersTeamListZuvius( salesPers, strgCode, selectedTeam,connectionObject );//Chnaged by sachin satre on 14-nov-16
			//itmWizardRemoteTemp.remove();
			//itmWizardRemoteTemp = null;

			String xslFileName = getXSLFileName( "strg_meet_team_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			teamData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, teamData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			/*if ( itmWizardRemoteTemp != null )
			{
				itmWizardRemoteTemp.remove();
				itmWizardRemoteTemp = null;
			}*/
		}
		return teamData;
	}
	
	public String getSalesPersTeamListZuvius(String salesPers, String strgCode,String selectedTeam,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 14-nov-16
	{
		String sql = "";
		String[] team = new String[25];
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ResultSet rset = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
        String transDB = null;
		try
		{
			//commented by sachin satre on 14-nov-16 start
			/*ConnDriver connDriver = new ConnDriver();
			if(this.userInfoBean!=null)
			{
				transDB = this.userInfoBean.getTransDB();
			}
			
			if(transDB!=null && (transDB.trim().length() >0 ))
			{
				connectionObject = connDriver.getConnectDB(transDB);
			}
			else
			{
				connectionObject = connDriver.getConnectDB("DriverITM");
			}*/
			//commented by sachin satre on 14-nov-16 end
			
			
			selectedTeam = (selectedTeam != null) ? selectedTeam.trim() : selectedTeam;
			team = selectedTeam.split(",");
			System.out.println("Team selected [" + Arrays.asList(team)+ "] strgCode[" + strgCode + "]");
			sql = "SELECT SQL_STR FROM POPHELP WHERE FIELD_NAME='SALES_PERS' AND MOD_NAME='W_STRG_MEET'";
			pstmt = connectionObject.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int num = 1;
			if (rs.next()) 
			{
				sql = rs.getString("SQL_STR").trim().replace("'?'", "?");
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1, salesPers);
				rs = pstmt.executeQuery();
				while (rs.next()) 
				{
					String reportTo = rs.getString("REPORT_TO");
					String desgn = rs.getString("DESIGNATION");
					System.out.println("reportTo[" + reportTo + "] desgn ["	+ desgn + "]");
					reportTo = (reportTo != null) ? reportTo.trim() : reportTo;
					if (new ArrayList<String>(Arrays.asList(team)).contains(reportTo)) 
					{
						valueXmlString.append("<Detail6 domID='" + num	+ "' selected = 'Y'>\r\n");
					} 
					else 
					{
						valueXmlString.append("<Detail6 domID='" + num	+ "' selected = 'N'>\r\n");
					}

					valueXmlString.append("<sales_pers><![CDATA[").append(reportTo).append("]]></sales_pers>\r\n");
					valueXmlString.append("<name><![CDATA[").append(rs.getString("NAME")).append("]]></name>\r\n");
					valueXmlString.append("<designation><![CDATA[").append(rs.getString("DESIGNATION")).append(	"]]></designation>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
					valueXmlString.append("<role_code><![CDATA[]]></role_code>\r\n");

					sql = "SELECT DESIGN_CODE FROM EMPLOYEE WHERE EMP_CODE = ?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1, reportTo);
					rset = pstmt.executeQuery();
					if (rset.next()) 
					{
						String desgnCode = rset.getString("DESIGN_CODE") != null ? rset.getString("DESIGN_CODE").trim(): "";
						valueXmlString.append("<design_code><![CDATA[").append(desgnCode).append("]]></design_code>\r\n");
					}

					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append("</Detail6>\r\n");
					num++;
				}
			}

			rs.close();
			rs = null;

			rset.close();
			rset = null;

			pstmt.close();
			pstmt = null;

		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String):"+ e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		} 
		finally 
		{
			try 
			{
				/*if (connectionObject != null && !connectionObject.isClosed()) 
				{
					connectionObject.close();
					connectionObject = null;
				}*/
				if (rs != null) 
				{
					rs.close();
					rs = null;
				}

				if (rset != null) 
				{
					rset.close();
					rset = null;
				}

				if (pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString.toString()+ ":********");
		return valueXmlString.toString();

	}
	//Added by Poonam Gole on 15-OCT-2015 for adding items data into strg_meet_order.:Start[W15FZUV005]
	public String getOrderItemList( String sprsCode,String workDate, String strgCode,String strgType, String selectedOrder, String custName, String selStockistCode, String selStockistName ) throws ITMException
	{
		System.out.println("sprsCode=>"+sprsCode+"workDate=>"+workDate+"strgCode=>"+strgCode+"strgType=>"+strgType+"selectedItem=>"+selectedOrder); 
		//Form 4 defaultData()
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pStmt = null;
		PreparedStatement pStmt1 = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		String orderData="";
		int domId =1 ;
		String xslFileName ="";
		HashMap itemMap = new HashMap();
		HashMap orderMap = new HashMap();
		
		HashMap stockistMap = new HashMap();
		HashMap stockistNameMap = new HashMap();
		String transDB = null;
		
		try
		{
			ConnDriver connDriver = new ConnDriver();
			/*connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			if(this.userInfoBean!=null)
			{
				transDB = this.userInfoBean.getTransDB();
			}
			if(transDB!=null && (transDB.trim().length() >0 ))
			{
				connectionObject = connDriver.getConnectDB(transDB);
			}
			else
			{
				connectionObject = connDriver.getConnectDB("DriverITM");
			}
			
			DecimalFormat decimal = new DecimalFormat("######0.00");
			 		
			//workDate = genericUtility.getValidDateString( workDate , genericUtility.getApplDateFormat() , "dd-MMM-yyyy");
			xslFileName = getXSLFileName( "strg_meet_item_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" ); 
			System.out.println( "xslFileName======> :"+xslFileName );

			valueXmlString.append( "<Root>\r\n" );
			
			selStockistCode = (selStockistCode == null)?"":selStockistCode.trim();
			selStockistName = (selStockistName == null)?"":selStockistName.trim();
		
			if ( selectedOrder != null && selectedOrder.trim().length() > 0 )
			{  
				System.out.println( "selectedOrder======> :"+selectedOrder );
				NodeList itemNodeList = ( genericUtility.parseString( selectedOrder ) ).getElementsByTagName("strg_order");
				System.out.println( "itemNodeList======> :"+itemNodeList );
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item(i).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String itemCode = "";
					String itemDescr = "";
					String orderQty = "";
					String columnValue = "";
					String stockistCode = "";
					String stockistName = "";
							
					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");						
						if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() ;
								itemCode = itemCode.trim();
							}
						}
						else if ( "scheme_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = checkNull(currNode.getFirstChild().getNodeValue());
								itemCode = itemCode.trim();
							}
						}
						else if("item_descr".equals( currNode.getNodeName() ))
						{
							if(currNode.getFirstChild() != null)
							{
								itemDescr = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null )
							{
								orderQty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						
					}
					//System.out.println("itemCode["+itemCode+"] itemDescr["+itemDescr+"] qty["+qty+"]" );
						System.out.println(" orderMap ["+orderMap+"]");
				
				}
				
				System.out.println("stockistMap ::"+stockistMap);
				System.out.println("stockistNameMap ::"+stockistNameMap);
			}
			
			//Commented and Changed By Bhushan on 06-05-15
			/*sql = "SELECT LRM.ITEM_CODE,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, LRM.LANDING_RATE FROM LANDING_RATE_MST LRM, ITEM ITEM, SALES_PERS SP "+
					"WHERE LRM.ITEM_CODE = ITEM.ITEM_CODE "+ 
					"AND SP.ITEM_SER = ITEM.ITEM_SER "+ 
					"AND SP.SALES_PERS = ? "+ 
					"AND ? BETWEEN LRM.EFF_FROM AND LRM.VALID_UPTO "+ 
					"ORDER BY ITEM.SH_DESCR ";
			*/
			//Commented and Changed By Bhushan on 30-06-15 [For set Item pophelp state_code wise ]
			/*sql = "SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR FROM  ITEM ITEM, SALES_PERS SP "+
					"WHERE SP.ITEM_SER = ITEM.ITEM_SER "+ 
					"AND SP.SALES_PERS = ? "+ 
					"ORDER BY ITEM.SH_DESCR ";*/
			
			sql =" SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR FROM  ITEM ITEM, STRG_CUSTOMER SC ,PRICELIST  PM "+
					"WHERE ITEM.ITEM_CODE = PM.ITEM_CODE AND SC.STATE_CODE = PM.PRICE_LIST "+
					"AND SC.SC_CODE= ? "+
					"ORDER BY ITEM.SH_DESCR ";
			
			
					/*sql = " SELECT DET.ITEM_CODE, ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, DET.RATE AS RATE " +
					" FROM SALES_BUDGET_CUST HDR,SALES_BUDGET_CUST_DET DET,PERIOD PERIOD,ACCTPRD ACCTPRD,ITEM ITEM, SALES_PERS SP " +
					" WHERE DET.PRD_CODE = PERIOD.CODE " +
					" AND ? BETWEEN PERIOD.FR_DATE AND PERIOD.TO_DATE " +
					" AND DET.TRAN_ID = HDR.TRAN_ID " +
					" AND HDR.ACCT_PRD = ACCTPRD.CODE " +
					" AND ITEM.ITEM_SER = SP.ITEM_SER " +
					" AND SP.SALES_PERS = ? " +
					" AND DET.ITEM_CODE = ITEM.ITEM_CODE " +
					" GROUP BY DET.ITEM_CODE,ITEM.DESCR,ITEM.SH_DESCR,DET.RATE " +
					" ORDER BY ITEM.SH_DESCR ";*/
			pStmt = connectionObject.prepareStatement(sql);
			
			//pStmt.setString(1, sprsCode);
			pStmt.setString(1, strgCode);
			//pStmt.setTimestamp(2,java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ));
			
			rs = pStmt.executeQuery();		
			
			String qty = "0";
			
			double value = 0d;
			double rate = 0d;
			
			//double landingRate = 0d;
			while(rs.next()) 
			{
				String itemCode = (checkNull(rs.getString("ITEM_CODE"))).trim();
				System.out.println("itemCode["+itemCode+"]");
				String itemDescr = checkNull(rs.getString("DESCR"));
				String itemShDescr = checkNull(rs.getString("SH_DESCR"));
				
				String stockistCode = "";
				String stockistName = "";
				
				//landingRate = rs.getDouble("LANDING_RATE");
				
				//Commented and Changed By Bhushan on 06-05-15
				//rate = rs.getDouble("LANDING_RATE");
				rate = getLandingRate( strgCode, itemCode, workDate, sprsCode, connectionObject);
				
				System.out.println("RATE:::==["+rate+"]");
        		if ( orderMap.get( itemCode.trim() ) != null )
        		{
        			String data = ( String ) orderMap.get( itemCode.trim() );
        			qty = data.substring( data.indexOf("~") + 1 );
        			valueXmlString.append("<Detail5 domID='"+domId+"' selected = 'Y'>\r\n" );
        			
        			stockistCode = (String)stockistMap.get(itemCode.trim());
        			stockistName = (String)stockistMap.get(stockistCode.trim());
        		}
        		else
        		{
        			valueXmlString.append("<Detail5 domID='"+domId+"' selected = 'N'>\r\n" );
        		}	
				valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
    		    valueXmlString.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>\r\n");
    		 	valueXmlString.append("<item_descr><![CDATA[").append(itemShDescr).append("]]></item_descr>\r\n");
    		 	valueXmlString.append("<tooltip_descr><![CDATA[").append(itemDescr).append("]]></tooltip_descr>\r\n");
    		 	valueXmlString.append("<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );
    		 	//valueXmlString.append("<landing_rate><![CDATA[" ).append( landingRate ).append( "]]></landing_rate>\r\n" );
    		 	valueXmlString.append("<landing_rate><![CDATA[" ).append( rate ).append( "]]></landing_rate>\r\n" );
    		 	value = Integer.parseInt(qty) * rate;
    		 	System.out.println("value::::==["+value+"]");
    		 	//value = Integer.parseInt(qty) * landingRate;
    		 	
    		 	valueXmlString.append("<value><![CDATA[" ).append( decimal.format(value) ).append( "]]></value>\r\n" );
				valueXmlString.append("<dcr_id><![CDATA[]]></dcr_id>\r\n");
				valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
				valueXmlString.append("<sales_pers><![CDATA[").append(sprsCode).append("]]></sales_pers>\r\n");
				valueXmlString.append("<stockist_code><![CDATA[").append(selStockistCode).append("]]></stockist_code>\r\n");
				valueXmlString.append("<stockist_name><![CDATA[").append(selStockistName).append("]]></stockist_name>\r\n");
				valueXmlString.append("</Detail5>\r\n" );
				
				domId++;
				qty = "0";
			}
			rs.close();
			rs = null;
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			
			
			valueXmlString.append( "</Root>\r\n" );
			orderData = valueXmlString.toString();
			orderData = ( new E12GenericUtility() ).transformToString( xslFileName, orderData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getSampleItemList(String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSampleItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
			
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return orderData;
	}
	//Added by Poonam Gole on 15-OCT-2015 for adding items data into strg_meet_order.:Start[W15FZUV005]
	
	//Added by Poonam Gole on 15-OCT-2015 for adding items pophelp form pricelist.:Start[W15FZUV005]
	private double getLandingRate(String strgCode, String itemCode, String workDate, String sprsCode, Connection connectionObject) throws Exception 
	{
		System.out.println("Inside getLandingRate()::::::" );
		double rate = 0d;
		String sql = "";
		String stateCode = "";
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		
		try
		{
			System.out.println("strgCode:::>>>>[" + strgCode +"]" );
			sql = "SELECT STATE_CODE FROM STRG_CUSTOMER WHERE SC_CODE= ? ";
			
			pStmt = connectionObject.prepareStatement(sql);
			pStmt.setString(1, strgCode);
			rs = pStmt.executeQuery();
			
			if(rs.next()) 
			{
				stateCode= (checkNull(rs.getString("STATE_CODE"))).trim();
			}
			
			System.out.println("stateCode:::>>>>[" + stateCode +"]");
			DistCommon distComn = new DistCommon();
			rate = distComn.pickRate(stateCode, workDate, itemCode, connectionObject);
			 
			System.out.println("getLandingRate_RATE::>>>>["+itemCode+"] [" + rate +"]");
			
			
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :getLandingRate(String):" + e.getMessage() + ":" );
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				
				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				
			}
			catch(Exception e)
			{
				System.out.println( "Exception getLandingRate(String) :==>\n"+e.getMessage());
			}
		}
		
		return rate;
	}
	
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	//Added by Poonam Gole on 15-OCT-2015 for adding items pophelp form pricelist.:End[W15FZUV005]
	
	public String getSalesPersItemList( String salesPers, String strgCode, String selectedItem, String eventDate ) throws ITMException
	{
		String itemData = "";
		//StrgMeetWizardRemote itmWizardRemoteTemp = null;
		Connection connectionObject =null;
		try
		{
			//added by sachin satre on [14-nov-16] [start]
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]
			/*
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			itmWizardRemoteTemp = (ibase.webitm.ejb.wsfa.transactions.StrgMeetWizardRemote)ctx.lookup("ibase/StrgMeetWizardEJB/remote");
			itemData = itmWizardRemoteTemp.getSalesPersItemList( salesPers, strgCode, selectedItem, eventDate );
			itmWizardRemoteTemp = null;
			*/
			itemData = new WsfaZuviusDsrWizardEJB().getSalesPersItemList( salesPers, strgCode, selectedItem, eventDate,connectionObject );//Chnaged by sachin satre on 14-nov-16
			String xslFileName = getXSLFileName( "strg_meet_item_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//changed by Rahul Barve on 3-sep-2014
			//itemData = (  ibase.webitm.utility. GenericUtility.getInstance()  ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			itemData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			/*
			if ( itmWizardRemoteTemp != null )
			{
				itmWizardRemoteTemp = null;
			}
			*/
			try
			{
				if ( connectionObject != null && !connectionObject.isClosed()) 
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				
			}
		}
		return itemData;
	
	}
	
	//Added by Poonam Gole on 15-OCT-2015 for adding items pophelp for chemist.:Start[W15FZUV005]
	
	public String getSalesPersChemItemList( String salesPers, String strgCode, String selectedItem, String eventDate ) throws ITMException
	{
		String itemData = "";
		//StrgMeetWizardRemote itmWizardRemoteTemp = null;
		String transDB = "";
		Connection connectionObject =null;
		try
		{
			//added by sachin satre on [14-nov-16] [start]
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]
			
			
			/*
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			itmWizardRemoteTemp = (ibase.webitm.ejb.wsfa.transactions.StrgMeetWizardRemote)ctx.lookup("ibase/StrgMeetWizardEJB/remote");
			itemData = itmWizardRemoteTemp.getSalesPersItemList( salesPers, strgCode, selectedItem, eventDate );
			itmWizardRemoteTemp = null;
			*/
			itemData = new WsfaZuviusDsrWizardEJB().getSalesPersChemItemList( salesPers, strgCode, selectedItem, eventDate,connectionObject );//Chnaged by sachin satre on 14-nov-16
			String xslFileName = getXSLFileName( "strg_meet_chem_item_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//changed by Rahul Barve on 3-sep-2014
			//itemData = (  ibase.webitm.utility. GenericUtility.getInstance()  ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			itemData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			/*
			if ( itmWizardRemoteTemp != null )
			{
				itmWizardRemoteTemp = null;
			}
			*/
			try
			{
				if ( connectionObject != null && !connectionObject.isClosed()) 
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				
			}
		}
		return itemData;
	
	}
	//Added by Poonam Gole on 15-OCT-2015 for adding items pophelp for chemist.:End[W15FZUV005]
	
	//Added by Poonam Gole on 15-OCT-2015 for adding items pophelp for chemist.:Start[W15FZUV005]
	
	public String getSalesPersStocItemList( String salesPers, String strgCode, String selectedItem, String eventDate ) throws ITMException
	{
		String itemData = "";
		//StrgMeetWizardRemote itmWizardRemoteTemp = null;
		String transDB = null;
		Connection connectionObject =null;
		try
		{
			//added by sachin satre on [14-nov-16] [start]
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]
			/*
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			itmWizardRemoteTemp = (ibase.webitm.ejb.wsfa.transactions.StrgMeetWizardRemote)ctx.lookup("ibase/StrgMeetWizardEJB/remote");
			itemData = itmWizardRemoteTemp.getSalesPersItemList( salesPers, strgCode, selectedItem, eventDate );
			itmWizardRemoteTemp = null;
			*/
			itemData = new WsfaZuviusDsrWizardEJB().getSalesPersStocItemList( salesPers, strgCode, selectedItem, eventDate,connectionObject );//Chnaged by sachin satre on 14-nov-16
			String xslFileName = getXSLFileName( "strg_meet_stoc_item_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//changed by Rahul Barve on 3-sep-2014
			//itemData = (  ibase.webitm.utility. GenericUtility.getInstance()  ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			itemData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			/*
			if ( itmWizardRemoteTemp != null )
			{
				itmWizardRemoteTemp = null;
			}
			*/
			try
			{
				if ( connectionObject != null && !connectionObject.isClosed()) 
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				
			}
		}
		return itemData;
	
	}
	//Added by Poonam Gole on 15-OCT-2015 for adding items pophelp for chemist.:End[W15FZUV005]
	public String getSalesPersTeamList( String salesPers, String strgCode, String selectedTeam, String workWith ) throws ITMException
	{
		System.out.println("workWith in getSalesPersTeamList =["+workWith+"]");
		String teamData = "";
		//StrgMeetWizardRemote itmWizardRemoteTemp = null;
		try
		{
			
			//added by sachin satre on [14-nov-16] [start]
			Connection connectionObject=null;
			connectionObject =getConnection();
			System.out.println("connectionObject"+connectionObject);
			//added by sachin satre on [14-nov-16] [end]
			/*
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			itmWizardRemoteTemp = (ibase.webitm.ejb.wsfa.transactions.StrgMeetWizardRemote)ctx.lookup("ibase/StrgMeetWizardEJB/remote");
			teamData = itmWizardRemoteTemp.getSalesPersTeamList( salesPers, strgCode, selectedTeam, workWith );
			itmWizardRemoteTemp = null;
			*/
			teamData = new WsfaZuviusDsrWizardEJB().getSalesPersTeamList( salesPers, strgCode, selectedTeam, workWith,connectionObject );//Chnaged by sachin satre on 14-nov-16
			String xslFileName = getXSLFileName( "strg_meet_mitoch_team_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//changed by Rahul Barve on 3-sep-2014
			//teamData = (   ibase.webitm.utility. GenericUtility.getInstance()  ).transformToString( xslFileName, teamData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			teamData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, teamData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			/*
			if ( itmWizardRemoteTemp != null )
			{
				itmWizardRemoteTemp = null;
			}
			*/
		}
		System.out.println("teamData:::"+teamData);
		return teamData;
	}
	
	public String getSalesPersonList( String loginCode ) throws ITMException
	{
		System.out.println("loginCode in getSalesPersonList =["+loginCode+"]");
		String salesPerspList = "";
		StrgCustDeactive strgCustDeactiveRemote = null;//modified by kailash.
		Connection conn= null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			//Added by sagar m.14-jan-19[for In deactivation doctor/chemist sales_pers pophelp]Start
			ConnDriver mConnDriver =  new ConnDriver();
			String tranDB=getUserInfo().getTransDB();
			if(tranDB != null && tranDB.trim().length() > 0)
			{
				conn = mConnDriver.getConnectDB(tranDB);
			}
			//Added by sagar m.14-jan-19[for In deactivation doctor/chemist sales_pers pophelp]End
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//strgCustDeactiveRemote = (ibase.webitm.ejb.wsfa.transactions.StrgCustDeactiveRemote)ctx.lookup("ibase/StrgCustDeactive/remote");
			strgCustDeactiveRemote = new StrgCustDeactive();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]
			//salesPerspList = strgCustDeactiveRemote.getSalesPersonList( loginCode );// commented by sagar m.

			salesPerspList = strgCustDeactiveRemote.getSalesPersonList( loginCode,conn );
			String xslFileName = getXSLFileName( "customer_deact_sales_pers_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//changed by Rahul Barve on 3-sep-2014
			//salesPerspList = (   ibase.webitm.utility. GenericUtility.getInstance()  ).transformToString( xslFileName, salesPerspList, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			salesPerspList = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, salesPerspList, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			//Added by sagar m.14-jan-19[for In deactivation doctor/chemist sales_pers pophelp]Start
			try 
			{
				if ( strgCustDeactiveRemote != null )
				{
					strgCustDeactiveRemote = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn=null;
				}
				
			} catch (Exception e2) {
				// TODO: handle exception
			}
		}
		//Added by sagar m.14-jan-19[for In deactivation doctor/chemist sales_pers pophelp]End
		return salesPerspList;
	}
	
	// Added By Rakesh kumar 26/02/13 START:.
	public String getCmeActivityCodeList( String salesPers, String selectedActCode )
	{
		String activityCodeData = "";
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			activityCodeData = new SalePersCmeWizardEJB().getCmeActivityCodeList( salesPers, selectedActCode );
			String xslFileName = getXSLFileName( "sales_pers_act_code_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//changed by Rahul Barve on 3-sep-2014
			//activityCodeData = (   ibase.webitm.utility. GenericUtility.getInstance() ).transformToString( xslFileName, activityCodeData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			activityCodeData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, activityCodeData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

			System.out.println("@@@@@@@@@@@ activityCoddeData @@@@@@@@@ ");
		}
		catch ( Exception e  )
		{
			e.printStackTrace();
		}
		finally
		{
			
		}
		return activityCodeData;
	}
	//Added By Rakesh kumar 26/02/13 END:.
	
	
	
	
	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}
	
	//added by Bhushan 9/11/15 get the prior visits : START
	public String getPriorVisits( String sprsCode, String strgCode, String eventDate ,String linkTitle, String tranId ) throws ITMException
	{
		String visitData = "";
		String custData = "";
		Connection connectionObject = null; 
		try
		{
			//added by sachin satre on [14-nov-16] [start]
			connectionObject =getConnection();
			String xslFileName = "";
			System.out.println("connectionObject ["+connectionObject+"linkTitle ["+linkTitle+"]");
			System.out.println("tranId ["+tranId+"]"); // added by rupali on 19/03/18 for showing data in dashboard link
			//added by sachin satre on [14-nov-16] [end]
		    //visitData = new WsfaZuviusDsrWizardEJB().getPriorVisits(sprsCode, strgCode, eventDate,connectionObject);
			//Added by Ashutosh G-on 02-Nov-17 [Start- For customer info]
			if( "Customer Info.".equalsIgnoreCase(linkTitle) )
			{
				visitData = new StrgMeetDCRWizard().getCustInfoData(sprsCode, strgCode, eventDate, tranId, connectionObject); // added tran_id by rupali on 19/03/18 for showing data in dashboard link [start] 
				xslFileName = getXSLFileName( "wsfa_sales_pers_customer_info_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
				visitData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, visitData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			}
			else
			{
				visitData = new StrgMeetDCRWizard().getPriorVisits(sprsCode, strgCode, eventDate, tranId, connectionObject);  // added tran_id by rupali on 19/03/18 for showing data in dashboard link [start]
				xslFileName = getXSLFileName( "wsfa_sales_pers_prior_visit_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
				visitData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, visitData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			}
			//Added by Ashutosh G-on 02-Nov-17 [End- For customer info]
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			
			try
			{
				if ( connectionObject != null && !connectionObject.isClosed()) 
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				
			}
		}
		
		System.out.println("visitData:::"+visitData);
		return visitData;
	}
	//added by Bhushan 9/11/15 get the prior visits : END
	
	
	// Changed by Rahul on 16-May-2016 [START] to set Activity Description value 
		public String getActivityDescr(String salesPers, String workDate)
		{
			Connection connectionObject = null;
			PreparedStatement planPstmt = null;
			ResultSet planRs = null;
			System.out.println("workDate.....::::"+workDate);
			GenericUtility genericUtility = GenericUtility.getInstance();
			StringBuffer valueXmlString = new StringBuffer();
			try
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB("DriverITM");*/
				//added by sachin satre on [14-nov-16] [start]
				connectionObject =getConnection();
				System.out.println("connectionObject"+connectionObject);
				//added by sachin satre on [14-nov-16] [end]
				
				int num =1;
				WsfaZuviusDsrWizardEJB dsrWiz = new WsfaZuviusDsrWizardEJB();
				String sfaParmValue = dsrWiz.getSfaParmValue(salesPers,connectionObject);//Chnaged by sachin satre on 14-nov-16
				valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
		        valueXmlString.append( "" ).append( "</editFlag>\r\n</Header>\r\n<Errors>\r\n</Errors>\r\n" );
		        if(sfaParmValue.equalsIgnoreCase("Y"))
		        {
					String sql =" SELECT PLAN.PLAN_DATE AS PLAN_DATE,PLAN.PLAN_ACTIVITY AS PLAN_ACTIVITY,FLD.ACTIVITY_CODE AS ACTIVITY_CODE," +
						 " FLD.ACTIVITY_TYPE AS ACTIVITY_TYPE,FLD.DESCR AS DESCR "+
			             " FROM SPRS_PLAN_HDR PLAN,FIELDACTIVITY FLD WHERE PLAN_DATE= ?" +
			             " AND PLAN.PLAN_ACTIVITY = FLD.ACTIVITY_CODE AND SPRS_CODE__PLAN = ? AND CONFIRM = ?";
					planPstmt =  connectionObject.prepareStatement(sql);
					planPstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					planPstmt.setString(2, checkNull(salesPers));
					planPstmt.setString(3, checkNull("Y"));
					planRs = planPstmt.executeQuery();
					if(planRs.next())
					{
						valueXmlString.append( "<Detail1 dbID='' domID='"+ num +"' objContext='1' selected='Y'>\r\n" );
						valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='Y' />\r\n" );
						valueXmlString.append("<activity_type><![CDATA[").append( planRs.getString("ACTIVITY_TYPE")).append("]]></activity_type>\r\n");
						valueXmlString.append("<activity_descr><![CDATA[").append( planRs.getString("DESCR")).append("]]></activity_descr>\r\n");
						valueXmlString.append("<activity_code><![CDATA[").append( planRs.getString("ACTIVITY_CODE")).append("]]></activity_code>\r\n");
						//actType = planRs.getString("ACTIVITY_TYPE");
						//actDscr = planRs.getString("DESCR");
						valueXmlString.append("</Detail1>");
					}
					else if(!planRs.next())
					{
						valueXmlString.append( "<Detail1 dbID='' domID='"+ num +"' objContext='1' selected='Y'>\r\n" );
						valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='Y' />\r\n" );
						valueXmlString.append("<is_plan><![CDATA[").append("N").append("]]></is_plan>\r\n");;
						valueXmlString.append("</Detail1>");
					}
					
		        }
		        valueXmlString.append("</Root>");
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
			finally
			{
				try
				{
					if (connectionObject != null && !connectionObject.isClosed())
					{
						connectionObject.close();
						connectionObject = null;
					}
					if(planPstmt!=null)
					{
						planPstmt.close();
						planPstmt=null;
					}
					if(planRs!=null)
					{
						planRs.close();
						planRs=null;
					}
				}
				catch(Exception e)
				{
					e.printStackTrace();
				}
			}
			return valueXmlString.toString();
		}
		// Changed by Rahul on 16-May-2016 [END] to set Activity Description value 	
		//Added by vinayak on 20/10/2016 [start]
		public String getSalesPersOtherItemList( String salesPers, String strgCode, String selectedItem, String eventDate ) throws ITMException
		{
			String itemData = "";
			//StrgMeetWizardRemote itmWizardRemoteTemp = null;
			try
			{
				/*
				InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
				itmWizardRemoteTemp = (ibase.webitm.ejb.wsfa.transactions.StrgMeetWizardRemote)ctx.lookup("ibase/StrgMeetWizardEJB/remote");
				itemData = itmWizardRemoteTemp.getSalesPersItemList( salesPers, strgCode, selectedItem, eventDate );
				itmWizardRemoteTemp = null;
				*/
				itemData = new WsfaZuviusDsrWizardEJB().getSalesPersOtherItemList( salesPers, strgCode, selectedItem, eventDate );
				String xslFileName = getXSLFileName( "strg_meet_other_item_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
				//changed by Rahul Barve on 3-sep-2014
				//itemData = (  ibase.webitm.utility. GenericUtility.getInstance()  ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
				itemData = ( new ibase.utility.E12GenericUtility() ).transformToString( xslFileName, itemData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

			}
			catch (Exception e)
			{
				throw new ITMException(e);
			}
			finally
			{
				/*
				if ( itmWizardRemoteTemp != null )
				{
					itmWizardRemoteTemp = null;
				}
				*/
			}
			return itemData;
		
		}
		//Added by vinayak on 20/10/2016 [end]
		
		public String getSalesPersTeamListOther( String salesPers, String strgCode, String selectedTeam ) throws ITMException
		{
			String teamData = "";
			//ITMWizardStatefulRemote itmWizardRemoteTemp = null;
			try
			{
				System.out.println("StrgMeetWizardBean : getSalesPersTeamListMitoch() ::");
				//InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
				//itmWizardRemoteTemp = (ibase.webitm.ejb.ITMWizardStatefulRemote)ctx.lookup("ibase/ITMWizardStatefulEJB/remote");
				//teamData = itmWizardRemoteTemp.getSalesPersTeamList( salesPers, strgCode, selectedTeam );
				teamData = getSalesPersTeamListOtherZuvius( salesPers, strgCode, selectedTeam );
				//itmWizardRemoteTemp.remove();
				//itmWizardRemoteTemp = null;

				String xslFileName = getXSLFileName( "strg_meet_team_other_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
				teamData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, teamData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			}
			catch (Exception e)
			{
				throw new ITMException(e);
			}
			finally
			{
				/*if ( itmWizardRemoteTemp != null )
				{
					itmWizardRemoteTemp.remove();
					itmWizardRemoteTemp = null;
				}*/
			}
			return teamData;
		}
		public String getSalesPersTeamListOtherZuvius(String salesPers, String strgCode,String selectedTeam) throws ITMException
		{
			String sql = "";
			String[] team = new String[25];
			StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
			Connection connectionObject = null;
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			ResultSet rset = null;
			GenericUtility genericUtility = GenericUtility.getInstance();
	        String transDB = null;
			try
			{
				ConnDriver connDriver = new ConnDriver();

				if(this.userInfoBean!=null)
				{
					transDB = this.userInfoBean.getTransDB();
				}
				
				if(transDB!=null && (transDB.trim().length() >0 ))
				{
					connectionObject = connDriver.getConnectDB(transDB);
				}
				else
				{
					connectionObject = connDriver.getConnectDB("DriverITM");
				}
				selectedTeam = (selectedTeam != null) ? selectedTeam.trim() : selectedTeam;
				team = selectedTeam.split(",");
				System.out.println("Team selected [" + Arrays.asList(team)+ "] strgCode[" + strgCode + "]");
				sql = "SELECT SQL_STR FROM POPHELP WHERE FIELD_NAME='SALES_PERS' AND MOD_NAME='W_STRG_MEET'";
				pstmt = connectionObject.prepareStatement(sql);
				rs = pstmt.executeQuery();
				int num = 1;
				if (rs.next()) 
				{
					sql = rs.getString("SQL_STR").trim().replace("'?'", "?");
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1, salesPers);
					rs = pstmt.executeQuery();
					while (rs.next()) 
					{
						String reportTo = rs.getString("REPORT_TO");
						String desgn = rs.getString("DESIGNATION");
						System.out.println("reportTo[" + reportTo + "] desgn ["	+ desgn + "]");
						reportTo = (reportTo != null) ? reportTo.trim() : reportTo;
						if (new ArrayList<String>(Arrays.asList(team)).contains(reportTo)) 
						{
							valueXmlString.append("<Detail16 domID='" + num	+ "' selected = 'Y'>\r\n");
						} 
						else 
						{
							valueXmlString.append("<Detail16 domID='" + num	+ "' selected = 'N'>\r\n");
						}

						valueXmlString.append("<sales_pers><![CDATA[").append(reportTo).append("]]></sales_pers>\r\n");
						valueXmlString.append("<name><![CDATA[").append(rs.getString("NAME")).append("]]></name>\r\n");
						valueXmlString.append("<designation><![CDATA[").append(rs.getString("DESIGNATION")).append(	"]]></designation>\r\n");
						valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
						valueXmlString.append("<role_code><![CDATA[]]></role_code>\r\n");

						sql = "SELECT DESIGN_CODE FROM EMPLOYEE WHERE EMP_CODE = ?";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, reportTo);
						rset = pstmt.executeQuery();
						if (rset.next()) 
						{
							String desgnCode = rset.getString("DESIGN_CODE") != null ? rset.getString("DESIGN_CODE").trim(): "";
							valueXmlString.append("<design_code><![CDATA[").append(desgnCode).append("]]></design_code>\r\n");
						}

						valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
						valueXmlString.append("</Detail16>\r\n");
						num++;
					}
				}

				rs.close();
				rs = null;

				rset.close();
				rset = null;

				pstmt.close();
				pstmt = null;

			} 
			catch (Exception e) 
			{
				e.printStackTrace();
				System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String):"+ e.getMessage() + ":");
				valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
			} 
			finally 
			{
				try 
				{
					if (connectionObject != null && !connectionObject.isClosed()) 
					{
						connectionObject.close();
						connectionObject = null;
					}
					if (rs != null) 
					{
						rs.close();
						rs = null;
					}

					if (rset != null) 
					{
						rset.close();
						rset = null;
					}

					if (pstmt != null) 
					{
						pstmt.close();
						pstmt = null;
					}
				} 
				catch (Exception e) 
				{
					System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String) :==>\n"+ e.getMessage());
					throw new ITMException(e);
				}
			}
			valueXmlString.append("</Root>\r\n");
			System.out.println("\n****ValueXmlString :" + valueXmlString.toString()+ ":********");
			return valueXmlString.toString();

		}
		//Added by sachin satre on [14-nov-16] [start] 
		public Connection getConnection()
		{
			Connection conn = null;
			ConnDriver connDriver = new ConnDriver();
			try
			{
				System.out.println(" In StrgMeetwizardBean :: getConnection() :: ["+this.userInfo+"]");
				System.out.println(" In StrgMeetwizardBean :: getConnection() :: ["+this.userInfoBean+"]");
				if(this.userInfo != null)
				{
					String transDB = this.userInfo.getTransDB();
					
					System.out.println(" StrgMeetwizardBean getConnection :: transDB :: ["+transDB+"]");
					
					if( transDB != null && transDB.trim().length() > 0 && !"null".equalsIgnoreCase(transDB))
					{
						conn = connDriver.getConnectDB(transDB);
						connDriver = null;
						System.out.println(" StrgMeetwizardBean getConnection :: transDB :: on if condition :["+transDB+"]");
					}
					else
					{
						System.out.println(" StrgMeetwizardBean :: transDB is null :: So that creating connection using DriverITM....");					
						conn = connDriver.getConnectDB("DriverITM");
						connDriver = null;
					}
				}
				else
				{
					System.out.println(" StrgMeetwizardBean :: UserInfo is null :: So that creating connection using DriverITM....");
					conn = connDriver.getConnectDB("DriverITM");
					connDriver = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : [StrgMeetwizardBean][getConnection] :==>\n"+e.getMessage());
				e.printStackTrace();
			}
			return conn;
		}
		//Added by sachin satre on [14-nov-16] [end] 
		//Added by sachin satre on [14-nov-16] [start]
		public String getActivityCodeList( String salesPers, String selectedActCode ) throws ITMException
		{
			String activityCodeData = "";
			ITMWizardStatefulRemote itmWizardRemoteTemp = null;
			Connection connectionObject =null;
			try
			{
				//added by sachin satre on [14-nov-16] [start]
				connectionObject =getConnection();
				System.out.println("connectionObject"+connectionObject);
				//added by sachin satre on [14-nov-16] [end]
				InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
				/*itmWizardRemoteTemp = (ibase.webitm.ejb.ITMWizardStatefulRemote)ctx.lookup("ibase/ITMWizardStatefulEJB/remote");
				activityCodeData = itmWizardRemoteTemp.getActivityCodeList( salesPers, selectedActCode );*/
				activityCodeData = new WsfaZuviusDsrWizardEJB().getActivityCodeList( salesPers, selectedActCode,connectionObject);
				/*itmWizardRemoteTemp.remove();
				itmWizardRemoteTemp = null;*/

				String xslFileName = getXSLFileName( "strg_meet_act_code_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
				activityCodeData = new E12GenericUtility().transformToString( xslFileName, activityCodeData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			}
			catch ( Exception e  )
			{
				e.printStackTrace();
			}
			finally
			{
				if ( itmWizardRemoteTemp != null )
				{
					itmWizardRemoteTemp.remove();
					itmWizardRemoteTemp = null;
				}	
				try 
				{
					if (connectionObject != null && !connectionObject.isClosed()) 
					{
						connectionObject.close();
						connectionObject = null;
					}
				} 
				catch (Exception e) 
				{
					System.out.println("Exception :getActivityCodeList :getActivityCodeList (String) :==>\n"+ e.getMessage());
					throw new ITMException(e);
				}
				
			}
			return activityCodeData;
		}
		//Added by sachin satre on [14-nov-16] [start]
		public String getPendingSample( String salesPers ) throws ITMException
		{
			String pendingSample = "";
			Connection conn = null;
			try
			{
				pendingSample = new StrgMeetWizardEJB().getPendingSample( salesPers, conn );
			}
			catch (Exception e)
			{
				throw new ITMException(e);
			}
			return pendingSample;
		
		}
		public HashMap getSampleDARStatus( String salesPers ) throws ITMException
		{
			HashMap sampleStatusMap = new HashMap();
			Connection conn = null;
			try
			{
				sampleStatusMap = new CallReportStatusEJB().getSampleDARStatus( salesPers, conn );
			}
			catch (Exception e)
			{
				throw new ITMException(e);
			}
			return sampleStatusMap;
		
		}
	
	// Added by Pankaj R on 17-Dec-17 to migrate FN_GET_EMP_HOLIDAY function [START]
	public boolean isEmpHoliday(String empCode , String date, Connection conn) throws Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean isHoliday = false;
		try
		{
			String holtblno = getHoltblno(empCode,date, conn);
			String holDate = "";
			String holDateTo = "";
			String Sql = " SELECT HOL_DATE AS A_HOL_DATE FROM HOLIDAY WHERE HOL_TBLNO = ? AND HOL_DATE = ? ";
			pstmt = conn.prepareStatement(Sql);
			pstmt.setString(1, holtblno);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(date));
			rs = pstmt.executeQuery();			
			if(rs.next())
			{
				holDate = checkNull(rs.getString("A_HOL_DATE"));
			}
			//Added by Mrunalini Sinkar for change_holiday changes in DAR & Monthly Plan(17/12/2019 : start)
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt !=null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("holDate is["+holDate+"]");
			if(holDate != null && holDate.trim().length()>0)
			{
				String chnageSql="SELECT B.HOL_DATE_TO FROM CHANGE_HOLIDAY B, HOLIDAY H " + 
						"WHERE  H.HOL_TBLNO = B.HOL_TBLNO AND B.HOL_DATE_FOR= H.HOL_DATE " + 
						"AND B.HOL_TBLNO=? AND B.EMP_CODE=? AND H.HOL_DATE=? ";
				pstmt = conn.prepareStatement(chnageSql);
				pstmt.setString(1, holtblno);
				pstmt.setString(2, empCode);
				pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(date));
				rs = pstmt.executeQuery();			
				if(rs.next())
				{
					holDateTo = checkNull(rs.getString("HOL_DATE_TO"));
				}
				//Added by Mrunalini Sinkar for change_holiday changes in DAR & Monthly Plan(17/12/2019 : start)
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("holDateTo is["+holDateTo+"]");

				if(holDateTo!=null && holDateTo.trim().length()>0)
				{

					Date applHolDate =getDateObject(holDate);
					Date applHolDateTo =getDateObject(holDateTo);
					System.out.println("applHolDate["+applHolDate+"]applHolDateTo["+applHolDateTo+"]applHolDate.compareTo(applHolDateTo)["+applHolDate.compareTo(applHolDateTo)+"]");
					if(applHolDate.compareTo(applHolDateTo) == 0)
					{
						isHoliday = true;
					}
					else
					{
						isHoliday =  false;
					}
				}
				else
				{
					isHoliday = true;
				}
			}
			else
			{
				String changeHolDate="";
				String holSql = " SELECT HOL_DATE_TO AS HOL_DATE_TO FROM CHANGE_HOLIDAY WHERE HOL_TBLNO = ? AND HOL_DATE_TO = ? AND EMP_CODE=? ";
				pstmt = conn.prepareStatement(holSql);
				pstmt.setString(1, holtblno);
				pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(date));
				pstmt.setString(3, empCode);
				rs = pstmt.executeQuery();			
				if(rs.next())
				{
					changeHolDate = checkNull(rs.getString("HOL_DATE_TO"));
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(changeHolDate!=null && changeHolDate.trim().length()>0)
				{
					isHoliday =  true;
				}
				else
				{
					isHoliday =  false;
				}
			}
			/*if ( holDate != null )
			{
				isHoliday = true;
		}
			else
			{
				isHoliday =  false;
			}*/
			
			//Added by Mrunalini Sinkar for change_holiday changes in DAR & Monthly Plan(17/12/2019 : end)
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("isHoliday["+isHoliday+"]");
		return isHoliday;
	}
		  
	private String getHoltblno (String emplCode, String eventDate, Connection conn ) throws Exception
	{
		int count = 0;
		int cnt = 0;
		String sql = null;
		String sqlCnt = null;
		String holTblNo = null;
		String sqlTbl = null;
		String sqlTblNo = null;
		PreparedStatement pstmtCount = null;
		ResultSet rsCount = null;
		PreparedStatement pstmtCnt = null;
		ResultSet rsCnt = null;
		PreparedStatement pstmtSet = null;
		ResultSet rsSet = null;
		PreparedStatement pstmtTbl = null;
		ResultSet rsTbl = null;
		PreparedStatement pstmtTblno = null;
		ResultSet rsTblno = null;
		
		try
		{
			sql = " SELECT COUNT(*) AS COUNT FROM EMP_EMPLOY_EVENTS WHERE EMP_CODE = ? AND CONFIRMED = 'Y'";
			pstmtCount = conn.prepareStatement(sql);
			pstmtCount.setString(1, emplCode);
			rsCount = pstmtCount.executeQuery();
				
			if(rsCount.next())
			{
				count = rsCount.getInt("COUNT");
			}
			//added by mrunalini sinkar on 10-April-2018(start)
			if (rsCount != null)
			{
				rsCount.close();
				rsCount = null;
			}
			if(pstmtCount !=null)
			{
				pstmtCount.close();
				pstmtCount = null;
			}
			//added by mrunalini sinkar on 10-April-2018(end)
			//System.out.println("EMP_EMPLOY_EVENTS count =["+count+"]");
			if(count > 0 )
			{
				String sql1 = " SELECT COUNT(*) AS COUNT FROM EMP_EMPLOY_EVENTS WHERE EMP_CODE = ? AND EFF_DATE = (SELECT MAX(EFF_DATE) FROM EMP_EMPLOY_EVENTS WHERE EMP_CODE = ? AND CONFIRMED =  'Y'AND EFF_DATE <= ?) AND CONFIRMED = 'Y'";
				pstmtCnt = conn.prepareStatement(sql1);
				pstmtCnt.setString(1, emplCode);
				pstmtCnt.setString(2, emplCode);
				pstmtCnt.setTimestamp(3, java.sql.Timestamp.valueOf(eventDate));
				rsCnt = pstmtCnt.executeQuery();						
				
				if(rsCnt.next())
				{
					cnt = rsCnt.getInt("COUNT");
				}
				//added by mrunalini sinkar on 10-April-2018(start)
				if (rsCnt != null)
				{
					rsCnt.close();
					rsCnt = null;
				}
				if(pstmtCnt !=null)
				{
					pstmtCnt.close();
					pstmtCnt = null;
				}
				//added by mrunalini sinkar on 10-April-2018(end)

				System.out.println("EMP_EMPLOY_EVENTS cnt =["+cnt+"]");
				if(cnt > 0 )
				{
					sqlCnt = " SELECT AA.HOL_TBLNO__TO AS HOL_TBLNO FROM EMP_EMPLOY_EVENTS AA WHERE AA.EMP_CODE = ? AND AA.CONFIRMED = 'Y' AND AA.TRAN_ID = ( SELECT MAX(BB.TRAN_ID) FROM EMP_EMPLOY_EVENTS BB WHERE BB.EMP_CODE = AA.EMP_CODE AND BB.EFF_DATE = ( SELECT MAX(CC.EFF_DATE) FROM EMP_EMPLOY_EVENTS CC WHERE CC.EMP_CODE = AA.EMP_CODE AND CC.EFF_DATE <= ? AND CC.CONFIRMED = 'Y' ) AND BB.CONFIRMED = 'Y')";
				}
				else
				{
					sqlCnt = " SELECT AA.HOL_TBLNO__FR AS HOL_TBLNO FROM EMP_EMPLOY_EVENTS AA WHERE AA.EMP_CODE = ? AND AA.CONFIRMED = 'Y' AND AA.TRAN_ID = ( SELECT MIN(BB.TRAN_ID) FROM EMP_EMPLOY_EVENTS BB WHERE BB.EMP_CODE = AA.EMP_CODE AND BB.EFF_DATE = ( SELECT MIN(CC.EFF_DATE) FROM EMP_EMPLOY_EVENTS CC WHERE CC.EMP_CODE = AA.EMP_CODE AND CC.EFF_DATE > ? AND CC.CONFIRMED = 'Y' ) AND BB.CONFIRMED = 'Y')";					  
				}
				pstmtSet = conn.prepareStatement(sqlCnt);
				pstmtSet.setString(1, emplCode);
				pstmtSet.setTimestamp(2, java.sql.Timestamp.valueOf(eventDate));
				rsSet = pstmtSet.executeQuery();
				if(rsSet.next())
				{
					holTblNo = rsSet.getString("HOL_TBLNO");
				}
				//added by mrunalini sinkar on 10-April-2018(start)
				if (rsSet != null)
				{
					rsSet.close();
					rsSet = null;
				}
				if(pstmtSet !=null)
				{
					pstmtSet.close();
					pstmtSet = null;
				}
				//added by mrunalini sinkar on 10-April-2018(end)

			}
		   
			if(holTblNo == null || (holTblNo).trim().length() == 0  )
			{
				String workSite = "";
				sqlTbl = "SELECT HOL_TBLNO, WORK_SITE FROM EMPLOYEE WHERE EMP_CODE = ? ";
				pstmtTbl = conn.prepareStatement(sqlTbl);
				pstmtTbl.setString(1, emplCode);
				rsTbl = pstmtTbl.executeQuery();
				if(rsTbl.next())
				{
					holTblNo = rsTbl.getString("HOL_TBLNO");
					workSite = rsTbl.getString("WORK_SITE");
				}
				//added by mrunalini sinkar on 10-April-2018(start)
				if (rsTbl != null)
				{
					rsTbl.close();
					rsTbl = null;
				}
				if(pstmtTbl !=null)
				{
					pstmtTbl.close();
					pstmtTbl = null;
				}
				//added by mrunalini sinkar on 10-April-2018(end)
	
				if(holTblNo == null || (holTblNo).trim().length() == 0  )
				{
					sqlTblNo = "SELECT HOL_TBLNO FROM SITE WHERE SITE_CODE = ? ";
					pstmtTblno = conn.prepareStatement(sqlTblNo);
					pstmtTblno.setString(1, workSite);
					rsTblno = pstmtTblno.executeQuery();
							
					if(rsTblno.next())
					{
						holTblNo = rsTblno.getString("HOL_TBLNO");
					}
					//added by mrunalini sinkar on 10-April-2018(start)
					if (rsTblno != null)
					{
						rsTblno.close();
						rsTblno = null;
					}
					if(pstmtTblno !=null)
					{
						pstmtTblno.close();
						pstmtTblno = null;
					}
					//added by mrunalini sinkar on 10-April-2018(end)
				}
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsCount != null)
				{
					rsCount.close();
					rsCount = null;
				}
				if(pstmtCount !=null)
				{
					pstmtCount.close();
					pstmtCount = null;
				}
				if (rsCnt != null)
				{
					rsCnt.close();
					rsCnt = null;
				}
				if(pstmtCnt !=null)
				{
					pstmtCnt.close();
					pstmtCnt = null;
				}
				if (rsSet != null)
				{
					rsSet.close();
					rsSet = null;
				}
				if(pstmtSet !=null)
				{
					pstmtSet.close();
					pstmtSet = null;
				}
				if (rsTbl != null)
				{
					rsTbl.close();
					rsTbl = null;
				}
				if(pstmtTbl !=null)
				{
					pstmtTbl.close();
					pstmtTbl = null;
				}
				if (rsTblno != null)
				{
					rsTblno.close();
					rsTblno = null;
				}
				if(pstmtTblno !=null)
				{
					pstmtTblno.close();
					pstmtTblno = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("holTblNo =["+holTblNo+"]");
		return holTblNo; 
	}
	// Added by Pankaj R on 17-Dec-17 to migrate FN_GET_EMP_HOLIDAY function [end]
	//Added by dipak for calendar view 25/02/13 : START
	public String getSalesPersTeamList1( String salesPers, String strgCode, String selectedTeam, String workWith ) throws ITMException
	{
		//System.out.println("workWith in getSalesPersTeamList =["+workWith+"]");
		String teamData = "";
		try
		{
			teamData = new StrgMeetWizardEJB().getSalesPersTeamList1( salesPers, strgCode, selectedTeam, workWith );
			String xslFileName = getXSLFileName( "strg_meet_team_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			teamData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, teamData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		//System.out.println("teamData:::"+teamData);
		return teamData;
	}
		//Added by Dipak on 25/02/13 : END
	//Added by ashutosh on 18-jan-18  [for validation on submit-Start]
	public String getSalesPersTeamValidation( String emCode , String salesPers ) throws ITMException
	{
		System.out.println("1623 Inside getSalesPersTeamValidation ");
		String errString = "";
		//Added and modified by kailash on 02-04-18 for multitenancy changes.[Start]
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		try
		{
			
			int cnt=0;
			ITMDBAccessEJB itmDBAccessLocal = null;//modified by kailash.
			ArrayList teamList = new ArrayList();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			//System.out.println("1636 Inside getSalesPersTeamValidation ");
			//ConnDriver connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB( "DriverValidator" );
			connectionObject = getConnection();
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]
			//System.out.println("1643 Inside getSalesPersTeamValidation ");
			sql = "SELECT SALES_PERS , SP_NAME AS NAME ,ITEM_SER ,GET_EMP_DESIGNATION(SALES_PERS)AS DESIGNATION  FROM SALES_PERS  WHERE SALES_PERS IN (select emp_code  from EMPLOYEE WHERE fn_get_hierarcy_NIGEL(EMP_CODE, CAST( ? As VARCHAR(10) )) > 0 )";
			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString( 1, emCode );
			rs = pstmt.executeQuery();
			//System.out.println("1650 Inside getSalesPersTeamValidation ");
			while(rs.next())
			{
				String teamMember = checkNull(rs.getString("SALES_PERS"));
				teamList.add(teamMember);
			}
			System.out.println("1648 teamList ["+teamList+"] salesPers ["+salesPers+"] emCode ["+emCode);
			if(!teamList.contains(salesPers))
			{
				errString = itmDBAccessLocal.getErrorString( "sales_pers", "INVALSLPER", salesPers );
				return errString;
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String):" + e.getMessage() + ":" );
			
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if (connectionObject != null && !connectionObject.isClosed()) 
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//Added and modified by kailash on 02-04-18 for multitenancy changes.[End]
		
		return errString;
	}
	//Added by ashutosh on 18-jan-18  [for validation on submit-End]
	// added by rupali on 01/11/18 for dispalying scheme description in link [start]
	public String getSchemeDescription( String sprsCode, String strgCode, String eventDate ,String itemCode ) throws ITMException
	{
		String schemeData = "";
		String custData = "";
		Connection connectionObject = null; 
		try
		{
			connectionObject =getConnection();
			String xslFileName = "";
			schemeData = new StrgMeetDCRWizard().getSchemeDescription(sprsCode, strgCode, eventDate, itemCode, connectionObject);  // added tran_id by rupali on 19/03/18 for showing data in dashboard link [start]
			xslFileName = getXSLFileName( "wsfa_item_scheme_description_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			schemeData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, schemeData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( connectionObject != null && !connectionObject.isClosed()) 
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				
			}
		}
		System.out.println("visitData:::"+schemeData);
		return schemeData;
	}
	// added by rupali on 01/11/18 for dispalying scheme description in link [end]
	
	
	
	public String getBeatWiseCustomer( String routeId, String sprsCode, String localityCode ) throws ITMException
	{
		String visitData = "";
		String custData = "";
		Connection connectionObject = null; 
		try
		{

			connectionObject =getConnection();
			String xslFileName = "";
			System.out.println("connectionObject ["+routeId+"sprsCode ["+sprsCode+"]localityCode["+localityCode+"]");

				visitData = new StrgMeetDCRWizard().getBeatWiseCustomers(routeId, sprsCode, localityCode, connectionObject);  // added tran_id by rupali on 19/03/18 for showing data in dashboard link [start]
				xslFileName = getXSLFileName( "wsfa_beat_wise_customer_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
				visitData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, visitData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			
			try
			{
				if ( connectionObject != null && !connectionObject.isClosed()) 
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				
			}
		}
		
		System.out.println("visitData:::"+visitData);
		return visitData;
	}
	//Added by mrunalini sinkar
	public java.util.Date getDateObject(String date) throws RemoteException,ITMException
	{
		java.util.Date dat = null;
		E12GenericUtility genericUtility = new E12GenericUtility();

		try
		{			
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			dat = simpleDateFormat.parse(date);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return dat;
	}
}