/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.nfunk.jep.JEP;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ReCalculateTax {
    double totalTax = 0.0;
    String taxBase = null;
    ArrayList taxArrLst = null;
    Node workingTaxNode = null;
    Node dataNode = null;
    Node updatedTaxNode = null;
    HashMap tempVarMap = null;
    ArrayList taxCodeSeqArrList = null;
    Connection conn = null;
    Statement stmt = null;
    ResultSet rs = null;
    Document updatedTaxDom = null;
    StringBuffer taxChangeStrBuff = new StringBuffer();
    int domIdCtr = -1;
    String selDataObjCtx = "";
    String selDataDomId = "";
    JEP taxJEP;
    String refSerStr = "";
    private UserInfoBean userInfo = null;

    public void setTaxTranDom(Node detailNode, Node taxNode, String selDataObjCtx, String selDataDomId) throws Exception {
        try {
            BaseLogger.log("3", null, null, "Before Recalculating Tax.....................");
            BaseLogger.log("9", null, null, "Data Node :[" + detailNode + "]");
            BaseLogger.log("9", null, null, "Tax Node :[" + taxNode + "]");
            BaseLogger.log("3", null, null, ".....................Before Recalculating Tax");
            this.dataNode = detailNode;
            this.selDataObjCtx = selDataObjCtx;
            this.selDataDomId = selDataDomId;
            this.setTaxArrLst(taxNode, "Tax");
            this.updatedTaxNode = taxNode;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ReCalculateTax : setTaxTranDom() : \n" + e);
            throw e;
        }
    }

    private void setTaxArrLst(Node searchFrom, String tagName) throws ITMException {
        BaseLogger.log("2", null, null, "Setting TaxArrLst . . . . . . . . . . . . . .");
        try {
            NodeList childNodeList = searchFrom.getChildNodes();
            this.taxArrLst = new ArrayList();
            int childNodeListLength = childNodeList.getLength();
            int counter = 0;
            while (counter < childNodeListLength) {
                Node childNode = childNodeList.item(counter);
                if (childNode.getNodeName().equalsIgnoreCase(tagName)) {
                    this.taxArrLst.add(childNode);
                }
                ++counter;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ReCalculateTax: setTaxArrLst :==>\n" + e);
            throw new ITMException(e);
        }
    }

    private int countTaxCodesFromTaxBase(String taxBase, UserInfoBean userInfo) throws ITMException {
        int taxCnt = 0;
        BaseLogger.log("2", userInfo, null, "\n==========");
        BaseLogger.log("2", userInfo, null, "  TAX_CODE       ");
        BaseLogger.log("2", userInfo, null, "===========");
        try {
            try {
                BaseLogger.log("3", userInfo, null, " Tax Base \t :" + taxBase + ":");
                String queryForTaxCode = "SELECT TAX_CODE FROM TBASSEQ WHERE TAX_BASE ='" + taxBase + "' ORDER BY SEQ_NO";
                BaseLogger.log("3", userInfo, null, " queryForTaxCode : " + queryForTaxCode);
                this.conn = this.conn == null ? (this.conn = this.getDBConnection(userInfo)) : this.conn;
                this.stmt = this.conn.createStatement();
                this.taxCodeSeqArrList = new ArrayList();
                this.rs = this.stmt.executeQuery(queryForTaxCode);
                while (this.rs.next()) {
                    ++taxCnt;
                    this.taxCodeSeqArrList.add(this.rs.getString(1));
                    BaseLogger.log("3", userInfo, null, "tax Code = " + this.rs.getString(1));
                }
                this.rs.close();
                this.stmt.close();
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception : ReCalculateTax : countTaxCodesFromTaxBase() \n ");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.conn != null) {
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return taxCnt;
    }

    private double calcAppAmtForDiffTCodes(int cntTaxCodes, String taxCode) throws ITMException {
        String taxAmtStr = null;
        BaseLogger.log("2", null, null, " Tax Code from calcAppAmtForDiffTCodes : " + taxCode);
        double taxAmt = 0.0;
        try {
            if (taxCode == null) {
                taxCode = "";
            }
            taxAmtStr = this.getElementValue(cntTaxCodes, "tax_amt", "tax_code", taxCode);
            BaseLogger.log("3", null, null, " \n Tax Amount from getElementValue in calcTaxAmt is : " + taxAmtStr);
            if (taxAmtStr != null) {
                taxAmt = Double.parseDouble(taxAmtStr.trim());
                BaseLogger.log("3", null, null, "Tax Amt is \t:" + taxAmt + ":");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, " Exception : TaxCalc : calcAppAmtForDiffTCodes : " + e);
            throw new ITMException(e);
        }
        return taxAmt;
    }

    private void setTaxNodeValue(String nodeName, String nodeValue) throws ITMException {
        Document dom = this.workingTaxNode.getOwnerDocument();
        try {
            if (nodeValue == null) {
                nodeValue = "";
            }
            boolean nodeFound = false;
            NodeList childNodeList = this.workingTaxNode.getChildNodes();
            int j = 0;
            while (j < childNodeList.getLength()) {
                Node elementNode = childNodeList.item(j);
                if (elementNode.getNodeType() == 1 && elementNode.getNodeName().equals(nodeName)) {
                    if (elementNode.getFirstChild() == null) {
                        if (nodeValue != null) {
                            Element sourceElement = dom.createElement(nodeName);
                            Text sourceText = dom.createTextNode(nodeValue);
                            sourceElement.appendChild(sourceText);
                            Node updatedNode = dom.importNode(sourceElement, true);
                            this.workingTaxNode.replaceChild(updatedNode, elementNode);
                        }
                    } else {
                        elementNode.getFirstChild().setNodeValue(nodeValue);
                    }
                    nodeFound = true;
                }
                if (nodeFound) {
                    this.taxChangeStrBuff.append("<").append(nodeName).append(">").append(nodeValue).append("</").append(nodeName).append(">");
                    break;
                }
                ++j;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, " Exception : TaxCalc : setNodeValue() \n " + e);
            throw new ITMException(e);
        }
    }

    private String getElementValueFromTaxNode(String elementName) throws ITMException {
        String elementValue = null;
        try {
            NodeList childNodeList = this.workingTaxNode.getChildNodes();
            int j = 0;
            while (j < childNodeList.getLength()) {
                Node elementNode = childNodeList.item(j);
                if (elementNode.getNodeType() == 1 && elementNode.getNodeName().equals(elementName.trim()) && elementNode.getFirstChild() != null) {
                    elementValue = elementNode.getFirstChild().getNodeValue();
                    break;
                }
                ++j;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : taxCalc : getElementValueFromTaxNode() \n" + e);
            throw new ITMException(e);
        }
        return elementValue;
    }

    private String getElementValueFromUpdatedNode(int count) throws ITMException {
        String elementValue = "";
        String updatedTaxString = "";
        try {
            Node taxNode = (Node)this.taxArrLst.get(count);
            NodeList childNodeList = taxNode.getChildNodes();
            int childNodeListLen = childNodeList.getLength();
            int i = 0;
            while (i < childNodeListLen) {
                Node elementNode = childNodeList.item(i);
                if (elementNode != null && elementNode.getNodeType() == 1 && elementNode.getNodeName().equalsIgnoreCase("tax_perc") && elementNode.getFirstChild() != null) {
                    elementValue = elementNode.getFirstChild().getNodeValue();
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : taxCalc : getElementValueFromTaxNode() \n" + e);
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "Updated value (getElementValueFromUpdatedNode) :" + elementValue + ": of count :" + count + ":");
        return elementValue;
    }

    private String getNodeValue(String NodeName) throws ITMException {
        String tagValueStr = null;
        try {
            NodeList taxElements = this.dataNode.getChildNodes();
            int j = 0;
            while (j < taxElements.getLength()) {
                Node taxElement = taxElements.item(j);
                if (taxElement.getNodeType() == 1 && taxElement.getNodeName().equals(NodeName) && taxElement.getFirstChild() != null) {
                    tagValueStr = taxElement.getFirstChild().getNodeValue();
                    break;
                }
                ++j;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : taxCalc : getNodeValue() \n" + e);
            throw new ITMException(e);
        }
        return tagValueStr;
    }

    private boolean isNodeFound(String nodeName) throws ITMException {
        boolean isFound = false;
        try {
            if (this.searchNode(this.dataNode, nodeName) != null) {
                isFound = true;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : taxCalc : getNode() \n" + e);
            throw new ITMException(e);
        }
        return isFound;
    }

    private String getElementValue(int cntTaxCodes, String elementNodeName, String tagName, String tagValue) throws ITMException {
        String elementValueStr;
        block4: {
            Node ParentNode = null;
            elementValueStr = null;
            try {
                ParentNode = this.getParentNode(cntTaxCodes, tagName.trim(), tagValue.trim());
                if (ParentNode == null) break block4;
                NodeList childNodeList = ParentNode.getChildNodes();
                int i = 0;
                while (i < childNodeList.getLength()) {
                    Node elementNode = childNodeList.item(i);
                    if (elementNode.getNodeName().equals(elementNodeName) && elementNode.getFirstChild() != null) {
                        elementValueStr = elementNode.getFirstChild().getNodeValue();
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : taxCalc : getElementValue : " + e);
                throw new ITMException(e);
            }
        }
        return elementValueStr;
    }

    private Node searchNode(Node searchFrom, String tagName) throws ITMException {
        Node currNode = null;
        try {
            NodeList childNodeList = searchFrom.getChildNodes();
            int childListLength = childNodeList.getLength();
            int iCtr = 0;
            while (iCtr < childListLength) {
                Node curChild = childNodeList.item(iCtr);
                if (curChild.getNodeName().equalsIgnoreCase(tagName)) {
                    currNode = curChild;
                    break;
                }
                ++iCtr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ReCalculateTax:searchNode :==>\n" + e);
            throw new ITMException(e);
        }
        return currNode;
    }

    private Node getParentNode(int cntTaxCodes, String elementName, String elementValue) throws ITMException {
        Node parentNode = null;
        boolean count = false;
        try {
            BaseLogger.log("3", null, null, "cntTaxCodes :" + cntTaxCodes + "\n\t elementName :" + elementName + "\n\t elementValue :" + elementValue);
            int cntForTaxArrLst = 0;
            while (cntForTaxArrLst < this.taxArrLst.size()) {
                Node taxNode = (Node)this.taxArrLst.get(cntForTaxArrLst);
                NodeList taxNodeList = taxNode.getChildNodes();
                int taxNodeListLen = taxNodeList.getLength();
                int cntForNodeList = 0;
                while (cntForNodeList < taxNodeListLen) {
                    String elementNodeValue;
                    Node elementNode = taxNodeList.item(cntForNodeList);
                    if (elementNode.getNodeType() == 1 && elementNode.getNodeName().equals(elementName) && elementNode.getFirstChild() != null && (elementNodeValue = elementNode.getFirstChild().getNodeValue()).trim().equals(elementValue.trim())) {
                        parentNode = elementNode.getParentNode();
                        break;
                    }
                    ++cntForNodeList;
                }
                ++cntForTaxArrLst;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, " Exception : Taxcalc : getParentNode() : " + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        return parentNode;
    }

    private double rndAmt(double amt, String round, double roundTo, UserInfoBean userInfo) throws ITMException {
        double rndAmt = 0.0;
        double multiplier = 1.0;
        double actualAmt = amt;
        try {
            if (amt < 0.0) {
                multiplier = -1.0;
                amt = Math.abs(amt);
            } else {
                if (amt == 0.0) {
                    return amt;
                }
                if (round.equals("N")) {
                    return amt;
                }
                if (roundTo == 0.0) {
                    return amt;
                }
            }
            String roundStr = round;
            char rnd = roundStr.charAt(0);
            double modVal = this.getMod(amt, roundTo, userInfo);
            switch (rnd) {
                case 'X': {
                    if (modVal > 0.0) {
                        rndAmt = amt - modVal + roundTo;
                        break;
                    }
                    rndAmt = amt;
                    break;
                }
                case 'P': {
                    rndAmt = amt - modVal;
                    break;
                }
                case 'R': {
                    if (modVal < roundTo / 2.0) {
                        rndAmt = amt - modVal;
                        break;
                    }
                    if (actualAmt > 0.0) {
                        rndAmt = amt - modVal + roundTo;
                        break;
                    }
                    rndAmt = amt - modVal - roundTo;
                    break;
                }
                default: {
                    rndAmt = amt;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception : TaxReCalcualtion : rndAmt() \n");
            throw new ITMException(e);
        }
        return rndAmt *= multiplier;
    }

    private String getTaxDom(Node detailNode) throws RemoteException, ITMException {
        StringBuffer taxStringBuff = new StringBuffer();
        String retString = "";
        Object taxNode = null;
        try {
            NodeList taxList = detailNode.getChildNodes();
            int taxLength = taxList.getLength();
            int count = 0;
            while (count < taxLength) {
                if (taxList.item(count).getNodeName().equals("tax_perc")) {
                    taxStringBuff.append(this.serializeDom(taxList.item(count)));
                }
                ++count;
            }
            retString = this.getNormalizedString(taxStringBuff.toString());
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception:MasterStatefulEJB: getTaxDom:" + e);
            throw new ITMException(e);
        }
        return retString;
    }

    private Document parseString(String xmlString) throws ITMException {
        Document dom = null;
        ByteArrayInputStream baos = null;
        try {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setIgnoringComments(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, CommonConstants.ENCODING);
                baos = new ByteArrayInputStream(xmlString.getBytes());
                dom = db.parse(baos);
            }
            catch (Exception e) {
                dom = null;
                BaseLogger.log("0", null, null, "Exception :MasterStatefulEJB :parseString :==>\n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                    baos = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in releasing file resource :");
                e.printStackTrace();
            }
        }
        return dom;
    }

    private String serializeDom(Node dom) throws ITMException {
        String retString = null;
        ByteArrayOutputStream out = null;
        try {
            try {
                out = new ByteArrayOutputStream();
                Transformer serializer = TransformerFactory.newInstance().newTransformer();
                serializer.setOutputProperty("omit-xml-declaration", "yes");
                serializer.setOutputProperty("encoding", CommonConstants.ENCODING);
                serializer.transform(new DOMSource(dom), new StreamResult(out));
                retString = out.toString(CommonConstants.ENCODING);
                out.flush();
                out.close();
                out = null;
            }
            catch (Exception e) {
                retString = null;
                BaseLogger.log("0", null, null, "Exception :MasterStatefulEJB :serializeDom :==>\n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in releasing file resource :]");
                e.printStackTrace();
            }
        }
        return retString;
    }

    private String getNormalizedString(String nodeString) throws ITMException {
        StringBuffer tempStringBuff = new StringBuffer();
        try {
            tempStringBuff.append("<DocumentRoot>");
            tempStringBuff.append("<description>Datawindow Root</description>");
            tempStringBuff.append("<group0>");
            tempStringBuff.append("<description>Group0 description</description>");
            tempStringBuff.append("<Header0>");
            tempStringBuff.append("<description>Header0 members</description>");
            tempStringBuff.append(nodeString);
            tempStringBuff.append("</Header0>");
            tempStringBuff.append("</group0>");
            tempStringBuff.append("</DocumentRoot>");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :MasterStatefulEJB :getNormalizedString :==>\n" + e);
            throw new ITMException(e);
        }
        return tempStringBuff.toString();
    }

    private double applyAmtFromExpr(String exprStr, String exprStrInput, String applyOperatorStr, double applyAmt) throws ITMException {
        BaseLogger.log("2", null, null, "***************************  NEW WORK BY DASH    ******************************** ");
        BaseLogger.log("2", null, null, "exprStr [" + exprStr + "]");
        BaseLogger.log("2", null, null, "exprStrInput [" + exprStrInput + "]");
        BaseLogger.log("2", null, null, "applyOperatorStr [" + applyOperatorStr + "]");
        BaseLogger.log("2", null, null, "applyAmt [" + applyAmt + "]");
        double retVal = 0.0;
        this.taxJEP = new JEP();
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            this.taxJEP.addStandardFunctions();
            this.taxJEP.addStandardConstants();
            if (exprStrInput != null && exprStrInput.length() > 0) {
                ArrayList exprStrInputList = this.getTokenList(exprStrInput, ",");
                BaseLogger.log("3", null, null, "ExprStrInputList :" + exprStrInputList);
                String firstToken = null;
                int ctr = 0;
                while (ctr < exprStrInputList.size()) {
                    String currVarName = null;
                    String currVarValue = null;
                    String varType = null;
                    String tempExprInpStr = (String)exprStrInputList.get(ctr);
                    BaseLogger.log("3", null, null, "Current Expr :[" + tempExprInpStr + "]");
                    ArrayList varDescTokenList = this.getTokenList(tempExprInpStr, ".");
                    BaseLogger.log("3", null, null, "Var Desc Token List :" + varDescTokenList);
                    if (varDescTokenList != null && varDescTokenList.size() > 0) {
                        currVarName = (String)varDescTokenList.get(varDescTokenList.size() - 1);
                        if (((String)varDescTokenList.get(0)).indexOf("[") != -1) {
                            firstToken = (String)varDescTokenList.get(0);
                            firstToken = firstToken.substring(1, firstToken.length() - 1);
                            BaseLogger.log("3", null, null, "ReCalculateTax.applyAmtFromExpr() firstToken :[" + firstToken + "]");
                            if (firstToken.toLowerCase().endsWith("_perc")) {
                                String currTaxCode = firstToken.substring(0, firstToken.indexOf("_perc"));
                                currVarValue = this.getElementValueFromTaxesNode("tax_perc", currTaxCode);
                                BaseLogger.log("3", null, null, "ReCalculateTax.applyAmtFromExpr() currVarValue in if :[" + currVarValue + "]");
                            } else {
                                currVarValue = this.getElementValueFromTaxesNode("tax_amt", firstToken);
                                BaseLogger.log("3", null, null, "ReCalculateTax.applyAmtFromExpr() currVarValue in else :[" + currVarValue + "]");
                            }
                            varType = "D";
                        } else {
                            firstToken = (String)varDescTokenList.get(0);
                            firstToken = firstToken.length() == 0 ? this.selDataObjCtx : firstToken;
                            Document detailDom = this.dataNode.getOwnerDocument();
                            String detailDomId = (String)varDescTokenList.get(1);
                            detailDomId = detailDomId.length() == 0 ? this.selDataDomId : detailDomId;
                            BaseLogger.log("3", null, null, "Form No. :[" + firstToken + "] Dom Id :[" + detailDomId + "]");
                            Node curDetail = this.searchNode(detailDom, firstToken, detailDomId);
                            currVarValue = this.getElementValueFromNode(currVarName, curDetail);
                            varType = (String)varDescTokenList.get(2);
                        }
                        BaseLogger.log("3", null, null, "Var Name :[" + currVarName + "]");
                        BaseLogger.log("3", null, null, "Var Type :[" + varType + "]");
                        BaseLogger.log("3", null, null, "Var Value :[" + currVarValue + "]");
                        Object varValue = null;
                        if (varType.equalsIgnoreCase("I")) {
                            varValue = Integer.valueOf(currVarValue == null || currVarValue.length() == 0 ? "0" : currVarValue);
                        } else if (varType.equalsIgnoreCase("N") || varType.equalsIgnoreCase("D")) {
                            varValue = Double.valueOf(currVarValue == null || currVarValue.length() == 0 ? "0" : currVarValue);
                        } else {
                            Object object = varValue = currVarValue == null ? "" : currVarValue;
                        }
                        if (varValue != null) {
                            BaseLogger.log("3", null, null, "********* Adding currVar [" + currVarName + "] with currVarValue [" + varValue.toString() + "] into taxJEP ");
                            this.taxJEP.addVariableAsObject(currVarName, varValue);
                        }
                    }
                    ++ctr;
                }
            }
            this.taxJEP.parseExpression(exprStr);
            String errStr = this.taxJEP.getErrorInfo();
            BaseLogger.log("3", null, null, "********* After parseExpression errStr [" + errStr + "]");
            String expVal = "";
            if (errStr != null) {
                expVal = errStr;
                BaseLogger.log("3", null, null, "********* Error occured during Evaluation");
            } else if (this.taxJEP.getValueAsObject() != null) {
                expVal = this.taxJEP.getValueAsObject().toString();
                retVal = Double.parseDouble(expVal == null || expVal.length() == 0 ? "0.0" : expVal);
                retVal = Double.parseDouble(genericUtility.formatDouble(retVal, 3));
                applyAmt = Double.parseDouble(genericUtility.formatDouble(applyAmt, 3));
                BaseLogger.log("3", null, null, "********* expVal [" + expVal + "]");
                BaseLogger.log("3", null, null, "********* retVal [" + retVal + "]");
                BaseLogger.log("3", null, null, "********* applyAmt [" + applyAmt + "]");
                BaseLogger.log("3", null, null, "********* applyOperatorStr [" + applyOperatorStr + "]");
                BaseLogger.log("3", null, null, "********* (applyOperatorStr.charAt(0)) [" + applyOperatorStr.charAt(0) + "]");
                if (applyOperatorStr != null && applyOperatorStr.length() > 0) {
                    switch (applyOperatorStr.charAt(0)) {
                        case 'A': {
                            retVal = applyAmt + retVal;
                            break;
                        }
                        case 'S': {
                            retVal = applyAmt - retVal;
                            break;
                        }
                        case 'M': {
                            retVal = applyAmt * retVal;
                            break;
                        }
                        case 'D': {
                            retVal = applyAmt / retVal;
                        }
                    }
                }
                BaseLogger.log("3", null, null, "********* After switch retVal [" + retVal + "]");
            } else {
                BaseLogger.log("3", null, null, "taxJEP.getValueAsObject() is null ");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : TaxCalulation : applyAmtFromFormula() \n");
            throw new ITMException(e);
        }
        return retVal;
    }

    private ArrayList getTokenList(String tokenString, String delimiter) throws Exception {
        BaseLogger.log("2", null, null, "Getting arraylist from the string :" + tokenString + ": delimiter :" + delimiter + ":");
        ArrayList<String> returnList = null;
        if (tokenString != null && tokenString.length() > 0 && tokenString != "") {
            returnList = new ArrayList<String>();
            if (delimiter.length() == 1) {
                while (tokenString.indexOf(delimiter) != -1) {
                    int endIndex = tokenString.indexOf(delimiter);
                    returnList.add(tokenString.substring(0, endIndex));
                    tokenString = tokenString.substring(endIndex + 1, tokenString.length());
                }
                returnList.add(tokenString.substring(0, tokenString.length()));
            } else if (delimiter.length() == 2 && (delimiter.equals("[]") || delimiter.equals("{}") || delimiter.equals("()"))) {
                while (tokenString.indexOf(delimiter.substring(0, 1)) != -1) {
                    int endIndex = tokenString.indexOf(delimiter.substring(1));
                    returnList.add(tokenString.substring(1, endIndex));
                    tokenString = tokenString.substring(endIndex + 1, tokenString.length());
                }
            }
        }
        return returnList;
    }

    private String getElementValueFromTaxesNode(String elementName, String taxCode) throws ITMException {
        String elementVal = "";
        try {
            Node taxNode = this.getParentNode(0, "tax_code", taxCode);
            elementVal = this.getElementValueFromNode(elementName, taxNode);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : TaxCalculation : searchNode :" + e);
            throw new ITMException(e);
        }
        return elementVal;
    }

    private String getElementValueFromNode(String elementName, Node curNode) throws ITMException {
        BaseLogger.log("2", null, null, "********* getElementValueFromNode elementName [" + elementName + "]");
        String elementVal = "";
        try {
            NodeList curNodeList = curNode.getChildNodes();
            int curNodeListLength = curNodeList.getLength();
            int ctr = 0;
            while (ctr < curNodeListLength) {
                Node curChildNode = curNodeList.item(ctr);
                if (curChildNode.getNodeName().equalsIgnoreCase(elementName) && curChildNode.getFirstChild() != null) {
                    elementVal = curChildNode.getFirstChild().getNodeValue();
                    BaseLogger.log("3", null, null, "********* getElementValueFromNode elementVal [" + elementVal + "]");
                    break;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : TaxCalculation : getElementValueFromNode :" + e);
            throw new ITMException(e);
        }
        return elementVal;
    }

    private Node searchNode(Document dom, String objContext, String nodeID) throws ITMException {
        Node detailNode = null;
        try {
            objContext = objContext == null || objContext.length() == 0 ? "1" : objContext;
            nodeID = nodeID == null || nodeID.length() == 0 ? "1" : nodeID;
            BaseLogger.log("9", null, null, "serachNode : objContext :" + objContext + "nodeID :" + nodeID + ": dom :" + dom);
            NodeList detailList = dom.getElementsByTagName("Detail" + objContext);
            int detListLength = detailList.getLength();
            int ctr = 0;
            while (ctr < detListLength) {
                Node curDetail = detailList.item(ctr);
                if (curDetail.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase(nodeID)) {
                    detailNode = curDetail;
                    break;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : TaxCalculation : searchNode :" + e);
            throw new ITMException(e);
        }
        return detailNode;
    }

    private Connection getDBConnection(UserInfoBean userInfo) throws ITMException {
        try {
            String transDB = userInfo.getTransDB();
            ConnDriver connDriver = new ConnDriver();
            this.conn = connDriver.getConnectDB(transDB);
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception : ReCalculateTax : getDBConnection() : \n" + e);
            throw new ITMException(e);
        }
        return this.conn;
    }

    private String getApplyOn(String taxBaseStr, UserInfoBean userInfo) throws ITMException {
        String applyOnStr = null;
        BaseLogger.log("2", userInfo, null, "\n================================================");
        BaseLogger.log("2", userInfo, null, "apply_on  apply_perc apply_operator  apply_formula");
        BaseLogger.log("2", userInfo, null, "==================================================\n");
        try {
            try {
                if (taxBaseStr != null) {
                    String queryForApplyOn = "SELECT APPLY_ON, APPLY_PERC, APPLY_OPERATOR, APPLY_FORMULA, TAX_EXPR, TAX_EXPR_INP FROM TAXBASE WHERE TAX_BASE ='" + taxBaseStr + "' ";
                    BaseLogger.log("3", userInfo, null, "getApplyOn : query for apply on : " + queryForApplyOn);
                    this.conn = this.conn == null ? (this.conn = this.getDBConnection(userInfo)) : this.conn;
                    this.stmt = this.conn.createStatement();
                    this.rs = this.stmt.executeQuery(queryForApplyOn);
                    this.tempVarMap = new HashMap();
                    while (this.rs.next()) {
                        this.tempVarMap.put("applyOn", this.rs.getString(1));
                        this.tempVarMap.put("applyPerc", new Double(this.rs.getDouble(2)));
                        this.tempVarMap.put("applyOperator", this.rs.getString(3));
                        this.tempVarMap.put("applyFormula", this.rs.getString(4));
                        BaseLogger.log("3", userInfo, null, String.valueOf(this.rs.getString(1)) + " \t " + this.rs.getString(2) + " \t " + this.rs.getString(3) + " \t " + this.rs.getString(4));
                        this.tempVarMap.put("exprStr", this.rs.getString(5));
                        this.tempVarMap.put("exprStrInput", this.rs.getString(6));
                    }
                    applyOnStr = (String)this.tempVarMap.get("applyOn");
                    this.rs.close();
                    this.stmt.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception : ReCalculateTax : getApplyOn() " + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                if (this.conn != null) {
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return applyOnStr;
    }

    private double getApplyAmt(String taxBaseStr, double rate, float qty, double noOfArticle, double clgRate, double disc, String rateFldStr, String qtyFldStr, UserInfoBean userInfo) throws ITMException {
        double qtyFld = 0.0;
        double rateFld = 0.0;
        double applyAmt = 0.0;
        try {
            String applyOnStr = this.getApplyOn(taxBaseStr, userInfo);
            if (applyOnStr != null) {
                applyOnStr = applyOnStr.trim();
                char applyOn = applyOnStr.charAt(0);
                BaseLogger.log("3", userInfo, null, "Before qtyFldStr :[" + qtyFldStr + "] rateFldStr :[" + rateFldStr + "]");
                boolean isQtyFieldExists = this.isNodeFound(qtyFldStr);
                boolean isRateFieldExists = this.isNodeFound(rateFldStr);
                boolean isDiscountFieldExists = this.isNodeFound("discount");
                String qtyFldValueStr = null;
                String rateFldValueStr = null;
                if (!isRateFieldExists) {
                    qtyFldValueStr = this.getNodeValue("quantity");
                    rateFldValueStr = this.getNodeValue("rate");
                } else {
                    qtyFldValueStr = this.getNodeValue(qtyFldStr);
                    rateFldValueStr = this.getNodeValue(rateFldStr);
                }
                if (qtyFldValueStr != null && !"null".equalsIgnoreCase(qtyFldValueStr) && qtyFldValueStr.trim().length() > 0) {
                    isQtyFieldExists = true;
                    qtyFld = Double.parseDouble(qtyFldValueStr.trim());
                }
                if (rateFldValueStr != null && !"null".equalsIgnoreCase(rateFldValueStr) && rateFldValueStr.trim().length() > 0) {
                    isRateFieldExists = true;
                    rateFld = Double.parseDouble(rateFldValueStr.trim());
                }
                BaseLogger.log("3", userInfo, null, "After qtyFldStr :[" + qtyFldStr + "] rateFldStr :[" + rateFldStr + "] qtyFld :[" + qtyFld + "] rateFld :[" + rateFld + "]");
                if (applyOn == 'N' && !isDiscountFieldExists) {
                    applyOn = 'G';
                }
                if (applyOn == 'T' && !isDiscountFieldExists) {
                    applyOn = 'E';
                }
                if (applyOn == 'E' && !this.isNodeFound("rate__Clg")) {
                    applyOn = 'G';
                }
                BaseLogger.log("3", userInfo, null, "Final applyOn :[" + applyOn + "]");
                switch (applyOn) {
                    case 'G': {
                        String amtFldValueStr;
                        if (!isQtyFieldExists) {
                            amtFldValueStr = this.getNodeValue("amount");
                            if (amtFldValueStr != null) {
                                applyAmt = Double.parseDouble(amtFldValueStr.trim());
                                break;
                            }
                            if (!isRateFieldExists) break;
                            BaseLogger.log("3", userInfo, null, ":ReCalculateTax:[" + isRateFieldExists + "]");
                            applyAmt = rateFld;
                            break;
                        }
                        applyAmt = qtyFld * rateFld;
                        break;
                    }
                    case 'N': {
                        String amtFldValueStr;
                        if (!isQtyFieldExists) {
                            amtFldValueStr = this.getNodeValue("amount");
                            if (amtFldValueStr != null) {
                                applyAmt = Double.parseDouble(amtFldValueStr.trim());
                            }
                        } else {
                            applyAmt = qtyFld * rateFld;
                        }
                        applyAmt -= applyAmt * (disc / 100.0);
                        break;
                    }
                    case 'R': {
                        applyAmt = rateFld;
                        break;
                    }
                    case 'Q': {
                        applyAmt = qtyFld;
                        break;
                    }
                    case 'A': {
                        applyAmt = noOfArticle;
                        break;
                    }
                    case 'E': {
                        if (!isQtyFieldExists) {
                            applyAmt = clgRate;
                            break;
                        }
                        applyAmt = qtyFld * clgRate;
                        break;
                    }
                    case 'T': {
                        applyAmt = !isQtyFieldExists ? clgRate : qtyFld * clgRate;
                        applyAmt -= applyAmt * (disc / 100.0);
                    }
                }
                if (applyAmt > 0.0) {
                    Double applyPercDbl = (Double)this.tempVarMap.get("applyPerc");
                    double applyPerc = applyPercDbl;
                    applyAmt = applyAmt * applyPerc / 100.0;
                }
                BaseLogger.log("3", userInfo, null, "Final applyAmt :[" + applyAmt + "]");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception : ReCalculateTax : getApplyAmt() " + e);
            throw new ITMException(e);
        }
        return applyAmt;
    }

    public String reCalculate(String qtyFldStr, String rateFldStr, UserInfoBean userInfo, String currCodeTranStr, String refSerStr, String taxCalcDate) throws ITMException {
        String taxChangeStr = "";
        try {
            this.userInfo = userInfo;
            this.refSerStr = refSerStr;
            E12GenericUtility genericUtility = new E12GenericUtility();
            String taxBase = null;
            String taxCode = null;
            String currCodeTaxStr = null;
            double rate = 0.0;
            float qty = 0.0f;
            double noOfArticle = 0.0;
            double clgRate = 0.0;
            double disc = 0.0;
            double applyAmt = 0.0;
            double taxAmt = 0.0;
            double taxAmtTcurr = 0.0;
            double exchRate = 0.0;
            String tempForTranDom = null;
            String objContext = this.dataNode.getAttributes().getNamedItem("objContext").getNodeValue();
            int len = this.taxArrLst.size();
            BaseLogger.log("3", userInfo, null, "reCalculate : this.taxArrLst.size() :" + this.taxArrLst.size());
            int loopCounter = 0;
            while (loopCounter < len) {
                String rateFromUPdatedNode;
                this.domIdCtr = loopCounter;
                this.workingTaxNode = (Node)this.taxArrLst.get(loopCounter);
                if (this.getElementValueFromTaxNode("tax_base") != null && this.getElementValueFromTaxNode("tax_base").length() > 0) {
                    taxBase = this.getElementValueFromTaxNode("tax_base");
                }
                BaseLogger.log("3", userInfo, null, "reCalculate : this.taxBase :[" + taxBase + "]");
                currCodeTranStr = E12GenericUtility.checkNull(currCodeTranStr);
                if (this.getElementValueFromTaxNode("tax_code") != null && this.getElementValueFromTaxNode("tax_code").length() > 0) {
                    taxCode = this.getElementValueFromTaxNode("tax_code");
                    BaseLogger.log("3", userInfo, null, "reCalculate : this.taxCode :[" + taxCode + "]");
                    DBAccessEJB dbAccessEJB = new DBAccessEJB();
                    currCodeTaxStr = E12GenericUtility.checkNull(dbAccessEJB.getDBColumnValue("TAX", "CURR_CODE", "TAX_CODE='" + taxCode + "'", userInfo.getTransDB()));
                    BaseLogger.log("3", userInfo, null, "reCalculate : currCodeTaxStr :[" + currCodeTaxStr + "]");
                    BaseLogger.log("3", userInfo, null, "reCalculate : currCodeTranStr :[" + currCodeTranStr + "]");
                }
                if (currCodeTaxStr == null || "".equals(currCodeTaxStr)) {
                    currCodeTaxStr = currCodeTranStr;
                }
                if ((rateFromUPdatedNode = this.getElementValueFromUpdatedNode(loopCounter)) != null && rateFromUPdatedNode.length() > 0) {
                    rate = Double.parseDouble(rateFromUPdatedNode);
                }
                BaseLogger.log("3", userInfo, null, "Danish : rate :" + rate + ": loopCounter :" + loopCounter + ":");
                tempForTranDom = this.getNodeValue("rate");
                if (tempForTranDom != null && !tempForTranDom.equals("")) {
                    rate = Double.parseDouble(tempForTranDom);
                    BaseLogger.log("3", userInfo, null, "first time rate  :" + rate);
                }
                tempForTranDom = null;
                if (!currCodeTranStr.equals(currCodeTaxStr)) {
                    exchRate = this.getExchangeRate(currCodeTranStr, currCodeTaxStr, userInfo.getSiteCode(), taxCalcDate, " ");
                    BaseLogger.log("3", userInfo, null, "Exchange Rate from master:[" + exchRate + "]");
                }
                if ((tempForTranDom = this.getNodeValue("quantity")) != null && !tempForTranDom.equals("")) {
                    qty = Float.parseFloat(tempForTranDom);
                }
                tempForTranDom = null;
                tempForTranDom = this.getNodeValue("no_art");
                if (tempForTranDom != null && !tempForTranDom.equals("")) {
                    noOfArticle = Double.parseDouble(tempForTranDom);
                }
                tempForTranDom = null;
                if (this.getNodeValue("rate__clg") != null && this.getNodeValue("rate__clg").length() > 0) {
                    tempForTranDom = this.getNodeValue("rate__clg");
                }
                if (tempForTranDom != null && !tempForTranDom.equals("")) {
                    clgRate = Double.parseDouble(tempForTranDom);
                }
                tempForTranDom = null;
                tempForTranDom = this.getNodeValue("discount");
                if (tempForTranDom != null && !tempForTranDom.equals("")) {
                    disc = Double.parseDouble(tempForTranDom);
                }
                if (taxBase == null) {
                    BaseLogger.log("3", userInfo, null, " taxBase is null");
                    break;
                }
                applyAmt = this.getApplyAmt(taxBase, rate, qty, noOfArticle, clgRate, disc, qtyFldStr, rateFldStr, userInfo);
                BaseLogger.log("3", userInfo, null, "Apply Amount : " + applyAmt);
                int taxCnt = this.countTaxCodesFromTaxBase(taxBase, userInfo);
                BaseLogger.log("3", userInfo, null, "tax Count  : " + taxCnt);
                BaseLogger.log("3", userInfo, null, "taxCodeSeqArrList : \t " + this.taxCodeSeqArrList);
                int j = 0;
                while (j < taxCnt) {
                    BaseLogger.log("3", userInfo, null, "calcAppAmtForDiffTCodes() called ...... ");
                    applyAmt += this.calcAppAmtForDiffTCodes(loopCounter, (String)this.taxCodeSeqArrList.get(j));
                    ++j;
                }
                BaseLogger.log("3", userInfo, null, "Apply Amount after function calling : " + applyAmt);
                String formulaStr = (String)this.tempVarMap.get("applyFormula");
                String funcArgExprStr = (String)this.tempVarMap.get("exprStr");
                String funcArgExprStrInput = (String)this.tempVarMap.get("exprStrInput");
                String funcArgApplyOpertorStr = (String)this.tempVarMap.get("applyOperator");
                double formulaAmt = 0.0;
                BaseLogger.log("3", userInfo, null, "Condition formula formulaStr :" + formulaStr + ":\n");
                if (funcArgExprStr != null && funcArgExprStr.length() > 0) {
                    applyAmt = this.applyAmtFromExpr(funcArgExprStr, funcArgExprStrInput, funcArgApplyOpertorStr, applyAmt);
                    BaseLogger.log("3", null, null, "After applyAmtFromExpr applyAmt [" + applyAmt + "]");
                }
                this.setTaxNodeValue("taxable_amt", genericUtility.formatDouble(applyAmt, 3));
                String round = this.getElementValueFromTaxNode("round");
                double roundTo = 1.0;
                if (this.getElementValueFromTaxNode("round_to") != null && this.getElementValueFromTaxNode("round_to").length() > 0) {
                    roundTo = Double.parseDouble(this.getElementValueFromTaxNode("round_to"));
                }
                String rateType = "";
                if (this.getElementValueFromTaxNode("rate_type") != null && this.getElementValueFromTaxNode("rate_type").length() > 0) {
                    rateType = this.getElementValueFromTaxNode("rate_type");
                }
                if (this.getElementValueFromUpdatedNode(loopCounter) != null && this.getElementValueFromUpdatedNode(loopCounter).length() > 0) {
                    rate = Double.parseDouble(this.getElementValueFromUpdatedNode(loopCounter));
                }
                BaseLogger.log("3", userInfo, null, "rate :  " + rate);
                char rateTypeChar = rateType.charAt(0);
                if (rateTypeChar == 'P') {
                    taxAmt = applyAmt * rate / 100.0;
                    BaseLogger.log("3", userInfo, null, "taxable amt is : " + taxAmt);
                } else if (rateTypeChar == 'F') {
                    taxAmt = rate;
                } else if (rateTypeChar == 'S') {
                    BaseLogger.log("3", userInfo, null, "ReCalculateTax.reCalculate() 1985 taxamt : [" + taxAmt + "]");
                    BaseLogger.log("3", userInfo, null, "ReCalculateTax.reCalculate() 1985 rate : [" + rate + "]");
                    BaseLogger.log("3", userInfo, null, "ReCalculateTax.reCalculate() 1985 qtyFldStr : [" + qtyFldStr + "]");
                    taxAmt = rate;
                    String qtyFldValueStr = null;
                    double qtyVal = 0.0;
                    boolean isQtyFieldExists = this.isNodeFound(qtyFldStr);
                    qtyFldValueStr = !isQtyFieldExists ? this.getNodeValue("quantity") : this.getNodeValue(qtyFldStr);
                    if (qtyFldValueStr != null && qtyFldValueStr.trim().length() > 0) {
                        qtyVal = Double.parseDouble(qtyFldValueStr.trim());
                    }
                    BaseLogger.log("3", userInfo, null, "ReCalculateTax.reCalculate() 1985 quantity : [" + qtyVal + "]");
                    if (qtyVal < 0.0) {
                        taxAmt *= -1.0;
                    }
                    BaseLogger.log("3", userInfo, null, "ReCalculateTax.reCalculate() 1985 taxamt for type S : [" + taxAmt + "]");
                } else {
                    taxAmt = applyAmt * rate;
                }
                if (exchRate > 0.0 && currCodeTaxStr != null && !"".equals(currCodeTaxStr) && !currCodeTaxStr.equals(currCodeTranStr)) {
                    double exchRateTran = 1.0 / exchRate;
                    taxAmtTcurr = taxAmt * exchRateTran;
                } else {
                    taxAmtTcurr = taxAmt;
                }
                taxAmtTcurr = this.rndAmt(taxAmtTcurr, round, roundTo, userInfo);
                BaseLogger.log("3", userInfo, null, "recalculationtax:taxAmtTcurr:[" + taxAmtTcurr + "]");
                taxAmt = this.rndAmt(taxAmt, round, roundTo, userInfo);
                String effect = "";
                if (this.getElementValueFromTaxNode("effect") != null && this.getElementValueFromTaxNode("effect").length() > 0) {
                    effect = this.getElementValueFromTaxNode("effect");
                }
                if (effect.trim().equals("-") && rate > 0.0) {
                    BaseLogger.log("3", userInfo, null, "Condition 1");
                    rate *= -1.0;
                }
                if (effect.trim().equals("-") && taxAmt > 0.0) {
                    BaseLogger.log("3", userInfo, null, "Condition 2");
                    taxAmt *= -1.0;
                    taxAmtTcurr *= -1.0;
                }
                if (effect != null && !effect.trim().equalsIgnoreCase("N")) {
                    BaseLogger.log("3", userInfo, null, "effect In :[" + effect + "]");
                    this.totalTax = currCodeTaxStr != null && !"".equals(currCodeTaxStr) && !currCodeTaxStr.equals(currCodeTranStr) ? (this.totalTax += taxAmtTcurr) : (this.totalTax += taxAmt);
                    this.totalTax = this.rndAmt(this.totalTax, "R", 0.001, userInfo);
                }
                this.setTaxNodeValue("tax_perc", new Double(rate).toString());
                if (currCodeTaxStr != null && !"".equals(currCodeTaxStr) && !currCodeTaxStr.equals(currCodeTranStr)) {
                    this.setTaxNodeValue("tax_amt", genericUtility.formatDouble(taxAmtTcurr, 3));
                    this.setTaxNodeValue("tax_amt__tcurr", genericUtility.formatDouble(taxAmt, 3));
                } else {
                    this.setTaxNodeValue("tax_amt", genericUtility.formatDouble(taxAmt, 3));
                    this.setTaxNodeValue("tax_amt__tcurr", genericUtility.formatDouble(taxAmtTcurr, 3));
                }
                double recoPerc = 0.0;
                double recoAmt = 0.0;
                if (this.getElementValueFromTaxNode("reco_perc") != null) {
                    String recoPercStr = this.getElementValueFromTaxNode("reco_perc");
                    BaseLogger.log("3", userInfo, null, "ReCalculateTax.reCalculate() : recoPercStr :[" + recoPercStr + "]");
                    if (!"".equals(E12GenericUtility.checkNull(recoPercStr))) {
                        Double recoPercDbl = Double.valueOf(recoPercStr);
                        recoPerc = recoPercDbl;
                        BaseLogger.log("3", userInfo, null, "ReCalculateTax.reCalculate() : recoPerc :[" + recoPerc + "]");
                    }
                }
                if (recoPerc > 0.0) {
                    recoAmt = currCodeTaxStr != null && !"".equals(currCodeTaxStr) && !currCodeTaxStr.equals(currCodeTranStr) ? taxAmtTcurr * recoPerc / 100.0 : taxAmt * recoPerc / 100.0;
                    recoAmt = this.rndAmt(taxAmt, round, roundTo, userInfo);
                    this.setTaxNodeValue("reco_amount", Double.toString(recoAmt));
                    BaseLogger.log("3", null, null, "ReCalculateTax.reCalculate() : Recovery Percentage : " + recoPerc);
                    BaseLogger.log("3", null, null, "ReCalculateTax.reCalculate() : Recovery Amount : " + recoAmt);
                }
                String taxForm = this.getTaxFormValDataNode("" + (this.domIdCtr + 1));
                BaseLogger.log("3", userInfo, null, "Setting taxForm as [" + taxForm + "] for DomID [" + (this.domIdCtr + 1) + "] ");
                this.setTaxNodeValue("tax_form", taxForm);
                taxChangeStr = String.valueOf(taxChangeStr) + "<Tax domID='" + ++this.domIdCtr + "' ><attribute pkNames='' selected='N' status='O' updateFlag='A'/>" + this.taxChangeStrBuff.toString() + "</Tax>";
                this.taxChangeStrBuff.delete(0, this.taxChangeStrBuff.length());
                ++loopCounter;
            }
            if (taxChangeStr.length() > 0) {
                Node dataDomTaxesNode;
                String totTaxStr = genericUtility.formatDouble(this.totalTax, 3);
                Node dataDomTaxAmtNode = this.searchNode(this.dataNode, "tax_amt");
                if (dataDomTaxAmtNode != null && dataDomTaxAmtNode.getFirstChild() != null) {
                    dataDomTaxAmtNode.getFirstChild().setNodeValue(totTaxStr);
                }
                if ((dataDomTaxesNode = this.searchNode(this.dataNode, "Taxes")) != null && dataDomTaxesNode.getAttributes().getNamedItem("status") != null) {
                    dataDomTaxesNode.getAttributes().getNamedItem("status").setNodeValue("N");
                }
                taxChangeStr = "<Root><Detail" + this.selDataObjCtx + " domID='" + this.selDataDomId + "'><tax_amt>" + totTaxStr + "</tax_amt><Taxes status='O'>" + taxChangeStr + "</Taxes></Detail" + this.selDataObjCtx + "></Root>";
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception : taxCalc : reCalculate() \n" + e);
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "ReCalculateTax : taxChangeStr :" + taxChangeStr);
        return taxChangeStr;
    }

    private String getTaxFormValDataNode(String domID) {
        String taxForm;
        block8: {
            taxForm = "";
            try {
                NodeList taxNodeList = this.updatedTaxNode.getChildNodes();
                int len = taxNodeList.getLength();
                int ctr = 0;
                while (ctr < len) {
                    Node currNode = taxNodeList.item(ctr);
                    if (currNode != null && currNode.getAttributes() != null && currNode.getAttributes().getNamedItem("domID") != null) {
                        String currDomID = currNode.getAttributes().getNamedItem("domID").getNodeValue();
                        BaseLogger.log("3", null, null, "currDomID [" + currDomID + "] domID [" + domID + "]");
                        if (currDomID != null && currDomID.equalsIgnoreCase(domID)) {
                            NodeList childNL = currNode.getChildNodes();
                            int childNLLen = childNL.getLength();
                            int locCtr = 0;
                            while (locCtr < childNLLen) {
                                String nodeName;
                                Node childNode = childNL.item(locCtr);
                                if (childNode != null && (nodeName = childNode.getNodeName()) != null && nodeName.equalsIgnoreCase("tax_form")) {
                                    taxForm = childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : childNode.getNodeValue();
                                    if (taxForm == null || "null".equalsIgnoreCase(taxForm)) {
                                        taxForm = "";
                                    }
                                    break block8;
                                }
                                ++locCtr;
                            }
                            break;
                        }
                    }
                    ++ctr;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return taxForm;
    }

    private double getMod(double val1, double val2, UserInfoBean userInfo) throws Exception {
        Statement stmtLocal = null;
        ResultSet rsLocal = null;
        double modVal = -1.0;
        try {
            try {
                String qryStr = "SELECT MOD(" + val1 + ", " + val2 + ") FROM DUAL";
                if ("MSSQL".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                    qryStr = "SELECT " + val1 + "%" + val2 + " ";
                }
                this.conn = this.conn == null ? (this.conn = this.getDBConnection(userInfo)) : this.conn;
                stmtLocal = this.conn.createStatement();
                BaseLogger.log("3", userInfo, null, "qryStr [" + qryStr + "]");
                rsLocal = stmtLocal.executeQuery(qryStr);
                while (rsLocal.next()) {
                    modVal = rsLocal.getDouble(1);
                }
                rsLocal.close();
                rsLocal = null;
                stmtLocal.close();
                stmtLocal = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :TaxReCalculation: getMod :==>\n" + e);
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            try {
                if (stmtLocal != null) {
                    stmtLocal.close();
                    stmtLocal = null;
                }
                if (this.conn != null) {
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return modVal;
    }

    private double getExchangeRate(String currCodeTranStr, String currCodeStr, String loginSiteStr, String taxCalcDate, String asType) throws ITMException {
        double lc_exch_rate;
        block60: {
            BaseLogger.log("2", this.userInfo, null, "Recalculate.getExchangeRate() currCodeTranStr : [" + currCodeTranStr + "]");
            BaseLogger.log("2", this.userInfo, null, "Recalculate.getExchangeRate() currCodeStr : [" + currCodeStr + "]");
            BaseLogger.log("2", this.userInfo, null, "Recalculate.getExchangeRate() loginSiteStr : [" + loginSiteStr + "]");
            BaseLogger.log("2", this.userInfo, null, "Recalculate.getExchangeRate() taxCalcDate : [" + taxCalcDate + "]");
            BaseLogger.log("2", this.userInfo, null, "Recalculate.getExchangeRate() asType : [" + asType + "]");
            BaseLogger.log("2", this.userInfo, null, "Recalculate.getExchangeRate() refSerStr : [" + this.refSerStr + "]");
            String ls_fin_entity = "";
            String ls_curr_code__to = "";
            String var_value = "";
            String type = "";
            lc_exch_rate = 0.0;
            String sql = "";
            Statement stmtInner = null;
            Statement pstmt = null;
            Statement pstmt1 = null;
            ResultSet rs = null;
            ResultSet rs1 = null;
            Timestamp tranDate = null;
            E12GenericUtility genericUtility = new E12GenericUtility();
            try {
                Connection connection = this.conn = this.conn == null ? (this.conn = this.getDBConnection(this.userInfo)) : this.conn;
                if (currCodeTranStr.trim().equalsIgnoreCase(currCodeStr.trim())) {
                    return 1.0;
                }
                try {
                    if (taxCalcDate != null && taxCalcDate.length() > 0) {
                        taxCalcDate = genericUtility.getValidDateString(taxCalcDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
                        tranDate = Timestamp.valueOf(String.valueOf(taxCalcDate) + " 00:00:00");
                    } else {
                        Date todayDate = new Date(System.currentTimeMillis());
                        taxCalcDate = genericUtility.getValidDateString(todayDate.toString(), "yyyy-MM-dd", genericUtility.getDBDateFormat());
                        tranDate = Timestamp.valueOf(String.valueOf(taxCalcDate) + " 00:00:00");
                    }
                    if (currCodeStr.equals("")) {
                        try {
                            sql = "SELECT FIN_ENTITY FROM SITE WHERE SITE_CODE ='" + loginSiteStr.trim() + "'";
                            PreparedStatement stmt = this.conn.prepareStatement(sql);
                            rs = stmt.executeQuery();
                            if (rs.next() && (rs = (stmtInner = this.conn.prepareStatement(sql = "SELECT CURR_CODE FROM FINENT WHERE FIN_ENTITY = '" + (ls_fin_entity = rs.getString(1)).trim() + "'")).executeQuery()).next()) {
                                ls_curr_code__to = rs.getString(1);
                            }
                            stmt.close();
                            stmt = null;
                            rs.close();
                            rs = null;
                        }
                        catch (Exception e) {
                            BaseLogger.log("0", null, null, "Exception :: [][getDailyExchRateSellBuy] ::" + e);
                        }
                    } else {
                        ls_curr_code__to = currCodeStr;
                    }
                    String exchRateColName = "";
                    if (this.refSerStr != null && this.refSerStr.length() > 0) {
                        exchRateColName = this.refSerStr.trim().equalsIgnoreCase("VOUCH") || this.refSerStr.trim().equalsIgnoreCase("DRNPAY") || this.refSerStr.trim().equalsIgnoreCase("P-ORD") || this.refSerStr.trim().equalsIgnoreCase("P-RCP") || this.refSerStr.trim().equalsIgnoreCase("P-RET") || this.refSerStr.trim().equalsIgnoreCase("P-CON") || this.refSerStr.trim().equalsIgnoreCase("D-RCP") || this.refSerStr.trim().equalsIgnoreCase("P-ADV") || this.refSerStr.trim().equalsIgnoreCase("P-AMD") || this.refSerStr.trim().equalsIgnoreCase("P-RET") || this.refSerStr.trim().equalsIgnoreCase("M-VOUC") ? "EXCH_RATE__BUY" : (this.refSerStr.trim().equalsIgnoreCase("S-DSP") || this.refSerStr.trim().equalsIgnoreCase("S-INV") || this.refSerStr.trim().equalsIgnoreCase("S-ORD") || this.refSerStr.trim().equalsIgnoreCase("S-AMD") || this.refSerStr.trim().equalsIgnoreCase("D-ORD") || this.refSerStr.trim().equalsIgnoreCase("D-ISS") || this.refSerStr.trim().equalsIgnoreCase("MDRCRC") || this.refSerStr.trim().equalsIgnoreCase("MDRCRD") || this.refSerStr.trim().equalsIgnoreCase("RCP") ? "EXCH_RATE__SELL" : "EXCH_RATE");
                    }
                    BaseLogger.log("2", this.userInfo, null, "Recalculate.getExchangeRate() exchRateColName : [" + exchRateColName + "]");
                    try {
                        try {
                            sql = "SELECT " + exchRateColName + " FROM DAILY_EXCH_RATE_SELL_BUY WHERE CURR_CODE = '" + currCodeTranStr.trim() + "' AND CURR_CODE__TO = '" + ls_curr_code__to.trim() + "' AND ? BETWEEN FROM_DATE AND TO_DATE";
                            pstmt = this.conn.prepareStatement(sql);
                            pstmt.setTimestamp(1, tranDate);
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                lc_exch_rate = rs.getDouble(1);
                                BaseLogger.log("2", this.userInfo, null, "Recalculate.getExchangeRate() lc_exch_rate 3967 : [" + lc_exch_rate + "]");
                            }
                            if (lc_exch_rate == 0.0) {
                                sql = "SELECT " + exchRateColName + " FROM DAILY_EXCH_RATE_SELL_BUY WHERE CURR_CODE = '" + ls_curr_code__to.trim() + "' AND CURR_CODE__TO = '" + currCodeTranStr.trim() + "' AND ? BETWEEN FROM_DATE AND TO_DATE";
                                pstmt1 = this.conn.prepareStatement(sql);
                                pstmt1.setTimestamp(1, tranDate);
                                rs1 = pstmt1.executeQuery();
                                if (rs1.next()) {
                                    lc_exch_rate = rs1.getDouble(1);
                                    BaseLogger.log("2", this.userInfo, null, "Recalculate.getExchangeRate() lc_exch_rate 3979  : [" + lc_exch_rate + "]");
                                    if (lc_exch_rate != 0.0) {
                                        lc_exch_rate = 1.0 / lc_exch_rate;
                                        BaseLogger.log("2", this.userInfo, null, "Recalculate.getExchangeRate() lc_exch_rate 3983 : [" + lc_exch_rate + "]");
                                    }
                                }
                                rs1.close();
                                rs1 = null;
                                pstmt1.close();
                                pstmt1 = null;
                            }
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                        }
                        catch (SQLException e) {
                            BaseLogger.log("0", null, null, "Exception :: [][getDailyExchRateSellBuy]" + sql + e);
                            e.printStackTrace();
                            throw new ITMException(e);
                        }
                        catch (Exception ex) {
                            BaseLogger.log("0", null, null, "Exception []::" + ex.getMessage());
                            ex.printStackTrace();
                            throw new ITMException(ex);
                        }
                    }
                    finally {
                        try {
                            if (pstmt != null) {
                                pstmt.close();
                                pstmt = null;
                            }
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                            if (pstmt1 != null) {
                                pstmt1.close();
                                pstmt1 = null;
                            }
                            if (rs1 != null) {
                                rs1.close();
                                rs1 = null;
                            }
                            if (stmtInner != null) {
                                stmtInner.close();
                                stmtInner = null;
                            }
                        }
                        catch (Exception e) {
                            BaseLogger.log("0", null, null, "Exception []" + e.getMessage() + ":");
                        }
                    }
                    if (lc_exch_rate != 0.0) break block60;
                    try {
                        try {
                            sql = "SELECT EXCH_RATE FROM DAILY_EXCH_RATE_SELL_BUY WHERE CURR_CODE = '" + currCodeTranStr.trim() + "' AND CURR_CODE__TO = '" + ls_curr_code__to.trim() + "' AND ? BETWEEN FROM_DATE AND TO_DATE";
                            pstmt = this.conn.prepareStatement(sql);
                            pstmt.setTimestamp(1, tranDate);
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                lc_exch_rate = rs.getDouble(1);
                                BaseLogger.log("2", this.userInfo, null, "Recalculate.getExchangeRate() lc_exch_rate 4045 : [" + lc_exch_rate + "]");
                            }
                            if (lc_exch_rate == 0.0) {
                                sql = "SELECT EXCH_RATE FROM DAILY_EXCH_RATE_SELL_BUY WHERE CURR_CODE = '" + ls_curr_code__to.trim() + "' AND CURR_CODE__TO = '" + currCodeTranStr.trim() + "' AND ? BETWEEN FROM_DATE AND TO_DATE";
                                pstmt1 = this.conn.prepareStatement(sql);
                                pstmt1.setTimestamp(1, tranDate);
                                rs1 = pstmt1.executeQuery();
                                if (rs1.next()) {
                                    lc_exch_rate = rs1.getDouble(1);
                                    BaseLogger.log("2", this.userInfo, null, "Recalculate.getExchangeRate() lc_exch_rate 4056 : [" + lc_exch_rate + "]");
                                    if (lc_exch_rate != 0.0) {
                                        lc_exch_rate = 1.0 / lc_exch_rate;
                                        BaseLogger.log("2", this.userInfo, null, "Recalculate.getExchangeRate() lc_exch_rate 4060 : [" + lc_exch_rate + "]");
                                    }
                                }
                                rs1.close();
                                rs1 = null;
                                pstmt1.close();
                                pstmt1 = null;
                            }
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                        }
                        catch (SQLException e) {
                            BaseLogger.log("0", null, null, "Exception ::[][getDailyExchRateSellBuy]" + sql + e);
                            e.printStackTrace();
                            throw new ITMException(e);
                        }
                        catch (Exception ex) {
                            BaseLogger.log("0", null, null, "Exception []::" + ex.getMessage());
                            ex.printStackTrace();
                            throw new ITMException(ex);
                        }
                    }
                    finally {
                        try {
                            if (pstmt != null) {
                                pstmt.close();
                                pstmt = null;
                            }
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                            if (pstmt1 != null) {
                                pstmt1.close();
                                pstmt1 = null;
                            }
                            if (rs1 != null) {
                                rs1.close();
                                rs1 = null;
                            }
                        }
                        catch (Exception e) {
                            BaseLogger.log("0", null, null, "Exception []" + e.getMessage() + ":");
                        }
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "ReCalculate:getExchangeRate:Exception []::" + e.getMessage());
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
            finally {
                try {
                    if (this.conn != null) {
                        this.conn.close();
                        this.conn = null;
                    }
                }
                catch (Exception e) {
                    throw new ITMException(e);
                }
            }
        }
        return lc_exch_rate;
    }
}

