package ibase.scheduler.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import ibase.utility.CommonConstants;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;

import ibase.scheduler.bean.SchedulerBean;
import ibase.scheduler.ejb.ScheduleInfoEJB;
import ibase.scheduler.ejb.ScheduleInfoRemote;
import ibase.scheduler.ejb.SchedulerEJB;
import ibase.scheduler.ejb.SchedulerRemote;
import ibase.scheduler.utility.ScheduleUtility;
import ibase.servlet.AuthenticateServlet;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;

public class ScheduleInfoServlet extends AuthenticateServlet
{
	
	private static final long serialVersionUID = 1L;
	String BACKGROUND_JOB_SERVER="";
	SchedulerEJB ejb=new SchedulerEJB();
	static boolean IS_SERVER_START = false;
	ScheduleInfoServlet schedule=new ScheduleInfoServlet();

	
	protected void doGet( HttpServletRequest request, HttpServletResponse response )throws ServletException
    {
		 doPost(request, response);
    }

	public void doPost( HttpServletRequest request, HttpServletResponse response )throws ServletException
	{
		HttpSession sess= request.getSession();
		BaseLogger.log("2",null,null,"ScheduleInfoServlet called------------------------------");
		String responseStr = null;
		SchedulerBean schedulerbean = (SchedulerBean)sess.getAttribute("schedulerBean");
		try
		{
			boolean toRespond = true;
			if( Boolean.valueOf( authenticate( request ) ).booleanValue() )
			{
				UserInfoBean userInfo = ( UserInfoBean ) request.getSession().getAttribute( "USER_INFO" );// Added by Sachin Satre on [08-Feb-19]
				String scheduleId = request.getParameter( "SCHEDULE_ID" );
				String actionStr =	 request.getParameter( "ACTION" );
				String schdlXmlString =	 request.getParameter( "SCHXMLSTRING" );
				String owner =  request.getParameter( "OWNER" );
				String activity_Name = request.getParameter( "ACTIVITY_NAME" );
				String pgContx = request.getParameter( "PAGECONTX" );
				if( scheduleId == null || scheduleId.trim().length() <= 0)
				{
					scheduleId = request.getParameter( "DB_ID" );
				}
				System.out.print("--scheduleId["+scheduleId+"]--actionStr["+actionStr+"]--schdlXmlString["+schdlXmlString+"]--owner["+owner+"]");
				System.out.print("--activity_Name["+activity_Name+"]--pgContx["+pgContx+"]::userInfo::["+userInfo+"]");
				if( actionStr.equalsIgnoreCase( "START" ) )
				{	// changes by madhup 29/01/07
					BaseLogger.log("3",null,null, "Inside START..27 :::::::::: "+schdlXmlString);
					if(!schdlXmlString.equalsIgnoreCase( "AllSumMode"))
					{
						System.out.print("--In if condition !schdlXmlString.equalsIgnoreCase(AllSumMode)--");
						if( ! ScheduleUtility.getInstance().checkDateSchedule( schdlXmlString ) )
						{
							BaseLogger.log("3",null,null, "Inside START..29");
							System.out.print("--In if if  condition !schdlXmlString.equalsIgnoreCase(AllSumMode)--");
							//getScheduleInfoComp().updateSchedule( scheduleId , schdlXmlString );
							String getOwner = getSchedulerComp().getSchedulerOwner( scheduleId , userInfo ) ; //Added By Nilesh Start :: 22-05-19
							System.out.print(" getOwner :: "+ getOwner);
							int userlevel = getSchedulerComp().getUserLevel( getOwner , userInfo ); 
							System.out.print(" userlevel :: "+ userlevel);
							System.out.print(" userInfo :: "+ userInfo.getUserLevel());
							String loginUsrLev = userInfo.getUserLevel();
							if(!loginUsrLev.equalsIgnoreCase("0") && userlevel==0)
							{
								BaseLogger.log("3",null,null, "Inside START..30");
								responseStr= String.valueOf(userlevel);
							}
							else
							{	
								BaseLogger.log("3",null,null, "Inside START..31");
								getScheduleInfoComp().updateSchedule( scheduleId , schdlXmlString ,userInfo ); // Changed by Sachin Satre on [08-feb-19]
								//responseStr = getSchedulerComp().startSchedule( scheduleId );
								responseStr = getSchedulerComp().startSchedule( scheduleId ,userInfo ); // Changed by Sachin Satre on [08-feb-19]
							}	
						}
						else
						{
							BaseLogger.log("3",null,null, "Inside START..32");
							System.out.print("--In else condition !schdlXmlString.equalsIgnoreCase(AllSumMode)--");
							//Changed By Madhup On 13/07/07 For Shecheduler while registring.Start
							//responseStr = "<Errors><error id='' type='E' column_name=''><message>Start Date can't be less than current date.</message><description></description><type></type><option></option></error></Errors>";
							String getOwner = getSchedulerComp().getSchedulerOwner( scheduleId , userInfo ) ; //Added By Nilesh Start :: 22-05-19
							System.out.print(" getOwner :: "+ getOwner);
							int userlevel = getSchedulerComp().getUserLevel( getOwner , userInfo ); 
							System.out.print(" userlevel :: "+ userlevel);
							System.out.print(" userInfo :: "+ userInfo.getUserLevel());
							String loginUsrLev = userInfo.getUserLevel();
							if(!loginUsrLev.equalsIgnoreCase("0") && userlevel==0)
							{
								BaseLogger.log("3",null,null, "Inside START..33");
								responseStr= String.valueOf(userlevel);
							}
							else
							{	
								BaseLogger.log("3",null,null, "Inside START..34");
								schdlXmlString = ScheduleUtility.getInstance().updateXml(schdlXmlString);
								//getScheduleInfoComp().updateSchedule( scheduleId , schdlXmlString );
								getScheduleInfoComp().updateSchedule( scheduleId , schdlXmlString ,userInfo );// Changed by Sachin Satre on [08-feb-19]
								//responseStr = getSchedulerComp().startSchedule( scheduleId );
								responseStr = getSchedulerComp().startSchedule( scheduleId ,userInfo );// Changed by Sachin Satre on [08-feb-19]
							}	
							//Changed By Madhup On 13/07/07 For Shecheduler while registring.End
						}
					}
					else
					{
						System.out.print("--In else condition !schdlXmlString.equalsIgnoreCase(AllSumMode)--");
						String schXmlStr = getScheduleInfoComp().getScheduleModelStr( scheduleId );
						if(! ScheduleUtility.getInstance().checkDateSchedule( schXmlStr ))
						{
							BaseLogger.log("3",null,null, "Inside START..35");
							System.out.print("--In if else condition !schdlXmlString.equalsIgnoreCase(AllSumMode)--");
							//responseStr = getSchedulerComp().startSchedule( scheduleId );
							String getOwner = getSchedulerComp().getSchedulerOwner( scheduleId , userInfo ) ; //Added By Nilesh Start :: 22-05-19
							System.out.print(" getOwner :: "+ getOwner);
							int userlevel = getSchedulerComp().getUserLevel( getOwner , userInfo ); 
							System.out.print(" userlevel :: "+ userlevel);
							System.out.print(" userInfo :: "+ userInfo.getUserLevel());
							String loginUsrLev = userInfo.getUserLevel();
							if(!loginUsrLev.equalsIgnoreCase("0") && userlevel==0)
							{
								responseStr= String.valueOf(userlevel);
							}
							else
							{	
								responseStr = getSchedulerComp().startSchedule( scheduleId ,userInfo );
							}	
						}
						else
						{
							System.out.print("--In else else condition !schdlXmlString.equalsIgnoreCase(AllSumMode)--");
							//Changed By Madhup On 13/07/07 For Shecheduler while registring.Start
							//responseStr = "<Errors><error id='' type='E' column_name=''><message>Start Date can't be less than current date.</message><description></description><type></type><option></option></error></Errors>";
							String getOwner = getSchedulerComp().getSchedulerOwner( scheduleId , userInfo ) ; //Added By Nilesh Start :: 22-05-19
							System.out.print(" getOwner :: "+ getOwner);
							int userlevel = getSchedulerComp().getUserLevel( getOwner , userInfo ); 
							System.out.print(" userlevel :: "+ userlevel);
							System.out.print(" userInfo :: "+ userInfo.getUserLevel());
							String loginUsrLev = userInfo.getUserLevel();
							if(!loginUsrLev.equalsIgnoreCase("0") && userlevel==0)
							{
								responseStr= String.valueOf(userlevel);
							}
							schdlXmlString = ScheduleUtility.getInstance().updateXml(schdlXmlString);
							//getScheduleInfoComp().updateSchedule( scheduleId , schdlXmlString );
							getScheduleInfoComp().updateSchedule( scheduleId , schdlXmlString ,userInfo );// Changed by Sachin Satre on [08-feb-19]
							//responseStr = getSchedulerComp().startSchedule( scheduleId );
							responseStr = getSchedulerComp().startSchedule( scheduleId ,userInfo );// Changed by Sachin Satre on [08-feb-19]);
							//Changed By Madhup On 13/07/07 For Shecheduler while registring.End
						}
					}
					// end changes
				}
				else if( actionStr.equalsIgnoreCase( "RUN" ) )
				{
					//Changed by Dayanand on 01/04/2011[ Pass tran ID to update schedule_log || queries spent 99% of its database time on CPU ]
					//responseStr = getSchedulerComp().runSchedule( scheduleId );
					//responseStr = getSchedulerComp().runSchedule( scheduleId, "" );
					//responseStr = getSchedulerComp().runSchedule( scheduleId, "" , userInfo );// Changed by Sachin Satre on [08-feb-19]);
					//Added By Pankaj T. on 14-11-19 [If BUSINESS EVENT execution result true then execute scheduler else not. Suppose if BUSINESS EVENT not define then execute like currently]
					responseStr = getSchedulerComp().executeScheduleManually(scheduleId, userInfo);
					BaseLogger.log("3",null,null, "SCHEDULEID::"+scheduleId);
				}
				else if( actionStr.equalsIgnoreCase( "STOP" ) )
				{
					BaseLogger.log("3",null,null, "Inside STOP schedule action");
					//Commented and changed by Gulzar on 03/09/15 : START
					//responseStr = getSchedulerComp().stopSchedule( scheduleId );
					//responseStr = getSchedulerComp().stopSelectedSchedule( scheduleId );
					String getOwner = getSchedulerComp().getSchedulerOwner( scheduleId , userInfo ) ; //Added By Nilesh Start :: 22-05-19
					System.out.print(" getOwner :: "+ getOwner);
					int userlevel = getSchedulerComp().getUserLevel( getOwner , userInfo ); 
					System.out.print(" userlevel :: "+ userlevel);
					System.out.print(" userInfo :: "+ userInfo.getUserLevel());
					String loginUsrLev = userInfo.getUserLevel();
					if(!loginUsrLev.equalsIgnoreCase("0") && userlevel==0)
					{
						responseStr= String.valueOf(userlevel);
					}
					else
					{	
						responseStr = getSchedulerComp().stopSelectedSchedule( scheduleId , userInfo ) ;// Changed by Sachin Satre on [08-Feb-19]
						
					}	
					//Added By Nilesh End :: 22-05-19
					//Commented and changed by Gulzar on 03/09/15 : END
				}
				else if( actionStr.equalsIgnoreCase( "REGISTER" ) )
				{
					if( ! ScheduleUtility.getInstance().checkDateSchedule( schdlXmlString ) )
					{
						if( owner != null && owner.length() > 0 )
						{
							//responseStr = getScheduleInfoComp().registerSchedule( schdlXmlString, owner );
							responseStr = getScheduleInfoComp().registerSchedule( schdlXmlString, owner ,userInfo);
							try{
								String appServerId=schedule.getAppServerIPAddr();
								String backserver=schedule.getBackgroundJobServer();
								System.out.println("Application App server ip"+appServerId);
								System.out.println("BackServer is "+appServerId);
								} catch(Exception e){
									e.printStackTrace();
								}
							// Changed by Sachin Satre on [08-Feb-19]
//							List<SchedulerBean> listInfo=ejb.list();
//							request.setAttribute("listCategory", listInfo);
							
							// Changed by Arunkumar Yadav on [10-Feb-23][To compare background job server tag]

						
						}
						else
						{
							//responseStr = getScheduleInfoComp().registerSchedule( schdlXmlString );
							responseStr = getScheduleInfoComp().registerSchedule( schdlXmlString , userInfo); 
							
							// Changed by Arunkumar Yadav on [10-Feb-23][To compare background job server tag]
						}
					}
					else
					{
						responseStr = "<Errors><error id='' type='E' column_name=''><message>Start Date can't be less than current date.</message><description></description><type></type><option></option></error></Errors>";
					}
				}
				//Changed By Madhup On 13/07/07 For Shecheduler while registring.Start
				else if( actionStr.equalsIgnoreCase( "REGISTERANDSART" ) )
				{
					BaseLogger.log("3",null,null, "Inside RegisterAndStart::");
					if( ! ScheduleUtility.getInstance().checkDateSchedule( schdlXmlString ) )
					{
						if( owner != null && owner.length() > 0 )
						{
							BaseLogger.log("3",null,null, "Inside REGISTERANDSART1");
							//responseStr = getScheduleInfoComp().registerSchedule( schdlXmlString, owner );
							responseStr = getScheduleInfoComp().registerSchedule( schdlXmlString, owner , userInfo );// Changed by Sachin Satre on [08-Feb-19]
							String schId= getScheduleInfoComp().getRegSchId();
							//getSchedulerComp().startSchedule( schId );
							getSchedulerComp().startSchedule( schId , userInfo  );
						}
						else
						{
							BaseLogger.log("3",null,null, "Inside REGISTERANDSART2");
							//responseStr = getScheduleInfoComp().registerSchedule( schdlXmlString );
							responseStr = getScheduleInfoComp().registerSchedule( schdlXmlString , userInfo );// Changed by Sachin Satre on [08-Feb-19]
							String schId= getScheduleInfoComp().getRegSchId();
							//getSchedulerComp().startSchedule( schId );
							getSchedulerComp().startSchedule( schId  , userInfo );// Changed by Sachin Satre on [08-Feb-19]
						}
					}
					else
					{
						BaseLogger.log("3",null,null, "Inside RegisterAndStart5::");
						schdlXmlString = ScheduleUtility.getInstance().updateXml(schdlXmlString);
						if( owner != null && owner.length() > 0 )
						{
							BaseLogger.log("3",null,null, "Inside REGISTERANDSART3");
							//responseStr = getScheduleInfoComp().registerSchedule( schdlXmlString, owner );
							responseStr = getScheduleInfoComp().registerSchedule( schdlXmlString, owner , userInfo );// Changed by Sachin Satre on [08-Feb-19]
							String schId= getScheduleInfoComp().getRegSchId();
							//getSchedulerComp().startSchedule( schId );
							getSchedulerComp().startSchedule( schId , userInfo );// Changed by Sachin Satre on [08-Feb-19]
						}
						else
						{
							BaseLogger.log("3",null,null, "Inside REGISTERANDSART4");
							//responseStr = getScheduleInfoComp().registerSchedule( schdlXmlString );
							responseStr = getScheduleInfoComp().registerSchedule( schdlXmlString , userInfo );// Changed by Sachin Satre on [08-Feb-19]
							String schId= getScheduleInfoComp().getRegSchId();
							//getSchedulerComp().startSchedule( schId );
							getSchedulerComp().startSchedule( schId , userInfo );// Changed by Sachin Satre on [08-Feb-19]
						}
					}
				}
				else if(actionStr.equalsIgnoreCase( "VERIFYDATE" ))
				{
					if( ! ScheduleUtility.getInstance().checkDateSchedule( schdlXmlString ) )
					{
						responseStr ="true";
					}
					else
					{
						responseStr ="false";
					}
				}
				//Changed By Madhup On 13/07/07 For Shecheduler while registring.End
				//Changed by Rupali on 6/11/2008 for [If scheduler updaion process ,if start time is less than current time then scheduler fired time should not set to current date & time.].Request ID[BI89BAS002].Start
				else if( actionStr.equalsIgnoreCase( "SCHINFOMODIFY" ) )
				{
					BaseLogger.log("3",null,null,"ONLY SCHEDULER INFORMATION UPDATED START.................. ");
					//responseStr = getScheduleInfoComp().updateSchedule( scheduleId , schdlXmlString  );
					responseStr = getScheduleInfoComp().updateSchedule( scheduleId , schdlXmlString , userInfo );// Changed by Sachin Satre on [08-Feb-19]
					BaseLogger.log("3",null,null,"ONLY SCHEDULER INFORMATION UPDATED END.................. ");
				}
				//Changed by Rupali on 6/11/2008 for [If scheduler updaion process ,if start time is less than current time then scheduler fired time should not set to current date & time.].Request ID[BI89BAS002].End
				else if( actionStr.equalsIgnoreCase( "MODIFY" ) )
				{
					BaseLogger.log("3",null,null,"MODIFY START.................. ");
					if( ! ScheduleUtility.getInstance().checkDateSchedule( schdlXmlString ) )
					{
						//Changed by rupali [NOT MERGED]
						//getScheduleInfoComp().updateScheduleToDB( scheduleId , schdlXmlString );
						//if start Date should be greater than prevoius and current date unless you got Null pointer Exception
						getScheduleInfoComp().updateScheduleToDB( scheduleId , schdlXmlString  ,userInfo );//Changed by Sachin Satre on [08-Feb-19]
						BaseLogger.log("3",null,null,"--After updateScheduleToDB--");
						//responseStr = getScheduleInfoComp().updateSchedule( scheduleId , schdlXmlString );
						responseStr = getScheduleInfoComp().updateSchedule( scheduleId , schdlXmlString , userInfo );//Changed by Sachin Satre on [08-Feb-19]
						BaseLogger.log("3",null,null,"--After updateSchedule--"+responseStr);
					}
					else
					{
						//Changed By Madhup On 13/07/07 For Shecheduler while registring.Start
						//responseStr = "<Errors><error id='' type='E' column_name=''><message>Start Date can't be less than current date.</message><description></description><type></type><option></option></error></Errors>";
						//Changed by Rupali on 6/11/2008 for [If scheduler updaion process ,if start time is less than current time then scheduler fired time should not set to current date & time.].Request ID[BI89BAS002].Start
						/*
						schdlXmlString = ScheduleUtility.getInstance().updateXml(schdlXmlString);
						getScheduleInfoComp().updateSchedule( scheduleId , schdlXmlString );
						responseStr= "";
						*/
						responseStr = "<Errors><error id='' type='E' column_name=''><message>Start Date and Time can't be less than current date.</message><description></description><type></type><option></option></error></Errors>";
						//Changed by Rupali on 6/11/2008 for [If scheduler updaion process ,if start time is less than current time then scheduler fired time should not set to current date & time.].Request ID[BI89BAS002].End
						//Changed By Madhup On 13/07/07 For Shecheduler while registring.End
					}
				}
				else if( actionStr.equalsIgnoreCase( "DELETE" ) )
				{
					if( owner != null && owner.length() > 0 )
					{
						BaseLogger.log("3",null,null, "Inside scheduleInfoServlet DELETE Action");
						//responseStr = getScheduleInfoComp().deleteSchedule( scheduleId,owner );
						responseStr = getScheduleInfoComp().deleteSchedule( scheduleId , owner , userInfo ) ;// Changed by Sachin Satre on [08-Feb-19]
					}
					else
					{
						//responseStr = getScheduleInfoComp().deleteSchedule( scheduleId);
						responseStr = getScheduleInfoComp().deleteSchedule( scheduleId , userInfo) ;// Changed by Sachin Satre on [08-Feb-19]
					}
				}
				else if( actionStr.equalsIgnoreCase( "LOAD_ACTIVITY" ) )
				{
					 responseStr = schedulerbean.setActivityList(activity_Name,scheduleId,pgContx);
				}
				else if( actionStr.equalsIgnoreCase( "ACTIVITY_INFO" ) )
				{
					 responseStr = schedulerbean.getActivityInfo(activity_Name);
				}
				else if( actionStr.equalsIgnoreCase( "DELETE_ACTIVITY" ) )
				{
					 responseStr = schedulerbean.deleteActivity(activity_Name);
				}
				else if( actionStr.equalsIgnoreCase( "SCH_DETAIL" ) )
				{
					//getScheduleModelDetail( scheduleId, response );
					getScheduleModelDetail( scheduleId, response, userInfo );// Changed by Sachin Satre on [08-Feb-19]
					toRespond = false;
				}
			}
			if( toRespond )
			{
				//Added by Dnyaneshwar Chavan on 24-OCT-13 [CO3ASUN005] [ Resolved the issue of when response in Russian language or etc.  ] START
		        //response.setContentType("text/html");
		        response.setContentType( "text/html; charset="+CommonConstants.ENCODING );
		        //Added by Dnyaneshwar Chavan on 24-OCT-13 [CO3ASUN005] [ Resolved the issue of when response in Russian language or etc.  ] END

				OutputStream outStream = response.getOutputStream();
				//Gulzar on 03/09/15 : START
				responseStr = (responseStr == null) ?"":responseStr;
				//Gulzar on 03/09/15 : END
				outStream.write( responseStr.getBytes() );
				outStream.flush();
				outStream.close();
			}
		}
		catch(Exception e)
		{
			try
			{
				e.printStackTrace();
				PrintWriter writer = response.getWriter();
				//Added by Dnyaneshwar Chavan on 24-OCT-13 [CO3ASUN005] [ Resolved the issue of when response in Russian language or etc.  ] START
		        //response.setContentType("text/html");
		        response.setContentType( "text/html; charset="+CommonConstants.ENCODING );
		        //Added by Dnyaneshwar Chavan on 24-OCT-13 [CO3ASUN005] [ Resolved the issue of when response in Russian language or etc.  ] END

				//changes by madhup 28/04/07
				/*ByteArrayOutputStream baos = new ByteArrayOutputStream();
				e.printStackTrace( new PrintStream( baos ) );
				response.setContentLength( baos.toString().length() );
				writer.println( baos.toString() );*/
				response.setContentLength( e.getMessage().length() );
				writer.println( e.getMessage() );
				//end changes
				writer.flush();
				writer.close();
				//baos.close();
			}
			catch (Exception exp)
			{
				exp.printStackTrace();
			}
		}
		catch( Throwable t )
		{
			try
			{
				BaseLogger.log("3",null,null,"-------Exception-------"+t.getMessage());

				PrintWriter writer = response.getWriter();

				//Added by Dnyaneshwar Chavan on 24-OCT-13 [CO3ASUN005] [ Resolved the issue of when response in Russian language or etc.  ] START
		        //response.setContentType("text/html");
		        response.setContentType( "text/html; charset="+CommonConstants.ENCODING );
		        //Added by Dnyaneshwar Chavan on 24-OCT-13 [CO3ASUN005] [ Resolved the issue of when response in Russian language or etc.  ] END

				String sessMsg = ( String )sess.getAttribute( "ERR_MSG" );
				String errMsg = "ERR_MSG :" + ( ( sessMsg == null ) ? "" : ( sessMsg + "\n"+t.getMessage() ) );
				response.setContentLength( errMsg.length() );
				writer.println( errMsg );
				writer.flush();
				writer.close();
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		BaseLogger.log("2",null,null,"ScheduleInfoServlet : doPost() completed ");//Added By Danish on 01/10/2006
	}


	private void getScheduleModelStr( String scheduleId, HttpServletResponse response )throws BaseException
	{
		try
		{
			ScheduleInfoRemote ejbObj = getScheduleInfoComp();
			String schModelStr = ejbObj.getScheduleModelStr( scheduleId );
			response.setBufferSize( 1024 );

			//Added by Dnyaneshwar Chavan on 24-OCT-13 [CO3ASUN005] [ Resolved the issue of when response in Russian language or etc.  ] START
	        //response.setContentType("text/html");
	        response.setContentType( "text/html; charset="+CommonConstants.ENCODING );
	        //Added by Dnyaneshwar Chavan on 24-OCT-13 [CO3ASUN005] [ Resolved the issue of when response in Russian language or etc.  ] END

			OutputStream outStream = response.getOutputStream();
			outStream.write( schModelStr.getBytes() );
			outStream.flush();
			outStream.close();
		}
		catch ( BaseException be )
		{
			throw be;
		}
		catch ( Exception exp )
		{
			throw new BaseException( exp );
		}
	}
	//Added by Sachin Satre on [08-feb-19] [Start]
	private void getScheduleModelDetail( String scheduleId, HttpServletResponse response )throws BaseException
	{
		getScheduleModelDetail(  scheduleId,  response , null );
	}
	//Added by Sachin Satre on [08-feb-19] [End]
	//private void getScheduleModelDetail( String scheduleId, HttpServletResponse response )throws BaseException
	private void getScheduleModelDetail( String scheduleId, HttpServletResponse response , UserInfoBean userInfo )throws BaseException // Changed by Sachin Satre on [08-Feb-19]
	{
		System.out.print("--scheduleId["+scheduleId+"]");
		try
		{
			ScheduleInfoRemote ejbObj = getScheduleInfoComp();
			//Gulzar on 03/09/15 : START
			//String schModelStr = ejbObj.getScheduleModelDetail( scheduleId );
			String schModelStr = ejbObj.getSelectedScheduleModel( scheduleId ,userInfo );// Changed by Sachin Satre on [08-Feb-19]
			//Gulzar on 03/09/15 : END
			response.setBufferSize( 1024 );

			//Added by Dnyaneshwar Chavan on 24-OCT-13 [CO3ASUN005] [ Resolved the issue of when response in Russian language or etc.  ] START
	        //response.setContentType("text/html");
	        response.setContentType( "text/html; charset="+CommonConstants.ENCODING );
	        //Added by Dnyaneshwar Chavan on 24-OCT-13 [CO3ASUN005] [ Resolved the issue of when response in Russian language or etc.  ] END

			OutputStream outStream = response.getOutputStream();
			outStream.write( schModelStr.getBytes() );
			outStream.flush();
			outStream.close();
		}
		catch ( BaseException be )
		{
			throw be;
		}
		catch ( Exception exp )
		{
			throw new BaseException( exp );
		}
	}


	//private Scheduler getSchedulerComp() throws BaseException
	private SchedulerRemote getSchedulerComp() throws BaseException
	{
		//Scheduler ejbObj = null;
		// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
		//SchedulerRemote ejbObj = null;
		SchedulerEJB ejbObj = null;
		// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext( appConnect.getProperty() );
			/*SchedulerHome schedulerHome = ( SchedulerHome )ctx.lookup( "Scheduler" );
			ejbObj = schedulerHome.create();*/
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
			//ejbObj = ( SchedulerRemote )ctx.lookup( "ibase/SchedulerEJB/remote" );
			ejbObj = new SchedulerEJB();
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
		}
		catch (BaseException be)
		{
			throw be;
		}
		catch ( Exception exp )
		{
			throw new BaseException( exp );
		}
		return ejbObj;
	}

	//private ScheduleInfo getScheduleInfoComp() throws BaseException
	private ScheduleInfoRemote getScheduleInfoComp() throws BaseException
	{
		//ScheduleInfo ejbObj = null;
		// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
		//ScheduleInfoRemote ejbObj = null;
		ScheduleInfoEJB ejbObj = null;
		// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext( appConnect.getProperty() );
			/*ScheduleInfoHome scheduleInfoHome = ( ScheduleInfoHome )ctx.lookup( "ScheduleInfo" );
			ejbObj = scheduleInfoHome.create();*/
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
			//ejbObj = ( ScheduleInfoRemote )ctx.lookup( "ibase/ScheduleInfoEJB/remote" );
			ejbObj = new ScheduleInfoEJB();
			
			
		}
		catch (BaseException be)
		{
			throw be;
		}
		catch ( Exception exp )
		{
			throw new BaseException( exp );
		}
		return ejbObj;
	}
	public String getAppServerIPAddr() throws Exception
	{
		String ipAddr = "";
		try
	    {
	        Enumeration<NetworkInterface> b = NetworkInterface.getNetworkInterfaces();
	        while( b.hasMoreElements())
	        {
	            for ( InterfaceAddress f :b.nextElement().getInterfaceAddresses())
	            {
	                if ( f.getAddress().isSiteLocalAddress())
	                {
	                    ipAddr = f.getAddress().toString();
	                    //BaseLogger.log("9",null,null,f.getAddress());
	                }
	            }
	        }
	        BaseLogger.log("3",null,null,"ipAddr =["+ipAddr+"]");

	        if(ipAddr.startsWith("\"") || ipAddr.startsWith("/"))
	        {
	            ipAddr = ipAddr.substring(1, ipAddr.length());
	        }
	        BaseLogger.log("3",null,null,"ipAddr1 =["+ipAddr+"]");
	        if(ipAddr == null || ipAddr.trim().length() == 0)
	        {
	        	InetAddress inetAddress;
	            inetAddress = InetAddress.getLocalHost();
	            String hostName = inetAddress.getHostName();
	            ipAddr = inetAddress.getHostAddress();
	            BaseLogger.log("3",null,null,"hostName =["+hostName+"]");
	        }
	        BaseLogger.log("3",null,null,"ipAddr2 =["+ipAddr+"]");
	    }
	    catch (SocketException se)
	    {
	        se.printStackTrace();
	    }
		catch (Exception e)
	    {
	        e.printStackTrace();
	    }
		return ipAddr;
	}
	
	

public String getBackgroundJobServer() throws FileNotFoundException{
	//Changed by Arunkumar on 08-02-2023 [to check background job server is empty if not then comparing to TOMCATHOME tag]
	try
	{
		CommonConstants common=new CommonConstants();
		String filename ="/" + "IBASEHOME" + File.separator + "ibase.xml";

		File fileObj = new File( filename );
		if( ! fileObj.exists() )
		{
			if( ! fileObj.getParentFile().exists() )
			{
				fileObj.getParentFile().mkdirs();
			}
			common.createDefIBASEHOME( fileObj );
		}

		DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
		Document document = documentBuilder.parse(filename);
		E12GenericUtility genUtility = new E12GenericUtility();
		String BackjobServer = document.getElementsByTagName("BACKGROUND_JOB_SERVER").item(0).getFirstChild().getNodeValue();
		if (document.getElementsByTagName("BACKGROUND_JOB_SERVER").item(0) != null && document.getElementsByTagName("BACKGROUND_JOB_SERVER").item(0).getFirstChild() != null)
		{
			BACKGROUND_JOB_SERVER = document.getElementsByTagName("BACKGROUND_JOB_SERVER").item(0).getFirstChild().getNodeValue();
			BACKGROUND_JOB_SERVER=getAppServerIPAddr();
		}
		else 
		{
			
			String tomcatHome =document.getElementsByTagName("TOMCATHOME").item(0).getFirstChild().getNodeValue();
			if(tomcatHome.equals(getAppServerIPAddr())	){
				System.out.println("Both Ips are equal");
			}
			else{
				System.out.println("Both Ips are not equal");

			}
		}
		
		
	}catch(Exception e){
		e.printStackTrace();
	}
	
		return BACKGROUND_JOB_SERVER;
	}
	
	
	
}