/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.servlet.AuthenticateServlet;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ITMAuthenticateServlet
extends AuthenticateServlet {
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        BaseLogger.log("2", null, null, ":::ITMAuthenticateServlet called:::");
        this.doPost(request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            HttpSession sess = request.getSession();
            UserInfoBean userInfoBean = (UserInfoBean)sess.getAttribute("USER_INFO");
            if (userInfoBean == null) {
                request.getSession().invalidate();
                throw new ITMException(new Exception("SESSION_EXPIRED"));
            }
            this.authenticate(request);
            String action = request.getParameter("ACTION");
            String result = "";
            BaseLogger.log("2", null, null, " action[" + action + "]");
            if ("GET_SITES".equals(action)) {
                UserInfoBean userInfo = (UserInfoBean)sess.getAttribute("USER_INFO");
                String userId = request.getParameter("userId");
                String userLevel = request.getParameter("userLevel") == null ? "" : request.getParameter("userLevel");
                BaseLogger.log("3", userInfo, null, "---> userId[" + userId + "] userLevel[" + userLevel + "]");
                DBAccessEJB dbAccess = new DBAccessEJB();
                result = dbAccess.getSiteInfo(userId, userLevel, userInfo);
                dbAccess = null;
            } else if ("SET_SELECTED_SITE_CODE".equals(action)) {
                this.setSelectedSiteInfo(request);
                result = "true";
            } else {
                String flag = request.getParameter("flag");
                result = flag.equalsIgnoreCase("Y") ? this.getApplications(request) : (flag.equalsIgnoreCase("C") ? this.getAppConnOpt(request) : this.getAppDescrp(request));
            }
            BaseLogger.log("3", null, null, "result for user connections is: " + result);
            PrintWriter writer = response.getWriter();
            response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
            writer.write(result);
            writer.flush();
            writer.close();
        }
        catch (ITMException itme) {
            try {
                PrintWriter writer = response.getWriter();
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                String errMsg = itme.getMessage();
                response.setContentLength(errMsg.length());
                writer.println(errMsg);
                writer.flush();
                writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            try {
                PrintWriter writer = response.getWriter();
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(baos));
                response.setContentLength(baos.toString().length());
                writer.println(baos.toString());
                writer.flush();
                writer.close();
                baos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    protected String authenticate(HttpServletRequest request) throws ITMException {
        BaseLogger.log("2", null, null, "Called ITMAuthenticateServlet authentication.....");
        String responseStr = "false";
        try {
            if (Boolean.valueOf(super.authenticate(request)).booleanValue()) {
                HttpSession sess = request.getSession();
                UserInfoBean userInfo = (UserInfoBean)sess.getAttribute("USER_INFO");
                if (userInfo != null && !"true".equals(sess.getAttribute("IS_EMP_INFO_SET"))) {
                    DBAccessEJB dbAccess = new DBAccessEJB();
                    userInfo.setEmpInfo(dbAccess.getEmpInfo(userInfo.getLoginCode(), userInfo.getSiteCode(), userInfo.getTransDB()));
                    sess.setAttribute("IS_EMP_INFO_SET", (Object)"true");
                    dbAccess = null;
                }
                responseStr = "true";
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :ITMAuthenticateServlet :authenticate() :==>\n" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ITMAuthenticateServlet :authenticate() :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return responseStr;
    }

    protected String getApplications(HttpServletRequest request) throws ITMException {
        String applLst = null;
        try {
            DBAccessEJB dbAccess = new DBAccessEJB();
            String userId = request.getParameter("UserId");
            String userLevel = request.getParameter("Userlevel");
            HttpSession sess = request.getSession();
            UserInfoBean userInfo = (UserInfoBean)sess.getAttribute("USER_INFO");
            applLst = this.getCommaSeperatedValue(dbAccess.getApplications(userId, userLevel, userInfo));
            dbAccess = null;
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :ITMAuthenticateServlet :getApplications() :==>\n" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ITMAuthenticateServlet :getApplications() :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return applLst;
    }

    protected String getAppDescrp(HttpServletRequest request) throws ITMException {
        String descrp = null;
        try {
            DBAccessEJB dbAccess = new DBAccessEJB();
            String appName = request.getParameter("APPNAME");
            BaseLogger.log("3", null, null, "application name:: " + appName);
            HttpSession sess = request.getSession();
            UserInfoBean userInfo = (UserInfoBean)sess.getAttribute("USER_INFO");
            descrp = dbAccess.getAppDescription(appName, userInfo.toString());
            BaseLogger.log("3", userInfo, null, "description in servlet is:: " + descrp);
            if (descrp == null) {
                descrp = "No description available";
                return descrp;
            }
            return descrp;
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :ITMAuthenticateServlet :getdescription() :==>\n" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ITMAuthenticateServlet :getdescription() :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
    }

    private String getCommaSeperatedValue(ArrayList applNames) {
        StringBuffer fieldNameBuff = new StringBuffer();
        for (Object fieldName : applNames) {
            fieldNameBuff.append((String)fieldName).append(",");
        }
        String CSValues = fieldNameBuff.toString();
        if (!"".equalsIgnoreCase(CSValues)) {
            CSValues = CSValues.substring(0, CSValues.lastIndexOf(","));
        }
        return CSValues;
    }

    private void setSelectedSiteInfo(HttpServletRequest request) throws ITMException {
        BaseLogger.log("2", null, null, "**********SET SELECTED SITE CODE AND DESCR**************");
        String selectedSiteCode = request.getParameter("selectedSiteCode");
        String selectedSiteDescr = request.getParameter("selectedSiteDescr");
        String selectedProfileId = request.getParameter("selectedProfileId");
        String userId = request.getParameter("userId");
        BaseLogger.log("2", null, null, " selectedSiteCode [" + selectedSiteCode + "] selectedSiteDescr[" + selectedSiteDescr + "] selectedProfileId[" + selectedProfileId + "]");
        HttpSession sess = request.getSession();
        UserInfoBean userInfo = (UserInfoBean)sess.getAttribute("USER_INFO");
        BaseLogger.log("2", userInfo, null, "User level [" + userInfo.getUserLevel() + "]");
        BaseLogger.log("2", userInfo, null, " B4 set value in user infor bean sideCode [" + userInfo.getSiteCode() + "] sideDescr [" + userInfo.getSiteDescr() + "]");
        if (userInfo != null && selectedSiteCode != null) {
            try {
                DBAccessEJB dbAccess = new DBAccessEJB();
                String enterprise = dbAccess.updateEnterprise(selectedSiteCode, userInfo.getTransDB());
                BaseLogger.log("3", userInfo, null, "enterprise121[" + enterprise + "]");
                if (enterprise != null && !"null".equalsIgnoreCase(enterprise) && !"undefined".equalsIgnoreCase(enterprise)) {
                    userInfo.setEnterprise(enterprise);
                }
                dbAccess = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception in setsletcted site info[" + e.getMessage() + "]");
                throw new ITMException(e);
            }
            userInfo.setSiteCode(selectedSiteCode);
            userInfo.setSiteDescr(selectedSiteDescr);
            if (selectedProfileId != null && selectedProfileId.length() > 0) {
                userInfo.setProfileId(selectedProfileId);
            }
            sess.setAttribute("USER_INFO", (Object)userInfo);
            sess.setAttribute("IS_EMP_INFO_SET", (Object)"true");
        }
    }

    protected String getAppConnOpt(HttpServletRequest request) throws ITMException {
        String connOpt = null;
        try {
            DBAccessEJB dbAccess = new DBAccessEJB();
            String appName = request.getParameter("APPNAME");
            BaseLogger.log("3", null, null, "application name:: " + appName);
            HttpSession sess = request.getSession();
            UserInfoBean userInfo = (UserInfoBean)sess.getAttribute("USER_INFO");
            connOpt = dbAccess.getAppConnOpt(appName, userInfo);
            BaseLogger.log("3", userInfo, null, "connection option in servlet is:: " + connOpt);
            if (connOpt == null) {
                return connOpt;
            }
            return connOpt;
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :ITMAuthenticateServlet :getdescription() :==>\n" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ITMAuthenticateServlet :getdescription() :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
    }
}

