package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.wsfa.masters.SellsStock;
import ibase.webitm.utility.ITMException;

public class SellInSellOutSchedule implements Schedule
{
	private E12GenericUtility genericUtility = null;
	private String salesPersMailFormatCode = "";
	private String mgrMailFormatCode = "";
	private String transDB = "";
	
	public SellInSellOutSchedule()
	{
		System.out.println( "Inside SellInSellOutSchedule :" );
	}

	@Override
	public String schedule(String scheduleParamXML) throws Exception 
	{
		System.out.println("In the Schedule scheduleParamXML ::: ["+ scheduleParamXML +"]");
		Connection conn = null;
		String resultStr = "success";
		try 
		{
			genericUtility = new E12GenericUtility();
			Document document = genericUtility.parseString( scheduleParamXML );
			
			UserInfoBean userInfo = null;
			if ( document.getElementsByTagName( "USERINFOXML" ) != null && document.getElementsByTagName( "USERINFOXML" ).item(0) != null
					&& document.getElementsByTagName( "USERINFOXML" ).item(0).getChildNodes() != null
					&& document.getElementsByTagName( "USERINFOXML" ).item(0).getChildNodes().item(0) != null )
			{
				userInfo = new UserInfoBean( genericUtility.serializeDom( document.getElementsByTagName( "USERINFOXML" ).item(0).getChildNodes().item(0) ) );
			}
			System.out.println( "userInfo :: ["+ userInfo +"]" );
			
			if ( userInfo == null )
			{
				return "userInfo is null";
			}
			
			getNodeValueFrmActualParamsNode( document );
			salesPersMailFormatCode = ( salesPersMailFormatCode != null && salesPersMailFormatCode.trim().length() > 0 ) ? salesPersMailFormatCode : "SP_MISSED_SELL_IN_OUT";	
			mgrMailFormatCode = ( mgrMailFormatCode != null && mgrMailFormatCode.trim().length() > 0 ) ? mgrMailFormatCode : "MGR_MISSED_SELL_IN_OUT";	
			System.out.println( "salesPersMailFormatCode : ["+ salesPersMailFormatCode +"], mgrMailFormatCode : ["+ mgrMailFormatCode +"]" );
			
			transDB = ( transDB != null && transDB.trim().length() > 0 ) ? transDB : checkNull( userInfo.getTransDB());
			System.out.println("transDB : ["+ transDB +"]");

			//String transDB = checkNull( userInfo.getTransDB() );
			System.out.println("transDB : ["+ transDB +"]");
			if( transDB.length() > 0 )
			{
				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB( transDB );
				connDriver = null;
			}
			
			SellsStock sellsStock = new SellsStock();
			HashMap<String, HashMap<String, HashMap<String,String>>> sellInOutNotificationDetailMap = sellsStock.getMissingSellInOutNotificationDetails( conn, userInfo );
			System.out.println( "sellInOutNotificationDetailMap : ["+ sellInOutNotificationDetailMap +"]" );

			sendReminderEmailToSalesPerson( sellInOutNotificationDetailMap, userInfo, conn, salesPersMailFormatCode );
			sendNotificationEmailToManager( sellInOutNotificationDetailMap, userInfo, conn, mgrMailFormatCode );
		}
		catch (ITMException e) 
		{
			resultStr = e.getMessage();
			e.printStackTrace();
		}
		catch (BaseException e) 
		{
			resultStr = e.getMessage();
			e.printStackTrace();
		}
		catch (Exception e) 
		{
			resultStr = e.getMessage();
			e.printStackTrace();
		}
		finally
		{
			try 
			{
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}

		return resultStr;
	}
	
	private void getNodeValueFrmActualParamsNode(Document doc)
	{
		try
		{
			NodeList paramNodeList = doc.getElementsByTagName("ACTUALPARAMETERS");
			Node paramNode = paramNodeList.item(0);
			genericUtility.removeWhitespaceInner(paramNode, null);
			NodeList actParamNdList = paramNode.getChildNodes(); 
			int parameterLength = actParamNdList.getLength();
			BaseLogger.log("3", null,  null,"no::"+parameterLength);
 			for(int parameter = 0; parameter< parameterLength; parameter++)
			{
				Node paramNd = actParamNdList.item(parameter);
				
				String attributeName = paramNd.getAttributes().getNamedItem("name").getNodeValue();
				BaseLogger.log("3", null,  null,"attributeName:: ["+ attributeName +"]" );
				if(attributeName.equalsIgnoreCase("TRANS_DB"))
				{
					String transDb = paramNd.getFirstChild().getNodeValue();
					this.transDB = transDb;
				}
				else if(attributeName.equalsIgnoreCase("SP_FORMAT_CODE"))
				{
					String spMailFormat = paramNd.getFirstChild().getNodeValue();
					this.salesPersMailFormatCode = spMailFormat;
				}
				else if(attributeName.equalsIgnoreCase("MANAGER_FORMAT_CODE"))
				{
					String managerMailFormat = paramNd.getFirstChild().getNodeValue();
					this.mgrMailFormatCode = managerMailFormat;
				}
			}
		}
		catch(Exception e) 
		{
			BaseLogger.log("0", null,  null,"Exception in getNodeValueFrmActualParamsNode(): " +e.getMessage());
			e.printStackTrace();
		}
	}
	
	private void sendReminderEmailToSalesPerson( HashMap<String, HashMap<String, HashMap<String, String>>> sellInOutNotificationDetailMap, UserInfoBean userInfo, Connection conn, String spMailFormatCode ) throws Exception
	{
		try 
		{
			String subject = "";
			String bodyText = "";
			
			StringBuffer mailDomStr = new StringBuffer();
			String entityCode = userInfo.getEntityCode();
			
			HashMap<String, HashMap<String,String>> spEmailIdMap = sellInOutNotificationDetailMap.get( "EMAIL_ID" );
			HashMap<String,String> salesPersonEmailIdMap = spEmailIdMap.get( "EMAIL_ID" );
			
			String salesPersonEmailIds = salesPersonEmailIdMap.get( "EMAIL_ID" );
			salesPersonEmailIds = salesPersonEmailIds.replace("[", "").replace("]", "");
			System.out.println( "salesPersonEmailIds : ["+ salesPersonEmailIds +"]" );
			
			HashMap <String, String > mailSubjNBodyTextMap  = getMailSubjectNBodyTextData( spMailFormatCode, conn);
			System.out.println(" getMailSubjNBodyTextMap : ["+ mailSubjNBodyTextMap +"]");
			
			if( mailSubjNBodyTextMap != null && mailSubjNBodyTextMap.size() > 0 )
			{
				subject = mailSubjNBodyTextMap.get("SUBJECT");
				bodyText = mailSubjNBodyTextMap.get("BODY_TEXT");
			}
			else
			{
				 subject = "Missing Sell In and Sell Out";
				 bodyText = "Your Sell In and Sell Out entry missing for last week. \n\nPlease do the needful.";
			}
			mailDomStr.append( "<ROOT>" );
			mailDomStr.append( "<MAIL>" );
			mailDomStr.append( "<EMAIL_TYPE>page</EMAIL_TYPE>" );
			mailDomStr.append( "<ENTITY_CODE>" ).append( entityCode ).append( "</ENTITY_CODE>" ); //TO DO
			mailDomStr.append( "<ENTITY_TYPE>" ).append( "E" ).append( "</ENTITY_TYPE>" );
			mailDomStr.append( "<SUBJECT>" ).append( subject ).append( "</SUBJECT>" );
			mailDomStr.append( "<BODY_TEXT>" ).append( bodyText ).append( "</BODY_TEXT>" );
			mailDomStr.append( "<TO_ADD>" ).append( salesPersonEmailIds ).append( "</TO_ADD>" );
			mailDomStr.append( "<CC_ADD></CC_ADD>" );
			mailDomStr.append( "<FORMAT_CODE></FORMAT_CODE>" );
			mailDomStr.append( "<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>" );
			mailDomStr.append( "</MAIL>" );
			mailDomStr.append( "<XML_DATA></XML_DATA>" );
			mailDomStr.append( "</ROOT>" );
			
			System.out.println("mailDomStr sendReminderEmailToSalesPerson :["+ mailDomStr +"]");

			EMail email = new EMail();
			email.sendMail( mailDomStr.toString(), "ITM", conn );
		}
		catch (RemoteException e) 
		{
			System.out.println( "RemoteException :: sendReminderEmailToSalesPerson : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		catch (ITMException e) 
		{
			System.out.println( "ITMException :: sendReminderEmailToSalesPerson : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		catch (Exception e) 
		{
			System.out.println( "Exception :: sendReminderEmailToSalesPerson : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
	}
	
	private void sendNotificationEmailToManager( HashMap<String, HashMap<String, HashMap<String, String>>> sellInOutNotificationDetailMap, UserInfoBean userInfo, Connection conn, String managerMailFormatCode ) throws Exception
	{
		try 
		{
			String subject = "";
			String bodyText = "";
			
			String entityCode = userInfo.getEntityCode();
			StringBuffer mailDomStr = null;
			
			HashMap<String, HashMap<String,String>> reportToSPEmailIdMap = sellInOutNotificationDetailMap.get( "REPORT_TO" );
			System.out.println( "reportToSPEmailIdMap : ["+ reportToSPEmailIdMap +"]" );

			HashMap<String, HashMap<String,String>> reportToRSMEmailIdMap = sellInOutNotificationDetailMap.get( "RSM" );
			System.out.println( "reportToRSMEmailIdMap : ["+ reportToRSMEmailIdMap +"]" );
			
			System.out.println("reportToMailIdMap length : ["+ reportToSPEmailIdMap.size() +"]");
			
			HashMap <String, String > mailSubjNBodyTextMap = getMailSubjectNBodyTextData( managerMailFormatCode, conn );
			System.out.println(" getMailSubjNBodyTextMap : ["+ mailSubjNBodyTextMap +"]");
			
			for( Map.Entry<String, HashMap<String,String>> entry : reportToSPEmailIdMap.entrySet() )
			{
				mailDomStr = new StringBuffer();
				String reportToMailId = entry.getKey();
				System.out.println( "reportToMailId : ["+ reportToMailId +"]" );
				
				HashMap<String,String> spNamesMap = entry.getValue();
				List<String> spNameList = new ArrayList<String>( spNamesMap.values() );
				System.out.println( "spNameList : ["+ spNameList +"]" );
				String salesPersonNames = spNameList.toString().replace("[", "").replace("]", "").replaceAll("&", "and");
				System.out.println( "salesPersonNames : ["+ salesPersonNames +"]" );
				
				HashMap<String, String> rsmMailIdMap = reportToRSMEmailIdMap.get( reportToMailId );
				String rsmMailId = "";
				List<String> rsmMailIdList = null;
				if ( reportToRSMEmailIdMap != null && reportToRSMEmailIdMap.size() > 0 )
				{
					rsmMailIdList = new ArrayList<String>( rsmMailIdMap.keySet() );
					System.out.println( "rsmMailIdList : ["+ rsmMailIdList +"]" );
					rsmMailId = rsmMailIdList.toString().replace("[", "").replace("]", "");
					System.out.println( "salesPersonNames : ["+ salesPersonNames +"]" );
				}
				rsmMailId = checkNull( rsmMailId );
				if ( rsmMailId.length() > 0 )
				{
					rsmMailId += "," + userInfo.getLoginEmailId();
				}
				else
				{
					rsmMailId = userInfo.getLoginEmailId();
				}
				if( mailSubjNBodyTextMap != null && mailSubjNBodyTextMap.size() > 0 )
				{
					subject = mailSubjNBodyTextMap.get("SUBJECT");
					bodyText = mailSubjNBodyTextMap.get("BODY_TEXT");
					bodyText = bodyText +" \n\n"+ salesPersonNames;
				}
				else
				{
					 subject = "Missing Sell In and Sell Out";
					 bodyText = "Following sales person(s) missing Sell In and Sell Out for last week. \n\n"+ salesPersonNames;
				}
				try
				{
					mailDomStr.append( "<ROOT>" );
					mailDomStr.append( "<MAIL>" );
					mailDomStr.append( "<EMAIL_TYPE>page</EMAIL_TYPE>" );
					mailDomStr.append( "<ENTITY_CODE>" ).append( entityCode ).append( "</ENTITY_CODE>" ); 
					mailDomStr.append( "<ENTITY_TYPE>" ).append( "E" ).append( "</ENTITY_TYPE>" );
					mailDomStr.append( "<SUBJECT>" ).append( subject ).append( "</SUBJECT>" );
					mailDomStr.append( "<BODY_TEXT>" ).append( bodyText ).append( "</BODY_TEXT>" );
					mailDomStr.append( "<TO_ADD>" ).append( reportToMailId ).append( "</TO_ADD>" );
					mailDomStr.append( "<CC_ADD>" ).append( rsmMailId ).append( "</CC_ADD>" );
					mailDomStr.append( "<FORMAT_CODE></FORMAT_CODE>" );
					mailDomStr.append( "<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>" );
					mailDomStr.append( "</MAIL>" );
					mailDomStr.append( "<XML_DATA></XML_DATA>" );
					mailDomStr.append( "</ROOT>" );

					System.out.println("sendNotificationEmailToManager mailDomStr :: ["+ mailDomStr +"]");
					EMail email = new EMail();
					email.sendMail( mailDomStr.toString(), "ITM", conn );
				}
				catch (Exception e) 
				{
					System.out.println( "Exception :: sendNotificationEmaiToManager : ["+ e.getMessage() +"]" );
					e.printStackTrace();
				}
			}
		}
		catch (Exception e) 
		{
			System.out.println( "ITMException :: sendNotificationEmaiToManager : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
	}
	
	private HashMap<String, String> getMailSubjectNBodyTextData( String spMailFormatCode, Connection conn )
	{
		HashMap<String, String > getMailSubNBodyTextMap = new HashMap<String, String>();
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String subject = "";
		String mailBody = "";
		try
		{
			String sql = "SELECT SUBJECT,BODY_TEXT FROM MAIL_FORMAT WHERE FORMAT_CODE = ?";
			System.out.println(" sql : [" + sql + "]");
			
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, spMailFormatCode);
			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				subject = rs.getString("SUBJECT");
				mailBody = rs.getString("BODY_TEXT");
			}
			getMailSubNBodyTextMap.put("SUBJECT", subject );
			getMailSubNBodyTextMap.put("BODY_TEXT", mailBody );
			
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception e)
		{
			System.out.println( "Exception :: getMailSubjectNBodyTextData : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		return getMailSubNBodyTextMap;
	}
	
	private static String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	
	@Override
	public String schedulePriority(String wrkflwPriority) throws Exception 
	{
		return null;
	}
	
	@Override
	public String schedule(HashMap map) throws Exception 
	{
		return null;
	}
}