/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.ejb.session;

import ibase.bi.bean.DateBean;
import ibase.bi.common.system.config.DBInfo;
import ibase.bi.ejb.session.DBAccessEJB;
import ibase.bi.ejb.session.DrillParser;
import ibase.bi.ejb.session.OrderedMap;
import ibase.bi.ejb.session.QueryBuilderLocal;
import ibase.bi.ejb.session.QueryBuilderRemote;
import ibase.bi.ejb.session.TableInfoBean;
import ibase.bi.ejb.session.XMLExplorer;
import ibase.bi.utility.BIException;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.UserConstants;
import java.io.ByteArrayInputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Stateless(name="QueryBuilderEJB")
public class QueryBuilderEJB
implements QueryBuilderRemote,
QueryBuilderLocal {
    private String userID;
    private String profileID;
    private int baID;
    private String baName;
    private String queryMode;
    private XMLExplorer xe;
    private HashMap queryInfo;
    private HashMap logicalMap;
    private HashMap nameMap;
    private HashMap dbTableMap;
    private HashMap javaTypeMappings;
    private HashMap disPatternMappings;
    private HashMap dbPatternMappings;
    private HashMap expressionTypeMappings;
    private TreeMap joinOrder;
    private HashMap joinInfo;
    private ArrayList selectedTables;
    private ArrayList winFuncIDList;
    private ArrayList winFuncExpList;
    private ArrayList groupFuncIDList;
    private ArrayList groupExcludeList;
    private String curGroupFuncExpression;
    private ArrayList havingList;
    private OrderedMap selectedElements;
    private OrderedMap selectedFieldNames;
    private StringBuffer newSelectBuffer;
    private ArrayList toGroupElements;
    private HashMap queryStringInfo;
    private ArrayList calList;
    private int posPrompt;
    private boolean isGroup;
    private boolean isWinFunction;
    private boolean isGroupFunction;
    private boolean isAggFuncExists;
    private String calWhereString;
    private StringBuffer havingClause;
    private String currFuncDataType;
    private HashMap whereCondition;
    private String whereStmt = null;
    private HashMap dimMap;
    private HashMap logicalPhysicalMap = null;

    @PostConstruct
    public void postConstructCallback() {
        BaseLogger.log("1", null, null, "QueryBuilderEJB PostConstruct -  ");
    }

    @PreDestroy
    public void preDestroyCallback() {
        BaseLogger.log("1", null, null, "QueryBuilderEJB  PreDestory -   ");
    }

    private void initialize(int baID, String baName, String userID, String profileID, HashMap queryInfo, HashMap columnDefaultFunctionMap) throws Exception {
        BaseLogger.log("3", null, null, "\n\n\n\t\t Initializing .........");
        this.userID = userID;
        this.profileID = profileID;
        this.baID = baID;
        this.baName = baName;
        this.queryInfo = queryInfo;
        this.xe = new XMLExplorer();
        this.xe.parseXML(baName, userID);
        System.out.println("xe after parseXML ::::" + this.xe + " xe.dbTableMappings " + this.xe.dbTableMappings);
        this.nameMap = this.xe.nameMappings;
        this.dbTableMap = this.xe.dbTableMappings;
        this.javaTypeMappings = this.xe.javaTypeMappings;
        this.disPatternMappings = this.xe.disPatternMappings;
        this.dbPatternMappings = this.xe.dbPatternMappings;
        this.expressionTypeMappings = new HashMap();
        if (columnDefaultFunctionMap == null) {
            this.expressionTypeMappings = this.xe.expressionTypeMappings;
        } else {
            this.expressionTypeMappings.putAll(columnDefaultFunctionMap);
        }
        this.joinOrder = this.xe.joinOrder;
        this.joinInfo = this.xe.joinInfo;
        this.selectedTables = new ArrayList();
        this.selectedElements = new OrderedMap();
        this.selectedFieldNames = new OrderedMap();
        this.toGroupElements = new ArrayList();
        this.queryStringInfo = new HashMap();
        this.calList = new ArrayList();
        this.winFuncIDList = new ArrayList();
        this.winFuncExpList = new ArrayList();
        this.groupFuncIDList = new ArrayList();
        this.posPrompt = 0;
    }

    @Override
    public String createSQL(int baID, String baName, String userID, String profileID, HashMap queryInfo, HashMap columnDefaultFunctionMap, HashMap logicalPhysicalMap, String queryMode) throws RemoteException, Exception {
        try {
            this.initialize(baID, baName, userID, profileID, queryInfo, columnDefaultFunctionMap);
            Iterator itr = this.queryInfo.keySet().iterator();
            this.whereCondition = null;
            this.queryMode = queryMode;
            this.logicalPhysicalMap = logicalPhysicalMap;
            while (itr.hasNext()) {
                Integer key = (Integer)itr.next();
                this.readQueryInfo(key);
            }
            String query = this.buildSQL();
            return query;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void readQueryInfo(Integer queryNo) throws Exception {
        StringBuffer query = new StringBuffer();
        if (this.queryInfo.containsKey(queryNo)) {
            ArrayList qPBean = (ArrayList)this.queryInfo.get(queryNo);
            if (qPBean != null && qPBean.size() >= 6) {
                this.calList = (ArrayList)qPBean.get(5);
            }
            String selectPart = this.buildSelect(qPBean);
            String wherePart = this.buildWhere((ArrayList)qPBean.get(4), queryNo.toString());
            String fromPart = this.buildFrom();
            StringBuffer winFuncExpBuffer = new StringBuffer();
            int ctr = 0;
            while (ctr < this.winFuncExpList.size()) {
                String newElement = this.winFuncExpList.get(ctr).toString();
                if (selectPart.indexOf(newElement) == -1) {
                    winFuncExpBuffer.append(String.valueOf(newElement) + ",");
                }
                ++ctr;
            }
            if (winFuncExpBuffer.toString().endsWith(",")) {
                winFuncExpBuffer = winFuncExpBuffer.deleteCharAt(winFuncExpBuffer.toString().lastIndexOf(","));
            }
            StringBuffer winFuncIDBuffer = new StringBuffer();
            int ctr2 = 0;
            while (ctr2 < this.winFuncIDList.size()) {
                winFuncIDBuffer.append(this.winFuncIDList.get(ctr2));
                ++ctr2;
            }
            if (winFuncIDBuffer.toString().toUpperCase().endsWith(" AND")) {
                winFuncIDBuffer = winFuncIDBuffer.delete(winFuncIDBuffer.toString().lastIndexOf("And"), winFuncIDBuffer.toString().length() - 1);
            } else if (winFuncIDBuffer.toString().toUpperCase().endsWith(" OR")) {
                winFuncIDBuffer = winFuncIDBuffer.delete(winFuncIDBuffer.toString().lastIndexOf(" Or"), winFuncIDBuffer.toString().length() - 1);
            }
            StringBuffer havingExpBuffer = new StringBuffer();
            int ctr3 = 0;
            while (ctr3 < this.groupFuncIDList.size()) {
                String havingConditions = this.groupFuncIDList.get(ctr3).toString();
                havingExpBuffer.append(String.valueOf(havingConditions) + ",");
                ++ctr3;
            }
            if (havingExpBuffer.toString().endsWith(",")) {
                havingExpBuffer = havingExpBuffer.deleteCharAt(havingExpBuffer.toString().lastIndexOf(","));
            }
            if (selectPart != null && selectPart.length() > 0) {
                if (winFuncExpBuffer != null && winFuncExpBuffer.length() > 0) {
                    query.append(String.valueOf(selectPart) + "," + winFuncExpBuffer.toString() + " ");
                    winFuncExpBuffer = null;
                } else {
                    query.append(String.valueOf(selectPart) + " ");
                }
            }
            if (fromPart != null && fromPart.length() > 0) {
                query.append(String.valueOf(fromPart) + " ");
            }
            if (wherePart != null && wherePart.length() > 0) {
                query.append(String.valueOf(wherePart) + " ");
            }
            if (havingExpBuffer != null && havingExpBuffer.length() > 0) {
                query.append("HAVING " + havingExpBuffer.toString());
            }
            if (winFuncIDBuffer != null && winFuncIDBuffer.length() > 0) {
                query = new StringBuffer("SELECT " + this.newSelectBuffer.toString() + "FROM (" + query + ") OFTab WHERE " + winFuncIDBuffer.toString());
                this.newSelectBuffer = null;
                winFuncIDBuffer = null;
            } else if (this.isAggFuncExists) {
                query = new StringBuffer("SELECT " + this.newSelectBuffer.toString() + "FROM (" + query + ") ");
                ArrayList groupFilterList = this.toGroupElements;
                if (this.groupExcludeList != null && this.groupExcludeList.size() != 0) {
                    int i = 0;
                    while (i < groupFilterList.size()) {
                        if (this.groupExcludeList.contains(groupFilterList.get(i))) {
                            groupFilterList.remove(i);
                        }
                        ++i;
                    }
                }
                if (this.toGroupElements.size() > 0) {
                    query.append(" GROUP BY ");
                }
                int ctr4 = 0;
                while (ctr4 < groupFilterList.size()) {
                    String fieldName = (String)groupFilterList.get(ctr4);
                    query.append(String.valueOf(fieldName.substring(fieldName.lastIndexOf(".") + 1)) + ", ");
                    ++ctr4;
                }
                int index = query.toString().lastIndexOf(",");
                query.replace(index, index + 1, " ");
                this.newSelectBuffer = null;
                winFuncIDBuffer = null;
                if (this.groupExcludeList != null) {
                    this.groupExcludeList.clear();
                }
            }
        }
        this.queryStringInfo.put(queryNo, query);
        this.newSelectBuffer = null;
        this.selectedTables.clear();
        this.selectedElements.clear();
        this.selectedFieldNames.clear();
        this.toGroupElements.clear();
        this.winFuncIDList.clear();
        this.winFuncExpList.clear();
        this.groupFuncIDList.clear();
        this.isAggFuncExists = false;
    }

    private String buildSelect(ArrayList qPBean) throws Exception {
        String fieldName;
        StringBuffer selectBuffer = new StringBuffer();
        this.newSelectBuffer = new StringBuffer();
        UserConstants uc = new UserConstants();
        uc.parseUserConstantsXML(this.userID);
        this.dimMap = new HashMap();
        int pos = 0;
        this.isGroup = false;
        ArrayList<String> logicalNameList = new ArrayList<String>();
        int ctr1 = 0;
        while (ctr1 < 4) {
            ArrayList eachQuadrant = (ArrayList)qPBean.get(ctr1);
            int ctr2 = 0;
            while (ctr2 < eachQuadrant.size()) {
                System.out.println("edit mode  for query " + this.queryMode.equalsIgnoreCase("EDIT"));
                ++pos;
                String logName = ((String)eachQuadrant.get(ctr2)).trim();
                logicalNameList.add(logName);
                if (logName.indexOf("CALCULATION") != -1 && this.queryMode.equalsIgnoreCase("GUI")) {
                    this.getCalExpression(logName, pos, false);
                } else if (this.queryMode != null && this.queryMode.equalsIgnoreCase("GUI") && this.nameMap.containsKey(logName)) {
                    String phyName = ((String)this.nameMap.get(logName)).trim();
                    fieldName = phyName.substring(phyName.lastIndexOf(".") + 1);
                    String tableName = (String)this.dbTableMap.get(logName);
                    String expressionType = (String)this.expressionTypeMappings.get(phyName);
                    if (expressionType == null && this.xe.expressionTypeMappings != null) {
                        expressionType = (String)this.xe.expressionTypeMappings.get(phyName);
                    }
                    if (!expressionType.equals("C")) {
                        this.isGroup = true;
                    }
                    this.selectedElements.put(String.valueOf(pos) + "~" + expressionType, phyName);
                    this.selectedFieldNames.put(String.valueOf(pos) + "~" + expressionType, fieldName);
                    if (!this.selectedTables.contains(tableName) && !tableName.equalsIgnoreCase("DUAL") && tableName.indexOf("DUAL.") == -1) {
                        this.selectedTables.add(tableName);
                    }
                } else if (uc.isUserConstant(logName)) {
                    this.selectedElements.put(String.valueOf(pos) + "~C", ":" + logName + ": AS " + logName);
                    this.selectedFieldNames.put(String.valueOf(pos) + "~C", logName);
                } else {
                    String physicalName = logName;
                    if (this.logicalPhysicalMap != null) {
                        physicalName = (String)this.logicalPhysicalMap.get(logName);
                    }
                    this.selectedElements.put(String.valueOf(pos) + "~G", physicalName);
                    this.selectedFieldNames.put(String.valueOf(pos) + "~G", physicalName);
                }
                ++ctr2;
            }
            ++ctr1;
        }
        ArrayList iter = this.selectedElements.keySet();
        int k = 0;
        while (k < iter.size()) {
            String key = (String)iter.get(k);
            BaseLogger.log("9", null, null, "Key :" + key);
            String expressionType = key.substring(key.indexOf("~") + 1);
            BaseLogger.log("9", null, null, "expressionType :" + expressionType);
            String value = null;
            if ((String)this.selectedElements.get(key) != null) {
                value = ((String)this.selectedElements.get(key)).trim();
            }
            BaseLogger.log("9", null, null, "value :" + value);
            BaseLogger.log("9", null, null, "isGroup :" + this.isGroup);
            if (this.isGroup) {
                if (value.indexOf(" AS ") == -1) {
                    if (expressionType.equalsIgnoreCase("C") || expressionType.equalsIgnoreCase("G") || expressionType.length() == 0) {
                        int index3 = value.indexOf("DUAL.");
                        if (index3 != -1) {
                            value = String.valueOf(value.substring(0, index3)) + value.substring(index3 + 5, value.length());
                        } else if (value.indexOf(" AS ") != -1) {
                            value = value.substring(0, value.indexOf(" AS "));
                        }
                        if (value.indexOf("DIM[") == -1) {
                            this.toGroupElements.add(value);
                        }
                    } else if (expressionType.indexOf("()") != -1) {
                        fieldName = value.substring(value.lastIndexOf(".") + 1);
                        String defaultFunctionName = expressionType.substring(0, expressionType.length() - 2);
                        this.selectedElements.put(key, String.valueOf(defaultFunctionName) + "(" + value + ") AS " + defaultFunctionName + "_" + logicalNameList.get(k).toString());
                        if (this.isAggFuncExists) {
                            this.selectedFieldNames.put(key, String.valueOf(defaultFunctionName) + "(" + defaultFunctionName + "_" + logicalNameList.get(k).toString() + ")");
                        } else {
                            this.selectedFieldNames.put(key, String.valueOf(defaultFunctionName) + "_" + logicalNameList.get(k).toString());
                        }
                    }
                } else {
                    int index4 = value.indexOf("DUAL.");
                    if (index4 != -1) {
                        value = String.valueOf(value.substring(0, index4)) + value.substring(index4 + 5, value.length());
                    }
                    if (expressionType.equalsIgnoreCase("X")) {
                        this.toGroupElements.add(value.substring(0, value.indexOf(" AS ")));
                    } else if (expressionType.equalsIgnoreCase("C")) {
                        this.toGroupElements.add(value.substring(0, value.indexOf(" AS ")));
                    }
                }
            }
            ++k;
        }
        BaseLogger.log("9", null, null, "selectedElements :" + this.selectedElements);
        BaseLogger.log("9", null, null, "selectedFieldNames :" + this.selectedFieldNames);
        BaseLogger.log("9", null, null, "toGroupElements :" + this.toGroupElements);
        ArrayList iter1 = this.selectedElements.keySet();
        BaseLogger.log("9", null, null, "iter1 :" + iter1);
        int p = 0;
        while (p < iter1.size()) {
            StringBuffer tempBuff;
            String colName;
            String dimName;
            String logicalName = (String)iter1.get(p);
            String selElm = (String)this.selectedElements.get(logicalName);
            BaseLogger.log("9", null, null, "selElm :" + selElm);
            String selFieldName = (String)this.selectedFieldNames.get(logicalName);
            BaseLogger.log("9", null, null, "selFieldName :" + selFieldName);
            String columnNameInSel = "";
            String fieldName2 = "";
            if (selElm != null) {
                columnNameInSel = selElm.trim();
            }
            if (selFieldName != null) {
                fieldName2 = selFieldName.trim();
            }
            int index = columnNameInSel.indexOf("DUAL.");
            ArrayList<String> inSelectBuffList = new ArrayList<String>();
            ArrayList<String> inNewSelBuffList = new ArrayList<String>();
            if (index != -1) {
                columnNameInSel = String.valueOf(columnNameInSel.substring(0, index)) + columnNameInSel.substring(index + 5, columnNameInSel.length());
            }
            int dimStartIndex = 0;
            int dimEndIndex = -1;
            while (columnNameInSel.indexOf("DIM[") != -1) {
                dimStartIndex = columnNameInSel.indexOf("DIM[", 0);
                dimEndIndex = columnNameInSel.indexOf("]", dimStartIndex);
                dimName = columnNameInSel.substring(dimStartIndex + 4, dimEndIndex);
                colName = this.dimMap.get(dimName).toString();
                tempBuff = new StringBuffer(columnNameInSel);
                if (!colName.equals("null")) {
                    tempBuff.replace(dimStartIndex, dimEndIndex + 1, colName);
                } else {
                    tempBuff.replace(dimStartIndex, dimEndIndex + 1, "");
                }
                columnNameInSel = tempBuff.toString();
                dimStartIndex = dimEndIndex;
                BaseLogger.log("3", null, null, "columnNameInSel after replacing:" + columnNameInSel);
            }
            while (fieldName2.indexOf("DIM[") != -1) {
                dimStartIndex = fieldName2.indexOf("DIM[", 0);
                dimEndIndex = fieldName2.indexOf("]", dimStartIndex);
                dimName = fieldName2.substring(dimStartIndex + 4, dimEndIndex);
                colName = this.dimMap.get(dimName).toString();
                tempBuff = new StringBuffer(fieldName2);
                tempBuff.replace(dimStartIndex, dimEndIndex + 1, "'" + colName + "'," + colName.substring(colName.lastIndexOf(".") + 1));
                fieldName2 = tempBuff.toString();
                dimStartIndex = dimEndIndex;
                BaseLogger.log("3", null, null, "fieldName after replacing:" + fieldName2);
            }
            if (this.isAggFuncExists) {
                String str;
                StringTokenizer st;
                if (columnNameInSel.indexOf(",") == -1 && selectBuffer.toString().indexOf(columnNameInSel) == -1) {
                    selectBuffer.append(String.valueOf(columnNameInSel) + ",");
                } else if (columnNameInSel.indexOf(",") != -1) {
                    st = new StringTokenizer(columnNameInSel, ",");
                    while (st.hasMoreTokens()) {
                        str = st.nextToken().trim();
                        if (selectBuffer.toString().indexOf(str) != -1) continue;
                        selectBuffer.append(String.valueOf(str) + ",");
                    }
                }
                if (this.newSelectBuffer.toString().indexOf(fieldName2) == -1) {
                    this.newSelectBuffer.append(String.valueOf(fieldName2) + ",");
                } else if (fieldName2.indexOf(",") != -1) {
                    st = new StringTokenizer(fieldName2, ",");
                    while (st.hasMoreTokens()) {
                        str = st.nextToken().trim();
                        if (this.newSelectBuffer.toString().indexOf(str) != -1) continue;
                        this.newSelectBuffer.append(String.valueOf(str) + ",");
                    }
                }
            } else {
                if (!inSelectBuffList.contains(columnNameInSel)) {
                    selectBuffer.append(String.valueOf(columnNameInSel) + ",");
                    inSelectBuffList.add(columnNameInSel);
                }
                if (!inNewSelBuffList.contains(fieldName2)) {
                    this.newSelectBuffer.append(String.valueOf(fieldName2) + ",");
                    inNewSelBuffList.add(fieldName2);
                }
            }
            if (!inSelectBuffList.contains(columnNameInSel)) {
                selectBuffer.append(String.valueOf(columnNameInSel) + ",");
                inSelectBuffList.add(columnNameInSel);
            }
            if (!inNewSelBuffList.contains(fieldName2)) {
                this.newSelectBuffer.append(String.valueOf(fieldName2) + ",");
                inNewSelBuffList.add(fieldName2);
            }
            ++p;
        }
        int index = selectBuffer.toString().lastIndexOf(",");
        selectBuffer.replace(index, index + 1, " ");
        index = this.newSelectBuffer.toString().lastIndexOf(",");
        this.newSelectBuffer.replace(index, index + 1, " ");
        String _sqlSelectPart = "SELECT " + selectBuffer.toString();
        System.out.println("QueryBuilderEJB : buildSelect " + _sqlSelectPart);
        return _sqlSelectPart;
    }

    private String buildWhere(ArrayList userWhereList, String queryNo) throws Exception {
        System.out.println("buildWhere  NEW" + userWhereList);
        DateBean dtbean = new DateBean();
        StringBuffer whereBuffer = new StringBuffer();
        StringBuffer groupByBuffer = new StringBuffer();
        StringBuffer userWhereBuffer = new StringBuffer();
        int subQueryCount = 1;
        int ctr = 0;
        while (ctr < userWhereList.size()) {
            String lOperand;
            ArrayList eachUserWhereInfo = (ArrayList)userWhereList.get(ctr);
            String oriLOperand = lOperand = ((String)eachUserWhereInfo.get(0)).trim();
            System.out.println("lOperand " + lOperand);
            if (lOperand.indexOf("CALCULATION") == -1) {
                if (this.nameMap.containsKey(lOperand)) {
                    System.out.println("dbTableMap new  " + this.dbTableMap);
                    String tableName = (String)this.dbTableMap.get(lOperand);
                    lOperand = ((String)this.nameMap.get(lOperand)).trim();
                    int index1 = lOperand.indexOf("DUAL.");
                    if (index1 != -1) {
                        lOperand = String.valueOf(lOperand.substring(0, index1)) + lOperand.substring(index1 + 5, lOperand.length());
                    } else if (!this.selectedTables.contains(tableName)) {
                        this.selectedTables.add(tableName);
                    }
                } else {
                    lOperand = ":" + lOperand + ":";
                }
            } else {
                this.calWhereString = "";
                this.getCalExpression(lOperand, 0, true);
                lOperand = this.calWhereString;
            }
            String operator = ((String)eachUserWhereInfo.get(1)).trim();
            String userWhereType = ((String)eachUserWhereInfo.get(2)).trim();
            String rOperand = (String)eachUserWhereInfo.get(3);
            ArrayList rOperandList = null;
            boolean flag = false;
            boolean nullCheck = false;
            if (operator.equalsIgnoreCase("Exists")) {
                flag = true;
                operator = "IN";
            } else if (operator.equalsIgnoreCase("IS")) {
                nullCheck = true;
            } else if (operator.equalsIgnoreCase("NOT IN")) {
                flag = true;
            }
            if (userWhereType.equalsIgnoreCase("Prompt")) {
                rOperand = operator.equalsIgnoreCase("Between") ? "&&" + this.posPrompt++ + "." + rOperand + "&&" + " AND " + "&&" + this.posPrompt++ + ".And&&" : "&&" + this.posPrompt++ + "." + rOperand + "&&";
            } else if (userWhereType.equalsIgnoreCase("Constant")) {
                rOperandList = this.getROperandList(rOperand);
                StringBuffer rOperandBuffer = new StringBuffer();
                if (oriLOperand.indexOf("CALCULATION") == -1) {
                    int x;
                    String javaType = null;
                    String dispattern = null;
                    String dbpattern = null;
                    String tempVal = null;
                    if (this.disPatternMappings.get((String)eachUserWhereInfo.get(0)) != null) {
                        dispattern = (String)this.disPatternMappings.get((String)eachUserWhereInfo.get(0));
                    }
                    if (this.dbPatternMappings.get((String)eachUserWhereInfo.get(0)) != null) {
                        dbpattern = (String)this.dbPatternMappings.get((String)eachUserWhereInfo.get(0));
                    }
                    if ((javaType = this.javaTypeMappings.get((String)eachUserWhereInfo.get(0)) != null ? ((String)this.javaTypeMappings.get(((String)eachUserWhereInfo.get(0)).trim())).trim() : "").indexOf("Double") != -1 || javaType.indexOf("BigDecimal") != -1) {
                        x = 0;
                        while (x < rOperandList.size()) {
                            tempVal = (String)rOperandList.get(x);
                            if (dispattern != null && dbpattern != null && tempVal.indexOf("@@") == -1) {
                                tempVal = dtbean.convertPattern(dispattern, dbpattern, tempVal);
                            }
                            rOperandBuffer.append(tempVal).append(",");
                            ++x;
                        }
                    } else {
                        x = 0;
                        while (x < rOperandList.size()) {
                            if (nullCheck) {
                                if (((String)rOperandList.get(x)).trim().equalsIgnoreCase("NULL") || ((String)rOperandList.get(x)).equalsIgnoreCase("NOT NULL")) {
                                    rOperandBuffer.append((String)rOperandList.get(x)).append(",");
                                }
                                nullCheck = false;
                            } else if (((String)rOperandList.get(x)).indexOf(" AND ") != -1 || ((String)rOperandList.get(x)).indexOf(" and ") != -1) {
                                String subrOperandString1 = "";
                                String subrOperandString2 = "";
                                String rOperandString = (String)rOperandList.get(x);
                                if (((String)rOperandList.get(x)).indexOf(" AND ") != -1) {
                                    subrOperandString1 = rOperandString.substring(0, rOperandString.indexOf(" AND "));
                                    subrOperandString2 = rOperandString.substring(rOperandString.indexOf(" AND ") + 5, rOperandString.length());
                                }
                                if (((String)rOperandList.get(x)).indexOf(" and ") != -1) {
                                    subrOperandString1 = rOperandString.substring(0, rOperandString.indexOf(" and "));
                                    subrOperandString2 = rOperandString.substring(rOperandString.indexOf(" and ") + 5, rOperandString.length());
                                }
                                String tempVal1 = subrOperandString1.trim();
                                String tempVal2 = subrOperandString2.trim();
                                if (dispattern != null && dbpattern != null) {
                                    if (tempVal1.indexOf("@@") == -1) {
                                        tempVal1 = dtbean.convertPattern(dispattern, dbpattern, tempVal1);
                                    }
                                    if (tempVal2.indexOf("@@") == -1) {
                                        tempVal2 = dtbean.convertPattern(dispattern, dbpattern, tempVal2);
                                    }
                                }
                                String finalrOperandString = "'" + tempVal1 + "'" + " AND " + "'" + tempVal2 + "'";
                                rOperandBuffer.append(finalrOperandString).append(",");
                            } else {
                                tempVal = (String)rOperandList.get(x);
                                if (dispattern != null && dbpattern != null && tempVal.indexOf("@@") == -1) {
                                    tempVal = dtbean.convertPattern(dispattern, dbpattern, tempVal);
                                }
                                rOperandBuffer.append("'").append(tempVal).append("'").append(",");
                            }
                            ++x;
                        }
                    }
                } else if (this.currFuncDataType.toUpperCase().indexOf("NUMBER") != -1) {
                    int x = 0;
                    while (x < rOperandList.size()) {
                        rOperandBuffer.append((String)rOperandList.get(x)).append(",");
                        ++x;
                    }
                } else {
                    int x = 0;
                    while (x < rOperandList.size()) {
                        rOperandBuffer.append("'").append((String)rOperandList.get(x)).append("'").append(",");
                        ++x;
                    }
                }
                rOperand = rOperandBuffer.deleteCharAt(rOperandBuffer.length() - 1).toString();
            } else if (userWhereType.equalsIgnoreCase("Subquery")) {
                rOperand = "~" + queryNo + subQueryCount++ + "~";
            } else if (userWhereType.equalsIgnoreCase("Function")) {
                String fnName = ((String)eachUserWhereInfo.get(4)).trim();
                String colName = ((String)eachUserWhereInfo.get(5)).trim();
                if (fnName.equalsIgnoreCase("SYSDATE")) {
                    rOperand = fnName;
                } else {
                    DBInfo.newInstance(this.xe.dbName);
                    String expressionType = DBInfo.getFunctionType(fnName);
                    expressionType = expressionType.substring(2, expressionType.length());
                    colName = ((String)this.nameMap.get(colName)).trim();
                    rOperand = expressionType.equalsIgnoreCase("G") ? "( SELECT " + fnName + "(" + colName + ") FROM " + colName.substring(0, colName.lastIndexOf(".")) + " )" : String.valueOf(fnName) + "(" + colName + ") ";
                    int index2 = rOperand.indexOf("DUAL.");
                    if (index2 != -1) {
                        rOperand = String.valueOf(rOperand.substring(0, index2)) + rOperand.substring(index2 + 5, rOperand.length());
                    }
                }
            } else if (userWhereType.equalsIgnoreCase("Column")) {
                String colName = ((String)eachUserWhereInfo.get(5)).trim();
                System.out.println("rOperand colName " + colName);
                String tempcolName = colName;
                rOperand = colName.indexOf("CALCULATION") == -1 ? (colName = ((String)this.nameMap.get(colName)).trim()) : colName;
                int index = rOperand.indexOf("DUAL.");
                if (rOperand.indexOf("CALCULATION") != -1) {
                    this.calWhereString = "";
                    this.getCalExpression(rOperand, 0, true);
                    rOperand = this.calWhereString;
                } else if (index != -1) {
                    rOperand = String.valueOf(rOperand.substring(0, index)) + rOperand.substring(index + 5, rOperand.length());
                } else {
                    System.out.println("tempcolName dbTableMap " + this.dbTableMap + " tempcolName " + tempcolName);
                    String tableName = (String)this.dbTableMap.get(tempcolName);
                    System.out.println("tempcolName tableName " + tableName);
                    if (!this.selectedTables.contains(tableName)) {
                        this.selectedTables.add(tableName);
                    }
                }
            } else if (userWhereType.equalsIgnoreCase("User Constants")) {
                rOperand = ":" + ((String)eachUserWhereInfo.get(5)).trim() + ":";
            }
            if (flag) {
                rOperand = "(" + rOperand + ") ";
                flag = false;
            }
            this.updateWhereInputs(((String)eachUserWhereInfo.get(0)).trim(), rOperand, ctr, queryNo);
            String logOperator = ((String)eachUserWhereInfo.get(6)).trim();
            if (!this.isWinFunction && !this.isGroupFunction) {
                if (logOperator.equalsIgnoreCase("AND") || logOperator.equalsIgnoreCase("OR")) {
                    userWhereBuffer.append("(" + lOperand + " " + operator + " " + rOperand + ") " + logOperator + " ");
                } else if (logOperator.equalsIgnoreCase("AND (") || logOperator.equalsIgnoreCase("OR (")) {
                    userWhereBuffer.append("(" + lOperand + " " + operator + " " + rOperand + ") " + logOperator + " ");
                } else if (logOperator.equalsIgnoreCase(") AND") || logOperator.equalsIgnoreCase(") OR")) {
                    userWhereBuffer.append("(" + lOperand + " " + operator + " " + rOperand + ") " + logOperator + " ");
                } else if (logOperator.equalsIgnoreCase(")")) {
                    userWhereBuffer.append("(" + lOperand + " " + operator + " " + rOperand + ") " + logOperator + " ");
                } else {
                    userWhereBuffer.append("(" + lOperand + " " + operator + " " + rOperand + ") ");
                }
            } else {
                if (userWhereBuffer != null && ctr + 1 == userWhereList.size()) {
                    String tempString = userWhereBuffer.toString();
                    if (tempString.endsWith("And ")) {
                        userWhereBuffer = new StringBuffer(tempString.substring(0, tempString.lastIndexOf("And")));
                    }
                    if (tempString.endsWith("Or ")) {
                        userWhereBuffer = new StringBuffer(tempString.substring(0, tempString.lastIndexOf("Or")));
                    }
                }
                if (this.isWinFunction) {
                    if (logOperator.equalsIgnoreCase("AND") || logOperator.equalsIgnoreCase("OR")) {
                        this.winFuncIDList.add("(" + oriLOperand + " " + operator + " " + rOperand + ") " + logOperator);
                    } else {
                        this.winFuncIDList.add("(" + oriLOperand + " " + operator + " " + rOperand + ")");
                    }
                    this.isWinFunction = false;
                } else if (this.isGroupFunction) {
                    this.groupFuncIDList.add("(" + this.curGroupFuncExpression + " " + operator + " " + rOperand + ") ");
                    this.isGroupFunction = false;
                }
            }
            ++ctr;
        }
        String rowSecurityWhere = this.readRowSecurity();
        String joinPredicates = this.readJoinInfo();
        if (joinPredicates != null) {
            whereBuffer.append(joinPredicates);
        }
        if (rowSecurityWhere != null) {
            if (whereBuffer.length() > 0) {
                whereBuffer.append(" AND ");
            }
            whereBuffer.append(rowSecurityWhere);
        }
        if (userWhereBuffer != null && userWhereBuffer.length() > 0) {
            if (whereBuffer.length() > 0) {
                whereBuffer.append(" AND ");
            }
            whereBuffer.append("(" + userWhereBuffer + ")");
        }
        if (this.winFuncExpList.size() > 0 || this.isAggFuncExists) {
            ArrayList iter = this.selectedElements.keySet();
            int k = 0;
            while (k < iter.size()) {
                String key = (String)iter.get(k);
                String expressionType = key.substring(key.indexOf("~") + 1);
                String value = ((String)this.selectedElements.get(key)).trim();
                if (this.isGroup) {
                    if (value.indexOf(" AS ") == -1) {
                        if (expressionType.equalsIgnoreCase("C") || expressionType.equalsIgnoreCase("G") || expressionType.length() == 0) {
                            int index3 = value.indexOf("DUAL.");
                            if (index3 != -1) {
                                value = String.valueOf(value.substring(0, index3)) + value.substring(index3 + 5, value.length());
                            } else if (value.indexOf(" AS ") != -1) {
                                value = value.substring(0, value.indexOf(" AS "));
                            }
                            while (value.indexOf(",") != -1) {
                                String str = value.substring(0, value.indexOf(","));
                                if (str.indexOf("DIM[") == -1) {
                                    this.toGroupElements.add(str);
                                }
                                value = value.substring(value.indexOf(",") + 1);
                            }
                            if (value.indexOf("DIM[") == -1) {
                                this.toGroupElements.add(value);
                            }
                        }
                    } else {
                        int index4 = value.indexOf("DUAL.");
                        if (index4 != -1) {
                            value = String.valueOf(value.substring(0, index4)) + value.substring(index4 + 5, value.length());
                        }
                        if (expressionType.equalsIgnoreCase("X")) {
                            this.toGroupElements.add(value.substring(0, value.indexOf(" AS ")));
                        } else if (expressionType.equalsIgnoreCase("C")) {
                            this.toGroupElements.add(value.substring(0, value.indexOf(" AS ")));
                        }
                    }
                }
                ++k;
            }
        }
        if (this.toGroupElements.size() > 0) {
            int index;
            groupByBuffer = new StringBuffer();
            String currValue = null;
            ArrayList<String> inGroupBuffList = new ArrayList<String>();
            int ctr2 = 0;
            while (ctr2 < this.toGroupElements.size()) {
                currValue = ((String)this.toGroupElements.get(ctr2)).trim();
                if (!inGroupBuffList.contains(currValue) && currValue.indexOf("DIM[") == -1) {
                    groupByBuffer.append(String.valueOf(currValue) + ",");
                    inGroupBuffList.add(currValue);
                }
                ++ctr2;
            }
            if (this.isAggFuncExists && this.groupExcludeList != null && this.groupExcludeList.size() > 0) {
                BaseLogger.log("3", null, null, "this.groupExcludeList :" + this.groupExcludeList.size());
                BaseLogger.log("3", null, null, "this.toGroupElements :" + this.toGroupElements.size());
                ctr2 = 0;
                while (ctr2 < this.groupExcludeList.size()) {
                    if (!this.toGroupElements.contains(this.groupExcludeList.get(ctr2))) {
                        groupByBuffer.append(String.valueOf(((String)this.groupExcludeList.get(ctr2)).trim()) + ",");
                    }
                    ++ctr2;
                }
            }
            if ((index = groupByBuffer.toString().lastIndexOf(44)) != -1) {
                groupByBuffer.replace(index, index + 1, " ");
            }
        }
        String _sqlWherePart = "";
        _sqlWherePart = whereBuffer != null && whereBuffer.length() > 0 ? (groupByBuffer != null && groupByBuffer.length() > 0 ? "WHERE " + whereBuffer.toString().trim() + " GROUP BY " + groupByBuffer.toString().trim() : "WHERE " + whereBuffer.toString().trim()) : (groupByBuffer != null && groupByBuffer.length() > 0 ? " GROUP BY " + groupByBuffer.toString().trim() : null);
        System.out.println("QueryBuilderEJB : buildWhere " + _sqlWherePart);
        return _sqlWherePart;
    }

    private void updateWhereInputs(String lOperand, String rOperand, int whereCtr, String queryNo) throws Exception {
        if (rOperand.indexOf("~") != -1) {
            return;
        }
        this.whereCondition = this.whereCondition == null ? new HashMap() : this.whereCondition;
        rOperand = rOperand.replace('\'', ' ');
        String strNo = null;
        strNo = queryNo.equalsIgnoreCase("1") ? "" : queryNo;
        this.whereCondition.put(String.valueOf(strNo) + lOperand + whereCtr, rOperand);
    }

    @Override
    public HashMap getWhereCondition() throws RemoteException, Exception {
        try {
            return this.whereCondition;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private String buildFrom() throws Exception {
        BaseLogger.log("3", null, null, "Selected Tables :" + this.selectedTables);
        StringBuffer fromBuffer = new StringBuffer();
        int ctr = 0;
        while (ctr < this.selectedTables.size()) {
            fromBuffer.append(this.selectedTables.get(ctr) + ",");
            ++ctr;
        }
        if (fromBuffer != null && fromBuffer.length() > 0) {
            int index = fromBuffer.toString().lastIndexOf(44);
            if (index != -1) {
                fromBuffer.replace(index, index + 1, " ");
            }
            return "FROM " + fromBuffer.toString().trim();
        }
        return "FROM DUAL";
    }

    private HashMap getBIRowSecurity() throws Exception {
        BaseLogger.log("3", null, null, "\n\n getBIRowSecurity");
        String driverInfo = this.xe.driverInfo;
        String driverUsed = null;
        AppConnectParm appConnect = new AppConnectParm("bi");
        Properties props = appConnect.getProperty();
        InitialContext ctx = new InitialContext(props);
        DBAccessEJB dBAccessEJB = new DBAccessEJB();
        driverUsed = driverInfo != null ? driverInfo : this.baName;
        String xml = dBAccessEJB.getRowSecurity(this.baID, this.userID, this.profileID, driverUsed);
        if (!xml.equals("")) {
            HashMap<String, String> rowSecurityInfo = new HashMap<String, String>();
            ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = documentBuilder.parse(new InputSource(bais));
            NodeList nl = doc.getElementsByTagName("TABLE");
            int ctr = 0;
            while (ctr < nl.getLength()) {
                String lineNo = nl.item(ctr).getAttributes().getNamedItem("LINE_NO").getNodeValue();
                String tableName = nl.item(ctr).getAttributes().getNamedItem("NAME").getNodeValue();
                String condition = nl.item(ctr).getFirstChild().getNodeValue();
                rowSecurityInfo.put(tableName, condition);
                ++ctr;
            }
            return rowSecurityInfo;
        }
        return null;
    }

    private String readRowSecurity() throws Exception {
        StringBuffer securityBuffer = new StringBuffer();
        HashMap rowSecurityInfo = this.getBIRowSecurity();
        String isForced = null;
        String temp2 = null;
        String tableName = null;
        if (rowSecurityInfo != null) {
            for (String temp2 : rowSecurityInfo.keySet()) {
                int index = temp2.indexOf(46);
                isForced = temp2.substring(0, index);
                tableName = temp2.substring(index + 1);
                if (this.selectedTables.contains(tableName)) {
                    securityBuffer.append(rowSecurityInfo.get(temp2) + " AND ");
                    continue;
                }
                if (isForced == null || !isForced.equalsIgnoreCase("F")) continue;
                securityBuffer.append(rowSecurityInfo.get(temp2) + " AND ");
                this.selectedTables.add(tableName);
            }
        }
        if (securityBuffer != null && securityBuffer.length() > 0) {
            int index = securityBuffer.toString().lastIndexOf(" AND ");
            if (index != -1) {
                securityBuffer.replace(index, index + 5, " ");
            }
            return "(" + securityBuffer.toString().trim() + ")";
        }
        return null;
    }

    private String readJoinInfo() throws Exception {
        this.addViaTables();
        DBInfo dbInfo = DBInfo.newInstance(this.xe.dbName);
        StringBuffer joinWhere = new StringBuffer();
        Iterator iter = this.joinOrder.keySet().iterator();
        while (iter.hasNext()) {
            String curTableName = ((String)this.joinOrder.get(iter.next())).trim();
            if (!this.selectedTables.contains(curTableName) || !this.joinInfo.containsKey(curTableName)) continue;
            TableInfoBean currInfo = (TableInfoBean)this.joinInfo.get(curTableName);
            ArrayList forKey = currInfo.getForeignKeys();
            int ctr = 0;
            while (ctr < forKey.size()) {
                StringTokenizer tokens = new StringTokenizer((String)forKey.get(ctr), "#");
                String lhsKeyID = tokens.nextToken();
                String refTableName = tokens.nextToken();
                String forKeyName = tokens.nextToken();
                String joinType = tokens.nextToken();
                if (this.selectedTables.contains(refTableName)) {
                    TableInfoBean refInfo = (TableInfoBean)this.joinInfo.get(refTableName);
                    ArrayList priKey = refInfo.getPrimaryKeys();
                    int ctr1 = 0;
                    while (ctr1 < priKey.size()) {
                        String arrValue = (String)priKey.get(ctr1);
                        String pK = arrValue.substring(arrValue.lastIndexOf("#") + 1);
                        String rhsKeyID = refInfo.getID(arrValue);
                        if (rhsKeyID.equalsIgnoreCase(lhsKeyID)) {
                            if (joinType.equalsIgnoreCase("I")) {
                                joinWhere.append(String.valueOf(curTableName) + "." + forKeyName + " = " + refTableName + "." + pK + " AND ");
                            } else if (joinType.equalsIgnoreCase("RO")) {
                                if (DBInfo.OUTER_JOIN != null) {
                                    joinWhere.append(String.valueOf(curTableName) + "." + forKeyName + " = " + refTableName + "." + pK + DBInfo.OUTER_JOIN + " AND ");
                                }
                            } else if (joinType.equalsIgnoreCase("LO") && DBInfo.OUTER_JOIN != null) {
                                joinWhere.append(String.valueOf(curTableName) + "." + forKeyName + DBInfo.OUTER_JOIN + " = " + refTableName + "." + pK + " AND ");
                            }
                        }
                        ++ctr1;
                    }
                    refInfo = null;
                }
                ++ctr;
            }
            currInfo = null;
        }
        if (joinWhere != null && joinWhere.length() > 0) {
            int index = joinWhere.toString().lastIndexOf(" AND ");
            if (index != -1) {
                joinWhere.replace(index, index + 5, " ");
            }
            return "(" + joinWhere.toString().trim() + ")";
        }
        return null;
    }

    private void addViaTables() throws Exception {
        int size = this.selectedTables.size();
        int ctr = 0;
        while (ctr < size) {
            TableInfoBean tabInfoObj = (TableInfoBean)this.joinInfo.get((String)this.selectedTables.get(ctr));
            if (tabInfoObj != null) {
                String viaTableName = tabInfoObj.getViaTableName();
                ArrayList<String> tempSelectedList = new ArrayList<String>();
                while (viaTableName != null && !this.selectedTables.contains(viaTableName)) {
                    tempSelectedList.add(viaTableName);
                    tabInfoObj = (TableInfoBean)this.joinInfo.get(viaTableName);
                    viaTableName = null;
                    if (tabInfoObj == null) continue;
                    viaTableName = tabInfoObj.getViaTableName();
                }
                if (viaTableName != null && this.selectedTables.contains(viaTableName) && tempSelectedList.size() > 0) {
                    int ctr1 = 0;
                    while (ctr1 < tempSelectedList.size()) {
                        this.selectedTables.add((String)tempSelectedList.get(ctr1));
                        ++ctr1;
                    }
                }
            }
            Object var3_4 = null;
            ++ctr;
        }
    }

    private void getCalExpression(String calID, int pos, boolean toCheckWinFunc) throws Exception {
        BaseLogger.log("9", null, null, "(START getCalExpression)THIS.SELECTED ELEMENTS :" + this.selectedElements);
        boolean isCurGroupFunc = false;
        boolean isCurAggFunc = false;
        boolean isCurWinFunc = false;
        boolean isDim = false;
        this.currFuncDataType = null;
        StringBuffer expression = null;
        StringBuffer tempExpression = null;
        String expressionType = "";
        String calName = "";
        int ctr = 0;
        while (ctr < this.calList.size()) {
            ArrayList calInfo = (ArrayList)this.calList.get(ctr);
            if (calID.equals(((String)calInfo.get(0)).trim())) {
                calName = ((String)calInfo.get(1)).trim();
                expression = new StringBuffer();
                tempExpression = new StringBuffer();
                int ctr1 = 2;
                while (ctr1 < calInfo.size() - 1) {
                    String physicalName;
                    String curValue = (String)calInfo.get(ctr1);
                    while (curValue.indexOf("~k") != -1) {
                        StringBuffer curValueBuff = new StringBuffer(curValue);
                        int startIndex = curValue.indexOf("~k");
                        int endIndex = curValue.indexOf("(", startIndex + 1);
                        String funcName = null;
                        if (endIndex != -1) {
                            funcName = curValueBuff.substring(startIndex + 2, endIndex);
                        } else {
                            funcName = curValueBuff.substring(startIndex + 2);
                            if (funcName.indexOf(41) != -1) {
                                funcName = funcName.substring(0, funcName.indexOf(41) - 1);
                            }
                        }
                        DBInfo.newInstance(this.xe.dbName);
                        String functionKey = DBInfo.getFunctionType(funcName);
                        physicalName = "";
                        if (functionKey != null) {
                            physicalName = functionKey.substring(functionKey.lastIndexOf(".") + 1, functionKey.length());
                            if (expressionType.equals("")) {
                                expressionType = functionKey.substring(2, functionKey.lastIndexOf("."));
                            } else {
                                String nestExpType = functionKey.substring(2, functionKey.lastIndexOf("."));
                                if ("G".equals(nestExpType)) {
                                    expressionType = nestExpType;
                                }
                            }
                        } else {
                            physicalName = funcName;
                            functionKey = funcName;
                        }
                        curValueBuff.delete(startIndex, startIndex + 2);
                        int funNIndex = curValueBuff.toString().indexOf(funcName);
                        curValueBuff.replace(funNIndex, funNIndex + funcName.length(), physicalName);
                        curValue = curValueBuff.toString();
                        String winFunctionStr = functionKey.substring(0, 1);
                        BaseLogger.log("9", null, null, "winFunctionStr :" + winFunctionStr);
                        if (winFunctionStr.equals("1")) {
                            isCurWinFunc = true;
                        } else if (winFunctionStr.equals("2")) {
                            isCurAggFunc = true;
                            this.isAggFuncExists = true;
                        }
                        if (!expressionType.equalsIgnoreCase("G")) continue;
                        this.isGroup = true;
                        isCurGroupFunc = true;
                    }
                    StringBuffer funcParams = new StringBuffer();
                    while (curValue.indexOf("~t") != -1) {
                        StringBuffer curValueBuff = new StringBuffer(curValue);
                        int startIndex = curValue.indexOf("~t");
                        int endIndex = curValue.indexOf("~t", startIndex + 1);
                        String logName = curValueBuff.substring(startIndex + 2, endIndex);
                        physicalName = null;
                        String fieldName = null;
                        if (this.nameMap.containsKey(logName)) {
                            String tableName;
                            physicalName = (String)this.nameMap.get(logName);
                            fieldName = physicalName.substring(physicalName.lastIndexOf(".") + 1);
                            funcParams.append(physicalName).append(",");
                            if (isCurAggFunc) {
                                if (this.groupExcludeList == null) {
                                    this.groupExcludeList = new ArrayList();
                                }
                                if (!this.groupExcludeList.contains(physicalName) && physicalName.indexOf("DIM[") == -1) {
                                    this.groupExcludeList.add(physicalName);
                                }
                            }
                            if (!this.selectedTables.contains(tableName = (String)this.dbTableMap.get(logName))) {
                                this.selectedTables.add(tableName);
                            }
                            if (isCurAggFunc) {
                                curValueBuff.replace(startIndex, endIndex + 2, fieldName);
                            } else {
                                curValueBuff.replace(startIndex, endIndex + 2, physicalName);
                            }
                        } else {
                            if (logName.indexOf("DIM") != -1) {
                                int size;
                                isDim = true;
                                boolean isExist = false;
                                String dimName = logName.substring(logName.indexOf("[") + 1, logName.indexOf("]"));
                                DrillParser drillParser = new DrillParser(this.baName);
                                HashMap hierarchieMap = drillParser.getHierarchieMap();
                                ArrayList hierarchieList = (ArrayList)hierarchieMap.get(dimName);
                                int i = size = hierarchieList.size() - 1;
                                while (i >= 0) {
                                    String phyName = this.nameMap.get(hierarchieList.get(i)).toString().trim();
                                    ArrayList selElemList = this.selectedElements.values;
                                    int j = 0;
                                    while (j < selElemList.size()) {
                                        String str = selElemList.get(j).toString().trim();
                                        if (str.indexOf(phyName) != -1) {
                                            isExist = true;
                                            this.dimMap.put(dimName, phyName);
                                            break;
                                        }
                                        if (i == size) {
                                            this.dimMap.put(dimName, "null");
                                        }
                                        ++j;
                                    }
                                    if (isExist) break;
                                    --i;
                                }
                                physicalName = logName;
                                if (isCurAggFunc) {
                                    funcParams.append(logName).append(",");
                                }
                                BaseLogger.log("9", null, null, " **** dimMap **** :" + this.dimMap);
                            } else {
                                physicalName = ":" + logName + ":";
                            }
                            curValueBuff.replace(startIndex, endIndex + 2, physicalName);
                        }
                        curValue = curValueBuff.toString();
                    }
                    while (curValue.indexOf(94) != -1) {
                        curValue = curValue.replace('^', ',');
                    }
                    int index = funcParams.toString().lastIndexOf(",");
                    if (index != -1) {
                        funcParams.replace(index, index + 1, " ");
                    }
                    if (isCurAggFunc) {
                        expression.append(funcParams.toString());
                        tempExpression.append("SUM(" + curValue + ")").append(" AS " + calID);
                    } else {
                        expression.append(curValue);
                        this.calWhereString = expression.toString();
                    }
                    ++ctr1;
                }
                this.currFuncDataType = ((String)calInfo.get(calInfo.size() - 1)).trim();
            }
            ++ctr;
        }
        if (!isCurAggFunc) {
            tempExpression.append(calID);
        }
        if (toCheckWinFunc) {
            if (isCurWinFunc) {
                this.isWinFunction = true;
                this.winFuncExpList.add(String.valueOf(expression.toString()) + " AS " + calID);
            } else if (isCurGroupFunc) {
                this.isGroupFunction = true;
                this.curGroupFuncExpression = expression.toString();
            }
        }
        if (!isCurAggFunc) {
            expression.append(" AS " + calID);
        }
        if (expressionType.length() > 0) {
            this.selectedElements.put(String.valueOf(pos) + "~" + expressionType, expression.toString());
            this.selectedFieldNames.put(String.valueOf(pos) + "~" + expressionType, tempExpression.toString());
        } else {
            this.selectedElements.put(String.valueOf(pos) + "~" + "X", expression.toString());
            this.selectedFieldNames.put(String.valueOf(pos) + "~" + "X", tempExpression.toString());
        }
        BaseLogger.log("9", null, null, "Inner expression :" + expression.toString());
        BaseLogger.log("9", null, null, "Outer expression :" + tempExpression.toString());
        BaseLogger.log("9", null, null, "(END getCalExpression)THIS.SELECTED ELEMENTS :" + this.selectedElements);
        BaseLogger.log("9", null, null, "(END getCalExpression)THIS.SELECTED FIELD NAMES :" + this.selectedFieldNames);
    }

    private String buildSQL() throws Exception {
        ArrayList<String> queries = new ArrayList<String>();
        queries.add("1");
        ArrayList sub = (ArrayList)((ArrayList)this.queryInfo.get(new Integer(1))).get(7);
        int i = 1;
        while (i < sub.size()) {
            if (((String)sub.get(i)).trim().indexOf("u") != -1 || ((String)sub.get(i)).trim().indexOf("In") != -1 || ((String)sub.get(i)).trim().indexOf("UnionAll") != -1 || ((String)sub.get(i)).trim().indexOf("minus") != -1) {
                queries.add(((String)sub.get(i)).trim());
            }
            ++i;
        }
        StringBuffer finalString = new StringBuffer();
        int k = 0;
        while (k < queries.size()) {
            StringBuffer finalQuery = (StringBuffer)this.queryStringInfo.get(new Integer(k + 1));
            BaseLogger.log("3", null, null, "finalQuery :" + finalQuery);
            while (finalQuery.toString().indexOf(126) != -1) {
                int startIndex = finalQuery.toString().indexOf(126);
                int endIndex = finalQuery.toString().indexOf(126, startIndex + 1);
                String qNo = finalQuery.substring(startIndex + 1, endIndex);
                StringBuffer subQuery = (StringBuffer)this.queryStringInfo.get(new Integer(qNo));
                finalQuery.replace(startIndex, endIndex + 1, "(" + subQuery.toString() + ")");
            }
            if (((String)queries.get(k)).endsWith("u")) {
                finalString.append(" UNION ");
                finalString.append(finalQuery);
            } else if (((String)queries.get(k)).endsWith("In")) {
                finalString.append(" INTERSECT ");
                finalString.append(finalQuery);
            } else if (((String)queries.get(k)).endsWith("UnionAll")) {
                finalString.append(" UNION ALL ");
                finalString.append(finalQuery);
            } else if (((String)queries.get(k)).endsWith("minus")) {
                finalString.append(" MINUS ");
                finalString.append(finalQuery);
            } else {
                finalString.append(finalQuery);
            }
            ++k;
        }
        return finalString.toString();
    }

    private ArrayList getROperandList(String rOperand) throws Exception {
        ArrayList<String> rOperandList = null;
        rOperandList = new ArrayList<String>();
        StringTokenizer strTokenizer = new StringTokenizer(rOperand, "~");
        while (strTokenizer.hasMoreTokens()) {
            rOperandList.add(strTokenizer.nextToken());
        }
        return rOperandList;
    }

    @Override
    public String getWhereStmt() throws RemoteException, Exception {
        return "";
    }
}

