/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility.training.bankIntegration;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.utility.training.bankIntegration.CommonMethods;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenerateXmlPayment
extends ActionHandlerEJB {
    UserInfoBean userInfoGlobal = new UserInfoBean();
    CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
    ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
    E12GenericUtility e12GenericUtility = new E12GenericUtility();

    public String actionHandler(String tranID, String xtraParam, Connection conn) throws RemoteException, ITMException {
        String resultgenerate = "";
        BaseLogger.log((String)"3", null, null, (Object)"Inside actionHandler");
        BaseLogger.log((String)"3", null, null, (Object)("GET tranID gsbggsb[" + tranID + "]"));
        BaseLogger.log((String)"3", null, null, (Object)("GET xtraParam [" + xtraParam + "]"));
        String userCode = this.e12GenericUtility.getValueFromXTRA_PARAMS(xtraParam, "loginCode");
        BaseLogger.log((String)"3", null, null, (Object)("Inside GenerateXmlPayment userCode [" + userCode + "]"));
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                UserInfoBean userInfo = this.commonDBAccessEJB.createUserInfo(userCode);
                tranID = "01BPD0089";
                this.generateXML(userInfo, tranID);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return resultgenerate;
    }

    public void generateXML(UserInfoBean userInfo, String tranID) {
        try {
            System.out.println("Inside gsb generateXMl()");
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
            HashMap<String, Object> unsHsbcValuesMap = this.getUnsHsbcDetails(tranID, userInfo);
            System.out.println("unsHsbcValuesMap:::" + unsHsbcValuesMap);
            String sourceFilePath = "/wildfly/BankIntegration/UNS_HSBC.xml";
            Document doc = CommonMethods.readXML(sourceFilePath);
            String destinationFilePath = "/wildfly/BankIntegration/UNS_HSBC_modified.xml";
            System.out.println("destinationFilePath [" + destinationFilePath + "]");
            if (doc != null) {
                Element root = doc.getDocumentElement();
                CommonMethods.modifyElementValue(root, "GrpHdr", "MsgId", unsHsbcValuesMap.get("TRAN_ID").toString().trim());
                CommonMethods.modifyElementValue(root, "GrpHdr", "CreDtTm", unsHsbcValuesMap.get("REF_DATE").toString().trim());
                CommonMethods.modifyElementValue(root, "Authstn", "Cd", "ILEV");
                CommonMethods.modifyElementValue(root, "GrpHdr", "NbOfTxs", "1");
                CommonMethods.modifyElementValue(root, "GrpHdr", "CtrlSum", unsHsbcValuesMap.get("NET_AMT").toString().trim());
                CommonMethods.modifyElementValue(root, "InitgPty", "Nm", "UNIVERSAL NUTRISCIENCE PVT. LTD");
                CommonMethods.modifyElementValue(root, "OrgId", "Id", "ABCXXXXX001");
                CommonMethods.modifyElementValue(root, "PmtInf", "PmtInfId", unsHsbcValuesMap.get("TRAN_ID").toString().trim());
                CommonMethods.modifyElementValue(root, "PmtInf", "PmtMtd", "TRF");
                CommonMethods.modifyElementValue(root, "PmtInf", "NbOfTxs", "1");
                CommonMethods.modifyElementValue(root, "PmtInf", "CtrlSum", unsHsbcValuesMap.get("NET_AMT").toString().trim());
                CommonMethods.modifyElementValue(root, "PmtInf", "ReqdExctnDt", unsHsbcValuesMap.get("REF_DATE").toString().trim());
                CommonMethods.modifyElementValue(root, "Dbtr", "Nm", "UNIVERSAL NUTRISCIENCE PVT. LTD");
                CommonMethods.modifyElementValue(root, "PstlAdr", "StrtNm", "2nd Floor,Fleet House, Andheri - Kurla Rd, Gamdevi, Marol, Naka");
                CommonMethods.modifyElementValue(root, "PstlAdr", "PstCd", "400059");
                CommonMethods.modifyElementValue(root, "PstlAdr", "TwnNm", "Mumbai");
                CommonMethods.modifyElementValue(root, "PstlAdr", "CtrySubDvsn", "Maharashtra");
                CommonMethods.modifyElementValue(root, "PstlAdr", "Ctry", "IN");
                CommonMethods.modifyElementValue(root, "Othr", "Id", unsHsbcValuesMap.get("AC_NO").toString().trim());
                CommonMethods.modifyElementValue(root, "DbtrAcct", "Ccy", "INR");
                CommonMethods.modifyElementValue(root, "PstlAdr", "Ctry", "IN");
                CommonMethods.modifyElementValue(root, "PmtId", "InstrId", unsHsbcValuesMap.get("TRAN_ID").toString().trim());
                CommonMethods.modifyElementValue(root, "PmtId", "EndToEndId", unsHsbcValuesMap.get("TRAN_ID").toString().trim());
                CommonMethods.modifyElementValue(root, "SvcLvl", "Cd", "URNS");
                CommonMethods.modifyElementValue(root, "CtgyPurp", "Cd", "SUPP");
                CommonMethods.modifyElementValue(root, "Amt", "InstdAmt", unsHsbcValuesMap.get("NET_AMT").toString().trim());
                CommonMethods.modifyElementValue(root, "FinInstnId", "Nm", unsHsbcValuesMap.get("BANK_CODE__BEN").toString().trim());
                CommonMethods.modifyElementValue(root, "PstlAdr", "Ctry", "IN");
                CommonMethods.modifyElementValue(root, "Cdtr", "Nm", unsHsbcValuesMap.get("CHQ_NAME").toString().trim());
                CommonMethods.modifyElementValue(root, "PstlAdr", "StrtNm", unsHsbcValuesMap.get("SUPPLIER_ADDRESS").toString().trim());
                CommonMethods.modifyElementValue(root, "PstlAdr", "Ctry", "IN");
                CommonMethods.modifyElementValue(root, "Othr", "Id", unsHsbcValuesMap.get("BANK_ACCT_NO__BEN").toString().trim());
                CommonMethods.modifyElementValue(root, "CdtrAcct", "Nm", unsHsbcValuesMap.get("CHQ_NAME").toString().trim());
                CommonMethods.modifyElementValue(root, "RltdRmtInf", "RmtLctnMtd", "EMAL");
                CommonMethods.modifyElementValue(root, "RltdRmtInf", "RmtLctnElctrncAdr", unsHsbcValuesMap.get("EMAIL_ADDR").toString().trim());
                CommonMethods.modifyElementValue(root, "RfrdDocInf", "Nb", this.getBillNo());
                CommonMethods.modifyElementValue(root, "RfrdDocInf", "RltdDt", this.getBillDate());
                CommonMethods.modifyElementValue(root, "CdOrPrtry", "Prtry", "/AMNT/10.00");
                CommonMethods.modifyElementValue(root, "CdtrRefInf", "Ref", "/AMNT/10.00");
                CommonMethods.modifyElementValue(root, "Strd", "AddtlRmtInf", "/NAMT/" + unsHsbcValuesMap.get("NET_AMT").toString().trim());
                CommonMethods.saveChanges(doc, destinationFilePath);
                System.out.println("XML modified successfully!");
            } else {
                System.out.println("Failed to read XML file.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getBillDate() {
        return null;
    }

    private String getBillNo() {
        return null;
    }

    private HashMap<String, Object> getUnsHsbcDetails(String tranID, UserInfoBean userInfo) throws SQLException {
        HashMap<String, Object> unshsbcDetails = new HashMap<String, Object>();
        System.out.println("Inside getUnsHsbcDetails tranID: [" + tranID + "]");
        System.out.println("Inside getUnsHsbcDetails : [" + userInfo + "]");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String unsHsbcSQL = "SELECT \npay.TRAN_ID, pay.REF_DATE, pay.NET_AMT, pay.SUNDRY_CODE, pay.SUNDRY_TYPE, pay.BANK_CODE, paybank.AC_NO, \nS.ADDR1 || ' ' || S.ADDR2 || ' ' || S.ADDR3 || ' '|| S.CITY || ' '|| S.STATE_CODE AS SUPPLIER_ADDRESS, S.CHQ_NAME, S.EMAIL_ADDR, \nSB.BANK_ACCT_NO__BEN, SB.BANK_CODE__BEN, SB.IFSC\nFROM MISC_PAYMENT pay, MISC_PAYDET paydet,  BANK paybank, SUPPLIER S, SUPPLIER_BANK SB \nWHERE pay.tran_id = ? \nAND SB.ACTIVE_YN ='Y'\nAND pay.tran_id = paydet.tran_id\nAND pay.BANK_CODE = paybank.BANK_CODE \nAND PAY.SUNDRY_CODE = S.SUPP_CODE\nAND s.SUPP_CODE = SB.SUPP_CODE";
                pstmt = connection.prepareStatement(unsHsbcSQL);
                pstmt.setString(1, tranID);
                rs = pstmt.executeQuery();
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                while (rs.next()) {
                    int i = 1;
                    while (i <= columnCount) {
                        String columnName = metaData.getColumnName(i);
                        Object columnValue = rs.getObject(i);
                        unshsbcDetails.put(columnName, columnValue);
                        ++i;
                    }
                    System.out.println("Row Data unshsbcDetails Hashmap: " + unshsbcDetails);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return unshsbcDetails;
    }

    private String getBillDate(String tranID, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log((String)"2", null, null, (Object)"getBillDate calling rsk------------------");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String billdate = "";
        StringBuffer bufferbilldate = new StringBuffer();
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String result = "SELECT BILL_DATE FROM MISC_VOUCHER WHERE TRAN_ID in (select VOUCH_NO from MISC_PAYDET where tran_id = ?)";
                BaseLogger.log((String)"3", null, null, (Object)"getBillDate calling inside Confirm tan_id-----------");
                pstmt = connection.prepareStatement(result);
                pstmt.setString(1, tranID);
                rs = pstmt.executeQuery();
                StringBuilder resultLineOfDate = new StringBuilder();
                while (rs.next()) {
                    billdate = rs.getString("BILL_DATE");
                    resultLineOfDate.append(billdate).append(",");
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(tranID);
                    buffer.append(bufferbilldate);
                }
                if (resultLineOfDate.length() > 0) {
                    resultLineOfDate.deleteCharAt(resultLineOfDate.length() - 1);
                }
                BaseLogger.log((String)"3", null, null, (Object)("****BILL_Date = " + resultLineOfDate.toString()));
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                bufferbilldate.append(billdate);
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bufferbilldate.toString();
    }
}

