/*
 * Decompiled with CFR 0.152.
 */
package ibase.ai.entityid;

import ibase.ai.entityid.AIEngine;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class RasaAIEngine
implements AIEngine {
    @Override
    public String getItemCodeList(String dataJsonStr, UserInfoBean userInfo) {
        BaseLogger.log("3", userInfo, null, "Inside getItemCodeList rasa :: userInfo[" + userInfo + "]");
        String incoiceDetailsServiceURL = this.getPythonUrl("INVOICE_DETAILS_LIST");
        String result = "";
        BaseLogger.log("3", userInfo, null, "Inside getItemCodeList rasa:: incoiceDetailsServiceURL[" + incoiceDetailsServiceURL + "]");
        if (incoiceDetailsServiceURL.length() > 0) {
            BaseLogger.log("3", userInfo, null, "getItemCodeList: dataJsonStr:" + dataJsonStr);
            try {
                if (dataJsonStr == null || dataJsonStr.length() == 0) {
                    BaseLogger.log("3", userInfo, null, "getItemCodeList pythonServicesMap Default dataJsonStr ");
                    dataJsonStr = "{\"text\":[\"Augmentin 300mg Intravenous\"]}";
                }
                BaseLogger.log("3", userInfo, null, "getItemCodeList pythonServicesMap aftar :: dataJsonStr[" + dataJsonStr + "]");
                ByteArrayInputStream stream = new ByteArrayInputStream(dataJsonStr.getBytes(StandardCharsets.UTF_8));
                BaseLogger.log("3", userInfo, null, "getItemCodeList pythonServicesMap: stream[" + stream + "]");
                incoiceDetailsServiceURL = String.valueOf(incoiceDetailsServiceURL) + "?enterprise=enterprise1";
                byte[] responseData = E12GenericUtility.makeRequest(incoiceDetailsServiceURL, stream);
                result = new String(responseData);
                BaseLogger.log("3", userInfo, null, "getItemCodeList byteArray[" + result + "]");
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in RasaWitAIEngine sgetItemCodeList[" + e.getMessage() + "]");
                e.printStackTrace();
            }
            result = this.getItemCodeFromDB(result, userInfo);
            BaseLogger.log("3", userInfo, null, "getItemCodeList rasa result[" + result + "]");
        }
        return result;
    }

    @Override
    public String trainEngin(String dataJsonStr, UserInfoBean userInfo) {
        BaseLogger.log("3", userInfo, null, "Train rasa API :: dataJsonStr:" + dataJsonStr);
        String incoiceDetailsServiceURL = this.getPythonUrl("TRAIN_AI_FOR_ITEM_CODES");
        incoiceDetailsServiceURL = String.valueOf(incoiceDetailsServiceURL) + "?param=add&enterprise=enterprise1";
        BaseLogger.log("3", userInfo, null, "Train rasa API :: incoiceDetailsServiceURL[" + incoiceDetailsServiceURL + "]");
        if (dataJsonStr == null || dataJsonStr.length() == 0) {
            dataJsonStr = "{ 'product_data':[{'id':'I1','descr':'Calpol 300mg Susp', 'attr1':'Calpol', 'attr2':'300mg', 'attr3':'Susp','no_of_attr':'3'}] }";
        }
        BaseLogger.log("3", userInfo, null, "Train API pythonServicesMap: dataJsonStr[" + dataJsonStr + "]");
        ByteArrayInputStream stream = new ByteArrayInputStream(dataJsonStr.getBytes(StandardCharsets.UTF_8));
        BaseLogger.log("3", userInfo, null, "Train API pythonServicesMap: stream[" + stream + "]");
        String result = "";
        try {
            byte[] responseData = E12GenericUtility.makeRequest(incoiceDetailsServiceURL, stream);
            result = new String(responseData);
            BaseLogger.log("3", userInfo, null, "Train API GET_ITEM_CODE_LIST: result[" + result + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in RasaAIEngine sgetItemCodeList[" + e.getMessage() + "]");
            e.printStackTrace();
        }
        BaseLogger.log("3", userInfo, null, "Train API GET_ITEM_CODE_LIST: return[" + result + "]");
        return result;
    }

    public String getPythonUrl(String endPointName) {
        BaseLogger.log("3", null, null, "inside getPythonUrl endPointName:[" + endPointName);
        Map<String, Map<String, String>> pythonServicesMap = CommonConstants.EXTRACTION_PYTHON_SERVICES;
        BaseLogger.log("3", null, null, "getPythonUrl pythonServicesMap:[" + pythonServicesMap);
        String incoiceDetailsServiceURL = "";
        if (pythonServicesMap.containsKey(endPointName)) {
            BaseLogger.log("3", null, null, "getPythonUrl: have INVOICE_DETAILS_LIST ::");
            Map<String, String> proteusSenseServiceDetails = pythonServicesMap.get(endPointName);
            BaseLogger.log("3", null, null, "getPythonUrl: proteusSenseServiceDetails" + proteusSenseServiceDetails);
            String protocol = proteusSenseServiceDetails.get("PROTOCOL");
            String host = proteusSenseServiceDetails.get("HOST");
            String port = E12GenericUtility.checkNull(proteusSenseServiceDetails.get("PORT"));
            String path = proteusSenseServiceDetails.get("ENDPOINT");
            path = String.valueOf(path) + "_rasa";
            BaseLogger.log("3", null, null, "getPythonUrl: path:" + path);
            incoiceDetailsServiceURL = String.format("%s://%s%s/%s", protocol, host, port, path);
            BaseLogger.log("3", null, null, "result getPythonUrl: incoiceDetailsServiceURL[" + incoiceDetailsServiceURL + "]");
        }
        return incoiceDetailsServiceURL;
    }

    String getItemCodeFromDB(String data, UserInfoBean userInfo) {
        String result;
        block28: {
            String transDB = userInfo.getTransDB();
            BaseLogger.log("3", null, null, "1 ::getItemCodeFromDB ::userInfo[" + userInfo + "]transDB[" + transDB + "], data[" + data + "]");
            String retDocumentName = "";
            Connection conn = null;
            Statement mPstmt = null;
            JSONObject jsonItem = new JSONObject();
            result = "";
            try {
                try {
                    conn = this.getConnection(transDB);
                    if (conn != null) {
                        BaseLogger.log("3", null, null, "getItemCodeFromDB  connection is null");
                    }
                    JSONObject dataObj = new JSONObject(data);
                    BaseLogger.log("3", null, null, "1 getItemCodeFromDB :: dataObj[" + dataObj + "]");
                    JSONArray lines = dataObj.getJSONArray("prediction");
                    BaseLogger.log("3", null, null, "1 getItemCodeFromDB :: lines[" + lines + "]");
                    int i = 0;
                    while (i < lines.length()) {
                        JSONObject obj = lines.getJSONObject(i);
                        BaseLogger.log("3", null, null, "getItemCodeFromDB[" + obj.keys() + "],obj[" + obj.keys().getClass().getName() + "]");
                        String attr = "";
                        Iterator json_keys = obj.keys();
                        while (json_keys.hasNext()) {
                            String json_key = (String)json_keys.next();
                            BaseLogger.log("3", null, null, "getItemCodeFromDB::json_key[" + json_key + "]");
                            if (!json_key.startsWith("attr")) continue;
                            char[] chars = json_key.toCharArray();
                            StringBuilder sb = new StringBuilder();
                            char[] cArray = chars;
                            int n = chars.length;
                            int n2 = 0;
                            while (n2 < n) {
                                char c = cArray[n2];
                                if (Character.isDigit(c)) {
                                    sb.append(c);
                                }
                                ++n2;
                            }
                            String attrVal = obj.getString(json_key);
                            BaseLogger.log("3", null, null, "getItemCodeFromDB::json_key[" + json_key + "],attrVal[" + attrVal + "]cn[" + sb + "]");
                            attr = String.valueOf(attr) + " phy_attrib_" + sb + "='" + attrVal + "' and ";
                        }
                        BaseLogger.log("3", null, null, "getItemCodeFromDB[" + i + "],obj[" + obj + "]");
                        BaseLogger.log("3", null, null, "[" + i + "],attr[" + attr + "]");
                        if (attr.length() > 1) {
                            attr = attr.substring(0, attr.length() - 4);
                        }
                        String selQry = "select item_code from item where" + attr;
                        BaseLogger.log("3", null, null, "[" + i + "],selQry[" + selQry + "]");
                        String item_code = "";
                        try {
                            mPstmt = conn.prepareStatement(selQry);
                            BaseLogger.log("3", null, null, "selQry executed");
                            ResultSet rs = mPstmt.executeQuery();
                            if (rs.next()) {
                                item_code = rs.getString(1) == null ? "" : rs.getString(1);
                                BaseLogger.log("3", null, null, "getItemCodeFromDB:: item_code[" + item_code + "]");
                                JSONObject itm_cod = new JSONObject();
                                itm_cod.put("doc_id", obj.getInt("id"));
                                itm_cod.put("item_code", (Object)item_code);
                                jsonItem.put(obj.getString("descr"), (Object)item_code);
                                BaseLogger.log("3", null, null, "getItemCodeFromDB:: jsonItem[" + jsonItem + "]");
                            }
                            if (mPstmt != null) {
                                mPstmt.close();
                                mPstmt = null;
                            }
                        }
                        catch (Exception e) {
                            BaseLogger.log("0", null, null, "Exception ::getItemCodeFromDB get item_code:==>" + e);
                            e.printStackTrace();
                        }
                        BaseLogger.log("3", null, null, "getItemCodeFromDB::[" + i + "]item_code[" + item_code + "]");
                        ++i;
                    }
                    result = jsonItem.toString();
                    BaseLogger.log("3", null, null, "getItemCodeFromDB:: result[" + result + "]");
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception ::getItemCodeFromDB :==>" + e);
                    e.printStackTrace();
                    try {
                        if (conn != null) {
                            if (mPstmt != null) {
                                mPstmt.close();
                                mPstmt = null;
                            }
                            conn.close();
                            conn = null;
                        }
                        break block28;
                    }
                    catch (Exception e2) {
                        BaseLogger.log("0", null, null, "Exception ::getItemCodeFromDB while closing streams :==>" + e2);
                        e2.printStackTrace();
                    }
                    break block28;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        if (mPstmt != null) {
                            mPstmt.close();
                            mPstmt = null;
                        }
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception ::getItemCodeFromDB while closing streams :==>" + e);
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (conn != null) {
                    if (mPstmt != null) {
                        mPstmt.close();
                        mPstmt = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception ::getItemCodeFromDB while closing streams :==>" + e);
                e.printStackTrace();
            }
        }
        BaseLogger.log("3", null, null, "end getItemCodeFromDB:: result[" + result + "]");
        return result;
    }

    public Connection getConnection(String transDB) throws RemoteException, ITMException {
        Connection conn = null;
        try {
            BaseLogger.log("3", null, null, "IN getConnection METHOD:: transDB[" + transDB + "]");
            ConnDriver connDriver = null;
            connDriver = new ConnDriver();
            conn = connDriver.getConnectDB(transDB);
            conn.setAutoCommit(false);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : [DocumentHandlerEJB][getConnection] :==>\n" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return conn;
    }
}

