/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.EdiLoadBatchLocal;
import ibase.webitm.ejb.EdiLoadBatchRemote;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterApplyEJBLocal;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.ejb.Stateless;
import javax.naming.InitialContext;

@Stateless
public class EdiLoadBatch
extends ActionHandlerEJB
implements EdiLoadBatchLocal,
EdiLoadBatchRemote {
    @Override
    public String actionHandler(String tranId, String xtraParams, String forcedFlag) throws RemoteException, ITMException {
        String errString;
        block18: {
            errString = null;
            Connection conn = null;
            ConnDriver ConnDriver2 = new ConnDriver();
            PreparedStatement pstmt = null;
            Object pstmt1 = null;
            ResultSet rs = null;
            String loadStat = "";
            BaseLogger.log("2", null, null, "Edi loading <!@> tranId----" + tranId);
            BaseLogger.log("2", null, null, "tranId----" + tranId);
            try {
                try {
                    conn = ConnDriver2.getConnectDB("Driver");
                    conn.setAutoCommit(false);
                    ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
                    BaseLogger.log("3", null, null, "xtraParams----" + xtraParams);
                    BaseLogger.log("3", null, null, "forcedFlag----" + forcedFlag);
                    tranId = tranId.substring(0, tranId.indexOf(":"));
                    tranId = tranId.trim();
                    if (tranId != null || tranId.trim().length() > 0) {
                        String tranIdRef = null;
                        pstmt = conn.prepareStatement("SELECT LOAD_STAT,TRAN_ID__REF FROM BATCHLOAD WHERE BATCH_ID=?");
                        pstmt.setString(1, tranId);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            loadStat = rs.getString("LOAD_STAT");
                            tranIdRef = rs.getString("TRAN_ID__REF");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (loadStat.equalsIgnoreCase("N") && tranIdRef == null) {
                            errString = this.AppBatch(tranId, xtraParams, forcedFlag);
                            BaseLogger.log("3", null, null, "<!@#> sucess > errString:" + errString + ":");
                        } else {
                            BaseLogger.log("3", null, null, "Batch Load:errCode:VTLOBATFA");
                            errString = itmDBAccess.getErrorString("", "VTLOBATFA", "");
                            BaseLogger.log("3", null, null, "errString:" + errString + ":");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (conn == null) break block18;
                    try {
                        conn.close();
                        conn = null;
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                        throw new ITMException(ex);
                    }
                }
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                        conn = null;
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                        throw new ITMException(ex);
                    }
                }
            }
        }
        return errString;
    }

    private String AppBatch(String tranId, String xtraParams, String forcedFlag) {
        String errString = "";
        UserInfoBean userInfo = null;
        MasterApplyEJBLocal masterAppLocal = null;
        try {
            masterAppLocal = this.getComponent("MasterApplyEJB");
            userInfo = new UserInfoBean();
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            DBAccessEJB dbAccess = new DBAccessEJB();
            E12GenericUtility genericUtility = new E12GenericUtility();
            String loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            String siteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
            userInfo.setLoginCode(loginCode);
            userInfo.setSiteCode(siteCode);
            userInfo.setEmpInfo(dbAccess.getEmpInfo(loginCode, siteCode, userInfo.getTransDB()));
            userInfo.setUserLevel("1");
            errString = masterAppLocal.applyMasterTable(tranId, xtraParams, userInfo);
            dbAccess = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errString;
    }

    private MasterApplyEJBLocal getComponent(String EjbComponent) throws ITMException {
        InitialContext ctx = null;
        MasterApplyEJBLocal masterAppLocal = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
            BaseLogger.log("3", null, null, "************InitialContext ctx = *******************************************");
            masterAppLocal = (MasterApplyEJBLocal)ctx.lookup("ibase/" + EjbComponent + "/local");
            BaseLogger.log("3", null, null, "************ masterAppLocal = *******************************************");
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :EjbComponent : getComponent :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :getComponent : getComponent :==>");
            throw new ITMException(e);
        }
        return masterAppLocal;
    }

    @Override
    public String actionHandler(String tranId, String xtraParams, String forcedFlag, UserInfoBean userInfo) throws RemoteException, ITMException {
        String errString;
        block18: {
            errString = null;
            Connection conn = null;
            ConnDriver ConnDriver2 = new ConnDriver();
            PreparedStatement pstmt = null;
            Object pstmt1 = null;
            ResultSet rs = null;
            String loadStat = "";
            String transDB = null;
            BaseLogger.log("2", userInfo, null, "Edi loading <!@> tranId----" + tranId);
            BaseLogger.log("2", userInfo, null, "tranId----" + tranId);
            try {
                try {
                    transDB = userInfo.getTransDB();
                    conn = ConnDriver2.getConnectDB(transDB);
                    conn.setAutoCommit(false);
                    ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
                    BaseLogger.log("3", userInfo, null, "xtraParams----" + xtraParams);
                    BaseLogger.log("3", userInfo, null, "forcedFlag----" + forcedFlag);
                    tranId = tranId.substring(0, tranId.indexOf(":"));
                    tranId = tranId.trim();
                    if (tranId != null || tranId.trim().length() > 0) {
                        String tranIdRef = null;
                        pstmt = conn.prepareStatement("SELECT LOAD_STAT,TRAN_ID__REF FROM BATCHLOAD WHERE BATCH_ID=?");
                        pstmt.setString(1, tranId);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            loadStat = rs.getString("LOAD_STAT");
                            tranIdRef = rs.getString("TRAN_ID__REF");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (loadStat.equalsIgnoreCase("N") && tranIdRef == null) {
                            errString = this.AppBatch(tranId, xtraParams, forcedFlag);
                            BaseLogger.log("3", userInfo, null, "<!@#> sucess > errString:" + errString + ":");
                        } else {
                            BaseLogger.log("3", userInfo, null, "Batch Load:errCode:VTLOBATFA");
                            errString = itmDBAccess.getErrorString("", "VTLOBATFA", "", userInfo);
                            BaseLogger.log("3", userInfo, null, "errString:" + errString + ":");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (conn == null) break block18;
                    try {
                        conn.close();
                        conn = null;
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                        throw new ITMException(ex);
                    }
                }
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                        conn = null;
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                        throw new ITMException(ex);
                    }
                }
            }
        }
        return errString;
    }

    public String action(String tranId, String xtraParams, String forcedFlag) throws ITMException {
        String errString = null;
        BaseLogger.log("3", this.getUserInfo(), null, "In EdiLoadBatch");
        BaseLogger.log("3", this.getUserInfo(), null, "tranId : [" + tranId + "], xtraParams : [" + xtraParams + "], forcedFlag : [" + forcedFlag + "]");
        Statement psUpdateBl = null;
        Connection conn = null;
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                String serviceCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "actionServiceCode");
                BaseLogger.log("3", this.getUserInfo(), null, "serviceCode : [" + serviceCode + "]");
                String newLoadStatus = "";
                if ("edi_batchload_hold".equalsIgnoreCase(serviceCode)) {
                    newLoadStatus = "H";
                } else if ("edi_batchload_reload".equalsIgnoreCase(serviceCode)) {
                    newLoadStatus = "R";
                } else if ("edi_batchload_skip".equalsIgnoreCase(serviceCode)) {
                    newLoadStatus = "K";
                }
                String[] tranIdArr = tranId.split(":");
                String batchId = tranIdArr[0];
                String tranSl = tranIdArr[1];
                BaseLogger.log("3", this.getUserInfo(), null, "batchId : [" + batchId + "], tranSl : [" + tranSl + "]");
                conn = this.getConnection();
                DBAccessEJB dbAccess = new DBAccessEJB();
                String loadStatus = dbAccess.getDBColumnValue("BATCHLOAD", "LOAD_STAT", " BATCH_ID = '" + batchId + "' AND TRAN_SL = '" + tranSl + "' ", conn);
                dbAccess = null;
                loadStatus = E12GenericUtility.checkNull(loadStatus);
                BaseLogger.log("3", this.getUserInfo(), null, "loadStatus : [" + loadStatus + "], newLoadStatus : [" + newLoadStatus + "]");
                ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
                if ("Y".equalsIgnoreCase(loadStatus)) {
                    errString = itmDBAccess.getErrorString("", "VTINVSTATY", "", this.getUserInfo());
                } else if ("N".equalsIgnoreCase(loadStatus) && !"K".equalsIgnoreCase(newLoadStatus)) {
                    errString = itmDBAccess.getErrorString("", "VTINVSTATP", "", this.getUserInfo());
                } else if ("R".equalsIgnoreCase(loadStatus) && !"K".equalsIgnoreCase(newLoadStatus)) {
                    errString = itmDBAccess.getErrorString("", "VTINVSTATR", "", this.getUserInfo());
                } else if ("K".equalsIgnoreCase(loadStatus) && !"R".equalsIgnoreCase(newLoadStatus)) {
                    errString = itmDBAccess.getErrorString("", "VTINVSTATK", "", this.getUserInfo());
                } else if ("E".equalsIgnoreCase(loadStatus) && !"R".equalsIgnoreCase(newLoadStatus) && !"K".equalsIgnoreCase(newLoadStatus)) {
                    errString = itmDBAccess.getErrorString("", "VTINVSTATE", "", this.getUserInfo());
                } else {
                    if (!newLoadStatus.equalsIgnoreCase(loadStatus)) {
                        String chgTerm = new E12GenericUtility().getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
                        chgTerm = chgTerm == null || chgTerm.length() == 0 ? this.getUserInfo().getRemoteHostName() : this.getUserInfo().getRemoteHost();
                        if (chgTerm != null && chgTerm.length() > 15) {
                            chgTerm = chgTerm.substring(0, 15);
                        }
                        String update = "UPDATE BATCHLOAD SET LOAD_STAT = ?, CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ? WHERE BATCH_ID = ? AND TRAN_SL = ?";
                        psUpdateBl = conn.prepareStatement(update);
                        psUpdateBl.setString(1, newLoadStatus);
                        psUpdateBl.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                        psUpdateBl.setString(3, this.getUserInfo().getLoginCode());
                        psUpdateBl.setString(4, chgTerm);
                        psUpdateBl.setString(5, batchId);
                        psUpdateBl.setString(6, tranSl);
                        int updateCnt = psUpdateBl.executeUpdate();
                        psUpdateBl.close();
                        psUpdateBl = null;
                        BaseLogger.log("3", null, null, "BATCHLOAD : updateCnt :: [" + updateCnt + "]");
                    }
                    errString = itmDBAccess.getErrorString("", "VTSTATUPDT", "", this.getUserInfo());
                }
                itmDBAccess = null;
            }
            catch (SQLException ex) {
                BaseLogger.log("0", null, null, "SQLException in EdiLoadBatch : action :: [" + ex.getMessage() + "]");
                ex.printStackTrace();
                throw new ITMException(ex);
            }
            catch (Exception ex) {
                BaseLogger.log("0", null, null, "Exception in EdiLoadBatch : action :: [" + ex.getMessage() + "]");
                ex.printStackTrace();
                throw new ITMException(ex);
            }
        }
        finally {
            try {
                if (psUpdateBl != null) {
                    psUpdateBl.close();
                    psUpdateBl = null;
                }
                if (conn != null) {
                    conn.commit();
                    conn = null;
                }
            }
            catch (SQLException sqlex) {
                sqlex.printStackTrace();
            }
        }
        return errString;
    }
}

