package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;

public class StrgMeetDCRWizPostConf extends ActionHandlerEJB
{
	private E12GenericUtility e12GenericUtility = new E12GenericUtility();
	
	public String confirm(String xmlData, String tranID, String editFlg, String xtraParam, Connection conn) throws RemoteException, ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		boolean isLocalConn = false;

		System.out.println("StrgMeetDCRWizPostConf.confirm()");
		System.out.println("StrgMeetDCRWizPostConf.confirm() xmlData ["+xmlData+"]");
		System.out.println("StrgMeetDCRWizPostConf.confirm() tranID ["+tranID+"]");
		System.out.println("StrgMeetDCRWizPostConf.confirm() editFlag ["+editFlg+"]");
		System.out.println("StrgMeetDCRWizPostConf.confirm() xtraParam ["+xtraParam+"]");

		try
		{
			String userId = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParam,"loginCode");
			if ( getUserInfo() == null )
			{
				CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
				setUserInfo( commonDBAccessEJB.createUserInfo( userId ) );
			}
			if ( conn == null )
			{
				String transDB = getUserInfo().getTransDB();
				
				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB);
				connDriver = null;
				
				isLocalConn = true;
				System.out.println("Connection created...");
			}
			
			String loginEmpCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParam,"loginEmpCode");
			String objName = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParam,"objName");
			
			System.out.println("(objName:::"+objName);
			
			SimpleDateFormat sdf = new SimpleDateFormat(e12GenericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			currDate = e12GenericUtility.getValidDateTimeString( currDate, e12GenericUtility.getApplDateFormat(),e12GenericUtility.getDBDateFormat() );

			String mainFormNo = E12GenericUtility.checkNull(getFormNo(objName, "mainform", conn));
			/*String docFormNo = E12GenericUtility.checkNull(getFormNo(objName, "doctor", conn));
			String retailrFormNo = E12GenericUtility.checkNull(getFormNo(objName, "retailer", conn));
			String stockistFormNo = E12GenericUtility.checkNull(getFormNo(objName, "stockist", conn));
			String ncwFormNo = E12GenericUtility.checkNull(getFormNo(objName, "ncw", conn));*/
			
			/*String sampleorderFormNo = E12GenericUtility.checkNull(getFormNo(objName, "sampleorder", conn));
			String retailerSampleOrderFormNo = E12GenericUtility.checkNull(getFormNo(objName, "retailersampleorder", conn));
			String stockistSampleOrderFormNo = E12GenericUtility.checkNull(getFormNo(objName, "stockistsampleorder", conn));
			String ncwSampleOrderFormNo = E12GenericUtility.checkNull(getFormNo(objName, "ncwsampleorder", conn));
			System.out.println("docformNo ["+docFormNo+"] mainFOrmNo ["+mainFormNo+"] sampleorderNo ["+sampleorderFormNo+"]");
			System.out.println("retailerSampleOrderFormNo ["+ retailerSampleOrderFormNo +"]");
			System.out.println("stockistSampleOrderFormNo ["+ stockistSampleOrderFormNo +"]");
			System.out.println("ncwSampleOrderFormNo ["+ ncwSampleOrderFormNo +"]");*/

			String itemSer = "";
			String itemSerSql = "SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = ?";
			pstmt = conn.prepareStatement(itemSerSql);
			pstmt.setString(1, userId);
			rSet = pstmt.executeQuery();
			if(rSet.next())
			{
				itemSer = E12GenericUtility.checkNull(rSet.getString("ITEM_SER"));
			}
			if(rSet != null)
			{
				rSet.close();
				rSet = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("itemSer : ["+ itemSer +"]");
			
			Document dom = null;
			if(xmlData != null && xmlData.trim().length()!=0)
			{
				dom = e12GenericUtility.parseString(xmlData);
			}
			
			NodeList childList = null;
			Node parentNode = null;
			Node childNode = null;
			int noOfChilds = 0;
			
			String childNodeName = "";
			String salesPers  = "", eventDate = "", dcrId = "";
			
			NodeList parentList = dom.getElementsByTagName("Detail"+ mainFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentNodeListLength : "+parentNodeListLength);
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				System.out.println("noOfChilds : "+noOfChilds);
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("sales_pers"))
					{
						salesPers = E12GenericUtility.checkNull(e12GenericUtility.getColumnValueFromNode("sales_pers", parentNode));
					}
					else if (childNodeName.equalsIgnoreCase("event_date"))
					{
						eventDate = E12GenericUtility.checkNull(e12GenericUtility.getColumnValueFromNode("event_date", parentNode));
					}
					else if (childNodeName.equalsIgnoreCase("dcr_id"))
					{
						dcrId = E12GenericUtility.checkNull(e12GenericUtility.getColumnValueFromNode("dcr_id", parentNode));
					}
				}
			}
			System.out.println("salesPers : ["+ salesPers +"], eventDate : ["+ eventDate +"], dcrId : ["+ dcrId +"]");
			
			if ( dcrId.length() > 0 && eventDate.length() > 0 )
			{
				try 
				{
					StrgMeetDCRWizConf strgMeetDCRWizConf = new StrgMeetDCRWizConf();
					strgMeetDCRWizConf.setUserInfo( getUserInfo() );
					strgMeetDCRWizConf.sendNotification( dcrId, eventDate, loginEmpCode, xtraParam, conn );
					strgMeetDCRWizConf = null;
				}
				catch (Exception e) 
				{
					e.printStackTrace();
					System.out.println( "StrgMeetDCRWizConf.sendNotification ["+ e.getMessage() +"]" );
				}
				
				String validEventDate = e12GenericUtility.getValidDateTimeString( eventDate, e12GenericUtility.getApplDateFormat(), e12GenericUtility.getDBDateFormat() );
				System.out.println("validEventDate : ["+ validEventDate +"]");
				
				updateStrgSeries( dcrId, validEventDate, currDate, conn );
				updateStrgProdItem( dcrId, validEventDate, currDate, conn );
				updateStrgProd( dcrId, validEventDate, itemSer, currDate, conn );
				
				if ( conn != null )
				{
					conn.commit();
				}
			}
			
			/*parentNodeListLength = 0;
			parentList = null;
			parentNode = null;
			childList = null;
			noOfChilds = 0;
			childNode = null;

			parentList = dom.getElementsByTagName("Detail"+ docFormNo);
			parentNodeListLength = parentList.getLength();
			System.out.println("parentNodeListLength : "+parentNodeListLength);
			String strgCode = "";
			ArrayList<String> strgCodeArr = new ArrayList<String>();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				System.out.println("noOfChilds : "+noOfChilds);
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}

					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("strg_code"))
					{
						strgCode = E12GenericUtility.checkNull(e12GenericUtility.getColumnValueFromNode("strg_code", parentNode));
						System.out.println("strgCode : "+strgCode);
						strgCodeArr.add(strgCode);
						break;
					}
				}
			}
			System.out.println("Dcotor strgCodeArr ::"+strgCodeArr);*/

			/*parentNodeListLength = 0;
			parentList = null;
			parentNode = null;
			childList = null;
			noOfChilds = 0;
			childNode = null;
			
			ArrayList<String> strgCodeArr = new ArrayList<String>();
			parentList = dom.getElementsByTagName("Detail"+ sampleorderFormNo);
			parentNodeListLength = parentList.getLength();
			System.out.println("parentNodeListLength : "+parentNodeListLength);
			String itemCode = "", strgCode = "";
			ArrayList<String> itemCodeArr = new ArrayList<String>();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				System.out.println("noOfChilds : "+noOfChilds);
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("strg_code"))
					{
						strgCode = E12GenericUtility.checkNull(e12GenericUtility.getColumnValueFromNode("strg_code", parentNode));
						System.out.println("strgCode : "+strgCode);
						strgCodeArr.add(strgCode);
					}
					if(childNodeName.equalsIgnoreCase("item_code"))
					{
						itemCode = E12GenericUtility.checkNull(e12GenericUtility.getColumnValueFromNode("item_code", parentNode));
						System.out.println("item_code : "+itemCode);
						itemCodeArr.add(itemCode);
					}
				}
			}
			System.out.println("strgCodeArr Item ::"+strgCodeArr);
			System.out.println("itemCodeArr Item ::"+itemCodeArr);
			
			updateStrgProdItem(strgCodeArr, itemCodeArr, salesPers, currDate, conn);
			updateStrgProd(strgCodeArr, itemCodeArr, salesPers, itemSer, getUserInfo(), currDate, conn);*/
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("StrgMeetDCRWizPostConf.confirm() : "+e);
			throw new ITMException(e);
		}
		finally 
		{
			try 
			{
				if(rSet != null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null && isLocalConn )
				{
					conn.close();
					conn = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
		return "";
	}

	public String getFormNo(String objName, String formName, Connection connectionObject) throws ITMException
	{
		Statement stmt = null;
		ResultSet rs = null;
		String formNo = "";
		try
		{
			String sql = "SELECT FORM_NO FROM OBJ_FORMS WHERE WIN_NAME = '"+"w_"+objName+"'AND FORM_NAME = '"+formName+"'";
			stmt = connectionObject.createStatement();
			rs = stmt.executeQuery(sql);
			if( rs.next() )
			{
				formNo = E12GenericUtility.checkNull(rs.getString("FORM_NO"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( stmt !=null )
			{
				stmt.close();
				stmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("StrgMeetDCRWizPostConf.getFormNo() "+e);
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018
		}
		return formNo;
	}
	
	private void updateStrgSeries( String dcrId, String eventDate, String currDate, Connection conn )
	{
		PreparedStatement pstmt = null;
		try
		{
			String sql = "UPDATE STRG_SERIES SET LAST_ORDER_DATE = ? "
					+ " WHERE SC_CODE IN ( SELECT STRG_CODE FROM STRG_MEET WHERE DCR_ID = ? AND CONFIRMED = 'Y' ) AND STATUS = 'Y'";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(eventDate));
			pstmt.setString(2, dcrId);
			
			int seriesUpdateCnt = pstmt.executeUpdate();
			System.out.println("seriesUpdateCnt : ["+ seriesUpdateCnt +"]");
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			String strgCustSql = "UPDATE STRG_CUST_EXCEPTION SET EXCEP_FLAG = ?, PRC_DATE = ? "
					+ " WHERE SC_CODE IN ( SELECT STRG_CODE FROM STRG_MEET WHERE DCR_ID = ? AND CONFIRMED = 'Y' ) "
					+ "AND (ITEM_CODE IS NULL OR UPPER(ITEM_CODE) = 'NULL') AND (PRODUCT_CODE IS NULL OR UPPER(PRODUCT_CODE) = 'NULL')";

			pstmt = conn.prepareStatement(strgCustSql);
			pstmt.setString(1, "0");
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(currDate));
			pstmt.setString(3, dcrId);
			
			int excepUpdateCnt = pstmt.executeUpdate();
			System.out.println("excepUpdateCnt : ["+ excepUpdateCnt +"]");
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if ( conn != null )
			{
				conn.commit();
			}
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("StrgMeetDCRWizPostConf.updateStrgSeries() : "+e);
		}
		finally
		{
			try 
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
	}
	
	private void updateStrgProdItem( String dcrId, String eventDate, String currDate, Connection conn )
	{
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmt2 = null;
		ResultSet rs = null;
		
		try
		{
			String sql = "SELECT SM.STRG_CODE, ITEM.PRODUCT_CODE, SMO.ITEM_CODE "
					+ " FROM STRG_MEET_ORDER SMO, STRG_MEET SM, ITEM ITEM "
					+ " WHERE SMO.DCR_ID = SM.DCR_ID "
					+ " AND SMO.ITEM_CODE = ITEM.ITEM_CODE "
					+ " AND SMO.STRG_CODE = SM.STRG_CODE "
					+ " AND SM.DCR_ID = ?"
					+ " AND SM.CONFIRMED = 'Y'";
			
			String strgProdSql = "UPDATE STRG_PRODUCT SET LAST_ORDER_DATE = ? WHERE SC_CODE = ? AND ITEM_CODE = ? AND PRODUCT_CODE = ?";
			pstmt1 = conn.prepareStatement(strgProdSql);
			
			String strgCustExcpSql = "UPDATE STRG_CUST_EXCEPTION SET EXCEP_FLAG = ?, PRC_DATE = ? WHERE SC_CODE = ? AND ITEM_CODE = ? AND PRODUCT_CODE = ?";
			pstmt2 = conn.prepareStatement(strgCustExcpSql);
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, dcrId);
			rs = pstmt.executeQuery();
			String strgCode = "";
			String productCode = "";
			String itemCode = "";
			
			while( rs.next() )
			{
				strgCode = rs.getString("STRG_CODE");
				productCode = rs.getString("PRODUCT_CODE");
				itemCode = rs.getString("ITEM_CODE");
				
				pstmt1.setTimestamp(1, java.sql.Timestamp.valueOf(eventDate));
				pstmt1.setString(2, strgCode);
				pstmt1.setString(3, itemCode);
				pstmt1.setString(4, productCode);
				pstmt1.addBatch();
				
				pstmt2.setString(1, "0");
				pstmt2.setTimestamp(2, java.sql.Timestamp.valueOf(currDate));
				pstmt2.setString(3, strgCode);
				pstmt2.setString(4, itemCode);
				pstmt2.setString(5, productCode);
				pstmt2.addBatch();
			}
			int[] strgProdCountArr = pstmt1.executeBatch();
			System.out.println("updateStrgProdItem :: strgProdCountArr : ["+ strgProdCountArr.length +"]");
			
			int[] strgCustExcpCountArr = pstmt2.executeBatch();
			System.out.println("updateStrgProdItem :: strgCustExcpCountArr : ["+ strgCustExcpCountArr.length +"]");
			
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(pstmt1 != null)
			{
				pstmt1.close();
				pstmt1 = null;
			}
			if(pstmt2 != null)
			{
				pstmt2.close();
				pstmt2 = null;
			}
			if ( conn != null )
			{
				conn.commit();
			}
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("StrgMeetDCRWizPostConf.updateStrgSeries() : "+e);
		}
		finally
		{
			try 
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if(pstmt2 != null)
				{
					pstmt2.close();
					pstmt2 = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
	}
	
	private void updateStrgProd( String dcrId, String eventDate, String itemSer, String currDate, Connection conn )
	{
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmt2 = null;
		ResultSet rs = null;
		
		try
		{
			String sql = "SELECT DISTINCT SM.STRG_CODE, ITEM.PRODUCT_CODE, "
					+ " (SELECT TRAN_ID AS PROD_TRAN_ID FROM STRG_PRODUCT WHERE SC_CODE = SM.STRG_CODE AND PRODUCT_CODE = ITEM.PRODUCT_CODE AND (ITEM_CODE IS NULL OR UPPER(ITEM_CODE) = 'NULL') AND ROWNUM = '1') PROD_TRAN_ID,"
					+ " (SELECT TRAN_ID AS EXCEP_TRAN_ID FROM STRG_CUST_EXCEPTION WHERE SC_CODE = SM.STRG_CODE AND PRODUCT_CODE = ITEM.PRODUCT_CODE AND (ITEM_CODE IS NULL OR UPPER(ITEM_CODE) = 'NULL') AND ROWNUM = '1') EXCEP_TRAN_ID "
					+ " FROM STRG_MEET_ORDER SMO, STRG_MEET SM, ITEM ITEM "
					+ " WHERE SMO.DCR_ID = SM.DCR_ID "
					+ " AND SMO.ITEM_CODE = ITEM.ITEM_CODE "
					+ " AND SMO.STRG_CODE = SM.STRG_CODE "
					+ " AND SM.DCR_ID = ?"
					+ " AND SM.CONFIRMED = 'Y'";
			
			String strgProdSql = "UPDATE STRG_PRODUCT SET LAST_ORDER_DATE = ? WHERE SC_CODE = ? AND PRODUCT_CODE = ? AND (ITEM_CODE IS NULL OR UPPER(ITEM_CODE) = 'NULL')";
			pstmt1 = conn.prepareStatement(strgProdSql);
			
			String strgCustExcpSql = "UPDATE STRG_CUST_EXCEPTION SET EXCEP_FLAG = ?, PRC_DATE = ? WHERE SC_CODE = ? AND PRODUCT_CODE = ? AND (ITEM_CODE IS NULL OR UPPER(ITEM_CODE) = 'NULL')";
			pstmt2 = conn.prepareStatement(strgCustExcpSql);
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, dcrId);
			rs = pstmt.executeQuery();
			String strgCode = "";
			String productCode = "";
			String strgProdTranId = "";
			String excepTranId = "";
			
			while( rs.next() )
			{
				strgCode = rs.getString("STRG_CODE");
				productCode = rs.getString("PRODUCT_CODE");
				strgProdTranId = E12GenericUtility.checkNull( rs.getString("PROD_TRAN_ID") );
				excepTranId = E12GenericUtility.checkNull( rs.getString("EXCEP_TRAN_ID") );
				
				if ( strgProdTranId.length() > 0 )
				{
					pstmt1.setTimestamp(1, java.sql.Timestamp.valueOf(eventDate));
					pstmt1.setString(2, strgCode);
					pstmt1.setString(3, productCode);
					pstmt1.addBatch();
				}
				else
				{
					insertStrgProd( strgCode, productCode, itemSer, eventDate, currDate, conn );
				}

				if ( excepTranId.length() > 0 )
				{
					pstmt2.setString(1, "0");
					pstmt2.setTimestamp(2, java.sql.Timestamp.valueOf(currDate));
					pstmt2.setString(3, strgCode);
					pstmt2.setString(4, productCode);
					pstmt2.addBatch();
				}
				else
				{
					insertStrgCustExcep( strgCode, productCode, currDate, conn );
				}
			}
			int[] strgProdCountArr = pstmt1.executeBatch();
			System.out.println("updateStrgProd :: strgProdCountArr : ["+ strgProdCountArr.length +"]");
			
			int[] strgCustExcpCountArr = pstmt2.executeBatch();
			System.out.println("updateStrgProd :: strgCustExcpCountArr : ["+ strgCustExcpCountArr.length +"]");
			
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(pstmt1 != null)
			{
				pstmt1.close();
				pstmt1 = null;
			}
			if(pstmt2 != null)
			{
				pstmt2.close();
				pstmt2 = null;
			}
			if ( conn != null )
			{
				conn.commit();
			}
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("StrgMeetDCRWizPostConf.updateStrgSeries() : "+e);
		}
		finally
		{
			try 
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if(pstmt2 != null)
				{
					pstmt2.close();
					pstmt2 = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
	}
	
	private void insertStrgProd( String strgCode, String productCode, String itemSer, String eventDate, String currDate, Connection conn )
	{
		PreparedStatement pstmt = null;
		
		try
		{
			String tranID = new DBAccessEJB().generateTranId( "W_STRG_PRODUCT", getUserInfo().getSiteCode(), getUserInfo().getLoginCode(), conn );
			
			String insertProdSql = "INSERT INTO STRG_PRODUCT(SC_CODE,CHG_USER,CHG_DATE,CHG_TERM,TRAN_ID,LINE_NO,LAST_ORDER_DATE,PRODUCT_CODE, ITEM_SER) "
					+ " VALUES (?,?,?,?,?,?,?,?,?)";
			pstmt = conn.prepareStatement(insertProdSql);
			pstmt.setString(1, strgCode);
			pstmt.setString(2, getUserInfo().getLoginCode());
			pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(currDate));
			pstmt.setString(4, getUserInfo().getLoginCode());
			pstmt.setString(5, tranID);
			pstmt.setString(6, "1");
			pstmt.setTimestamp(7, java.sql.Timestamp.valueOf(eventDate));
			pstmt.setString(8, productCode);
			pstmt.setString(9, itemSer);
			
			int insertCount = pstmt.executeUpdate();
			System.out.println("insertStrgProd :: insertCount : ["+ insertCount +"]");
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("StrgMeetDCRWizPostConf.insertStrgProd() : "+e);
		}
		finally
		{
			try 
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
	}
	
	private void insertStrgCustExcep( String strgCode, String productCode, String currDate, Connection conn )
	{
		PreparedStatement pstmt = null;
		
		try
		{
			String tranID = new DBAccessEJB().generateTranId( "W_STRG_CUST_EXC", getUserInfo().getSiteCode(), getUserInfo().getLoginCode(), conn );
			
			String insertProdSql = "INSERT INTO STRG_CUST_EXCEPTION(TRAN_ID,PRC_DATE,EXCEP_FLAG,SC_CODE,PRODUCT_CODE,ITEM_CODE,ADD_USER,ADD_DATE,ADD_TERM,CHG_USER,CHG_DATE,CHG_TERM) "
					+ " VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmt = conn.prepareStatement(insertProdSql);
			pstmt.setString(1, tranID);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(currDate));
			pstmt.setString(3, "0");
			pstmt.setString(4, strgCode);
			pstmt.setString(5, productCode);
			pstmt.setString(6, "");
			pstmt.setString(7, getUserInfo().getLoginCode());
			pstmt.setTimestamp(8, java.sql.Timestamp.valueOf(currDate));
			pstmt.setString(9, getUserInfo().getTermId());
			pstmt.setString(10, getUserInfo().getLoginCode());
			pstmt.setTimestamp(11, java.sql.Timestamp.valueOf(currDate));
			pstmt.setString(12, getUserInfo().getTermId());
			
			int insertStrgCustExcpCnt = pstmt.executeUpdate();
			System.out.println("insertStrgCustExcep :: insertStrgCustExcpCnt : ["+ insertStrgCustExcpCnt +"]");
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("StrgMeetDCRWizPostConf.insertStrgCustExcep() : "+e);
		}
		finally
		{
			try 
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
	}

	/*private void updateStrgSeries(ArrayList<String> scCodeArr, String salesPers, String eventDate, String currDate, Connection conn)
	{
		PreparedStatement pstmt = null;
		try
		{
			String sql = "UPDATE STRG_SERIES SET LAST_ORDER_DATE = ? WHERE SC_CODE = ?";
			String strgCustSql = "update strg_cust_exception set excep_flag = ?, prc_date = ? where sc_code = ? and item_code is null and product_code is null";

			for(int i = 0; i < scCodeArr.size(); i++)
			{
				String scCode = scCodeArr.get(i);
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(currDate));
				pstmt.setString(2, scCode);
				int count = pstmt.executeUpdate();
				System.out.println("StrgMeetDCRWizPostConf.updateStrgSeries() count "+count);
				if(count > 0)
				{
					conn.commit();
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				pstmt = conn.prepareStatement(strgCustSql);
				pstmt.setString(1, "0");
				pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(currDate));
				pstmt.setString(3, scCode);
				int cntExcep = pstmt.executeUpdate();
				System.out.println("StrgMeetDCRWizPostConf.updateStrgSeries()cntExcep "+cntExcep);
				if(count > 0)
				{
					conn.commit();
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
		}
		catch (Exception e) 
		{
			System.out.println("StrgMeetDCRWizPostConf.updateStrgSeries() : "+e);
		}
	}*/

	/*public void updateStrgProdItem(ArrayList<String> scCodeArr, ArrayList<String> itemCodeArr, String salesPers, String currDate, Connection conn)
	{
		try
		{
			PreparedStatement pstmt = null;
			ResultSet rs = null;

			String sql = "update strg_product set LAST_ORDER_DATE = ? where sc_code = ? and item_code = ? and product_code = ?";
			String getProductSql = "select product_code from item where item_code = ? ";
			String strgCustSql = "update strg_cust_exception set excep_flag = ? ,prc_date = ? where sc_code = ? and item_code = ? and product_code = ?";
			for(int i = 0; i < scCodeArr.size(); i++)
			{
				String scCode = scCodeArr.get(i);
				String itemCode = itemCodeArr.get(i);
				String prodCode = "";

				pstmt = conn.prepareStatement(getProductSql);
				pstmt.setString(1, itemCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					prodCode = rs.getString("product_code");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(currDate));
				pstmt.setString(2, scCode);
				pstmt.setString(3, itemCode);
				pstmt.setString(4, prodCode);
				int count = pstmt.executeUpdate();
				System.out.println("StrgMeetDCRWizPostConf.updateStrgProdItem() count "+count);
				if(count > 0)
				{
					conn.commit();
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				pstmt = conn.prepareStatement(strgCustSql);
				pstmt.setString(1, "0");
				pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(currDate));
				pstmt.setString(3, scCode);
				pstmt.setString(4, itemCode);
				pstmt.setString(5, prodCode);

				int cntExcep = pstmt.executeUpdate();
				System.out.println("StrgMeetDCRWizPostConf.updateStrgProdItem ()cntExcep "+cntExcep);
				if(count > 0)
				{
					conn.commit();
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
		}
		catch (Exception e) 
		{
			System.out.println("StrgMeetDCRWizPostConf.updateStrgSeries() : "+e);
		}
	}*/

	/*public void updateStrgProd(ArrayList<String> scCodeArr, ArrayList<String> itemCodeArr, String salesPers, String itemSer, UserInfoBean userInfo, String currDate, Connection conn)
	{
		try
		{
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			int productCount = 0;
			String getProductCntSql = "select count(1) as PROD_COUNT from strg_product where sc_code = ? and product_code = ? and item_code is null";
			String sql = "update strg_product set LAST_ORDER_DATE = ? where sc_code = ? and product_code = ? and item_code is null";
			String getProductSql = "select product_code from item where item_code = ? ";
			String strgCustSql = "update strg_cust_exception set excep_flag = ? ,prc_date = ? where sc_code = ?  and product_code = ? and item_code is null";
			for(int i = 0; i < scCodeArr.size(); i++)
			{
				productCount = 0;
				String scCode = scCodeArr.get(i);
				String itemCode = itemCodeArr.get(i);
				String prodCode = "";
				pstmt = conn.prepareStatement(getProductSql);
				pstmt.setString(1, itemCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					prodCode = rs.getString("product_code");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				pstmt = conn.prepareStatement(getProductCntSql);
				pstmt.setString(1, scCode);
				pstmt.setString(2, prodCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					productCount = rs.getInt("PROD_COUNT");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if(productCount > 0 )
				{
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(currDate));
					pstmt.setString(2, scCode);
					pstmt.setString(3, prodCode);
					int count = pstmt.executeUpdate();
					System.out.println("StrgMeetDCRWizPostConf.updateStrgProd() count "+count);
					if(count > 0)
					{
						conn.commit();
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

					pstmt = conn.prepareStatement(strgCustSql);
					pstmt.setString(1, "0");
					pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(currDate));
					pstmt.setString(3, scCode);
					pstmt.setString(4, prodCode);

					int cntExcep = pstmt.executeUpdate();
					System.out.println("StrgMeetDCRWizPostConf.updateStrgProd ()cntExcep "+cntExcep);
					if(count > 0)
					{
						conn.commit();
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				else
				{
					String tranID = new DBAccessEJB().generateTranId( "W_STRG_PRODUCT", userInfo.getSiteCode(),userInfo.getLoginCode(),conn);
					String insertProdSql = "Insert into STRG_PRODUCT (SC_CODE,CHG_USER,CHG_DATE,CHG_TERM,TRAN_ID,LINE_NO,LAST_ORDER_DATE,PRODUCT_CODE, ITEM_SER) values (?,?,?,?,?,?,?,?,?)";
					pstmt = conn.prepareStatement(insertProdSql);
					pstmt.setString(1, scCode);
					pstmt.setString(2, userInfo.getLoginCode());
					pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(currDate));
					pstmt.setString(4, userInfo.getLoginCode());
					pstmt.setString(5, tranID);
					pstmt.setString(6, "1");
					pstmt.setTimestamp(7, java.sql.Timestamp.valueOf(currDate));
					pstmt.setString(8, prodCode);
					pstmt.setString(9, itemSer);
					int insertCount = pstmt.executeUpdate();
					if(insertCount > 0)
					{
						conn.commit();
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
		}
		catch (Exception e) 
		{
			System.out.println("StrgMeetDCRWizPostConf.updateStrgSeries() : "+e);
		}
	}*/
}
