/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Firewall {
    public static HashMap<String, HashMap<String, HashMap<String, String>>> servletParameterMap = new HashMap();
    public static ArrayList<String> blackListedKeywordList = new ArrayList();
    public static ArrayList<String> blackListedInputList = new ArrayList();
    public static ArrayList<String> allowedFeildList = new ArrayList();
    String xmlKeyword = "";
    E12GenericUtility e12GenericUtility = new E12GenericUtility();

    public static void scanInput() throws ITMException {
        try {
            String filePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "configuration" + File.separator + "ServerParameterFirewall.json";
            BaseLogger.log("3", null, null, "Firewall.sacnInput() json filePath:[" + filePath + "]");
            File fileObject = new File(filePath);
            if (fileObject.exists()) {
                String[] keywordsArray;
                JsonObject jsonData = E12GenericUtility.readJsonFile(filePath);
                JsonObject mianJsonData = (JsonObject)jsonData.get("ROOT");
                JsonArray jsonArray1 = mianJsonData.getAsJsonArray("SERVLET_DETAILS");
                int j = 0;
                while (j < jsonArray1.size()) {
                    JsonObject currentJson1 = (JsonObject)jsonArray1.get(j);
                    for (String servletKey : currentJson1.keySet()) {
                        HashMap parameterMap = new HashMap();
                        if (currentJson1.get(servletKey) instanceof JsonObject) {
                            JsonObject JsonObject2 = (JsonObject)currentJson1.get(servletKey);
                            JsonArray jsonArray = null;
                            jsonArray = JsonObject2.getAsJsonArray("PARAMETER_DETAIL");
                            int i = 0;
                            while (i < jsonArray.size()) {
                                JsonObject currentJson = (JsonObject)jsonArray.get(i);
                                for (String key : currentJson.keySet()) {
                                    if (!(currentJson.get(key) instanceof JsonObject)) continue;
                                    JsonObject detailJson = (JsonObject)currentJson.get(key);
                                    HashMap<String, String> parameterDetailsMap = new HashMap<String, String>();
                                    parameterDetailsMap.put("MIN_LEN", detailJson.get("MIN_LEN").getAsString());
                                    parameterDetailsMap.put("MAX_LEN", detailJson.get("MAX_LEN").getAsString());
                                    parameterDetailsMap.put("SPACE_ALLOW", detailJson.get("SPACE_ALLOW").getAsString());
                                    parameterMap.put(key.toUpperCase(), parameterDetailsMap);
                                }
                                ++i;
                            }
                        }
                        servletParameterMap.put(servletKey.toUpperCase(), parameterMap);
                    }
                    ++j;
                }
                JsonElement blackListData = mianJsonData.get("BLACKLISTED_KEYWORDS");
                JsonElement blackListDataInput = mianJsonData.get("BLACKLISTED_INPUTS");
                JsonElement allowedFields = mianJsonData.get("ALLOWED_FEILDS");
                if (blackListData != null) {
                    keywordsArray = blackListData.getAsString().split(",");
                    int l = 0;
                    while (l < keywordsArray.length) {
                        blackListedKeywordList.add(keywordsArray[l]);
                        ++l;
                    }
                }
                if (blackListDataInput != null) {
                    keywordsArray = blackListDataInput.getAsString().split(",");
                    int l = 0;
                    while (l < keywordsArray.length) {
                        blackListedInputList.add(keywordsArray[l]);
                        ++l;
                    }
                }
                if (allowedFields != null) {
                    keywordsArray = allowedFields.getAsString().split(",");
                    int l = 0;
                    while (l < keywordsArray.length) {
                        allowedFeildList.add(keywordsArray[l]);
                        ++l;
                    }
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Firewall.sacnInput() Exception:[" + E12GenericUtility.getStackTrace(e) + "]");
            throw new ITMException(e);
        }
    }

    public String checkVulnerability(String queryString, String servletPathString, UserInfoBean userInfo, String requestURI, String requestURL) throws ITMException {
        String result;
        block27: {
            result = "";
            try {
                String[] parameterArr;
                if (servletPathString != null && servletPathString.startsWith("/")) {
                    servletPathString = servletPathString.substring(1);
                }
                if ("".equals(E12GenericUtility.checkNull(queryString)) || (parameterArr = queryString.split("&")) == null || parameterArr.length <= 0) break block27;
                int i = 0;
                while (i < parameterArr.length) {
                    String keyValue = parameterArr[i];
                    if (keyValue != null && !"".equals(E12GenericUtility.checkNull(keyValue))) {
                        String key = "";
                        String value = "";
                        int checkXml = keyValue.indexOf("<?xml");
                        if (checkXml != -1) {
                            key = keyValue.substring(0, keyValue.indexOf("="));
                            value = keyValue.substring(keyValue.indexOf("=") + 1);
                        } else {
                            String[] keyValueArr = keyValue.split("=");
                            int j = 0;
                            while (j < keyValueArr.length) {
                                if (j == 0) {
                                    key = keyValueArr[0];
                                } else if (j == 1) {
                                    value = keyValueArr[1];
                                }
                                ++j;
                            }
                        }
                        if (value != null && blackListedKeywordList != null && blackListedKeywordList.size() > 0) {
                            boolean keywordExist = false;
                            String keyword = "";
                            int k = 0;
                            while (k < blackListedKeywordList.size()) {
                                String blacklistedKeyWord = blackListedKeywordList.get(k);
                                if (value.toUpperCase().contains(blacklistedKeyWord.toUpperCase())) {
                                    keywordExist = true;
                                    keyword = blacklistedKeyWord.toUpperCase();
                                    break;
                                }
                                ++k;
                            }
                            if (keywordExist) {
                                result = "INVALID_REQUEST_PARAMETER~~" + key + "~~" + value + "~~" + "Parameter value contains blacklisted keword:" + keyword;
                                break;
                            }
                        }
                        if (value != null && key != null && blackListedInputList != null && blackListedInputList.size() > 0 && allowedFeildList.size() > 0 && !allowedFeildList.contains(key.toUpperCase())) {
                            BaseLogger.log("0", null, null, " value : [" + value + "]");
                            int xmlValue = value.indexOf("<?xml");
                            boolean keywordExist = false;
                            String keyword = "";
                            if (xmlValue != -1) {
                                keywordExist = this.checkXml(value);
                                keyword = this.xmlKeyword;
                            } else {
                                int k = 0;
                                while (k < blackListedInputList.size()) {
                                    String blacklistedInput = blackListedInputList.get(k);
                                    if (value.toUpperCase().contains(blacklistedInput.toUpperCase())) {
                                        keywordExist = true;
                                        keyword = blacklistedInput.toUpperCase();
                                        break;
                                    }
                                    ++k;
                                }
                            }
                            if (keywordExist) {
                                BaseLogger.log("0", null, null, "Firewall.checkVulnerability() keywordExist : [" + keywordExist + "]");
                                result = "INVALID_REQUEST_PARAMETER~~" + key + "~~" + value + "~~" + "Parameter value contains blacklisted Input:" + keyword;
                                break;
                            }
                        }
                        if (key != null && value != null && servletParameterMap != null && servletParameterMap.size() > 0 && servletParameterMap.containsKey(servletPathString.toUpperCase()) && !"".equals(E12GenericUtility.checkNull(value))) {
                            HashMap<String, String> parameterDetailsMap;
                            int length = value.length();
                            HashMap<String, HashMap<String, String>> parameterMap = servletParameterMap.get(servletPathString.toUpperCase());
                            if (parameterMap != null && parameterMap.size() > 0 && parameterMap.containsKey(key.toUpperCase()) && (parameterDetailsMap = parameterMap.get(key.toUpperCase())) != null && parameterDetailsMap.size() > 0) {
                                String minLength = E12GenericUtility.checkNull(parameterDetailsMap.get("MIN_LEN"));
                                String maxLength = E12GenericUtility.checkNull(parameterDetailsMap.get("MAX_LEN"));
                                String spaceAllow = E12GenericUtility.checkNull(parameterDetailsMap.get("SPACE_ALLOW"));
                                if (minLength.length() == 0) {
                                    minLength = "0";
                                }
                                if (maxLength.length() == 0) {
                                    maxLength = "0";
                                }
                                int minLen = Integer.parseInt(minLength);
                                int maxLen = Integer.parseInt(maxLength);
                                if (length < minLen || length > maxLen) {
                                    result = "INVALID_REQUEST_PARAMETER~~" + key + "~~" + value + "~~" + "Parameter value length out of range";
                                    break;
                                }
                                if ("N".equalsIgnoreCase(spaceAllow) && value.contains(" ")) {
                                    result = "INVALID_REQUEST_PARAMETER~~" + key + "~~" + value + "~~" + "Parameter value contains space";
                                    break;
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Firewall.checkVulnerability() Exception : [" + E12GenericUtility.getStackTrace(e) + "]");
                throw new ITMException(e);
            }
        }
        BaseLogger.log("0", null, null, "Firewall.checkVulnerability() result : [" + result + "]");
        return result;
    }

    public boolean checkXml(String xmlString) {
        boolean xmlKeywordExist = false;
        BaseLogger.log("0", null, null, " inside checkXml [" + xmlString + "] ");
        try {
            Document dom = this.e12GenericUtility.parseString(xmlString);
            BaseLogger.log("0", null, null, "serializeDom dom : [" + this.e12GenericUtility.serializeDom(dom).toString() + "]");
            NodeList childNodeList = null;
            Node parentNode = null;
            Node childNode = null;
            String childNodeName = null;
            NodeList cList = null;
            NodeList parentNodeList = dom.getElementsByTagName("Root");
            int i = 0;
            while (i < parentNodeList.getLength()) {
                parentNode = parentNodeList.item(i);
                childNodeList = parentNode.getChildNodes();
                int childNodeListLength = childNodeList.getLength();
                int ctr = 0;
                while (ctr < childNodeListLength && !xmlKeywordExist) {
                    childNode = childNodeList.item(ctr);
                    childNodeName = childNode.getNodeName();
                    cList = childNode.getChildNodes();
                    if (childNodeName.startsWith("Detail")) {
                        int cListIterator = 0;
                        while (cListIterator < cList.getLength() && !xmlKeywordExist) {
                            String columnValue = "";
                            Node cNode = cList.item(cListIterator);
                            if (cNode != null && cNode.getNodeType() == 1) {
                                String cNodeName = cNode.getNodeName();
                                if (cNodeName != null && !cNodeName.equalsIgnoreCase("attribute") && cNode.getFirstChild() != null) {
                                    columnValue = cNode.getFirstChild().getNodeValue();
                                    if (allowedFeildList.size() > 0 && !allowedFeildList.contains(cNodeName.toUpperCase())) {
                                        int k = 0;
                                        while (k < blackListedInputList.size()) {
                                            String blacklistedInput = blackListedInputList.get(k);
                                            if (blacklistedInput != null) {
                                                if (columnValue.contains(blacklistedInput)) {
                                                    xmlKeywordExist = true;
                                                    this.xmlKeyword = blacklistedInput.toUpperCase();
                                                    BaseLogger.log("0", null, null, "[" + cNodeName + " contains blackListed Input Value]");
                                                    break;
                                                }
                                            } else {
                                                System.out.println("blacklistedinput getting blank...");
                                                BaseLogger.log("0", null, null, "blacklistedinput getting Null...");
                                            }
                                            ++k;
                                        }
                                    }
                                }
                            } else {
                                BaseLogger.log("0", null, null, "cNode getting Null...");
                            }
                            ++cListIterator;
                        }
                    }
                    ++ctr;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "Firewall.checkVulnerability() dom : [" + ex + "]");
        }
        return xmlKeywordExist;
    }
}

