
package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.util.*;
import java.util.Date;
import java.text.DateFormat;
import java.sql.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import java.text.SimpleDateFormat;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.webitm.utility.ITMException;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.utility.CommonConstants;
//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].

public class FlmCmeWizPreSaveEJB extends ValidatorEJB
{

	public String preSave()throws RemoteException,ITMException
	{
		return "";
	}


	public String preSave( String domString, String editFlag, String xtraParams ,Connection conn) throws RemoteException,ITMException
	{
		String retString = "";
		String objName = "";
		String eventDate = "";
		String sprsCode = "";

		PreparedStatement pStmt = null;
		Document dom = null;

		boolean isError = false;
		boolean isLocalConn = false;

		try
		{

			isLocalConn = true;

			//changed by Rahul Barve on 3-sep-2014
			//GenericUtility genericUtility = GenericUtility.getInstance();
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			dom = genericUtility.parseString(domString);
			objName  = "strg_meet_admin_wiz";
			System.out.println("objName["+objName+"]");

			System.out.println("domString StrgMeetAdminWizPreSaveEJB ["+domString+"]");
			eventDate = genericUtility.getColumnValue("event_date", dom, "1", "");
			sprsCode = genericUtility.getColumnValue("sales_pers", dom, "1", "");
			System.out.println("salesPers [" + sprsCode + "]   travelDate [" + eventDate + "]");

			int updateCnt = 0;
			String sql = "SELECT COUNT(1) COUNT, DCR_ID FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? GROUP BY DCR_ID";
			System.out.println(" sql for checking previous record exists or not["+sql+"]");
			pStmt = conn.prepareStatement( sql );
			pStmt.setString( 1, sprsCode);
			pStmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			ResultSet recExist = pStmt.executeQuery();
			while ( recExist.next() )
			{
				String dcrId = checkNull( recExist.getString("DCR_ID") );
				System.out.println("DCR_ID to be deleted [" + dcrId + "]");
				sql = "DELETE FROM SPRS_ACT_TRAN WHERE DCR_ID = ?";
				System.out.println(" Delete if record exist["+sql+"]");
				pStmt = conn.prepareStatement( sql );
				pStmt.setString( 1, dcrId);
				updateCnt = pStmt.executeUpdate();
				System.out.println("[FlmCmePreSaveEJB]Update Count for deleting from sprs_act_tran:"+updateCnt);

				sql = "DELETE FROM SPRS_TRAVEL WHERE DCR_ID = ?";
				pStmt = conn.prepareStatement( sql );
				pStmt.setString( 1, dcrId);
				updateCnt = pStmt.executeUpdate();
				System.out.println("[FlmCmePreSaveEJB]Update Count for deleting from mkt_event:"+updateCnt);

				sql = "DELETE FROM MKT_EVENT WHERE DCR_ID = ?";
				pStmt = conn.prepareStatement( sql );
				pStmt.setString( 1, dcrId);
				updateCnt = pStmt.executeUpdate();

				sql = "DELETE FROM MKT_EVENT_PARTICIPANT WHERE DCR_ID = ?";
				pStmt = conn.prepareStatement( sql );
				pStmt.setString( 1, dcrId);
				updateCnt = pStmt.executeUpdate();

				System.out.println("[FlmCmePreSaveEJB]Update Count for deleting from mkt_event_participant:"+updateCnt);

			}
			if ( pStmt != null )
			{
				pStmt.close();
			}

		}
		catch(Exception e)
		{
			System.out.println("Exception :StrgMeetAdminWizPreSaveEJB : :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{

				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :StrgMeetAdminWizPreSaveEJB : :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("Return string :"+retString);
		return retString;
	}

	private String getObjNameFromDom( Document dom, String attribute ) throws RemoteException,ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail1");
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return objName;
	}

	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}

}
