/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.GenerateFormLayout;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.InitialContext;
import org.w3c.dom.Document;

public class GenerateTranLayout {
    public String buildXSLString(String objName, String userLang, String userCountry, String editFlag, String appCtxPath, HashMap<String, String> propEditorInfoMap, UserInfoBean userInfo, Connection conn, ArrayList<String> gbNames) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "GenerateTranLayout: buildXSLString:Building XSL Str......");
        String xslString = "";
        String tempXslStr = "";
        String pageContext = "2";
        String objContext = "1";
        Document metaDataDoc = null;
        String sql = "";
        String formNo = "";
        Statement pstmt = null;
        ResultSet rs = null;
        String winName = "w_" + objName;
        String formTitle = "";
        HashMap<String, Object> paramMap = null;
        try {
            try {
                GenerateFormLayout formLayout = new GenerateFormLayout();
                sql = "SELECT TITLE,FORM_NO FROM OBJ_FORMS WHERE WIN_NAME = ? order by TO_NUMBER(FORM_NO)";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, winName);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    formNo = rs.getString("FORM_NO");
                    formTitle = rs.getString("TITLE");
                    if (!formNo.equalsIgnoreCase("1")) {
                        pageContext = "2";
                        objContext = formNo;
                        BaseLogger.log("3", userInfo, null, "Inside Obj forms Loop for obj context:[" + objContext + "]");
                        paramMap = this.getObjParamMap(objName, objContext, userInfo);
                        boolean isTaxApplicable = (Boolean)paramMap.get("IS_TAX_APPL");
                        metaDataDoc = formLayout.setLocaleLabels(objName, objContext, userLang, userCountry, pageContext, editFlag, propEditorInfoMap, userInfo);
                        tempXslStr = formLayout.getDetailXSL(editFlag, appCtxPath, gbNames, paramMap, userInfo);
                        tempXslStr = this.getDetailContainer(objContext, pageContext, formTitle, isTaxApplicable, tempXslStr);
                    } else {
                        BaseLogger.log("3", userInfo, null, "Inside Obj forms Loop for obj context:[" + objContext + "]");
                        metaDataDoc = formLayout.setLocaleLabels(objName, objContext, userLang, userCountry, pageContext, editFlag, propEditorInfoMap, userInfo);
                        tempXslStr = formLayout.getHeaderXSL(editFlag, appCtxPath, gbNames, this.getObjParamMap(objName, objContext, userInfo), userInfo, formTitle);
                    }
                    BaseLogger.log("3", userInfo, null, "Temp Xsl For obj Form:[" + formNo + "]" + tempXslStr);
                    xslString = String.valueOf(xslString) + tempXslStr;
                }
                xslString = String.valueOf(xslString) + "\n</FORM>\n<xsl:for-each select=\"/DocumentRoot/Message\">\n<xsl:value-of select='.'/></xsl:for-each>";
                xslString = String.valueOf(xslString) + "\n</body>";
                xslString = String.valueOf(xslString) + "</html>\n";
                xslString = String.valueOf(xslString) + "</xsl:template>\n";
                xslString = String.valueOf(xslString) + "</xsl:stylesheet>\n";
                StringBuffer xslStrinBuff = new StringBuffer(xslString);
                xslString = xslStrinBuff.toString();
                BaseLogger.log("3", userInfo, null, "GenerateTranLayout:GeneratedXsl->>>> " + xslString);
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "ITMException: GenerateTranLayout: buildXSLString:==>" + itme);
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception: GenerateTranLayout: buildXSLString:==>" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        BaseLogger.log("2", userInfo, null, "Returning XSL String Length :[" + xslString.length() + "]bytes");
        return xslString;
    }

    private String getDetailContainer(String objContext, String pageContext, String fromLabel, boolean isTaxAppl, String detailXsl) {
        String detailCont = "";
        detailCont = "<div class=\"detailHeading detailHeadingTab\">\n<div id=\"headerDiv" + objContext + "\" class=\"\" style=\"float: left;width: 50%;\">\n" + "<label class=\"datailHeaderLabel\" style=\"transition: none;\" ><i class=\"\"  />\n";
        detailCont = String.valueOf(detailCont) + fromLabel;
        detailCont = String.valueOf(detailCont) + "\n</label>\n";
        detailCont = String.valueOf(detailCont) + "</div>";
        detailCont = String.valueOf(detailCont) + "</div>";
        detailCont = String.valueOf(detailCont) + "\n<div id=\"" + objContext + "\" class=\"detailContainerDiv\" onClick=\"SetClipboardDataForSimple('" + objContext + "');\" style=\"top:0%;\" >";
        detailCont = String.valueOf(detailCont) + "\n<div name=\"addNew" + objContext + "\" id=\"addNew" + objContext + "\" onClick=\"invokeAction('" + objContext + "','A');\" class=\"addNewDetailBtn\" title=\"Add New\"> <p class=\"plus\">+</p> </div>";
        detailCont = String.valueOf(detailCont) + "\n<div name=\"deleteDetail" + objContext + "\" id=\"deleteDetail" + objContext + "\" onClick=\"invokeAction('" + objContext + "','D');\" class=\"deleteDetailBtn\" currDomId=\"1\" style=\"display:none;\" title=\"Delete\"> <p title=\"Delete\" class=\"remove\" onClick=\"event.stopPropagation(); invokeAction('" + objContext + "','D');\" > <img class=\"removeImg\" src=\"/ibase/webitm/images/remove.png\"/> </p> </div>";
        detailCont = String.valueOf(detailCont) + "\n<div name=\"copyData" + objContext + "\" id=\"copyData" + objContext + "\" onmouseover=\"displayMessageInsimple(this,'" + objContext + "');\"  onMouseout=\"displayNoneInSimple(this,'" + objContext + "');\"  onClick=\"OnClickEventCopyDataSimple();\" class=\"copyData \" title=\"\"> <p class=\"plus\"> <div class=\"copyImagePosition\"> <img class=\"copyImage\"  src=\"/ibase/webitm/images/copy.png\"/> </div> </p> <span class=\"tooltiptext\"  style=\"display:none;\"  id=\"DisplayPasteMsgSimple" + objContext + "\"> Click to,<br></br> Copy the content of the screen to clipboard, You can paste the data in external software and modify it. To press Ctrl + V to paste data from clipboard to this screen.<br></br> <b>Note:</b> Paste of data would happen subject to validity. </span></div>";
        detailCont = String.valueOf(detailCont) + "\n<div id=\"detailDataContainerDivId" + pageContext + objContext + "\" class=\"detailPgDetailDataContainerDiv detailPgScrollDiv\" scrollObjContext='" + objContext + "' onscroll=\"scrollDiv(this);\" >\n";
        detailCont = String.valueOf(detailCont) + detailXsl;
        detailCont = String.valueOf(detailCont) + "\n</div></div>\n";
        return detailCont;
    }

    public HashMap<String, Object> getObjParamMap(String objName, String objContext, UserInfoBean userInfo) throws ITMException {
        HashMap<String, Object> paramMap = null;
        try {
            BaseLogger.log("3", userInfo, null, "[GenerateTranLayout]Object name set2...............");
            InitialContext initialContext = new InitialContext(new AppConnectParm().getProperty());
            DBAccessEJB dbAccess = new DBAccessEJB();
            HashMap objDetailMap = dbAccess.getObjDetailMap(objName, userInfo);
            paramMap = new HashMap<String, Object>();
            if (objDetailMap != null) {
                paramMap.put("KEY_FLAG", objDetailMap.get("KEY_FLAG") != null ? (String)objDetailMap.get("KEY_FLAG") : "M");
                ArrayList taxList = this.getTokenList((String)objDetailMap.get("TAX_FORMS"), ",");
                Boolean isTaxApplicable = new Boolean(false);
                if (taxList != null && taxList.contains(objContext)) {
                    isTaxApplicable = new Boolean(true);
                }
                paramMap.put("IS_TAX_APPL", isTaxApplicable);
                paramMap.put("EDIT_TMPLT", objDetailMap.get("EDIT_TMPLT") != null ? new Integer((String)objDetailMap.get("EDIT_TMPLT")) : new Integer("0"));
            }
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :GenerateTranLayout :setObjDetails :==>" + e);
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "[GenerateTranLayout]Obj name and other initializations done !!!!!!!!!!!!!");
        return paramMap;
    }

    private ArrayList getTokenList(String tokenString, String delimiter) throws Exception {
        BaseLogger.log("2", null, null, "[GenerateTranLayout]Getting arraylist from the string :" + tokenString + ": delimiter :" + delimiter + ":");
        ArrayList<String> returnList = null;
        if (tokenString != null && tokenString.length() > 0 && tokenString != "") {
            returnList = new ArrayList<String>();
            if (delimiter.length() == 1) {
                while (tokenString.indexOf(delimiter) != -1) {
                    int endIndex = tokenString.indexOf(delimiter);
                    returnList.add(tokenString.substring(0, endIndex));
                    tokenString = tokenString.substring(endIndex + 1, tokenString.length());
                }
                returnList.add(tokenString.substring(0, tokenString.length()));
            } else if (delimiter.length() == 2 && (delimiter.equals("[]") || delimiter.equals("{}") || delimiter.equals("()"))) {
                while (tokenString.indexOf(delimiter.substring(0, 1)) != -1) {
                    int endIndex = tokenString.indexOf(delimiter.substring(1));
                    returnList.add(tokenString.substring(1, endIndex));
                    tokenString = tokenString.substring(endIndex + 1, tokenString.length());
                }
            }
        }
        return returnList;
    }
}

