package ibase.webitm.ejb.wsfa.transactions;

import java.io.StringWriter;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;
import java.util.TreeMap;

import javax.naming.InitialContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.json.JSONObject;
import org.json.simple.parser.JSONParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.bean.wsfa.DARCommonBean;
import ibase.webitm.bean.wsfa.OrgStructure;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.utility.wsfa.WSFACommon;

/**
 * Session Bean implementation class RealTimeReport
 */
//@Stateless		commented by Sagar M [22 Nov 2018].
public class CustomerSurveyWiz extends CustomerSurveyWizard 
{
	/**
	 * Default constructor.
	 */
	public CustomerSurveyWiz()
	{
		// TODO Auto-generated constructor stub
	}
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}
	
	private E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			System.out.println("xmlString ["+xmlString+"]");
			System.out.println("xmlString1 ["+xmlString1+"]");
			System.out.println("xmlString2:::::: ["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams, formName);
			System.out.println ( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println ( "Exception: RealTimeReportEJB: wfValData(String xmlString): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		//System.out.println ( "Returning from RealTimeReportEJB wfValData" );
		return (errString);
	}
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException, ITMException
	{
		//System.out.println("wfValData calling.............:::");
		String errString = "";
		PreparedStatement pstmtActivity = null;// modified by kailash.
		ResultSet rsActivity = null; // modified by kailash.
		ResultSet rs = null;
		ResultSet rSet = null; //added by rupali on 15/09/17 for worked with field
		Connection connectionObject = null;
		//GenericUtility genericUtility = GenericUtility.getInstance();
		PreparedStatement pstmt = null;
		Node parentNode = null;
		Node childNode = null;
		NodeList parentList =null;
		NodeList childList= null;
		String childNodeName = "";
		int parentNodeListLength =0;
		int noOfChilds = 0;
		int ctr = 0;
		ResultSet stpRs = null;
		String empCodeHO="";
		String stpStatus="";
		String usrTypeLogin = "";
		
		try
		{
			String dbName =CommonConstants.DB_NAME; //added by rupali on 15/09/17 for worked with field
			String columnValue = "";
			String strgCode="";
			String strgType="";
			String dcrDate="";
			String sql = "";
			int currentFormNo = 0;
			String sprsCodeWW = "";	// added by rupali on 03/05/18 for single screen mgr reporting
			//ConnDriver connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB("DriverValidator");
			connectionObject = getConnection();
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			String siteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			userId = getEmpCode(userId, connectionObject);

			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]
			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			//System.out.println("currentFormNo in wfValData:::"+currentFormNo);
			// added by rupali on 30/10/17 for applying condition of sfaparm for validation of stockist_code [start]
			String parmValue = "";
			String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='IS_PREF_STOCKIST' AND ACTIVE='Y' ";
			pstmt = connectionObject.prepareStatement(sfaParmSql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				parmValue = checkNull(rs.getString("PARM_VALUE"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			String isMemberPresnt  = checkNull(getSfaParmValue(userId,"HIDE_UNLIST_DET",connectionObject));  //added by mrunalini sinkar for member present
			String RealParmData = checkNull(getSfaParmValue(userId, "ALLOW_STOCKIST_DAR", connectionObject));// added by shraddha M for stockist validation[31-08-19]
			String isFortuneActivity = checkNull(getSfaParmValue(userId, "IS_FORTUNE_ACTIVITY", connectionObject));//added by Bhagyashri T for fortune validation[16-12-21]
			// added by rupali on 30/10/17 for applying condition of sfaparm for validation of stockist_code [start]
			String mgrCode = getMGREmployee(userId, connectionObject);// added by rupali on 03/05/18 for single screen mgr reporting

			String stockistTable = getSfaParmValue(userId,"GET_STOCKIST_DETAILS",connectionObject);
			String totAllwCallList="";
			
			if("doctor".equalsIgnoreCase(formName))
			{
				String updateFlag = ""; // added by rupali on 23/02/18 for edit mode of realtime report
				errString = wfValSalesPersAct(dom, dom2, objContext, userId,connectionObject);
				// commented by rupali on 18/10/17 for not allowing to finish the report if mandatory fields are blank on holiday
				//if( errString.indexOf( "<Errors>" ) == -1 )
				//{
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (ctr = 0; ctr < noOfChilds; ctr++)
					{
						columnValue ="";
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						childNodeName = childNode.getNodeName();
						String actType = checkNull(genericUtility.getColumnValue( "activity_type" , dom2 ,objContext));
						//System.out.println("activity type is:"+actType);
						strgType = checkNull(genericUtility.getColumnValue("cust_type", dom2, objContext));
						String cusType = checkNull(genericUtility.getColumnValue("strg_type", dom2, objContext));
						// added by rupali on 23/02/18 for edit mode of realtime report [start]
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
							//System.out.println("updateFlag is:::::::"+updateFlag);
						}
						// added by rupali on 23/02/18 for edit mode of realtime report [end]
						if (childNodeName.equalsIgnoreCase("event_date"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								//System.out.println("Tran date cannot be null:");
								errString = itmDBAccessLocal.getErrorString("event_date","NULEVTDATE",userId);

								break;
							}
							else
							{
								SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
								java.util.Date eventDate = null;
								try
								{
									eventDate = sdfFormat.parse( childNode.getFirstChild().getNodeValue());
									//System.out.println("eventdate is:"+eventDate);
									//System.out.println("eventDate is : ["+eventDate+"]");
								}
								catch ( Exception e )
								{
									//System.out.println("------------- INVALIDFRMT ---------------");
									errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
									break;
								}

								String evtdat=childNode.getFirstChild().getNodeValue();
								if (!sdfFormat.format(eventDate).equals(evtdat))
								{
									errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
									break;
								}
								// added by mrunalini sinkar for allowing future_date to particular activity code on 01-04-2019(start) 
								String futureDate="";
								String eventType = checkNull(genericUtility.getColumnValue( "event_type" , dom2 ,objContext));
								String itemSer = getItemSer(userId,connectionObject);
								//String actSql = " SELECT FUTURE_DATE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? AND ITEM_SER = ? ";
								
								if(dbName.equalsIgnoreCase("ORACLE"))
								{
									String actSql = "SELECT FUTURE_DATE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? "+
											 "AND (ITEM_SER IS NULL OR ITEM_SER = 'ALL' OR ITEM_SER = ?) "+
											 "AND (SITE_CODE IS NULL OR SITE_CODE = 'ALL' OR (SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE = ?) IN "+
											 "(SELECT REGEXP_SUBSTR(SITE_CODE,'[^,]+', 1, LEVEL) FROM DUAL CONNECT BY REGEXP_SUBSTR(SITE_CODE, '[^,]+', 1, LEVEL) IS NOT NULL) ) "+
											 "ORDER BY DESCR ";
									pstmt = connectionObject.prepareStatement(actSql);
									pstmt.setString(1, eventType);
									pstmt.setString(2, itemSer);  
									pstmt.setString(3, userId);  
									rSet = pstmt.executeQuery();
									if (rSet.next())
									{
										futureDate =  checkNull(rSet.getString("FUTURE_DATE"));
									}
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
								}
								else
								{

									String actSql = " SELECT FUTURE_DATE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
										pstmt = connectionObject.prepareStatement(actSql);
										pstmt.setString(1, eventType);
										rSet = pstmt.executeQuery();
										if (rSet.next())
										{
											futureDate =  checkNull(rSet.getString("FUTURE_DATE"));
										}
										if (rSet != null)
										{
											rSet.close();
											rSet = null;
										}
										if (pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
								 
								}
								
								
								
								// added by mrunalini sinkar for allowing future_date to particular activity code on 01-04-2019(end)
								//if ( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 )
								if (( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 && (futureDate.equalsIgnoreCase("0") || futureDate.trim().length() == 0)))
								{

									errString = itmDBAccessLocal.getErrorString( "event_date", "FUTUREVENT", userId );
									break;
								}
								// commentted and added by rupali on 26/06/19 for getting allow delay period from table [start]
								//String allDealyPrd = checkNull(genericUtility.getColumnValue( "allwd_delay_prd" , dom2 ,objContext));
								//String allDealyPrd = "";
								String entryMode = checkNull(genericUtility.getColumnValue( "entry_mode" , dom2 ,objContext));
								System.out.println("entryMode is:["+entryMode+"]");
								int allDealyPrd = 0;
								String allDelaySql = "SELECT ALLWD_DELAY_PRD FROM SALES_PERS WHERE SALES_PERS=?";
								pstmt =  connectionObject.prepareStatement(allDelaySql);
								pstmt.setString(1, checkNull(userId));
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									allDealyPrd = rs.getInt("ALLWD_DELAY_PRD");
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								// commentted and added by rupali on 26/06/19 for getting allow delay period from table [end]
								try
								{
									/*java.util.Date date = Calendar.getInstance().getTime();
									String currDate = sdfFormat.format( date );
									Date currenDate = sdfFormat.parse(currDate);
									long difference = currenDate.getTime() - eventDate.getTime();
									long daysBetween = (difference / (1000*60*60*24));
									String days=String.valueOf(daysBetween);
									int diffDays=Integer.parseInt(days);
									int allwPrd=Integer.parseInt(allDealyPrd);
									if(diffDays > allwPrd)
									{
										errString = itmDBAccessLocal.getErrorString( "event_date", "NOTALLWREP", userId );
										break;
									}*/
									
									int totDelPrd = 0;
									long diffDays = 0;
									java.util.Date currDate = new java.util.Date();
									java.util.Date tempDate = null;
									DateFormat applFormat = new SimpleDateFormat(getApplDateFormat());
									ArrayList<String> holiList = new ArrayList<String>();
									String eventdate = genericUtility.getValidDateTimeString( evtdat , getApplDateFormat() , getDBDateFormat());
									String holtblno = getHoltblno(userId,eventdate, connectionObject);
									
									Calendar cal = Calendar.getInstance();
									SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
									cal.setTime( sdf.parse(evtdat) );
									tempDate = cal.getTime();
									long diff = currDate.getTime() - tempDate.getTime();
									diffDays = diff / (24 * 60 * 60 * 1000);
									System.out.println(diffDays + " ssssdays, ");
									
									Calendar calBef = Calendar.getInstance(); 
									calBef.add(Calendar.DAY_OF_MONTH,-allDealyPrd);
									java.util.Date befoDate = calBef.getTime();
									String befoDateAppl = applFormat.format( befoDate );
									String befoDateDB= genericUtility.getValidDateTimeString( befoDateAppl , getApplDateFormat() , getDBDateFormat());
									
									Calendar calAft = Calendar.getInstance(); 
									java.util.Date aftDate = calAft.getTime();
									//String aftDateAppl = applFormat.format( aftDate );//Commended by Hariom for holiday check -03-Nov-20
									String aftDateDB= genericUtility.getValidDateTimeString( evtdat , getApplDateFormat() , getDBDateFormat());//Changed by Hariom for holiday check -03-Nov-20
									holiList = getHolidayList(befoDateDB,aftDateDB,holtblno,userId,connectionObject);//userId added by mrunalini sinkar for change_holiday(start)
									
									int holCnt = holiList.size();
									totDelPrd = allDealyPrd + holCnt;
									System.out.println("totDelPrd::["+totDelPrd+"] alwdDelPrd:::["+allDealyPrd+"] holCnt:::["+holCnt+"]");

									if (diffDays > totDelPrd && !"A".equalsIgnoreCase(entryMode))
									{
										errString = itmDBAccessLocal.getErrorString( "work_date" , "MAXDELYPRD" , userId );
										break;
									}
	
								}
								catch(Exception e)
								{
									System.out.println("------------- INVALIDFRMT ---------------");
									
								}
								
								// added by mrunalini sinkar for ALLOW_DAR_WO_MAP sun changes on 01-april-2019(start)
								
								// added by Atish Rane for not display Holiday error in edit mode  changes on 26-Aug-2019(start)

								String holiday="";
								//if(!updateFlag.equalsIgnoreCase("E"))
								//{
									System.out.println("updateFlag111+++++"+updateFlag);
								 holiday = valHoliday( evtdat, userId, userId, itmDBAccessLocal, connectionObject,updateFlag);
								//}



								//Added by Hariom  on 19-August-2019 for bangladesh user(start)
								String code="";
								String fromDate="";
								String brndParmData  = checkNull(getSfaParmValue(userId,"DAR_BRAND_MANDATE",connectionObject));
								String workDate = checkNull(genericUtility.getColumnValue( "event_date" , dom ));

								if(brndParmData.equalsIgnoreCase("Y"))
								{

									String frDate="SELECT FR_DATE-1 AS FR_DATE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE" ;
									pstmt = connectionObject.prepareStatement(frDate);
									pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										fromDate= checkNull(rSet.getString("FR_DATE"));
									}

									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}

									if(pstmt !=null)
									{
										pstmt.close();
										pstmt = null;
									}

									String periodCode="SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE" ;
									pstmt = connectionObject.prepareStatement(periodCode);
									pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(fromDate));
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										code= checkNull(rSet.getString("CODE"));
									}

									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}

									if(pstmt !=null)
									{
										pstmt.close();
										pstmt = null;
									}

									String brandSql = "SELECT * FROM STRG_BRAND_ACT WHERE SALES_PERS = ? AND PRD_CODE = ? ";
									pstmt = connectionObject.prepareStatement(brandSql);
									pstmt.setString(1,userId);
									pstmt.setString(2,code);
									rSet = pstmt.executeQuery();

									if(rSet.next())
									{
										System.out.println("Records are Present........");
									}
									else
									{
										errString = itmDBAccessLocal.getErrorString( "work_date" , "INVLIDDAR" , userId );
										break;

									}
									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}

									if(pstmt !=null)
									{
										pstmt.close();
										pstmt = null;
									}
								}

								//Added by Hariom  on 19-August-2019 for bangladesh user(end)
	
								
								int dojValidCount = 0;
								String sDobj = "SELECT COUNT(1) AS CNT FROM EMPLOYEE E WHERE EMP_CODE = ? AND ? < E.DATE_JOIN";
								pstmt = connectionObject.prepareStatement(sDobj);
								pstmt.setString(1, userId);
								pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( evtdat, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

								rSet = pstmt.executeQuery();
								if (rSet.next())
								{
									dojValidCount = rSet.getInt("CNT");
								}
								if (rSet != null)
								{
									rSet.close();
									rSet = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}

								if(dojValidCount > 0)
								{
									errString = itmDBAccessLocal.getErrorString( "work_date" , "INVDTJWRK" , userId );
									break;
								}
								
								/*String salesMode = "", deviceType = "";
								String modeSql = "SELECT MODE_REPO FROM SALES_PERS WHERE SALES_PERS= ? ";
								pstmt = connectionObject.prepareStatement(modeSql);
								pstmt.setString(1,userId);
								rSet = pstmt.executeQuery();
							    if(rSet.next())
							    {
							    	salesMode = checkNull(rSet.getString("MODE_REPO"));
							    	System.out.println("Records are Present........");
							    }
							    if (rSet != null)
								{
									rSet.close();
									rSet = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
							    
								String deviceTypeSql = "SELECT DEVICE_TYPE, TO_CHAR(LOGINTIME, 'DD-MM-YYYY HH24:MI:SS A.M.') FROM LOGINTRACE WHERE USERID = ? AND LOGINTIME = (SELECT MAX(LOGINTIME) FROM LOGINTRACE WHERE USERID = ?)";
								pstmt = connectionObject.prepareStatement(deviceTypeSql);
								pstmt.setString(1,userId);
								pstmt.setString(2,userId);
								rSet = pstmt.executeQuery();
							    if(rSet.next())
							    {
							    	deviceType = checkNull(rSet.getString("DEVICE_TYPE"));
							    	System.out.println("DEVICE_TYPE........"+deviceType);
							    }
							    if (rSet != null)
								{
									rSet.close();
									rSet = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								
							    System.out.println(": MODE :"+salesMode);
							    if (!deviceType.trim().equalsIgnoreCase("Browser") && salesMode.equalsIgnoreCase("W"))
							    {
								    errString = itmDBAccessLocal.getErrorString( "event_date" , "INVLIDMODE" , userId );
							    }
							    
							    String propValue = fetchPropertyValue("NETREPORT_MOBMODE_DISSALLOW" , itemSer , connectionObject);
							    if (deviceType.trim().equalsIgnoreCase("Browser"))
								{									
									if (salesMode.equalsIgnoreCase("M") && propValue.indexOf(updateFlag) >= 0)
									{
											errString = itmDBAccessLocal.getErrorString( "work_date" , "MOBNETNA" , userId );
											break;
									}
								}*/
							}
						}
						else if (childNodeName.equalsIgnoreCase("event_type"))
						{
							//System.out.println("Inside eventtype");
							String actCode = checkNull(genericUtility.getColumnValue("event_type", dom2, objContext));
							//System.out.println("actCode =["+actCode+"]");
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								//System.out.println("Activity cannot be null:");
								errString = itmDBAccessLocal.getErrorString("event_type","NULACTCODE",userId);

								break;
							}
							else
							{
								String actSql = "";
								int count = 0;

								actSql = "SELECT COUNT(*) AS COUNT FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
								pstmt = connectionObject.prepareStatement(actSql);
								pstmt.setString(1, actCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count = rs.getInt("COUNT");
								}
								if (rs != null)
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									errString = itmDBAccessLocal.getErrorString("event_type","ACTNOTPRE",userId);
									break;
								}
								//added by mrunalini sinkar on 1-june-2017 for activity type validation (start)
								String eventDate = checkNull(genericUtility.getColumnValue( "event_date" , dom2 ,objContext));
								String salesPers = checkNull(genericUtility.getColumnValue( "sales_pers" , dom2 ,objContext));

								String pDate = genericUtility.getValidDateTimeString( eventDate , getApplDateFormat() , getDBDateFormat());

								//ArrayList halfDayActList = halfDayActivityList("HALF_DAY_ACTIVITIES",connectionObject);
								//int recCount = 0;
								ArrayList activityList = new ArrayList();
								String activitySql = "SELECT ACTIVITY_CODE FROM SPRS_ACT_TRAN WHERE EVENT_DATE = ? AND SALES_PERS=? ";
								pstmt = connectionObject.prepareStatement(activitySql);
								pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(pDate));
								pstmt.setString(2, salesPers);
								rs = pstmt.executeQuery();
								while (rs.next())
								{
									activityList.add(rs.getString("ACTIVITY_CODE"));
									//System.out.println("arraylsit"+activityList);
								}
								if(rs!=null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}

								//recCount = activityList.size();
								columnValue = checkNull( columnValue );
								String checkSQL="";
								checkSQL = "SELECT SPRS_ACT_TRAN.ACTIVITY_CODE AS ACTIVITY_CODE,FIELDACTIVITY.ACTIVITY_TYPE AS ACTIVITY_TYPE FROM SPRS_ACT_TRAN,FIELDACTIVITY WHERE EVENT_DATE=? AND SALES_PERS=?  AND SPRS_ACT_TRAN.ACTIVITY_CODE = FIELDACTIVITY.ACTIVITY_CODE ";
								pstmt = connectionObject.prepareStatement(checkSQL);
								pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(pDate));//Shahu - 27/10/12
								pstmt.setString(2, salesPers);
								rs = pstmt.executeQuery();
								while(rs.next())
								{
									String activityCode =checkNull( rs.getString("ACTIVITY_CODE"));
									activityCode = checkNull(activityCode).trim().toUpperCase();
									//System.out.println("ACTIVITY CODE IS:"+activityCode);
									String activityType = checkNull(rs.getString("ACTIVITY_TYPE"));
									activityType = checkNull(activityType).trim().toUpperCase();
									//System.out.println("ACTIVITY TYPE IS:"+activityType);


									if(activityType.indexOf("LEAVE")!=-1)
									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmtActivity = connectionObject.prepareStatement(checkSQL);
										pstmtActivity.setString(1, columnValue);
										rsActivity =pstmtActivity.executeQuery();
										if(rsActivity.next())
										{
											String eventType = checkNull(rsActivity.getString("ACTIVITY_TYPE"));
											//changed by vishal pathare on 6.11.17 for[ alert msg should display if activity code changed].
											//if(!columnValue.equalsIgnoreCase( activityCode ))
											if(!activityType.equalsIgnoreCase(eventType))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANLEAVE", userId );
												break;
											}
											else
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "LEAVEDAY", userId );
												break;
											} // added by mrunalini sinkar to cannot allow LEAVE on same day
										}
									}
									//else if (activityType.indexOf("NFW")!=-1)//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
									else if (!activityType.equalsIgnoreCase("FW") && !activityType.equalsIgnoreCase("LEAVE"))
									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmtActivity = connectionObject.prepareStatement(checkSQL);
										pstmtActivity.setString(1, columnValue);
										rsActivity =pstmtActivity.executeQuery();
										if(rsActivity.next())
										{
											String eventType = checkNull(rsActivity.getString("ACTIVITY_TYPE"));
											//changed by vishal pathare on 6.11.17 for[ alert msg should display if activity code changed].											//if(!activityType.equalsIgnoreCase(eventType))
											//if(!columnValue.equalsIgnoreCase( activityCode ))
											if(!activityType.equalsIgnoreCase(eventType))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANNFW", userId );
												break;
											}
											else
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "NFWDAY", userId );
												break;
											} // added by mrunalini sinkar to cannot allow NFW on same day
										}

									}
									else if (activityType.indexOf("FW")!=-1)
									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmtActivity = connectionObject.prepareStatement(checkSQL);
										pstmtActivity.setString(1, columnValue);
										rsActivity =pstmtActivity.executeQuery();
										if( rsActivity.next() )
										{
											String eventType = checkNull(rsActivity.getString("ACTIVITY_TYPE"));
											//System.out.println("activity type is:"+eventType);
											//changed by vishal pathare on 6.11.17 for[ alert msg should display if activity code changed].
											//if(!columnValue.equalsIgnoreCase( activityCode ))
											if(!activityType.equalsIgnoreCase(eventType))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANFW", userId );
												break;
											}
										}

									}

									if (rsActivity!= null)
									{
										rsActivity.close();
										rsActivity = null;
									}
									if(pstmtActivity!=null)
									{
										pstmtActivity.close();
										pstmtActivity = null;
									}


								}
								if(rs!=null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
							}
							//added by mrunalini sinkar on 1-june-2017 for activity type validation (end)

						}						
						else if("FW".equalsIgnoreCase(actType))//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
						{
							String actCode = checkNull(genericUtility.getColumnValue("event_type", dom2, objContext));
							if ( childNodeName.equalsIgnoreCase("strg_code"))
							{
								String routeType = checkNull((genericUtility.getColumnValue("route_type", dom2, objContext)));

								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									if(!"H".equalsIgnoreCase(routeType) && !"M".equalsIgnoreCase(routeType) && !actCode.equalsIgnoreCase("CA") )
									{
										errString = itmDBAccessLocal.getErrorString( "strg_code" , "NULSTRGCOD" , userId );
										break;
									}
									
								}
								else 
								{
									dcrDate = checkNull((genericUtility.getColumnValue("event_date", dom2, objContext)));
									strgCode = checkNull((genericUtility.getColumnValue("strg_code", dom2, objContext)));
									if( strgCode.equalsIgnoreCase("NA") )
									{
										continue;
									}
									sprsCodeWW = checkNull((genericUtility.getColumnValue("visited_with_team", dom2, objContext))); // added by rupali on 03/05/18 for single screen mgr reporting
									String strgCustType = checkNull((genericUtility.getColumnValue("strg_type", dom2, objContext)));
									int count = 0;
									String strgCodeSql = "";
									String custActiveSql = "";
									if(strgCustType.equalsIgnoreCase("S") && stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
									{
										strgCodeSql = "SELECT COUNT(*) AS COUNT FROM CUSTOMER WHERE CUST_CODE= ? ";
									}
									else
									{
										strgCodeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE= ? ";
									}
									pstmt = connectionObject.prepareStatement(strgCodeSql);
									pstmt.setString(1,strgCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										count = rs.getInt("COUNT");
									}
									if (rs != null)
									{
										rs.close();
										rs = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(count == 0)
									{
										errString = itmDBAccessLocal.getErrorString("strg_code","CUSTNTEXT",userId);
										break;
									}

									int custCount = 0;
									String custExistSql = "SELECT COUNT(*) AS COUNT FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE = ? AND STRG_CODE = ?";
									pstmt = connectionObject.prepareStatement(custExistSql);
									pstmt.setString(1, userId);
									pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
									pstmt.setString(3, strgCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										custCount = rs.getInt("COUNT");
									}
									if (rs != null)
									{
										rs.close();
										rs = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(custCount > 0 && !"E".equalsIgnoreCase(updateFlag)) // added condition of by updateFlag rupali on 23/02/18 for edit mode of realtime report
									{
										errString = itmDBAccessLocal.getErrorString("strg_code","CUSTEXST",userId);
										break;
									}

								}
							}
							else if( childNodeName.equalsIgnoreCase("survey_templ"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString =getErrorString("survey_templ","SUTEMPNULL",userId);
									break;
								}
								else
								{
									int tempCnt = 0;
									String custExistSql = "SELECT COUNT(*) AS COUNT FROM SURVEY_TEMPLATE WHERE CONFIRMED = 'Y'";
									pstmt = connectionObject.prepareStatement(custExistSql);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										tempCnt = rs.getInt("COUNT");
									}
									if (rs != null)
									{
										rs.close();
										rs = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(tempCnt == 0) // added condition of by updateFlag rupali on 23/02/18 for edit mode of realtime report
									{
										errString = itmDBAccessLocal.getErrorString("survey_templ","SUTNOTEXST",userId);
										break;
									}
								}
							}

							
						}
						if (childNodeName.equalsIgnoreCase("sales_pers"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								errString =getErrorString("sales_pers","NULSPCODNM",userId);
								break;
							}

						}


					}
				}
				if(errString != null && errString.length()>0 && errString.indexOf("Errors")!=-1)
				{
					System.out.println(" Detail contaning :: errString :: []");
					String msgDescr = "";
					msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
					if(errString.contains("UNLSTNTALW"))
					{
						String strData = msgDescr.substring( msgDescr.indexOf("having")+("having").length(), msgDescr.indexOf("customers"));
						msgDescr = msgDescr.replace(strData, " "+totAllwCallList+" ");
						errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) +"<![CDATA["+ msgDescr +"]]>"+"" + errString.substring( errString.indexOf("</description>"), errString.length());
					}
					return errString;
				}


			}
			else if("survey".equalsIgnoreCase(formName) || "retailersurvey".equalsIgnoreCase(formName) || "stockistsurvey".equalsIgnoreCase(formName) || "ncwsurvey".equalsIgnoreCase(formName))
			{
				// added by rupali on 16/07/19 to validate survey question [start]
				String surveyDescr = "", surveyCode = "";
				ArrayList surveyList = new ArrayList();
				ArrayList custTypeList = new ArrayList();
				
				String eventDate = checkNull(genericUtility.getColumnValue("event_date", dom2));
				String eventType = checkNull(genericUtility.getColumnValue("event_type", dom2));
				strgType = checkNull(genericUtility.getColumnValue("strg_type", dom2));
				String surveyTemplate=checkNull(genericUtility.getColumnValue("survey_templ", dom2));
				//Added by Pooja S on  [18-FEB-2020] to set the activity template in case of MI 
				String activityTempl=checkNull(genericUtility.getColumnValue("activity_templ", dom2));
				// added by rupali on 16/07/19 to validate survey question [end]
				
				//System.out.println("survey : validation ::");
				parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
				parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectBox = "";
					String updateFlag = "";
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds["+noOfChilds+"]");
					for (ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
						if(childNodeName.equalsIgnoreCase("strg_code"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								errString = itmDBAccessLocal.getErrorString( "strg_code" , "NULSTRGCD" , userId );
								break;
							}
						}
						else if(childNodeName.equalsIgnoreCase("survey_code"))
						{
							//System.out.println("inside survey_code:::::"+childNodeName);
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								//System.out.println("inside survey_code if loop:::::"+childNodeName);
								errString = itmDBAccessLocal.getErrorString("survey_code","NULSURVCD",userId);
								break;
							}
							// added by rupali on 16/07/19 to validate survey question [start]
							else
							{
								surveyCode = checkNull(genericUtility.getColumnValueFromNode("survey_code", parentNode));
								surveyDescr = checkNull(genericUtility.getColumnValueFromNode("strgType", parentNode));
								surveyList.add(surveyCode);
							}
							// added by rupali on 16/07/19 to validate survey question [end]
						}
						else if(childNodeName.equalsIgnoreCase("result1") || childNodeName.equalsIgnoreCase("result2") || childNodeName.equalsIgnoreCase("result3"))
						{
							//System.out.println("inside survey_code:::::"+childNodeName);
							String resultType = genericUtility.getColumnValueFromNode("result_type", parentNode);
							//System.out.println("inside survey_code resultType is:::::"+resultType);
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								if((childNodeName.equalsIgnoreCase("result1") && (resultType.equalsIgnoreCase("N"))) || (childNodeName.equalsIgnoreCase("result3") && (resultType.equalsIgnoreCase("T")))
										|| (childNodeName.equalsIgnoreCase("result2") && (resultType.equalsIgnoreCase("D") || resultType.equalsIgnoreCase("L"))))
								{
									errString = itmDBAccessLocal.getErrorString("survey_code","NULSURVRES",userId);
									break;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("doc_id_2"))
						{
							System.out.println("inside DOC_ID__2:::::"+childNodeName);
							String attachOPT = checkNull(genericUtility.getColumnValueFromNode("attach_opt", parentNode));
							System.out.println("inside DOC_ID__2 attachOPT:::::"+attachOPT);
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								System.out.println("inside DOC_ID__2 if loop:::::");
								if("1".equalsIgnoreCase(attachOPT))
								{
									errString = itmDBAccessLocal.getErrorString("survey_code","NULLATTACH",userId);
									break;
									
								}
							}
						}
					}
					if(errString != null && errString.trim().length() > 0)
					{
						break;
					}
				}
				// added by rupali on 16/07/19 to validate survey question [start]
				if(errString == null ||  errString.trim().length() == 0)
				{
					System.out.println("strgType:::"+strgType+" surveyList:::"+surveyList+"surveyTemplate IS["+surveyTemplate+"] eventType ["+ eventType +"]");
					custTypeList=getTemplateSurvey(connectionObject, userId);
					System.out.println("custTypeList is:["+custTypeList+"]");
					if(custTypeList.contains(strgType)  && parentNodeListLength > 0)
					{
							String surveySql = "SELECT B.SURVEY_CODE SURVEY_CODE, C.DESCR SURVEY_DESCR,C.MANDATORY FROM SURVEY_TEMPLATE A, SURVEY_TEMPL_DET B, SURVEY_MASTER C, SURVEY_GROUP G " + 
							           "WHERE A.SURVEY_TEMPL = B.SURVEY_TEMPL AND C.SURVEY_GROUP = G.SURVEY_GROUP AND A.SURVEY_TEMPL IN(SELECT SURVEY_TEMPL FROM SURVEY_TEMPLATE " + 
							           "WHERE SURVEY_TEMPL = ? AND ? BETWEEN EFF_FROM AND VALID_UPTO AND CONFIRMED ='Y') AND B.SURVEY_CODE = C.SURVEY_CODE " + 
							           "AND C.ACTIVE='Y' AND C.MANDATORY = 'Y'";
							PreparedStatement pstmtSurvey =  connectionObject.prepareStatement(surveySql);
							//Added by Pooja S on  [18-FEB-2020] to set the activity template in case of MI Start
							if( eventType.equalsIgnoreCase("MI")  || eventType.equalsIgnoreCase("OT"))
							{
								pstmtSurvey.setString(1,activityTempl);
							}
							else
							{
							pstmtSurvey.setString(1,surveyTemplate);
							}
							//Added by Pooja S on  [18-FEB-2020] to set the activity template in case of MI Start End
							pstmtSurvey.setTimestamp(2,java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ));
							ResultSet rsSurvey = pstmtSurvey.executeQuery();
							while (rsSurvey.next())
							{
								surveyCode = checkNull(rsSurvey.getString("SURVEY_CODE"));
								surveyDescr = checkNull(rsSurvey.getString("SURVEY_DESCR"));
								if(!surveyList.contains(surveyCode))
								{
									errString = itmDBAccessLocal.getErrorString("survey_code","SURVENTSEL",userId);
									break;
								}
							}
							//Added by Hariom for Dirty Connection close -- 09-Mar-2021 [Start]
							if (rsSurvey != null)
							{
								rsSurvey.close();
								rsSurvey = null;
							}
							if (pstmtSurvey != null)
							{
								pstmtSurvey.close();
								pstmtSurvey = null;
							}
							//Added by Hariom for Dirty Connection close -- 09-Mar-2021 [End]
							if(errString != null && errString.trim().length() > 0)
							{
								System.out.println("surveyDescr =["+surveyDescr+"]");
								errString = getModifiedErrorString(errString, surveyDescr);
							}
						}
						// added by rupali on 16/07/19 to validate survey question [end]
				}
			}


		}//try end
		catch (Exception e)
		{
			System.out.println ( "Exception: real time reoprt: wfValData(Document dom): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		finally
		{
			try
			{
				//Added by kailash on 05-04-18 for closing resultset and prepare stmt[Start]
				if (rsActivity!= null)
				{
					rsActivity.close();
					rsActivity = null;
				}
				if(pstmtActivity!=null)
				{
					pstmtActivity.close();
					pstmtActivity = null;
				}
				//Added by kailash on 05-04-18 for closing resultset and prepare stmt[End]
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :real Time report : wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return (errString);

	}

	
	public String defaultDataWiz() throws RemoteException, ITMException
	{
		return "";
	}

	public String defaultDataWiz(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams, String formName) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		System.out.println("defaultDataWiz xmlString:::: ["+xmlString+"]");
		System.out.println("defaultDataWiz xmlString1::: ["+xmlString1+"]");
		System.out.println("defaultDataWiz xmlString2::: ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = defaultDataWiz( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams, formName );
			//System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :RealTimeReportEJB :defaultDataWiz(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		//System.out.println ( "returning from RealTimeReportEJB defaultDataWiz" );
		return errString;
	}
	public String defaultDataWiz( Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams, String formName ) throws RemoteException,ITMException
	{
		//System.out.println ( "In side defaultDataWiz :::::::::" );
		ResultSet rs = null;
		PreparedStatement pstmt = null,pStmt1=null;
		ResultSet itemRs = null,rs1=null;
		String sql = "";
		String columnValue = "";
		String userId = "";
		Statement stmt = null;
		int currentFormNo = 0;
		String errString = "",itemCode="",salesPers="";
		String eventDate="",strgType="",strgCode="", strgNameDom ="";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		String [] temp = new String [10];
		String spName = "";
		String empcode = "";
		//String windowName = "w_"+getObjName(dom,objContext);
		//System.out.println("Window Name Got :::["+windowName+"]");
		String clientName="",phoneNo="",address="",emailId="",visitTimeFr="",visitTimeTo="",localitySql="",localityDescr="",dcrDate="";
		String sprsCodeWW = ""; // added by rupali on 03/05/18 for single screen mgr reporting

		try
		{
			String dbName =CommonConstants.DB_NAME; //added by rupali on 15/09/17 for worked with field

			String currentGeoPos = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"currentGeoPos");
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			connectionObject = getConnection();
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			userId = getEmpCode(userId, connectionObject);
			empcode = userId;
			String empDesign = getDesignName(userId, connectionObject); 
			columnValue = genericUtility.getColumnValue( currentColumn, dom );
			String mgrCode = getMGREmployee(userId, connectionObject);// added by rupali on 03/05/18 for single screen mgr reporting

			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			String tranId ="";
			String prdCode ="";
			String spNameSql = "";
			InetAddress ownIP=InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			DateFormat dbFormat = new SimpleDateFormat(getDBDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			String currentDate = dtFormat.format( date );
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");

			if("doctor".equalsIgnoreCase(formName))
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				String doctorFormNo= checkNull(getFormNo(objName, "doctor", connectionObject));
				String sampleOrder=checkNull(getFormNo(objName, "sampleorder", connectionObject));
				String doctorTeam=checkNull(getFormNo(objName, "team", connectionObject));
				String startTime =  geteventTime();
				String isMemberPresnt  = checkNull(getSfaParmValue(userId,"HIDE_UNLIST_DET",connectionObject));  
				String displayTimeField  = checkNull(getSfaParmValue(userId,"HIDE_EVENT_TIME_END",connectionObject));
				String isFortuneActivity = checkNull(getSfaParmValue(salesPers, "IS_FORTUNE_ACTIVITY", connectionObject));
				
				if( currentColumn.equalsIgnoreCase( "itm_default" ))
				{
					String sprsCode = genericUtility.getColumnValue("sales_pers", dom2, doctorFormNo);
					String actCode = genericUtility.getColumnValue("event_type", dom2, doctorFormNo);
					String custTypeDescr = genericUtility.getColumnValue("sh_descr", dom2, doctorFormNo);
					String trvDate = genericUtility.getColumnValue("event_date", dom2, doctorFormNo);
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom2,doctorFormNo));
					String activityCode = checkNull(genericUtility.getColumnValue("strg_code", dom2,doctorFormNo));// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]

					
					spNameSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
					pstmt =  connectionObject.prepareStatement(spNameSql);
					pstmt.setString(1, userId);
					rs = pstmt.executeQuery();
					if ( rs.next())
					{
						spName = checkNull(rs.getString("SP_NAME"));
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					String stanCodeHQ="",headQaurter="";
					String hqSql="SELECT EMP.STAN_CODE__HQ AS STAN_CODE__HQ,ST.DESCR AS HEADQAURTER FROM EMPLOYEE EMP,STATION ST WHERE EMP.EMP_CODE=? AND EMP.STAN_CODE__HQ=ST.STAN_CODE";
					pstmt =  connectionObject.prepareStatement(hqSql);
					pstmt.setString(1, userId);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						stanCodeHQ = checkNull(rs.getString("STAN_CODE__HQ"));
						headQaurter = checkNull(rs.getString("HEADQAURTER"));
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					
					
					String allowChgTime="";
					String ACTIVITYSql="SELECT ALLOW_CHG_VISITTIME FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
					pstmt =  connectionObject.prepareStatement(ACTIVITYSql);
					pstmt.setString(1, userId);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						allowChgTime = checkNull(rs.getString("ALLOW_CHG_VISITTIME"));
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					
					String parmValue = getSfaParmValue(userId,"SEQUENTIAL_DAR",connectionObject); // added by mrunalini sinkar on 21-Feb-2018(start)

					
					
					
					
				
					String eFlag=genericUtility.getColumnValue("editFlag", dom2,doctorFormNo);

					String tranID = genericUtility.getColumnValue("prv_tran_id", dom2, doctorFormNo);
					System.out.println("tranID::::::::"+tranID+"eFlag :::::::"+eFlag);
					int cnt = 0;
					if(tranID != null && tranID != "" && tranID.trim().length() != 0 && "E".equalsIgnoreCase(eFlag))
					{
						SimpleDateFormat applFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());//Added by mrunalini sinkar for next plan date


						String editSql = "SELECT  SM.* ,ST.DESCR AS SURVEY_TEMPL_DESCR FROM STRG_MEET SM LEFT OUTER JOIN SURVEY_TEMPLATE ST ON SM.SURVEY_TEMPL=ST.SURVEY_TEMPL  WHERE SM.TRAN_ID=?";
						pstmt =  connectionObject.prepareStatement(editSql);
						pstmt.setString(1, tranID);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							Date planDate=null;
							String showDate="";
							String actType = "";
							String actDescr = "";
							String stockistCode = "";

							String placeRequired="";
							String visitedwithTeam = ""; 
							currDate = rs.getString("EVENT_DATE");
							Date evntDate = dbFormat.parse(currDate);
							currDate = dtFormat.format(evntDate);
							String eventType = checkNull(rs.getString("EVENT_TYPE"));
							String classCode = checkNull(rs.getString("STRG_CLASS_CODE"));
							String cusType = checkNull(rs.getString("STRG_TYPE"));
							strgCode = checkNull(rs.getString("STRG_CODE"));
							String copyPlan = checkNull(rs.getString("COPY_PLAN"));
							String callOutcome = checkNull(rs.getString("CALL_OUTCOME")); 
							sprsCodeWW = checkNull(rs.getString("SPRS_CODE__WW"));
							String nextPlanDate=checkNull(rs.getString("NEXT_PLAN_DATE"));
							if(nextPlanDate!=null && nextPlanDate.trim().length()>0)
							{
								planDate=dbFormat.parse(nextPlanDate);
								showDate=applFormat.format(planDate);
							}
							String templateId=checkNull(rs.getString("SURVEY_TEMPL"));
							String templateIdDescr=checkNull(rs.getString("SURVEY_TEMPL_DESCR"));

							//changed by mrunalini sinkar for place required changes(start)
							//String actSql  = "SELECT DESCR, ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
							String actSql  = "SELECT DESCR, ACTIVITY_TYPE,PLACE_REQUIRED FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
							pStmt1 = connectionObject.prepareStatement(actSql);
							pStmt1.setString(1, eventType);
							rs1 = pStmt1.executeQuery();
							if(rs1.next())
							{
								actDescr = checkNull(rs1.getString("DESCR"));
								actType = checkNull(rs1.getString("ACTIVITY_TYPE"));
								placeRequired = checkNull(rs1.getString("PLACE_REQUIRED"));
							}
							if( rs1 !=null )
							{
								rs1.close();
								rs1 = null;
							}
							if( pStmt1 !=null )
							{
								pStmt1.close();
								pStmt1 = null;
							}
							
							

							String custSql  = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE = ?";
							pStmt1 = connectionObject.prepareStatement(custSql);
							pStmt1.setString(1, strgCode);
							rs1 = pStmt1.executeQuery();
							if(rs1.next())
							{
								cnt = rs1.getInt("COUNT");
							}
							if( rs1 !=null )
							{
								rs1.close();
								rs1 = null;
							}
							if( pStmt1 !=null )
							{
								pStmt1.close();
								pStmt1 = null;
							}

							//adeed by mrunalini sinkar on 6-july-2018(start)
							String active="",parmVal="",formNo="";
							String subFormsql="SELECT ACTIVE,PARM_VALUE FROM SFAPARM WHERE PARM_NAME='IS_SUBFORM_PROTECT'";
							PreparedStatement subFormPstmt =connectionObject.prepareStatement(subFormsql);
							ResultSet subFormRs = subFormPstmt.executeQuery();
							if(subFormRs.next())
							{
								active=checkNull(subFormRs.getString("ACTIVE"));
								parmVal=checkNull(subFormRs.getString("PARM_VALUE"));
							}
							if(subFormRs != null)
							{
								subFormRs.close();
								subFormRs = null;
							}
							if(subFormPstmt != null)
							{
								subFormPstmt.close();
								subFormPstmt = null;
							}
							if(active.equalsIgnoreCase("Y"))
							{

								String subFormName = "";
								String [] subForm = parmVal.split(",");
								for(int i = 0 ;i < subForm.length;i++)
								{
									if(subFormName == null || subFormName.trim().length() == 0)
									{
										subFormName = subForm[i];
									}
									else
									{
										subFormName = subFormName + "','" + subForm[i];
									}
								}
								subFormName = "'" + subFormName + "'";

								String objectName = getObjNameFromDom( dom, "objName" , 1);
								String objWinName = "w_"+objectName;
								String objFormSql= "SELECT FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN("+subFormName+") ";
								PreparedStatement objFormpstmt = connectionObject.prepareStatement(objFormSql);
								objFormpstmt.setString(1, objWinName);
								ResultSet objFormrs = objFormpstmt.executeQuery();
								while(objFormrs.next())
								{
									String objFormNo = checkNull(objFormrs.getString("FORM_NO"));
									if(formNo == null || formNo.trim().length() == 0)
									{
										formNo = objFormNo;
									}
									else
									{
										formNo = formNo + "," + objFormNo;
									}
								}
								if(objFormrs != null)
								{
									objFormrs.close();
									objFormrs = null;
								}
								if(objFormpstmt != null)
								{
									objFormpstmt.close();
									objFormpstmt = null;
								}
							}
							//System.out.println("formNo is["+formNo+"]");
							valueXmlString.append( "<Detail"+objContext+" domID='1' formName='"+formName+"' selected = 'Y'>\r\n" );
							valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
							valueXmlString.append("<tran_id><![CDATA[" ).append(tranID).append( "]]></tran_id>\r\n" );
							valueXmlString.append("<event_date protect = '1'><![CDATA[" ).append( currDate ).append( "]]></event_date>\r\n" );
							valueXmlString.append("<survey_templ protect = '1'>").append(templateId).append("</survey_templ>\r\n");
							valueXmlString.append("<survey_templ_descr protect = '1'>").append(templateIdDescr).append("</survey_templ_descr>\r\n");

							valueXmlString.append( "<emp_design><![CDATA[" ).append( empDesign ).append( "]]></emp_design>\r\n" );
							valueXmlString.append( "<grade_code><![CDATA[" ).append( "" ).append( "]]></grade_code>\r\n" );
							//Added by Pooja on 18/12/19 [Coaching related detail form implementation] END
							valueXmlString.append( "<event_type protect = '1'><![CDATA[" ).append( checkNull(rs.getString("EVENT_TYPE")) ).append( "]]></event_type>\r\n" );
							valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append( actDescr ).append( "]]></activity_descr>\r\n" );
							valueXmlString.append( "<activity_type><![CDATA[" ).append( actType ).append( "]]></activity_type>\r\n" );
							valueXmlString.append( "<place_required><![CDATA[" ).append( placeRequired ).append( "]]></place_required>\r\n" );	// added by mrunalini sinkar on 09-sep-2018 for place required changes(start)
							valueXmlString.append( "<chg_date protect = '1'><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
							valueXmlString.append( "<chg_user protect = '1'><![CDATA[" ).append(empcode).append( "]]></chg_user>\r\n" );
							valueXmlString.append( "<chg_term protect = '1'><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
							valueXmlString.append( "<sales_pers protect = '1'><![CDATA[" ).append(userId).append( "]]></sales_pers>\r\n" );
							valueXmlString.append( "<sales_pers_sp_name protect = '1'><![CDATA[" ).append(spName).append( "]]></sales_pers_sp_name>\r\n" );
							valueXmlString.append( "<stan_code__hq><![CDATA[" ).append(stanCodeHQ).append( "]]></stan_code__hq>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
							valueXmlString.append( "<headquarter><![CDATA[" ).append(headQaurter).append( "]]></headquarter>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
							valueXmlString.append( "<strg_type protect = '1'><![CDATA[" ).append( checkNull(rs.getString("STRG_TYPE")) ).append( "]]></strg_type>\r\n" );
							valueXmlString.append( "<locality_code protect = '1'><![CDATA[" ).append( checkNull(rs.getString("LOCALITY_CODE")) ).append( "]]></locality_code>\r\n" );
							valueXmlString.append( "<wf_status><![CDATA[" ).append( checkNull(rs.getString("WF_STATUS")) ).append( "]]></wf_status>\r\n" );
							valueXmlString.append( "<confirmed><![CDATA[" ).append( checkNull(rs.getString("CONFIRMED")) ).append( "]]></confirmed>\r\n" );
							valueXmlString.append( "<route_id protect='1'><![CDATA[" ).append( checkNull(rs.getString("ROUTE_ID")) ).append( "]]></route_id>\r\n" ); // added by mrunalini sinka for route_id changes on 30-04-2019
							valueXmlString.append( "<station_type><![CDATA[" ).append( checkNull(rs.getString("STATION_TYPE")) ).append( "]]></station_type>\r\n" );//added by mrunalini sinka for route_id changes on 30-04-2019
							valueXmlString.append("<is_member_present><![CDATA[" ).append(checkNull(isMemberPresnt)).append( "]]></is_member_present>\r\n" );
							
							// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
							if(isFortuneActivity.trim().equalsIgnoreCase("Y"))
							{
								if(allowChgTime.trim().equalsIgnoreCase("Y"))
								{
									valueXmlString.append( "<event_time_start protect='0'><![CDATA[").append(checkNull(rs.getString("EVENT_TIME_START"))).append("]]></event_time_start>\r\n");
									valueXmlString.append( "<event_time_end protect='0'><![CDATA[").append( checkNull(rs.getString("EVENT_TIME_END")) ).append( "]]></event_time_end>\r\n" );								
								}
								else if(allowChgTime.trim().equalsIgnoreCase("N"))
								{
									valueXmlString.append( "<event_time_start protect = '1'><![CDATA[").append(checkNull(rs.getString("EVENT_TIME_START"))).append("]]></event_time_start>\r\n");
									valueXmlString.append( "<event_time_end protect = '1'><![CDATA[").append( checkNull(rs.getString("EVENT_TIME_END")) ).append( "]]></event_time_end>\r\n" );								
								
								}
								else if(allowChgTime.trim().equalsIgnoreCase("B"))
								{
									valueXmlString.append( "<event_time_start protect='0'><![CDATA[").append(checkNull(rs.getString("EVENT_TIME_START"))).append("]]></event_time_start>\r\n");
									valueXmlString.append( "<event_time_end protect='0'><![CDATA[").append( checkNull(rs.getString("EVENT_TIME_END")) ).append( "]]></event_time_end>\r\n" );								
								
								}
								else
								{
									valueXmlString.append( "<event_time_start protect = '1'><![CDATA[").append(checkNull(rs.getString("EVENT_TIME_START"))).append("]]></event_time_start>\r\n");
									valueXmlString.append( "<event_time_end protect = '1'><![CDATA[").append( checkNull(rs.getString("EVENT_TIME_END")) ).append( "]]></event_time_end>\r\n" );								
								
								}
								valueXmlString.append( "<allow_chg_visittime><![CDATA[").append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );								
							}
							else
							{
								valueXmlString.append( "<event_time_start visible = '0'><![CDATA[").append(checkNull(rs.getString("EVENT_TIME_START"))).append("]]></event_time_start>\r\n");
								valueXmlString.append( "<event_time_end visible = '0'><![CDATA[").append( checkNull(rs.getString("EVENT_TIME_END")) ).append( "]]></event_time_end>\r\n" );
							}
							// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
							valueXmlString.append( "<visit_time_from visible = '0'><![CDATA[").append(checkNull(rs.getString("EVENT_TIME_START"))).append( "]]></visit_time_from>\r\n" );//added by shraddha M[20/07/2020]
							valueXmlString.append( "<strg_no_visit protect='1'><![CDATA[" ).append( checkNull(rs.getString("STRG_NO_VISIT")) ).append( "]]></strg_no_visit>\r\n" );
							valueXmlString.append("<member_present><![CDATA[" ).append(checkNull(rs.getString("MEMBER_PRESENT")) ).append( "]]></member_present>\r\n" ); 


							//added by mrunalini sinkar on 12-june-2018 For set ---NA--- in case refused (start)
							if(callOutcome.equalsIgnoreCase("0"))
							{
								valueXmlString.append( "<meet_summ protect='1' visible='0'><![CDATA[" ).append("---NA---").append( "]]></meet_summ>\r\n" );
							}
							else
							{
								valueXmlString.append( "<meet_summ protect='0' visible='1'><![CDATA[" ).append( checkNull(rs.getString("MEET_SUMM")) ).append( "]]></meet_summ>\r\n" );
							}
							valueXmlString.append( "<subform_protect><![CDATA[" ).append(formNo).append( "]]></subform_protect>\r\n" );
							//added by mrunalini sinkar on 12-june-2018 For set ---NA--- in case refused (end)
							valueXmlString.append( "<short_id protect='1'><![CDATA[" ).append( checkNull(rs.getString("SHORT_ID")) ).append( "]]></short_id>\r\n" );
							valueXmlString.append( "<dcr_id protect='1'><![CDATA[" ).append( checkNull(rs.getString("DCR_ID")) ).append( "]]></dcr_id>\r\n" );
							valueXmlString.append( "<pob_val protect='1'><![CDATA[" ).append( checkNull(rs.getString("POB_VAL")) ).append( "]]></pob_val>\r\n" );
							valueXmlString.append( "<sku_value protect='1'><![CDATA[" ).append( checkNull(rs.getString("SKU_VALUE")) ).append( "]]></sku_value>\r\n" );
							valueXmlString.append( "<add_geopos protect='1'><![CDATA[" ).append( checkNull(rs.getString("ADD_GEOPOS")) ).append( "]]></add_geopos>\r\n" );
							valueXmlString.append( "<chg_geopos protect='1'><![CDATA[" ).append( checkNull(rs.getString("CHG_GEOPOS")) ).append( "]]></chg_geopos>\r\n" );
							valueXmlString.append( "<geopos_accuracy protect='1'><![CDATA[" ).append( checkNull(rs.getString("GEOPOS_ACCURACY")) ).append( "]]></geopos_accuracy>\r\n" ); //changes made by rupali on 20/07/18 for adding geopos_accuracy tag
							valueXmlString.append( "<geo_pos_name><![CDATA[" ).append( checkNull(rs.getString("GEO_POS_NAME")) ).append( "]]></geo_pos_name>\r\n" );
							valueXmlString.append( "<order_of_visit protect='1'><![CDATA[" ).append( checkNull(rs.getString("ORDER_OF_VISIT")) ).append( "]]></order_of_visit>\r\n" );
							//valueXmlString.append( "<visited_with protect = '0'><![CDATA[" ).append( teamDetail ).append( "]]></visited_with>\r\n" );
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append( "" ).append( "]]></calloutcome_descr>\r\n" );
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append(checkNull(getShDescr(cusType,connectionObject))).append( "]]></sh_descr>\r\n" );
							valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append( checkNull(rs.getString("COPY_PLAN")) ).append( "]]></copy_plan>\r\n" );
							valueXmlString.append( "<visited_with_team><![CDATA[" ).append( checkNull(rs.getString("SPRS_CODE__WW")) ).append( "]]></visited_with_team>\r\n" );
							// added by rupali on 03/05/18 for single screen mgr reporting [start]
							if(mgrCode.trim().length()!= 0)
							{
								valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append( checkNull(rs.getString("SPRS_CODE__WW")) ).append( "]]></sprs_code__ww>\r\n" );
								valueXmlString.append( "<visited_with protect = '1'><![CDATA[" ).append( visitedwithTeam ).append( "]]></visited_with>\r\n" );
							}
							else
							{
								valueXmlString.append( "<visited_with protect = '1'><![CDATA[" ).append( "" ).append( "]]></visited_with>\r\n" );
							}
							// added by rupali on 03/05/18 for single screen mgr reporting [end]

							if(cnt > 0)
							{
								//Added by mrunalini sinkar for member present changes(start)
								valueXmlString.append( "<strg_code protect = '1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")) ).append( "]]></strg_code>\r\n" );
								valueXmlString.append( "<call_outcome protect = '1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("CALL_OUTCOME")) ).append( "]]></call_outcome>\r\n" );
								valueXmlString.append( "<oth_participant visible='1'><![CDATA[" ).append( checkNull(rs.getString("OTH_PARTICIPANT")) ).append( "]]></oth_participant>\r\n" );
								valueXmlString.append( "<remarks visible='1'><![CDATA[" ).append( checkNull(rs.getString("REMARKS")) ).append( "]]></remarks>\r\n" );
								valueXmlString.append( "<cust_type protect = '1'><![CDATA[" ).append( "LISTED" ).append( "]]></cust_type>\r\n" );
								valueXmlString.append( "<strg_name protect = '1'><![CDATA[" ).append( checkNull(rs.getString("STRG_NAME")) ).append( "]]></strg_name>\r\n" );
								valueXmlString.append( "<email_addr protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
								valueXmlString.append( "<mobile_no protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
								valueXmlString.append( "<address_as protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );
								valueXmlString.append( "<gender protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("GENDER")) ).append( "]]></gender>\r\n" );
								valueXmlString.append( "<spl_code protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
								valueXmlString.append( "<addr1 protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR1")) ).append( "]]></addr1>\r\n" );
								valueXmlString.append( "<addr2 protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR2")) ).append( "]]></addr2>\r\n" );
								valueXmlString.append( "<addr3 protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR3")) ).append( "]]></addr3>\r\n" );
								valueXmlString.append( "<strg_class_code protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("STRG_CLASS_CODE")) ).append( "]]></strg_class_code>\r\n" );
								valueXmlString.append("<next_plan_date visible='1'><![CDATA[" ).append(checkNull(showDate)).append( "]]></next_plan_date>\r\n" );
							}
							else
							{
								if(!isMemberPresnt.equalsIgnoreCase("Y"))//Added by mrunalini sinkar for member present changes
								{
									//Added by mrunalini sinkar for member present changes(start)
									valueXmlString.append( "<strg_code protect = '1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")) ).append( "]]></strg_code>\r\n" );
									valueXmlString.append( "<call_outcome protect = '1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("CALL_OUTCOME")) ).append( "]]></call_outcome>\r\n" );
									valueXmlString.append( "<oth_participant visible='1'><![CDATA[" ).append( checkNull(rs.getString("OTH_PARTICIPANT")) ).append( "]]></oth_participant>\r\n" );
									valueXmlString.append( "<remarks visible='1'><![CDATA[" ).append( checkNull(rs.getString("REMARKS")) ).append( "]]></remarks>\r\n" );
									valueXmlString.append( "<stockist_code visible='1'><![CDATA[" ).append( stockistCode ).append( "]]></stockist_code>\r\n" );
									//Added by mrunalini sinkar for member present changes(end)
									valueXmlString.append( "<strg_name protect = '0'><![CDATA[" ).append( checkNull(rs.getString("STRG_NAME")) ).append( "]]></strg_name>\r\n" );
									valueXmlString.append( "<email_addr protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
									valueXmlString.append( "<mobile_no protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
									valueXmlString.append( "<address_as protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );
									valueXmlString.append( "<gender protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("GENDER")) ).append( "]]></gender>\r\n" );
									valueXmlString.append( "<addr1 protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR1")) ).append( "]]></addr1>\r\n" );
									valueXmlString.append( "<addr2 protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR2")) ).append( "]]></addr2>\r\n" );
									valueXmlString.append( "<addr3 protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR3")) ).append( "]]></addr3>\r\n" );
									valueXmlString.append( "<strg_class_code protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("STRG_CLASS_CODE")) ).append( "]]></strg_class_code>\r\n" );
									valueXmlString.append( "<class_code_descr protect = '1' visible = '1'><![CDATA[" ).append( "" ).append( "]]></class_code_descr>\r\n" );
									//added & commented by mrunalini sinkar on 30-01-2019(start) 
									valueXmlString.append( "<cust_type protect = '1'><![CDATA[" ).append(checkNull(getCustTypeDesc(cusType, connectionObject))).append( "]]></cust_type>\r\n" );
									if("D".equalsIgnoreCase(cusType))
									{
										valueXmlString.append( "<spl_code protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
										valueXmlString.append( "<speciality_descr protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPECIALITY_DESCR")) ).append( "]]></speciality_descr>\r\n" );

									}
									else
									{
										valueXmlString.append( "<spl_code protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
										valueXmlString.append( "<speciality_descr protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPECIALITY_DESCR")) ).append( "]]></speciality_descr>\r\n" );

									}
									valueXmlString.append("<next_plan_date visible='1'><![CDATA[" ).append(checkNull(showDate)).append( "]]></next_plan_date>\r\n" );

								}
								else//Added by mrunalini sinkar for member present changes
								{
									
									String strgName=checkNull(rs.getString("STRG_NAME"));
									valueXmlString.append("<strg_code protect = '1' visible='0'><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")) ).append( "]]></strg_code>\r\n" );
									valueXmlString.append("<call_outcome protect = '1' visible='0'><![CDATA[" ).append( checkNull(rs.getString("CALL_OUTCOME")) ).append( "]]></call_outcome>\r\n" );
									valueXmlString.append("<oth_participant visible='0'><![CDATA[" ).append( checkNull(rs.getString("OTH_PARTICIPANT")) ).append( "]]></oth_participant>\r\n" );
									valueXmlString.append("<remarks visible='0'><![CDATA[" ).append( checkNull(rs.getString("REMARKS")) ).append( "]]></remarks>\r\n" );
									valueXmlString.append( "<stockist_code visible='0'><![CDATA[" ).append( stockistCode ).append( "]]></stockist_code>\r\n" );

									if(strgName!=null && strgName.trim().length() >0)
									{
										valueXmlString.append( "<strg_name protect = '0' visible='0'><![CDATA[" ).append( checkNull(rs.getString("STRG_NAME")) ).append( "]]></strg_name>\r\n" );
									}
									else
									{
										valueXmlString.append( "<strg_name protect = '0' visible='0'><![CDATA[" ).append(checkNull(getShDescr(cusType,connectionObject))).append( "]]></strg_name>\r\n" );

									}
									valueXmlString.append( "<email_addr protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
									valueXmlString.append( "<mobile_no protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
									valueXmlString.append( "<address_as protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );
									valueXmlString.append( "<gender protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("GENDER")) ).append( "]]></gender>\r\n" );
									valueXmlString.append( "<addr1 protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR1")) ).append( "]]></addr1>\r\n" );
									valueXmlString.append( "<addr2 protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR2")) ).append( "]]></addr2>\r\n" );
									valueXmlString.append( "<addr3 protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR3")) ).append( "]]></addr3>\r\n" );
									valueXmlString.append( "<strg_class_code protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("STRG_CLASS_CODE")) ).append( "]]></strg_class_code>\r\n" );
									valueXmlString.append( "<class_code_descr protect = '1' visible = '0'><![CDATA[" ).append( "" ).append( "]]></class_code_descr>\r\n" );
									//added & commented by mrunalini sinkar on 30-01-2019(start) 
									valueXmlString.append( "<cust_type protect = '1' visible='0'><![CDATA[" ).append(checkNull(getCustTypeDesc(cusType, connectionObject))).append( "]]></cust_type>\r\n" );
									if("D".equalsIgnoreCase(cusType))
									{
										valueXmlString.append( "<spl_code protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
										valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SPECIALITY_DESCR")) ).append( "]]></speciality_descr>\r\n" );

									}
									else
									{
										valueXmlString.append( "<spl_code protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
										valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SPECIALITY_DESCR")) ).append( "]]></speciality_descr>\r\n" );

									}
									valueXmlString.append("<next_plan_date visible='0'><![CDATA[" ).append(checkNull(showDate)).append( "]]></next_plan_date>\r\n" );

								}


							}
							//System.out.println("itemdefaultEdit called....");
							valueXmlString.append( "<order_form_no><![CDATA[" ).append( sampleOrder ).append( "]]></order_form_no>\r\n" );
							valueXmlString.append( "<team_form_no><![CDATA[" ).append( doctorTeam ).append( "]]></team_form_no>\r\n" );
							valueXmlString.append(" <host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
							valueXmlString.append( "<display_time_fld><![CDATA[" ).append( displayTimeField ).append( "]]></display_time_fld>\r\n" );//addednby shraddha M[20/07/2020]

							valueXmlString.append( "</Detail1>\r\n" );

							HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
							strgCode = "'"+strgCode+"'";

							if(subFormsMap.containsKey("team"))
							{
								String teamFormNo = subFormsMap.get("team");
								if ( preDomExists( dom2, teamFormNo ) )
								{
									String prevFormValues =  getPrevFormVal( dom2, teamFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
									//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
									valueXmlString.append( prevFormValues );
								}
								else if( !"".equalsIgnoreCase( strgCode ) )
								{
									String existingTeam = getSalesExistingTeamDetail( userId, currDate , strgCode,teamFormNo,"team",connectionObject ) ;
									//System.out.println( "DefaultDataDAR :: existiteam [ " + existingTeam + "]" );
									if( existingTeam !=null && existingTeam.length() > 0 )
									{
										valueXmlString.append( existingTeam);
									}
								}
							}

							if(subFormsMap.containsKey("survey"))
							{
								String surveyFormNo = subFormsMap.get("survey");
								if ( preDomExists( dom2, surveyFormNo ) )
								{
									String prevFormValues =  getPrevFormVal( dom2, surveyFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
									//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
									valueXmlString.append( prevFormValues );
								}
								else if( !"".equalsIgnoreCase( strgCode ) )
								{
									String existingSurvey = getExistingSurveyDetail( userId, currDate, strgCode, surveyFormNo,"survey", connectionObject );
									//System.out.println( "DefaultDataDAR :: existingSurvey [ " + existingSurvey + "]" );
									if( existingSurvey !=null && existingSurvey.length() > 0 )
									{
										valueXmlString.append( existingSurvey);
									}
								}
							}

						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					else
					{
						

						

						// added by rupali on 04/12/18 to set nearest manager in visited with field [end]
						// added by mrunalini sinkar for default activity for CHC client on 07-02-2019[start]
						String defACt = checkNull(getSfaParmValue(userId, "DEF_ACT_REALCODE", connectionObject));
						String actDescr="",actType="",placReq="";
						//Added by Bhagyashri T for Activity place[W21DSUN098][26/JUL/21]
						String actPlace="";
						//String defACtsql = "SELECT DESCR AS ACTIVITY_DESCR,ACTIVITY_TYPE,PLACE_REQUIRED FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
						String defACtsql = "SELECT DESCR AS ACTIVITY_DESCR,ACTIVITY_TYPE,PLACE_REQUIRED,ACTIVITY_PLACE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";//Added by Bhagyashri T for Activity place[W21DSUN098][26/JUL/21]
						pstmt = connectionObject.prepareStatement(defACtsql);
						pstmt.setString(1, defACt);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							actDescr = checkNull(rs.getString("ACTIVITY_DESCR"));
							actType = checkNull(rs.getString("ACTIVITY_TYPE"));
							placReq = checkNull(rs.getString("PLACE_REQUIRED"));
							actPlace = checkNull(rs.getString("ACTIVITY_PLACE"));//Added by Bhagyashri T for Activity place[W21DSUN098][26/JUL/21]
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						// added by mrunalini sinkar for default activity for CHC client on 07-02-2019[end]
						//added by mrunalini sinkar for protect event date & set current date for CHC client on 07-01-2018[start]
						int allwdPrd=0;
						String allDelaySql = "SELECT ALLWD_DELAY_PRD FROM SALES_PERS WHERE SALES_PERS=?";
						pstmt =  connectionObject.prepareStatement(allDelaySql);
						pstmt.setString(1, checkNull(userId));
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							allwdPrd = rs.getInt("ALLWD_DELAY_PRD");
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						//added by mrunalini sinkar for protect event date & set current date for CHC client on 07-01-2018[end]
						// added by rupali on 26/07/18 to open realtime report from series master [start]
						if(strgCode == null || strgCode.trim().length() == 0)
						{
							//System.out.println("inside if["+strgCode+"]");
							valueXmlString.append( "<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
							valueXmlString.append( "<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n");
							valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
							//added by mrunalini sinkar for protect event date & set current date for CHC client on 07-01-2018[start]
							if(allwdPrd > 0)
							{
								valueXmlString.append( "<event_date protect = '0' ><![CDATA[" ).append( currentDate ).append( "]]></event_date>\r\n" );
							}
							else
							{
								valueXmlString.append( "<event_date protect = '1' ><![CDATA[" ).append( currentDate ).append( "]]></event_date>\r\n" );
							}
							//valueXmlString.append( "<event_date><![CDATA[" ).append( currDate ).append( "]]></event_date>\r\n" );
							//added by mrunalini sinkar for protect event date & set current date for CHC client on 07-01-2018[end]
							//added & commented by mrunalini sinkar for default activity (start)
							/*valueXmlString.append( "<event_type protect = '0'><![CDATA[" ).append("FW").append( "]]></event_type>\r\n" );
							valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append("WHOLE DAY FIELD WORK").append( "]]></activity_descr>\r\n" );
							valueXmlString.append( "<activity_type><![CDATA[" ).append("FW").append( "]]></activity_type>\r\n" );
							valueXmlString.append( "<place_required><![CDATA[" ).append("Y").append( "]]></place_required>\r\n" ); // added by mrunalini sinkar for place required changes()*/
							valueXmlString.append( "<event_type protect = '0'><![CDATA[" ).append(defACt).append( "]]></event_type>\r\n" );
							valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append(actDescr).append( "]]></activity_descr>\r\n" );
							valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
							valueXmlString.append( "<place_required><![CDATA[" ).append(placReq).append( "]]></place_required>\r\n" );
							valueXmlString.append( "<activity_place><![CDATA[" ).append(actPlace).append( "]]></activity_place>\r\n" );//Added by Bhagyashri T for Activity place[W21DSUN098][26/JUL/21]
							//added & commented by mrunalini sinkar for default activity (end)
							//	valueXmlString.append( "<cust_type><![CDATA[" ).append("").append( "]]></cust_type>\r\n" ); // commented by rupali on 19/09/17 for showing default value in cust_type
							valueXmlString.append( "<cust_type><![CDATA[" ).append("LISTED").append( "]]></cust_type>\r\n" ); // added by rupali on 19/09/17 for showing default value in cust_type
							valueXmlString.append( "<chg_date protect = '1'><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
							valueXmlString.append( "<chg_user protect = '1'><![CDATA[" ).append(empcode).append( "]]></chg_user>\r\n" );
							valueXmlString.append( "<chg_term protect = '1'><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
							valueXmlString.append( "<sales_pers protect = '1'><![CDATA[" ).append(userId).append( "]]></sales_pers>\r\n" );
							valueXmlString.append( "<sales_pers_sp_name protect = '1'><![CDATA[" ).append(spName).append( "]]></sales_pers_sp_name>\r\n" );
							valueXmlString.append( "<stan_code__hq><![CDATA[" ).append(stanCodeHQ).append( "]]></stan_code__hq>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
							valueXmlString.append( "<headquarter><![CDATA[" ).append(headQaurter).append( "]]></headquarter>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
							valueXmlString.append( "<oth_participant><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );//Added by sagar m.on 17.1.19[for work with other set current value].
							valueXmlString.append( "<sku_value><![CDATA[" ).append("0").append( "]]></sku_value>\r\n" );

							valueXmlString.append( "<strg_name protect = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
							valueXmlString.append( "<address protect = '1'><![CDATA[" ).append("").append( "]]></address>\r\n" );
							valueXmlString.append( "<email_addr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
							valueXmlString.append( "<mobile_no protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
							// commented by rupali on 23/05/18 for getting locality code of customer [start]
							/*valueXmlString.append( "<locality_code protect = '0'><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
							valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );*/
							// commented by rupali on 23/05/18 for getting locality code of customer [end]
							//commented by vishal pathare on 25.10.17 for[initial value should apply (Default Call outcome should be believer)].
							//valueXmlString.append( "<call_outcome protect = '0'><![CDATA[" ).append("5").append( "]]></call_outcome>\r\n" );
							//valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
							valueXmlString.append( "<address_as protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
							valueXmlString.append( "<gender protect = '1' visible = '0'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
							valueXmlString.append( "<spl_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></spl_code>\r\n" );
							valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></speciality_descr>\r\n" );
							valueXmlString.append( "<wf_status><![CDATA[" ).append("P").append( "]]></wf_status>\r\n" );
							valueXmlString.append( "<confirmed><![CDATA[" ).append("N").append( "]]></confirmed>\r\n" );
							// added by rupali on 27/10/17 for displaying preffered stockist field [start]
							valueXmlString.append( "<stockist_name protect = '1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
							valueXmlString.append( "<stockist_code><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
							// added by rupali on 27/10/17 for displaying preffered stockist field [end]
							// added by rupali on 01/12/17 for hiding unnecessary fields [start]
							valueXmlString.append( "<addr1 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
							valueXmlString.append( "<addr2 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
							valueXmlString.append( "<addr3 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
							valueXmlString.append( "<strg_class_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
							valueXmlString.append( "<class_code_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
							// added by rupali on 01/12/17 for hiding unnecessary fields [end]
							// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [start]
							/*valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
							valueXmlString.append("<event_time_end><![CDATA[").append(startTime).append( "]]></event_time_end>\r\n" );*/
							// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [end]
							valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
							valueXmlString.append("<visited_with_team protect = '0'><![CDATA[" ).append(checkNull(empcode)).append( "]]></visited_with_team>\r\n" ); // added by rupali on 03/05/18 for single screen mgr reporting
							valueXmlString.append("<is_member_present><![CDATA[" ).append(checkNull(isMemberPresnt)).append( "]]></is_member_present>\r\n" ); 

							// added by rupali on 23/05/18 for getting locality code of customer [start]
							String locCode = genericUtility.getColumnValue("locality_code", dom2, doctorFormNo);
							String locDescr = "";
							if(locCode == null || locCode.trim().length() == 0)
							{
								strgCode = genericUtility.getColumnValue("strg_code", dom2, doctorFormNo);
								sql = "SELECT LC.LOCALITY_CODE AS LOCALITY_CODE,LC.DESCR AS DESCR FROM LOCALITY LC, STRG_CUSTOMER SC WHERE LC.LOCALITY_CODE = SC.LOCALITY_CODE AND SC.SC_CODE = ?";
								pstmt =  connectionObject.prepareStatement(sql);
								pstmt.setString(1, strgCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									locCode = rs.getString("LOCALITY_CODE");
									locDescr = rs.getString("DESCR");
									//System.out.println("localoty code =["+locCode+"] locality descr =["+locDescr+"]");
								}
								if (rs!= null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}

								valueXmlString.append( "<locality_code protect = '0'><![CDATA[" ).append( locCode ).append( "]]></locality_code>\r\n" );
								valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append( locDescr ).append( "]]></locality_descr>\r\n" );
							}
							// added by rupali on 23/05/18 for getting locality code of customer [end]
							valueXmlString.append( "<visited_with><![CDATA[" ).append("").append( "]]></visited_with>\r\n" ); // added by rupali on 04/12/18 to set nearest manager in visited with field
							
							// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
							if(isFortuneActivity.trim().equalsIgnoreCase("Y")) 
							{
								if(allowChgTime.trim().equalsIgnoreCase("Y"))
								{
								valueXmlString.append("<event_time_start protect='0'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='0'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								}
								else if(allowChgTime.trim().equalsIgnoreCase("N"))
								{
									valueXmlString.append("<event_time_start protect = '1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
									valueXmlString.append("<event_time_end protect = '1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
									
								}								
								else
								{
									valueXmlString.append("<event_time_start protect = '1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
									valueXmlString.append("<event_time_end protect = '1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
									
								}
								valueXmlString.append( "<allow_chg_visittime><![CDATA[").append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );								

							}
							else
							{
							valueXmlString.append("<event_time_start visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
							valueXmlString.append("<event_time_end visible = '0'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
							}
							// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
							valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							valueXmlString.append( "<allwd_delay_prd><![CDATA[" ).append( allwdPrd ).append( "]]></allwd_delay_prd>\r\n" );
							valueXmlString.append( "<order_form_no><![CDATA[" ).append( sampleOrder ).append( "]]></order_form_no>\r\n" );
							valueXmlString.append( "<team_form_no><![CDATA[" ).append( doctorTeam ).append( "]]></team_form_no>\r\n" );
							valueXmlString.append(" <host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
							//Added by Pooja on 18/12/19 [Coaching related detail form implementation] START
							valueXmlString.append( "<emp_design><![CDATA[" ).append( empDesign ).append( "]]></emp_design>\r\n" );
							valueXmlString.append( "<grade_code><![CDATA[" ).append( "" ).append( "]]></grade_code>\r\n" );
							valueXmlString.append( "<display_time_fld><![CDATA[" ).append( displayTimeField ).append( "]]></display_time_fld>\r\n" );//addednby shraddha M[20/07/2020]
							//Added by Pooja on 18/12/19 [Coaching related detail form implementation] END
							valueXmlString.append( "</Detail1>\r\n" );
							//System.out.println("itemdefault called....");
						}
						else
						{
							//System.out.println("inside else in realtime["+strgCode+"]");
							String salesPersCode = userId;
							String travelDate = currDate;
							String eventType = defACt;
							strgType = checkNull(genericUtility.getColumnValue("cust_type", dom2));
							String localityCode = genericUtility.getColumnValue("locality_code", dom2, doctorFormNo);

							valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
							valueXmlString.append( "<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n");
							valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
							//added by mrunalini sinkar for protect event date & set current date for CHC client on 07-01-2018[start]
							if(allwdPrd > 0)
							{
								valueXmlString.append( "<event_date protect = '0' ><![CDATA[" ).append( currentDate ).append( "]]></event_date>\r\n" );
							}
							else
							{
								valueXmlString.append( "<event_date protect = '1' ><![CDATA[" ).append( currentDate ).append( "]]></event_date>\r\n" );
							}

							//valueXmlString.append( "<event_date><![CDATA[" ).append( currDate ).append( "]]></event_date>\r\n" );
							//added by mrunalini sinkar for protect event date & set current date for CHC client on 07-01-2018[end]
							//added & commented by mrunalini sinkar for default activity (start)
							/*valueXmlString.append( "<event_type protect = '0'><![CDATA[" ).append("FW").append( "]]></event_type>\r\n" );
							valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append("WHOLE DAY FIELD WORK").append( "]]></activity_descr>\r\n" );
							valueXmlString.append( "<activity_type><![CDATA[" ).append("FW").append( "]]></activity_type>\r\n" );
							valueXmlString.append( "<place_required><![CDATA[" ).append("Y").append( "]]></place_required>\r\n" ); // added by mrunalini sinkar for place required changes()*/
							valueXmlString.append( "<event_type protect = '0'><![CDATA[" ).append(defACt).append( "]]></event_type>\r\n" );
							valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append(actDescr).append( "]]></activity_descr>\r\n" );
							valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
							valueXmlString.append( "<place_required><![CDATA[" ).append(placReq).append( "]]></place_required>\r\n" );
							valueXmlString.append( "<activity_place><![CDATA[" ).append(actPlace).append( "]]></activity_place>\r\n" );//Added by Bhagyashri T for Activity place[W21DSUN098][26/JUL/21]
							//added & commented by mrunalini sinkar for default activity (end)
							valueXmlString.append( "<sku_value><![CDATA[" ).append("0").append( "]]></sku_value>\r\n" );

							valueXmlString.append( "<chg_date protect = '1'><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
							valueXmlString.append( "<chg_user protect = '1'><![CDATA[" ).append(empcode).append( "]]></chg_user>\r\n" );
							valueXmlString.append( "<chg_term protect = '1'><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
							valueXmlString.append( "<sales_pers protect = '1'><![CDATA[" ).append(userId).append( "]]></sales_pers>\r\n" );
							valueXmlString.append( "<stan_code__hq><![CDATA[" ).append(stanCodeHQ).append( "]]></stan_code__hq>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
							valueXmlString.append( "<headquarter><![CDATA[" ).append(headQaurter).append( "]]></headquarter>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
							valueXmlString.append( "<sales_pers_sp_name protect = '1'><![CDATA[" ).append(spName).append( "]]></sales_pers_sp_name>\r\n" );
							
							// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
							if(isFortuneActivity.trim().equalsIgnoreCase("Y")) 
							{
								if(allowChgTime.trim().equalsIgnoreCase("Y"))
								{
								valueXmlString.append("<event_time_start protect='0'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='0'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								
								}
								else if(allowChgTime.trim().equalsIgnoreCase("N"))
								{
									valueXmlString.append("<event_time_start protect = '1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
									valueXmlString.append("<event_time_end protect = '1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );									
								}								
								else
								{
									valueXmlString.append("<event_time_start protect = '1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
									valueXmlString.append("<event_time_end protect = '1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
									
								}
								valueXmlString.append( "<allow_chg_visittime><![CDATA[").append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );								

							}
							else
							{
							valueXmlString.append("<event_time_start visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
							valueXmlString.append("<event_time_end visible = '0'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
							}
							// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
							
							valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append( "]]></visit_time_from>\r\n" );//added by shraddha M[20/07/2020]
							valueXmlString.append("<is_member_present><![CDATA[" ).append(checkNull(isMemberPresnt)).append( "]]></is_member_present>\r\n" ); 
							int planCount=0;
							String isPlanCumpulsory  = getSfaParmValue(userId,"IS_PLAN_COMPULSORY",connectionObject);
							if(travelDate != null && travelDate.trim().length() > 0)
							{
								if("Y".equalsIgnoreCase(isPlanCumpulsory))
								{
									String planSql="select count(*) AS COUNT from SPRS_PLAN_HDR sph,SPRS_PLAN_cust planCust where sph.plan_date=? and sph.SPRS_CODE__PLAN=? and planCust.sc_code=? and planCust.locality_code=? and sph.plan_id=planCust.plan_id and sph.confirm='Y'";
									PreparedStatement planPstmt =  connectionObject.prepareStatement(planSql);
									planPstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( travelDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
									planPstmt.setString(2, checkNull(salesPersCode));
									planPstmt.setString(3, checkNull(strgCode));
									planPstmt.setString(4, checkNull(localityCode));

									ResultSet planRs = planPstmt.executeQuery();
									if(planRs.next())
									{
										planCount = planRs.getInt("COUNT");
									}
									if(planRs != null)
									{
										planRs.close();
										planRs = null;
									}
									if(planPstmt != null)
									{
										planPstmt.close();
										planPstmt = null;
									}
								}
							}
							//sql = "SELECT SC.FIRST_NAME || ' ' ||  SC.LAST_NAME AS STRG_NAME, SC.CUST_TYPE, SC.LOCALITY_CODE, SC.ADDRESS_AS, SC.SEX, SC.ADDR1, SC.ADDR2, SC.ADDR3, SS.CLASS_CODE, SS.SPL_CODE, S.DESCR AS SPPECIALITY, SC.EMAIL_ADDR,SC.MOBILE_NO, LC.DESCR FROM STRG_CUSTOMER SC LEFT OUTER JOIN  STRG_SERIES SS ON SC.SC_CODE = SS.SC_CODE LEFT OUTER JOIN SPECIALITY S ON SS.SPL_CODE = S.SPL_CODE, LOCALITY LC WHERE SC.LOCALITY_CODE = LC.LOCALITY_CODE AND SC.SC_CODE= ? ";
							String sfaParmVal  = checkNull(getSfaParmValue(salesPers,"CHC_SURVEY",connectionObject));

							sql = "SELECT SC.FIRST_NAME || ' ' ||  SC.LAST_NAME AS STRG_NAME, SC.CUST_TYPE, SC.LOCALITY_CODE, SC.ADDRESS_AS,(CASE WHEN SCT.SURVEY_TEMPL IS NULL THEN '"+sfaParmVal+"' ELSE SCT.SURVEY_TEMPL END) AS SURVEY_TEMPL, "
									+ "SC.SEX, SC.ADDR1, SC.ADDR2, SC.ADDR3, SS.CLASS_CODE, SS.SPL_CODE, S.DESCR AS SPPECIALITY, SC.EMAIL_ADDR,SC.MOBILE_NO, "
									+ "SS.ROUTE_ID, (CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END) AS DESCR,SS.NO_VISIT "
									+ "FROM STRG_CUSTOMER SC LEFT OUTER JOIN  STRG_SERIES SS ON SC.SC_CODE = SS.SC_CODE "
									+ "LEFT OUTER JOIN SPRS_ROUTE SR ON SS.ROUTE_ID = SR.ROUTE_ID AND SR.SPRS_CODE = SS.SALES_PERS "
									+ "LEFT OUTER JOIN SPECIALITY S ON SS.SPL_CODE = S.SPL_CODE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON SC.CUST_TYPE=SCT.TYPE, LOCALITY LC WHERE SR.LOCALITY_CODE = LC.LOCALITY_CODE AND SC.SC_CODE= ? AND SPRS_CODE = ?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1,strgCode);
							pstmt.setString(2,userId);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								String customerType = checkNull(rs.getString("CUST_TYPE"));
								//System.out.println("CUST_TYPE IS :"+customerType);
								int visit=0;
								visit = orderOfVisit(travelDate,salesPersCode,localityCode ,connectionObject);
								valueXmlString.append("<strg_name protect = '1'><![CDATA[" ).append(checkNull(rs.getString("STRG_NAME"))).append( "]]></strg_name>\r\n" );
								valueXmlString.append("<strg_code protect = '0'><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
								valueXmlString.append("<cust_type protect = '0'><![CDATA[" ).append("LISTED").append( "]]></cust_type>\r\n" );
								valueXmlString.append("<strg_type protect = '1'><![CDATA[" ).append( checkNull(rs.getString("CUST_TYPE"))).append( "]]></strg_type>\r\n" );
								valueXmlString.append("<locality_code protect='0'><![CDATA[" ).append( checkNull(rs.getString("LOCALITY_CODE")) ).append( "]]></locality_code>\r\n" );
								valueXmlString.append("<locality_descr><![CDATA[" ).append( checkNull(rs.getString("DESCR")) ).append( "]]></locality_descr>\r\n" );
								valueXmlString.append("<address_as protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );
								valueXmlString.append("<gender protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SEX")) ).append( "]]></gender>\r\n" );
								valueXmlString.append("<addr1 protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR1")) ).append( "]]></addr1>\r\n" );
								valueXmlString.append("<addr2 protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR2")) ).append( "]]></addr2>\r\n" );
								valueXmlString.append("<addr3 protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR3")) ).append( "]]></addr3>\r\n" );
								valueXmlString.append("<email_addr protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
								valueXmlString.append("<mobile_no protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
								valueXmlString.append("<order_of_visit><![CDATA[" ).append(visit).append( "]]></order_of_visit>\r\n" );
								valueXmlString.append("<strg_no_visit><![CDATA[" ).append(checkNull(rs.getString("NO_VISIT"))).append( "]]></strg_no_visit>\r\n" );
								valueXmlString.append("<survey_templ><![CDATA[").append(checkNull(rs.getString("SURVEY_TEMPL"))).append("]]></survey_templ>\r\n");

								valueXmlString.append("<strg_class_code protect = '1' visible = '0'><![CDATA[" ).append(rs.getString("CLASS_CODE")).append( "]]></strg_class_code>\r\n" );
								/*valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );*/
								if("D".equalsIgnoreCase(customerType) )
								{
									valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("DOCTOR").append( "]]></sh_descr>\r\n" );
								}
								else if("C".equalsIgnoreCase(customerType) || "R".equalsIgnoreCase(customerType) )
								{
									valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("CHEMIST").append( "]]></sh_descr>\r\n" );
								}
								else if("S".equalsIgnoreCase(customerType) )
								{
									valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("STOCKIST").append( "]]></sh_descr>\r\n" );
								}
								else
								{
									valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("LISTED").append( "]]></sh_descr>\r\n" );
								}
								/*if(customerType.equals("D"))
								{
									valueXmlString.append("<spl_code protect = '1' visible = '0'><![CDATA[" ).append(rs.getString("SPL_CODE")).append( "]]></spl_code>\r\n" );
									valueXmlString.append("<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append(rs.getString("SPPECIALITY")).append( "]]></speciality_descr>\r\n" );
								}
								else
								{
									valueXmlString.append("<spl_code protect = '1' visible = '0'><![CDATA[" ).append("OTH").append( "]]></spl_code>\r\n" );
									valueXmlString.append("<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append("OTHER").append( "]]></speciality_descr>\r\n" );

								}*/
								valueXmlString.append("<spl_code protect = '1' visible = '0'><![CDATA[" ).append(rs.getString("SPL_CODE")).append( "]]></spl_code>\r\n" );
								valueXmlString.append("<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append(rs.getString("SPPECIALITY")).append( "]]></speciality_descr>\r\n" );
								valueXmlString.append("<route_id><![CDATA[" ).append(rs.getString("ROUTE_ID")).append( "]]></route_id>\r\n" );
								
								}
							else
							{
								valueXmlString.append("<strg_name protect = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
								valueXmlString.append("<strg_code protect = '0'><![CDATA[" ).append("").append( "]]></strg_code>\r\n" );
								valueXmlString.append("<strg_type protect = '1'><![CDATA[" ).append("").append( "]]></strg_type>\r\n" );
								valueXmlString.append("<cust_type protect = '0'><![CDATA[" ).append("").append( "]]></cust_type>\r\n" );
								valueXmlString.append("<locality_code><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
								valueXmlString.append("<locality_descr><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
								valueXmlString.append("<address_as protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
								valueXmlString.append("<gender protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></gender>\r\n" );
								valueXmlString.append("<addr1 protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
								valueXmlString.append("<addr2 protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
								valueXmlString.append("<addr3 protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
								valueXmlString.append("<email_addr protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
								valueXmlString.append("<mobile_no protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
								valueXmlString.append("<strg_class_code protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
								valueXmlString.append("<spl_code protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></spl_code>\r\n" );
								valueXmlString.append("<speciality_descr protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></speciality_descr>\r\n" );
								/*valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );*/
							}
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							if (pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							/*if( eventType != null && eventType.trim().length() != 0 )
							{
								valueXmlString.append( "<event_type protect = '1'><![CDATA[" ).append(checkNull(eventType)).append( "]]></event_type>\r\n" );
							}
							else
							{
								valueXmlString.append( "<event_type protect = '1'><![CDATA[" ).append(defACt).append( "]]></event_type>\r\n" );
								valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append(actDescr).append( "]]></activity_descr>\r\n" );
								valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
							}*/
							if("Y".equalsIgnoreCase(isPlanCumpulsory) && planCount>0)
							{
								valueXmlString.append( "<copy_plan protect='0'><![CDATA[" ).append("Y").append( "]]></copy_plan>\r\n" );
							}
							else
							{
								valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
							}
							valueXmlString.append("<visited_with_team protect = '0'><![CDATA[" ).append(checkNull(empcode)).append( "]]></visited_with_team>\r\n" );
							valueXmlString.append( "<visited_with><![CDATA[" ).append("").append( "]]></visited_with>\r\n" ); // added by rupali on 04/12/18 to set nearest manager in visited with field
							valueXmlString.append( "<allwd_delay_prd><![CDATA[" ).append( allwdPrd ).append( "]]></allwd_delay_prd>\r\n" );
							valueXmlString.append( "<order_form_no><![CDATA[" ).append( sampleOrder ).append( "]]></order_form_no>\r\n" );
							valueXmlString.append( "<team_form_no><![CDATA[" ).append( doctorTeam ).append( "]]></team_form_no>\r\n" );
							valueXmlString.append(" <host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
							//Added by Pooja on 18/12/19 [Coaching related detail form implementation] START
							valueXmlString.append( "<emp_design><![CDATA[" ).append( empDesign ).append( "]]></emp_design>\r\n" );
							valueXmlString.append( "<grade_code><![CDATA[" ).append( "" ).append( "]]></grade_code>\r\n" );
							valueXmlString.append( "<display_time_fld><![CDATA[" ).append( displayTimeField ).append( "]]></display_time_fld>\r\n" );//addednby shraddha M[20/07/2020]

							//Added by Pooja on 18/12/19 [Coaching related detail form implementation] END
							valueXmlString.append( "</Detail"+objContext+">\r\n" );

						}
						// added by rupali on 26/07/18 to open realtime report from series master [end]
						//commented by rupali on 26/07/18 to open realtime report from series master [start]
						/*valueXmlString.append( "<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
						valueXmlString.append( "<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n");
						valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
						valueXmlString.append( "<event_date><![CDATA[" ).append( currDate ).append( "]]></event_date>\r\n" );
						valueXmlString.append( "<event_type protect = '0'><![CDATA[" ).append("FW").append( "]]></event_type>\r\n" );
						valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append("WHOLE DAY FIELD WORK").append( "]]></activity_descr>\r\n" );
						valueXmlString.append( "<activity_type><![CDATA[" ).append("FW").append( "]]></activity_type>\r\n" );
						//	valueXmlString.append( "<cust_type><![CDATA[" ).append("").append( "]]></cust_type>\r\n" ); // commented by rupali on 19/09/17 for showing default value in cust_type
						valueXmlString.append( "<cust_type><![CDATA[" ).append("LISTED").append( "]]></cust_type>\r\n" ); // added by rupali on 19/09/17 for showing default value in cust_type
						valueXmlString.append( "<chg_date protect = '1'><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_user protect = '1'><![CDATA[" ).append(empcode).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_term protect = '1'><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
						valueXmlString.append( "<sales_pers protect = '1'><![CDATA[" ).append(userId).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<sales_pers_sp_name protect = '1'><![CDATA[" ).append(spName).append( "]]></sales_pers_sp_name>\r\n" );

						valueXmlString.append( "<strg_name protect = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
						valueXmlString.append( "<address protect = '1'><![CDATA[" ).append("").append( "]]></address>\r\n" );
						valueXmlString.append( "<email_addr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						valueXmlString.append( "<mobile_no protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
						// commented by rupali on 23/05/18 for getting locality code of customer [start]
						valueXmlString.append( "<locality_code protect = '0'><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
						// commented by rupali on 23/05/18 for getting locality code of customer [end]
						//commented by vishal pathare on 25.10.17 for[initial value should apply (Default Call outcome should be believer)].
						//valueXmlString.append( "<call_outcome protect = '0'><![CDATA[" ).append("5").append( "]]></call_outcome>\r\n" );
						//valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
						valueXmlString.append( "<address_as protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
						valueXmlString.append( "<gender protect = '1' visible = '0'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
						valueXmlString.append( "<spl_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></spl_code>\r\n" );
						valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></speciality_descr>\r\n" );
						valueXmlString.append( "<wf_status><![CDATA[" ).append("P").append( "]]></wf_status>\r\n" );
						valueXmlString.append( "<confirmed><![CDATA[" ).append("N").append( "]]></confirmed>\r\n" );
						// added by rupali on 27/10/17 for displaying preffered stockist field [start]
						valueXmlString.append( "<stockist_name protect = '1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						valueXmlString.append( "<stockist_code><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
						// added by rupali on 27/10/17 for displaying preffered stockist field [end]
						// added by rupali on 01/12/17 for hiding unnecessary fields [start]
						valueXmlString.append( "<addr1 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
						valueXmlString.append( "<addr2 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
						valueXmlString.append( "<addr3 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
						valueXmlString.append( "<strg_class_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
						valueXmlString.append( "<class_code_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
						// added by rupali on 01/12/17 for hiding unnecessary fields [end]
						// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [start]
						valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
						valueXmlString.append("<event_time_end><![CDATA[").append(startTime).append( "]]></event_time_end>\r\n" );
						// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [end]
						valueXmlString.append( "<is_pr_exist><![CDATA[" ).append( isPrExist ).append("]]></is_pr_exist>\r\n" );//added by mrunalini sinkar
						valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
						valueXmlString.append("<visited_with_team protect = '0'><![CDATA[" ).append(checkNull(empcode)).append( "]]></visited_with_team>\r\n" ); // added by rupali on 03/05/18 for single screen mgr reporting
						// added by rupali on 23/05/18 for getting locality code of customer [start]
						String locCode = genericUtility.getColumnValue("locality_code", dom2, doctorFormNo);
						String locDescr = "";
						if(locCode == null || locCode.trim().length() == 0)
						{
							strgCode = genericUtility.getColumnValue("strg_code", dom2, doctorFormNo);
							sql = "SELECT LC.LOCALITY_CODE AS LOCALITY_CODE,LC.DESCR AS DESCR FROM LOCALITY LC, STRG_CUSTOMER SC WHERE LC.LOCALITY_CODE = SC.LOCALITY_CODE AND SC.SC_CODE = ?";
							pstmt =  connectionObject.prepareStatement(sql);
							pstmt.setString(1, strgCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								locCode = rs.getString("LOCALITY_CODE");
								locDescr = rs.getString("DESCR");
								System.out.println("localoty code =["+locCode+"] locality descr =["+locDescr+"]");
							}
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}

							valueXmlString.append( "<locality_code protect = '0'><![CDATA[" ).append( locCode ).append( "]]></locality_code>\r\n" );
							valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append( locDescr ).append( "]]></locality_descr>\r\n" );
						}
						// added by rupali on 23/05/18 for getting locality code of customer [end]
						valueXmlString.append( "</Detail1>\r\n" );
						System.out.println("itemdefault called....");*/
						//commented by rupali on 26/07/18 to open realtime report from series master [end]
					}
					// added by rupali on 23/02/18 for edit mode of realtime report [end]

					// commented by rupali on 23/02/18 for edit mode of realtime report [start]
					/*valueXmlString.append( "<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n");
					valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
					valueXmlString.append( "<event_date><![CDATA[" ).append( currDate ).append( "]]></event_date>\r\n" );
					valueXmlString.append( "<event_type protect = '0'><![CDATA[" ).append("FW").append( "]]></event_type>\r\n" );
					valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append("WHOLE DAY FIELD WORK").append( "]]></activity_descr>\r\n" );
					valueXmlString.append( "<activity_type><![CDATA[" ).append("FW").append( "]]></activity_type>\r\n" );
					//	valueXmlString.append( "<cust_type><![CDATA[" ).append("").append( "]]></cust_type>\r\n" ); // commented by rupali on 19/09/17 for showing default value in cust_type
					valueXmlString.append( "<cust_type><![CDATA[" ).append("LISTED").append( "]]></cust_type>\r\n" ); // added by rupali on 19/09/17 for showing default value in cust_type
					valueXmlString.append( "<chg_date protect = '1'><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
					valueXmlString.append( "<chg_user protect = '1'><![CDATA[" ).append(empcode).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<chg_term protect = '1'><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
					valueXmlString.append( "<sales_pers protect = '1'><![CDATA[" ).append(userId).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<sales_pers_sp_name protect = '1'><![CDATA[" ).append(spName).append( "]]></sales_pers_sp_name>\r\n" );

					valueXmlString.append( "<strg_name protect = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
					valueXmlString.append( "<address protect = '1'><![CDATA[" ).append("").append( "]]></address>\r\n" );
					valueXmlString.append( "<email_addr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
					valueXmlString.append( "<mobile_no protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
					valueXmlString.append( "<locality_code protect = '0'><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
					valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
					//commented by vishal pathare on 25.10.17 for[initial value should apply (Default Call outcome should be believer)].
					//valueXmlString.append( "<call_outcome protect = '0'><![CDATA[" ).append("5").append( "]]></call_outcome>\r\n" );
					//valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
					valueXmlString.append( "<address_as protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
					valueXmlString.append( "<gender protect = '1' visible = '0'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
					valueXmlString.append( "<spl_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></spl_code>\r\n" );
					valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></speciality_descr>\r\n" );
					valueXmlString.append( "<wf_status><![CDATA[" ).append("P").append( "]]></wf_status>\r\n" );
					valueXmlString.append( "<confirmed><![CDATA[" ).append("N").append( "]]></confirmed>\r\n" );
					// added by rupali on 27/10/17 for displaying preffered stockist field [start]
					valueXmlString.append( "<stockist_name protect = '1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
					valueXmlString.append( "<stockist_code><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
					// added by rupali on 27/10/17 for displaying preffered stockist field [end]
					// added by rupali on 01/12/17 for hiding unnecessary fields [start]
					valueXmlString.append( "<addr1 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
					valueXmlString.append( "<addr2 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
					valueXmlString.append( "<addr3 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
					valueXmlString.append( "<strg_class_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
					valueXmlString.append( "<class_code_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
					// added by rupali on 01/12/17 for hiding unnecessary fields [end]
					// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [start]
					valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
					valueXmlString.append("<event_time_end><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
					// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [end]
					valueXmlString.append( "<is_pr_exist><![CDATA[" ).append( isPrExist ).append("]]></is_pr_exist>\r\n" );//added by mrunalini sinkar
					valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );

					valueXmlString.append( "</Detail"+objContext+">\r\n" );
					System.out.println("itemdefault called....");*/
					// commented by rupali on 23/02/18 for edit mode of realtime report [start]

				}
				else if( currentColumn.equalsIgnoreCase( "event_date" ))
				{
					String eventType="";
					//System.out.println("Itemchanged on event_date .....");
					dcrDate = checkNull(genericUtility.getColumnValue("event_date", dom2 ));
					salesPers = checkNull(genericUtility.getColumnValue( "sales_pers", dom2 ));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom2 ));
					String localityCode=checkNull(genericUtility.getColumnValue("locality_code", dom2 ));
					String custDateType=checkNull(genericUtility.getColumnValue("cust_type", dom2 ));
					eventType = checkNull(genericUtility.getColumnValue("event_type", dom2)); // Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]

					//strgType = checkNull(genericUtility.getColumnValue("cust_type", dom2 ));
					//strgNameDom = checkNull(genericUtility.getColumnValue("strg_name", dom2 ));


					/*					if( (dcrDate != null && dcrDate.trim().length() > 0)  && (strgType != null && strgType.trim().length() > 0)
							&& (strgNameDom != null && strgNameDom.trim().length() > 0) && (strgCode != null && strgCode.trim().length() > 0))
					{
					 */						/*System.out.println("Called Itemchanged on event_date ::::: editFlag"+editFlag);


						System.out.println( " dcrDate dcrDate [" + dcrDate + "]" );
						eventDate=dcrDate;
						System.out.println( " eventDate dcrDate [" + eventDate + "]" );*/

					/*if("U".equalsIgnoreCase(strgType))
						{
							strgType = "L";
						}
						else if ("V".equalsIgnoreCase(strgType))
						{
							strgType = "F";
						}*/
					//added by mrunalini sinkar on 19-jan-2018 prescription report changes (start)
					if(dcrDate != null && dcrDate.trim().length() > 0)
					{




						String allowChgTime="";
						String ACTIVITYSql="SELECT ALLOW_CHG_VISITTIME FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
						pstmt =  connectionObject.prepareStatement(ACTIVITYSql);
						pstmt.setString(1, eventType);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							allowChgTime = checkNull(rs.getString("ALLOW_CHG_VISITTIME"));
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						
						valueXmlString.append("<Detail"+objContext+ " domID='1' formName='"+formName+"'>\r\n" );
						
						valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
						
						String setVisitTime = getSfaParmValue(salesPers,"SET_VISIT_TIME",connectionObject);
						String eventEndTime = getSfaParmValue(salesPers,"HIDE_EVENT_TIME_END",connectionObject);

						if(isFortuneActivity.trim().equalsIgnoreCase("Y"))
						{
							if(allowChgTime.trim().equalsIgnoreCase("Y"))
							{
								valueXmlString.append("<event_time_start protect='0'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='0'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
						
							}		
							else if(allowChgTime.trim().equalsIgnoreCase("N"))
							{
								valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							}
							else if(allowChgTime.trim().equalsIgnoreCase("B") && !dcrDate.equals(currentDate))
							{
								valueXmlString.append("<event_time_start protect='0'><![CDATA[]]></event_time_start>\r\n");
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
								valueXmlString.append("<event_time_end protect='0'><![CDATA[]]></event_time_end>\r\n" );
							}
							else
							{
								valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							}						
							valueXmlString.append( "<allow_chg_visittime><![CDATA[").append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );								

							
						}
						else
						{
							if(!dcrDate.equals(currentDate) && (setVisitTime.trim().length() == 0 || setVisitTime.equalsIgnoreCase("N")))
							{
								if("LISTED".equalsIgnoreCase(custDateType))
								{
									if("Y".equalsIgnoreCase(eventEndTime))
									{
										valueXmlString.append("<event_time_start visible = '1'><![CDATA[]]></event_time_start>\r\n");
										valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
										valueXmlString.append("<event_time_end visible = '0'><![CDATA[]]></event_time_end>\r\n" );
									}
									else
									{
										valueXmlString.append("<event_time_start visible = '1'><![CDATA[]]></event_time_start>\r\n");
										valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
										valueXmlString.append("<event_time_end visible = '1'><![CDATA[]]></event_time_end>\r\n" );
									}
								}
								else
								{
									valueXmlString.append("<event_time_start visible = '0'><![CDATA[]]></event_time_start>\r\n");
									valueXmlString.append("<visit_time_from visible = '1'><![CDATA[]]></visit_time_from>\r\n");
									valueXmlString.append("<event_time_end visible = '1'><![CDATA[]]></event_time_end>\r\n" );
								}

							}
						}
						// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
						
						if(isFortuneActivity.trim().equalsIgnoreCase("Y"))
						{
							if(allowChgTime.trim().equalsIgnoreCase("Y"))
							{
								valueXmlString.append("<event_time_start protect='0'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='0'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
						
							}		
							else if(allowChgTime.trim().equalsIgnoreCase("N"))
							{
								valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							}
							else if(allowChgTime.trim().equalsIgnoreCase("B") && !dcrDate.equals(currentDate))
							{
								valueXmlString.append("<event_time_start protect='0'><![CDATA[]]></event_time_start>\r\n");
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
								valueXmlString.append("<event_time_end protect='0'><![CDATA[]]></event_time_end>\r\n" );
							}
							else
							{
								valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							}						
							valueXmlString.append( "<allow_chg_visittime><![CDATA[").append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );								

							
						}
						else
						{
							if(!dcrDate.equals(currentDate))
							{
								if("LISTED".equalsIgnoreCase(custDateType))
								{
									if("Y".equalsIgnoreCase(eventEndTime))
									{
										valueXmlString.append("<event_time_start visible = '1'><![CDATA[]]></event_time_start>\r\n");
										valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
										valueXmlString.append("<event_time_end visible = '0'><![CDATA[]]></event_time_end>\r\n" );
									}
									else
									{
										valueXmlString.append("<event_time_start visible = '1'><![CDATA[]]></event_time_start>\r\n");
										valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
										valueXmlString.append("<event_time_end visible = '1'><![CDATA[]]></event_time_end>\r\n" );
									}

								}
								else
								{
									valueXmlString.append("<event_time_start visible = '0'><![CDATA[]]></event_time_start>\r\n");
									valueXmlString.append("<visit_time_from visible = '1'><![CDATA[]]></visit_time_from>\r\n");
									valueXmlString.append("<event_time_end visible = '1'><![CDATA[]]></event_time_end>\r\n" );
								}

							}
							else
							{
								valueXmlString.append("<event_time_start visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end visible = '0'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");

							}
						}
						// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
						
						valueXmlString.append( "<oth_participant><![CDATA[" ).append( "").append( "]]></oth_participant>\r\n" );//Added by sagar m.on 17.1.19[for work with other set current value].
						valueXmlString.append( "</Detail"+objContext+">\r\n" );
					}
					//}
				}
				else if(currentColumn.trim().equalsIgnoreCase( "event_type" ))
				{
					//System.out.println("In side Itemchanged called Activity.......... ");
					String actDescr = "", actType="",placeRequired="",actPlace="";
					String allowChgTime = "";
					String strgTypeD = checkNull(genericUtility.getColumnValue("strg_type", dom2, "1"));
					String custTypeD = checkNull(genericUtility.getColumnValue("cust_type", dom2, "1"));
					//System.out.println("strgTypeD :: ["+strgTypeD+"]custTypeD::["+custTypeD+"]");

					String activityCode = checkNull(genericUtility.getColumnValue("event_type", dom2));
					//Added by Pooja on 18/12/19 [Coaching related detail form implementation]
					String shDescr = checkNull(genericUtility.getColumnValue("sh_descr", dom2));
					//Query Modified by mrunalini sinkar to add the place required on 09-sep-2018
					//sql = " SELECT DESCR, ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
					
					
					sql = " SELECT DESCR, ACTIVITY_TYPE,PLACE_REQUIRED, ALLOW_CHG_VISITTIME,ACTIVITY_PLACE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,activityCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						actDescr = checkNull(rs.getString("DESCR"));
						actType = checkNull(rs.getString("ACTIVITY_TYPE"));
						placeRequired = checkNull(rs.getString("PLACE_REQUIRED")); //added by mrunalini sinkar to add the place required on 09-sep-2018
						allowChgTime = checkNull(rs.getString("ALLOW_CHG_VISITTIME")); // Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
						actPlace = checkNull(rs.getString("ACTIVITY_PLACE")); 

					}
					//System.out.println("actType =["+actType+"]placeRequired=["+placeRequired+"]");
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					// added by mrunalini sinkar if the activity type is leave and nfw on 30-may-2017 then protect the all fields(start)
					//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
					//if("LEAVE".equalsIgnoreCase(actType) || "NFW".equalsIgnoreCase(actType))
					//Added by Pooja on 18/12/19 [Coaching related detail form implementation]
					//if(!"FW".equalsIgnoreCase(actType))
					if(!"FW".equalsIgnoreCase(actType) || "CA".equalsIgnoreCase(activityCode) ) //Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
					{
						valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n" );
						valueXmlString.append( "<event_type protect = '0'><![CDATA[" ).append(checkNull(activityCode)).append( "]]></event_type>\r\n" );
						valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append(checkNull(actDescr)).append( "]]></activity_descr>\r\n" );
						valueXmlString.append( "<activity_type><![CDATA[" ).append(checkNull(actType)).append( "]]></activity_type>\r\n" );
						//Added by Pooja on 18/12/19 [Coaching related detail form implementation] START
						valueXmlString.append( "<activity_place><![CDATA[" ).append(checkNull(actPlace)).append( "]]></activity_place>\r\n" );

						if( "CA".equalsIgnoreCase(activityCode) )
						{
							valueXmlString.append( "<strg_code protect = '1' visible = '0'><![CDATA[" ).append("NA").append( "]]></strg_code>\r\n" );
						}
						else
						{
							valueXmlString.append( "<strg_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></strg_code>\r\n" );
						}
						//Added by Pooja on 18/12/19 [Coaching related detail form implementation] END
						valueXmlString.append( "<strg_name protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
						valueXmlString.append( "<address_as protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
						valueXmlString.append( "<gender protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></gender>\r\n" );
						valueXmlString.append( "<cust_type protect = '1' visible = '0'><![CDATA[" ).append(checkNull(custTypeD)).append( "]]></cust_type>\r\n" );
						//Chnages by mrunalini sinkar to add the place required on 09-sep-2018
						//added by mrunalini sinkar on 26-june-2018(start)
						//if( "NFW".equalsIgnoreCase(actType))
						if( "Y".equalsIgnoreCase(placeRequired))
						{
							valueXmlString.append( "<locality_code protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
							valueXmlString.append( "<locality_descr protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
							if(mgrCode.trim().length()!= 0)
							{
								valueXmlString.append( "<visited_with protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></visited_with>\r\n" ); //added by rupali on 18/09/17 for worked with field
							}
							else
							{
								valueXmlString.append( "<visited_with protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></visited_with>\r\n" ); //added by rupali on 18/09/17 for worked with field
							}
						}
						//added by mrunalini sinkar on 26-june-2018(end)
						else
						{
							valueXmlString.append( "<locality_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
							valueXmlString.append( "<locality_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
							valueXmlString.append( "<visited_with protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></visited_with>\r\n" ); //added by rupali on 18/09/17 for worked with field
						}
						//added by mrunalini sinkar on 26-june-2018(end)
						valueXmlString.append( "<call_outcome protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></call_outcome>\r\n" );
						//commented by mrunalini sinkar to set na in case of LEAVE & NFW11 -june-2018(start)
						//valueXmlString.append( "<meet_summ protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<meet_summ protect = '1' visible = '0'><![CDATA[" ).append("---NA---").append( "]]></meet_summ>\r\n" );
						//commented by mrunalini sinkar to set na in case of LEAVE & NFW11 -june-2018(start)
						valueXmlString.append( "<addr1 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
						valueXmlString.append( "<addr2 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
						valueXmlString.append( "<addr3 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
						valueXmlString.append( "<mobile_no protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
						valueXmlString.append( "<email_addr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						valueXmlString.append( "<strg_class_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
						valueXmlString.append( "<class_code_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
						valueXmlString.append( "<spl_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></spl_code>\r\n" );
						valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></speciality_descr>\r\n" );
						valueXmlString.append( "<remarks protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></remarks>\r\n" );
						valueXmlString.append( "<copy_plan protect='1' visible = '0'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
						valueXmlString.append( "<oth_participant protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" ); //added by rupali on 18/09/17 for worked with field
						// added by rupali on 27/10/17 for displaying preffered stockist field [start]
						valueXmlString.append( "<stockist_name protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						valueXmlString.append( "<stockist_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
						// added by rupali on 27/10/17 for displaying preffered stockist field [end]
						/*valueXmlString.append("<event_time_start visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
						valueXmlString.append("<event_time_end visible = '0'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );*/
						valueXmlString.append( "<visited_with_team protect = '1' visible = '0'><![CDATA[" ).append(empcode).append( "]]></visited_with_team>\r\n" ); // added by rupali on 03/05/18 for single screen mgr reporting
						valueXmlString.append( "<place_required protect = '1' visible = '0'><![CDATA[" ).append(placeRequired).append( "]]></place_required>\r\n" ); //added by mrunalini sinkar to add the place required on 09-sep-2018
						if(isFortuneActivity.trim().equalsIgnoreCase("Y"))
						{
							if(allowChgTime.trim().equalsIgnoreCase("Y"))
							{
								valueXmlString.append("<event_time_start protect='0'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='0'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
						
							}		
							else if(allowChgTime.trim().equalsIgnoreCase("N"))
							{
								valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							}
							else if(allowChgTime.trim().equalsIgnoreCase("B") && !dcrDate.equals(currentDate))
							{
								valueXmlString.append("<event_time_start protect='0'><![CDATA[]]></event_time_start>\r\n");
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
								valueXmlString.append("<event_time_end protect='0'><![CDATA[]]></event_time_end>\r\n" );
							}
							else
							{
								valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							}						
							valueXmlString.append( "<allow_chg_visittime><![CDATA[").append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );								

							
						}
						
						valueXmlString.append( "</Detail"+objContext+">\r\n" );
					}
					else
					{
						valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n" );
						valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append(checkNull(actDescr)).append( "]]></activity_descr>\r\n" );
						valueXmlString.append( "<event_type protect = '0'><![CDATA[" ).append(checkNull(activityCode)).append( "]]></event_type>\r\n" );
						valueXmlString.append( "<activity_type><![CDATA[" ).append(checkNull(actType)).append( "]]></activity_type>\r\n" );
						valueXmlString.append( "<strg_code protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></strg_code>\r\n" );
						valueXmlString.append( "<strg_name protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
						valueXmlString.append( "<address_as protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
						valueXmlString.append( "<gender protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></gender>\r\n" );
						valueXmlString.append( "<cust_type protect = '0' visible = '1'><![CDATA[" ).append("LISTED").append( "]]></cust_type>\r\n" );
						valueXmlString.append( "<locality_code protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<call_outcome protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></call_outcome>\r\n" );
						valueXmlString.append( "<meet_summ protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<addr1 protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
						valueXmlString.append( "<addr2 protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
						valueXmlString.append( "<addr3 protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
						//valueXmlString.append( "<mobile_no protect = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
						//valueXmlString.append( "<email_addr protect = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						valueXmlString.append( "<spl_code protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></spl_code>\r\n" );
						valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></speciality_descr>\r\n" );
						valueXmlString.append( "<remarks protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></remarks>\r\n" );
						valueXmlString.append( "<strg_class_code protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
						valueXmlString.append( "<class_code_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
						valueXmlString.append( "<visited_with protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></visited_with>\r\n" ); //added by rupali on 18/09/17 for worked with field
						// added by rupali on 27/10/17 for displaying preffered stockist field [start]
						valueXmlString.append( "<stockist_name protect = '1' visible = '1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						valueXmlString.append( "<stockist_code protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
						// added by rupali on 27/10/17 for displaying preffered stockist field [end]
						// added by rupali on 01/12/17 for hiding unnecessary fields [start]
						valueXmlString.append( "<locality_descr protect = '1' visible = '1'><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
						valueXmlString.append( "<mobile_no protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
						valueXmlString.append( "<email_addr protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						// added by rupali on 01/12/17 for hiding unnecessary fields [end]
						/*valueXmlString.append("<event_time_start visible = '1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
						valueXmlString.append("<event_time_end visible = '1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );*/
						valueXmlString.append( "<copy_plan protect='1' visible = '1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
						valueXmlString.append( "<oth_participant protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" ); //added by rupali on 18/09/17 for worked with field
						valueXmlString.append( "<visited_with_team protect = '0' visible = '1'><![CDATA[" ).append(empcode).append( "]]></visited_with_team>\r\n" ); // added by rupali on 03/05/18 for single screen mgr reporting
						valueXmlString.append( "<place_required protect = '0' visible = '0'><![CDATA[" ).append(placeRequired).append( "]]></place_required>\r\n" ); //added by mrunalini sinkar to add the place required on 09-sep-2018
						valueXmlString.append( "<activity_place><![CDATA[" ).append(checkNull(actPlace)).append( "]]></activity_place>\r\n" );

						// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
						if(isFortuneActivity.trim().equalsIgnoreCase("Y"))
						{
							if(allowChgTime.trim().equalsIgnoreCase("Y"))
							{
								valueXmlString.append("<event_time_start protect='0'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='0'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
						
							}		
							else if(allowChgTime.trim().equalsIgnoreCase("N"))
							{
								valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							}
							else if(allowChgTime.trim().equalsIgnoreCase("B") && !dcrDate.equals(currentDate))
							{
								valueXmlString.append("<event_time_start protect='0'><![CDATA[]]></event_time_start>\r\n");
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
								valueXmlString.append("<event_time_end protect='0'><![CDATA[]]></event_time_end>\r\n" );
							}
							else
							{
								valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							}						
							valueXmlString.append( "<allow_chg_visittime><![CDATA[").append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );											
						}			
						// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
						valueXmlString.append( "</Detail"+objContext+">\r\n" );
					}
					// added by mrunalini sinkar if the activity type is leave and nfw on 30-may-2017 then protect the all fields(end)
				}

				else if(currentColumn.trim().equalsIgnoreCase("strg_code" ))
				{
					String eventType = checkNull(genericUtility.getColumnValue("event_type", dom2,doctorFormNo));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom2,doctorFormNo));
					//System.out.println("strgCode in doctor form is:["+strgCode+"]");
					String sprsCode = genericUtility.getColumnValue("sales_pers", dom2, doctorFormNo);
					String trvDate = genericUtility.getColumnValue("event_date", dom2, doctorFormNo);
					strgType = checkNull(genericUtility.getColumnValue("cust_type", dom2));
					String localityCode = checkNull(genericUtility.getColumnValue("locality_code", dom2, doctorFormNo));
					String locDescription = checkNull(genericUtility.getColumnValue("locality_descr", dom2, doctorFormNo));
					String stockistCode = checkNull(genericUtility.getColumnValue("stockist_code", dom2, doctorFormNo));
					String stockistName = checkNull(genericUtility.getColumnValue("stockist_name", dom2, doctorFormNo));
					String shdescr = checkNull(genericUtility.getColumnValue("sh_descr", dom2, doctorFormNo));
					
					//Added by Mrunalini Sinkar On 03-10-2018 for allw_delay_prd(start)
					int allwdPrd=0;
					String allDelaySql = "SELECT ALLWD_DELAY_PRD FROM SALES_PERS WHERE SALES_PERS=?";
					pstmt =  connectionObject.prepareStatement(allDelaySql);
					pstmt.setString(1, checkNull(sprsCode));
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						allwdPrd = rs.getInt("ALLWD_DELAY_PRD");
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					//Added by Mrunalini Sinkar On 03-10-2018 for allw_delay_prd(end)
					// added by rupali on 11/09/18 for applying validation for distance limit variance [start]
					//String varDistance = getSfaParmValue(userId,"VARIANCE_DISTANCE_LMT",connectionObject);
					String varDistance = getSfaParmValue(userId,"VARIANCE_DISTANC_LMT",connectionObject);
					String taggedLoc = "";
					/*String taggedLocSql = "SELECT GET_TAGGED_LOCATION(?) AS TAGGED_LOCATION FROM DUAL";
					pstmt =  connectionObject.prepareStatement(taggedLocSql);
					pstmt.setString(1, checkNull(strgCode));
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						taggedLoc = checkNull(rs.getString("TAGGED_LOCATION"));
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}*/
					// added by rupali on 11/09/18 for applying validation for distance limit variance [end]

					// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
					String allowChgTime="";
					String ACTIVITYSql="SELECT ALLOW_CHG_VISITTIME FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
					pstmt =  connectionObject.prepareStatement(ACTIVITYSql);
					pstmt.setString(1, eventType);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						allowChgTime = checkNull(rs.getString("ALLOW_CHG_VISITTIME"));
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
					
					valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
					//Added by Pooja on 18/12/19 [Coaching related detail form implementation] START
					eventType = genericUtility.getColumnValue( "event_type", dom );
					//Added by Pooja on 18/12/19 [Coaching related detail form implementation] END
					int visit=0;
					visit = orderOfVisit(trvDate,sprsCode,localityCode ,connectionObject); //added by mrunalini sinkar to count total number of visit
					//added by mrunalini sinkar on 19-jan-2018 for adding copy plan changes report changes (end)
					int planCount=0;
					String planID = "";
					int planCnt = 0;
					int planCustCnt = 0;
					Boolean isCustPlan = false;
					String isPlanCumpulsory  = getSfaParmValue(userId,"IS_PLAN_COMPULSORY",connectionObject);
					if(trvDate != null && trvDate.trim().length() > 0)
					{
						if("Y".equalsIgnoreCase(isPlanCumpulsory))
						{
							String planSql="select count(*) AS COUNT from SPRS_PLAN_HDR sph,SPRS_PLAN_cust planCust where sph.plan_date=? and sph.SPRS_CODE__PLAN=? and planCust.sc_code=? and planCust.locality_code=? and sph.plan_id=planCust.plan_id and sph.confirm='Y'";
							PreparedStatement planPstmt =  connectionObject.prepareStatement(planSql);
							planPstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
							planPstmt.setString(2, checkNull(sprsCode));
							planPstmt.setString(3, checkNull(strgCode));
							planPstmt.setString(4, checkNull(localityCode));

							ResultSet planRs = planPstmt.executeQuery();
							if(planRs.next())
							{
								planCount = planRs.getInt("COUNT");
							}
							if(planRs != null)
							{
								planRs.close();
								planRs = null;
							}
							if(planPstmt != null)
							{
								planPstmt.close();
								planPstmt = null;
							}
							// added by rupali on 10/10/18 to set report from plan value if plan for selected loaclity is available [start]
							planSql = "select PLAN_ID, count(*) AS COUNT from SPRS_PLAN_HDR where sprs_code__plan = ? and plan_date = ? and confirm='Y' group by plan_id";
							planPstmt =  connectionObject.prepareStatement(planSql);
							planPstmt.setString(1, checkNull(sprsCode));
							planPstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
							planRs = planPstmt.executeQuery();
							if(planRs.next())
							{
								planID = planRs.getString("PLAN_ID");
								planCnt = planRs.getInt("COUNT");
								String planCustSql="select count(*) AS COUNT from SPRS_PLAN_CUST where PLAN_ID = ?";
								PreparedStatement planCustPstmt =  connectionObject.prepareStatement(planCustSql);
								planCustPstmt.setString(1, checkNull(planID));
								ResultSet planCustRs = planCustPstmt.executeQuery();
								if(planCustRs.next())
								{
									planCustCnt = planCustRs.getInt("COUNT");
								}
								//addedby mrunalini 310821
								if(planCustRs != null)
								{
									planCustRs.close();
									planCustRs = null;
								}
								if(planCustPstmt != null)
								{
									planCustPstmt.close();
									planCustPstmt = null;
								}
							}
							if(planRs != null)
							{
								planRs.close();
								planRs = null;
							}
							if(planPstmt != null)
							{
								planPstmt.close();
								planPstmt = null;
							}
							if( planCnt > 0 && planCustCnt > 0 )
							{
								isCustPlan = true;
							}
							// added by rupali on 10/10/18 to set report from plan value if plan for selected loaclity is available [end]
						}
					}
					//added by mrunalini sinkar on 19-jan-2018 for adding copy plan changes report changes (end)
					if(dbName.equalsIgnoreCase("ORACLE"))
					{
						sql = "SELECT SC.FIRST_NAME || ' ' ||  SC.LAST_NAME  STRG_NAME,SC.CUST_TYPE,SC.LOCALITY_CODE,SC.ADDRESS_AS,SC.SEX,SC.ADDR1,SC.ADDR2,SC.ADDR3,SC.EMAIL_ADDR,SC.MOBILE_NO,SC.SURVEY_TEMPL,ST.DESCR SURVEY_TEMPL_DESCR " + 
								"FROM STRG_CUSTOMER   SC LEFT OUTER JOIN SURVEY_TEMPLATE ST ON ST.SURVEY_TEMPL = SC.SURVEY_TEMPL WHERE SC.SC_CODE = ? AND SC.STATUS='A' ";
					}
					else
					{
						sql = "SELECT  C.COMPANY_NAME AS STRG_NAME,SC.CUST_TYPE,SC.LOCALITY_CODE,SC.ADDRESS_AS,SC.SEX,SC.ADDR1,SC.ADDR2,SC.ADDR3,SC.EMAIL_ADDR,SC.MOBILE_NO,SC.SURVEY_TEMPL,ST.DESCR SURVEY_TEMPL_DESCR " + 
								"FROM COMPANY C,STRG_CUSTOMER   SC LEFT OUTER JOIN SURVEY_TEMPLATE ST ON ST.SURVEY_TEMPL = SC.SURVEY_TEMPL WHERE SC.SC_CODE = ? AND SC.STATUS='A'  AND C.COMPANY_CODE=SC.SC_CODE ";
					}
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,strgCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						String customerType = checkNull(rs.getString("CUST_TYPE"));
						
						//System.out.println("CUST_TYPE IS :"+customerType);
						valueXmlString.append("<strg_name protect = '1'><![CDATA[" ).append(checkNull(rs.getString("STRG_NAME"))).append( "]]></strg_name>\r\n" );
						valueXmlString.append("<strg_code protect = '0'><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
						//	valueXmlString.append("<cust_type protect = '1'><![CDATA[" ).append("LISTED").append( "]]></cust_type>\r\n" ); // commented by rupali on 19/09/17 for editing cust_type
						valueXmlString.append("<cust_type protect = '0'><![CDATA[" ).append("LISTED").append( "]]></cust_type>\r\n" ); // added by rupali on 19/09/17 for editing cust_type
						valueXmlString.append("<strg_type protect = '1'><![CDATA[" ).append( checkNull(rs.getString("CUST_TYPE"))).append( "]]></strg_type>\r\n" );
						//valueXmlString.append("<locality_code protect='1'><![CDATA[" ).append( checkNull(rs.getString("LOCALITY_CODE")) ).append( "]]></locality_code>\r\n" );
						//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(start)

						if(localityCode!=null && localityCode.trim().length()>0)
						{
							valueXmlString.append("<locality_code protect='0'><![CDATA[" ).append(localityCode).append( "]]></locality_code>\r\n" );	//Changed by Sagar B. on 13/10/17 for location code editable
						}
						else
						{
							valueXmlString.append("<locality_code protect='0'><![CDATA[" ).append( checkNull(rs.getString("LOCALITY_CODE")) ).append( "]]></locality_code>\r\n" );	//Changed by Sagar B. on 13/10/17 for location code editable
						}
						//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(end)

						valueXmlString.append("<address_as protect = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );
						valueXmlString.append("<gender protect = '1'><![CDATA[" ).append( checkNull(rs.getString("SEX")) ).append( "]]></gender>\r\n" );
						valueXmlString.append("<addr1 protect = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR1")) ).append( "]]></addr1>\r\n" );
						valueXmlString.append("<addr2 protect = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR2")) ).append( "]]></addr2>\r\n" );
						valueXmlString.append("<addr3 protect = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR3")) ).append( "]]></addr3>\r\n" );
						valueXmlString.append("<email_addr protect = '1'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
						valueXmlString.append("<mobile_no protect = '1'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
						valueXmlString.append("<order_of_visit><![CDATA[" ).append(visit).append( "]]></order_of_visit>\r\n" );
						valueXmlString.append("<strg_class_code protect = '1'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
						// added by rupali on 20/09/17 for inserting event_time in strg_meet table [start]
						/*valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
						valueXmlString.append("<event_time_end><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );*/
						// added by rupali on 20/09/17 for inserting event_time in strg_meet table [end]
						// added by rupali on 09/10/17 for displaying customer type on summary screen [start]
						if("D".equalsIgnoreCase(customerType) )
						{
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("DOCTOR").append( "]]></sh_descr>\r\n" );
							valueXmlString.append("<stockist_code protect = '0' visible = '1'><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name protect = '1' visible = '1'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );
						}
						else if("C".equalsIgnoreCase(customerType) || "R".equalsIgnoreCase(customerType) )
						{
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("CHEMIST").append( "]]></sh_descr>\r\n" );
							valueXmlString.append("<stockist_code protect = '0' visible = '1'><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name protect = '1' visible = '1'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );
						}
						else if("S".equalsIgnoreCase(customerType) )
						{
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("STOCKIST").append( "]]></sh_descr>\r\n" );
							valueXmlString.append("<stockist_code protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						}
						else
						{
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("LISTED").append( "]]></sh_descr>\r\n" );
							valueXmlString.append("<stockist_code protect = '0' visible = '1'><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name protect = '1' visible = '1'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );
						}
						// added by rupali on 09/10/17 for displaying customer type on summary screen [end]
						//added by mrunalini sinkar on 20-july-2017 to add speciality code (start)
						/*if(customerType.equals("D"))
						{
							valueXmlString.append("<spl_code protect = '1'><![CDATA[" ).append(rs.getString("SPL_CODE")).append( "]]></spl_code>\r\n" );
							valueXmlString.append("<speciality_descr protect = '1'><![CDATA[" ).append(rs.getString("SPPECIALITY")).append( "]]></speciality_descr>\r\n" );
						}
						else
						{
							valueXmlString.append("<spl_code protect = '1'><![CDATA[" ).append("OTH").append( "]]></spl_code>\r\n" );
							valueXmlString.append("<speciality_descr protect = '1'><![CDATA[" ).append("OTHER").append( "]]></speciality_descr>\r\n" );
						}*/
						valueXmlString.append("<spl_code protect = '1'><![CDATA[" ).append("").append( "]]></spl_code>\r\n" );
						valueXmlString.append("<survey_templ><![CDATA[" ).append(rs.getString("SURVEY_TEMPL")).append( "]]></survey_templ>\r\n" );
						valueXmlString.append("<survey_templ_descr protect = '1'><![CDATA[" ).append(rs.getString("SURVEY_TEMPL_DESCR")).append( "]]></survey_templ_descr>\r\n" );

						//added by mrunalini sinkar on 20-july-2017 to add speciality code (end)
					}
					else
					{
						valueXmlString.append("<strg_name protect = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
						valueXmlString.append("<strg_code protect = '0'><![CDATA[" ).append("").append( "]]></strg_code>\r\n" );
						valueXmlString.append("<strg_type protect = '1'><![CDATA[" ).append("").append( "]]></strg_type>\r\n" );
						valueXmlString.append("<cust_type protect = '0'><![CDATA[" ).append("").append( "]]></cust_type>\r\n" );
						valueXmlString.append("<locality_code><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
						valueXmlString.append("<locality_descr><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
						valueXmlString.append("<address_as protect = '0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
						valueXmlString.append("<gender protect = '0'><![CDATA[" ).append("").append( "]]></gender>\r\n" );
						valueXmlString.append("<addr1 protect = '0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
						valueXmlString.append("<addr2 protect = '0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
						valueXmlString.append("<addr3 protect = '0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
						valueXmlString.append("<email_addr protect = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						valueXmlString.append("<mobile_no protect = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
						valueXmlString.append("<strg_class_code protect = '0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
						valueXmlString.append("<spl_code protect = '0'><![CDATA[" ).append("").append( "]]></spl_code>\r\n" );
						valueXmlString.append("<speciality_descr protect = '0'><![CDATA[" ).append("").append( "]]></speciality_descr>\r\n" );
						// added by rupali on 20/09/17 for inserting event_time in strg_meet table [start]
						valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
						valueXmlString.append("<event_time_end><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
						valueXmlString.append("<route_id protect = '1'><![CDATA[" ).append("").append( "]]></route_id>\r\n" );
						valueXmlString.append("<survey_templ><![CDATA[" ).append("").append( "]]></survey_templ>\r\n" );
						valueXmlString.append("<survey_templ_descr protect = '1'><![CDATA[" ).append("").append( "]]></survey_templ_descr>\r\n" );

						// added by rupali on 20/09/17 for inserting event_time in strg_meet table [end]
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					// commented by rupali on 28/12/17 for not setting blank values in stockist code and name
					// added by rupali on 27/10/17 for displaying preffered stockist field [start]
					/*valueXmlString.append( "<stockist_name protect = '1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
					valueXmlString.append( "<stockist_code protect = '0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );*/
					// added by rupali on 27/10/17 for displaying preffered stockist field [end]
					// added by mrunalini sinkar for default activity for CHC client on 07-02-2019[start]
					String defACt = checkNull(getSfaParmValue(userId, "DEF_ACT_REALCODE", connectionObject));
					String actDescr="",actType="",placReq="";
					String defACtsql = "SELECT DESCR AS ACTIVITY_DESCR,ACTIVITY_TYPE,PLACE_REQUIRED FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
					pstmt = connectionObject.prepareStatement(defACtsql);
					pstmt.setString(1, defACt);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						actDescr = checkNull(rs.getString("ACTIVITY_DESCR"));
						actType = checkNull(rs.getString("ACTIVITY_TYPE"));
						placReq = checkNull(rs.getString("PLACE_REQUIRED"));
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					// added by mrunalini sinkar for default activity for CHC client on 07-02-2019[end]
					if( eventType != null && eventType.trim().length() != 0 )
					{
						valueXmlString.append( "<event_type protect = '1'><![CDATA[" ).append(checkNull(eventType)).append( "]]></event_type>\r\n" );
					}
					else
					{
						valueXmlString.append( "<event_type protect = '1'><![CDATA[" ).append(defACt).append( "]]></event_type>\r\n" );
						valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append(actDescr).append( "]]></activity_descr>\r\n" );
						valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
						valueXmlString.append( "<place_required><![CDATA[" ).append(placReq).append( "]]></place_required>\r\n" );//Added by mrunalini sinkar for place required changes(start)
					}
					// added condition by rupali on 10/10/18 to set report from plan value if plan for selected loaclity is available
					if("Y".equalsIgnoreCase(isPlanCumpulsory) && isCustPlan )
					{
						//if("Y".equalsIgnoreCase(isPlanCumpulsory) && planCount>0)
						if(planCount>0)
						{
							valueXmlString.append( "<copy_plan protect='0'><![CDATA[" ).append("Y").append( "]]></copy_plan>\r\n" );
						}
						else
						{
							valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
						}
					}
					// added by rupali on 29/05/18 for getting locality code of customer [start]
					String locCode = genericUtility.getColumnValue("locality_code", dom2, doctorFormNo);
					String locDescr = "";
					if(locCode == null || locCode.trim().length() == 0)
					{
						strgCode = genericUtility.getColumnValue("strg_code", dom2, doctorFormNo);
						sql = "SELECT LC.LOCALITY_CODE AS LOCALITY_CODE,LC.DESCR AS DESCR FROM LOCALITY LC, STRG_CUSTOMER SC WHERE LC.LOCALITY_CODE = SC.LOCALITY_CODE AND SC.SC_CODE = ?";
						pstmt =  connectionObject.prepareStatement(sql);
						pstmt.setString(1, strgCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							locCode = rs.getString("LOCALITY_CODE");
							locDescr = rs.getString("DESCR");
							//System.out.println("localoty code =["+locCode+"] locality descr =["+locDescr+"]");
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}

						valueXmlString.append( "<locality_code protect = '0'><![CDATA[" ).append( locCode ).append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append( locDescr ).append( "]]></locality_descr>\r\n" );
					}
					// added by rupali on 29/05/18 for getting locality code of customer [end]
					// added by rupali on 11/09/18 for applying validation for distance limit variance [start]
					valueXmlString.append( "<variance_distance><![CDATA[" ).append( varDistance ).append( "]]></variance_distance>\r\n" );
					valueXmlString.append( "<tagged_location><![CDATA[" ).append( taggedLoc ).append( "]]></tagged_location>\r\n" );
					// added by rupali on 11/09/18 for applying validation for distance limit variance [end]
					//Added by Mrunalini Sinkar On 03-10-2018 for allw_delay_prd(start)
					valueXmlString.append( "<allwd_delay_prd><![CDATA[" ).append( allwdPrd ).append( "]]></allwd_delay_prd>\r\n" );
					//Added by Mrunalini Sinkar On 03-10-2018 for allw_delay_prd(start)
					// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
					if(isFortuneActivity.trim().equalsIgnoreCase("Y"))
					{
						valueXmlString.append( "<allow_chg_visittime><![CDATA[").append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );								

						if(allowChgTime.trim().equalsIgnoreCase("Y"))
						{
							valueXmlString.append("<event_time_start protect='0'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
							valueXmlString.append("<event_time_end protect='0'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
							valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");

						}		
						else if(allowChgTime.trim().equalsIgnoreCase("N"))
						{
							valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
							valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
							valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
						}
						else if(allowChgTime.trim().equalsIgnoreCase("B") && !dcrDate.equals(currentDate))
						{
							valueXmlString.append("<event_time_start protect='0'><![CDATA[]]></event_time_start>\r\n");
							valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
							valueXmlString.append("<event_time_end protect='0'><![CDATA[]]></event_time_end>\r\n" );
						}
						else
						{
							valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
							valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
							valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
						}						

					}
					// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
				
					valueXmlString.append( "</Detail"+objContext+">\r\n" );
				}
				else if( currentColumn.equalsIgnoreCase("survey_templ"))
				{

					System.out.println("INSIDE survey_templ itemchange................");
					String surveyTemplate = checkNull(genericUtility.getColumnValue("survey_templ", dom2,"1"));
					System.out.println("survey_templ code is  :"+surveyTemplate);
					String surveyDescr="";
					sql = "SELECT DESCR FROM SURVEY_TEMPLATE WHERE SURVEY_TEMPL=? ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1, surveyTemplate);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						surveyDescr = checkNull(rs.getString("DESCR"));
						//System.out.println("stockistName"+stockistName);

					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<survey_templ_descr protect = '1'><![CDATA[" ).append(checkNull(surveyDescr)).append( "]]></survey_templ_descr>\r\n" );
					valueXmlString.append( "</Detail"+objContext+">\r\n" );
				
				}

			}

			else if("team".equalsIgnoreCase(formName) || "retailerteam".equalsIgnoreCase(formName))
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				System.out.println("in case 4....");
				if( currentColumn.equalsIgnoreCase("itm_default") )
				{

					String salePersCode = "";
					String wrkDate = "";
					String scCode = "";
					//	String objName = "strg_meet_dcr_wiz";
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
					//System.out.println("**********************In WsfaZuviusDsrWizEJB defaultDataDAR : salePersCode : ["+salePersCode+"] wrkDate:["+wrkDate+"] scCode:["+scCode+"]" );
					valueXmlString.append( getSalesTeamDetails( dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,formName, connectionObject, objContext ));//commented by vinayakk
				}
			}

			else if("survey".equalsIgnoreCase(formName))
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					System.out.println("in detail ...........");
					String salePersCode = "";
					String wrkDate = "";
					String scCode = "";
					//		String objName = "strg_meet_dcr_wiz";
					//System.out.println("Object nAme  value in subform:-  -  "+objName);
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					//System.out.println("ParentForm no is:- "+parentFormNo);

					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
					String surveyTemplate=getSelectedRowValue(dom2, parentFormNo, "survey_templ", 0);

					//System.out.println("hgjjg : " + salePersCode + " wrkDate: " + wrkDate + " scCode: " + scCode );
					valueXmlString.append( getSurveyDetails(dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,connectionObject,objContext,formName,surveyTemplate ));
				}
			}			
			valueXmlString.append( "</Root>\r\n" );
		}//try block ends here
		catch(Exception e)
		{
			System.out.println( "Exception :CustomerSurveyWiz :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :CustomerSurveyWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}

		System.out.println( "\n****ValueXmlString :::::::::::" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	/*private String checkNull(String input)
	{
		if (input == null)
		{
			input="";
		}
		return input.trim();
	}*/
	private String getObjName(Document dom2,String objContext)
	{
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;
		String objName = "";
		elementList = dom2.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("objName")!=null)
				{
					objName = etlAttributes.getNamedItem("objName").getNodeValue();
				}
			}
		}
		return objName;
	}

	




	private String getDomID(Document dom2,String objContext)
	{
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;
		String objName = "";
		elementList = dom2.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("domID")!=null)
				{
					objName = etlAttributes.getNamedItem("domID").getNodeValue();
				}
			}
		}
		return objName;
	}


	public String getSalesTeamDetails( Document dom, Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams,String formName, Connection connectionObject,String formNo ) throws ITMException //Chnaged by sachin satre on 09-nov-16
	{
		ResultSet rs = null;
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		int domID = 1;
		int num = 0;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "";
		String selectedTeam = "";
		String dcrId="";
		String sql="";
		String userId="";
		String dcrID="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn =false;
		try
		{
			//System.out.println("Printing DOM + "+genericUtility.serializeDom(dom)+"+++++++++++++++");
			//System.out.println("Printing DOM222 + "+genericUtility.serializeDom(dom2)+"+++++++++++++++");
			if(connectionObject ==  null )
			{
				connectionObject = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
				isLocalConn =true;
			}
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if( "".equalsIgnoreCase( checkNull( salePersCode ) ) )
			{
				salePersCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			}


			String [] temp = scCode.split(",");
			if ( preDomExists( dom2, formNo ))
			{
				selectedTeam = getPrevFormValues( dom2, formNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
				//System.out.println("previous form values for team : - "+selectedTeam);
			}
			else
			{
				String newScCode = "";
				if(scCode != null && scCode.trim().length() > 0 && scCode.indexOf("'") == -1)
				{
					newScCode = "'"+scCode+"'";
				}
				else
				{
					newScCode = scCode;
				}
				selectedTeam = getSalesExistingTeamDetail( salePersCode, wrkDate , newScCode, formNo ,formName,connectionObject) ;
			}
			selectedTeam = "<Root>" + selectedTeam + "</Root>";
			//System.out.println("selectedTeam>>>"+selectedTeam);
			String itemDetails = getSalesPersTeamList(dom,dom2, salePersCode, scCode, selectedTeam, wrkDate,formNo,formName);
			//TODO


			//System.out.println("itemDetails>>>"+itemDetails);
			valueXmlString.append(itemDetails);
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
			e.printStackTrace();
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				/*if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}	*/
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:defaultDataDAR :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		//System.out.println("Return valueXmlString===>"+valueXmlString);
		return valueXmlString.toString();

	}

	private String getSalesExistingTeamDetail( String salePersCode, String eventDate , String custList ,String formNo,String formName,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 09-nov-16
	{

		ResultSet rs = null;
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		int domID=1;
		StringBuffer valueXmlString = new StringBuffer();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn =false;
		try
		{
			String dbName =CommonConstants.DB_NAME; 

			if(connectionObject ==null )
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
				connectionObject = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
				isLocalConn =true;
			}
			String smiQuery = "";

			String dcrID = getDCRId(connectionObject,salePersCode, eventDate);
			//System.out.println("dcrID>>>"+dcrID);

			if("MYSQL".equalsIgnoreCase(dbName))
			{
				smiQuery= "SELECT DISTINCT ST.TRAN_ID AS TRAN_ID,ST.DCR_ID AS DCR_ID, ST.SALES_PERS AS SALES_PERS ,ST.STRG_CODE AS STRG_CODE , CONCAT(IFNULL(EMP_FNAME,''),' ',IFNULL(EMP_MNAME,''),' ',IFNULL(EMP_LNAME,''))AS EMP_NAME, " +
						"EMP.DESIGNATION DESIGNATION FROM STRG_MEET_TEAM ST LEFT OUTER JOIN EMPLOYEE EMP ON ST.SALES_PERS = EMP.EMP_CODE " +
						"WHERE ST.DCR_ID = '"+dcrID+"' AND STRG_CODE IN("+custList+")";
			}
			else
			{

				
				smiQuery= "SELECT DISTINCT ST.TRAN_ID AS TRAN_ID,ST.DCR_ID AS DCR_ID, ST.SALES_PERS AS SALES_PERS ,ST.STRG_CODE AS STRG_CODE , UPPER(EMP.EMP_FNAME) ||' ' ||UPPER(EMP.EMP_MNAME) ||' '|| UPPER(EMP.EMP_LNAME) AS EMP_NAME, " +
						"EMP.DESIGNATION DESIGNATION FROM STRG_MEET_TEAM ST LEFT OUTER JOIN EMPLOYEE EMP ON ST.SALES_PERS = EMP.EMP_CODE " +
						"WHERE ST.DCR_ID = '"+dcrID+"' AND STRG_CODE IN("+custList+")";
			}


			//System.out.println(" StrgMeetSQL[ ---- >] "+smiQuery);
			pstmt = connectionObject.prepareStatement(smiQuery);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String salesPers = checkNull(rs.getString("SALES_PERS"));
				String dispName = checkNull(getEmpNameDesign(salesPers,connectionObject));//added by mrunalini sinkar 
				String empDesign = getDesignName(salesPers, connectionObject); 
				valueXmlString.append( "<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
				valueXmlString.append("<name>").append(rs.getString("emp_name")).append("</name>\n");//Gulzar
				valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(rs.getString("SALES_PERS"))).append("]]></sales_pers>\n");
				valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
				valueXmlString.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
				valueXmlString.append( "<tran_id><![CDATA[" ).append(checkNull(rs.getString("TRAN_ID"))).append( "]]></tran_id>\r\n" );
				valueXmlString.append("<design_code><![CDATA[").append( empDesign ).append("]]></design_code>\r\n"); // added by rupali on 23/02/18 for edit mode of realtime report
				valueXmlString.append("<visited_with_display><![CDATA[" ).append(checkNull(dispName)).append( "]]></visited_with_display>\r\n" );
				valueXmlString.append( "</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	public String getSalesPersTeamList(Document dom,Document dom2, String sprsCode, String strgCode, String selectedTeam, String eventDate, String formNo, String formName ) throws ITMException
	{
		//Form 4 defaultData()
		String sql = "";
		String sql1 = "";
		StringBuffer selectedXmlString = new StringBuffer();
		StringBuffer unselectedString = new StringBuffer();
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String name = "";
		int maxLineNo = 0;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isMasterPitchFound = false;
		String custTranID = null;
		int modeCounter = 0;
		String workWith = "";
		boolean isLocal = false ;
		int currentFormNo=0;
		String dbName =CommonConstants.DB_NAME; 

		//String objName = checkNull(getObjNameFromDom(dom2, "objName",formNo));
		try
		{
			if(connectionObject == null)
			{
				connectionObject = getConnection();
				isLocal = true;
			}
			if( formNo != null && formNo.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( formNo );
			}
			String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
			String parentFormNo = checkNull(getParentformNo(formNo, objName, connectionObject ));
			//	workWith = checkNull(genericUtility.getColumnValue("select_team", dom2, parentFormNo)); //commented by rupali on 18/09/17 for worked with field
			workWith = checkNull(genericUtility.getColumnValue("visited_with", dom2, parentFormNo)); //added by rupali on 15/09/17 for worked with field
			//	System.out.println("Visited with value is +="+workWith);
			List workWithListForm = null;
			String workWithCodeList = "";
			if(workWith != null && workWith.trim().length() > 0)
			{
				String workWithCode[] = workWith.split(",");

				int totalFieldNo = workWithCode.length;

				//System.out.println("totalFieldNo ::"+totalFieldNo);

				for ( int i = 0; i < totalFieldNo; i++ )
				{
					String code = workWithCode[i];
					if(code.indexOf("(") != -1)
					{
						code = code.substring(code.indexOf("(")+1,code.indexOf(")")).trim();
					}

					workWithCodeList = workWithCodeList + code + ",";
				}
				workWithCodeList = workWithCodeList.substring(0, workWithCodeList.lastIndexOf(","));

				//System.out.println( "workWithCodeList ::::: "+ workWithCodeList);
				String wrkWith = workWithCodeList;
				workWithListForm = Arrays.asList(wrkWith.split(","));
				//System.out.println("value in workWithListForm is:- "+workWithListForm);
			}
			//System.out.println("Printing getDrSalesPersTeamList DOM + "+genericUtility.serializeDom(dom)+"+++++++++++++++");
			//System.out.println("Printing getDrSalesPersTeamList DOM222 + "+genericUtility.serializeDom(dom2)+"+++++++++++++++");
			valueXmlString.append( "<Root>\r\n" );
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			//connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
			/*
			sql1 =" SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR FROM  ITEM ITEM, STRG_CUSTOMER SC ," +
					"PRICELIST  PM "+
					"WHERE ITEM.ITEM_CODE = PM.ITEM_CODE AND SC.STATE_CODE = PM.PRICE_LIST "+
					"AND SC.SC_CODE= ? "+
					"ORDER BY ITEM.SH_DESCR ";
			 */
			// added by rupali on 13/04/18 for org_structure related changes [start]
			ArrayList salesPersList = new ArrayList();
			String salesPersTemp="";
			String isOrgStrcture = getSfaParmValue(sprsCode,"HIERARCY_FRM_ORG_STR",connectionObject);
			OrgStructure orgStructure = new OrgStructure();
			String itemSer=checkNull(getItemSer(sprsCode, connectionObject));
			HashMap<String, String> employeeDesignationMap=null;
			DARCommonBean darCommonBean= new DARCommonBean();
			if(dbName.equalsIgnoreCase("ORACLE"))
			{
				employeeDesignationMap=darCommonBean.getEmployeeDesignationMap(itemSer,connectionObject);
				System.out.println("employeeDesignationMap is["+employeeDesignationMap+"]");
			}

			if("Y".equalsIgnoreCase(isOrgStrcture))
			{
				salesPersList = orgStructure.reportToUp(sprsCode,eventDate,connectionObject);
				salesPersTemp = orgStructure.getFormattedList(salesPersList);
			}
			
			//Changed & Added By Vikas Lagad on 23-12-2019 [Changed logic for JNJ_coaching manager in team detail form ]Start
			String teamGradeLevel = "";
			sql = "select parm_value from sfaparm WHERE parm_name = ? and active = ? ";
			PreparedStatement pstmt1= connectionObject.prepareStatement(sql);
			pstmt1.setString(1, "TEAM_GRADE_LEV");
			pstmt1.setString(2, "Y");
			ResultSet rs1= pstmt1.executeQuery();
			
			if(rs1.next())
			{
				teamGradeLevel = checkNull(rs1.getString(1));
			}
			else
			{
				teamGradeLevel = "4";
			}
			if(pstmt1 != null)
			{
				pstmt1.close();
				pstmt1 = null;
			}
			if(rs1 != null)
			{
				rs1.close();
				rs1 = null;
			}
			

			
			if(salesPersList != null && !salesPersList.isEmpty())
			{
				//sql1 ="SELECT EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO <='"+teamGradeLevel+"' ORDER BY GRADE.LEVEL_NO DESC";
				sql = "SELECT DISTINCT '2' AS SR_NO,EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO " + 
						"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
						"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
						"UNION "+
						"SELECT DISTINCT '1' AS SR_NO,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO "+
						 "FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' ORDER BY SR_NO,LEVEL_NO DESC";

			}
			else
			{
				ArrayList teamList = new ArrayList();

				String teamSql="";
				if(dbName.equalsIgnoreCase("ORACLE"))
				{
					teamSql="SELECT REPORT_TO FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR  REPORT_TO = EMP_CODE AND REPORT_TO IS NOT NULL";
				}
				else
				{
					teamSql="WITH RECURSIVE CTE_CONNECT_BY AS ( " + 
							"SELECT 1 AS LEVEL, S.* FROM EMPLOYEE S WHERE EMP_CODE = ? " + 
							"UNION ALL " + 
							"SELECT LEVEL + 1 AS LEVEL, S.* FROM CTE_CONNECT_BY R INNER JOIN EMPLOYEE S ON  r.REPORT_TO = s.EMP_CODE AND s.REPORT_TO IS NOT NULL " + 
							") " + 
							"SELECT REPORT_TO FROM CTE_CONNECT_BY " ;


				}
				
				
				PreparedStatement teamPstmt= connectionObject.prepareStatement(teamSql);
				teamPstmt.setString(1, sprsCode);
				ResultSet teamRs= teamPstmt.executeQuery();
				while(teamRs.next())
				{
					String reportTo=checkNull(teamRs.getString("REPORT_TO"));
					teamList.add(reportTo);
				}
				if(teamPstmt != null)
				{
					teamPstmt.close();
					teamPstmt = null;
				}
				if(teamRs != null)
				{
					teamRs.close();
					teamRs = null;
				}
				
				System.out.println("teamList is:"+teamList);
				
				String salesPersEmp=orgStructure.getFormattedList(teamList);
				//sql1 ="SELECT EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+teamGradeLevel+"' ORDER BY GRADE.LEVEL_NO DESC";
				if(dbName.equalsIgnoreCase("ORACLE"))
				{
					sql1 = "SELECT DISTINCT '2' AS SR_NO,EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
							 "FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"'  ORDER BY SR_NO,LEVEL_NO DESC";

				}
				else
				{
					sql1 = "SELECT DISTINCT '1' AS SR_NO,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
							"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"'  ORDER BY SR_NO,LEVEL_NO DESC";

				}
				
				

			}
			//Changed & Added By Vikas Lagad on 18-12-2019 [Changed logic for JNJ_coaching manager in team detail form]END
			// added by rupali on 13/04/18 for org_structure related changes [end]
			//System.out.println(" selectedTeam in dom vala parametr["+selectedTeam+"]");
			HashMap teamMap = new HashMap();

			String dcrID = getDCRId(connectionObject,sprsCode, eventDate);
			//System.out.println("Value of dcr id is:- -"+dcrID);

			if ( selectedTeam != null && selectedTeam.trim().length() > 0 )
			{
				//System.out.println(" selectedTeam in dom vala parametrtest lenghth["+selectedTeam.length()+"]");
				NodeList teamNodeList = ( genericUtility.parseString( selectedTeam ) ).getElementsByTagName("Detail"+formNo+"");
				int nodeListLen = teamNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					int x =1;
					NodeList innerNodeList = teamNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String selTeam = "";

					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						//System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");
						if ( "sales_pers".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								selTeam = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						if ( "name".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								name = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
					}
					//System.out.println("selectTeam details["+selTeam+"] [");
					teamMap.put( selTeam, selTeam);

					//System.out.println(" teamMap ["+teamMap+"]");
					x++;
				}
			}

			if(dcrID != null)
			{
				String checkModeSql = " SELECT MAX(LINE_NO) AS MAXLINENO,MAX(TRAN_ID) AS TRAN_ID  FROM STRG_MEET_TEAM WHERE DCR_ID= ?  AND STRG_CODE = ?";
				pstmt = connectionObject.prepareStatement(checkModeSql);
				pstmt.setString(1,dcrID);
				pstmt.setString(2,strgCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					maxLineNo = rs.getInt("MAXLINENO");
					custTranID = checkNull(rs.getString("TRAN_ID"));
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(custTranID != null)
				{
					if(custTranID.length()>0)
						modeCounter++;
				}
			}

			int num = 1;
			int lineNo=1;
			pstmt =  connectionObject.prepareStatement( sql1 );
			// added by rupali on 13/04/18 for org_structure related changes
			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String teamCode = checkNull(rs.getString("REPORT_TO"));
				String mobileNo = checkNull(rs.getString("MOBILE_NO"));

				String empName = getEmpName(teamCode, connectionObject);
				String empDesign = getDesignName(teamCode, connectionObject);
				//System.out.println("test check report: - "+teamCode);
				//String designation = checkNull(rs.getString("DESIGNATION"));
				String empNameDesign = getEmpNameDesign(teamCode, connectionObject);
				System.out.println("empNameDesign::"+empNameDesign);
				String srNo = checkNull(rs.getString("SR_NO"));
				String designation="";
				if("2".equalsIgnoreCase(srNo) && !employeeDesignationMap.isEmpty())
				{
					if(employeeDesignationMap.containsKey(teamCode))
					{
						designation=employeeDesignationMap.get(teamCode);

					}
					else
					{
						designation=empDesign;

					}
				}
				else
				{
					designation=empDesign;
				}
				if(empNameDesign!=null && empNameDesign.trim().length()>0)
				{
					empNameDesign=empNameDesign.substring(0, empNameDesign.lastIndexOf("("));
					System.out.println("empNameDesign before add designation : - "+empNameDesign);
					empNameDesign=empNameDesign +"("+designation+")";

				}
				System.out.println("empNameDesign after add designation : - "+empNameDesign);
				
				
				if ( teamMap.get( teamCode.trim() ) != null )
				{
					String data = ( String ) teamMap.get( teamCode.trim() );
					//System.out.println("value of data is inside if:- "+data);
					selectedXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'Y' formName='"+formName+"'>\r\n" );
					selectedXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03-06-15
					selectedXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
					selectedXmlString.append("<sales_pers><![CDATA[").append( data ).append("]]></sales_pers>\r\n");
					selectedXmlString.append("<name><![CDATA[").append( empName ).append("]]></name>\r\n");
					selectedXmlString.append("<sales_pers_sp_name ><![CDATA[").append( empName ).append("]]></sales_pers_sp_name>\r\n");
					selectedXmlString.append("<design_code><![CDATA[").append( empDesign ).append("]]></design_code>\r\n");
					selectedXmlString.append("<line_no><![CDATA["+num+"]]></line_no>\r\n");
					selectedXmlString.append("<tran_id><![CDATA["+custTranID+"]]></tran_id>\r\n");
					selectedXmlString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
					selectedXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
					selectedXmlString.append("<employee_designation><![CDATA[").append( designation ).append("]]></employee_designation>\r\n");
					selectedXmlString.append("<visited_with_display><![CDATA[").append( empNameDesign ).append("]]></visited_with_display>\r\n");
					selectedXmlString.append("<sp_mobile_no><![CDATA[").append( mobileNo ).append("]]></sp_mobile_no>\r\n");
					selectedXmlString.append( "</Detail"+formNo+">\r\n" );
					num++;
				}
				else
				{

					maxLineNo = maxLineNo +1;
					//System.out.println("Value of mode counter is = "+modeCounter);
					if(modeCounter == 0)
					{
						//System.out.println("Value in ifff workWithListForm{"+workWithListForm+"}teamcode value is :- {"+teamCode);

						if((workWithListForm != null) && (workWithListForm.contains(teamCode)))
						{
							unselectedString.append("<Detail"+formNo+" domID='"+maxLineNo+"' selected = 'Y' formName='"+formName+"'>\r\n" );
							unselectedString.append("<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
							unselectedString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
							unselectedString.append("<sales_pers><![CDATA[").append( teamCode ).append("]]></sales_pers>\r\n");
							unselectedString.append("<line_no><![CDATA["+maxLineNo+"]]></line_no>\r\n");
							unselectedString.append("<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
							unselectedString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
							unselectedString.append("<name><![CDATA[").append( empName ).append("]]></name>\r\n");
							unselectedString.append("<sales_pers_sp_name ><![CDATA[").append( empName ).append("]]></sales_pers_sp_name>\r\n");
							unselectedString.append("<design_code><![CDATA[").append( empDesign ).append("]]></design_code>\r\n");
							unselectedString.append("<employee_designation><![CDATA[").append( designation ).append("]]></employee_designation>\r\n");
							unselectedString.append("<visited_with_display><![CDATA[").append( empNameDesign ).append("]]></visited_with_display>\r\n");
							unselectedString.append("<sp_mobile_no><![CDATA[").append( mobileNo ).append("]]></sp_mobile_no>\r\n");

							unselectedString.append("</Detail"+formNo+">\r\n" );
						}
						else
						{
							unselectedString.append("<Detail"+formNo+" domID='"+maxLineNo+"' selected = 'N' formName='"+formName+"'>\r\n" );
							unselectedString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
							unselectedString.append("<sales_pers><![CDATA[").append( teamCode ).append("]]></sales_pers>\r\n");
							unselectedString.append("<line_no><![CDATA["+maxLineNo+"]]></line_no>\r\n");
							unselectedString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
							//unselectedString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
							unselectedString.append("<strg_code><![CDATA[").append( "" ).append("]]></strg_code>\r\n");
							unselectedString.append("<name><![CDATA[").append( empName ).append("]]></name>\r\n");
							unselectedString.append("<sales_pers_sp_name ><![CDATA[").append( empName ).append("]]></sales_pers_sp_name>\r\n");
							unselectedString.append("<design_code><![CDATA[").append( empDesign ).append("]]></design_code>\r\n");
							unselectedString.append("<employee_designation><![CDATA[").append( designation ).append("]]></employee_designation>\r\n");
							unselectedString.append("<visited_with_display><![CDATA[").append( empNameDesign ).append("]]></visited_with_display>\r\n");
							unselectedString.append("<sp_mobile_no><![CDATA[").append( mobileNo ).append("]]></sp_mobile_no>\r\n");

							unselectedString.append( "</Detail"+formNo+">\r\n" );
						}
					}

					else
					{
						//System.out.println("value of data is inside else:- ");
						unselectedString.append("<Detail"+formNo+" domID='"+maxLineNo+"' selected = 'N' formName='"+formName+"'>\r\n" );
						unselectedString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
						unselectedString.append("<sales_pers><![CDATA[").append( teamCode ).append("]]></sales_pers>\r\n");
						unselectedString.append("<line_no><![CDATA["+maxLineNo+"]]></line_no>\r\n");
						unselectedString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
						//unselectedString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
						unselectedString.append("<strg_code><![CDATA[").append("").append("]]></strg_code>\r\n");
						unselectedString.append("<name><![CDATA[").append( empName ).append("]]></name>\r\n");
						unselectedString.append("<sales_pers_sp_name ><![CDATA[").append( empName ).append("]]></sales_pers_sp_name>\r\n");
						unselectedString.append("<design_code><![CDATA[").append( empDesign ).append("]]></design_code>\r\n");
						unselectedString.append("<employee_designation><![CDATA[").append( designation ).append("]]></employee_designation>\r\n");
						unselectedString.append("<visited_with_display><![CDATA[").append( empNameDesign ).append("]]></visited_with_display>\r\n");
						unselectedString.append("<sp_mobile_no><![CDATA[").append( mobileNo ).append("]]></sp_mobile_no>\r\n");

						unselectedString.append( "</Detail"+formNo+">\r\n" );
					}
				}

			}//end of while

			valueXmlString.append(selectedXmlString);
			valueXmlString.append(unselectedString);
			//System.out.println("outside detail:- "+valueXmlString);
			if(rs != null)
			{
				rs.close(); rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close(); pstmt = null;
			}
			num = 1;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			//System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if(connectionObject != null && isLocal)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		valueXmlString.append( "</Root>\r\n" );
		//System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	//added by mrunalini sinkar to show order of visit  on summary page 2-june-2017(start)

	public int orderOfVisit(String eventDate,String salesPers,String localityCode ,Connection conn ) throws ITMException
	{
		//System.out.println("CALLING THE orderOfVisit::::");
		int orderOfVisit=0;
		try
		{
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			int count=0;
			String countSql ="SELECT COUNT(*) AS COUNT FROM SPRS_TRAVEL WHERE TRAVEL_DATE = ? AND SALES_PERS = ? AND LOCALITY_CODE = ?";
			pstmt = conn.prepareStatement(countSql);
			pstmt.setTimestamp(1,java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmt.setString(2,salesPers);
			pstmt.setString(3,localityCode);
			rs = pstmt.executeQuery();
			//System.out.println("countSqlcountSql:::>>>["+countSql+"]");
			if(rs.next())
			{
				count=rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			//System.out.println("count:::>>["+count+"]");
			if(count>0)
			{
				//System.out.println("iside if:");
				String orderVisit="SELECT ORDER_OF_VISIT FROM SPRS_TRAVEL WHERE TRAVEL_DATE=? AND SALES_PERS=? AND LOCALITY_CODE=?";
				pstmt = conn.prepareStatement(orderVisit);
				pstmt.setTimestamp(1,java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmt.setString(2,salesPers);
				pstmt.setString(3,localityCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					orderOfVisit=rs.getInt("ORDER_OF_VISIT");
					//System.out.println("order of visit is:"+orderOfVisit);
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			else
			{
				//System.out.println("iside else:");
				int maxVisit = 0;
				String orderVisit="SELECT MAX(ORDER_OF_VISIT) AS ORDER_OF_VISIT FROM SPRS_TRAVEL WHERE TRAVEL_DATE=? AND SALES_PERS=?";
				pstmt = conn.prepareStatement(orderVisit);
				pstmt.setTimestamp(1,java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmt.setString(2,salesPers);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					maxVisit = rs.getInt("ORDER_OF_VISIT");
					//System.out.println("max visit is:"+maxVisit);
					orderOfVisit = maxVisit+1;
					//System.out.println("order of visit is:"+orderOfVisit);
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}

			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}

		return orderOfVisit;
	}
	//added by mrunalini sinkar to show order of visit  on summary page 2-june-2017(end)

	private String getEmpName(String empCode,Connection conn) throws ITMException
	{
		String name=null;
		String employeCode = null;
		try
		{
			String dbName =CommonConstants.DB_NAME; 
			String nameSql="";
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			if(dbName.equalsIgnoreCase("ORACLE"))
			{
				nameSql = "SELECT UPPER(EMP_FNAME) ||' ' ||UPPER(EMP_MNAME) ||' '|| UPPER(EMP_LNAME) AS EMP_NAME,EMP_CODE from employee 	WHERE EMP_CODE= ? ";

			}
			else
			{
				nameSql = "SELECT CONCAT(IFNULL(EMP_FNAME,''),' ',IFNULL(EMP_MNAME,''),' ',IFNULL(EMP_LNAME,''))AS EMP_NAME, EMP_CODE from employee 	WHERE EMP_CODE= ? ";

			}
			pstmt = conn.prepareStatement(nameSql);

			pstmt.setString(1,empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				name = checkNull(rs.getString("EMP_NAME"));
				employeCode = checkNull(rs.getString("EMP_CODE"));
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return name +"("+employeCode+")";
	}

	private String getDesignName(String empCode,Connection conn) throws ITMException
	{
		String designation="";
		try
		{
			PreparedStatement pstmt = null;
			ResultSet rs = null;

			String nameSql = "SELECT DESIGN_CODE FROM EMPLOYEE WHERE EMP_CODE= ? ";
			pstmt = conn.prepareStatement(nameSql);

			pstmt.setString(1,empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				designation = checkNull(rs.getString("DESIGN_CODE"));
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return designation;
	}
	public String getCallNoteTypes( String xmlString, String xtraParams) throws ITMException
	{
		//System.out.println("in getCallNoteTypes");
		String listType = "";
		PreparedStatement pstmtNoteType = null;
		ResultSet rsNoteType = null;
		Connection conn = null;
		String noteType = "";
		String descr = "";
		String shDescr = "";
		String colorCode = "";
		JSONObject jsonObj = new JSONObject();
		String jSonKey="";
		try
		{
			JSONObject jsonNoteTypeObj = new JSONObject();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			Document dom=genericUtility.parseString(xmlString);
			//System.out.println("Dom >>>:: "+dom);
			//System.out.println("xmlString>>>::"+xmlString);
			jSonKey=genericUtility.getColumnValue("scope_object",dom);
			//System.out.println("jSonKey>>>::"+jSonKey);
			if(jSonKey==null || jSonKey.trim().length()==0)  // changed by rupali on 06/03/17
			{
				jSonKey="JSON";
			}
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );*/
			conn = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
			String noteTypeSql = "SELECT NOTE_TYPE, DESCR, SH_DESCR, REQ_FOLL_UP, TASK_TYPE, COLOR_CODE FROM CALL_NOTE_TYPE ORDER BY SEQ_NO";
			pstmtNoteType = conn.prepareStatement(noteTypeSql);
			rsNoteType = pstmtNoteType.executeQuery();
			while(rsNoteType.next())
			{
				noteType = checkNull(rsNoteType.getString("NOTE_TYPE"));
				descr = checkNull(rsNoteType.getString("DESCR"));
				shDescr = checkNull(rsNoteType.getString("SH_DESCR"));
				colorCode = checkNull(rsNoteType.getString("COLOR_CODE"));
				jsonNoteTypeObj.put(noteType, shDescr+","+colorCode);
			}
			//System.out.println("jSonKey>>>::"+jSonKey);
			jsonObj.put(jSonKey, jsonNoteTypeObj);
			//System.out.println("jsonConvertedData ::"+jsonObj.toString());
		}
		catch(Exception e)
		{
			System.out.println("Exception in getcallnotetype ::"+e.getMessage());
			throw new ITMException(e);//addde by mrunalini sinkar on 11-04-2018
		}
		finally
		{
			try
			{
				if(rsNoteType != null)
				{
					rsNoteType.close();
					rsNoteType = null;
				}
				if(pstmtNoteType != null)
				{
					pstmtNoteType.close();
					pstmtNoteType = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return jsonObj.toString();
	}

	private String generateCustomerCode( Connection conn ) throws ITMException
	{
		String uniqueKey = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{

			//System.out.println("StrgSerStatusHistBean : Generating Primary Key ...........");

			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_wsfa_strg_customer' ";
			pstmt = conn.prepareStatement(keyStringQuery);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				String keyString = rs.getString("KEY_STRING");
				String keyCol = rs.getString("TRAN_ID_COL");
				String tranSer = rs.getString("REF_SER");
				String xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
				xmlValues = xmlValues + "<Header></Header>";
				xmlValues = xmlValues + "<Detail1>";
				xmlValues = xmlValues +        "<sc_code></sc_code>";
				xmlValues = xmlValues + "</Detail1></Root>";
				TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
				uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			}
			rs.close();	rs = null;
			pstmt.close();
			pstmt = null;

		}
		catch(Exception exp)
		{
			System.out.println("Exception : StrgSerStatusHistBean :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : StrgSerStatusHistBean :getUniqueKey :finally==>");
				throw new ITMException(e);
			}
		}
		//System.out.println("Generated Primary Key :"+uniqueKey);
		return uniqueKey;
	}
	//added by mrunalini sinkar if dcr is alerdy confirm then same date scond dcr not allow(start)

	public String wfValSalesPersAct(Document dom, Document dom2, String currentFormNo, String userId,Connection connectionObject) throws ITMException //chnged by sachin satre on [9-nov-16] to get connection
	{
		//System.out.println("inside wfValSalesPersAct ");
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String updateFlag="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String errString = "";
		String errStringNew = "";
		String checkSQL = "";
		String childNodeName = "";
		String columnValue = "";

		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;//modified by kailash.
		boolean isLocalConn=false;
		int noOfChilds = 0;
		try
		{
			String dbName =CommonConstants.DB_NAME; //added by rupali on 15/09/17 for worked with field

			if(connectionObject == null)
			{
				connectionObject = getConnection();
				isLocalConn=true;
			}

			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal=new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
			int parentNodeListLength = parentList.getLength();

			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}

					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("event_date"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("event_date","NULLEVTCOD",userId);
							break;
						}
						else
						{
							SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
							java.util.Date eventDate = sdfFormat.parse( childNode.getFirstChild().getNodeValue());
							String evtdat=childNode.getFirstChild().getNodeValue();
							if (!sdfFormat.format(eventDate).equals(evtdat))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
								break;
							}

							// added by mrunalini sinkar for allowing future_date to particular activity code on 01-04-2019(start) 
							String futureDate="";
							String eventType = checkNull(genericUtility.getColumnValue( "event_type" , dom2 ,currentFormNo));
							String itemSer = getItemSer(userId,connectionObject);
							//String actSql = " SELECT FUTURE_DATE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? AND ITEM_SER = ? ";
							String actSql ="";
							if(dbName.equalsIgnoreCase("ORACLE"))
							 {
									actSql = "SELECT FUTURE_DATE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? "+
											 "AND (ITEM_SER IS NULL OR ITEM_SER = 'ALL' OR ITEM_SER = ?) "+
											 "AND (SITE_CODE IS NULL OR SITE_CODE = 'ALL' OR (SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE = ?) IN "+
											 "(SELECT REGEXP_SUBSTR(SITE_CODE,'[^,]+', 1, LEVEL) FROM DUAL CONNECT BY REGEXP_SUBSTR(SITE_CODE, '[^,]+', 1, LEVEL) IS NOT NULL) ) "+
											 "ORDER BY DESCR ";
									pstmt = connectionObject.prepareStatement(actSql);
									pstmt.setString(1, eventType);
									pstmt.setString(2, itemSer);  
									pstmt.setString(3, userId);  
									rSet = pstmt.executeQuery();
									if (rSet.next())
									{
										futureDate =  checkNull(rSet.getString("FUTURE_DATE"));
									}
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}

							 }
							 else
							 {
								 actSql = " SELECT FUTURE_DATE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
									pstmt = connectionObject.prepareStatement(actSql);
									pstmt.setString(1, eventType);
									rSet = pstmt.executeQuery();
									if (rSet.next())
									{
										futureDate =  checkNull(rSet.getString("FUTURE_DATE"));
									}
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
							 }

							
							// added by mrunalini sinkar for allowing future_date to particular activity code on 01-04-2019(end)
							//if ( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 )
							if (( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 && (futureDate.equalsIgnoreCase("0") || futureDate.trim().length() == 0)))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "FUTUREVENT", userId );
								break;
							}


							String salesPers =checkNull( genericUtility.getColumnValue( "sales_pers" , dom2 ,currentFormNo));
							String dcrDate = checkNull(genericUtility.getColumnValue( "event_date" , dom2 ,currentFormNo));

							


							int allowDays = 0;
							String propName = "MAX_ALLOW_PRD_MEET";
							checkSQL = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ? ";
							pstmt = connectionObject.prepareStatement(checkSQL);
							pstmt.setString(1, propName);
							rSet = pstmt.executeQuery();
							if( rSet.next() )
							{
								allowDays = rSet.getInt("PROP_VALUE");

								java.util.Calendar cal = java.util.Calendar.getInstance();
								java.util.Date currDate = new java.util.Date();
								cal.setTime( currDate );
								cal.add( cal.DATE, -allowDays );
								if( eventDate.before( cal.getTime() ) )
								{
									errString = itmDBAccessLocal.getErrorString( "event_date" , "XCIDMITLMT" , userId );
									break;
								}
							}
							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}


							String eventdate = childNode.getFirstChild().getNodeValue();


							String activityCode = checkNull(genericUtility.getColumnValue( "event_type" , dom2 ));
							String activityType = checkNull(genericUtility.getColumnValue( "activity_type" , dom2 ));
							//System.out.println("before activityCode"+ activityCode);
							//System.out.println("before activity"+ activityType);
							if(activityCode==null || activityCode.length()==0)
							{
								errString = itmDBAccessLocal.getErrorString("event_type","NULLACTCOD",userId);
								break;
							}

							if(activityType==null || activityType.length()==0)
							{
								String sql= "select activity_type from fieldactivity where activity_code= ?";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, activityCode);
								rSet = pstmt.executeQuery();
								if( rSet.next() )
								{
									activityType= checkNull(rSet.getString("ACTIVITY_TYPE"));
									//System.out.println("In If"+ activityType);
								}
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}

							}
							if( salesPers != null && evtdat != null )
							{
								// commented and added by Rupali on 04/12/17 for defining sfaparam value for sequential reporting[start]
								/*errStringNew = checkSequentialReporting(connectionObject, salesPers, evtdat);
								if(errStringNew != null && errStringNew.indexOf("<Errors>") != -1)
								{
									errString = errStringNew;
									break;
								}*/
								//commented by mrunalini sinkar for adding irg unit condition in case of sequential dar(start)
								/*String parmValue = "";
								SimpleDateFormat dtFormat = new SimpleDateFormat(genericUtility.getDBDateTimeFormat());
								String currDate = dtFormat.format(new java.util.Date());
								String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='SEQUENTIAL_DAR' AND ? BETWEEN EFF_FROM AND VALID_UPTO AND ACTIVE='Y' ";
								PreparedStatement pstmtSfaParm = connectionObject.prepareStatement(sfaParmSql);
								pstmtSfaParm.setTimestamp(1, java.sql.Timestamp.valueOf(currDate));
								ResultSet rsSfaParm = pstmtSfaParm.executeQuery();
								if (rsSfaParm.next())
								{
									parmValue = checkNull(rsSfaParm.getString("PARM_VALUE"));
								}
								if(rsSfaParm != null)
								{
									rsSfaParm.close();
									rsSfaParm = null;
								}
								if(pstmtSfaParm != null)
								{
									pstmtSfaParm.close();
									pstmtSfaParm = null;
								}*/
								//commented by mrunalini sinkar for on 21-Feb-2018 adding irg unit condition in case of sequential dar(start)
								boolean seqDAR=true;
								String parmValue = getSfaParmValue(userId,"SEQUENTIAL_DAR",connectionObject); // added by mrunalini sinkar on 21-Feb-2018(start)
								String designation = checkNull(genericUtility.getColumnValue( "emp_design" , dom2,"1"));
								String seqDesignCode = checkNull(getSfaParmValue(salesPers,"SEQ_DAR_NO_MANDATE",connectionObject)); 
								String event = checkNull(genericUtility.getColumnValue( "event_type" , dom2,"1" ));
								System.out.println("designation code is:["+designation+"]event["+event+"]");
								if(seqDesignCode!=null && seqDesignCode.trim().length()!=0)
								{
									String [] temp = seqDesignCode.split(",");
									for(int i = 0 ;i < temp.length;i++)
									{
										String designCodeName=checkNull(temp[i]);
										if(designation.equalsIgnoreCase(designCodeName) && "CA".equalsIgnoreCase(event))
										{
											seqDAR=false;
											break;
										}
									}
								}
										
								
								System.out.println("seqDAR is:["+seqDAR+"]");
								if(seqDAR)
								{
									if(parmValue.equalsIgnoreCase("Y"))
									{
										errStringNew = checkSequentialReporting(connectionObject, salesPers, evtdat);
										if(errStringNew != null && errStringNew.indexOf("<Errors>") != -1)
										{
											errString = errStringNew;
											break;
										}
									}
								}
								//System.out.println("In 1 If parmValue is"+ parmValue);

								// commented and added by Rupali on 04/12/17 for defining sfaparam value for sequential reporting[end]
								//Added by mrunalini sinkar for adding Sun Changes on 1-april-2019(END)

								int maxUnconfAllow=0;
								String parmVal = getSfaParmValue(userId, "UNCONF_DAR", connectionObject);
								System.out.println("UNCONF_DAR IS["+parmVal+"]");
								if (parmVal.trim().length() > 0)										
								{
									try
									{
										maxUnconfAllow = Integer.parseInt(parmVal.trim());
									}
									catch (NumberFormatException ne)
									{
										maxUnconfAllow = 0;
									}	
								}
								System.out.println("maxUnconfAllow IS["+maxUnconfAllow+"]");
								/*if(maxUnconfAllow>0)
								{
									String unConfDcrDates="";
									int DARCount=0;
									String selectConfirmSql = "SELECT DISTINCT EVENT_DATE FROM SPRS_ACT_TRAN  WHERE SALES_PERS = ? " +
											" AND (CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END ) <> 'Y'" +
											" AND  EVENT_DATE < ? ORDER BY EVENT_DATE ";
									PreparedStatement pstmtSelect = connectionObject.prepareStatement(selectConfirmSql);
									pstmtSelect.setString(1, salesPers);
									pstmtSelect.setTimestamp( 2, java.sql.Timestamp.valueOf(dcrDate));
									ResultSet resultSelect = pstmtSelect.executeQuery();
									while(resultSelect.next())
									{
										DARCount++;
										String unConfDcrDate = (resultSelect.getString("EVENT_DATE")) == null ?"":resultSelect.getString("EVENT_DATE").trim();
										unConfDcrDate = genericUtility.getValidDateString( unConfDcrDate, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat() );
										unConfDcrDates += unConfDcrDate+",";

									}
									resultSelect.close(); resultSelect = null;
									pstmtSelect.close(); pstmtSelect = null;
									System.out.println( "Event Dates >>> ["+unConfDcrDates+"] DARCount["+DARCount+"]");
									//if(count >=3)
									if(DARCount >= maxUnconfAllow)
									{
                                        errString = itmDBAccessLocal.getErrorString("sales_pers","DCRUNCONFD",userId);
										errString = getModifiedErrorString(errString, unConfDcrDates);
                                        String message=getMsgDescr("DCRUNCONFD",connectionObject);
										errString = "";
										String messageValue ="\r\n"+message+"\n"+unConfDcrDates;
										StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
										valueXmlErrorString.append("<error id=\"DCRUNCONFD\" type=\"E\" >");
										valueXmlErrorString.append("<message><![CDATA[").append("").append("]]></message>\r\n");
										valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
										valueXmlErrorString.append("<type>E</type>\r\n");
										valueXmlErrorString.append("<option></option>\r\n");
										valueXmlErrorString.append("<time></time>\r\n");
										valueXmlErrorString.append("<alarm></alarm>\r\n");
										valueXmlErrorString.append("<source></source>\r\n");
										valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
										valueXmlErrorString.append("<redirect>1</redirect>\r\n");
										valueXmlErrorString.append("</error>\r\n");
										valueXmlErrorString.append("</Errors>\r\n");
										valueXmlErrorString.append("</Header>\r\n");
										valueXmlErrorString.append( "</Root>\r\n" );
										//System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
										errString =valueXmlErrorString.toString();
										return errString;
									}
								}*/
								//Added by mrunalini sinkar for adding Sun Changes on 1-april-2019(END)
								
								int actCount = 0;
								String sql= "select activity_type,count(*) as count from fieldactivity where activity_code= ? group by activity_type";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, activityCode);
								rSet = pstmt.executeQuery();
								if( rSet.next() )
								{
									activityType= checkNull(rSet.getString("ACTIVITY_TYPE"));
									actCount = rSet.getInt("count");
									//System.out.println("In If"+ activityType);
								}
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								// added by Atish Rane for not display Holiday error in edit mode  changes on 26-Aug-2019(start)

								if(!updateFlag.equalsIgnoreCase("E"))
								{
								errString = valHoliday( evtdat, salesPers, userId, itmDBAccessLocal, connectionObject,"");
								if(errString != null && errString.length()>0 && (errString.indexOf("ERRORS")!=-1 || errString.indexOf("Errors")!=-1))
								{
									//System.out.println("CAME HERE");
									//System.out.println("activity"+ activityType);
									if(actCount == 0)
									{
										errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNOTFND", userId );
										break;
									}
									if(activityType !=null && activityType.length() > 0 && "LEAVE".equalsIgnoreCase(activityType))
									{
										//System.out.println("Checking leave not allowed");
										errString = itmDBAccessLocal.getErrorString("event_type","LVENOTALOW",userId);
										break;
									}

									else
									{
										//System.out.println("Checking leave not allowed--- in else");
										errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
									}

									//System.out.println("Holiday!");
									break;

								}

							}
								// added by Atish Rane for not display Holiday error in edit mode  changes on 26-Aug-2019(end)


						}

					}
				}
				if(errString.indexOf("<Errors>")!=-1)
				{
					break;
				}
			}
		}
		}
		catch(Exception e)
		{
			System.out.println ( "Exception :WsfaZuviusDsrWizardEJB :wfValData():" + e.getMessage() + ":" );

			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;
	}
	//added by mrunalini sinkar if dcr is alerdy confirm then same date scond dcr not allow(end)

	public String getSelectedRowVal(Document dom,String formNo, String colName, int rowNo) throws ITMException
	{
		NodeList detailList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		int	detailListLength = 0;
		int noOfChilds = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+formNo);
			//System.out.println("detailList....."+detailList);
			detailListLength = detailList.getLength();
			parentNode = detailList.item(rowNo);
			//System.out.println("parentNode....."+parentNode);
			elementAttr = (Element)parentNode;
			childList = parentNode.getChildNodes();
			//System.out.println("childList....."+childList);
			noOfChilds = childList.getLength();

			if ( parentNode != null )
			{
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(colName) )
					{
						if(childNode.getFirstChild()!=null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
							break;
						}
					}
				}
			}

			if(columnValue == null)
				columnValue = "";

		}
		catch( Exception exp )
		{
			exp.printStackTrace();
		}

		return columnValue;
	}
	private String getModifiedErrorString(String errString, String modifiedString)
	{
		String xmlStr1 = "";
		String xmlStr2 = "";
		//String xmlStr3 = "";
		try
		{
			if(errString.indexOf("<trace>") != -1)
			{
				xmlStr1 = errString.substring(0,errString.indexOf("<trace>"));
				//xmlStr3 = errString.substring(errString.indexOf("<description>")+"<description>".length(),errString.indexOf("</description>"));
				xmlStr2 = errString.substring(errString.indexOf("</trace>")+"</trace>".length());

				modifiedString = "<trace>" + modifiedString + "</trace>";

				errString = xmlStr1 + modifiedString + xmlStr2;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		//System.out.println("getModifiedErrorString >> errString ::"+errString);
		return errString;
	}



	public String getShDescr(String type,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String shDescr = "";
		try
		{

			String sql  = "SELECT SH_DESCR FROM STRG_CUST_TYPE WHERE TYPE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, type);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				shDescr = checkNull(rs.getString("SH_DESCR"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018
		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("shDescr val:- "+shDescr);
		return shDescr;
	}

	public String getStanCodeFrom( Connection con, String userId, String currDate,String check ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String localityCodeFrom = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn=false;
		try
		{
			if(con == null)
			{
				con =getConnection();
				isLocalConn=true;
			}
			//Added by kailash on 04-03-19 [start]
			String travelDate = "";
			String maxTravelDt = "SELECT MAX(TRAVEL_DATE) AS TRAVEL_DATE FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE <= ?";
			pstmt =  con.prepareStatement(maxTravelDt);
			pstmt.setString(1, userId );
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString(currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				travelDate = checkNull(rs.getString("TRAVEL_DATE"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(travelDate != null && travelDate.trim().length() > 0) // added this condtion if travel date is blanck then exception is occured
			{
				//Added by kailash on 04-03-19 [end]

				//Change done by kailash on 04-03-19[start]
				/*String stanCodeSql = "SELECT ST.LOCALITY_CODE FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
						" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+
						" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=? AND TRAVEL_DATE <= ?) ) "+
						" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
						" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=? AND TRAVEL_DATE <= ?)";*/
				String stanCodeSql = "SELECT ST.LOCALITY_CODE FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
						" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+
						" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE = ? ) "+
						" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
						" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  = ? ";
				pstmt =  con.prepareStatement(stanCodeSql);
				pstmt.setString(1, userId );
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf(travelDate) );
				pstmt.setString(3, userId );
				pstmt.setTimestamp( 4, java.sql.Timestamp.valueOf(travelDate) );
				//Change done by kailash on 04-03-19[end]
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					localityCodeFrom = rs.getString(1);
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			//added by  mrunalini sinakr to get locality if salesperson first time report(start)
			else
			{
				String stanCodeHq="";
				String sqlHq = "select stan_code__hq from employee where emp_code= ? ";
				pstmt = con.prepareStatement( sqlHq );
				pstmt.setString(1, userId);
				 rs = pstmt.executeQuery();
				if ( rs.next() )
				{
					stanCodeHq =   checkNull(rs.getString("stan_code__hq"));
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				String getLocalitySql = "SELECT SR.LOCALITY_CODE FROM SPRS_ROUTE SR,LOCALITY LOC "
						+ "WHERE SR.STAN_CODE = ? AND SR.SPRS_CODE = ? AND SR.STATUS='Y' AND SR.LOCALITY_CODE = LOC.LOCALITY_CODE ";

				pstmt = con.prepareStatement(getLocalitySql);
				pstmt.setString(1, stanCodeHq);
				pstmt.setString(2, userId);

				 rs = pstmt.executeQuery();
				if(rs.next())
				{
					localityCodeFrom =   checkNull(rs.getString("LOCALITY_CODE"));
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			//added by  mrunalini sinakr to get locality if salesperson first time report(end)
			

		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( isLocalConn && con != null && ! con.isClosed() )
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :RealTimeReportEJB :getStanCodeFrom :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return localityCodeFrom;
	}
	public String getDefaultTravelMode(String sprsCode, String eventdate, String localityCode, Connection connectionObject ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn=false;
		String travelMode = "";
		int holCnt = 0;
		int dayNo = 0;
		try
		{
			if(connectionObject == null)
			{
				connectionObject =getConnection();
				isLocalConn=true;
			}
			String locCodeFrom = getStanCodeFrom( connectionObject, sprsCode, eventdate, "");

			Date dateNo = new SimpleDateFormat(genericUtility.getApplDateFormat()).parse(eventdate);
			System.out.println(eventdate+"\t"+dateNo);
			SimpleDateFormat format = new SimpleDateFormat("dd");
			int monthDay=Integer.parseInt(format.format(dateNo));
			System.out.println(monthDay);

			String holDayCnt = "SELECT COUNT(*) AS COUNT FROM HOLIDAY, PERIOD WHERE HOL_DATE BETWEEN FR_DATE AND ? AND CODE = (SELECT CODE FROM PERIOD WHERE ? "+
					"BETWEEN FR_DATE AND TO_DATE) AND HOLIDAY.DESCR = 'SUNDAY' AND HOL_TBLNO = (SELECT HOL_TBLNO FROM EMPLOYEE WHERE EMP_CODE = ?)";
			pstmt = connectionObject.prepareStatement(holDayCnt);
			pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventdate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventdate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmt.setString(3,sprsCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				holCnt = rs.getInt("COUNT");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			dayNo = monthDay - holCnt;

			String trvModeSql = "SELECT TRV_MODE FROM SPRS_TOUR_PLANDET WHERE TRAN_ID = (SELECT MAX(TRAN_ID) FROM SPRS_TOUR_PLAN WHERE SALES_PERS= ? "+
					"AND PRD_CODE__FROM = (SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE)) AND FROM_LOCALITY = ? AND TO_LOCALITY = ? AND DAY_NO = ?";
			pstmt = connectionObject.prepareStatement(trvModeSql);
			pstmt.setString(1,sprsCode);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventdate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmt.setString(3,locCodeFrom);
			pstmt.setString(4,localityCode);
			pstmt.setInt(5,dayNo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				travelMode = checkNull(rs.getString("TRV_MODE"));
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :RealTimeReportEJB :getTravelMode :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return travelMode;
	}
	
	

	
	
	
	
	

	public String getSurveyDetails( Document dom, Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams, Connection connectionObject ,String formNo,String formName,String surveyTemplate) throws ITMException //Chnaged by sachin satre on 09-nov-16
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID = 1;
		int num = 0;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "";
		String selectedItem = "";
		String dcrId="";
		String sql="";
		String userId="";
		String dcrID="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn =false;
		try
		{
			if(connectionObject ==  null )
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if( "".equalsIgnoreCase( checkNull( salePersCode ) ) )
			{
				salePersCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			}


			String [] temp = scCode.split(",");
			if ( preDomExists( dom2, formNo ))
			{
				selectedItem = getPrevFormValues( dom2, formNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
			}
			else
			{
				String newScCode = "";
				if(scCode != null && scCode.trim().length() > 0 && scCode.indexOf("'") == -1)
				{
					newScCode = "'"+scCode+"'";
				}
				else
				{
					newScCode = scCode;
				}
				System.out.println("bfor getExistingSurveyDetail selectedItem>>>"+selectedItem);
				selectedItem = getExistingSurveyDetail( salePersCode, wrkDate , newScCode,formNo ,formName,connectionObject) ; //Chnaged by sachin satre on 09-nov-16
			}
			selectedItem = "<Root>" + selectedItem + "</Root>";
			//System.out.println("selectedItem>>>"+selectedItem);
			System.out.println("after getExistingSurveyDetail>>>"+selectedItem);
			String itemDetails = getSurveyList(dom, salePersCode, scCode, selectedItem, wrkDate,formNo,formName,surveyTemplate );

			//System.out.println("itemDetails>>>"+itemDetails);
			valueXmlString.append(itemDetails);
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
			e.printStackTrace();
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:defaultDataDAR :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("Return valueXmlString===>"+valueXmlString);
		return valueXmlString.toString();

	}
}