/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.TemplateDetails;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.UploadFileEJB;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import jxl.Cell;
import jxl.Range;
import jxl.Sheet;
import jxl.Workbook;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UploadTemplateMapping {
    private E12GenericUtility genericUtility = new E12GenericUtility();
    private UserInfoBean userInfo = null;
    private DBAccessEJB dbAccessEJB = new DBAccessEJB();
    private final String COLUMN_SEPARATOR = ":";
    private String objName = "";
    private String templateName = "";
    private String templateKey = "";
    private HashMap<String, String> sheetDetailMap = null;
    private boolean isAutoConfirm = false;

    public UploadTemplateMapping(UserInfoBean userInfo) {
        this.userInfo = userInfo;
        this.objName = "";
        this.templateName = "";
    }

    public String setTemplateDetails(String objName, String templateName, UserInfoBean userInfo) throws RemoteException, ITMException {
        String responseStr = "<Root><Detail>Success</Detail></Root>";
        this.objName = objName;
        this.templateName = templateName;
        UploadFileEJB uploadFile = new UploadFileEJB();
        HashMap<String, HashMap<String, String>> templateDetailMap = uploadFile.getTemplateDetail(objName, "Process_Temp", templateName, userInfo);
        uploadFile = null;
        if (templateDetailMap == null) {
            responseStr = this.genericUtility.getErrorString("", "NOTEMPRHGT", userInfo.getLoginCode());
        } else if (templateDetailMap != null && templateDetailMap.size() == 0) {
            responseStr = this.genericUtility.getErrorString("", "FILEMAPNOE", userInfo.getLoginCode());
        } else {
            this.templateKey = String.valueOf(objName) + "::" + templateName;
            this.setObjectDetail(userInfo);
            int totalForms = TemplateDetails.get(objName).getNoOfForms();
            TemplateDetails.get(objName).setTemplateMap(templateDetailMap);
            String templateXML = TemplateDetails.get(objName).getTemplateXml(templateName);
            String fileMappingXml = TemplateDetails.get(objName).getFileMapping(templateName);
            this.isAutoConfirm = TemplateDetails.get(objName).isAutoConfirm(templateName);
            TemplateDetails.get(this.templateKey).createTemplateDetail(templateXML, totalForms);
            TemplateDetails.get(this.templateKey).createFileMappingDetail(fileMappingXml);
            this.sheetDetailMap = TemplateDetails.get(this.templateKey).getSheetDetailMap();
        }
        return responseStr;
    }

    private void setObjectDetail(UserInfoBean userInfo) throws ITMException {
        HashMap<String, Object> objDetailMap = new HashMap<String, Object>();
        try {
            HashMap tranSetupDtlMap = this.getDBAccess().getObjDetailMap(this.objName, userInfo);
            DWFactory dws = new DWFactory(userInfo);
            ArrayList objFormsDetailList = this.getDBAccess().getObjFormsDetailList(this.objName, userInfo);
            HashMap<String, String> formWisePkFldNameMap = new HashMap<String, String>();
            HashMap<String, HashMap> formWiseColLogNameSizeMap = new HashMap<String, HashMap>();
            HashMap<String, HashMap<String, String>> dbWiseColLogNameTypeMap = new HashMap<String, HashMap<String, String>>();
            HashMap<String, HashMap> formWiseDropDownColValueMap = new HashMap<String, HashMap>();
            HashMap<String, HashMap> formWiseFieldCaseValueMap = new HashMap<String, HashMap>();
            HashMap<String, HashMap> formWiseFieldPrecisionValueMap = new HashMap<String, HashMap>();
            HashMap<String, HashMap> metadataWiseColLogNameTypeMap = new HashMap<String, HashMap>();
            HashMap<String, String> formNameMap = new HashMap<String, String>();
            int noOfForms = objFormsDetailList.size();
            int formNo = 0;
            while (formNo < noOfForms) {
                String formPkFldName;
                ArrayList currFormDetailList = (ArrayList)objFormsDetailList.get(formNo);
                String objContext = (String)currFormDetailList.get(14);
                String pkFldName = "";
                if ("1".equals(objContext)) {
                    pkFldName = this.checkNull((String)tranSetupDtlMap.get("TRAN_ID_COL"));
                }
                if ((formPkFldName = this.checkNull("" + currFormDetailList.get(27))).length() > 0) {
                    pkFldName = formPkFldName;
                }
                pkFldName = pkFldName.replaceAll(",", ":");
                pkFldName = pkFldName.toLowerCase();
                BaseLogger.log("3", userInfo, null, "objContext : [" + objContext + "], pkFldName : [" + pkFldName + "]");
                formWisePkFldNameMap.put(objContext, pkFldName);
                String formName = this.checkNull("" + currFormDetailList.get(32));
                BaseLogger.log("3", userInfo, null, "objContext : [" + objContext + "], formName : [" + formName + "]");
                formNameMap.put(objContext, formName);
                if (formName.length() == 0) {
                    formName = objContext;
                }
                String metaDataFileName = String.valueOf(this.objName) + "2" + formName;
                DWObject dwObj = dws.getDataWindow(metaDataFileName);
                if (pkFldName.length() == 0) {
                    ArrayList primaryKeyLogNameList = dwObj.getPrimaryKeyLogNameList();
                    StringBuffer pkFieldNameBuff = new StringBuffer();
                    int i = 0;
                    while (i < primaryKeyLogNameList.size()) {
                        String pkFieldName = (String)primaryKeyLogNameList.get(i);
                        pkFieldNameBuff.append(pkFieldName).append(":");
                        ++i;
                    }
                    pkFldName = pkFieldNameBuff.toString();
                    formWisePkFldNameMap.put(objContext, pkFldName);
                }
                HashMap colLogNameSizeMap = dwObj.getColLogNameSizeMap();
                formWiseColLogNameSizeMap.put(objContext, colLogNameSizeMap);
                HashMap metadataColLogNameTypeMap = dwObj.getColLogNameTypeMap();
                metadataWiseColLogNameTypeMap.put(objContext, metadataColLogNameTypeMap);
                String tableName = dwObj.getTableToBeUpdated();
                BaseLogger.log("3", userInfo, null, "tableName : [" + tableName + "]");
                HashMap<String, String> dbColLogNameTypeMap = this.getDBAccess().getColLogNameTypeMap(tableName, userInfo);
                BaseLogger.log("3", userInfo, null, "DBColLogNameTypeMap : [" + dbColLogNameTypeMap + "]");
                dbWiseColLogNameTypeMap.put(objContext, dbColLogNameTypeMap);
                HashMap dropDownColValueMap = dwObj.getDropDownColValueMap();
                formWiseDropDownColValueMap.put(objContext, dropDownColValueMap);
                HashMap fieldCaseValueMap = dwObj.getFieldCaseValueMap();
                formWiseFieldCaseValueMap.put(objContext, fieldCaseValueMap);
                HashMap fieldPrecisionValueMap = dwObj.getFieldPrecisionValueMap();
                formWiseFieldPrecisionValueMap.put(objContext, fieldPrecisionValueMap);
                dwObj.remove();
                dwObj = null;
                ++formNo;
            }
            objDetailMap.put("TOTAL_FORMS", noOfForms);
            objDetailMap.put("PK_NAME", formWisePkFldNameMap);
            objDetailMap.put("FORM_NAME", formNameMap);
            objDetailMap.put("TRANSETUP", tranSetupDtlMap);
            objDetailMap.put("COLUMN_SIZE", formWiseColLogNameSizeMap);
            objDetailMap.put("COLUMN_TYPE_DB", dbWiseColLogNameTypeMap);
            objDetailMap.put("COLUMN_TYPE_METADATA", metadataWiseColLogNameTypeMap);
            objDetailMap.put("COLUMN_TYPE_VALUES", formWiseDropDownColValueMap);
            objDetailMap.put("FIELD_CASE_VALUES", formWiseFieldCaseValueMap);
            objDetailMap.put("FIELD_PRECISION_VALUES", formWiseFieldPrecisionValueMap);
            dws = null;
            BaseLogger.log("3", userInfo, null, "objDetailMap [" + objDetailMap + "]");
            TemplateDetails.get(this.objName).setObjDetailMap(objDetailMap);
            this.createExcelColumnMap(noOfForms);
        }
        catch (RemoteException e) {
            throw new ITMException(e);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    private void createExcelColumnMap(int noOfForms) throws ITMException {
        try {
            BaseLogger.log("3", null, null, "noOfForms [ " + noOfForms + "]");
            HashMap actualColListMap = new HashMap();
            HashMap<Integer, ArrayList<String>> allActualColListMap = new HashMap<Integer, ArrayList<String>>();
            int tabNo = 0;
            while (tabNo < noOfForms) {
                int formNo = tabNo + 1;
                BaseLogger.log("3", null, null, "createExcelColumnMap formNo [" + formNo + "]");
                HashMap<String, String> colListMap = this.getActualColListMap(this.objName, formNo);
                BaseLogger.log("3", null, null, "colListMap - [" + colListMap + "]");
                ArrayList<String> actualColList = new ArrayList<String>();
                LinkedHashMap<String, String> actualColMap = new LinkedHashMap<String, String>();
                for (Map.Entry<String, String> entry : colListMap.entrySet()) {
                    String codeName = entry.getKey();
                    String simpleName = entry.getValue();
                    if (codeName.indexOf(46) != -1) {
                        codeName = codeName.substring(codeName.indexOf(46) + 1);
                    }
                    actualColMap.put(codeName, simpleName);
                    actualColList.add(codeName);
                }
                BaseLogger.log("3", null, null, "actualColMap - [" + actualColMap + "]");
                actualColListMap.put(formNo, actualColMap);
                BaseLogger.log("3", null, null, "actualColList - [" + actualColList + "]");
                allActualColListMap.put(formNo, actualColList);
                ++tabNo;
            }
            TemplateDetails.get(this.templateKey).setActualColListMap(allActualColListMap);
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Exception :: createExcelColumnMap : [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    private HashMap<String, String> getActualColListMap(String objName, int tabNo) throws ITMException {
        LinkedHashMap<String, String> targetUpdatableColMap = new LinkedHashMap<String, String>();
        try {
            String pageContext = "2";
            String objContext = Integer.toString(tabNo);
            String editor = "WebEditor";
            HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
            if (this.userInfo != null) {
                propEditorInfoMap.put("PROFILE_ID_RES", this.userInfo.getProfileIdRes());
                propEditorInfoMap.put("ENTERPRISE_ID_RES", "");
                propEditorInfoMap.put("USER_ID", this.checkNull(this.userInfo.getLoginCode()));
            }
            propEditorInfoMap.put("EDITOR", editor);
            String formName = this.checkNull(TemplateDetails.get(objName).getFormName(objContext));
            BaseLogger.log("3", null, null, "formName - [" + formName + "]");
            String metadataFilePath = this.genericUtility.getMetaDataFilePath(objName, objContext, pageContext, formName, propEditorInfoMap, this.userInfo.getTransDB());
            BaseLogger.log("3", null, null, "metadataFilePath - [" + metadataFilePath + "]");
            DWObject dw = new DWObject(metadataFilePath, this.userInfo);
            ArrayList actualColValue = dw.getColumnsList();
            Hashtable updateColMapTemp = dw.getUpdateableLogPhyColNames();
            BaseLogger.log("3", null, null, "updateColMapTemp === [" + updateColMapTemp + "]");
            Hashtable updateColMap = dw.getNonEditableLogPhyColNames();
            BaseLogger.log("3", null, null, "updateColMap === [" + updateColMap + "]");
            HashMap<String, String> tabOrderWiseLogicalNameMap = dw.getTabOrderWiseLogicalNameMap();
            BaseLogger.log("3", null, null, "tabOrderWiseLogicalNameMap [" + tabOrderWiseLogicalNameMap + "]");
            ArrayList<String> updatableColList = new ArrayList<String>();
            for (Object k : updateColMap.keySet()) {
                updatableColList.add(k.toString().trim());
            }
            for (Object object : tabOrderWiseLogicalNameMap.keySet()) {
                if (!updatableColList.contains(object.toString().trim())) continue;
                targetUpdatableColMap.put("" + object, tabOrderWiseLogicalNameMap.get(object));
            }
            dw.remove();
            dw = null;
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Exception :: getActualColListMap : [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return targetUpdatableColMap;
    }

    public String applyTemplate(String inputDataStr) throws ITMException {
        StringBuffer updatedDataStr = new StringBuffer();
        LinkedHashMap<String, String> dataMap = null;
        LinkedHashMap<String, Integer> detailDomIdMap = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, String> detailDataMap = new LinkedHashMap<String, String>();
        int totalForms = TemplateDetails.get(this.objName).getNoOfForms();
        BaseLogger.log("3", this.userInfo, null, "totalForms : [" + totalForms + "]");
        HashMap<String, LinkedHashMap<String, String>> formWiseDataMap = this.buildDataMap(inputDataStr, totalForms);
        BaseLogger.log("3", this.userInfo, null, "formWiseDataMap : [" + formWiseDataMap + "]");
        HashMap<Integer, HashMap<String, HashMap<String, String>>> formWiseLookUpDetailMap = TemplateDetails.get(this.templateKey).getSheetMapDetailMap();
        BaseLogger.log("3", this.userInfo, null, "Sheet Detail Map : [" + formWiseLookUpDetailMap + "]");
        HashMap<Integer, LinkedHashMap<String, String>> formWiseSrcTargetColumnMap = TemplateDetails.get(this.templateKey).getFormWiseTargetCol();
        BaseLogger.log("3", this.userInfo, null, "sheet Src Target Column Map : [" + formWiseSrcTargetColumnMap + "]");
        HashMap<Integer, LinkedHashMap<String, String>> formWiseMappingLogicMap = TemplateDetails.get(this.templateKey).getFormWiseMapLogicData();
        BaseLogger.log("3", this.userInfo, null, "sheet Mapping Logic Map : [" + formWiseMappingLogicMap + "]");
        ArrayList<String> parentPkNameList = TemplateDetails.get(this.objName).getPKFieldNameList("1");
        int detailDomId = 1;
        for (Map.Entry<String, LinkedHashMap<String, String>> entry : formWiseDataMap.entrySet()) {
            String formWisekey = entry.getKey();
            HashMap formDataMap = formWiseDataMap.get(formWisekey);
            BaseLogger.log("3", this.userInfo, null, "formNo : [" + formWisekey + "], formDataMap : [" + formDataMap + "]");
            if (formWisekey.indexOf("~") != -1) {
                formWisekey = formWisekey.substring(0, formWisekey.lastIndexOf("~"));
                BaseLogger.log("3", this.userInfo, null, "formWisekey : [" + formWisekey + "]");
            }
            int formNo = Integer.parseInt(formWisekey);
            String rowData = "";
            ArrayList<String> pkNameList = TemplateDetails.get(this.objName).getPKFieldNameList("" + formNo);
            HashMap<String, HashMap<String, String>> lookUpDetailMap = formWiseLookUpDetailMap.get(formNo);
            HashMap srcTargetColumnMap = formWiseSrcTargetColumnMap.get(formNo);
            HashMap mapLogicMap = formWiseMappingLogicMap.get(formNo);
            dataMap = this.buildDetailDataMap(formNo, formDataMap, lookUpDetailMap, srcTargetColumnMap, mapLogicMap, pkNameList, parentPkNameList);
            BaseLogger.log("3", this.userInfo, null, "dataMap : [" + dataMap + "]");
            if (dataMap == null) continue;
            if (dataMap.containsKey("INPUT_DATA_ERR")) {
                return this.genericUtility.getErrorString("", dataMap.get("INPUT_DATA_ERR"), "Invalid data!", "");
            }
            String[] pkDetails = this.getPkDetails(dataMap, pkNameList, parentPkNameList);
            String pkName = pkDetails[0];
            String pkValue = pkDetails[1];
            String parentPkValue = pkDetails[2];
            String detailPkValue = String.valueOf(parentPkValue) + "~" + formNo;
            BaseLogger.log("3", this.userInfo, null, "detailPkValue [" + detailPkValue + "]");
            if (detailDomIdMap.containsKey(detailPkValue)) {
                detailDomId = (Integer)detailDomIdMap.get(detailPkValue);
                ++detailDomId;
            } else {
                detailDomId = 1;
            }
            detailDomIdMap.put(detailPkValue, detailDomId);
            rowData = this.buildDetailData(dataMap, formNo, pkValue, detailDomId, pkName);
            if (formNo == 1) {
                detailDataMap.put(parentPkValue, rowData);
                continue;
            }
            if (detailDataMap.containsKey(parentPkValue)) {
                StringBuffer dataBuff = new StringBuffer();
                String existingData = (String)detailDataMap.get(parentPkValue);
                dataBuff.append(existingData).append(rowData);
                detailDataMap.put(parentPkValue, dataBuff.toString());
                continue;
            }
            for (Map.Entry entry2 : detailDataMap.entrySet()) {
                String headerParentKey = (String)entry2.getKey();
                BaseLogger.log("3", this.userInfo, null, "headerParentKey : [" + headerParentKey + "]");
                String[] array3 = headerParentKey.split("\\:");
                String tempPkVal = array3[0];
                BaseLogger.log("3", this.userInfo, null, "tempPkVal : [" + tempPkVal + "]");
                if (!tempPkVal.equals(parentPkValue)) continue;
                StringBuffer dataBuff = new StringBuffer();
                String existingData = (String)detailDataMap.get(headerParentKey);
                dataBuff.append(existingData).append(rowData);
                detailDataMap.put(headerParentKey, dataBuff.toString());
            }
        }
        for (Map.Entry<String, LinkedHashMap<String, String>> entry : detailDataMap.entrySet()) {
            updatedDataStr.append((String)((Object)entry.getValue()));
        }
        BaseLogger.log("3", this.userInfo, null, "updatedDataStr : [" + updatedDataStr + "]");
        return updatedDataStr.toString();
    }

    private HashMap<String, LinkedHashMap<String, String>> buildDataMap(String dataStr, int totalForms) {
        LinkedHashMap<String, LinkedHashMap<String, String>> dataMap = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        try {
            Document document = this.genericUtility.parseString(dataStr);
            LinkedHashMap<String, String> formDataMap = null;
            NodeList detailNodeList = null;
            HashMap<Integer, LinkedHashMap<String, String>> formWiseSrcTargetColumnMap = TemplateDetails.get(this.templateKey).getFormWiseTargetCol();
            BaseLogger.log("3", this.userInfo, null, "sheet Src Target Column Map ==> : [" + formWiseSrcTargetColumnMap + "]");
            int formNo = 1;
            while (formNo <= totalForms) {
                detailNodeList = document.getElementsByTagName("Detail" + formNo);
                BaseLogger.log("3", null, null, "detailNodeList.getLength() : [" + detailNodeList.getLength() + "]");
                HashMap srcTargetColumnMap = formWiseSrcTargetColumnMap.get(formNo);
                int detailNodeCtr = 0;
                while (detailNodeCtr < detailNodeList.getLength()) {
                    formDataMap = new LinkedHashMap<String, String>();
                    Node dataNode = detailNodeList.item(detailNodeCtr);
                    NodeList childOfDetailNode = dataNode.getChildNodes();
                    BaseLogger.log("3", null, null, "childOfDetailNode length : [" + childOfDetailNode.getLength() + "]");
                    int detailChildNode = 0;
                    while (detailChildNode < childOfDetailNode.getLength()) {
                        Node tagNode = childOfDetailNode.item(detailChildNode);
                        if (tagNode.getNodeType() == 1) {
                            String srcColName;
                            String columnName = childOfDetailNode.item(detailChildNode).getNodeName();
                            BaseLogger.log("3", null, null, "columnName : [" + columnName + "]");
                            String columnValue = "";
                            if (!"attribute".equals(columnName) && childOfDetailNode.item(detailChildNode).getFirstChild() != null && childOfDetailNode.item(detailChildNode).getFirstChild().getNodeValue() != null) {
                                columnValue = childOfDetailNode.item(detailChildNode).getFirstChild().getNodeValue();
                                BaseLogger.log("3", null, null, "columnValue : [" + columnValue + "]");
                                srcColName = this.getSourceColumn(srcTargetColumnMap, columnName);
                                if (srcColName != null && srcColName.length() > 0 && !srcColName.equals(columnName)) {
                                    columnName = srcColName;
                                }
                                formDataMap.put(columnName, columnValue);
                            } else {
                                columnValue = "";
                                srcColName = this.getSourceColumn(srcTargetColumnMap, columnName);
                                if (srcColName != null && srcColName.length() > 0 && !srcColName.equals(columnName)) {
                                    columnName = srcColName;
                                }
                                formDataMap.put(columnName, columnValue);
                            }
                        }
                        ++detailChildNode;
                    }
                    dataMap.put(String.valueOf(formNo) + "~" + detailNodeCtr, formDataMap);
                    ++detailNodeCtr;
                }
                ++formNo;
            }
            BaseLogger.log("3", null, null, "dataMap : [" + dataMap + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Exception :: buildDataMap : [" + e.getMessage() + "]");
        }
        return dataMap;
    }

    private String getSourceColumn(HashMap<String, String> srcTargetColumnMap, String colName) {
        String sourceCol = "";
        for (Map.Entry<String, String> entry : srcTargetColumnMap.entrySet()) {
            BaseLogger.log("3", null, null, "key : [" + entry.getKey() + "], value :[" + entry.getValue() + "], colName : [" + colName + "]");
            if (!entry.getValue().toLowerCase().equals(colName.toLowerCase())) continue;
            sourceCol = entry.getKey().toLowerCase();
            break;
        }
        return sourceCol;
    }

    private LinkedHashMap<String, String> buildDetailDataMap(int formNo, HashMap<String, String> formDataMap, HashMap<String, HashMap<String, String>> lookUpDetailMap, HashMap<String, String> srcTargetColumnMap, HashMap<String, String> mapLogicMap, ArrayList<String> pkNameList, ArrayList<String> parentPkNameList) throws ITMException {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        try {
            HashMap<String, String> dbColLogNameTypeMap = TemplateDetails.get(this.objName).getColumnTypeDB("" + formNo);
            HashMap<String, String> metadataColLogNameTypeMap = TemplateDetails.get(this.objName).getColumnTypeMetaDeta("" + formNo);
            HashMap<String, Integer> colLogNameSizeMap = TemplateDetails.get(this.objName).getColumnSize("" + formNo);
            HashMap<String, String> fieldCaseValueMap = TemplateDetails.get(this.objName).getFieldCase("" + formNo);
            HashMap<String, HashMap<String, String>> dropDownColValueMap = TemplateDetails.get(this.objName).getDropDownColValueMap("" + formNo);
            HashMap<String, Integer> colLogNamePrecisionMap = TemplateDetails.get(this.objName).getColumnPrecision("" + formNo);
            ArrayList<String> actualColList = TemplateDetails.get(this.templateKey).getActualColList(formNo);
            BaseLogger.log("3", this.userInfo, null, "actualColList : [" + actualColList + "]");
            String rowData = "";
            String colName = "";
            String targetCol = "";
            int actualColListLen = actualColList.size();
            BaseLogger.log("3", this.userInfo, null, "actualColListLen [" + actualColListLen + "]");
            int colNo = 0;
            while (colNo < actualColListLen) {
                colName = actualColList.get(colNo);
                BaseLogger.log("3", null, null, "<====> source Colum Name : [" + colName + "]");
                if (srcTargetColumnMap != null && srcTargetColumnMap.containsKey(colName)) {
                    targetCol = srcTargetColumnMap.get(colName);
                    BaseLogger.log("3", null, null, "<====> target Colum Name : [" + targetCol + "]");
                    String excelContent = "";
                    HashMap<String, String> contentMap = lookUpDetailMap.get(colName);
                    BaseLogger.log("3", null, null, "contentMap [" + contentMap + "]");
                    String mapLogic = mapLogicMap.get(colName);
                    BaseLogger.log("3", null, null, "mapLogic [" + mapLogic + "]");
                    if ("R".equals(mapLogic)) {
                        String sqlInput = this.checkNull(contentMap.get("SQL_INPUT"));
                        BaseLogger.log("3", null, null, "sqlInput - [" + sqlInput + "]");
                        StringBuffer finalVal = new StringBuffer();
                        if (sqlInput.contains(",")) {
                            String[] sqlInputArray = sqlInput.split(",");
                            int cnt = 0;
                            while (cnt < sqlInputArray.length) {
                                String sqlInputArg = this.checkNull(sqlInputArray[cnt]);
                                String contentData = this.checkNull(formDataMap.get(sqlInputArg));
                                finalVal.append(contentData);
                                finalVal.append(",");
                                ++cnt;
                            }
                        } else {
                            String contentData = this.checkNull(formDataMap.get(colName));
                            finalVal.append(contentData);
                            finalVal.append(",");
                        }
                        BaseLogger.log("3", null, null, "finalVal [" + finalVal + "]");
                        excelContent = this.checkNull(finalVal.toString());
                        excelContent = this.removeLastComma(excelContent);
                    } else {
                        excelContent = this.checkNull(formDataMap.get(colName));
                    }
                    BaseLogger.log("3", null, null, "excelContent : [" + excelContent + "]");
                    String finalContent = this.applyMapLogic(excelContent, contentMap, mapLogic, this.userInfo);
                    BaseLogger.log("3", null, null, "finalContent : [" + finalContent + "]");
                    rowData = String.valueOf(rowData) + finalContent;
                    if (CommonConstants.UPLOAD_IGNORE_VALUES.trim().length() <= 0 || !finalContent.equalsIgnoreCase(CommonConstants.UPLOAD_IGNORE_VALUES)) {
                        String errorDataStr = this.validateExcelInputData(colName, finalContent, metadataColLogNameTypeMap, dbColLogNameTypeMap, colLogNameSizeMap, dropDownColValueMap, colLogNamePrecisionMap);
                        if ((errorDataStr = this.checkNull(errorDataStr)).length() > 0) {
                            dataMap.put("INPUT_DATA_ERR", errorDataStr);
                            return dataMap;
                        }
                        if (finalContent != null && finalContent.length() > 0) {
                            finalContent = this.updateFieldCase(fieldCaseValueMap, colName, finalContent);
                        }
                        if ("line_no".equalsIgnoreCase(colName) || pkNameList.contains(colName)) {
                            finalContent = this.setCharFieldSpaces(dbColLogNameTypeMap, colLogNameSizeMap, colName, finalContent);
                        }
                        dataMap.put(colName, finalContent);
                    }
                }
                ++colNo;
            }
            if ((rowData = this.checkNull(rowData)).length() == 0) {
                return null;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return dataMap;
    }

    private String validateExcelInputData(String colName, String excelContent, HashMap<String, String> metadataColLogNameTypeMap, HashMap<String, String> dbColLogNameTypeMap, HashMap<String, Integer> colLogNameSizeMap, HashMap<String, HashMap<String, String>> dropDownColValueMap, HashMap<String, Integer> colLogNamePrecisionMap) {
        StringBuffer errorDescr = new StringBuffer();
        try {
            String validStr;
            String colType;
            HashMap<String, String> errorMap = new HashMap<String, String>();
            if (dbColLogNameTypeMap != null && dbColLogNameTypeMap.containsKey(colName)) {
                colType = this.checkNull(dbColLogNameTypeMap.get(colName));
                BaseLogger.log("3", null, null, "colType : [" + colType + "]");
                if ("char".equalsIgnoreCase(colType)) {
                    if (colLogNameSizeMap != null && colLogNameSizeMap.containsKey(colName) && excelContent.length() > 0) {
                        int actualSize = colLogNameSizeMap.get(colName);
                        int dataSize = excelContent.length();
                        BaseLogger.log("3", null, null, "colName : [" + colName + "] actualSize : [" + actualSize + "], dataSize : [" + dataSize + "]");
                        if (dataSize > actualSize) {
                            validStr = "Value too large for [" + excelContent + "] column, (actual: " + dataSize + ", maximum: " + actualSize + ")";
                            errorMap.put(colName, validStr);
                        }
                    }
                } else if ("decimal".equalsIgnoreCase(colType)) {
                    try {
                        if (excelContent.length() > 0) {
                            Double.parseDouble(excelContent);
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "[" + colType + "] Exception - [" + e.getMessage() + "]");
                        e.printStackTrace();
                        String validStr2 = "Invalid number [" + colName + "] for [" + excelContent + "] column.";
                        errorMap.put(colName, validStr2);
                    }
                }
            }
            if (metadataColLogNameTypeMap != null && metadataColLogNameTypeMap.containsKey(colName)) {
                colType = this.checkNull(metadataColLogNameTypeMap.get(colName));
                BaseLogger.log("3", null, null, "colType : [" + colType + "] colName : [" + colName + "]");
                if ("datetime".equalsIgnoreCase(colType)) {
                    try {
                        if (excelContent.length() > 0) {
                            this.genericUtility.getValidDateTimeString(excelContent, this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat());
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "[" + colType + "] -------->Exception - [" + e.getMessage() + "]");
                        e.printStackTrace();
                        String validStr3 = "Invalid date [" + excelContent + "] for [" + colName + "] column.";
                        errorMap.put(colName, validStr3);
                    }
                } else if ("date".equalsIgnoreCase(colType)) {
                    try {
                        if (excelContent.length() > 0) {
                            this.genericUtility.getValidDateString(excelContent, this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat());
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "[" + colType + "] -------->Exception - [" + e.getMessage() + "]");
                        e.printStackTrace();
                        String validStr4 = "Invalid date [" + excelContent + "] for [" + colName + "] column.";
                        errorMap.put(colName, validStr4);
                    }
                }
            }
            if (dropDownColValueMap != null && dropDownColValueMap.get(colName) != null) {
                HashMap<String, String> itemData = dropDownColValueMap.get(colName);
                if (excelContent.length() > 0 && !itemData.containsKey(excelContent)) {
                    String validStr5 = "Invalid value [" + excelContent + "] for drop down field [" + colName + "]";
                    errorMap.put(colName, validStr5);
                }
            }
            if (colLogNamePrecisionMap != null && colLogNamePrecisionMap.get(colName) != 0) {
                int dataPrecision = colLogNamePrecisionMap.get(colName);
                BaseLogger.log("3", null, null, "dataPrecision : [" + dataPrecision + "]");
                String[] excelContentPrecision = excelContent.split("\\.");
                String dataCount = excelContentPrecision[1];
                BaseLogger.log("3", null, null, "dataCount : [" + dataCount + "]");
                if (dataCount.length() > dataPrecision) {
                    validStr = "Invalid value [" + excelContent + "], precision is greater for [" + colName + "], enter only [" + dataPrecision + "] precision";
                    errorMap.put(colName, validStr);
                }
            }
            int errCnt = 1;
            if (errorMap.size() > 0) {
                for (Map.Entry entry : errorMap.entrySet()) {
                    errorDescr.append(errCnt).append(". ").append((String)entry.getValue()).append("\n");
                    ++errCnt;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "In the validateExcelInputData Exception -- > [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return errorDescr.toString();
    }

    private String updateFieldCase(HashMap<String, String> fieldCaseValueMap, String colName, String dataContent) {
        String colCaseVal;
        String finalData = dataContent;
        if (fieldCaseValueMap != null && fieldCaseValueMap.get(colName) != null && (colCaseVal = fieldCaseValueMap.get(colName)).equalsIgnoreCase("upper")) {
            finalData = dataContent.toUpperCase();
        }
        return finalData;
    }

    /*
     * Unable to fully structure code
     */
    private String setCharFieldSpaces(HashMap<String, String> colLogNameTypeMap, HashMap<String, Integer> colLogNameSizeMap, String colName, String colValue) {
        block2: {
            if (!colLogNameTypeMap.get(colName).equalsIgnoreCase("char")) break block2;
            size = colLogNameSizeMap.get(colName);
            if (!"line_no".equals(colName)) ** GOTO lbl9
            while (colValue.length() != size) {
                colValue = " " + colValue;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                colValue = String.valueOf(colValue) + " ";
lbl9:
                // 2 sources

                ** while (colValue.length() != size)
            }
        }
        return colValue;
    }

    private String[] getPkDetails(HashMap<String, String> dataMap, ArrayList<String> pkNameList, ArrayList<String> parentPkNameList) {
        String[] pkDtlArr = new String[3];
        StringBuffer pkNameBuff = new StringBuffer();
        StringBuffer pkValueBuff = new StringBuffer();
        StringBuffer parentPkValueBuff = new StringBuffer();
        if (pkNameList != null && dataMap != null && parentPkNameList != null) {
            int pkCtr = 0;
            while (pkCtr < pkNameList.size()) {
                String pkName = this.checkNull(pkNameList.get(pkCtr));
                pkNameBuff.append(pkName).append(":");
                if (dataMap.containsKey(pkName)) {
                    pkValueBuff.append(dataMap.get(pkName)).append(":");
                    if (parentPkNameList.contains(pkName)) {
                        parentPkValueBuff.append(dataMap.get(pkName)).append(":");
                    }
                }
                ++pkCtr;
            }
            if (pkValueBuff.toString().endsWith(":")) {
                pkValueBuff = pkValueBuff.deleteCharAt(pkValueBuff.length() - 1);
            }
            if (parentPkValueBuff.toString().endsWith(":")) {
                parentPkValueBuff = parentPkValueBuff.deleteCharAt(parentPkValueBuff.length() - 1);
            }
        }
        pkDtlArr[0] = pkNameBuff.toString();
        pkDtlArr[1] = pkValueBuff.toString();
        pkDtlArr[2] = parentPkValueBuff.toString();
        return pkDtlArr;
    }

    private String buildDetailData(HashMap<String, String> dataMap, int formNo, String pkValue, int domId, String pkName) {
        StringBuffer detailDataBuff = new StringBuffer();
        detailDataBuff.append("<Detail" + formNo + " dbID='" + pkValue + "' domID='" + domId + "' objName='" + this.objName + "' objContext='" + formNo + "'>");
        detailDataBuff.append("<attribute pkNames='" + pkName + "' status='N' updateFlag='A' selected='N' />");
        for (Map.Entry<String, String> dataEntry : dataMap.entrySet()) {
            String colName = dataEntry.getKey();
            String colValue = dataEntry.getValue();
            detailDataBuff.append("<").append(colName).append(" isDataUpload=\"true\"").append("><![CDATA[").append(colValue).append("]]></").append(colName).append(">");
        }
        detailDataBuff.append("</Detail" + formNo + ">");
        return detailDataBuff.toString();
    }

    private String applyMapLogic(String excelContent, HashMap<String, String> dataMap, String mapLogic, UserInfoBean userInfo) {
        String respString;
        block10: {
            respString = "";
            try {
                if ("D".equals(mapLogic)) {
                    if ("".equals(excelContent)) {
                        excelContent = "~NOVALUE~";
                    }
                    BaseLogger.log("3", userInfo, null, "excelContent renamed : [" + excelContent + "]");
                    respString = dataMap.get(excelContent) != null && dataMap.get(excelContent).length() > 0 ? dataMap.get(excelContent) : excelContent;
                    break block10;
                }
                if ("R".equals(mapLogic)) {
                    respString = this.getSqlValue(dataMap.get("SQL"), excelContent);
                    break block10;
                }
                if ("S".equals(mapLogic)) {
                    if (this.checkNull(dataMap.get("START_FROM")).length() > 0 && this.checkNull(dataMap.get("UP_TO")).length() > 0) {
                        int startFrom = Integer.parseInt(dataMap.get("START_FROM"));
                        int upTo = Integer.parseInt(dataMap.get("UP_TO"));
                        BaseLogger.log("3", userInfo, null, " startFrom : [" + startFrom + "]");
                        BaseLogger.log("3", userInfo, null, " upTo : [" + upTo + "]");
                        try {
                            respString = excelContent.substring(startFrom, upTo);
                            break block10;
                        }
                        catch (Exception e) {
                            throw new ITMException(e);
                        }
                    }
                    respString = excelContent;
                    break block10;
                }
                if ("A".equals(mapLogic)) {
                    respString = excelContent;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "In the applyMapLogic Exception : [" + e.getMessage() + "]");
                e.printStackTrace();
            }
        }
        BaseLogger.log("3", userInfo, null, "respString : [" + respString + "]");
        return respString;
    }

    private String getSqlValue(String sqlString, String sqlInput) throws ITMException {
        String respString = "";
        try {
            UploadFileEJB uploadFile = new UploadFileEJB();
            respString = uploadFile.getSqlValue(sqlString, sqlInput, this.userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "In the getSqlValue Exception : [" + e.getMessage() + "]");
            throw new ITMException(e);
        }
        return respString;
    }

    private String removeLastComma(String inputStr) {
        try {
            if (inputStr != null && inputStr.length() > 0 && inputStr.lastIndexOf(",") != -1) {
                inputStr = inputStr.substring(0, inputStr.length() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "In the removeLastComma Exception : [" + e.getMessage() + "]");
        }
        return inputStr;
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    private DBAccessEJB getDBAccess() {
        try {
            if (this.dbAccessEJB == null) {
                this.dbAccessEJB = new DBAccessEJB();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.dbAccessEJB;
    }

    public HashMap<String, String> getMappingSheetDetailMap() {
        return this.sheetDetailMap;
    }

    public boolean isAutoConfirm() {
        return this.isAutoConfirm;
    }

    public LinkedHashMap<String, String> buildExcelData(String excelFilePath, Workbook workbook) throws ITMException {
        LinkedHashMap<String, String> detailDataMap = new LinkedHashMap<String, String>();
        try {
            String userId = this.userInfo.getLoginCode();
            ArrayList<String> parentPkNameList = TemplateDetails.get(this.objName).getPKFieldNameList("1");
            if (parentPkNameList == null) {
                detailDataMap.put("INPUT_DATA_ERR", this.genericUtility.getErrorString("", "INVTRANID", userId));
                return detailDataMap;
            }
            String tempString = TemplateDetails.get(this.objName).getTemplateXml(this.templateName);
            BaseLogger.log("3", this.userInfo, null, "--------------Temp. String : [" + tempString + "]");
            ArrayList<Integer> sheetsUsed = TemplateDetails.get(this.objName).getTotalRowsInTemplate(this.templateName);
            BaseLogger.log("3", this.userInfo, null, "--------------totalRowsInTemp : [" + sheetsUsed + "]");
            HashMap<Integer, HashMap<String, HashMap<String, String>>> sheetMapDetailMap = TemplateDetails.get(this.templateKey).getSheetMapDetailMap();
            BaseLogger.log("3", this.userInfo, null, "Sheet Detail Map : " + sheetMapDetailMap);
            HashMap<Integer, LinkedHashMap<String, String>> sheetSrcTargetColumnMap = TemplateDetails.get(this.templateKey).getFormWiseTargetCol();
            BaseLogger.log("3", this.userInfo, null, "sheet Src Target Column Map : " + sheetSrcTargetColumnMap);
            HashMap<Integer, LinkedHashMap<String, String>> sheetMappingLogicMap = TemplateDetails.get(this.templateKey).getFormWiseMapLogicData();
            BaseLogger.log("3", this.userInfo, null, "sheet Mapping Logic Map : " + sheetMappingLogicMap);
            LinkedHashMap<String, Integer> detailDomIdMap = new LinkedHashMap<String, Integer>();
            HashMap<String, Integer> matrixSheetColSpanMap = new HashMap<String, Integer>();
            Sheet sheet = null;
            int n = 0;
            while (n < sheetsUsed.size()) {
                int tabNo = sheetsUsed.get(n);
                ArrayList<String> pkNameList = TemplateDetails.get(this.objName).getPKFieldNameList("" + tabNo);
                if (pkNameList == null) {
                    detailDataMap.put("INPUT_DATA_ERR", this.genericUtility.getErrorString("", "INVTRANID", userId));
                    return detailDataMap;
                }
                int detailDomId = 1;
                String sheetName = TemplateDetails.get(this.templateKey).getSheetName(tabNo);
                if (sheetName.length() != 0 && (sheet = workbook.getSheet(sheetName)) != null) {
                    int noOfColumns = sheet.getColumns();
                    int noOfRows = sheet.getRows();
                    int headingRowNo = TemplateDetails.get(this.templateKey).getHeadingRowNo(tabNo);
                    int matrixRowNo = TemplateDetails.get(this.templateKey).getMatrixRowNo(tabNo);
                    int startMatrixColNo = TemplateDetails.get(this.templateKey).getStartMatrixColNo(tabNo);
                    int endMatrixColNo = TemplateDetails.get(this.templateKey).getEndMatrixColNo(tabNo);
                    if (endMatrixColNo == -1) {
                        endMatrixColNo = noOfColumns;
                    }
                    int startsFrom = TemplateDetails.get(this.templateKey).getDataStartsFrom(tabNo);
                    BaseLogger.log("3", this.userInfo, null, "headingRowNo [" + headingRowNo + "]");
                    BaseLogger.log("3", this.userInfo, null, "matrixRowNo [" + matrixRowNo + "]");
                    BaseLogger.log("3", this.userInfo, null, "startMatrixColNo [" + startMatrixColNo + "]");
                    BaseLogger.log("3", this.userInfo, null, "endMatrixColNo [" + endMatrixColNo + "]");
                    BaseLogger.log("3", this.userInfo, null, "startsFrom [" + startsFrom + "], noOfRows [" + noOfRows + "]");
                    if (headingRowNo > noOfRows) {
                        detailDataMap.put("INPUT_DATA_ERR", this.genericUtility.getErrorString("", "INVEXHDR", userId));
                        return detailDataMap;
                    }
                    if (startsFrom == -1 || startsFrom > noOfRows) {
                        detailDataMap.put("INPUT_DATA_ERR", this.genericUtility.getErrorString("", "INVDSF", userId));
                        return detailDataMap;
                    }
                    ArrayList<String> actualColList = TemplateDetails.get(this.templateKey).getActualColList(tabNo);
                    if (actualColList == null) {
                        actualColList = new ArrayList();
                    }
                    HashMap<String, String> dbColLogNameTypeMap = TemplateDetails.get(this.objName).getColumnTypeDB("" + tabNo);
                    HashMap<String, String> metaDataColLogNameTypeMap = TemplateDetails.get(this.objName).getColumnTypeMetaDeta("" + tabNo);
                    HashMap<String, Integer> colLogNameSizeMap = TemplateDetails.get(this.objName).getColumnSize("" + tabNo);
                    HashMap<String, String> fieldCaseValueMap = TemplateDetails.get(this.objName).getFieldCase("" + tabNo);
                    HashMap<String, HashMap<String, String>> dropDownColValueMap = TemplateDetails.get(this.objName).getDropDownColValueMap("" + tabNo);
                    HashMap<String, Integer> colLogNamePrecisionMap = TemplateDetails.get(this.objName).getColumnPrecision("" + tabNo);
                    int rowNo = startsFrom;
                    while (rowNo < noOfRows) {
                        if (!this.validateCell(sheet, rowNo, noOfColumns)) break;
                        String rowData = "";
                        LinkedHashMap<String, String> dataMap = null;
                        int colSpan = 0;
                        if (matrixRowNo >= 0) {
                            if (parentPkNameList.size() == 1) {
                                HashMap parentPkNameMap = sheetSrcTargetColumnMap.get(1);
                                String parentPkName = this.getTempPKVal(parentPkNameMap);
                                parentPkNameList.add(parentPkName);
                                parentPkNameList.add("Y");
                            }
                            if (pkNameList.size() == 1) {
                                HashMap pkNameMap = sheetSrcTargetColumnMap.get(tabNo);
                                String tempPkVal = this.getTempPKVal(pkNameMap);
                                pkNameList.add(tempPkVal);
                                pkNameList.add("Y");
                            }
                            HashMap<String, Object> matrixDetailMap = this.getMatrixDetailMap(sheet, matrixRowNo, startMatrixColNo, endMatrixColNo);
                            BaseLogger.log("3", this.userInfo, null, "matrixDetailMap [" + matrixDetailMap + "]");
                            TreeMap matrixColMap = (TreeMap)matrixDetailMap.get("MATRIX_COL_MAP");
                            BaseLogger.log("3", this.userInfo, null, "matrixColMap [" + matrixColMap + "]");
                            colSpan = (Integer)matrixDetailMap.get("COLSPAN");
                            matrixSheetColSpanMap.put(sheetName, colSpan);
                            BaseLogger.log("3", this.userInfo, null, "colSpan - [" + colSpan + "]");
                            for (Map.Entry matrixEntry : matrixColMap.entrySet()) {
                                int matrixStartFrom = (Integer)matrixEntry.getKey();
                                String matrixContentVal = (String)matrixEntry.getValue();
                                BaseLogger.log("3", this.userInfo, null, "matrixContentVal - [" + matrixContentVal + "]");
                                ArrayList<Integer> matrixColList = this.getMatrixColList(noOfColumns, startMatrixColNo, endMatrixColNo, matrixStartFrom, colSpan);
                                BaseLogger.log("3", this.userInfo, null, "columnList = " + matrixColList);
                                dataMap = this.buildDetailDataMap(sheet, tabNo, rowNo, actualColList, matrixColList, matrixContentVal, sheetMapDetailMap, sheetSrcTargetColumnMap, sheetMappingLogicMap, pkNameList, metaDataColLogNameTypeMap, dbColLogNameTypeMap, colLogNameSizeMap, parentPkNameList, dropDownColValueMap, fieldCaseValueMap, colLogNamePrecisionMap, colSpan);
                                if (dataMap == null) continue;
                                if (dataMap.containsKey("INPUT_DATA_ERR")) {
                                    detailDataMap.put("INPUT_DATA_ERR", this.genericUtility.getErrorString("", dataMap.get("INPUT_DATA_ERR"), "Invalid data!", ""));
                                    return detailDataMap;
                                }
                                String[] pkDetails = this.getPkDetails(dataMap, pkNameList, parentPkNameList);
                                String pkName = pkDetails[0];
                                String pkValue = pkDetails[1];
                                String parentPkValue = pkDetails[2];
                                if (pkNameList.contains("Y")) {
                                    String[] array1 = pkName.split("\\:");
                                    pkName = array1[0];
                                }
                                if (parentPkNameList.contains("Y")) {
                                    String[] array2 = pkValue.split("\\:");
                                    pkValue = array2[0];
                                }
                                String detailPkValue = String.valueOf(parentPkValue) + "~" + tabNo;
                                BaseLogger.log("3", this.userInfo, null, "detailPkValue [" + detailPkValue + "]");
                                if (detailDomIdMap.containsKey(detailPkValue)) {
                                    detailDomId = (Integer)detailDomIdMap.get(detailPkValue);
                                    ++detailDomId;
                                } else {
                                    detailDomId = 1;
                                }
                                detailDomIdMap.put(detailPkValue, detailDomId);
                                rowData = this.buildDetailData(dataMap, tabNo, pkValue, detailDomId, pkName);
                                if (tabNo == 1) {
                                    detailDataMap.put(parentPkValue, rowData);
                                    continue;
                                }
                                if (!detailDataMap.containsKey(parentPkValue)) continue;
                                StringBuffer dataBuff = new StringBuffer();
                                String existingData = detailDataMap.get(parentPkValue);
                                dataBuff.append(existingData).append(rowData);
                                detailDataMap.put(parentPkValue, dataBuff.toString());
                            }
                        } else {
                            dataMap = this.buildDetailDataMap(sheet, tabNo, rowNo, actualColList, null, null, sheetMapDetailMap, sheetSrcTargetColumnMap, sheetMappingLogicMap, pkNameList, metaDataColLogNameTypeMap, dbColLogNameTypeMap, colLogNameSizeMap, parentPkNameList, dropDownColValueMap, fieldCaseValueMap, colLogNamePrecisionMap, colSpan);
                            if (dataMap != null) {
                                if (dataMap.containsKey("INPUT_DATA_ERR")) {
                                    detailDataMap.put("INPUT_DATA_ERR", this.genericUtility.getErrorString("", dataMap.get("INPUT_DATA_ERR"), "Invalid data!", ""));
                                    return detailDataMap;
                                }
                                String[] pkDetails = this.getPkDetails(dataMap, pkNameList, parentPkNameList);
                                String pkName = pkDetails[0];
                                String pkValue = pkDetails[1];
                                String parentPkValue = pkDetails[2];
                                String detailPkValue = String.valueOf(parentPkValue) + "~" + tabNo;
                                BaseLogger.log("3", this.userInfo, null, "detailPkValue [" + detailPkValue + "]");
                                if (detailDomIdMap.containsKey(detailPkValue)) {
                                    detailDomId = (Integer)detailDomIdMap.get(detailPkValue);
                                    ++detailDomId;
                                } else {
                                    detailDomId = 1;
                                }
                                detailDomIdMap.put(detailPkValue, detailDomId);
                                rowData = this.buildDetailData(dataMap, tabNo, pkValue, detailDomId, pkName);
                                if (tabNo == 1) {
                                    detailDataMap.put(parentPkValue, rowData);
                                } else if (detailDataMap.containsKey(parentPkValue)) {
                                    StringBuffer dataBuff = new StringBuffer();
                                    String existingData = detailDataMap.get(parentPkValue);
                                    dataBuff.append(existingData).append(rowData);
                                    detailDataMap.put(parentPkValue, dataBuff.toString());
                                } else {
                                    for (Map.Entry<String, String> entry : detailDataMap.entrySet()) {
                                        String headerParentKey = entry.getKey();
                                        BaseLogger.log("3", this.userInfo, null, "headerParentKey :: ==> [" + headerParentKey + "]");
                                        String[] array3 = headerParentKey.split("\\:");
                                        String tempPkVal = array3[0];
                                        BaseLogger.log("3", this.userInfo, null, "tempPkVal : [" + tempPkVal + "]");
                                        if (!tempPkVal.equals(parentPkValue)) continue;
                                        StringBuffer dataBuff = new StringBuffer();
                                        String existingData = detailDataMap.get(headerParentKey);
                                        dataBuff.append(existingData).append(rowData);
                                        detailDataMap.put(headerParentKey, dataBuff.toString());
                                    }
                                }
                            }
                        }
                        ++rowNo;
                    }
                    BaseLogger.log("3", this.userInfo, null, "matrixSheetColSpanMap ::- [" + matrixSheetColSpanMap + "]");
                    TemplateDetails.get(this.templateKey).setMatrixColSpanMap(matrixSheetColSpanMap);
                }
                ++n;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return detailDataMap;
    }

    private boolean validateCell(Sheet sheet, int rowNo, int noOfCols) {
        boolean isValid = true;
        try {
            String columnData = "";
            int k = 0;
            while (k < noOfCols) {
                columnData = String.valueOf(columnData) + this.checkNull(sheet.getCell(k, rowNo).getContents());
                ++k;
            }
            if (columnData.length() == 0 || "END_OF_FILE".equalsIgnoreCase(columnData)) {
                isValid = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isValid;
    }

    private String getTempPKVal(HashMap<String, String> parentPkNameMap) {
        String key = "";
        for (Map.Entry<String, String> entry : parentPkNameMap.entrySet()) {
            if (!"MatrixColumn".equals(entry.getValue())) continue;
            key = entry.getKey();
        }
        return key;
    }

    private HashMap<String, Object> getMatrixDetailMap(Sheet sheet, int matrixRowNo, int startMatrixColNum, int endMatrixColNum) throws ITMException {
        HashMap<String, Object> matrixDetailMap = new HashMap<String, Object>();
        try {
            int noOfColumns = sheet.getColumns();
            int actualStartMatrixColNo = 0;
            int nextStartMatrixColNo = noOfColumns;
            Range[] range = sheet.getMergedCells();
            BaseLogger.log("3", null, null, "sheet.getMergedCells() [" + range.length + "]");
            TreeMap<Integer, String> matrixColMap = new TreeMap<Integer, String>();
            if (range.length == 0) {
                int sigleMatrixNo = startMatrixColNum;
                while (sigleMatrixNo <= endMatrixColNum) {
                    String colName = sheet.getCell(sigleMatrixNo, matrixRowNo).getContents();
                    matrixColMap.put(sigleMatrixNo, colName);
                    ++sigleMatrixNo;
                }
                BaseLogger.log("3", null, null, "matrixColMap  - [" + matrixColMap + "]");
            } else {
                int i = 0;
                while (i < range.length) {
                    BaseLogger.log("3", null, null, "i - [" + i + "]");
                    Cell cell = range[i].getTopLeft();
                    if (cell.getRow() == matrixRowNo) {
                        matrixColMap.put(cell.getColumn(), cell.getContents());
                    }
                    ++i;
                }
            }
            BaseLogger.log("3", null, null, "matrixMap [" + matrixColMap + "]");
            matrixDetailMap.put("MATRIX_COL_MAP", matrixColMap);
            int matrixCnt = 0;
            for (Map.Entry entry : matrixColMap.entrySet()) {
                if (matrixCnt == 0) {
                    actualStartMatrixColNo = (Integer)entry.getKey();
                } else if (matrixCnt == 1) {
                    nextStartMatrixColNo = (Integer)entry.getKey();
                    break;
                }
                ++matrixCnt;
            }
            BaseLogger.log("3", null, null, "nextStartMatrixColNo - [" + nextStartMatrixColNo + "], actualStartMatrixColNo - [" + actualStartMatrixColNo + "]");
            matrixDetailMap.put("ACTUAL_MATRIX_START_FROM", actualStartMatrixColNo);
            matrixDetailMap.put("NEXT_MATRIX_START_FROM", nextStartMatrixColNo);
            int colSpan = nextStartMatrixColNo - actualStartMatrixColNo;
            BaseLogger.log("3", null, null, "colSpan - [" + colSpan + "]");
            matrixDetailMap.put("COLSPAN", colSpan);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return matrixDetailMap;
    }

    private ArrayList<Integer> getMatrixColList(int noOfColumns, int startMatrixColNo, int endMatrixColNo, int matrixStartFrom, int colSpan) {
        ArrayList<Integer> matrixColList = new ArrayList<Integer>();
        int colNo = 0;
        while (colNo < noOfColumns) {
            if (colNo < startMatrixColNo || colNo > endMatrixColNo) {
                matrixColList.add(colNo);
            } else if (colNo >= matrixStartFrom && colNo < matrixStartFrom + colSpan) {
                matrixColList.add(colNo);
            }
            ++colNo;
        }
        return matrixColList;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private LinkedHashMap<String, String> buildDetailDataMap(Sheet sheet, int formNo, int rowNo, ArrayList<String> actualColList, ArrayList<Integer> matrixColList, String matrixContentVal, HashMap<Integer, HashMap<String, HashMap<String, String>>> sheetMapDetailMap, HashMap<Integer, LinkedHashMap<String, String>> sheetSrcTargetColumnMap, HashMap<Integer, LinkedHashMap<String, String>> sheetMappingLogicMap, ArrayList<String> pkNameList, HashMap<String, String> metadataColLogNameTypeMap, HashMap<String, String> dbColLogNameTypeMap, HashMap<String, Integer> colLogNameSizeMap, ArrayList<String> parentPkNameList, HashMap<String, HashMap<String, String>> dropDownColValueMap, HashMap<String, String> fieldCaseValueMap, HashMap<String, Integer> colLogNamePrecisionMap, int colSpan) throws ITMException {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        try {
            HashMap<String, HashMap<String, String>> innerMap = sheetMapDetailMap.get(formNo);
            HashMap srcTargetColumnMap = sheetSrcTargetColumnMap.get(formNo);
            HashMap mapLogicMap = sheetMappingLogicMap.get(formNo);
            int headingRowNo = TemplateDetails.get(this.templateKey).getHeadingRowNo(formNo);
            int colSpanCnt = 0;
            String rowData = "";
            String colName = "";
            String targetCol = "";
            int actualColListLen = actualColList.size();
            int colNo = 0;
            while (colNo < actualColListLen) {
                colName = actualColList.get(colNo);
                if (srcTargetColumnMap != null && srcTargetColumnMap.containsKey(colName)) {
                    targetCol = (String)srcTargetColumnMap.get(colName);
                    BaseLogger.log("3", null, null, "<====> target Colum Name : [" + targetCol + "]");
                    String excelContent = "";
                    HashMap<String, String> contentMap = innerMap.get(colName);
                    BaseLogger.log("3", null, null, "contentMap " + contentMap);
                    String mapLogic = (String)mapLogicMap.get(colName);
                    BaseLogger.log("3", null, null, "mapLogic [" + mapLogic + "]");
                    if ("R".equals(mapLogic)) {
                        String sqlInput = this.checkNull(contentMap.get("SQL_INPUT"));
                        BaseLogger.log("3", null, null, "sqlInput - [" + sqlInput + "]");
                        StringBuffer finalVal = new StringBuffer();
                        if (sqlInput.contains(",")) {
                            String[] sqlInputArray = sqlInput.split(",");
                            int cnt = 0;
                            while (cnt < sqlInputArray.length) {
                                String sqlInputArg = this.checkNull(sqlInputArray[cnt]);
                                String contentData = this.getExcelContent(sheet, headingRowNo, rowNo, sqlInputArg, matrixColList, matrixContentVal);
                                finalVal.append(contentData);
                                finalVal.append(",");
                                ++cnt;
                            }
                        } else {
                            String contentData = this.getExcelContent(sheet, headingRowNo, rowNo, sqlInput, matrixColList, matrixContentVal);
                            finalVal.append(contentData);
                            finalVal.append(",");
                        }
                        BaseLogger.log("3", null, null, "finalVal [" + finalVal + "]");
                        excelContent = this.checkNull(finalVal.toString());
                        excelContent = this.removeLastComma(excelContent);
                    } else {
                        excelContent = this.getExcelContent(sheet, headingRowNo, rowNo, targetCol, matrixColList, matrixContentVal);
                    }
                    BaseLogger.log("3", null, null, "excelContent: [" + excelContent + "]");
                    String finalContent = this.applyMapLogic(excelContent, contentMap, mapLogic, this.userInfo);
                    rowData = String.valueOf(rowData) + finalContent;
                    if (CommonConstants.UPLOAD_IGNORE_VALUES.trim().length() > 0 && finalContent.equalsIgnoreCase(CommonConstants.UPLOAD_IGNORE_VALUES)) {
                        if (matrixColList != null) {
                            if (colSpan > colSpanCnt) {
                                ++colSpanCnt;
                            }
                            if (colSpan == colSpanCnt) {
                                return null;
                            }
                        }
                    } else {
                        String errorDataStr = this.validateExcelInputData(colName, finalContent, metadataColLogNameTypeMap, dbColLogNameTypeMap, colLogNameSizeMap, dropDownColValueMap, colLogNamePrecisionMap);
                        if ((errorDataStr = this.checkNull(errorDataStr)).length() > 0) {
                            dataMap.put("INPUT_DATA_ERR", errorDataStr);
                            return dataMap;
                        }
                        if (finalContent != null && finalContent.length() > 0) {
                            finalContent = this.fieldCaseData(fieldCaseValueMap, colName, finalContent);
                        }
                        if ("line_no".equalsIgnoreCase(colName) || pkNameList.contains(colName)) {
                            finalContent = this.setCharFieldSpaces(dbColLogNameTypeMap, colLogNameSizeMap, colName, finalContent);
                        }
                        dataMap.put(colName, finalContent);
                    }
                }
                ++colNo;
            }
            if ((rowData = this.checkNull(rowData)).length() == 0) {
                return null;
            }
        }
        catch (ITMException e) {
            throw new ITMException(e);
        }
        return dataMap;
    }

    private String getExcelContent(Sheet sheet, int headingRowNo, int rowNo, String targetColName, ArrayList<Integer> matrixColList, String matrixColVal) throws ITMException {
        String contentData = "";
        try {
            int noOfColumns = sheet.getColumns();
            if (matrixColList != null) {
                if ("MatrixColumn".equalsIgnoreCase(targetColName)) {
                    contentData = matrixColVal;
                } else {
                    int i = 0;
                    while (i < noOfColumns) {
                        if (matrixColList != null && matrixColList.contains(i)) {
                            String colName = sheet.getCell(i, headingRowNo).getContents();
                            if ((colName = this.checkNull(colName).replaceAll(" ", "_")).equals(targetColName)) {
                                contentData = sheet.getCell(i, rowNo).getContents();
                            }
                        }
                        ++i;
                    }
                }
            } else {
                int i = 0;
                while (i < noOfColumns) {
                    String colName = sheet.getCell(i, headingRowNo).getContents();
                    if ((colName = this.checkNull(colName).replaceAll(" ", "_")).equals(targetColName)) {
                        contentData = sheet.getCell(i, rowNo).getContents();
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return contentData;
    }

    private String fieldCaseData(HashMap<String, String> fieldCaseValueMap, String colName, String dataContent) {
        String colCaseVal;
        String finalData = dataContent;
        if (fieldCaseValueMap != null && fieldCaseValueMap.get(colName) != null && (colCaseVal = fieldCaseValueMap.get(colName)).equalsIgnoreCase("upper")) {
            finalData = dataContent.toUpperCase();
        }
        return finalData;
    }
}

