/*
 * Decompiled with CFR 0.152.
 */
package ibase.system.config;

import ibase.system.config.ConnectionMonitor;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.InfinispanLocal;
import ibase.webitm.utility.ITMException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class WriteToLog {
    static InfinispanLocal infinispanLocalObj = null;
    static Hashtable jndiProperties = null;
    static InitialContext ctx = null;

    static {
        try {
            if (CommonConstants.CACHE_OPT != 0) {
                jndiProperties = new Hashtable();
                jndiProperties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
                ctx = new InitialContext(jndiProperties);
                infinispanLocalObj = (InfinispanLocal)ctx.lookup("ibase/InfinispanEJB/local");
                BaseLogger.log("3", null, null, "WriteToLog infinispanLocalObj created.....");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in WriteToLog static block:[" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    public void writeLog() {
        StringBuffer connMonitorDetails = new StringBuffer();
        try {
            if (CommonConstants.CACHE_OPT != 0 && infinispanLocalObj != null) {
                Set<String> setMap = infinispanLocalObj.getConnInfoKeySet();
                Iterator<String> iteratorMap = setMap.iterator();
                connMonitorDetails.append("<root>");
                while (iteratorMap.hasNext()) {
                    String key = iteratorMap.next();
                    if (infinispanLocalObj.getConnInfo(key) != null) {
                        ConnectionMonitor monitor = infinispanLocalObj.getConnInfo(key);
                        BaseLogger.log("3", null, null, " In IF ConnectionId :: ( " + key + ", " + monitor + " )");
                        connMonitorDetails.append(monitor.toString());
                        continue;
                    }
                    BaseLogger.log("3", null, null, " In Else Key :: ( " + key + ", Value::" + infinispanLocalObj.getConnInfo(key) + " )");
                }
                connMonitorDetails.append("</root>");
                String filepath = CommonConstants.EXT_LOG;
                if (!"".equals(filepath)) {
                    File mkd = new File(filepath);
                    if (!mkd.exists()) {
                        mkd.mkdirs();
                    }
                    mkd = null;
                    WriteToLog.writeToFile(filepath, "test", connMonitorDetails.toString());
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : writeLog():" + e.getMessage() + ":");
            e.printStackTrace();
        }
    }

    public static void writeToFile(String folderName, String fileName, String content) throws Exception {
        BaseLogger.log("2", null, null, "In writeToFile ");
        BaseLogger.log("2", null, null, "FolderName::::" + folderName);
        BaseLogger.log("2", null, null, "FileName::::" + fileName);
        BaseLogger.log("2", null, null, "Content::::::" + content);
        BufferedWriter bw = null;
        OutputStreamWriter fw = null;
        try {
            try {
                String prefix = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
                String filePath = String.valueOf(folderName) + File.separator + fileName + ".xml";
                String xmlString = String.valueOf(prefix) + content;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(new InputSource(new StringReader(xmlString)));
                TransformerFactory tranFactory = TransformerFactory.newInstance();
                Transformer aTransformer = tranFactory.newTransformer();
                DOMSource src = new DOMSource(document);
                StreamResult dest = new StreamResult(new File(filePath));
                aTransformer.transform(src, dest);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void writeLogforStatementStatus(String msg) {
        OutputStreamWriter fw = null;
        try {
            try {
                BaseLogger.log("3", null, null, "Message::::" + msg);
                String filepath = CommonConstants.STATEMENT_LOG_PATH;
                BaseLogger.log("3", null, null, "filepath::::.." + filepath);
                if (!"".equals(filepath)) {
                    File mkd = new File(filepath);
                    if (!mkd.exists()) {
                        mkd.createNewFile();
                    }
                    fw = new FileWriter(mkd.getAbsoluteFile(), true);
                    fw.write(msg);
                    fw.flush();
                    fw.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception : writeLogforStatus():" + e.getMessage() + ":");
                e.printStackTrace();
                try {
                    if (fw != null) {
                        fw.flush();
                    }
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (fw != null) {
                    fw.flush();
                }
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

