/**
Title : SFAPlanParamIC
Date  : 02/02/2017
Author: Samadhan Pawar
Request Id: W16JJOH003
*/
package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.w3c.dom.*;

import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.*;
import ibase.utility.E12GenericUtility;
//@javax.ejb.Stateless			commented by Sagar M [22 Nov 2018].

public class SFAPlanParamIC extends ValidatorEJB implements SFAPlanParamICRemote,SFAPlanParamICLocal//implements SessionBean
{
	E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

    public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println(xmlString);
		Document dom = null;
		Document dom2 = null;
		Document dom1 = null;
		String  errString = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
			System.out.println("ErrString :" + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception :SFAPlanParamIC :wfValData(String xmlString): " + e.getMessage() + ":") ;
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning from SFAPlanParamIC wfValData");
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String sql = "",userId = "",prdCode="",planUpto="",paramTable="";
		String errString = "";
		Connection conn = null;
		PreparedStatement pstmt =null;
		ResultSet rs = null;
		int currentFormNo = 0;
		int count = 0;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			conn = getConnection();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
				case 1:
				prdCode = genericUtility.checkNull(genericUtility.getColumnValue("prd_code", dom));
				planUpto = genericUtility.checkNull(genericUtility.getColumnValue("plan_upto", dom));
				paramTable = genericUtility.checkNull(genericUtility.getColumnValue("param_table", dom));
				System.out.println(" prdCode [" + prdCode + "] planUpto [" + planUpto + "] paramTable [" + paramTable + "]");

				if ( prdCode == null || prdCode.length() == 0 )
				{
					System.out.println("<<===========  prd_code Blank ========>> ");
					errString = getErrorString("prd_code", "NULPRDCODE", "");
					return errString;
				}
				else
				{
					sql = "SELECT COUNT(*) FROM PERIOD WHERE CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, prdCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						count = rs.getInt(1);
					}

					if(count == 0)
					{
						System.out.println("<<===========  prd_code Invalid ========>> ");
						errString = getErrorString("prd_code", "INVPRDCOD", "");
						return errString;
					}
					pstmt.close();
					rs.close();
				}

				if ( planUpto == null || planUpto.length() == 0 )
				{
					System.out.println("<<===========  plan_upto Blank ========>> ");
					errString = getErrorString("prd_code", "NULUPTDATE", "");
					return errString;
				}
				else
				{
					java.util.Date dateUpto = genericUtility.getDateObject(planUpto);
					Timestamp timeUpTo = new Timestamp(dateUpto.getTime());
					/*// added by rupali on 04/08/17 for applying validation on submit date [start]
					SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());

					if ( (  getDateObject( sdfFormat.format( new Date() ) ) .compareTo(dateUpto) ) > 0 )
					{
						errString = getErrorString("prd_code", "PASTDATE", "");
						break;
					}
					// added by rupali on 04/08/17 for applying validation on submit date [end]
*/					sql = "SELECT COUNT(*) FROM PERIOD WHERE CODE = ? AND TO_DATE > = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, prdCode);
					pstmt.setTimestamp(2, timeUpTo);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						count = rs.getInt(1);
					}
					if(count == 0)
					{
						System.out.println("<<===========  plan_upto Invalid ========>> ");
						errString = getErrorString("prd_code", "INVUPTDATE", "");
						return errString;
					}
					pstmt.close();
					rs.close();
				}

				if(editFlag.equalsIgnoreCase("A"))
				{
					sql = "SELECT COUNT(*) FROM SF_PLAN_PARAM WHERE PARAM_TABLE = ? AND PRD_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, paramTable);
					pstmt.setString(2, prdCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						count = rs.getInt(1);
					}
					if(count > 0)
					{
						System.out.println("<<===========  Primary key already exist ========>> ");
						errString = getErrorString("prd_code", "INVPLNAEXT", "");
						return errString;
					}
					pstmt.close();
					rs.close();
				}

				if(errString != null && errString.trim().length()> 0)
				{
					break;
				}
				break;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :SFAPlanParamIC :wfValData(Document dom):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		return errString;
	}

	public String itemChanged() throws RemoteException,ITMException
	{
		return "";
	}
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			System.out.println("xmlString:"+xmlString);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception :SFAPlanParamIC :itemChanged(String,String,String,String,String,String):" + e.getMessage() + ":");
			valueXmlString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		System.out.println("returning from SFAPlanParamIC itemChanged");
		return (valueXmlString);
	}

	public String itemChanged(Document currDom, Document hdrDom, Document allDom, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		int n;
		Connection conn = null;
		PreparedStatement pstmt =null;
		ResultSet rs = null;
		String chgUser = "";
		String chgTerm = "";
		String paramTable = "";
		String periodCode = "",planUpto = "",empCode = "" ;
		String userId = "";//added by shraddha M [24/08/2020]
		Timestamp dateFrom = null;
		Timestamp dateTo= null;
		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{

			conn = getConnection();
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			System.out.println("itemchanged dom....");
			System.out.println("current form no: " + currentFormNo);
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");//added by shraddha M [24/08/2020]
			switch (currentFormNo)
			{
				case 1:
					System.out.println("Case1");
					valueXmlString.append( "<Detail1>\r\n" );
					if(currentColumn.trim()!=null)
					{
						if ( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
						{
							System.out.println("--------------item default --------------");

							if(editFlag.equalsIgnoreCase("A"))
							{
								String sql = "SELECT PROP_VALUE,DESCR,ITEM_SER FROM PROPERTIES WHERE PROP_NAME = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, "PARAM_TABLE");
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									paramTable = genericUtility.checkNull(rs.getString("PROP_VALUE"));
								}
								valueXmlString.append( "<chg_user><![CDATA[" ).append( chgUser ).append( "]]></chg_user>\r\n" );
								valueXmlString.append( "<chg_term><![CDATA[" ).append( chgTerm ).append( "]]></chg_term>\r\n" );
								valueXmlString.append( "<param_table><![CDATA[" ).append( paramTable ).append( "]]></param_table>\r\n" );
								if(rs!=null)
								{
									rs.close();
									rs=null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt=null;
								}
							}
						}
						if ( currentColumn.trim().equalsIgnoreCase( "prd_code" ))
						{
							String itemSerSql="";
							String itemSer="";
							
							System.out.println("--------------item prd_code --------------");
							periodCode = genericUtility.checkNull(genericUtility.getColumnValue("prd_code", currDom));

							if(periodCode.length() == 0 && periodCode.equalsIgnoreCase(""))
							{
								//return getErrorString("prd_code", "NULPRDCODE", "");
							}
							//added by shraddha M [24/08/2020]START
							itemSerSql= "SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS= ?";
							pstmt = conn.prepareStatement(itemSerSql);
							pstmt.setString(1, userId);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								itemSer = genericUtility.checkNull(rs.getString("ITEM_SER"));
								System.out.println("itemSer value:::["+itemSer+"]");
							}
							pstmt.close();
							rs.close();
							//added by shraddha M [24/08/2020]END
							String sql = "SELECT EMP_CODE FROM EMPLOYEE WHERE EMP_CODE IN (SELECT S.EMP_CODE FROM SALES_PERS S , PROPERTIES P WHERE P.ITEM_SER = S.ITEM_SER AND P.PROP_NAME = ?) AND HOL_TBLNO IS NOT NULL ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "PARAM_TABLE");
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								empCode = genericUtility.checkNull(rs.getString("EMP_CODE"));
							}
							pstmt.close();
							rs.close();

							String prdCodeSql = "SELECT FR_DATE,TO_DATE FROM PERIOD WHERE CODE = ?";
							pstmt = conn.prepareStatement( prdCodeSql );
							pstmt.setString(1, periodCode );
							rs = pstmt.executeQuery();
							if ( rs.next() )
							{
								dateFrom = rs.getTimestamp("FR_DATE");
								dateTo = rs.getTimestamp("TO_DATE");

								int diffInDays = (int)( (dateTo.getTime() - dateFrom.getTime()) / (1000 * 60 * 60 * 24) )	;
								//int workingDays = ( (diffInDays+1) - getHolidayCount(conn, empCode, dateFrom, dateTo) );
								//int workingDays = getWorkingDays(conn, dateFrom, dateTo);
								System.out.println("Getting getWorkingDays itemser ..... ["+itemSer+"]");
								int workingDays = getWorkingDays(conn, dateFrom, dateTo,itemSer);//Changes by shraddha M to remove hardcoded itemser [24/08/2020]
								valueXmlString.append( "<work_days><![CDATA[" ).append( workingDays ).append( "]]></work_days>\r\n" );
							}
							else
							{
								//return getErrorString("prd_code", "INVPRDCOD", "");
							}
							//added By Nilesh Start::02-06-2017
							if(rs!=null)
							{
								rs.close();
								rs=null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt=null;
							}
							//added By Nilesh End::02-06-2017
						}
						if ( currentColumn.trim().equalsIgnoreCase( "plan_upto" ))
						{

						}
					}
					valueXmlString.append("</Detail1>\r\n");
				break;
			}
			valueXmlString.append("</Root>\r\n");
		}
		catch(Exception e)
		{
			System.out.println("Exception :SFAPlanParamIC :itemChanged(Document,String):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("\n****ValueXmlString :" + valueXmlString + ":********");
		return valueXmlString.toString();
	}

		private java.util.ArrayList getHolidayList( Connection conn, String employeeCode,String periodCode, java.sql.Timestamp dateFrom, java.sql.Timestamp uptoDate ) throws ITMException
		{
			System.out.println("Getting Holidays Information ..... ");

			java.sql.PreparedStatement pstmtHolday = null;
			java.sql.ResultSet rsetHolday = null;
			E12GenericUtility genericUtility = new E12GenericUtility();

			java.util.ArrayList holidayArray = new java.util.ArrayList();
			java.util.Calendar currCalender = java.util.Calendar.getInstance();
			java.util.Calendar upToCalender = java.util.Calendar.getInstance();

			try
			{
				String formatWorkDate = "";
				String holidayDate = "";

				java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat( genericUtility.getApplDateFormat() );
				currCalender.setTimeInMillis( dateFrom.getTime() );
				upToCalender.setTimeInMillis( uptoDate.getTime() );

				upToCalender.add(upToCalender.DATE, 1);
				for (int count = 0; currCalender.before(upToCalender); count++ )
				{
					//System.out.println("currCalender:"+currCalender);
					//System.out.println("upToCalender:"+upToCalender);
					currCalender.setTimeInMillis( currCalender.getTimeInMillis() );
					formatWorkDate = sdf.format( currCalender.getTime() );
					java.sql.Timestamp  workDate = java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(formatWorkDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()));

					String getHolidaySQL = "SELECT DDF_GET_EMP_HOLIDAY( ?, ?, ?, ? )AS HOL_DATE FROM DUAL";
					pstmtHolday = conn.prepareStatement( getHolidaySQL );
					pstmtHolday.setString(1, employeeCode );
					pstmtHolday.setString(2, periodCode );
					pstmtHolday.setString(3, periodCode );
					pstmtHolday.setTimestamp(4, workDate );

					rsetHolday = pstmtHolday.executeQuery();

					if( rsetHolday.next() )
					{
						holidayDate = genericUtility.checkNull( rsetHolday.getString("HOL_DATE") );
						if( holidayDate.trim().length() > 0 )
						{
							holidayArray.add( genericUtility.getValidDateString(holidayDate, "dd-MMM-yyyy", genericUtility.getApplDateFormat()).toUpperCase() ) ;
						}
					}
					currCalender.add( currCalender.DATE,1 );
				}
				System.out.println("getHolidayList == holidayArray ==> ["+holidayArray+"]");
			}
			catch ( Exception eHolday )
			{
				System.out.println("ExpenseProcessEJB : getHolidayList => ");
				eHolday.printStackTrace();
				throw new ITMException(eHolday);
			}
			finally
			{
				try
				{
					if(pstmtHolday != null)
					{
						pstmtHolday.close();
					}
					if (rsetHolday !=null )
					{
						rsetHolday.close();
					}
				}
				catch(Exception closeRsc )
				{
					closeRsc.printStackTrace();
					throw new ITMException(closeRsc);
				}
			}
			return holidayArray;
		}

		public int getHolidayCount( Connection conn, String employeeCode, java.sql.Timestamp dateFrom, java.sql.Timestamp uptoDate ) throws ITMException
		{
			System.out.println("Getting Holidays Information ..... ");
			String sqlHolday;
			java.sql.PreparedStatement pstmtHolday = null;
			java.sql.ResultSet rsetHolday = null;
			int holidayCnt = 0;
			try
			{

				sqlHolday = "SELECT COUNT(*) FROM HOLIDAY WHERE HOL_TBLNO IN (SELECT HOL_TBLNO FROM EMPLOYEE WHERE EMP_CODE= ? ) AND HOL_DATE BETWEEN ? AND ? ";
				pstmtHolday = conn.prepareStatement( sqlHolday );
				pstmtHolday.setString(1, employeeCode );
				pstmtHolday.setTimestamp(2, dateFrom );
				pstmtHolday.setTimestamp(3, uptoDate );

				rsetHolday = pstmtHolday.executeQuery();

				if( rsetHolday.next() )
				{
					 holidayCnt = rsetHolday.getInt(1);
				}
				System.out.println("getHolidayCount == holidayCnt ==> ["+holidayCnt+"]");
			}
			catch ( Exception eHolday )
			{
				System.out.println("SFAPlanParamIC : getHolidayList => ");
				eHolday.printStackTrace();
				throw new ITMException(eHolday);
			}
			finally
			{
				try
				{
					if(pstmtHolday != null)
					{
						pstmtHolday.close();
					}
					if (rsetHolday != null )
					{
						rsetHolday.close();
					}
				}
				catch(Exception closeRsc )
				{
					closeRsc.printStackTrace();
					throw new ITMException(closeRsc);
				}
			}
			return holidayCnt;
		}


		//public int getWorkingDays( Connection conn, java.sql.Timestamp dateFrom, java.sql.Timestamp uptoDate) throws ITMException
		public int getWorkingDays( Connection conn, java.sql.Timestamp dateFrom, java.sql.Timestamp uptoDate, String itemSer ) throws ITMException //Changes by shraddha M to remove hardcoded itemser [24/08/2020]
		{
			System.out.println("Getting getWorkingDays Information ..... ["+itemSer+"]");
			String sqlHolday;
			java.sql.PreparedStatement pstmtHolday = null;
			java.sql.ResultSet rsetHolday = null;
			int workingCnt = 0;
			try
			{

				//sqlHolday = "SELECT COUNT(DT) FROM ((select dt from sfa_time where dt between ? and ?) minus	(select DISTINCT H.hol_date	FROM holiday H INNER JOIN EMPLOYEE E ON E.HOL_TBLNO=H.HOL_TBLNO	INNER JOIN SALES_PERS SP ON SP.SALES_PERS=E.EMP_CODE where H.hol_date between ? and ?	AND SP.ITEM_SER IN ('IPC','MNR')))A ";
				sqlHolday = "SELECT COUNT(DT) FROM ((select dt from sfa_time where dt between ? and ?) minus	(select DISTINCT H.hol_date	FROM holiday H INNER JOIN EMPLOYEE E ON E.HOL_TBLNO=H.HOL_TBLNO	INNER JOIN SALES_PERS SP ON SP.SALES_PERS=E.EMP_CODE where H.hol_date between ? and ?	AND SP.ITEM_SER = ?))A ";//Changes by shraddha M to remove hardcoded itemser [24/08/2020]
				pstmtHolday = conn.prepareStatement( sqlHolday );

				pstmtHolday.setTimestamp(1, dateFrom );
				pstmtHolday.setTimestamp(2, uptoDate );
				pstmtHolday.setTimestamp(3, dateFrom );
				pstmtHolday.setTimestamp(4, uptoDate );
				pstmtHolday.setString(5, itemSer);//added by shraddha M[24/08/2020]
				rsetHolday = pstmtHolday.executeQuery();

				if( rsetHolday.next() )
				{
					workingCnt = rsetHolday.getInt(1);
				}
				System.out.println("getWorkingDays == workingCnt ==> ["+workingCnt+"]");
			}
			catch ( Exception eHolday )
			{
				System.out.println("SFAPlanParamIC : getWorkingDays => ");
				eHolday.printStackTrace();
				throw new ITMException(eHolday);
			}
			finally
			{
				try
				{
					if(pstmtHolday != null)
					{
						pstmtHolday.close();
					}
					if (rsetHolday != null )
					{
						rsetHolday.close();
					}
				}
				catch(Exception closeRsc )
				{
					closeRsc.printStackTrace();
					throw new ITMException(closeRsc);
				}
			}
			return workingCnt;
		}

}

